/*:
 * @plugindesc Adds an intentional delay to image loading for testing purposes.
 * @target MZ
 * @param delayDuration
 * @text Delay Duration
 * @type number
 * @min 0
 * @desc The delay duration in milliseconds.
 * @default 2000
 * @help This plugin adds an intentional delay to image loading to test the wait condition.
 */

(() => {
    const pluginName = "DelayedImageLoadingPlugin";

    // Read plugin parameters
    const parameters = PluginManager.parameters(pluginName);
    const delayDuration = Number(parameters['delayDuration'] || 2000);
/*
    // Override Bitmap.prototype._onXhrLoad to add a delay
    const originalOnXhrLoad = Bitmap.prototype._onXhrLoad;
    Bitmap.prototype._onXhrLoad = function(xhr) {
        const bitmap = this;
        setTimeout(() => {
            originalOnXhrLoad.call(bitmap, xhr);
        }, delayDuration);
        
        console.log(`Delaying image load for ${delayDuration} ms: ${this._url}`);
    };
*/
    // Override Bitmap.prototype._onLoad to add a delay
    const originalOnLoad = Bitmap.prototype._onLoad;
    Bitmap.prototype._onLoad = function() {
        const bitmap = this;
        setTimeout(() => {
            originalOnLoad.call(bitmap);
        }, delayDuration);
        
        console.log(`Delaying image load for ${delayDuration} ms: ${this._url}`);
    };
})();
