//=============================================================================
// VisuStella MZ - Bright Effects
// VisuMZ_2_BrightEffects.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_2_BrightEffects = true;

var VisuMZ = VisuMZ || {};
VisuMZ.BrightEffects = VisuMZ.BrightEffects || {};
VisuMZ.BrightEffects.version = 1.07;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 2] [Version 1.07] [BrightEffects]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Bright_Effects_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 * 
 * This RPG Maker MZ plugin allows you to add various bright effects to your
 * game's maps and battle system. These effects can make the game appear more
 * vivid, light, and gives you control over the color settings of a particular
 * map to make a more distinct feeling, too. The bright effects can be changed
 * midway through events in both maps and battles, too.
 *
 * Features include all (but not limited to) the following:
 * 
 * * A Bloom filter effect that can help soften the feel of a map by giving
 *   objects on the screen a slight hazy glow.
 * * Godrays can be used to show animated sunlight coming down from the sky
 *   above.
 * * The Color Adjustment filter allows you to alter the brightness, contrast,
 *   and saturation levels of your maps and battles.
 * * The Tilt Shift filter creates a blur at the top and bottom sections of the
 *   screen to give a sense of proximity blurring.
 * * Plugin Commands that allow you to adjust these settings on the go.
 * * Notetags for maps to alter the Bloom, Godray, and Color Adjustments
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Required Plugin List ------
 *
 * * Pixi JS Filters*
 *
 * This plugin requires the above listed plugins to be installed inside your
 * game's Plugin Manager list in order to work. You cannot start your game with
 * this plugin enabled without the listed plugins.
 * 
 * *Note* You can download the Pixi JS Filters plugin library from the below
 * URL or from the Action Sequence Impact product page. Install it as a
 * Tier 0 plugin.
 * 
 * *Note2* Pixi JS Filters perform differently on different machines/devices.
 * Please understand that this is outside of VisuStella's control.
 * 
 * URL: https://filters.pixijs.download/v3.1.0/pixi-filters.js
 *
 * ------ Tier 2 ------
 *
 * This plugin is a Tier 2 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * New Effects
 * ============================================================================
 *
 * This plugin adds some new hard-coded features to RPG Maker MZ's functions.
 * The following is a list of them.
 *
 * ---
 *
 * Bloom
 * 
 * This filter puts a faint (or large) glow around lighter-colored objects on
 * the map to give them a softer, hazy, brighter feeling.
 * 
 * Properties:
 *
 * Scale: To adjust the strength of the bloom. Higher values is more
 * intense brightness.
 *
 * Brightness: The brightness, lower value is more subtle brightness, higher
 * value is blown-out.
 *
 * Threshold: Defines how bright a color needs to be to affect bloom.
 *
 * ---
 * 
 * Blur
 * 
 * The blur filter makes the screen appear less focused and more fuzzy. Details
 * become harder to distinguish and the like.
 * 
 * Properties:
 * 
 * Blur: Adjusts the blur strength. For best results, use numbers between 0 and
 * 5 where 0 is no blur and higher numbers mean higher blur strength. There are
 * no default Plugin Parameter settings for the Blur strength as it will
 * automatically default to 0 for best results.
 * 
 * ---
 *
 * Godray
 * 
 * The Godray filter puts down rays of light coming from the sky at an angle.
 * This is often used to represent sunlight peaking from above the clouds.
 * 
 * Properties:
 *
 * Visible: If on, the godrays will be visible by default. If off, they won't.
 *
 * Speed: The speed at which the light flickers. Lower for slower rate.
 * Higher for faster speeds.
 *
 * Gain: General intensity of the effect.
 *
 * Lacunarity: The density of the fractal noise.
 *
 * Angle: The angle/light-source direction of the rays.
 *
 * ---
 *
 * Color Adjustment
 * 
 * The Color Adjustment filter allows you to control the colors on the screen
 * to be more/less bright, contrast more/less, and more/less saturated.
 * 
 * Properties:
 *
 * Brightness: Adjusts the overall brightness of the screen. Use lower numbers
 * to make it darker and higher numbers to increase the brightness.
 *
 * Contrast: Increases the separation between dark and bright. Darker colors
 * become darker. Lighter colors become lighter. Increase this number to make
 * the effect more intense or decrease it to lessen it.
 *
 * Saturate: Adjusts the intensity of color on the screen. User higher numbers
 * to make colors more intense and lower numbers to make it less.
 *
 * ---
 * 
 * Tilt Shift
 * 
 * The Tilt Shift filter creates a blur at the upper and lower edges of the
 * screen with varying degrees of pixelation blur and gradient blur.
 * 
 * Properties:
 * 
 * Pixel Blur: What is the default pixel blur amount for tilt shift? Smaller
 * values mean less blur. Higher values mean more blur.
 * 
 * Gradient Blur: What is the default gradient blur amount for tilt shift?
 * Smaller values mean less gradient. Higher values mean more gradient.
 * 
 * ---
 *
 * ============================================================================
 * Extra Features
 * ============================================================================
 *
 * There are some extra features found if other VisuStella MZ plugins are found
 * present in the Plugin Manager list.
 *
 * ---
 * 
 * VisuMZ_1_OptionsCore
 * 
 * As of the VisuStella MZ Options Core v1.10 update, both the Bright Effects
 * and Horror Effects plugins will be affected by the "Special Effects" option
 * found under the Options Core's General Settings. If the "Special Effects"
 * option is set to OFF, then the filter effects applied by those plugins will
 * also be disabled. They will be reenabled when the option is set back to ON.
 * 
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 *
 * ---
 * 
 * === Bloom-Related Notetags ===
 * 
 * ---
 *
 * <Bloom Scale: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Changes the bloom scale to x for map/battle.
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Less bloom
 *   - Higher - More bloom
 *
 * ---
 *
 * <Bloom Brightness: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Changes the bloom brightness to x for map/battle
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Darker
 *   - Higher - Brighter
 *
 * ---
 *
 * <Bloom Threshold: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Changes the bloom threshold to x for map/battle.
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Less picky
 *   - Higher - More picky
 *
 * ---
 *
 * <Bloom Horz Scale: x to y>
 * <Bloom Vert Scale: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Sets an adjusting scale when traveling left to right on the map
 *   (Horz) or up to down on the map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Less bloom
 *   - Higher - More bloom
 *
 * ---
 *
 * <Bloom Horz Brightness: x to y>
 * <Bloom Vert Brightness: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Sets an adjusting brightness when traveling left to right on the
 *   map (Horz) or up to down on the map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Darker
 *   - Higher - Brighter
 *
 * ---
 *
 * <Bloom Horz Threshold: x to y>
 * <Bloom Vert Threshold: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Sets an adjusting threshold when traveling left to right on the
 *   map (Horz) or up to down on the map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Less picky
 *   - Higher - More picky
 *
 * ---
 * 
 * === Blur-Related Notetags ===
 * 
 * ---
 * 
 * <Blur: x>
 * 
 * - Used for: Map Notetags and Troop Names
 * - Changes the blur strength used for the screen to 'x'.
 * - Replace 'x' with a number representing the blur strength. For best
 *   results, use numbers between 0 and 5 where 0 is no blur and higher numbers
 *   mean higher blur strength.
 * 
 * ---
 * 
 * === Godray-Related Notetags ===
 * 
 * ---
 *
 * <Godray>
 * <No Godray>
 *
 * - Used for: Map Notetags and Troop Names
 * - Changes if there will be a godray on the map/battle regardless of the
 *   default settings in the plugin parameters.
 *
 * ---
 *
 * <Godray Speed: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Sets the flickering speed of the rays.
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Slower
 *   - Higher - Faster
 *
 * ---
 *
 * <Godray Gain: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Sets the gain/intensity of the rays.
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Lighter
 *   - Higher - Intense
 *
 * ---
 *
 * <Godray Lacunarity: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Sets the lacunarity/density of the rays.
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Less dense
 *   - Higher - More dense
 *
 * ---
 *
 * <Godray Angle: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Sets the angle of the rays.
 * - Replace 'x' with a number to represent the value. Use a negative or
 *   positive integer value.
 *   - Negative - Coming from the left
 *   - Positive - Coming from the right
 *
 * ---
 *
 * <Godray Horz Speed: x to y>
 * <Godray Vert Speed: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Adjusts godray speed going left to right on a map (Horz) or up
 *   to down on a map (Vert). 
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Slower
 *   - Higher - Faster
 *
 * ---
 *
 * <Godray Horz Gain: x to y>
 * <Godray Vert Gain: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Adjusts godray gain going left to right on a map (Horz) or up to
 *   down on a map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Lighter
 *   - Higher - Intense
 *
 * ---
 *
 * <Godray Horz Lacunarity: x to y>
 * <Godray Vert Lacunarity: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Adjusts godray lacunarity going left to right on a map (Horz) or
 *   up to down on a map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Less dense
 *   - Higher - More dense
 *
 * ---
 *
 * <Godray Horz Angle: x to y>
 * <Godray Vert Angle: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Adjusts godray angle going left to right on a map (Horz) or up
 *   to down on a map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use a negative or
 *   positive integer values.
 *   - Negative - Coming from the left
 *   - Positive - Coming from the right
 *
 * ---
 * 
 * === Color Adjust-Related Notetags ===
 * 
 * ---
 *
 * <Color Adjust Brightness: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Alters the screen brightness for the map/battle.
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Darker
 *   - Higher - Brighter
 *
 * ---
 *
 * <Color Adjust Contrast: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Adjusts the screen contrast for the map/battle.
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Less contrast
 *   - Higher - More contrast
 *
 * ---
 *
 * <Color Adjust Saturate: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Adjusts the screen saturation for the map/battle.
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Darker
 *   - Higher - Brighter
 *
 * ---
 *
 * <Color Adjust Horz Brightness: x to y>
 * <Color Adjust Vert Brightness: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Alters the screen brightness when moving left to right on a map
 *   (Horz) or up to down on a map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Darker
 *   - Higher - Brighter
 *
 * ---
 *
 * <Color Adjust Horz Contrast: x to y>
 * <Color Adjust Vert Contrast: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Adjusts the screen contrast when moving left to right on a map
 *   (Horz) or up to down on a map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Less contrast
 *   - Higher - More contrast
 *
 * ---
 *
 * <Color Adjust Horz Saturate: x to y>
 * <Color Adjust Vert Saturate: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Adjusts the screen saturation when moving left to right on a map
 *   (Horz) or up to down on a map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Less intensity
 *   - Higher - More intensity
 *
 * ---
 * 
 * === Tilt Shift Notetags ===
 * 
 * ---
 * 
 * <Tilt Shift Pixel Blur: x>
 * 
 * - Used for: Map Notetags and Troop Names
 * - Adjusts the tilt shift filter's pixel blur amount for the map/battle.
 * - Replace 'x' with a number to represent the blur intensity.
 *   - Lower = less blur
 *   - Higher = more blur
 * 
 * ---
 * 
 * <Tilt Shift Gradient Blur: x>
 * 
 * - Used for: Map Notetags and Troop Names
 * - Adjusts the tilt shift filter's gradient blur amount for the map/battle.
 * - Replace 'x' with a number to represent the gradient blur distance.
 *   - Lower = less gradient
 *   - Higher = more gradient
 * 
 * ---
 *
 * ============================================================================
 * Plugin Commands
 * ============================================================================
 *
 * The following are Plugin Commands that come with this plugin. They can be
 * accessed through the Plugin Command event command.
 *
 * ---
 * 
 * === Bloom Plugin Commands ===
 * 
 * ---
 *
 * Bloom: Change Settings
 * - Change the Bloom filter settings for the screen.
 *
 *   Bloom Scale:
 *   - Change bloom scale for the screen.
 *
 *   Bloom Brightness:
 *   - Change bloom brightness for the screen.
 *
 *   Bloom Threshold:
 *   - Change bloom threshold for the screen.
 *
 *   Shift Duration:
 *   - The amount of time it takes for the change to occur.
 *
 * ---
 *
 * Bloom: Reset
 * - Reset the Bloom filter settings for the settings found in the Plugin
 *   Parameters or map notetags.
 *
 *   Shift Duration:
 *   - The amount of time it takes for the reset to occur.
 *
 * ---
 * 
 * === Blur Plugin Commands ===
 * 
 * ---
 * 
 * Blur: Change Settings
 * - Change the Blur filter settings for the screen.
 * 
 *   Blur Strength:
 *   - Change blur strength for the screen.
 *   - For best results, use numbers between 0 and 5  where 0 is no blur and
 *     higher numbers mean higher blur strength.
 * 
 *   Blur Duration:
 *   - The amount of time it takes for the change to occur.
 * 
 * ---
 * 
 * Blur: Reset
 * - Clears the Blur filter.
 * 
 *   Blur Duration:
 *   - The amount of time it takes for the reset to occur.
 * 
 * ---
 * 
 * === Godray Plugin Commands ===
 * 
 * ---
 *
 * Godray: Change Settings
 * - Change the Godray filter settings for the screen.
 *
 *   Visible?:
 *   - Show godrays on the screen?
 *   - Visibility changes are immediate.
 *
 *   Godray Speed:
 *   - Change godray speed for the screen.
 *
 *   Godray Gain:
 *   - Change godray gain for the screen.
 *
 *   Godray Lacunarity:
 *   - Change godray lacunarity for the screen.
 *
 *   Godray Angle:
 *   - Change godray angle for the screen.
 *
 *   Shift Duration:
 *   - The amount of time it takes for the change to occur.
 *   - Visibility changes are immediate.
 *
 * ---
 *
 * Godray: Reset
 * - Reset the Godray filter settings for the settings found in the Plugin
 *   Parameters or map notetags.
 *
 *   Shift Duration:
 *   - The amount of time it takes for the reset to occur.
 *   - Visibility changes are immediate.
 *
 * ---
 * 
 * === Color Adjust Plugin Commands ===
 * 
 * ---
 *
 * Color Adjust: Change Settings
 * - Change the Color Adjustment filter settings for the screen.
 *
 *   Adjust Brightness:
 *   - Change color adjust brightness for the screen.
 *
 *   Adjust Contrast:
 *   - Change color adjust contrast for the screen.
 *
 *   Adjust Saturation:
 *   - Change color adjust saturation for the screen.
 *
 *   Shift Duration:
 *   - The amount of time it takes for the change to occur.
 *
 * ---
 *
 * Color Adjust: Reset
 * - Reset the Color Adjustment filter settings for the settings found in the
 *   Plugin Parameters or map notetags.
 *
 *   Shift Duration:
 *   - The amount of time it takes for the reset to occur.
 *
 * ---
 * 
 * === Tilt Shift Plugin Commands ===
 * 
 * ---
 * 
 * Tilt Shift: Change Settings
 * - Change the Tilt Shift filter settings for the screen.
 * 
 *   Pixel Blur:
 *   - What is the default pixel blur amount for tilt shift?
 *   - Smaller = less blur. Higher = more blur.
 * 
 *   Gradient Blur:
 *   - What is the default gradient blur amount for tilt shift?
 *   - Smaller = less gradient. Higher = more gradient.
 * 
 *   Shift Duration:
 *   - The amount of time it takes for the change to occur.
 * 
 * ---
 * 
 * Tilt Shift: Reset
 * - Reset the Tilt Shift filter settings for the settings found in the
 *   Plugin Parameters or map notetags.
 * 
 *   Shift Duration:
 *   - The amount of time it takes for the change to occur.
 * 
 * ---
 * 
 * ============================================================================
 * Plugin Parameters: General Settings
 * ============================================================================
 * 
 * This section is for the general plugin parameter settings.
 * 
 * ---
 * 
 * General
 * 
 *   Apply Base-Only?
 *   - Base-Only excludes pictures, timers, and weather.
 *   - Whole includes the above.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Bloom Settings
 * ============================================================================
 *
 * There are two versions of these plugin parameters. One of them are for the
 * Map Defaults and the other is for the Battle Defaults. These settings are
 * applied to the map and battle scenes respectively and will serve as the
 * stock setting when no map notetags, troop name tags, or Plugin Commands have
 * been used to alter them.
 *
 * ---
 *
 * Bloom Settings
 * 
 *   Bloom Scale:
 *   - Default bloom scale for the screen unless changed through tags.
 * 
 *   Bloom Brightness:
 *   - Default bloom brightness for the screen unless changed through tags.
 * 
 *   Bloom Threshold:
 *   - Default bloom threshold for the screen unless changed through tags.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Godray Settings
 * ============================================================================
 *
 * There are two versions of these plugin parameters. One of them are for the
 * Map Defaults and the other is for the Battle Defaults. These settings are
 * applied to the map and battle scenes respectively and will serve as the
 * stock setting when no map notetags, troop name tags, or Plugin Commands have
 * been used to alter them.
 *
 * ---
 *
 * Godray Settings
 * 
 *   Default Visible?:
 *   - Show godrays on all screens by default unless changed through tags?
 * 
 *   Godray Speed:
 *   - Default godray speed for all screens unless changed through tags.
 * 
 *   Godray Gain:
 *   - Default godray gain for all screens unless changed through tags.
 * 
 *   Godray Lacunarity:
 *   - Default godray lacunarity for all screens unless changed through tags.
 * 
 *   Godray Angle:
 *   - Default godray angle for all screens unless changed through tags.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Color Adjust Settings
 * ============================================================================
 *
 * There are two versions of these plugin parameters. One of them are for the
 * Map Defaults and the other is for the Battle Defaults. These settings are
 * applied to the map and battle scenes respectively and will serve as the
 * stock setting when no map notetags, troop name tags, or Plugin Commands have
 * been used to alter them.
 *
 * ---
 *
 * Color Adjust Settings
 * 
 *   Adjust Brightness:
 *   - Default color adjust brightness for all screens unless changed
 *     through tags.
 * 
 *   Adjust Contrast:
 *   - Default color adjust contrast for all screens unless changed
 *     through tags.
 * 
 *   Adjust Saturation:
 *   - Default color adjust saturation for all screens unless changed
 *     through tags.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Tilt Shift Settings
 * ============================================================================
 *
 * There are two versions of these plugin parameters. One of them are for the
 * Map Defaults and the other is for the Battle Defaults. These settings are
 * applied to the map and battle scenes respectively and will serve as the
 * stock setting when no map notetags, troop name tags, or Plugin Commands have
 * been used to alter them.
 *
 * ---
 *
 * Tilt Shift Settings
 * 
 *   Pixel Blur:
 *   - What is the default pixel blur amount for tilt shift?
 *   - Smaller = less blur. Higher = more blur.
 * 
 *   Gradient Blur:
 *   - What is the default gradient blur amount for tilt shift?
 *   - Smaller = less gradient. Higher = more gradient.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 * 
 * 7. If this VisuStella MZ plugin is a paid product, all project team members
 * must purchase their own individual copies of the paid product if they are to
 * use it. Usage includes working on related game mechanics, managing related
 * code, and/or using related Plugin Commands and features. Redistribution of
 * the plugin and/or its code to other members of the team is NOT allowed
 * unless they own the plugin itself as that conflicts with Article 4.
 * 
 * 8. Any extensions and/or addendums made to this plugin's Terms of Use can be
 * found on VisuStella.com and must be followed.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.07: March 16, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New features added by Olivia and sponsored by Archeia:
 * *** Blur
 * **** The blur filter makes the screen appear less focused and more fuzzy.
 *      Details become harder to distinguish and the like.
 * **** Notetags and Plugin Commands added.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.06: October 13, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New features added by Olivia and sponsored by Archeia:
 * *** Tilt Shift
 * **** The Tilt Shift filter creates a blur at the upper and lower edges of
 *      the screen with varying degrees of pixelation blur and gradient blur.
 * **** Plugin Parameters, Notetags, and Plugin Commands added.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.05: April 28, 2022
 * * Bug Fixes!
 * ** No longer crashes with event test play. Fix made by Olivia.
 * 
 * Version 1.04: March 24, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features:
 * ** New Plugin Parameters added: "Apply Base-Only?"
 * *** Base-Only excludes pictures, timers, and weather.
 * *** Whole includes the above.
 * 
 * Version 1.03: April 2, 2021
 * * Bug Fixes!
 * ** Changing scenes while a filter change is in transition will automatically
 *    load up the changes made to the filter to prevent desynchronization.
 *    Fix made by Olivia.
 * 
 * Version 1.02: March 12, 2021
 * * Compatibility Update!
 * ** Added compatibility with the VisuStella MZ Options Core v1.10 update.
 * *** When the "Special Effects" option is set to OFF, the filters for this
 *     plugin will be shut off. They will be returned to normal when set to ON.
 * * Documentation Update!
 * ** Added the Options Core section to the "Extra Features" list.
 * 
 * Version 1.01: December 25, 2020
 * * Bug Fixes!
 * ** Bright effects from battle should no longer carry back over into the
 *    map scene. Fix made by Yanfly.
 *
 * Version 1.00: January 18, 2021
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Begin
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command BloomChange
 * @text Bloom: Change Settings
 * @desc Change the Bloom filter settings for the screen.
 *
 * @arg Scale:num
 * @text Bloom Scale
 * @desc Change bloom scale for the screen.
 * @default 0.5
 *
 * @arg Brightness:num
 * @text Bloom Brightness
 * @desc Change bloom brightness for the screen.
 * @default 1.0
 *
 * @arg Threshold:num
 * @text Bloom Threshold
 * @desc Change bloom threshold for the screen.
 * @default 0.5
 *
 * @arg Duration:num
 * @text Shift Duration
 * @type number
 * @desc The amount of time it takes for the change to occur.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command BloomReset
 * @text Bloom: Reset
 * @desc Reset the Bloom filter settings for the settings found in
 * the Plugin Parameters or map notetags.
 *
 * @arg Duration:num
 * @text Shift Duration
 * @type number
 * @desc The amount of time it takes for the reset to occur.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Blur
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command BlurChange
 * @text Blur: Change Settings
 * @desc Change the Blur filter settings for the screen.
 *
 * @arg Blur:num
 * @text Blur Strength
 * @desc Change blur strength for the screen.
 * For best results, use numbers between 0 and 5.
 * @default 2.0
 *
 * @arg Duration:num
 * @text Blur Duration
 * @type number
 * @desc The amount of time it takes for the change to occur.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command BlurReset
 * @text Bloom: Reset
 * @desc Clears the Blur filter.
 *
 * @arg Duration:num
 * @text Blur Duration
 * @type number
 * @desc The amount of time it takes for the reset to occur.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Godray
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command GodrayChange
 * @text Godray: Change Settings
 * @desc Change the Godray filter settings for the screen.
 *
 * @arg Visible:eval
 * @text Visible?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show godrays on the screen?
 * Visibility changes are immediate.
 * @default true
 *
 * @arg Speed:num
 * @text Godray Speed
 * @desc Change godray speed for the screen.
 * @default 0.01
 *
 * @arg Gain:num
 * @text Godray Gain
 * @desc Change godray gain for the screen.
 * @default 0.6
 *
 * @arg Lacunarity:num
 * @text Godray Lacunarity
 * @desc Change godray lacunarity for the screen.
 * @default 2.0
 *
 * @arg Angle:num
 * @text Godray Angle
 * @desc Change godray angle for the screen.
 * @default -30
 *
 * @arg Duration:num
 * @text Shift Duration
 * @type number
 * @desc The amount of time it takes for the change to occur.
 * Visibility changes are immediate.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command GodrayReset
 * @text Godray: Reset
 * @desc Reset the Godray filter settings for the settings
 * found in the Plugin Parameters or map notetags.
 *
 * @arg Duration:num
 * @text Shift Duration
 * @type number
 * @desc The amount of time it takes for the reset to occur.
 * Visibility changes are immediate.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_ColorAdjust
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ColorAdjustChange
 * @text Color Adjust: Change Settings
 * @desc Change the Color Adjustment filter settings for the screen.
 *
 * @arg Brightness:num
 * @text Adjust Brightness
 * @desc Change color adjust brightness for the screen.
 * @default 1.0
 *
 * @arg Contrast:num
 * @text Adjust Contrast
 * @desc Change color adjust contrast for the screen.
 * @default 0.0
 *
 * @arg Saturate:num
 * @text Adjust Saturation
 * @desc Change color adjust saturation for the screen.
 * @default 0.0
 *
 * @arg Duration:num
 * @text Shift Duration
 * @type number
 * @desc The amount of time it takes for the change to occur.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ColorAdjustReset
 * @text Color Adjust: Reset
 * @desc Reset the Color Adjustment filter settings for the settings
 * found in the Plugin Parameters or map notetags.
 *
 * @arg Duration:num
 * @text Shift Duration
 * @type number
 * @desc The amount of time it takes for the reset to occur.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_TiltShift
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command TiltShiftChange
 * @text Tilt Shift: Change Settings
 * @desc Change the Tilt Shift filter settings for the screen.
 *
 * @arg Blur:num
 * @text Pixel Blur
 * @desc What is the default pixel blur amount for tilt shift?
 * Smaller = less blur. Higher = more blur.
 * @default 24
 *
 * @arg GradientBlur:num
 * @text Gradient Blur
 * @desc What is the default gradient blur amount for tilt shift?
 * Smaller = less gradient. Higher = more gradient.
 * @default 1000
 *
 * @arg Duration:num
 * @text Shift Duration
 * @type number
 * @desc The amount of time it takes for the change to occur.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command TiltShiftReset
 * @text Tilt Shift: Reset
 * @desc Reset the Tilt Shift filter settings for the settings
 * found in the Plugin Parameters or map notetags.
 *
 * @arg Duration:num
 * @text Shift Duration
 * @type number
 * @desc The amount of time it takes for the reset to occur.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_End
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BrightEffects
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 * 
 * @param Map
 * @text Map Defaults
 *
 * @param MapBaseFilter:eval
 * @text Apply Base-Only?
 * @parent Map
 * @type boolean
 * @on Base-Only
 * @off Apply Whole
 * @desc Base-Only excludes pictures, timers, and weather.
 * Whole includes the above.
 * @default true
 *
 * @param MapBloom:struct
 * @text Bloom Settings
 * @parent Map
 * @type struct<Bloom>
 * @desc Default bloom settings for all maps.
 * @default {"Scale:num":"0.5","Brightness:num":"1.0","Threshold:num":"0.5"}
 *
 * @param MapGodray:struct
 * @text Godray Settings
 * @parent Map
 * @type struct<Godray>
 * @desc Default Godray settings for all maps.
 * @default {"Visible:eval":"false","Speed:num":"0.01","Gain:num":"0.6","Lacunarity:num":"2.0","Angle:num":"-30"}
 *
 * @param MapColorAdjust:struct
 * @text Color Adjust Settings
 * @parent Map
 * @type struct<ColorAdjust>
 * @desc Default color adjustment settings for all maps.
 * @default {"Brightness:num":"1.0","Contrast:num":"0.0","Saturate:num":"0.0"}
 *
 * @param MapTiltShift:struct
 * @text Tilt Shift Settings
 * @parent Map
 * @type struct<TiltShift>
 * @desc Default tilt shift adjustment settings for all maps.
 * @default {"Blur:num":"24","GradientBlur:num":"1000"}
 * 
 * @param Battle
 * @text Battle Defaults
 *
 * @param BattleBaseFilter:eval
 * @text Apply Base-Only?
 * @parent Battle
 * @type boolean
 * @on Base-Only
 * @off Apply Whole
 * @desc Base-Only excludes pictures, timers, and weather.
 * Whole includes the above.
 * @default true
 *
 * @param BattleBloom:struct
 * @text Bloom Settings
 * @parent Battle
 * @type struct<Bloom>
 * @desc Default bloom settings for all battles.
 * @default {"Scale:num":"0.5","Brightness:num":"1.0","Threshold:num":"0.5"}
 *
 * @param BattleGodray:struct
 * @text Godray Settings
 * @parent Battle
 * @type struct<Godray>
 * @desc Default Godray settings for all battles.
 * @default {"Visible:eval":"false","Speed:num":"0.01","Gain:num":"0.6","Lacunarity:num":"2.0","Angle:num":"-30"}
 *
 * @param BattleColorAdjust:struct
 * @text Color Adjust Settings
 * @parent Battle
 * @type struct<ColorAdjust>
 * @desc Default color adjustment settings for all battles.
 * @default {"Brightness:num":"1.0","Contrast:num":"0.0","Saturate:num":"0.0"}
 *
 * @param BattleTiltShift:struct
 * @text Tilt Shift Settings
 * @parent Battle
 * @type struct<TiltShift>
 * @desc Default tilt shift adjustment settings for all battles.
 * @default {"Blur:num":"0","GradientBlur:num":"1600"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Bloom Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Bloom:
 *
 * @param Scale:num
 * @text Bloom Scale
 * @desc Default bloom scale for the screen unless changed through tags.
 * @default 0.5
 *
 * @param Brightness:num
 * @text Bloom Brightness
 * @desc Default bloom brightness for the screen unless changed through tags.
 * @default 1.0
 *
 * @param Threshold:num
 * @text Bloom Threshold
 * @desc Default bloom threshold for the screen unless changed through tags.
 * @default 0.5
 *
 */
/* ----------------------------------------------------------------------------
 * Godray Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Godray:
 *
 * @param Visible:eval
 * @text Default Visible?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show godrays on all screens by default unless changed through tags?
 * @default false
 *
 * @param Speed:num
 * @text Godray Speed
 * @desc Default godray speed for all screens unless changed through tags.
 * @default 0.01
 *
 * @param Gain:num
 * @text Godray Gain
 * @desc Default godray gain for all screens unless changed through tags.
 * @default 0.6
 *
 * @param Lacunarity:num
 * @text Godray Lacunarity
 * @desc Default godray lacunarity for all screens unless changed through tags.
 * @default 2.0
 *
 * @param Angle:num
 * @text Godray Angle
 * @desc Default godray angle for all screens unless changed through tags.
 * @default -30
 *
 */
/* ----------------------------------------------------------------------------
 * Color Adjust Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ColorAdjust:
 *
 * @param Brightness:num
 * @text Adjust Brightness
 * @desc Default color adjust brightness for all screens unless changed through tags.
 * @default 1.0
 *
 * @param Contrast:num
 * @text Adjust Contrast
 * @desc Default color adjust contrast for all screens unless changed through tags.
 * @default 0.0
 *
 * @param Saturate:num
 * @text Adjust Saturation
 * @desc Default color adjust saturation for all screens unless changed through tags.
 * @default 0.0
 *
 */
/* ----------------------------------------------------------------------------
 * Tilt Shift Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~TiltShift:
 *
 * @param Blur:num
 * @text Pixel Blur
 * @desc What is the default pixel blur amount for tilt shift?
 * Smaller = less blur. Higher = more blur.
 * @default 24
 *
 * @param GradientBlur:num
 * @text Gradient Blur
 * @desc What is the default gradient blur amount for tilt shift?
 * Smaller = less gradient. Higher = more gradient.
 * @default 1000
 *
 */
//=============================================================================

function _0x24b4(){var _0x3c9585=['ARRAYSTRUCT','BattleGodray','toUpperCase','setBrightEffectsGodraySettings','map','min','filters','_brightEffectsGodrayHorzSpeed','MapBloom','parse','_baseSprite','shiftY','Angle','updateMapBrightEffects','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','Spriteset_Base_createOverallFilters','MapColorAdjust','Contrast','exit','createBrightEffectsAdvBloomFilter','setupBrightEffectsAdvBloomFilter','_brightEffectsColorAdjustVertSaturate','ARRAYNUM','updateBrightEffectsBlurFilter','_brightEffectsColorAdjustHorzContrast','BattleBloom','findTargetSprite','version','ARRAYFUNC','getBrightEffectsColorAdjustSettings','GodrayFilter','1837232ldxnpE','bloomScale','visible','setBrightEffectsAdvBloomSettings','789969tMIMLR','_brightEffectsBloomVertThreshold','BRIGHT_EFFECTS_BASE_ONLY','190187wRkfLR','_BrightEffectsGodrayFilter','locate','Game_Map_setup','_BrightEffectsGodraySettingsBattle','setupBrightEffectsTiltShiftFilter','updateBrightEffectsTiltShiftFilter','Lacunarity','updateBrightEffectsAdvBloomFilter','_scene','_brightEffectsGodrayVertGain','MapGodray','setupBrightEffectsGodrayFilter','parameters','currentGradientBlur','threshold','_realX','_brightEffectsColorAdjustVertBrightness','contrast','createOverallFilters','_realY','Threshold','brightness','_brightEffectsGodrayHorzLacunarity','update','time','updateMapBrightEffectsGodray','_brightEffectsColorAdjustVertContrast','ColorAdjustChange','currentPixelBlur','_BrightEffectsBlurSettingsBattle','match','updateBrightEffectsGodrayFilter','_BrightEffectsGodraySettingsMap','351444QdvFoX','_BrightEffectsTiltShiftSettingsMap','_BrightEffectsTiltShiftSettingsBattle','width','_BrightEffectsColorAdjustSettingsMap','gradientBlur','currentBrightness','getBrightEffectsAdvBloomSettings','Brightness','screenY','createBrightEffectsGodrayFilter','gain','troop','_brightEffectsBloomVertScale','2zzUMvH','ColorMatrixFilter','setupBrightEffectsFilters','Blur','21RtDtss','_BrightEffectsTiltShiftFilter','format','setMapEnhanceTiltShiftFilterY','updateMapBrightEffectsColorAdjust','_brightEffectsBloomHorzBrightness','_brightEffectsBloomVertBrightness','end','Saturate','isSceneMap','_BrightEffectsBlurFilter','_brightEffectsGodrayVertSpeed','setup','updateMapBrightEffectsAdvBloom','Settings','BrightEffects','updateBrightEffectsColorAdjustFilter','MapBaseFilter','currentSaturate','isSceneBattle','VisuMZ_3_MapCameraZoom','Spriteset_Base_update','_brightEffectsBloomHorzThreshold','getBrightEffectsTiltShiftSettings','start','createBrightEffectsTiltShiftFilter','createBrightEffectsFilters','note','GradientBlur','_BrightEffectsAdvBloomSettingsBattle','lacunarity','Game_CharacterBase_locate','BloomReset','filter','speed','_brightEffectsColorAdjustHorzBrightness','setBrightEffectsColorAdjustSettings','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','ARRAYSTR','height','JSON','BlurFilter','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','BlurChange','updateBrightEffectsTiltShiftFilterProperties','BattleColorAdjust','1065jtqsQK','MapTiltShift','max','getBrightEffectsGodraySettings','TiltShiftReset','blur','596ofLEQw','createBrightEffectsColorAdjustFilter','setBrightEffectsBlurSettings','angle','_brightEffectsGodrayHorzGain','Speed','enabled','_brightEffectsGodrayHorzAngle','brightEffectsBaseOnly','Scene_Battle_start','ColorAdjustReset','_BrightEffectsBlurSettingsMap','getMapEnhanceScreenY','Visible','tileFocus','2832775KblhBp','Duration','setupBrightEffectsBlurFilter','setupBrightEffectsColorAdjustFilter','_brightEffectsGodrayVertAngle','_BrightEffectsColorAdjustSettingsBattle','saturate','mapCameraSettings','specialEffects','getBrightEffectsBlurSettings','zoomScale','ARRAYJSON','duration','mapCameraFocusTarget','currentContrast','pixelBlur','806301lqlwYR','updateBrightEffectsFilters','_BrightEffectsColorAdjustFilter','constructor','ConvertParams','tileHeight','BloomChange','call','push','currentBlur','TiltShiftFilter','name','STRUCT','20kUahnc','_brightEffectsBloomHorzScale','Gain','Scale','NUM','return\x200','description','registerCommand','_brightEffectsColorAdjustHorzSaturate','prototype','GodrayReset','_BrightEffectsAdvBloomSettingsMap','GodrayChange','_brightEffectsGodrayVertLacunarity','setBrightEffectsTiltShiftSettings','_BrightEffectsAdvBloomFilter'];_0x24b4=function(){return _0x3c9585;};return _0x24b4();}function _0x59a0(_0x1c1589,_0xe4fe70){var _0x24b41c=_0x24b4();return _0x59a0=function(_0x59a090,_0x3389d8){_0x59a090=_0x59a090-0x161;var _0x530d57=_0x24b41c[_0x59a090];return _0x530d57;},_0x59a0(_0x1c1589,_0xe4fe70);}var _0x57837c=_0x59a0;(function(_0x32849e,_0x5c2943){var _0x59b6f0=_0x59a0,_0x12945a=_0x32849e();while(!![]){try{var _0x182b1e=-parseInt(_0x59b6f0(0x1cd))/0x1*(-parseInt(_0x59b6f0(0x1fd))/0x2)+-parseInt(_0x59b6f0(0x1ca))/0x3+parseInt(_0x59b6f0(0x16b))/0x4*(parseInt(_0x59b6f0(0x165))/0x5)+parseInt(_0x59b6f0(0x1ef))/0x6*(-parseInt(_0x59b6f0(0x201))/0x7)+-parseInt(_0x59b6f0(0x1c6))/0x8+parseInt(_0x59b6f0(0x18a))/0x9+-parseInt(_0x59b6f0(0x197))/0xa*(-parseInt(_0x59b6f0(0x17a))/0xb);if(_0x182b1e===_0x5c2943)break;else _0x12945a['push'](_0x12945a['shift']());}catch(_0x4c809e){_0x12945a['push'](_0x12945a['shift']());}}}(_0x24b4,0x268a8));var label=_0x57837c(0x210),tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x57837c(0x222)](function(_0x24cd8d){var _0x3dcc66=_0x57837c;return _0x24cd8d['status']&&_0x24cd8d[_0x3dcc66(0x19d)]['includes']('['+label+']');})[0x0];VisuMZ[label]['Settings']=VisuMZ[label][_0x57837c(0x20f)]||{},VisuMZ[_0x57837c(0x18e)]=function(_0x1ac016,_0xd77bee){var _0x3f88c1=_0x57837c;for(const _0x4a2d17 in _0xd77bee){if(_0x4a2d17['match'](/(.*):(.*)/i)){const _0x574e69=String(RegExp['$1']),_0x3d9670=String(RegExp['$2'])[_0x3f88c1(0x1a9)]()['trim']();let _0x2d8058,_0x435f21,_0x383e48;switch(_0x3d9670){case _0x3f88c1(0x19b):_0x2d8058=_0xd77bee[_0x4a2d17]!==''?Number(_0xd77bee[_0x4a2d17]):0x0;break;case _0x3f88c1(0x1bd):_0x435f21=_0xd77bee[_0x4a2d17]!==''?JSON[_0x3f88c1(0x1b0)](_0xd77bee[_0x4a2d17]):[],_0x2d8058=_0x435f21[_0x3f88c1(0x1ab)](_0x236522=>Number(_0x236522));break;case'EVAL':_0x2d8058=_0xd77bee[_0x4a2d17]!==''?eval(_0xd77bee[_0x4a2d17]):null;break;case'ARRAYEVAL':_0x435f21=_0xd77bee[_0x4a2d17]!==''?JSON[_0x3f88c1(0x1b0)](_0xd77bee[_0x4a2d17]):[],_0x2d8058=_0x435f21[_0x3f88c1(0x1ab)](_0x77e559=>eval(_0x77e559));break;case _0x3f88c1(0x229):_0x2d8058=_0xd77bee[_0x4a2d17]!==''?JSON[_0x3f88c1(0x1b0)](_0xd77bee[_0x4a2d17]):'';break;case _0x3f88c1(0x185):_0x435f21=_0xd77bee[_0x4a2d17]!==''?JSON[_0x3f88c1(0x1b0)](_0xd77bee[_0x4a2d17]):[],_0x2d8058=_0x435f21[_0x3f88c1(0x1ab)](_0x3bd8e7=>JSON['parse'](_0x3bd8e7));break;case'FUNC':_0x2d8058=_0xd77bee[_0x4a2d17]!==''?new Function(JSON[_0x3f88c1(0x1b0)](_0xd77bee[_0x4a2d17])):new Function(_0x3f88c1(0x19c));break;case _0x3f88c1(0x1c3):_0x435f21=_0xd77bee[_0x4a2d17]!==''?JSON[_0x3f88c1(0x1b0)](_0xd77bee[_0x4a2d17]):[],_0x2d8058=_0x435f21[_0x3f88c1(0x1ab)](_0x5f1f40=>new Function(JSON[_0x3f88c1(0x1b0)](_0x5f1f40)));break;case'STR':_0x2d8058=_0xd77bee[_0x4a2d17]!==''?String(_0xd77bee[_0x4a2d17]):'';break;case _0x3f88c1(0x227):_0x435f21=_0xd77bee[_0x4a2d17]!==''?JSON['parse'](_0xd77bee[_0x4a2d17]):[],_0x2d8058=_0x435f21['map'](_0x1b0251=>String(_0x1b0251));break;case _0x3f88c1(0x196):_0x383e48=_0xd77bee[_0x4a2d17]!==''?JSON['parse'](_0xd77bee[_0x4a2d17]):{},_0x2d8058=VisuMZ[_0x3f88c1(0x18e)]({},_0x383e48);break;case _0x3f88c1(0x1a7):_0x435f21=_0xd77bee[_0x4a2d17]!==''?JSON[_0x3f88c1(0x1b0)](_0xd77bee[_0x4a2d17]):[],_0x2d8058=_0x435f21['map'](_0x3ba119=>VisuMZ[_0x3f88c1(0x18e)]({},JSON[_0x3f88c1(0x1b0)](_0x3ba119)));break;default:continue;}_0x1ac016[_0x574e69]=_0x2d8058;}}return _0x1ac016;},(_0x5791ca=>{var _0x200ba0=_0x57837c;const _0x2569a7=_0x5791ca[_0x200ba0(0x195)];for(const _0x44b8cd of dependencies){if(!Imported[_0x44b8cd]){alert(_0x200ba0(0x161)[_0x200ba0(0x203)](_0x2569a7,_0x44b8cd)),SceneManager['exit']();break;}}const _0x24d710=_0x5791ca['description'];if(_0x24d710[_0x200ba0(0x1ec)](/\[Version[ ](.*?)\]/i)){const _0x59873c=Number(RegExp['$1']);_0x59873c!==VisuMZ[label][_0x200ba0(0x1c2)]&&(alert(_0x200ba0(0x226)[_0x200ba0(0x203)](_0x2569a7,_0x59873c)),SceneManager[_0x200ba0(0x1b9)]());}if(_0x24d710[_0x200ba0(0x1ec)](/\[Tier[ ](\d+)\]/i)){const _0x601cfc=Number(RegExp['$1']);_0x601cfc<tier?(alert(_0x200ba0(0x1b5)[_0x200ba0(0x203)](_0x2569a7,_0x601cfc,tier)),SceneManager[_0x200ba0(0x1b9)]()):tier=Math[_0x200ba0(0x167)](_0x601cfc,tier);}VisuMZ['ConvertParams'](VisuMZ[label][_0x200ba0(0x20f)],_0x5791ca[_0x200ba0(0x1da)]);})(pluginData),PluginManager[_0x57837c(0x19e)](pluginData[_0x57837c(0x195)],_0x57837c(0x190),_0x5db04d=>{var _0xd1cdde=_0x57837c;VisuMZ['ConvertParams'](_0x5db04d,_0x5db04d);const _0x2462c7=$gameScreen[_0xd1cdde(0x1f6)]();_0x2462c7[_0xd1cdde(0x1c7)]=_0x5db04d[_0xd1cdde(0x19a)],_0x2462c7[_0xd1cdde(0x1e3)]=_0x5db04d['Brightness'],_0x2462c7[_0xd1cdde(0x1dc)]=_0x5db04d[_0xd1cdde(0x1e2)],_0x2462c7[_0xd1cdde(0x186)]=_0x5db04d[_0xd1cdde(0x17b)],!SceneManager['isSceneBattle']()&&($gameMap['_brightEffectsBloomHorzBrightness']=undefined,$gameMap[_0xd1cdde(0x207)]=undefined);}),PluginManager[_0x57837c(0x19e)](pluginData[_0x57837c(0x195)],_0x57837c(0x221),_0x9d813e=>{var _0x464148=_0x57837c;VisuMZ['ConvertParams'](_0x9d813e,_0x9d813e);SceneManager[_0x464148(0x214)]()?$gameTroop[_0x464148(0x1bb)]():$gameMap[_0x464148(0x1bb)]();const _0xf90aaa=$gameScreen['getBrightEffectsAdvBloomSettings']();_0xf90aaa['duration']=_0x9d813e[_0x464148(0x17b)];}),PluginManager[_0x57837c(0x19e)](pluginData[_0x57837c(0x195)],_0x57837c(0x162),_0x4bf9f7=>{var _0x2c1a10=_0x57837c;VisuMZ[_0x2c1a10(0x18e)](_0x4bf9f7,_0x4bf9f7);const _0x48aff8=$gameScreen['getBrightEffectsBlurSettings']();_0x48aff8[_0x2c1a10(0x16a)]=_0x4bf9f7[_0x2c1a10(0x200)],_0x48aff8[_0x2c1a10(0x186)]=_0x4bf9f7[_0x2c1a10(0x17b)];}),PluginManager[_0x57837c(0x19e)](pluginData['name'],'BlurReset',_0x46f4d4=>{var _0x1299cc=_0x57837c;VisuMZ[_0x1299cc(0x18e)](_0x46f4d4,_0x46f4d4);SceneManager[_0x1299cc(0x214)]()?$gameTroop[_0x1299cc(0x17c)]():$gameMap['setupBrightEffectsBlurFilter']();const _0x4f27bd=$gameScreen['getBrightEffectsBlurSettings']();_0x4f27bd[_0x1299cc(0x186)]=_0x46f4d4[_0x1299cc(0x17b)];}),PluginManager[_0x57837c(0x19e)](pluginData[_0x57837c(0x195)],_0x57837c(0x1a3),_0x5136e9=>{var _0x5d83ab=_0x57837c;VisuMZ[_0x5d83ab(0x18e)](_0x5136e9,_0x5136e9);const _0x43afc9=$gameScreen[_0x5d83ab(0x168)]();_0x43afc9['visible']=_0x5136e9[_0x5d83ab(0x178)],_0x43afc9[_0x5d83ab(0x223)]=_0x5136e9[_0x5d83ab(0x170)],_0x43afc9[_0x5d83ab(0x1fa)]=_0x5136e9[_0x5d83ab(0x199)],_0x43afc9[_0x5d83ab(0x21f)]=_0x5136e9[_0x5d83ab(0x1d4)],_0x43afc9[_0x5d83ab(0x16e)]=_0x5136e9[_0x5d83ab(0x1b3)],_0x43afc9[_0x5d83ab(0x186)]=_0x5136e9[_0x5d83ab(0x17b)],!SceneManager[_0x5d83ab(0x214)]()&&($gameMap['_brightEffectsGodrayHorzSpeed']=undefined,$gameMap[_0x5d83ab(0x20c)]=undefined);}),PluginManager['registerCommand'](pluginData[_0x57837c(0x195)],_0x57837c(0x1a1),_0x401926=>{var _0x25dfcd=_0x57837c;VisuMZ[_0x25dfcd(0x18e)](_0x401926,_0x401926);SceneManager[_0x25dfcd(0x214)]()?$gameTroop['setupBrightEffectsGodrayFilter']():$gameMap[_0x25dfcd(0x1d9)]();const _0x1d9eaa=$gameScreen[_0x25dfcd(0x168)]();_0x1d9eaa['duration']=_0x401926['Duration'];}),PluginManager['registerCommand'](pluginData[_0x57837c(0x195)],_0x57837c(0x1e9),_0x4aa67d=>{var _0x3bc0f2=_0x57837c;VisuMZ['ConvertParams'](_0x4aa67d,_0x4aa67d);const _0x1d0d28=$gameScreen[_0x3bc0f2(0x1c4)]();_0x1d0d28[_0x3bc0f2(0x1e3)]=_0x4aa67d[_0x3bc0f2(0x1f7)],_0x1d0d28[_0x3bc0f2(0x1df)]=_0x4aa67d[_0x3bc0f2(0x1b8)],_0x1d0d28['saturate']=_0x4aa67d[_0x3bc0f2(0x209)],_0x1d0d28[_0x3bc0f2(0x186)]=_0x4aa67d['Duration'],!SceneManager[_0x3bc0f2(0x214)]()&&($gameMap[_0x3bc0f2(0x19f)]=undefined,$gameMap[_0x3bc0f2(0x1bc)]=undefined);}),PluginManager[_0x57837c(0x19e)](pluginData[_0x57837c(0x195)],_0x57837c(0x175),_0x56ce0a=>{var _0x48598a=_0x57837c;VisuMZ['ConvertParams'](_0x56ce0a,_0x56ce0a);SceneManager['isSceneBattle']()?$gameTroop[_0x48598a(0x17d)]():$gameMap[_0x48598a(0x17d)]();const _0x45a353=$gameScreen['getBrightEffectsColorAdjustSettings']();_0x45a353[_0x48598a(0x186)]=_0x56ce0a['Duration'];}),PluginManager[_0x57837c(0x19e)](pluginData[_0x57837c(0x195)],'TiltShiftChange',_0xb446e8=>{var _0x4a9279=_0x57837c;VisuMZ[_0x4a9279(0x18e)](_0xb446e8,_0xb446e8);const _0x3e3323=$gameScreen[_0x4a9279(0x218)]();_0x3e3323[_0x4a9279(0x189)]=_0xb446e8[_0x4a9279(0x200)],_0x3e3323[_0x4a9279(0x1f4)]=_0xb446e8[_0x4a9279(0x21d)],_0x3e3323[_0x4a9279(0x186)]=_0xb446e8[_0x4a9279(0x17b)];}),PluginManager['registerCommand'](pluginData['name'],_0x57837c(0x169),_0x3103b2=>{var _0x50a884=_0x57837c;VisuMZ[_0x50a884(0x18e)](_0x3103b2,_0x3103b2);SceneManager[_0x50a884(0x214)]()?$gameTroop[_0x50a884(0x1d2)]():$gameMap[_0x50a884(0x1d2)]();const _0x56a997=$gameScreen[_0x50a884(0x218)]();_0x56a997[_0x50a884(0x186)]=_0x3103b2[_0x50a884(0x17b)];}),SceneManager[_0x57837c(0x214)]=function(){var _0x1d0c61=_0x57837c;return this[_0x1d0c61(0x1d6)]&&this[_0x1d0c61(0x1d6)][_0x1d0c61(0x18d)]===Scene_Battle;},SceneManager[_0x57837c(0x20a)]=function(){var _0x4c7356=_0x57837c;return this['_scene']&&this['_scene'][_0x4c7356(0x18d)]===Scene_Map;},Game_Screen[_0x57837c(0x1a0)][_0x57837c(0x1c9)]=function(_0x4cae2c,_0x154b26,_0x17a1f3,_0x5136e5){var _0x11a57f=_0x57837c;SceneManager[_0x11a57f(0x214)]()?this['_BrightEffectsAdvBloomSettingsBattle']={'bloomScale':_0x4cae2c,'brightness':_0x154b26,'threshold':_0x17a1f3,'duration':_0x5136e5||0x0}:this[_0x11a57f(0x1a2)]={'bloomScale':_0x4cae2c,'brightness':_0x154b26,'threshold':_0x17a1f3,'duration':_0x5136e5||0x0};},Game_Screen[_0x57837c(0x1a0)][_0x57837c(0x1f6)]=function(){var _0x237c44=_0x57837c;return SceneManager['isSceneBattle']()?(this[_0x237c44(0x21e)]===undefined&&$gameTroop[_0x237c44(0x1bb)](),this[_0x237c44(0x21e)]):(this[_0x237c44(0x1a2)]===undefined&&$gameMap[_0x237c44(0x1bb)](),this[_0x237c44(0x1a2)]);},Game_Screen[_0x57837c(0x1a0)]['setBrightEffectsGodraySettings']=function(_0x13d1fc,_0xc3b896,_0x3aeb88,_0x3f402e,_0x26f71e,_0x518b26){var _0x100ae1=_0x57837c;SceneManager[_0x100ae1(0x214)]()?this[_0x100ae1(0x1d1)]={'visible':_0x13d1fc,'speed':_0xc3b896,'gain':_0x3aeb88,'lacunarity':_0x3f402e,'angle':_0x26f71e,'duration':_0x518b26||0x0}:this[_0x100ae1(0x1ee)]={'visible':_0x13d1fc,'speed':_0xc3b896,'gain':_0x3aeb88,'lacunarity':_0x3f402e,'angle':_0x26f71e,'duration':_0x518b26||0x0};},Game_Screen[_0x57837c(0x1a0)][_0x57837c(0x168)]=function(){var _0xf6932b=_0x57837c;return SceneManager[_0xf6932b(0x214)]()?(this[_0xf6932b(0x1d1)]===undefined&&$gameTroop[_0xf6932b(0x1d9)](),this['_BrightEffectsGodraySettingsBattle']):(this[_0xf6932b(0x1ee)]===undefined&&$gameMap[_0xf6932b(0x1d9)](),this[_0xf6932b(0x1ee)]);},Game_Screen[_0x57837c(0x1a0)][_0x57837c(0x225)]=function(_0x1e4202,_0x1e6605,_0x10f21e,_0x18419a){var _0xa2bd82=_0x57837c;SceneManager[_0xa2bd82(0x214)]()?this['_BrightEffectsColorAdjustSettingsBattle']={'brightness':_0x1e4202,'contrast':_0x1e6605,'saturate':_0x10f21e,'duration':_0x18419a||0x0}:this[_0xa2bd82(0x1f3)]={'brightness':_0x1e4202,'contrast':_0x1e6605,'saturate':_0x10f21e,'duration':_0x18419a||0x0};},Game_Screen[_0x57837c(0x1a0)][_0x57837c(0x1c4)]=function(){var _0xedcde1=_0x57837c;return SceneManager['isSceneBattle']()?(this[_0xedcde1(0x17f)]===undefined&&$gameTroop[_0xedcde1(0x17d)](),this[_0xedcde1(0x17f)]):(this[_0xedcde1(0x1f3)]===undefined&&$gameMap[_0xedcde1(0x17d)](),this[_0xedcde1(0x1f3)]);},Game_Screen[_0x57837c(0x1a0)][_0x57837c(0x1a5)]=function(_0xdc814a,_0xe76496,_0x5d2c40){var _0x2cde07=_0x57837c;SceneManager[_0x2cde07(0x214)]()?this[_0x2cde07(0x1f1)]={'pixelBlur':_0xdc814a,'gradientBlur':_0xe76496,'duration':_0x5d2c40||0x0}:this[_0x2cde07(0x1f0)]={'pixelBlur':_0xdc814a,'gradientBlur':_0xe76496,'duration':_0x5d2c40||0x0};},Game_Screen[_0x57837c(0x1a0)][_0x57837c(0x218)]=function(){var _0x44435c=_0x57837c;return SceneManager[_0x44435c(0x214)]()?(this['_BrightEffectsTiltShiftSettingsBattle']===undefined&&$gameTroop[_0x44435c(0x1d2)](),this[_0x44435c(0x1f1)]):(this[_0x44435c(0x1f0)]===undefined&&$gameMap[_0x44435c(0x1d2)](),this[_0x44435c(0x1f0)]);},Game_Screen[_0x57837c(0x1a0)][_0x57837c(0x16d)]=function(_0x1fd14f,_0x448491){var _0x442bcb=_0x57837c;SceneManager['isSceneBattle']()?this[_0x442bcb(0x1eb)]={'blur':_0x1fd14f||0x0,'duration':_0x448491||0x0}:this[_0x442bcb(0x176)]={'blur':_0x1fd14f||0x0,'duration':_0x448491||0x0};},Game_Screen[_0x57837c(0x1a0)][_0x57837c(0x183)]=function(){var _0x39a043=_0x57837c;return SceneManager['isSceneBattle']()?(this[_0x39a043(0x1eb)]===undefined&&$gameTroop['setupBrightEffectsBlurFilter'](),this['_BrightEffectsBlurSettingsBattle']):(this['_BrightEffectsBlurSettingsMap']===undefined&&$gameMap['setupBrightEffectsBlurFilter'](),this[_0x39a043(0x176)]);},VisuMZ[_0x57837c(0x210)]['Scene_Battle_start']=Scene_Battle[_0x57837c(0x1a0)][_0x57837c(0x219)],Scene_Battle[_0x57837c(0x1a0)]['start']=function(){var _0x51c437=_0x57837c;VisuMZ['BrightEffects'][_0x51c437(0x174)][_0x51c437(0x191)](this),$gameTroop[_0x51c437(0x1ff)]();},Game_Troop['prototype'][_0x57837c(0x1ff)]=function(){var _0x5ca90e=_0x57837c;this['setupBrightEffectsAdvBloomFilter'](),this[_0x5ca90e(0x1d9)](),this[_0x5ca90e(0x17d)](),this[_0x5ca90e(0x1d2)](),this[_0x5ca90e(0x17c)]();},Game_Troop[_0x57837c(0x1a0)][_0x57837c(0x1bb)]=function(){var _0x535d70=_0x57837c;const _0x4335a7=VisuMZ[_0x535d70(0x210)][_0x535d70(0x20f)][_0x535d70(0x1c0)];var _0x28cf44=_0x4335a7['Scale'],_0x200263=_0x4335a7[_0x535d70(0x1f7)],_0x73a997=_0x4335a7['Threshold'];if(!!this[_0x535d70(0x1fb)]()){var _0x47110c=this[_0x535d70(0x1fb)]()[_0x535d70(0x195)];if(_0x47110c[_0x535d70(0x1ec)](/<BLOOM SCALE: (.*)>/i))var _0x28cf44=Number(RegExp['$1'])||0x0;if(_0x47110c[_0x535d70(0x1ec)](/<BLOOM BRIGHTNESS: (.*)>/i))var _0x200263=Number(RegExp['$1'])||0x0;if(_0x47110c[_0x535d70(0x1ec)](/<BLOOM THRESHOLD: (.*)>/i))var _0x73a997=Number(RegExp['$1'])||0x0;}$gameScreen[_0x535d70(0x1c9)](_0x28cf44,_0x200263,_0x73a997,0x0);},Game_Troop['prototype']['setupBrightEffectsGodrayFilter']=function(){var _0x17c96c=_0x57837c;const _0x2692a3=VisuMZ[_0x17c96c(0x210)][_0x17c96c(0x20f)][_0x17c96c(0x1a8)];var _0x3b6274=_0x2692a3['Visible'],_0x31dad1=_0x2692a3['Speed'],_0x45f0c6=_0x2692a3[_0x17c96c(0x199)],_0x36648b=_0x2692a3[_0x17c96c(0x1d4)],_0x3f32ba=_0x2692a3[_0x17c96c(0x1b3)];if(!!this[_0x17c96c(0x1fb)]()){var _0x42f3f7=this[_0x17c96c(0x1fb)]()[_0x17c96c(0x195)];if(_0x42f3f7[_0x17c96c(0x1ec)](/<GODRAY>/i))_0x3b6274=!![];else _0x42f3f7['match'](/<NO GODRAY>/i)&&(_0x3b6274=![]);_0x42f3f7[_0x17c96c(0x1ec)](/<GODRAY SPEED: (.*)>/i)&&(_0x31dad1=Number(RegExp['$1'])||0x0),_0x42f3f7[_0x17c96c(0x1ec)](/<GODRAY GAIN: (.*)>/i)&&(_0x45f0c6=Number(RegExp['$1'])||0x0),_0x42f3f7[_0x17c96c(0x1ec)](/<GODRAY LACUNARITY: (.*)>/i)&&(_0x36648b=Number(RegExp['$1'])||0x0),_0x42f3f7[_0x17c96c(0x1ec)](/<GODRAY ANGLE: (.*)>/i)&&(_0x3f32ba=Number(RegExp['$1'])||0x0);}$gameScreen[_0x17c96c(0x1aa)](_0x3b6274,_0x31dad1,_0x45f0c6,_0x36648b,_0x3f32ba,0x0);},Game_Troop[_0x57837c(0x1a0)][_0x57837c(0x17d)]=function(){var _0xa8a7c5=_0x57837c;const _0x2baef2=VisuMZ[_0xa8a7c5(0x210)][_0xa8a7c5(0x20f)][_0xa8a7c5(0x164)];var _0x10ec30=_0x2baef2[_0xa8a7c5(0x1f7)],_0x593e76=_0x2baef2[_0xa8a7c5(0x1b8)],_0x3d28a0=_0x2baef2[_0xa8a7c5(0x209)];if(!!this[_0xa8a7c5(0x1fb)]()){var _0x5e0d86=this[_0xa8a7c5(0x1fb)]()[_0xa8a7c5(0x195)];if(_0x5e0d86[_0xa8a7c5(0x1ec)](/<COLOR ADJUST BRIGHTNESS: (.*)>/i))var _0x10ec30=Number(RegExp['$1'])||0x0;if(_0x5e0d86[_0xa8a7c5(0x1ec)](/<COLOR ADJUST CONTRAST: (.*)>/i))var _0x593e76=Number(RegExp['$1'])||0x0;if(_0x5e0d86[_0xa8a7c5(0x1ec)](/<COLOR ADJUST SATURATE: (.*)>/i))var _0x3d28a0=Number(RegExp['$1'])||0x0;}$gameScreen['setBrightEffectsColorAdjustSettings'](_0x10ec30,_0x593e76,_0x3d28a0,0x0);},Game_Troop[_0x57837c(0x1a0)]['setupBrightEffectsTiltShiftFilter']=function(){var _0x19c016=_0x57837c;const _0x50c11a=VisuMZ[_0x19c016(0x210)][_0x19c016(0x20f)]['BattleTiltShift'];let _0xcd22be=_0x50c11a[_0x19c016(0x200)],_0x188f6e=_0x50c11a[_0x19c016(0x21d)];if(!!this[_0x19c016(0x1fb)]()){const _0x284fed=this[_0x19c016(0x1fb)]()['name'];_0x284fed[_0x19c016(0x1ec)](/<(?:TILTSHIFT|TILT SHIFT) PIXEL BLUR:[ ](\d+)>/i)&&(_0xcd22be=Number(RegExp['$1'])),_0x284fed[_0x19c016(0x1ec)](/<(?:TILTSHIFT|TILT SHIFT) (?:GRAD|GRADIENT) BLUR:[ ](\d+)>/i)&&(_0x188f6e=Number(RegExp['$1']));}$gameScreen[_0x19c016(0x1a5)](_0xcd22be,_0x188f6e,0x0);},Game_Troop['prototype'][_0x57837c(0x17c)]=function(){var _0x117c0a=_0x57837c;let _0x57ff77=0x0;if(!!this[_0x117c0a(0x1fb)]()){const _0x4b29ba=this[_0x117c0a(0x1fb)]()['name'];_0x4b29ba['match'](/<BLUR:[ ](.*?)>/i)&&(_0x57ff77=Number(RegExp['$1']));}$gameScreen[_0x117c0a(0x16d)](_0x57ff77,0x0);},VisuMZ[_0x57837c(0x210)]['Game_Map_setup']=Game_Map[_0x57837c(0x1a0)]['setup'],Game_Map['prototype'][_0x57837c(0x20d)]=function(_0xe0c162){var _0x1a478c=_0x57837c;VisuMZ[_0x1a478c(0x210)][_0x1a478c(0x1d0)]['call'](this,_0xe0c162),!!$dataMap&&this[_0x1a478c(0x1ff)]();},Game_Map['prototype'][_0x57837c(0x1ff)]=function(){var _0x1fdb47=_0x57837c;this[_0x1fdb47(0x1bb)](),this[_0x1fdb47(0x1d9)](),this['setupBrightEffectsColorAdjustFilter'](),this['setupBrightEffectsTiltShiftFilter'](),$gamePlayer[_0x1fdb47(0x1b4)]();},Game_Map[_0x57837c(0x1a0)]['setupBrightEffectsAdvBloomFilter']=function(){var _0x25c4c3=_0x57837c;const _0x2ac3b7=VisuMZ['BrightEffects'][_0x25c4c3(0x20f)][_0x25c4c3(0x1af)];var _0x32a808=_0x2ac3b7['Scale'],_0x48c923=_0x2ac3b7[_0x25c4c3(0x1f7)],_0x9a6579=_0x2ac3b7[_0x25c4c3(0x1e2)];this[_0x25c4c3(0x198)]=undefined,this[_0x25c4c3(0x1fc)]=undefined,this[_0x25c4c3(0x206)]=undefined,this[_0x25c4c3(0x207)]=undefined,this[_0x25c4c3(0x217)]=undefined,this[_0x25c4c3(0x1cb)]=undefined;if($dataMap){var _0x5bdf32=$dataMap[_0x25c4c3(0x21c)]||'';if(_0x5bdf32[_0x25c4c3(0x1ec)](/<BLOOM SCALE: (.*)>/i))var _0x32a808=Number(RegExp['$1'])||0x0;if(_0x5bdf32[_0x25c4c3(0x1ec)](/<BLOOM BRIGHTNESS: (.*)>/i))var _0x48c923=Number(RegExp['$1'])||0x0;if(_0x5bdf32[_0x25c4c3(0x1ec)](/<BLOOM THRESHOLD: (.*)>/i))var _0x9a6579=Number(RegExp['$1'])||0x0;_0x5bdf32['match'](/<BLOOM (?:HORZ|HORIZONTAL) SCALE: (.*) TO (.*)>/i)&&(this['_brightEffectsBloomHorzScale']=[Number(RegExp['$1']),Number(RegExp['$2'])],this[_0x25c4c3(0x1fc)]=undefined),_0x5bdf32[_0x25c4c3(0x1ec)](/<BLOOM (?:VERT|VERTICAL) SCALE: (.*) TO (.*)>/i)&&(this[_0x25c4c3(0x198)]=undefined,this['_brightEffectsBloomVertScale']=[Number(RegExp['$1']),Number(RegExp['$2'])]),_0x5bdf32[_0x25c4c3(0x1ec)](/<BLOOM (?:HORZ|HORIZONTAL) BRIGHTNESS: (.*) TO (.*)>/i)&&(this['_brightEffectsBloomHorzBrightness']=[Number(RegExp['$1']),Number(RegExp['$2'])],this[_0x25c4c3(0x207)]=undefined),_0x5bdf32['match'](/<BLOOM (?:VERT|VERTICAL) BRIGHTNESS: (.*) TO (.*)>/i)&&(this[_0x25c4c3(0x206)]=undefined,this[_0x25c4c3(0x207)]=[Number(RegExp['$1']),Number(RegExp['$2'])]),_0x5bdf32[_0x25c4c3(0x1ec)](/<BLOOM (?:HORZ|HORIZONTAL) THRESHOLD: (.*) TO (.*)>/i)&&(this[_0x25c4c3(0x217)]=[Number(RegExp['$1']),Number(RegExp['$2'])],this[_0x25c4c3(0x1cb)]=undefined),_0x5bdf32[_0x25c4c3(0x1ec)](/<BLOOM (?:VERT|VERTICAL) THRESHOLD: (.*) TO (.*)>/i)&&(this['_brightEffectsBloomHorzThreshold']=undefined,this['_brightEffectsBloomVertThreshold']=[Number(RegExp['$1']),Number(RegExp['$2'])]);}$gameScreen[_0x25c4c3(0x1c9)](_0x32a808,_0x48c923,_0x9a6579,0x0);},Game_Map[_0x57837c(0x1a0)]['setupBrightEffectsGodrayFilter']=function(){var _0xfe8bda=_0x57837c;const _0x3cb4b2=VisuMZ['BrightEffects'][_0xfe8bda(0x20f)][_0xfe8bda(0x1d8)];var _0x20e3cc=_0x3cb4b2[_0xfe8bda(0x178)],_0x4b702e=_0x3cb4b2[_0xfe8bda(0x170)],_0x3702e9=_0x3cb4b2[_0xfe8bda(0x199)],_0x1b0b82=_0x3cb4b2[_0xfe8bda(0x1d4)],_0x238793=_0x3cb4b2[_0xfe8bda(0x1b3)];this[_0xfe8bda(0x1ae)]=undefined,this['_brightEffectsGodrayVertSpeed']=undefined,this[_0xfe8bda(0x16f)]=undefined,this[_0xfe8bda(0x1d7)]=undefined,this[_0xfe8bda(0x1e4)]=undefined,this[_0xfe8bda(0x1a4)]=undefined,this[_0xfe8bda(0x172)]=undefined,this['_brightEffectsGodrayVertAngle']=undefined;if($dataMap){var _0x1c372d=$dataMap[_0xfe8bda(0x21c)]||'';if(_0x1c372d[_0xfe8bda(0x1ec)](/<GODRAY>/i))_0x20e3cc=!![];else _0x1c372d['match'](/<NO GODRAY>/i)&&(_0x20e3cc=![]);_0x1c372d[_0xfe8bda(0x1ec)](/<GODRAY SPEED: (.*)>/i)&&(_0x4b702e=Number(RegExp['$1'])||0x0),_0x1c372d['match'](/<GODRAY GAIN: (.*)>/i)&&(_0x3702e9=Number(RegExp['$1'])||0x0),_0x1c372d[_0xfe8bda(0x1ec)](/<GODRAY LACUNARITY: (.*)>/i)&&(_0x1b0b82=Number(RegExp['$1'])||0x0),_0x1c372d[_0xfe8bda(0x1ec)](/<GODRAY ANGLE: (.*)>/i)&&(_0x238793=Number(RegExp['$1'])||0x0),_0x1c372d['match'](/<GODRAY (?:HORZ|HORIZONTAL) SPEED: (.*) TO (.*)>/i)&&(this['_brightEffectsGodrayHorzSpeed']=[Number(RegExp['$1']),Number(RegExp['$2'])],this[_0xfe8bda(0x20c)]=undefined),_0x1c372d['match'](/<GODRAY (?:VERT|VERTICAL) SPEED: (.*) TO (.*)>/i)&&(this[_0xfe8bda(0x1ae)]=undefined,this[_0xfe8bda(0x20c)]=[Number(RegExp['$1']),Number(RegExp['$2'])]),_0x1c372d['match'](/<GODRAY (?:HORZ|HORIZONTAL) GAIN: (.*) TO (.*)>/i)&&(this[_0xfe8bda(0x16f)]=[Number(RegExp['$1']),Number(RegExp['$2'])],this[_0xfe8bda(0x1d7)]=undefined),_0x1c372d[_0xfe8bda(0x1ec)](/<GODRAY (?:VERT|VERTICAL) GAIN: (.*) TO (.*)>/i)&&(this[_0xfe8bda(0x16f)]=undefined,this[_0xfe8bda(0x1d7)]=[Number(RegExp['$1']),Number(RegExp['$2'])]),_0x1c372d[_0xfe8bda(0x1ec)](/<GODRAY (?:HORZ|HORIZONTAL) LACUNARITY: (.*) TO (.*)>/i)&&(this[_0xfe8bda(0x1e4)]=[Number(RegExp['$1']),Number(RegExp['$2'])],this[_0xfe8bda(0x1a4)]=undefined),_0x1c372d[_0xfe8bda(0x1ec)](/<GODRAY (?:VERT|VERTICAL) LACUNARITY: (.*) TO (.*)>/i)&&(this['_brightEffectsGodrayHorzLacunarity']=undefined,this[_0xfe8bda(0x1a4)]=[Number(RegExp['$1']),Number(RegExp['$2'])]),_0x1c372d['match'](/<GODRAY (?:HORZ|HORIZONTAL) ANGLE: (.*) TO (.*)>/i)&&(this[_0xfe8bda(0x172)]=[Number(RegExp['$1']),Number(RegExp['$2'])],this[_0xfe8bda(0x17e)]=undefined),_0x1c372d[_0xfe8bda(0x1ec)](/<GODRAY (?:VERT|VERTICAL) ANGLE: (.*) TO (.*)>/i)&&(this[_0xfe8bda(0x172)]=undefined,this[_0xfe8bda(0x17e)]=[Number(RegExp['$1']),Number(RegExp['$2'])]);}$gameScreen['setBrightEffectsGodraySettings'](_0x20e3cc,_0x4b702e,_0x3702e9,_0x1b0b82,_0x238793,0x0);},Game_Map[_0x57837c(0x1a0)][_0x57837c(0x17d)]=function(){var _0x3dfa64=_0x57837c;const _0x222ac3=VisuMZ[_0x3dfa64(0x210)][_0x3dfa64(0x20f)][_0x3dfa64(0x1b7)];var _0x1f702b=_0x222ac3['Brightness'],_0x349080=_0x222ac3[_0x3dfa64(0x1b8)],_0x26a127=_0x222ac3[_0x3dfa64(0x209)];this[_0x3dfa64(0x224)]=undefined,this[_0x3dfa64(0x1de)]=undefined,this[_0x3dfa64(0x1bf)]=undefined,this[_0x3dfa64(0x1e8)]=undefined,this[_0x3dfa64(0x19f)]=undefined,this[_0x3dfa64(0x1bc)]=undefined;if($dataMap){var _0x4f3119=$dataMap[_0x3dfa64(0x21c)]||'';if(_0x4f3119[_0x3dfa64(0x1ec)](/<COLOR ADJUST BRIGHTNESS: (.*)>/i))var _0x1f702b=Number(RegExp['$1'])||0x0;if(_0x4f3119[_0x3dfa64(0x1ec)](/<COLOR ADJUST CONTRAST: (.*)>/i))var _0x349080=Number(RegExp['$1'])||0x0;if(_0x4f3119[_0x3dfa64(0x1ec)](/<COLOR ADJUST SATURATE: (.*)>/i))var _0x26a127=Number(RegExp['$1'])||0x0;_0x4f3119[_0x3dfa64(0x1ec)](/<COLOR ADJUST (?:HORZ|HORIZONTAL) BRIGHTNESS: (.*) TO (.*)>/i)&&(this[_0x3dfa64(0x224)]=[Number(RegExp['$1']),Number(RegExp['$2'])],this[_0x3dfa64(0x1de)]=undefined),_0x4f3119[_0x3dfa64(0x1ec)](/<COLOR ADJUST (?:VERT|VERTICAL) BRIGHTNESS: (.*) TO (.*)>/i)&&(this[_0x3dfa64(0x224)]=undefined,this[_0x3dfa64(0x1de)]=[Number(RegExp['$1']),Number(RegExp['$2'])]),_0x4f3119[_0x3dfa64(0x1ec)](/<COLOR ADJUST (?:HORZ|HORIZONTAL) CONTRAST: (.*) TO (.*)>/i)&&(this[_0x3dfa64(0x1bf)]=[Number(RegExp['$1']),Number(RegExp['$2'])],this[_0x3dfa64(0x1e8)]=undefined),_0x4f3119[_0x3dfa64(0x1ec)](/<COLOR ADJUST (?:VERT|VERTICAL) CONTRAST: (.*) TO (.*)>/i)&&(this[_0x3dfa64(0x1bf)]=undefined,this[_0x3dfa64(0x1e8)]=[Number(RegExp['$1']),Number(RegExp['$2'])]),_0x4f3119['match'](/<COLOR ADJUST (?:HORZ|HORIZONTAL) SATURATE: (.*) TO (.*)>/i)&&(this[_0x3dfa64(0x19f)]=[Number(RegExp['$1']),Number(RegExp['$2'])],this['_brightEffectsColorAdjustVertSaturate']=undefined),_0x4f3119[_0x3dfa64(0x1ec)](/<COLOR ADJUST (?:VERT|VERTICAL) SATURATE: (.*) TO (.*)>/i)&&(this['_brightEffectsColorAdjustHorzSaturate']=undefined,this[_0x3dfa64(0x1bc)]=[Number(RegExp['$1']),Number(RegExp['$2'])]);}$gameScreen['setBrightEffectsColorAdjustSettings'](_0x1f702b,_0x349080,_0x26a127,0x0);},Game_Map[_0x57837c(0x1a0)][_0x57837c(0x1d2)]=function(){var _0x19ee5f=_0x57837c;const _0x15a49a=VisuMZ[_0x19ee5f(0x210)]['Settings'][_0x19ee5f(0x166)];let _0x19dac0=_0x15a49a[_0x19ee5f(0x200)],_0x1d354a=_0x15a49a[_0x19ee5f(0x21d)];if($dataMap){const _0x5f4d32=$dataMap[_0x19ee5f(0x21c)]||'';_0x5f4d32[_0x19ee5f(0x1ec)](/<(?:TILTSHIFT|TILT SHIFT) PIXEL BLUR:[ ](\d+)>/i)&&(_0x19dac0=Number(RegExp['$1'])),_0x5f4d32['match'](/<(?:TILTSHIFT|TILT SHIFT) (?:GRAD|GRADIENT) BLUR:[ ](\d+)>/i)&&(_0x1d354a=Number(RegExp['$1']));}$gameScreen[_0x19ee5f(0x1a5)](_0x19dac0,_0x1d354a,0x0);},Game_Map[_0x57837c(0x1a0)][_0x57837c(0x17c)]=function(){var _0x128cf9=_0x57837c;let _0x34f97d=0x0;if($dataMap){const _0x7e8f45=$dataMap[_0x128cf9(0x21c)]||'';_0x7e8f45[_0x128cf9(0x1ec)](/<BLUR:[ ](.*?)>/i)&&(_0x34f97d=Number(RegExp['$1']));}$gameScreen[_0x128cf9(0x16d)](_0x34f97d,0x0);},VisuMZ[_0x57837c(0x210)][_0x57837c(0x220)]=Game_CharacterBase[_0x57837c(0x1a0)][_0x57837c(0x1cf)],Game_CharacterBase[_0x57837c(0x1a0)][_0x57837c(0x1cf)]=function(_0x90ef9,_0x5b8ef6){var _0x36fa25=_0x57837c;VisuMZ[_0x36fa25(0x210)][_0x36fa25(0x220)][_0x36fa25(0x191)](this,_0x90ef9,_0x5b8ef6),this===$gamePlayer&&this[_0x36fa25(0x1b4)]();},VisuMZ[_0x57837c(0x210)]['Game_Player_update']=Game_Player[_0x57837c(0x1a0)][_0x57837c(0x1e5)],Game_Player[_0x57837c(0x1a0)][_0x57837c(0x1e5)]=function(_0x133008){var _0x5039af=_0x57837c;VisuMZ[_0x5039af(0x210)]['Game_Player_update'][_0x5039af(0x191)](this,_0x133008),this[_0x5039af(0x1b4)]();},Game_Player['prototype'][_0x57837c(0x1b4)]=function(){var _0x1d0f4f=_0x57837c;if(ConfigManager['specialEffects']===![])return;this['updateMapBrightEffectsAdvBloom'](),this[_0x1d0f4f(0x1e7)](),this[_0x1d0f4f(0x205)]();},Game_Player[_0x57837c(0x1a0)][_0x57837c(0x20e)]=function(){var _0x230b93=_0x57837c,_0x1bbd58=$gameScreen[_0x230b93(0x1f6)](),_0x232440=_0x1bbd58[_0x230b93(0x1c7)],_0x14478c=_0x1bbd58['brightness'],_0x53c792=_0x1bbd58[_0x230b93(0x1dc)];if($gameMap[_0x230b93(0x198)]!==undefined)var _0x3aad9a=$gameMap[_0x230b93(0x198)][0x0],_0x21c508=$gameMap[_0x230b93(0x198)][0x1]-_0x3aad9a,_0x205dbd=$gamePlayer['_realX']/$gameMap[_0x230b93(0x1f2)](),_0x232440=_0x3aad9a+_0x21c508*_0x205dbd;else{if($gameMap[_0x230b93(0x1fc)]!==undefined)var _0x3aad9a=$gameMap[_0x230b93(0x1fc)][0x0],_0x21c508=$gameMap[_0x230b93(0x1fc)][0x1]-_0x3aad9a,_0x205dbd=$gamePlayer[_0x230b93(0x1e1)]/$gameMap[_0x230b93(0x228)](),_0x232440=_0x3aad9a+_0x21c508*_0x205dbd;}if($gameMap['_brightEffectsBloomHorzBrightness']!==undefined)var _0x3aad9a=$gameMap[_0x230b93(0x206)][0x0],_0x21c508=$gameMap[_0x230b93(0x206)][0x1]-_0x3aad9a,_0x205dbd=$gamePlayer[_0x230b93(0x1dd)]/$gameMap[_0x230b93(0x1f2)](),_0x14478c=_0x3aad9a+_0x21c508*_0x205dbd;else{if($gameMap[_0x230b93(0x207)]!==undefined)var _0x3aad9a=$gameMap[_0x230b93(0x207)][0x0],_0x21c508=$gameMap['_brightEffectsBloomVertBrightness'][0x1]-_0x3aad9a,_0x205dbd=$gamePlayer[_0x230b93(0x1e1)]/$gameMap[_0x230b93(0x228)](),_0x14478c=_0x3aad9a+_0x21c508*_0x205dbd;}if($gameMap[_0x230b93(0x217)]!==undefined)var _0x3aad9a=$gameMap[_0x230b93(0x217)][0x0],_0x21c508=$gameMap[_0x230b93(0x217)][0x1]-_0x3aad9a,_0x205dbd=$gamePlayer[_0x230b93(0x1dd)]/$gameMap[_0x230b93(0x1f2)](),_0x53c792=_0x3aad9a+_0x21c508*_0x205dbd;else{if($gameMap[_0x230b93(0x1cb)]!==undefined)var _0x3aad9a=$gameMap[_0x230b93(0x1cb)][0x0],_0x21c508=$gameMap['_brightEffectsBloomVertThreshold'][0x1]-_0x3aad9a,_0x205dbd=$gamePlayer[_0x230b93(0x1e1)]/$gameMap[_0x230b93(0x228)](),_0x53c792=_0x3aad9a+_0x21c508*_0x205dbd;}$gameScreen[_0x230b93(0x1c9)](_0x232440,_0x14478c,_0x53c792,_0x1bbd58[_0x230b93(0x186)]);},Game_Player[_0x57837c(0x1a0)]['updateMapBrightEffectsGodray']=function(){var _0x32e90d=_0x57837c,_0x2710dd=$gameScreen[_0x32e90d(0x168)](),_0x1bdb90=_0x2710dd[_0x32e90d(0x1c8)],_0x19bd84=_0x2710dd[_0x32e90d(0x223)],_0x5b0152=_0x2710dd[_0x32e90d(0x1fa)],_0x521d02=_0x2710dd[_0x32e90d(0x21f)],_0x38d427=_0x2710dd[_0x32e90d(0x16e)];if($gameMap[_0x32e90d(0x1ae)]!==undefined)var _0x382e4f=$gameMap[_0x32e90d(0x1ae)][0x0],_0x2d8435=$gameMap[_0x32e90d(0x1ae)][0x1]-_0x382e4f,_0x217215=$gamePlayer[_0x32e90d(0x1dd)]/$gameMap[_0x32e90d(0x1f2)](),_0x19bd84=_0x382e4f+_0x2d8435*_0x217215;else{if($gameMap[_0x32e90d(0x1fc)]!==undefined)var _0x382e4f=$gameMap[_0x32e90d(0x20c)][0x0],_0x2d8435=$gameMap[_0x32e90d(0x20c)][0x1]-_0x382e4f,_0x217215=$gamePlayer['_realY']/$gameMap['height'](),_0x19bd84=_0x382e4f+_0x2d8435*_0x217215;}if($gameMap['_brightEffectsGodrayHorzGain']!==undefined)var _0x382e4f=$gameMap[_0x32e90d(0x16f)][0x0],_0x2d8435=$gameMap[_0x32e90d(0x16f)][0x1]-_0x382e4f,_0x217215=$gamePlayer['_realX']/$gameMap['width'](),_0x5b0152=_0x382e4f+_0x2d8435*_0x217215;else{if($gameMap['_brightEffectsGodrayVertGain']!==undefined)var _0x382e4f=$gameMap[_0x32e90d(0x1d7)][0x0],_0x2d8435=$gameMap[_0x32e90d(0x1d7)][0x1]-_0x382e4f,_0x217215=$gamePlayer[_0x32e90d(0x1e1)]/$gameMap['height'](),_0x5b0152=_0x382e4f+_0x2d8435*_0x217215;}if($gameMap[_0x32e90d(0x1e4)]!==undefined)var _0x382e4f=$gameMap['_brightEffectsGodrayHorzLacunarity'][0x0],_0x2d8435=$gameMap[_0x32e90d(0x1e4)][0x1]-_0x382e4f,_0x217215=$gamePlayer[_0x32e90d(0x1dd)]/$gameMap[_0x32e90d(0x1f2)](),_0x521d02=_0x382e4f+_0x2d8435*_0x217215;else{if($gameMap['_brightEffectsGodrayVertLacunarity']!==undefined)var _0x382e4f=$gameMap[_0x32e90d(0x1a4)][0x0],_0x2d8435=$gameMap[_0x32e90d(0x1a4)][0x1]-_0x382e4f,_0x217215=$gamePlayer[_0x32e90d(0x1e1)]/$gameMap[_0x32e90d(0x228)](),_0x521d02=_0x382e4f+_0x2d8435*_0x217215;}if($gameMap[_0x32e90d(0x172)]!==undefined)var _0x382e4f=$gameMap[_0x32e90d(0x172)][0x0],_0x2d8435=$gameMap[_0x32e90d(0x172)][0x1]-_0x382e4f,_0x217215=$gamePlayer[_0x32e90d(0x1dd)]/$gameMap[_0x32e90d(0x1f2)](),_0x38d427=_0x382e4f+_0x2d8435*_0x217215;else{if($gameMap[_0x32e90d(0x17e)]!==undefined)var _0x382e4f=$gameMap[_0x32e90d(0x17e)][0x0],_0x2d8435=$gameMap[_0x32e90d(0x17e)][0x1]-_0x382e4f,_0x217215=$gamePlayer[_0x32e90d(0x1e1)]/$gameMap[_0x32e90d(0x228)](),_0x38d427=_0x382e4f+_0x2d8435*_0x217215;}$gameScreen[_0x32e90d(0x1aa)](_0x1bdb90,_0x19bd84,_0x5b0152,_0x521d02,_0x38d427,_0x2710dd[_0x32e90d(0x186)]);},Game_Player[_0x57837c(0x1a0)][_0x57837c(0x205)]=function(){var _0x1cbee8=_0x57837c,_0x10d77d=$gameScreen[_0x1cbee8(0x1c4)](),_0x5f008d=_0x10d77d[_0x1cbee8(0x1e3)],_0x17f0c9=_0x10d77d[_0x1cbee8(0x1df)],_0x100733=_0x10d77d['saturate'];if($gameMap[_0x1cbee8(0x224)]!==undefined)var _0x2f294c=$gameMap[_0x1cbee8(0x224)][0x0],_0x39c289=$gameMap[_0x1cbee8(0x224)][0x1]-_0x2f294c,_0x25f322=$gamePlayer['_realX']/$gameMap[_0x1cbee8(0x1f2)](),_0x5f008d=_0x2f294c+_0x39c289*_0x25f322;else{if($gameMap[_0x1cbee8(0x1de)]!==undefined)var _0x2f294c=$gameMap[_0x1cbee8(0x1de)][0x0],_0x39c289=$gameMap[_0x1cbee8(0x1de)][0x1]-_0x2f294c,_0x25f322=$gamePlayer['_realY']/$gameMap[_0x1cbee8(0x228)](),_0x5f008d=_0x2f294c+_0x39c289*_0x25f322;}if($gameMap[_0x1cbee8(0x1bf)]!==undefined)var _0x2f294c=$gameMap['_brightEffectsColorAdjustHorzContrast'][0x0],_0x39c289=$gameMap[_0x1cbee8(0x1bf)][0x1]-_0x2f294c,_0x25f322=$gamePlayer['_realX']/$gameMap['width'](),_0x17f0c9=_0x2f294c+_0x39c289*_0x25f322;else{if($gameMap[_0x1cbee8(0x1e8)]!==undefined)var _0x2f294c=$gameMap[_0x1cbee8(0x1e8)][0x0],_0x39c289=$gameMap[_0x1cbee8(0x1e8)][0x1]-_0x2f294c,_0x25f322=$gamePlayer[_0x1cbee8(0x1e1)]/$gameMap[_0x1cbee8(0x228)](),_0x17f0c9=_0x2f294c+_0x39c289*_0x25f322;}if($gameMap[_0x1cbee8(0x19f)]!==undefined)var _0x2f294c=$gameMap[_0x1cbee8(0x19f)][0x0],_0x39c289=$gameMap['_brightEffectsColorAdjustHorzSaturate'][0x1]-_0x2f294c,_0x25f322=$gamePlayer[_0x1cbee8(0x1dd)]/$gameMap[_0x1cbee8(0x1f2)](),_0x100733=_0x2f294c+_0x39c289*_0x25f322;else{if($gameMap[_0x1cbee8(0x1bc)]!==undefined)var _0x2f294c=$gameMap[_0x1cbee8(0x1bc)][0x0],_0x39c289=$gameMap[_0x1cbee8(0x1bc)][0x1]-_0x2f294c,_0x25f322=$gamePlayer[_0x1cbee8(0x1e1)]/$gameMap['height'](),_0x100733=_0x2f294c+_0x39c289*_0x25f322;}$gameScreen['setBrightEffectsColorAdjustSettings'](_0x5f008d,_0x17f0c9,_0x100733,_0x10d77d['duration']);},Spriteset_Base[_0x57837c(0x1cc)]=![],Spriteset_Map['BRIGHT_EFFECTS_BASE_ONLY']=VisuMZ[_0x57837c(0x210)]['Settings'][_0x57837c(0x212)],Spriteset_Battle[_0x57837c(0x1cc)]=VisuMZ[_0x57837c(0x210)][_0x57837c(0x20f)]['BattleBaseFilter'],Spriteset_Base[_0x57837c(0x1a0)][_0x57837c(0x173)]=function(){var _0x59b4cb=_0x57837c;return Spriteset_Base[_0x59b4cb(0x1cc)];},Spriteset_Map[_0x57837c(0x1a0)]['brightEffectsBaseOnly']=function(){return Spriteset_Map['BRIGHT_EFFECTS_BASE_ONLY'];},Spriteset_Battle[_0x57837c(0x1a0)][_0x57837c(0x173)]=function(){return Spriteset_Battle['BRIGHT_EFFECTS_BASE_ONLY'];},VisuMZ[_0x57837c(0x210)][_0x57837c(0x1b6)]=Spriteset_Base[_0x57837c(0x1a0)][_0x57837c(0x1e0)],Spriteset_Base['prototype']['createOverallFilters']=function(){var _0x5d4469=_0x57837c;VisuMZ['BrightEffects']['Spriteset_Base_createOverallFilters'][_0x5d4469(0x191)](this),this[_0x5d4469(0x21b)]();},VisuMZ['BrightEffects'][_0x57837c(0x216)]=Spriteset_Base[_0x57837c(0x1a0)][_0x57837c(0x1e5)],Spriteset_Base['prototype'][_0x57837c(0x1e5)]=function(){var _0x465142=_0x57837c;VisuMZ['BrightEffects'][_0x465142(0x216)]['call'](this),this[_0x465142(0x18b)]();},Spriteset_Map[_0x57837c(0x1a0)]['getMapEnhanceScreenY']=function(){var _0x785723=_0x57837c;const _0x3f8688=$gameScreen[_0x785723(0x184)]();let _0x3537dc=0x0;if(Imported[_0x785723(0x215)]&&$gameScreen[_0x785723(0x181)]()[_0x785723(0x179)])_0x3537dc=Graphics['height']/0x2,_0x3537dc-=$gameMap[_0x785723(0x18f)]()*0.5*_0x3f8688;else{const _0x428f92=Imported[_0x785723(0x215)]?$gameScreen[_0x785723(0x187)](!![]):$gamePlayer,_0x47fb98=this[_0x785723(0x1c1)](_0x428f92);_0x3537dc=_0x428f92[_0x785723(0x1f8)]()*_0x3f8688,_0x3537dc-=_0x47fb98[_0x785723(0x228)]*0.5,_0x3537dc-=_0x428f92[_0x785723(0x1b2)]()*_0x3f8688*0.5;}return _0x3537dc;},Spriteset_Base['prototype'][_0x57837c(0x177)]=function(){var _0x56c612=_0x57837c;return Graphics[_0x56c612(0x228)]/0x2;},Spriteset_Base['prototype']['createBrightEffectsFilters']=function(){var _0x5e680e=_0x57837c;if(ConfigManager[_0x5e680e(0x182)]===![])return;this[_0x5e680e(0x1ad)]=this[_0x5e680e(0x1ad)]||[],this[_0x5e680e(0x1ba)](),this[_0x5e680e(0x1f9)](),this[_0x5e680e(0x16c)](),this['createBrightEffectsTiltShiftFilter'](),this['createBrightEffectsBlurFilter'](),this['updateBrightEffectsFilters']();},Spriteset_Base[_0x57837c(0x1a0)][_0x57837c(0x18b)]=function(){var _0x28bcd8=_0x57837c;this[_0x28bcd8(0x1d5)](),this[_0x28bcd8(0x1ed)](),this[_0x28bcd8(0x211)](),this[_0x28bcd8(0x1d3)](),this['updateBrightEffectsBlurFilter']();},Spriteset_Base[_0x57837c(0x1a0)][_0x57837c(0x1ba)]=function(){var _0x3790a0=_0x57837c;if(!PIXI[_0x3790a0(0x1ad)]['AdvancedBloomFilter'])return;this[_0x3790a0(0x1a6)]=new PIXI[(_0x3790a0(0x1ad))]['AdvancedBloomFilter']();this[_0x3790a0(0x173)]()?this['_baseSprite']['filters'][_0x3790a0(0x192)](this[_0x3790a0(0x1a6)]):this[_0x3790a0(0x1ad)][_0x3790a0(0x192)](this[_0x3790a0(0x1a6)]);var _0x1f2e7b=$gameScreen[_0x3790a0(0x1f6)]();_0x1f2e7b&&_0x1f2e7b[_0x3790a0(0x186)]>0x0&&(this[_0x3790a0(0x1a6)][_0x3790a0(0x1c7)]=_0x1f2e7b[_0x3790a0(0x1c7)],this[_0x3790a0(0x1a6)][_0x3790a0(0x1e3)]=_0x1f2e7b[_0x3790a0(0x1e3)],this[_0x3790a0(0x1a6)][_0x3790a0(0x1dc)]=_0x1f2e7b['threshold']);},Spriteset_Base[_0x57837c(0x1a0)][_0x57837c(0x1d5)]=function(){var _0x30a6d1=_0x57837c;if(!!this[_0x30a6d1(0x1a6)]){var _0x400a2d=$gameScreen['getBrightEffectsAdvBloomSettings'](),_0x5d1dec=_0x400a2d[_0x30a6d1(0x186)];_0x5d1dec<=0x0?(this['_BrightEffectsAdvBloomFilter'][_0x30a6d1(0x1c7)]=_0x400a2d[_0x30a6d1(0x1c7)],this[_0x30a6d1(0x1a6)][_0x30a6d1(0x1e3)]=_0x400a2d[_0x30a6d1(0x1e3)],this[_0x30a6d1(0x1a6)][_0x30a6d1(0x1dc)]=_0x400a2d[_0x30a6d1(0x1dc)]):(_0x400a2d['duration']--,this['_BrightEffectsAdvBloomFilter']['bloomScale']=(this[_0x30a6d1(0x1a6)][_0x30a6d1(0x1c7)]*(_0x5d1dec-0x1)+_0x400a2d[_0x30a6d1(0x1c7)])/_0x5d1dec,this[_0x30a6d1(0x1a6)][_0x30a6d1(0x1e3)]=(this[_0x30a6d1(0x1a6)]['brightness']*(_0x5d1dec-0x1)+_0x400a2d['brightness'])/_0x5d1dec,this[_0x30a6d1(0x1a6)][_0x30a6d1(0x1dc)]=(this[_0x30a6d1(0x1a6)][_0x30a6d1(0x1dc)]*(_0x5d1dec-0x1)+_0x400a2d['threshold'])/_0x5d1dec);}},Spriteset_Base[_0x57837c(0x1a0)][_0x57837c(0x1f9)]=function(){var _0x2dbf92=_0x57837c;if(!PIXI[_0x2dbf92(0x1ad)][_0x2dbf92(0x1c5)])return;this['_BrightEffectsGodrayFilter']=new PIXI[(_0x2dbf92(0x1ad))]['GodrayFilter'](),this[_0x2dbf92(0x1ce)][_0x2dbf92(0x171)]=![],this[_0x2dbf92(0x1ce)]['time']=0x0;this['brightEffectsBaseOnly']()?this[_0x2dbf92(0x1b1)][_0x2dbf92(0x1ad)][_0x2dbf92(0x192)](this[_0x2dbf92(0x1ce)]):this['filters'][_0x2dbf92(0x192)](this[_0x2dbf92(0x1ce)]);var _0x5c7e34=$gameScreen[_0x2dbf92(0x168)]();_0x5c7e34&&_0x5c7e34['duration']>0x0&&(this[_0x2dbf92(0x1ce)][_0x2dbf92(0x223)]=_0x5c7e34[_0x2dbf92(0x223)],this[_0x2dbf92(0x1ce)][_0x2dbf92(0x1fa)]=_0x5c7e34['gain'],this[_0x2dbf92(0x1ce)][_0x2dbf92(0x21f)]=_0x5c7e34[_0x2dbf92(0x21f)],this[_0x2dbf92(0x1ce)]['angle']=_0x5c7e34[_0x2dbf92(0x16e)]);},Spriteset_Base[_0x57837c(0x1a0)][_0x57837c(0x1ed)]=function(){var _0x1524af=_0x57837c;if(!!this['_BrightEffectsGodrayFilter']){var _0x165caa=$gameScreen[_0x1524af(0x168)](),_0x24e7dd=_0x165caa[_0x1524af(0x186)];_0x24e7dd<=0x0?(this[_0x1524af(0x1ce)][_0x1524af(0x223)]=_0x165caa[_0x1524af(0x223)],this[_0x1524af(0x1ce)][_0x1524af(0x1fa)]=_0x165caa['gain'],this[_0x1524af(0x1ce)][_0x1524af(0x21f)]=_0x165caa['lacunarity'],this[_0x1524af(0x1ce)][_0x1524af(0x16e)]=_0x165caa[_0x1524af(0x16e)]):(_0x165caa[_0x1524af(0x186)]--,this[_0x1524af(0x1ce)][_0x1524af(0x223)]=(this[_0x1524af(0x1ce)]['speed']*(_0x24e7dd-0x1)+_0x165caa[_0x1524af(0x223)])/_0x24e7dd,this[_0x1524af(0x1ce)]['gain']=(this[_0x1524af(0x1ce)][_0x1524af(0x1fa)]*(_0x24e7dd-0x1)+_0x165caa[_0x1524af(0x1fa)])/_0x24e7dd,this[_0x1524af(0x1ce)][_0x1524af(0x21f)]=(this[_0x1524af(0x1ce)][_0x1524af(0x21f)]*(_0x24e7dd-0x1)+_0x165caa[_0x1524af(0x21f)])/_0x24e7dd,this[_0x1524af(0x1ce)][_0x1524af(0x16e)]=(this[_0x1524af(0x1ce)][_0x1524af(0x16e)]*(_0x24e7dd-0x1)+_0x165caa[_0x1524af(0x16e)])/_0x24e7dd),this[_0x1524af(0x1ce)][_0x1524af(0x1e6)]+=this[_0x1524af(0x1ce)][_0x1524af(0x223)],this[_0x1524af(0x1ce)]['enabled']=_0x165caa['visible'];}},Spriteset_Base['prototype'][_0x57837c(0x16c)]=function(){var _0x534b91=_0x57837c;if(!PIXI['filters'][_0x534b91(0x1fe)])return;this[_0x534b91(0x18c)]=new PIXI[(_0x534b91(0x1ad))]['ColorMatrixFilter']();this[_0x534b91(0x173)]()?this[_0x534b91(0x1b1)][_0x534b91(0x1ad)][_0x534b91(0x192)](this[_0x534b91(0x18c)]):this[_0x534b91(0x1ad)][_0x534b91(0x192)](this['_BrightEffectsColorAdjustFilter']);var _0x4ff770=$gameScreen[_0x534b91(0x1c4)]();_0x4ff770&&_0x4ff770['duration']>0x0&&(this[_0x534b91(0x18c)][_0x534b91(0x1f5)]=_0x4ff770[_0x534b91(0x1e3)],this[_0x534b91(0x18c)][_0x534b91(0x188)]=_0x4ff770['contrast'],this[_0x534b91(0x18c)][_0x534b91(0x213)]=_0x4ff770['saturate']);},Spriteset_Base[_0x57837c(0x1a0)][_0x57837c(0x211)]=function(){var _0x2dc23a=_0x57837c;if(!!this['_BrightEffectsColorAdjustFilter']){var _0x5dfa4c=$gameScreen[_0x2dc23a(0x1c4)](),_0x463d46=_0x5dfa4c[_0x2dc23a(0x186)];_0x463d46<=0x0?(this[_0x2dc23a(0x18c)]['currentBrightness']=_0x5dfa4c['brightness'],this[_0x2dc23a(0x18c)][_0x2dc23a(0x188)]=_0x5dfa4c[_0x2dc23a(0x1df)],this[_0x2dc23a(0x18c)]['currentSaturate']=_0x5dfa4c[_0x2dc23a(0x180)]):(_0x5dfa4c[_0x2dc23a(0x186)]--,this[_0x2dc23a(0x18c)][_0x2dc23a(0x1f5)]=(this[_0x2dc23a(0x18c)][_0x2dc23a(0x1f5)]*(_0x463d46-0x1)+_0x5dfa4c[_0x2dc23a(0x1e3)])/_0x463d46,this['_BrightEffectsColorAdjustFilter']['currentContrast']=(this[_0x2dc23a(0x18c)][_0x2dc23a(0x188)]*(_0x463d46-0x1)+_0x5dfa4c[_0x2dc23a(0x1df)])/_0x463d46,this['_BrightEffectsColorAdjustFilter'][_0x2dc23a(0x213)]=(this[_0x2dc23a(0x18c)][_0x2dc23a(0x213)]*(_0x463d46-0x1)+_0x5dfa4c[_0x2dc23a(0x180)])/_0x463d46),this[_0x2dc23a(0x18c)][_0x2dc23a(0x1e3)](this[_0x2dc23a(0x18c)][_0x2dc23a(0x1f5)]),this[_0x2dc23a(0x18c)][_0x2dc23a(0x1df)](this[_0x2dc23a(0x18c)][_0x2dc23a(0x188)],!![]),this['_BrightEffectsColorAdjustFilter'][_0x2dc23a(0x180)](this['_BrightEffectsColorAdjustFilter'][_0x2dc23a(0x213)],!![]);}},Spriteset_Base[_0x57837c(0x1a0)][_0x57837c(0x21a)]=function(){var _0x31df70=_0x57837c;if(!PIXI[_0x31df70(0x1ad)][_0x31df70(0x194)])return;const _0x266a57=new PIXI[(_0x31df70(0x1ad))]['TiltShiftFilter']();this[_0x31df70(0x202)]=_0x266a57;this[_0x31df70(0x173)]()?this[_0x31df70(0x1b1)][_0x31df70(0x1ad)][_0x31df70(0x192)](_0x266a57):this[_0x31df70(0x1ad)][_0x31df70(0x192)](_0x266a57);var _0x1c38cd=$gameScreen['getBrightEffectsTiltShiftSettings']();_0x1c38cd&&_0x1c38cd[_0x31df70(0x186)]>0x0&&(_0x266a57['currentPixelBlur']=_0x1c38cd[_0x31df70(0x189)],_0x266a57[_0x31df70(0x1db)]=_0x1c38cd[_0x31df70(0x1f4)]);},Spriteset_Base[_0x57837c(0x1a0)]['updateBrightEffectsTiltShiftFilter']=function(){var _0x1aab52=_0x57837c;if(!this[_0x1aab52(0x202)])return;const _0x5b7ed3=this['getMapEnhanceScreenY']()+0.5;this['setMapEnhanceTiltShiftFilterY'](_0x5b7ed3),this[_0x1aab52(0x163)]();},Spriteset_Base[_0x57837c(0x1a0)][_0x57837c(0x204)]=function(_0x3eabe8){var _0x126cf9=_0x57837c;const _0x5259bd=0x4;if(this[_0x126cf9(0x202)]['start']['y']>_0x3eabe8)this[_0x126cf9(0x202)][_0x126cf9(0x219)]={'x':0x0,'y':Math[_0x126cf9(0x167)](this[_0x126cf9(0x202)]['start']['y']-_0x5259bd,_0x3eabe8)},this[_0x126cf9(0x202)][_0x126cf9(0x208)]={'x':0x258,'y':Math['max'](this['_BrightEffectsTiltShiftFilter'][_0x126cf9(0x208)]['y']-_0x5259bd,_0x3eabe8)};else this[_0x126cf9(0x202)]['start']['y']<_0x3eabe8&&(this[_0x126cf9(0x202)][_0x126cf9(0x219)]={'x':0x0,'y':Math['min'](this[_0x126cf9(0x202)][_0x126cf9(0x219)]['y']+_0x5259bd,_0x3eabe8)},this[_0x126cf9(0x202)][_0x126cf9(0x208)]={'x':0x258,'y':Math[_0x126cf9(0x1ac)](this[_0x126cf9(0x202)][_0x126cf9(0x208)]['y']+_0x5259bd,_0x3eabe8)});},Spriteset_Base['prototype']['updateBrightEffectsTiltShiftFilterProperties']=function(){var _0x41f844=_0x57837c;const _0x14a6d8=this[_0x41f844(0x202)];var _0x4fcc8a=$gameScreen[_0x41f844(0x218)](),_0x3bdef9=_0x4fcc8a['duration'];_0x3bdef9<=0x0?(_0x14a6d8[_0x41f844(0x1ea)]=_0x4fcc8a[_0x41f844(0x189)],_0x14a6d8[_0x41f844(0x1db)]=_0x4fcc8a[_0x41f844(0x1f4)]):(_0x4fcc8a['duration']--,_0x14a6d8[_0x41f844(0x1ea)]=(_0x14a6d8[_0x41f844(0x1ea)]*(_0x3bdef9-0x1)+_0x4fcc8a['pixelBlur'])/_0x3bdef9,_0x14a6d8['currentGradientBlur']=(_0x14a6d8['currentGradientBlur']*(_0x3bdef9-0x1)+_0x4fcc8a[_0x41f844(0x1f4)])/_0x3bdef9),_0x14a6d8[_0x41f844(0x16a)]=_0x14a6d8[_0x41f844(0x1ea)],_0x14a6d8[_0x41f844(0x1f4)]=_0x14a6d8[_0x41f844(0x1db)];},Spriteset_Base[_0x57837c(0x1a0)]['createBrightEffectsBlurFilter']=function(){var _0x85a318=_0x57837c;const _0x590b47=new PIXI[(_0x85a318(0x1ad))][(_0x85a318(0x22a))]();this['_BrightEffectsBlurFilter']=_0x590b47;this[_0x85a318(0x173)]()?this[_0x85a318(0x1b1)][_0x85a318(0x1ad)]['push'](_0x590b47):this[_0x85a318(0x1ad)][_0x85a318(0x192)](_0x590b47);var _0x5b8d97=$gameScreen[_0x85a318(0x183)]();_0x5b8d97&&_0x5b8d97[_0x85a318(0x186)]>0x0&&(_0x590b47[_0x85a318(0x193)]=_0x5b8d97[_0x85a318(0x16a)]);},Spriteset_Base[_0x57837c(0x1a0)][_0x57837c(0x1be)]=function(){var _0x53389b=_0x57837c;if(!!this[_0x53389b(0x20b)]){var _0x836b8c=$gameScreen[_0x53389b(0x183)](),_0x22e988=_0x836b8c[_0x53389b(0x186)];_0x22e988<=0x0?this[_0x53389b(0x20b)]['currentBlur']=_0x836b8c[_0x53389b(0x16a)]:(_0x836b8c[_0x53389b(0x186)]--,this[_0x53389b(0x20b)][_0x53389b(0x193)]=(this[_0x53389b(0x20b)][_0x53389b(0x193)]*(_0x22e988-0x1)+_0x836b8c[_0x53389b(0x16a)])/_0x22e988),this['_BrightEffectsBlurFilter'][_0x53389b(0x16a)]=this[_0x53389b(0x20b)][_0x53389b(0x193)];}};