//=============================================================================
// VisuStella MZ - Options Core
// VisuMZ_1_OptionsCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_OptionsCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.OptionsCore = VisuMZ.OptionsCore || {};
VisuMZ.OptionsCore.version = 1.23;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 1] [Version 1.23] [OptionsCore]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Options_Core_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Options Core plugin revamps the Options Menu Scene in RPG Maker MZ to be
 * more extensive and sustain a larger variety of options. This plugin will add
 * new options to the list in addition to options from other VisuStella MZ
 * plugins provided that they're installed as well. Game devs that are adept
 * with JavaScript are also able to add in their own options to the menu as
 * well.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Revamped Options Menu Scene and layout.
 * * The ability to add in your own Categories and options inside each of the
 *   individual categories.
 * * Newly added options like Master Volume, Window Tone support, and more.
 * * Integrated options added from other VisuStella MZ plugins.
 * * An added Playtest options category that is only available during test play
 *   to help speed up the game debug process.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 1 ------
 *
 * This plugin is a Tier 1 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin adds some new hard-coded features to RPG Maker MZ's functions.
 * The following is a list of them.
 *
 * ---
 *
 * Options Menu Scene
 *
 * - The whole scene is revamped due to all the new additions provided by the
 * Options Core plugin. While basic functions will still work, do not expect
 * everything to integrate into it seamlessly.
 *
 * ---
 *
 * ============================================================================
 * Extra Features
 * ============================================================================
 *
 * There are some extra features found if other VisuStella MZ plugins are found
 * present in the Plugin Manager list. Most of these enable new options for the
 * Options Core to utilize as the code for them to work is found in the newer
 * plugins.
 *
 * ---
 *
 * Many VisuMZ Plugins
 * 
 * - Many VisuMZ plugins have options that become available when installed
 *   together with the Options Core plugin that wouldn't be available normally.
 *
 * ---
 *
 * ============================================================================
 * Understanding Options
 * ============================================================================
 * 
 * This section is to clarify a few things about the Options Core.
 * 
 * ---
 * 
 * === Global Settings ===
 * 
 * The majority of settings adjusted by the player in the Options menu are
 * global settings. This is the way it is for base RPG Maker MZ without using
 * any plugins and this is the way it will be when using the Options Core.
 * 
 * What does this mean?
 * 
 * This means that if your player changed the Options settings, then loaded up
 * a different save, the Options settings do not revert to the settings from
 * the last time that save was made.
 * 
 * Why is this?
 * 
 * Because that is the industry standard. If the player wants to adjust the
 * BGM volume down to 50% from 100%, that means that when the player loads a
 * save file, the BGM volume does not shoot back up to 100%. Doing that would
 * require the player to adjust the settings multiple times for each save and
 * that just is not user friendly.
 * 
 * Therefore, the majority of the Options Core settings are global for this
 * very reason and are not going to change because of it.
 * 
 * ---
 * 
 * === Exceptions ===
 * 
 * There are a few exceptions to the rule. These exceptions are the three
 * settings that govern the "Window Tone" in the UI section.
 * 
 * This means the values inserted for "Red", "Green", and "Blue" are saved
 * relative to the save file's settings.
 * 
 * Why is this?
 * 
 * That's because RPG Maker MZ's "Change Window Color" event command does the
 * same thing and we have no intentions of altering how it behaves to keep the
 * otherwise-global aspect.
 * 
 * ---
 *
 * ============================================================================
 * Options Category: General
 * ============================================================================
 *
 * The following are the options that have been added to the Options Menu. This
 * is the default "General" category that appears with the plugin parameters.
 * These can be added and/or removed. If a new option has been added through an
 * update, then there's a likelihood of it not appearing due to the plugin
 * parameters not being updated with them.
 *
 * === Exploration ===
 *
 * These options adjust the general exploration aspects of the game.
 *
 * ---
 *
 * Always Dash
 * - A default option that came with RPG Maker MZ.
 * - If ON, then this puts the player character in a constant state of dashing
 *   unless the Dash button is held down.
 *   - OFF: Walks normally. Holding down Dash button will make player dash.
 *   - ON: Dashes normally. Holding down Dash button will make player walk.
 *
 * ---
 *
 * Autosave
 * - Requires: VisuMZ_1_SaveCore
 * - Lets the player choose whether or not they want autosaving in their game.
 *   - OFF: Autosaves are disabled.
 *   - ON: Autosaves are enabled and occur at the set conditions.
 *
 * ---
 *
 * Show Compass
 * - Requires: VisuMZ_4_ProximityCompass
 * - Displays the Proximity Compass in the corner of the screen.
 *   - OFF: Compass is hidden.
 *   - ON: Compass is shown.
 * 
 * ---
 *
 * Compass Size
 * - Requires: VisuMZ_4_ProximityCompass
 * - Changes the size of the compass.
 *   - 50% for Smallest
 *   - 100% for Largest
 * 
 * ---
 *
 * Show Quest Tracker
 * - Requires: VisuMZ_2_QuestSystem
 * - Player can choose if they want the Quest Tracker Window to appear on the
 *   map scene as they explore.
 *   - OFF: Quest Tracker Window does not appear.
 *   - ON: Quest Tracker Window is visible.
 *
 * ---
 *
 * Quest Tracker Position
 * - Requires: VisuMZ_2_QuestSystem
 * - Lets the player decide which half of the screen the Quest Tracker Window
 *   should appear.
 *   - ←: Quest Tracker Window appears on the left.
 *   - →: Quest Tracker Window appears on the right.
 *
 * ---
 *
 * Random Encounters
 * - Sometimes, random encounters can really take away the enjoyment a player
 *   has for the game if it's too frequent. This option lets the player turn
 *   them off or reduce their frequency by half.
 *   - None: No random encounters while this is selected.
 *   - Half: Random encounters occur at half frequency.
 *   - Normal: Random encounters occur at normal frequency.
 *
 * ---
 * 
 * Show Tutorials
 * - Requires: VisuMZ_2_TutorialPanelSys
 * - Allows tutorials to interrupt gameplay in order to teach the player about
 *   whatever new mechanic needs to be done.
 *   - OFF: Tutorials won't turn on but can still be accessed from main menu.
 *   - ON: Tutorials will halt gameplay to teach the player.
 * 
 * ---
 *
 * === Battle ===
 *
 * These options adjust the general battle aspects of the game.
 *
 * ---
 * 
 * Show Battle Animations:
 * - Players might want to turn off or some battle animations for various
 *   reasons. As examples, battle animations may take a toll on some players'
 *   computers while others might find them too distracting.
 *   - OFF: All battle animations are turned off.
 *   - SOME: Animations that aren't part of a skill/item's action sequence will
 *     not be displayed.
 *   - ON: All battle animations are visible.
 * 
 * ---
 *
 * Battle Animation Speed:
 * - Battles can become a slog for some types of players. This option comes
 *   with four speed types to blaze through the battle while animations are
 *   playing. Fret not, if it's time for an actor to input actions, then the
 *   battle speed will temporarily revert to normal speed.
 *   - Normal: The usual battle speed.
 *   - Fast: x2 the usual battle speed.
 *   - Faster: x3 the usual battle speed.
 *   - Fastest: x4 the usual battle speed.
 *
 * ---
 *
 * Battle Camera
 * - Requires: VisuMZ_3_ActSeqCamera
 * - Allows the player to turn on/off the camera in case the player is one
 *   who gets motion sick easily.
 *   - OFF: Battle camera is static and doesn't move/zoom.
 *   - ON: Battle camera has full range of movement and zoom.
 *
 * ---
 *
 * Command Remember
 * - A default Options menu command that remembers the last position of the
 *   battle input window.
 *   - OFF: Cursor position resets each time the battle input window is active.
 *   - ON: Cursor position remembers last position for battle input window.
 *
 * ---
 *
 * Active Battle Style
 * - Requires: VisuMZ_2_BattleSystemATB
 * - Lets the player switch betweent "Wait" and "Active".
 *   - Wait: ATB gauges stop filling up the moment an actor can input.
 *   - Active: ATB gauges keep filling even if actors can input.
 *
 * ---
 *
 * Active Battle Speed
 * - Requires: VisuMZ_2_BattleSystemATB
 * - Lets the player control how fast ATB gauges fill up.
 * - 1 for slowest.
 * - 5 for fastest.
 *
 * ---
 *
 * Auto Battle Start
 * - Requires: VisuMZ_1_BattleCore
 * - Start battles with Auto Battle on/off?
 *   - OFF: Battles do not start with Auto Battle on.
 *   - ON: Battles start with Auto Battle on.
 *
 * ---
 *
 * Auto Battle Style
 * - Requires: VisuMZ_1_BattleCore
 * - Determine if Auto Battle for the player party will attack only or be
 *   allowed to use skills as well.
 *   - Attack: Auto Battle actors will attack only.
 *   - Skills: Auto Battle actors can also use skills.
 * 
 * ---
 *
 * === Screen ===
 *
 * These options adjust the general screen-related aspects of the game.
 *
 * ---
 *
 * Display FPS
 * - Turns on/off the FPS counter in the upper left section of the screen.
 *
 * ---
 *
 * Full Screen
 * - Switches the game client between windowed mode and full screen.
 *
 * ---
 *
 * Stretch Screen
 * - If the game client is larger than the screen, then the game's canvas will
 *   stretch to fit the client. Turn this on or off.
 *
 * ---
 * 
 * Special Effects
 * - Requires: VisuMZ_2_BrightEffects and/or VisuMZ_2_HorrorEffects
 * - When using VisuStella MZ's Horror Effects or Bright Effects, users can opt
 *   to disable those effects by turning this option on/off.
 * 
 * ---
 * 
 * Dust Clouds
 * - Requires: VisuMZ_2_MovementEffects
 * - Plays dust cloud effects when the player and followers are running across
 *   the screen.
 * 
 * ---
 * 
 * Footprint Marks
 * - Requires: VisuMZ_2_MovementEffects
 * - Puts footprints down on the screen when the character sprites are moving
 *   on the screen.
 * 
 * ---
 * 
 * Smooth Scroll
 * - Requires: VisuMZ_2_MovementEffects
 * - Gradually shifts the screen camera to the player position.
 * 
 * ---
 * 
 * Blinking Lights
 * - Requires: VisuMZ_2_LightingEffects
 * - Turns off blinking effect from lighting effects.
 * 
 * ---
 * 
 * Pulsing Lights
 * - Requires: VisuMZ_2_LightingEffects
 * - Turns off pulsing effect from Lighting effects.
 * 
 * ---
 * 
 * Weather Density
 * - Requires: VisuMZ_2_WeatherEffects
 * - Allows players to control the density of weather patterns if it may be too
 *   much for their devices to handle.
 * 
 * ---
 *
 * ============================================================================
 * Options Category: Audio
 * ============================================================================
 *
 * The following are the options that have been added to the Options Menu. This
 * is the default "Audio" category that appears with the plugin parameters.
 * These can be added and/or removed. If a new option has been added through an
 * update, then there's a likelihood of it not appearing due to the plugin
 * parameters not being updated with them.
 *
 * === Volume ===
 *
 * These options adjust the volume-related aspects of the game.
 *
 * ---
 *
 * Master Volume
 * - The master volume sets the volume of all the other volume types by a
 *   proportional amount from 0% to 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 *
 * ---
 *
 * BGM Volume
 * - Controls the background music volume by a value between 0% and 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 *
 * ---
 *
 * BGS Volume
 * - Controls the background ambience volume by a value between 0% and 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 *
 * ---
 *
 * ME Volume
 * - Controls the fanfare volume by a value between 0% and 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 *
 * ---
 *
 * SE Volume
 * - Controls the sound effect volume by a value between 0% and 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 * 
 * ---
 * 
 * Voice Volume:
 * - Requires: VisuMZ_2_VoiceActControl
 * - Allows players to adjust the volume of the voice audio channel instead of
 *   having it linked to the SE audio channel. This is so players can choose to
 *   turn off sound effects while still hearing voices or vice versa.
 * 
 * ---
 * 
 * Advanced Sound Options
 * - Requires: Tome571/TF's "Advanced Sound Options plugin"
 * - Allows for very specialized control over sound settings.
 * 
 * ---
 *
 * === Sound Effects ===
 *
 * These options adjust the sound effects-related aspects of the game.
 *
 * ---
 * 
 * Battle Voices
 * - Requires: VisuMZ_3_BattleVoices
 * - Allows player to toggle the playing of battle voices in-battle.
 * 
 * ---
 * 
 * Footstep Sounds
 * - Requires: VisuMZ_2_MovementEffects
 * - Plays footstep sounds when the character sprites are moving on screen.
 * 
 * ---
 * 
 * Letter Sounds
 * - Requires VisuMZ_3_MessageSounds
 * - Allows player to toggle the playing of letter sounds for messages.
 * 
 * ---
 *
 * Sound Effects:
 * Cursor SFX:
 * Confirm SFX:
 * Cancel SFX:
 * Buzzer SFX:
 * - Not all sound effects register well with players and/or their computers.
 * - This lets players pick different sound effects if they have trouble
 *   hearing certain ones.
 *
 * ---
 *
 * ============================================================================
 * Options Category: UI
 * ============================================================================
 *
 * The following are the options that have been added to the Options Menu. This
 * is the default "UI" category that appears with the plugin parameters.
 * These can be added and/or removed. If a new option has been added through an
 * update, then there's a likelihood of it not appearing due to the plugin
 * parameters not being updated with them.
 *
 * === Windows ===
 *
 * These options adjust the Windows UI-related aspects of the game.
 *
 * ---
 *
 * Window Tone: Red:
 * Window Tone: Green:
 * Window Tone: Blue:
 * - Allows the player to adjust the Window Tone to their liking. This helps
 *   give players a more personal touch on their save file.
 *
 * ---
 *
 * === Text ===
 *
 * These options adjust the Text-related aspects of the game.
 *
 * ---
 *
 * Text Font:
 * - Certain fonts are harder to read for different players. Let the players
 *   pick the font the game uses to allow themselves maximum comfort.
 *
 * ---
 *
 * Text Speed
 * - Requires: VisuMZ_1_MessageCore
 * - Allows the player to set the speed at which text displays during messages.
 * - There are speeds 1 through 10, with 1 being the slowest and 10 being the
 *   fastest.
 * - Speed 11 is "Instant" which causes text to display instantly.
 * 
 * ---
 * 
 * Text Effects
 * - Requires: VisuMZ_2_AniMsgTextEffects
 * - Allows the player to toggle animated text effects.
 *
 * ---
 *
 * === Touch Input ===
 *
 * These options adjust the Touch UI-related aspects of the game.
 *
 * ---
 *
 * Touch UI
 * - Requires VisuMZ_0_CoreEngine
 * - This sets the visibility of the UI elements that are touch-only in the
 *   game such as the cancel button and the left/right actor switch buttons.
 *   - OFF: The touch-only UI elements do not appear.
 *   - ON: The touch-only UI elements do appear.
 *
 * ---
 *
 * Button Position:
 * - Requires VisuMZ_0_CoreEngine
 * - Moves the clickable Cancel button, Page Up button, and Page down button
 *   to either the top of the screen or bottom of the screen.
 *
 * ---
 *
 * Hover Select:
 * - Turn on/off Hover Select when using the mouse. If Hover Select is on, then
 *   the window cursor will automatically follow the mouse when applicable.
 *   Otherwise, the player will have to manually move the cursor.
 *
 * ---
 *
 * === Menu Arrangement ===
 *
 * These options adjust the Menu Arrangement-related aspects of the game.
 *
 * ---
 *
 * Menu Style
 * - Switch between 'Recommended' and 'Custom'. Recommended will have the menus
 *   arranged in the way the game/plugins decide for them to be. Otherwise,
 *   the player will be able to customize the positions of these next windows:
 *
 * ---
 *
 * Help Window Position:
 * Input Window Position:
 * - Adjust the positions of these windows in the various positions listed to
 *   allow the player to select what they're most comfortable with.
 *
 * ---
 *
 * === Battle UI ===
 *
 * These options adjust the Battle UI-related aspects of the game.
 *
 * ---
 *
 * Show Provoke Origin
 * - Requires VisuMZ_2_AggroControlSystem
 * - If a battler is under the effects of "Provoke", then a line tracing back
 *   to the origin of the "Provoke" effect can be found.
 *   - OFF: Hide the Provoke Origin lines.
 *   - ON: Show the Provoke Origin lines.
 *
 * ---
 *
 * Show Aggro Gauge
 * - Requires VisuMZ_2_AggroControlSystem
 * - Displays the amount of aggro a party member has with a gauge.
 *   - OFF: The Aggro Gauge is hidden.
 *   - ON: The Aggro Gauge is visible.
 *
 * ---
 *
 * Show HP Gauges
 * - Requires VisuMZ_3_VisualHpGauge
 * - Displays the amount of HP each battler has with a gauge under their feet.
 *   - OFF: The battlefield's HP Gauges are hidden.
 *   - ON: The battlefield's HP Gauges are visible.
 *
 * ---
 *
 * Show ATB Gauges
 * - Requires VisuMZ_2_BattleSystemATB
 * - Displays ATB gauges on each battler showing how much time they have left
 *   before they can act.
 *   - OFF: The battlefield's ATB Gauges are hidden.
 *   - ON: The battlefield's ATB Gauges are hidden.
 *
 * ---
 *
 * ============================================================================
 * Options Category: Playtest
 * ============================================================================
 *
 * The following are the options that have been added to the Options Menu. This
 * is the default "Text" category that appears with the plugin parameters.
 * These can be added and/or removed. If a new option has been added through an
 * update, then there's a likelihood of it not appearing due to the plugin
 * parameters not being updated with them.
 * 
 * *NOTE* Unless changed, this category only appears during playtesting and
 * does not appear outside of playtesting, which means deployed games should
 * not display this unless you've given them access to playtest mode.
 *
 * === Effects ===
 * 
 * ---
 *
 * Playtest Effects:
 * - If this is 'OFF', then all the Playtesting options are turned off. If 'ON'
 *   then you can adjust them however you like.
 *
 * ---
 * 
 * === Exploration ===
 * 
 * These options adjust the Playtest Exploration-related aspects of the game.
 * 
 * ---
 *
 * Map Update Speed:
 * - Allows you to speed up the events and movement on the map with four speed
 *   levels ranging from normal to x3 speed.
 *   - Normal: The usual update speed.
 *   - Fast: x2 the usual update speed.
 *   - Faster: x3 the usual update speed.
 *   - Fastest: x4 the usual update speed.
 *
 * ---
 *
 * Random Encounters:
 * - Sometimes, random encounters can really take away the enjoyment a player
 *   has for the game if it's too frequent. This option lets the player turn
 *   them off or reduce their frequency by half.
 *   - None: No random encounters while this is selected.
 *   - Half: Random encounters occur at half frequency.
 *   - Normal: Random encounters occur at normal frequency.
 *
 * ---
 * 
 * === Battle ===
 * 
 * These options adjust the Playtest Battle-related aspects of the game.
 * 
 * ---
 *
 * God Mode:
 * - If this is ON, then actors will be unable to die even if their HP reaches
 *   0. They will continue to act as if they still have HP left.
 *
 * ---
 *
 * Resist Negative Effects:
 * - Requires VisuMZ_1_SkillsStatesCore.
 * - If ON, this will resist states with a <Negative State> notetag.
 * - If ON, this will also resist debuffs.
 *
 * ---
 *
 * Instant K.O.
 * - If ON, then actors attacking enemies will deal fatal damage to enemies.
 *
 * ---
 *
 * Skill Costs:
 * Consume Items:
 * - If OFF, then skills won't cost anything and items won't be consumed.
 *
 * ---
 * 
 * === Rewards ===
 * 
 * These options adjust the Playtest Rewards-related aspects of the game.
 * 
 * ---
 *
 * EXP Multiplier:
 * Gold Multiplier:
 * Drop Multiplier:
 * - Allows you to adjust the multipliers for EXP gained, Gold gained, and
 *   Drop rates from x2 to x1024.
 *
 * ---
 * 
 * === Spawners ===
 * 
 * These options adjust the Playtest Spawner-related aspects of the game.
 * 
 * ---
 *
 * Spawn Items:
 * Spawn Weapons:
 * Spawn Armors:
 * - Sends you to a "shop" where you can purchase any of the game's named items
 *   for 0 gold each.
 *
 * ---
 * 
 * === Debug ===
 * 
 * These options adjust the Playtest Debug-related aspects of the game.
 * 
 * ---
 *
 * Debug Menu:
 * - Sends you to the Debug Menu Scene.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Options Settings
 * ============================================================================
 *
 * Allows you to adjust some default settings that may affect the way the
 * Options Menu Scene looks and/or some of the options available inside it.
 *
 * ---
 *
 * Categories
 * 
 *   Category Window Style:
 *   - How do you wish to draw commands in the Category Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Category Text Align:
 *   - Text alignment for the Command Window.
 * 
 *   Background Type:
 *   - Select background type for this window.
 *
 * ---
 * 
 * Options Window
 * 
 *   Background Type:
 *   - Select background type for this window.
 * 
 * ---
 *
 * Button Assist Window
 *
 *   Switch Category:
 *   - Button assist text used for switching categories.
 *   - For VisuStella MZ's Core Engine's Button Assist Window.
 * 
 *   Background Type:
 *   - Select background type for this window.
 *   - Requires VisuMZ_0_CoreEngine!
 *
 * ---
 *
 * Sound
 * 
 *   Cursor Sounds:
 *   OK Sounds:
 *   Cancel Sounds:
 *   Buzzer Sounds:
 *   - SE files player can select from for OK SE.
 *   - The first in the list will always be the default SE.
 *
 * ---
 *
 * Text
 * 
 *   Font Options:
 *   - Available fonts for the player to select from.
 *   - The first font in the list is always be the default font.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Options Categories
 * ============================================================================
 *
 * Here, you can add/edit/remove the categories found in the Options Menu Scene
 * and their related Options.
 *
 * ---
 *
 * Options Categories
 * 
 *   Name:
 *   - The name of this category as seen in the Category Window.
 *   - Text codes are supported.
 * 
 *   Icon:
 *   - Icon used for this category.
 *   - Use 0 for no icon.
 * 
 *   JS: Show/Hide:
 *   - Code used to determine if this category is visible.
 * 
 *   Options List:
 *   - Add options to this category here.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Listed Options
 * ============================================================================
 *
 * These are the Options found within an Options Category's List. Add, edit,
 * and/or remove them as you see fit. Adding or altering an option will require
 * adequate knowledge of JavaScript to do so.
 *
 * ---
 *
 * Basic
 * 
 *   Symbol:
 *   - Symbol used for this option when selected.
 *   - Make sure this is unique from other symbols.
 * 
 *   Icon:
 *   - Icon used for this option.
 *   - Use 0 for no icon.
 * 
 *   STR: Text:
 *   - Displayed text used for this option.
 *   - If this has a value, ignore the JS: Text version.
 * 
 *   JS: Text:
 *   - JavaScript code used to determine string used for the displayed name.
 *
 * ---
 *
 * Accessibility
 * 
 *   JS: Show/Hide:
 *   - Code used to determine if this option is visible.
 * 
 *   JS: Enable:
 *   - Code used to determine if this option is enabled.
 *   - This does NOT determine the ON/OFF value of the option. It instead
 *     determines if the option can be changed (enabled) or not (disabled).
 * 
 *   JS: Ext:
 *   - Code used to determine if this option's ext value.
 *
 * ---
 *
 * Functions
 * 
 *   JS: Draw Option:
 *   - Code used to draw this item into the List Window.
 * 
 *   JS: Process OK:
 *   - Code used when OK button is pressed while selected.
 * 
 *   JS: Cursor Right:
 *   - Code used when Right button is pressed while selected.
 * 
 *   JS: Cursor Left:
 *   - Code used when Left button is pressed while selected.
 *
 * ---
 *
 * Data
 * 
 *   JS: Default Value:
 *   - Code used to determine the default value of this option.
 *   - This is what determines the default ON/OFF values of an option.
 * 
 *   JS: Save Option:
 *   - Code used when saving this options setting.
 * 
 *   JS: Load Option:
 *   - Code used when loading this options setting.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Master Volume Shortcut Settings
 * ============================================================================
 *
 * Settings regarding the Master Volume Shortcut keys. Requires the
 * Options Core to allow players to adjust the master volume.
 * 
 * Shortcut: Ctrl + PageUp / Ctrl + PageDn
 *
 * ---
 *
 * Shortcut
 * 
 *   Enabled?:
 *   - Enable the shortcut?
 *   - Shortcut: Ctrl + PageUp / Ctrl + PageDn
 * 
 *   Shortcut Change Value:
 *   - What is the change amount for the shortcut key?
 *   - Master volume caps at 0 and 100.
 *
 * ---
 *
 * Sound Effects > Volume Up
 * 
 *   Filename:
 *   - Filename of the sound effect played.
 * 
 *   Volume:
 *   - Volume of the sound effect played.
 * 
 *   Pitch:
 *   - Pitch of the sound effect played.
 * 
 *   Pan:
 *   - Pan of the sound effect played.
 *
 * ---
 *
 * Sound Effects > Volume Down
 * 
 *   Filename:
 *   - Filename of the sound effect played.
 * 
 *   Volume:
 *   - Volume of the sound effect played.
 * 
 *   Pitch:
 *   - Pitch of the sound effect played.
 * 
 *   Pan:
 *   - Pan of the sound effect played.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.23: June 15, 2023
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Voice Acting Control and Battle Voices
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the Audio plugin parameters found in the Options Category
 *      plugin parameter settings to your current project.
 * * Documentation Update!
 * ** Help file updated for new features.
 * 
 * Version 1.22: January 20, 2023
 * * Added compatibility functionality for future plugin:
 * ** Animated Message Text Effects
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the UI plugin parameters found in the Options Category plugin
 *      parameter settings to your current project.
 * 
 * Version 1.21: October 27, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Added compatibility functionality for future plugin:
 * ** Tutorial Panel System
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General and Audio settings found in the Options Category
 *      plugin parameter to your current project.
 * * New Features!
 * ** Added "Master Volume Shortcut" Plugin Parameters.
 * *** Change the master volume anywhere in the game as long as the Options
 *     Core allows players to adjust the Master Volume.
 * *** Shortcut: Ctrl + PageUp / Ctrl + PageDn
 * 
 * Version 1.20: September 15, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Button Assist Window no longer follows the Core Engine's Option Scene
 *    settings, but instead follows the Button Assist Window's settings.
 *    Update made by Arisu.
 * * New Features!
 * ** New Plugin Parameters added by Arisu:
 * *** Parameters > Options Settings > Categories > Background Type
 * *** Parameters > Options Settings > Options Window > Background Type
 * *** Parameters > Options Settings > Button Assist Window > Background Type
 * **** Select background type for this window.
 * 
 * Version 1.19: August 11, 2022
 * * Feature Update!
 * ** VisuMZ Core Engine menu layout window settings now apply to all windows
 *    found in the Options Scene. Update made by Arisu.
 * 
 * Version 1.18: March 3, 2022
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins: "Movement Effects",
 *    "Weather Effects", and "Lighting Effects". Hold on tight!
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General and Audio settings found in the Options Category
 *      plugin parameter to your current project.
 * 
 * Version 1.17: December 30, 2021
 * * Bug Fixes!
 * ** Residual old code is now disabled from appearing on deployed projects if
 *    any carry over config data is brought over from the playtesting phase.
 * ** Yep, again again.
 * ** We had to call in the big boss to fix this.
 * 
 * Version 1.16: December 23, 2021
 * * Bug Fixes!
 * ** Residual old code is now disabled from appearing on deployed projects if
 *    any carry over config data is brought over from the playtesting phase.
 *    Fix made by Arisu.
 * ** Yep, again.
 * 
 * Version 1.15: December 16, 2021
 * * Bug Fixes!
 * ** Residual old code is now disabled from appearing on deployed projects if
 *    any carry over config data is brought over from the playtesting phase.
 *    Fix made by Arisu.
 * 
 * Version 1.14: December 9, 2021
 * * Compatibility Update!
 * ** Full Screen options have been updated to match the newest version of RPG
 *    Maker MZ's NodeJS client. Update made by Olivia.
 * *** The "Full Screen" settings have been updated in General settings. If
 *     you want to acquire these updated settings for an already-existing
 *     project, do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General settings found in the Options Category plugin
 *      parameter to your current project.
 * 
 * Version 1.13: April 23, 2021
 * * Documentation Update!
 * ** Added clarity for some of the JS plugin parameters:
 * *** JS: Enable:
 * **** This does NOT determine the ON/OFF value of the option. It instead
 *      determines if the option can be changed (enabled) or not (disabled).
 * *** JS: Default Value:
 * **** This is what determines the default ON/OFF values of an option.
 * 
 * Version 1.12: April 9, 2021
 * * Bug Fixes!
 * ** Turning Touch UI off should no longer disable the Button Assist Text for
 *    the Page Up/Down buttons from the Core Engine. Fix made by Olivia.
 * 
 * Version 1.11: April 2, 2021
 * * Bug Fixes!
 * ** Default "Special Effects" option added in v1.10 should now have a fixed
 *    load data sequence that does not force open the FPS counter. To acquire
 *    the fixed settings, do either of the following:
 * *** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * *** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General settings found in the Options Category plugin
 *      parameter to your current project.
 * * Documentation Update!
 * ** Added "Understanding Options" section.
 * ** Options Category: General section updated with "Special Effects" which
 *    was left out of the v1.10 update.
 * * Feature Update!
 * ** Default settings will now run regardless of undefined setting provided
 *    that their other conditions for usage have showed up first. This is to
 *    reduce confusion for users. Update made by Yanfly.
 * 
 * Version 1.10: March 12, 2021
 * * Compatibility Update!
 * ** Added compatibility for VisuStella MZ Bright Effects and Horror Effects.
 * *** "Special Effects" option allows users to turn on/off filters applied by
 *     the Bright Effects and Horror Effects plugins.
 * *** The "Special Effects" settings have been added to General settings. If
 *     you want to acquire these settings for an already-existing project, do
 *     either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General settings found in the Options Category plugin
 *      parameter to your current project.
 * * Documentation Update!
 * ** Added Bright Effects and Horror Effects to the list of plugins with Extra
 *    Features. Update made by Olivia.
 * 
 * Version 1.09: January 29, 2021
 * * Compatibility Update
 * ** Added compatibility for Tome571/TF's "Advanced Sound Options plugin".
 * *** Default settings have been added to the Audio settings. If you want to
 *     acquire these settings for an already-existing project, do either of the
 *     following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the Audio settings found in the Options Category plugin
 *      parameter to your current project.
 * 
 * Version 1.08: January 8, 2021
 * * Bug Fixes!
 * ** JS: Enabled accessibility option should now be working properly.
 * * Feature Update!
 * ** Disabled options should now be faded out completely.
 * 
 * Version 1.07: November 15, 2020
 * * Optimization update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.06: November 8, 2020
 * * Feature Update!
 * ** Modern Controls compatibility with Core Engine no longer enables the
 *    Item Categories window and child classes to utilize the Home/End keys.
 *
 * Version 1.05: October 18, 2020
 * * Optimization update!
 * 
 * Version 1.04: September 27, 2020
 * * Compatibility Update!
 * ** This plugin should offer better compatibility for future plugins!
 *    Update made by Yanfly.
 * 
 * Version 1.03: September 20, 2020
 * * Compatibility Update!
 * ** This plugin should offer better compatibility for future plugins!
 *    Update made by Yanfly.
 * 
 * Version 1.02: September 13, 2020
 * * Optimization Update!
 * ** Scrolling through menus should consume less resources.
 * 
 * Version 1.01: August 30, 2020
 * * Bug Fixes!
 * ** Before, already existing Options available in the RPG Maker MZ base code
 *    such as BGM Volume, Command Remember, Always Dash, and so on, would not
 *    have their default values declared through the Options Core. The Options
 *    Core now changes this functionality and gives priority to the Plugin
 *    Parameter settings declared by the game dev. Fix made by Yanfly.
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param OptionsCore
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param OptionsSettings:struct
 * @text Options Settings
 * @type struct<OptionsSettings>
 * @desc General settings pertaining to options found here.
 * @default {"Categories":"","CategoryStyle:str":"auto","CategoryTextAlign:str":"center","Sound":"","SFXCursorList:arraystr":"[\"Default\",\"Book2\",\"Coin\",\"Cursor1\",\"Cursor2\",\"Hammer\",\"Key\",\"Knock\",\"Open1\",\"Open2\",\"Open3\",\"Paralyze1\"]","SFXOKList:arraystr":"[\"Default\",\"Bell3\",\"Computer\",\"Decision2\",\"Flash1\",\"Bell3\",\"Cat\",\"Item1\",\"Item2\",\"Item3\",\"Ice4\",\"Decision1\"]","SFXCancelList:arraystr":"[\"Default\",\"Absorb1\",\"Book1\",\"Cancel1\",\"Cancel2\",\"Raise2\",\"Skill1\",\"Dog\",\"Shot2\",\"Ice3\",\"Magic1\",\"Magic2\"]","SFXBuzzerList:arraystr":"[\"Default\",\"Buzzer2\",\"Fall\",\"Skill2\",\"Shot3\",\"Bell1\",\"Crow\",\"Horn\",\"Ice2\",\"Magic3\",\"Open4\",\"Buzzer1\"]","Text":"","FontFaces:arraystr":"[\"Default\",\"Arial\",\"Candara\",\"Calibri\",\"Garamond\",\"Georgia\",\"Gill Sans MT\",\"Helvetica\",\"Impact\",\"Lato\",\"Rockwell\",\"Segoe UI\",\"Tahoma\",\"Times\",\"Trebuchet MS\",\"Verdana\"]","ButtonAssist":"","buttonAssistCategory:str":"Switch Category"}
 *
 * @param Categories:arraystruct
 * @text Options Categories
 * @type struct<Categories>[]
 * @desc Add categories and their options here.
 * @default ["{\"Name:str\":\"General\",\"Icon:num\":\"245\",\"ShowJS:func\":\"\\\"// Return Boolean\\\\nreturn true;\\\"\",\"List:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Exploration\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"alwaysDash\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"82\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.alwaysDash;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"autosave\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"225\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.autosaveOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_1_SaveCore &&\\\\\\\\\\\\\\\\n    VisuMZ.SaveCore.Settings.AutosaveOption.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"showCompass\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"222\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.showCompass;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_4_ProximityCompass &&\\\\\\\\\\\\\\\\n    VisuMZ.ProximityCompass.Settings.Options.AddShowOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"compassSize\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"222\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.compassSize;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_4_ProximityCompass &&\\\\\\\\\\\\\\\\n    VisuMZ.ProximityCompass.Settings.Options.AddSizeOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(20);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(21);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconsole.log((Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked()))\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 50;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(50, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(50, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(50, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 100;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"questTrackerShow\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"186\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.questTrackerShow;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_QuestSystem &&\\\\\\\\\\\\\\\\n    VisuMZ.QuestSystem.Settings.Tracker.AddShowOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"questTrackerPosition\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"186\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.questTrackerPosition;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_QuestSystem &&\\\\\\\\\\\\\\\\n    VisuMZ.QuestSystem.Settings.Tracker.AddShowOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = TextManager.questTrackerPosOff;\\\\\\\\\\\\\\\\nconst on  = TextManager.questTrackerPosOn;\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"randomEncounters\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"76\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Random Encounters\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst speedText = ['None', 'Half', 'Normal'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 3; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = speedText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 2 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 2);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 2;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"showTutorials\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"189\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.tutorial.optionsCmd;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_TutorialPanelSys &&\\\\\\\\\\\\\\\\n    VisuMZ.TutorialPanelSys.Settings.Options.AddTutorialsOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Battle\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"battleAniShow\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Show Battle Animations';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_1_OptionsCore;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst showText = ['OFF', 'SOME', 'ON'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 3; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = showText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 2 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 2);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 2;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"battleAniSpeed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Battle Animation Speed\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 4;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst speedText = ['Normal', 'Fast', 'Faster', 'Fastest'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 4; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = speedText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 3 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 3);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 3);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 3);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 3);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 3);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"battleCamera\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.battleCameraOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_3_ActSeqCamera && VisuMZ.ActSeqCamera.Settings.Options.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"commandRemember\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.commandRemember;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"atbActive\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Active Battle Style\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_BattleSystemATB && BattleManager.isATB();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'Wait';\\\\\\\\\\\\\\\\nconst on  = 'Active';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = $dataSystem.battleSystem === 1;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"atbSpeed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Active Battle Speed\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_BattleSystemATB && BattleManager.isATB();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 5;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.ctGaugeColor1();\\\\\\\\\\\\\\\\nconst color2 = ColorManager.ctGaugeColor2();\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nfor (let i = 1; i <= 5; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(true);\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * (i - 1));\\\\\\\\\\\\\\\\n    this.contents.fillRect(sx, gy, segment, 12, color0);\\\\\\\\\\\\\\\\n    if (value >= i) this.contents.gradientFillRect(sx + 1, gy + 1, segment - 2, 10, color1, color2);\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    this.drawText(i, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 5 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 1;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(1, 5);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(1, 5);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(1, 5);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 3;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(1, 5);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(1, 5);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"autoBattleAtStart\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.autoBattleStart;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.AutoBattle.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"autoBattleUseSkills\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.autoBattleStyle;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.AutoBattle.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = VisuMZ.BattleCore.Settings.AutoBattle.StyleOFF;\\\\\\\\\\\\\\\\nconst on  = VisuMZ.BattleCore.Settings.AutoBattle.StyleON;\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Screen\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"displayFPS\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"245\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Display FPS\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nif (!value) {\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"block\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._showFps = true;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"none\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"block\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._showFps = true;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"none\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\\nGraphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"none\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\\nif (config[symbol]) {\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"block\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._showFps = true;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"fullScreen\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"245\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Full Screen\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Utils.isNwjs();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'Window Mode';\\\\\\\\\\\\\\\\nconst on  = 'Full Screen';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nGraphics._switchFullScreen();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._requestFullScreen();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._cancelFullScreen();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"stretchScreen\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"245\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Stretch Screen\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = !!Graphics._stretchEnabled;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nGraphics._switchStretchMode();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._stretchEnabled;\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._stretchEnabled = true;\\\\\\\\\\\\\\\\n    Graphics._updateAllElements();\\\\\\\\\\\\\\\\n    Graphics._stretchScreenOptionsCore();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._stretchEnabled;\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._stretchEnabled = false;\\\\\\\\\\\\\\\\n    Graphics._updateAllElements();\\\\\\\\\\\\\\\\n    Graphics._stretchScreenOptionsCore();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = !!Graphics._stretchEnabled;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\\nif (ConfigManager[symbol]) {\\\\\\\\\\\\\\\\n    Graphics._stretchEnabled = true;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    Graphics._stretchEnabled = false;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nGraphics._updateAllElements();\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"specialEffects\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"87\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Special Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_BrightEffects ||\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_HorrorEffects;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"dustCloud\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"160\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.MovementEffectsOptions.DustCloud;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_MovementEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.MovementEffects.Settings.Options.AddDustCloud\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"footprints\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"141\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.MovementEffectsOptions.Footprints;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_MovementEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.MovementEffects.Settings.Options.AddFootprints\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"smoothCamera\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.MovementEffectsOptions.SmoothCamera;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_MovementEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.MovementEffects.Settings.Options.AddSmoothCamera\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"blinkingLights\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"214\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.LightingEffectsOptions.BlinkingLights;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_LightingEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.LightingEffects.Settings.Options.AddBlinkingLights\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"pulsingLights\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"214\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.LightingEffectsOptions.PulsingLights;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_LightingEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.LightingEffects.Settings.Options.AddPulsingLights\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"weatherDensity\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"65\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.weatherDensity;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_WeatherEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.WeatherEffects.Settings.Options.AddWeatherDensityOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(4);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(0);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 100;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\"}","{\"Name:str\":\"Audio\",\"Icon:num\":\"80\",\"ShowJS:func\":\"\\\"// Return Boolean\\\\nreturn true;\\\"\",\"List:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Volume\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"masterVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Master Volume\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(22);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(23);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    WebAudio.setMasterVolume(value / 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    WebAudio.setMasterVolume(value / 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    WebAudio.setMasterVolume(value / 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 100;\\\\\\\\\\\\\\\\nWebAudio.setMasterVolume(100 / 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\\nWebAudio.setMasterVolume(ConfigManager[symbol] / 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"bgmVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.bgmVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconsole.log((Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked()))\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"bgsVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.bgsVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"meVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.meVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.seVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"voiceVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.voiceVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_VoiceActControl;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"TF_AdvSoundOptions\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Advanced Sound Options\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.TFAdvancedSoundOptions;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\\nSceneManager.push(Scene_TFAudioOptions);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nif (Imported.TFAdvancedSoundOptions) {\\\\\\\\\\\\\\\\n    config.freq1Gain = TF._audio_1Gain || 0;\\\\\\\\\\\\\\\\n    config.freq2Gain = TF._audio_2Gain || 0;\\\\\\\\\\\\\\\\n    config.freq3Gain = TF._audio_3Gain || 0;\\\\\\\\\\\\\\\\n    config.freq4Gain = TF._audio_4Gain || 0;\\\\\\\\\\\\\\\\n    config.freq5Gain = TF._audio_5Gain || 0;\\\\\\\\\\\\\\\\n    config.freq6Gain = TF._audio_6Gain || 0;\\\\\\\\\\\\\\\\n    config.freq7Gain = TF._audio_7Gain || 0;\\\\\\\\\\\\\\\\n    config.freq8Gain = TF._audio_8Gain || 0;\\\\\\\\\\\\\\\\n    config.freq9Gain = TF._audio_9Gain || 0;\\\\\\\\\\\\\\\\n    config.preset = TF._audio_preset || \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Preset\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Sound Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"battleVoices\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"4\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.battleVoices;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_3_BattleVoices &&\\\\\\\\\\\\\\\\n    VisuMZ.BattleVoices.Settings.Options.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"footsteps\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"141\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.MovementEffectsOptions.Footsteps;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_MovementEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.MovementEffects.Settings.Options.AddSmoothCamera\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"msgLetterSound\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"189\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Letter Sounds\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_3_MessageSounds\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seCursor\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Cursor SFX\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = (value - 1) >= 0 ? 'Cursor %1'.format(value) : '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = 'Cursor %1'.format(value + 1);\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = (value + 1) < SoundManager.cursorSFXs.length ? 'Cursor %1'.format(value + 2) : '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cursorSFXs.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCursor();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cursorSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCursor();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cursorSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCursor();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seOK\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Confirm SFX\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = (value - 1) >= 0 ? 'Confirm %1'.format(value) : '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = 'Confirm %1'.format(value + 1);\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = (value + 1) < SoundManager.okSFXs.length ? 'Confirm %1'.format(value + 2) : '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.okSFXs.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playOk();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.okSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playOk();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.okSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playOk();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seCancel\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Cancel SFX\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = (value - 1) >= 0 ? 'Cancel %1'.format(value) : '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = 'Cancel %1'.format(value + 1);\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = (value + 1) < SoundManager.cancelSFXs.length ? 'Cancel %1'.format(value + 2) : '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cancelSFXs.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCancel();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cancelSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCancel();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cancelSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCancel();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seBuzzer\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Buzzer SFX\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = (value - 1) >= 0 ? 'Buzzer %1'.format(value) : '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = 'Buzzer %1'.format(value + 1);\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = (value + 1) < SoundManager.buzzerSFXs.length ? 'Buzzer %1'.format(value + 2) : '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.buzzerSFXs.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playBuzzer();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.buzzerSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playBuzzer();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.buzzerSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playBuzzer();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\"}","{\"Name:str\":\"UI\",\"Icon:num\":\"79\",\"ShowJS:func\":\"\\\"// Return Boolean\\\\nreturn true;\\\"\",\"List:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Windows\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"windowToneRed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"162\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Window Tone: Red\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = $gameSystem.windowTone()[0];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = ((value + 255) / (255 * 2)).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(10);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(2);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = value;\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[0];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 255 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = -255;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\n    value = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[0] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[0];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[0] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[0];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[0] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"windowToneGreen\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"164\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Window Tone: Green\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = $gameSystem.windowTone()[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = ((value + 255) / (255 * 2)).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(11);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(3);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = value;\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[1];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 255 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = -255;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\n    value = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[1] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[1];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[1] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[1];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[1] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"windowToneBlue\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"165\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Window Tone: Blue\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = $gameSystem.windowTone()[2];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = ((value + 255) / (255 * 2)).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(12);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(4);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = value;\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[2];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 255 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = -255;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\n    value = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[2] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[2];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[2] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[2];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[2] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Text\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"textFont\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"225\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Text Font\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = TextManager.optionsCoreFonts[value - 1] || '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = TextManager.optionsCoreFonts[value] || '-----';\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = TextManager.optionsCoreFonts[value + 1] || '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = TextManager.optionsCoreFonts.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refreshWindows();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = TextManager.optionsCoreFonts.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refreshWindows();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = TextManager.optionsCoreFonts.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refreshWindows();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"textSpeed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"225\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.messageCoreTextSpeed;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_1_MessageCore &&\\\\\\\\\\\\\\\\n    VisuMZ.MessageCore.Settings.TextSpeed.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 10).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(value > 10 ? 20 : 28);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(value > 10 ? 21 : 29);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = this.textSpeedStatusText();\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 11 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 1;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(1, 11);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(1, 11);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(1, 11);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = VisuMZ.MessageCore ? VisuMZ.MessageCore.Settings.TextSpeed.Default : 10;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(1, 11);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(1, 11);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"textEffects\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"79\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.textEffects;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_AniMsgTextEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.AniMsgTextEffects.Settings.Options.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Touch Input\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"touchUI\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"77\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.touchUI;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nif (Imported.VisuMZ_0_CoreEngine) {\\\\\\\\\\\\\\\\n    return !SceneManager.areButtonsHidden();\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    return true;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.updateButtonVisibility();\\\\\\\\\\\\\\\\nthis.updateWindowPositions();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.updateButtonVisibility();\\\\\\\\\\\\\\\\n    this.updateWindowPositions();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.updateButtonVisibility();\\\\\\\\\\\\\\\\n    this.updateWindowPositions();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiButtonPosition\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"77\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Button Position\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nif (Imported.VisuMZ_0_CoreEngine) {\\\\\\\\\\\\\\\\n    return !SceneManager.areButtonsHidden();\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    return true;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = '↑';\\\\\\\\\\\\\\\\nconst on  = '↓';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.updateButtonPositions();\\\\\\\\\\\\\\\\nthis.updateWindowPositions();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.updateButtonPositions();\\\\\\\\\\\\\\\\n    this.updateWindowPositions();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.updateButtonPositions();\\\\\\\\\\\\\\\\n    this.updateWindowPositions();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = uiDefault.ButtonPosition.call(this);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiHoverSelect\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"77\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Hover Select\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = uiDefault.hoverEnabled.call(this);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Menu Arrangement\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiMenuStyle\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Menu Style\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'Recommended';\\\\\\\\\\\\\\\\nconst on  = 'Custom';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiHelpPosition\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Help Window Position\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.uiMenuStyle;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = '↑';\\\\\\\\\\\\\\\\nconst on  = '↓';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle && !value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle && value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = uiDefault.HelpPosition.call(this);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiInputPosition\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Input Window Position\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.uiMenuStyle;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = '←';\\\\\\\\\\\\\\\\nconst on  = '→';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle && !value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle && value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = uiDefault.InputPosition.call(this);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Battle UI\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Provoke.AddOption) ||\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Aggro.AddOption) ||\\\\\\\\\\\\\\\\n    (BattleManager.isTpb() && Imported.VisuMZ_3_VisualAtbGauge && VisuMZ.VisualAtbGauge.Settings.Options.AddOption) ||\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.HpGauge.AddHpGaugeOption) ||\\\\\\\\\\\\\\\\n  false);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"provokeOrigin\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.provokeOrigin;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Provoke.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"aggroGauge\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.aggroGauge;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Aggro.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"visualHpGauge\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"84\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.visualHpGauge;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.HpGauge.AddHpGaugeOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"visualAtbGauge\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.visualAtbGauge;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn BattleManager.isTpb() && Imported.VisuMZ_2_BattleSystemATB && VisuMZ.BattleSystemATB.Settings.Options.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Provoke.AddOption) ||\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Aggro.AddOption) ||\\\\\\\\\\\\\\\\n    (BattleManager.isTpb() && Imported.VisuMZ_3_VisualAtbGauge && VisuMZ.VisualAtbGauge.Settings.Options.AddOption) ||\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.HpGauge.AddHpGaugeOption) ||\\\\\\\\\\\\\\\\n  false);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\"}","{\"Name:str\":\"Playtest\",\"Icon:num\":\"84\",\"ShowJS:func\":\"\\\"// Return Boolean\\\\nreturn $gameTemp.isPlaytest();\\\"\",\"List:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistMode\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"87\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Playtest Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Exploration\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistMapSpeed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"82\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Map Update Speed\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 4;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst speedText = ['Normal', 'Fast', 'Faster', 'Fastest'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 4; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = speedText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 3 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 3);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 3);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 3);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 3);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 3);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistRandomEncounters\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"76\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Random Encounters\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst speedText = ['None', 'Half', 'Normal'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 3; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = speedText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 2 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 2);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 2;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Battle\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistGodmode\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"God Mode\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistResistNegatives\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Resist Negative Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode && Imported.VisuMZ_1_SkillsStatesCore;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistInstantKO\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Instant K.O.\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistSkillCosts\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Skill Costs\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistConsumeItems\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Consume Items\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Rewards\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistExpMultiplier\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"88\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"EXP Multiplier\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 10).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(30);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(31);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = 'x%1'.format(2 ** value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 10 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 10);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistGoldMultiplier\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"314\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Gold Multiplier\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 10).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(14);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(6);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = 'x%1'.format(2 ** value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 10 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 10);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistDropMultiplier\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"176\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Drop Multiplier\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 10).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(11);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(3);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = 'x%1'.format(2 ** value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 10 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 10);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Spawners\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistSpawnItems\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"176\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Spawn Items\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Spawn Items\\\\\\\\\\\\\\\\nconst goods = [];\\\\\\\\\\\\\\\\nfor (const item of $dataItems) {\\\\\\\\\\\\\\\\n    if (item && item.name.trim() !== '') {\\\\\\\\\\\\\\\\n        goods.push([0, item.id, 1, 0]);\\\\\\\\\\\\\\\\n    }\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nSceneManager.push(Scene_Shop);\\\\\\\\\\\\\\\\nSceneManager.prepareNextScene(goods, true);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistSpawnWeapons\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Spawn Weapons\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Spawn Items\\\\\\\\\\\\\\\\nconst goods = [];\\\\\\\\\\\\\\\\nfor (const item of $dataWeapons) {\\\\\\\\\\\\\\\\n    if (item && item.name.trim() !== '') {\\\\\\\\\\\\\\\\n        goods.push([1, item.id, 1, 0]);\\\\\\\\\\\\\\\\n    }\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nSceneManager.push(Scene_Shop);\\\\\\\\\\\\\\\\nSceneManager.prepareNextScene(goods, true);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistSpawnArmors\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"137\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Spawn Armors\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Spawn Items\\\\\\\\\\\\\\\\nconst goods = [];\\\\\\\\\\\\\\\\nfor (const item of $dataArmors) {\\\\\\\\\\\\\\\\n    if (item && item.name.trim() !== '') {\\\\\\\\\\\\\\\\n        goods.push([2, item.id, 1, 0]);\\\\\\\\\\\\\\\\n    }\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nSceneManager.push(Scene_Shop);\\\\\\\\\\\\\\\\nSceneManager.prepareNextScene(goods, true);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Debug\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistCallDebug\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"89\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Debug Menu\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Call Debug Menu\\\\\\\\\\\\\\\\nSceneManager.push(Scene_Debug);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\"}"]
 *
 * @param MasterVolShortcut:struct
 * @text Master Volume Shortcut
 * @type struct<MasterVolShortcut>
 * @desc Settings regarding the Master Volume Shortcut keys.
 * Shortcut: Ctrl + PageUp / Ctrl + PageDn
 * @default {"Shortcut":"","Enable:eval":"true","change:num":"10","Sfx":"","VolUpSfx":"","upName:str":"Up1","upVolume:num":"90","upPitch:num":"100","upPan:num":"0","VolDnSfx":"","downName:str":"Down1","downVolume:num":"90","downPitch:num":"100","downPan:num":"0"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Categories List
 * ----------------------------------------------------------------------------
 */
/*~struct~Categories:
 *
 * @param Name:str
 * @text Name
 * @desc The name of this category as seen in the Category Window.
 * Text codes are supported.
 * @default Untitled
 *
 * @param Icon:num
 * @text Icon
 * @parent Name:str
 * @desc Icon used for this category.
 * Use 0 for no icon.
 * @default 0
 *
 * @param ShowJS:func
 * @text JS: Show/Hide
 * @parent Name:str
 * @type note
 * @desc Code used to determine if this category is visible.
 * @default "// Return Boolean\nreturn true;"
 *
 * @param List:arraystruct
 * @text Options List
 * @type struct<Options>[]
 * @desc Add options to this category here.
 * @default []
 *
 */
/* ----------------------------------------------------------------------------
 * Options List
 * ----------------------------------------------------------------------------
 */
/*~struct~Options:
 *
 * @param Symbol:str
 * @text Symbol
 * @desc Symbol used for this option when selected.
 * Make sure this is unique from other symbols.
 * @default Symbol
 *
 * @param Icon:num
 * @text Icon
 * @parent Symbol:str
 * @desc Icon used for this option.
 * Use 0 for no icon.
 * @default 0
 *
 * @param TextStr:str
 * @text STR: Text
 * @parent Symbol:str
 * @desc Displayed text used for this option.
 * If this has a value, ignore the JS: Text version.
 * @default Untitled
 *
 * @param TextJS:func
 * @text JS: Text
 * @parent Symbol:str
 * @type note
 * @desc JavaScript code used to determine string used for the displayed name.
 * @default "return 'Text';"
 *
 * @param Accessibility
 *
 * @param ShowJS:func
 * @text JS: Show/Hide
 * @parent Accessibility
 * @type note
 * @desc Code used to determine if this option is visible.
 * @default "// Return Boolean\nreturn true;"
 *
 * @param EnableJS:func
 * @text JS: Enable
 * @parent Accessibility
 * @type note
 * @desc Code used to determine if this option is enabled.
 * @default "// Return Boolean\nreturn true;"
 *
 * @param ExtJS:func
 * @text JS: Ext
 * @parent Accessibility
 * @type note
 * @desc Code used to determine if this option's ext value.
 * @default "// Return Value\nreturn 0;"
 *
 * @param Functions
 *
 * @param DrawJS:func
 * @text JS: Draw Option
 * @parent Functions
 * @type note
 * @desc Code used to draw this item into the List Window.
 * @default "// Declare Constants\nconst symbol = arguments[0];\nconst index = arguments[1];\nconst title = this.commandName(index);\nconst rect = this.itemLineRect(index);\nconst quarterWidth = rect.width / 4;\nconst halfWidth = rect.width / 2;\nconst value = this.getConfigValue(symbol);\n\n// Draw Command Name\nthis.resetFontSettings();\nthis.changePaintOpacity(true);\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \"left\");\n\n// Draw Status Text\nconst off = 'OFF';\nconst on  = 'ON';\nthis.changePaintOpacity(!value);\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \"center\");\nthis.changePaintOpacity(value);\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \"center\");"
 *
 * @param ProcessOkJS:func
 * @text JS: Process OK
 * @parent Functions
 * @type note
 * @desc Code used when OK button is pressed while selected.
 * @default "// Declare Constants\nconst symbol = arguments[0];\nconst value = this.getConfigValue(symbol);\n\n// Perform Actions\nthis.setConfigValue(symbol, !value);\nthis.redrawItem(this.findSymbol(symbol));\nthis.playCursorSound();"
 *
 * @param CursorRightJS:func
 * @text JS: Cursor Right
 * @parent Functions
 * @type note
 * @desc Code used when Right button is pressed while selected.
 * @default "// Declare Constants\nconst symbol = arguments[0];\nconst value = this.getConfigValue(symbol);\nconst lastValue = value;\n\n// Perform Actions\nthis.setConfigValue(symbol, true);\nthis.redrawItem(this.findSymbol(symbol));\nif (this.getConfigValue(symbol) !== lastValue) {\n    this.playCursorSound();\n}"
 *
 * @param CursorLeftJS:func
 * @text JS: Cursor Left
 * @parent Functions
 * @type note
 * @desc Code used when Left button is pressed while selected.
 * @default "// Declare Constants\nconst symbol = arguments[0];\nconst value = this.getConfigValue(symbol);\nconst lastValue = value;\n\n// Perform Actions\nthis.setConfigValue(symbol, false);\nthis.redrawItem(this.findSymbol(symbol));\nif (this.getConfigValue(symbol) !== lastValue) {\n    this.playCursorSound();\n}"
 *
 * @param Data
 *
 * @param DefaultJS:func
 * @text JS: Default Value
 * @parent Data
 * @type note
 * @desc Code used to determine the default value of this option.
 * @default "// Declare Constants\nconst config = arguments[0];\nconst symbol = arguments[1];\n\n// Perform Actions\nConfigManager[symbol] = false;"
 *
 * @param SaveJS:func
 * @text JS: Save Option
 * @parent Data
 * @type note
 * @desc Code used when saving this options setting.
 * @default "// Declare Constants\nconst config = arguments[0];\nconst symbol = arguments[1];\n\n// Return Value\nconfig[symbol] = ConfigManager[symbol];"
 *
 * @param LoadJS:func
 * @text JS: Load Option
 * @parent Data
 * @type note
 * @desc Code used when loading this options setting.
 * @default "// Declare Constants\nconst config = arguments[0];\nconst symbol = arguments[1];\n\n// Return Value\nConfigManager[symbol] = config[symbol];"
 *
 */
/* ----------------------------------------------------------------------------
 * Options Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~OptionsSettings:
 *
 * @param Categories
 *
 * @param CategoryStyle:str
 * @text Category Window Style
 * @parent Categories
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Category Window?
 * @default auto
 *
 * @param CategoryTextAlign:str
 * @text Category Text Align
 * @parent Categories
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Command Window.
 * @default center
 *
 * @param categoryWindowBgType:num
 * @text Background Type
 * @parent Categories
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param OptionsWindow
 * @text Options Window
 *
 * @param optionsWindowBgType:num
 * @text Background Type
 * @parent OptionsWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ButtonAssist
 * @text Button Assist Window
 *
 * @param buttonAssistCategory:str
 * @text Switch Category
 * @parent ButtonAssist
 * @desc Button assist text used for switching categories.
 * For VisuStella MZ's Core Engine's Button Assist Window.
 * @default Switch Category
 *
 * @param buttonAssistBgType:num
 * @text Background Type
 * @parent ButtonAssist
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * Requires VisuMZ_0_CoreEngine!
 * @default 0
 *
 * @param Sound
 *
 * @param SFXCursorList:arraystr
 * @text Cursor Sounds
 * @parent Sound
 * @type file[]
 * @dir audio/se/
 * @desc SE files player can select from for cursor SE.
 * The first in the list will always be the default SE.
 * @default ["Default"]
 *
 * @param SFXOKList:arraystr
 * @text OK Sounds
 * @parent Sound
 * @type file[]
 * @dir audio/se/
 * @desc SE files player can select from for OK SE.
 * The first in the list will always be the default SE.
 * @default ["Default"]
 *
 * @param SFXCancelList:arraystr
 * @text Cancel Sounds
 * @parent Sound
 * @type file[]
 * @dir audio/se/
 * @desc SE files player can select from for cancel SE.
 * The first in the list will always be the default SE.
 * @default ["Default"]
 *
 * @param SFXBuzzerList:arraystr
 * @text Buzzer Sounds
 * @parent Sound
 * @type file[]
 * @dir audio/se/
 * @desc SE files player can select from for buzzer SE.
 * The first in the list will always be the default SE.
 * @default ["Default"]
 *
 * @param Text
 *
 * @param FontFaces:arraystr
 * @text Font Options
 * @parent Text
 * @type string[]
 * @desc Available fonts for the player to select from.
 * The first font in the list is always be the default font.
 * @default ["Default","Arial","Verdana","Times New Roman"]
 *
 */
/* ----------------------------------------------------------------------------
 * Master Volume Shortcut Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MasterVolShortcut:
 * 
 * @param Shortcut
 *
 * @param Enable:eval
 * @text Enabled?
 * @parent Shortcut
 * @type boolean
 * @on Enable Shortcut
 * @off Disable Shortcut
 * @desc Enable the shortcut?
 * Shortcut: Ctrl + PageUp / Ctrl + PageDn
 * @default true
 *
 * @param change:num
 * @text Shortcut Change Value
 * @parent Shortcut
 * @type number
 * @min 1
 * @max 100
 * @desc What is the change amount for the shortcut key?
 * Master volume caps at 0 and 100.
 * @default 10
 * 
 * @param Sfx
 * @text Sound Effects
 * 
 * @param VolUpSfx
 * @text Volume Up
 * @parent Sfx
 *
 * @param upName:str
 * @text Filename
 * @parent VolUpSfx
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Up1
 *
 * @param upVolume:num
 * @text Volume
 * @parent VolUpSfx
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param upPitch:num
 * @text Pitch
 * @parent VolUpSfx
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param upPan:num
 * @text Pan
 * @parent VolUpSfx
 * @desc Pan of the sound effect played.
 * @default 0
 * 
 * @param VolDnSfx
 * @text Volume Down
 * @parent Sfx
 *
 * @param downName:str
 * @text Filename
 * @parent VolDnSfx
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Down1
 *
 * @param downVolume:num
 * @text Volume
 * @parent VolDnSfx
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param downPitch:num
 * @text Pitch
 * @parent VolDnSfx
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param downPan:num
 * @text Pan
 * @parent VolDnSfx
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
//=============================================================================

const _0x40271e=_0xf8f5;function _0xf8f5(_0x44221a,_0x28ae57){const _0x5030ae=_0x5030();return _0xf8f5=function(_0xf8f59d,_0x54fb53){_0xf8f59d=_0xf8f59d-0x89;let _0x1ad6ad=_0x5030ae[_0xf8f59d];return _0x1ad6ad;},_0xf8f5(_0x44221a,_0x28ae57);}(function(_0x35e53d,_0x35d63e){const _0x29ca7f=_0xf8f5,_0x5de04b=_0x35e53d();while(!![]){try{const _0x3aa594=parseInt(_0x29ca7f(0xa4))/0x1*(-parseInt(_0x29ca7f(0x1c8))/0x2)+parseInt(_0x29ca7f(0x130))/0x3+-parseInt(_0x29ca7f(0x22c))/0x4+-parseInt(_0x29ca7f(0x1e1))/0x5+-parseInt(_0x29ca7f(0x21f))/0x6*(parseInt(_0x29ca7f(0xb2))/0x7)+parseInt(_0x29ca7f(0x1e6))/0x8+parseInt(_0x29ca7f(0x19a))/0x9;if(_0x3aa594===_0x35d63e)break;else _0x5de04b['push'](_0x5de04b['shift']());}catch(_0x5dd576){_0x5de04b['push'](_0x5de04b['shift']());}}}(_0x5030,0x29a29));var label=_0x40271e(0x1e9),tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x40271e(0x24a)](function(_0x23756e){const _0x14f0e8=_0x40271e;return _0x23756e[_0x14f0e8(0x93)]&&_0x23756e[_0x14f0e8(0x198)][_0x14f0e8(0x18f)]('['+label+']');})[0x0];VisuMZ[label][_0x40271e(0x1ea)]=VisuMZ[label][_0x40271e(0x1ea)]||{},VisuMZ[_0x40271e(0x123)]=function(_0x1ee50d,_0x301f47){const _0x3abb9f=_0x40271e;for(const _0x275625 in _0x301f47){if('VOEBW'===_0x3abb9f(0x122)){const _0x4fb9db=_0x1799ed['OptionsCore'][_0x3abb9f(0x1ea)][_0x3abb9f(0x263)];if(this[_0x3abb9f(0xf5)]){const _0x27d1a3=_0x4fb9db['categoryWindowBgType']??0x0;this[_0x3abb9f(0xf5)][_0x3abb9f(0x250)](_0x27d1a3);}if(this['_optionsWindow']){const _0x1db512=_0x4fb9db[_0x3abb9f(0xa8)]??0x0;this[_0x3abb9f(0x155)][_0x3abb9f(0x250)](_0x1db512);}if(this[_0x3abb9f(0x18a)]){const _0x11af18=_0x4fb9db[_0x3abb9f(0x24b)]??0x0;this[_0x3abb9f(0x18a)][_0x3abb9f(0x250)](_0x11af18);}}else{if(_0x275625[_0x3abb9f(0x14c)](/(.*):(.*)/i)){if(_0x3abb9f(0xa6)!==_0x3abb9f(0x152)){const _0x1820c3=String(RegExp['$1']),_0x407f63=String(RegExp['$2'])[_0x3abb9f(0x8f)]()[_0x3abb9f(0x20c)]();let _0x177911,_0x324291,_0x8e6878;switch(_0x407f63){case _0x3abb9f(0x1f1):_0x177911=_0x301f47[_0x275625]!==''?Number(_0x301f47[_0x275625]):0x0;break;case _0x3abb9f(0xbc):_0x324291=_0x301f47[_0x275625]!==''?JSON[_0x3abb9f(0x1d0)](_0x301f47[_0x275625]):[],_0x177911=_0x324291[_0x3abb9f(0x170)](_0x5e59d2=>Number(_0x5e59d2));break;case _0x3abb9f(0x1b1):_0x177911=_0x301f47[_0x275625]!==''?eval(_0x301f47[_0x275625]):null;break;case _0x3abb9f(0x8b):_0x324291=_0x301f47[_0x275625]!==''?JSON[_0x3abb9f(0x1d0)](_0x301f47[_0x275625]):[],_0x177911=_0x324291[_0x3abb9f(0x170)](_0x442433=>eval(_0x442433));break;case'JSON':_0x177911=_0x301f47[_0x275625]!==''?JSON[_0x3abb9f(0x1d0)](_0x301f47[_0x275625]):'';break;case'ARRAYJSON':_0x324291=_0x301f47[_0x275625]!==''?JSON[_0x3abb9f(0x1d0)](_0x301f47[_0x275625]):[],_0x177911=_0x324291[_0x3abb9f(0x170)](_0x16d6b1=>JSON[_0x3abb9f(0x1d0)](_0x16d6b1));break;case _0x3abb9f(0x106):_0x177911=_0x301f47[_0x275625]!==''?new Function(JSON[_0x3abb9f(0x1d0)](_0x301f47[_0x275625])):new Function(_0x3abb9f(0x172));break;case _0x3abb9f(0x185):_0x324291=_0x301f47[_0x275625]!==''?JSON[_0x3abb9f(0x1d0)](_0x301f47[_0x275625]):[],_0x177911=_0x324291[_0x3abb9f(0x170)](_0x22a528=>new Function(JSON[_0x3abb9f(0x1d0)](_0x22a528)));break;case'STR':_0x177911=_0x301f47[_0x275625]!==''?String(_0x301f47[_0x275625]):'';break;case _0x3abb9f(0x10c):_0x324291=_0x301f47[_0x275625]!==''?JSON[_0x3abb9f(0x1d0)](_0x301f47[_0x275625]):[],_0x177911=_0x324291['map'](_0x278f95=>String(_0x278f95));break;case'STRUCT':_0x8e6878=_0x301f47[_0x275625]!==''?JSON[_0x3abb9f(0x1d0)](_0x301f47[_0x275625]):{},_0x1ee50d[_0x1820c3]={},VisuMZ[_0x3abb9f(0x123)](_0x1ee50d[_0x1820c3],_0x8e6878);continue;case _0x3abb9f(0x165):_0x324291=_0x301f47[_0x275625]!==''?JSON[_0x3abb9f(0x1d0)](_0x301f47[_0x275625]):[],_0x177911=_0x324291['map'](_0x30a5bd=>VisuMZ[_0x3abb9f(0x123)]({},JSON['parse'](_0x30a5bd)));break;default:continue;}_0x1ee50d[_0x1820c3]=_0x177911;}else return!_0x1354e3['isInputting']()&&!this['_battleAniSpeedLooping']&&!_0x5341ac[_0x3abb9f(0x1de)]();}}}return _0x1ee50d;},(_0x2ea817=>{const _0x37e94c=_0x40271e,_0x1d7950=_0x2ea817['name'];for(const _0x1ee08 of dependencies){if(_0x37e94c(0x253)!=='JVsNK')this['onTouchOk']();else{if(!Imported[_0x1ee08]){alert(_0x37e94c(0x144)[_0x37e94c(0x25a)](_0x1d7950,_0x1ee08)),SceneManager[_0x37e94c(0x8e)]();break;}}}const _0x2ee309=_0x2ea817['description'];if(_0x2ee309[_0x37e94c(0x14c)](/\[Version[ ](.*?)\]/i)){if('kxGCS'!=='SPJXg'){const _0x2bd9af=Number(RegExp['$1']);_0x2bd9af!==VisuMZ[label][_0x37e94c(0x1eb)]&&(alert('%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.'[_0x37e94c(0x25a)](_0x1d7950,_0x2bd9af)),SceneManager[_0x37e94c(0x8e)]());}else return _0x492af5[_0x37e94c(0x202)][_0x37e94c(0xf3)](this);}if(_0x2ee309[_0x37e94c(0x14c)](/\[Tier[ ](\d+)\]/i)){const _0x141384=Number(RegExp['$1']);_0x141384<tier?(alert('%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.'['format'](_0x1d7950,_0x141384,tier)),SceneManager[_0x37e94c(0x8e)]()):tier=Math[_0x37e94c(0x140)](_0x141384,tier);}VisuMZ[_0x37e94c(0x123)](VisuMZ[label][_0x37e94c(0x1ea)],_0x2ea817[_0x37e94c(0x1fa)]);})(pluginData),VisuMZ['OptionsCore'][_0x40271e(0x1fc)]=Scene_Boot[_0x40271e(0x1fb)][_0x40271e(0x158)],Scene_Boot[_0x40271e(0x1fb)][_0x40271e(0x158)]=function(){const _0x334701=_0x40271e;this['process_VisuMZ_OptionsCore_DefaultLoad'](),VisuMZ['OptionsCore'][_0x334701(0x1fc)][_0x334701(0xf3)](this),SoundManager[_0x334701(0xf1)](),this[_0x334701(0xe8)](),!Utils[_0x334701(0x211)](_0x334701(0xc0))&&(_0x334701(0x238)!=='ypjSV'?(_0x451551(_0x334701(0x206)[_0x334701(0x25a)](_0x613077,_0x1793dc,_0x2a7bfd)),_0x1b45b7[_0x334701(0x8e)]()):ConfigManager[_0x334701(0x1a8)]=![]);},Scene_Boot[_0x40271e(0x1fb)]['process_VisuMZ_OptionsCore_DefaultLoad']=function(){const _0x2b21f6=_0x40271e,_0x43f6f7=['alwaysDash','commandRemember',_0x2b21f6(0x10d),'bgmVolume',_0x2b21f6(0x1d9),'meVolume',_0x2b21f6(0x267)];for(const _0x1cd76e of VisuMZ[_0x2b21f6(0x1e9)]['Settings'][_0x2b21f6(0x19d)]){if(_0x2b21f6(0x1a3)!==_0x2b21f6(0x137))for(const _0x5374b7 of _0x1cd76e[_0x2b21f6(0x1c4)]){if(!_0x5374b7)continue;const _0x2921c5=_0x5374b7['Symbol'];if(!_0x2921c5)continue;if(_0x43f6f7['includes'](_0x2921c5))ConfigManager[_0x2921c5]=undefined;_0x5374b7['DefaultJS'][_0x2b21f6(0xf3)](this,ConfigManager,_0x2921c5);}else _0x40ef16['assistMode']=![];}},Scene_Boot[_0x40271e(0x1fb)]['process_VisuMZ_OptionsCore_Failsafe']=function(){const _0x1b4c10=_0x40271e;if(VisuMZ[_0x1b4c10(0x1e9)][_0x1b4c10(0x9a)]())return;const _0xab7d0c='0abCdefghijklmnopqrstuvwxyz',_0x4e286c=[0x3,0x8,0x5,0x1,0x14,0x13],_0x4f3b20=_0x4e286c[_0x1b4c10(0x23e)]((_0x59782f,_0x487bb2)=>_0x59782f+_0xab7d0c[_0x487bb2],''),_0x57c95c={'Name:str':_0x4f3b20,'Icon:num':'7','ShowJS:func':_0x1b4c10(0xb0),'List:arraystruct':_0x1b4c10(0x1e5)};Window_OptionsCategory[_0x1b4c10(0x1a4)]['push'](VisuMZ[_0x1b4c10(0x123)](_0x57c95c,_0x57c95c));},VisuMZ['OptionsCore'][_0x40271e(0x9a)]=function(){const _0x1cabf4=_0x40271e,_0xaa71ef='0abCdefghijklmnopqrstuvwxyz',_0x224ad5=[0x1,0x13,0x13,0x9,0x13,0x14,0xd,0xf,0x4,0x5],_0x247e7f=_0x224ad5['reduce']((_0x50e82e,_0x39a918)=>_0x50e82e+_0xaa71ef[_0x39a918],'');for(const _0x3fc9bf of Window_OptionsCategory[_0x1cabf4(0x1a4)]){if(!_0x3fc9bf)continue;for(const _0x12aca2 of _0x3fc9bf[_0x1cabf4(0x1c4)]){if(_0x1cabf4(0x1c3)!==_0x1cabf4(0x204)){if(!_0x12aca2)continue;if(_0x12aca2[_0x1cabf4(0xe2)][_0x1cabf4(0x236)]()['trim']()===_0x247e7f)return!![];}else{if(this[_0x1cabf4(0xb1)]())return;_0x2628eb[_0x1cabf4(0x1fb)][_0x1cabf4(0x18e)][_0x1cabf4(0xf3)](this);}}}return![];},VisuMZ['OptionsCore'][_0x40271e(0x1d4)]=ConfigManager['save'],ConfigManager[_0x40271e(0x120)]=function(){const _0x4be3cd=_0x40271e;if(this[_0x4be3cd(0x213)]||this['_loading'])return;VisuMZ['OptionsCore'][_0x4be3cd(0x1d4)][_0x4be3cd(0xf3)](this);},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x145)]=ConfigManager[_0x40271e(0x1ae)],ConfigManager[_0x40271e(0x1ae)]=function(){const _0x5e4b61=_0x40271e;let _0x2e2f95=VisuMZ[_0x5e4b61(0x1e9)][_0x5e4b61(0x145)]['call'](this);;return _0x2e2f95=this['makeDataOptionsCore'](_0x2e2f95),!Utils['isOptionValid'](_0x5e4b61(0xc0))&&(_0x2e2f95[_0x5e4b61(0x1a8)]=![]),_0x2e2f95;},ConfigManager[_0x40271e(0x11a)]=function(_0x5e3b3e){const _0x2604fe=_0x40271e;this[_0x2604fe(0x213)]=!![];for(const _0x39d382 of Window_OptionsCategory[_0x2604fe(0x1a4)]){for(const _0x5be97a of _0x39d382[_0x2604fe(0x1c4)]){if(!_0x5be97a)continue;const _0x539133=_0x5be97a[_0x2604fe(0xe2)];if(!_0x539133)continue;ConfigManager[_0x539133]===undefined&&_0x5be97a[_0x2604fe(0xaf)]['call'](this,_0x5e3b3e,_0x539133),_0x5be97a['SaveJS'][_0x2604fe(0xf3)](this,_0x5e3b3e,_0x539133);}}return this[_0x2604fe(0x213)]=![],_0x5e3b3e;},VisuMZ['OptionsCore'][_0x40271e(0x233)]=ConfigManager[_0x40271e(0x17a)],ConfigManager['applyData']=function(_0x176ca5){const _0x349c48=_0x40271e;VisuMZ[_0x349c48(0x1e9)][_0x349c48(0x233)]['call'](this,_0x176ca5),this[_0x349c48(0xc9)](_0x176ca5);},ConfigManager['applyDataOptionsCore']=function(_0x1c77bd){const _0x8b2ff9=_0x40271e;this[_0x8b2ff9(0xbd)]=!![];for(const _0x34ec6b of Window_OptionsCategory[_0x8b2ff9(0x1a4)]){for(const _0x3c1825 of _0x34ec6b[_0x8b2ff9(0x1c4)]){if(_0x8b2ff9(0x195)!=='uqddx'){const _0x2d3991=_0x140c97['OptionsCore'][_0x8b2ff9(0x99)]['call'](this);if(_0x1b6a6d&&_0x5a89c7[_0x8b2ff9(0x8d)]!==_0x54c065){if(_0x35ca2d[_0x8b2ff9(0x8d)]>0x0)return _0x48cb00[_0x8b2ff9(0x25c)][_0x16c2ea[_0x8b2ff9(0x8d)]]||_0x2d3991;}return _0x2d3991;}else{if(!_0x3c1825)continue;const _0x52969b=_0x3c1825[_0x8b2ff9(0xe2)];if(!_0x52969b)continue;_0x1c77bd[_0x52969b]===undefined?_0x3c1825['DefaultJS'][_0x8b2ff9(0xf3)](this,_0x1c77bd,_0x52969b):_0x3c1825['LoadJS'][_0x8b2ff9(0xf3)](this,_0x1c77bd,_0x52969b);}}}this[_0x8b2ff9(0xbd)]=![];},Graphics['_isFPSCounterOn']=function(){const _0x18f125=_0x40271e;return this[_0x18f125(0x251)]&&this[_0x18f125(0x251)][_0x18f125(0x13b)][_0x18f125(0x173)][_0x18f125(0x1cc)]!=='none';},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x256)]=Graphics['FPSCounter'][_0x40271e(0x1fb)][_0x40271e(0x215)],Graphics['FPSCounter']['prototype'][_0x40271e(0x215)]=function(){const _0x54154a=_0x40271e;VisuMZ[_0x54154a(0x1e9)][_0x54154a(0x256)]['call'](this),this[_0x54154a(0x103)]();},Graphics[_0x40271e(0x1a0)][_0x40271e(0x1fb)]['switchModeOptionsCore']=function(){const _0x35dbf6=_0x40271e;ConfigManager&&ConfigManager[_0x35dbf6(0xb4)]!==undefined&&(ConfigManager[_0x35dbf6(0xb4)]=Graphics['_isFPSCounterOn'](),ConfigManager[_0x35dbf6(0x120)]());if(SceneManager&&SceneManager[_0x35dbf6(0x214)]){const _0x28dd69=SceneManager[_0x35dbf6(0x214)];_0x28dd69[_0x35dbf6(0xce)](),_0x28dd69[_0x35dbf6(0xd9)]===Scene_Options&&_0x28dd69[_0x35dbf6(0x193)]();}},VisuMZ[_0x40271e(0x1e9)]['Scene_Boot_start']=Scene_Boot['prototype'][_0x40271e(0x17e)],Scene_Boot['prototype'][_0x40271e(0x17e)]=function(){const _0x354195=_0x40271e;VisuMZ[_0x354195(0x1e9)]['Scene_Boot_start']['call'](this);if(ConfigManager&&ConfigManager[_0x354195(0x181)]){if(_0x354195(0x150)===_0x354195(0x159)){let _0x31660d=_0x162a9f[_0x354195(0xe6)]||0x0;while(_0x31660d--){this[_0x354195(0x190)]();}}else Graphics['_requestFullScreen']();}},VisuMZ['OptionsCore'][_0x40271e(0x175)]=Graphics[_0x40271e(0x1be)],Graphics[_0x40271e(0x1be)]=function(){const _0xab54b3=_0x40271e;this[_0xab54b3(0x1fe)]()?ConfigManager[_0xab54b3(0x181)]=![]:ConfigManager['fullScreen']=!![],ConfigManager[_0xab54b3(0x120)](),VisuMZ[_0xab54b3(0x1e9)][_0xab54b3(0x175)][_0xab54b3(0xf3)](this),Graphics[_0xab54b3(0xf7)]();},VisuMZ[_0x40271e(0x1e9)]['Graphics_requestFullScreen']=Graphics[_0x40271e(0x1f2)],Graphics['_requestFullScreen']=function(){const _0x2e907d=_0x40271e;VisuMZ[_0x2e907d(0x1e9)]['Graphics_requestFullScreen'][_0x2e907d(0xf3)](this),this['_fullScreenOptionsCore']();},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x1ef)]=Graphics[_0x40271e(0x20e)],Graphics[_0x40271e(0x20e)]=function(){const _0x3efb06=_0x40271e;VisuMZ[_0x3efb06(0x1e9)][_0x3efb06(0x1ef)]['call'](this),this[_0x3efb06(0xf7)]();},Graphics[_0x40271e(0xf7)]=function(){const _0x4b7b6a=_0x40271e;if(SceneManager&&SceneManager[_0x4b7b6a(0x214)]){const _0x378e39=SceneManager[_0x4b7b6a(0x214)];if(_0x378e39[_0x4b7b6a(0xd9)]===Scene_Options){if(_0x4b7b6a(0x146)===_0x4b7b6a(0x146))setTimeout(_0x378e39[_0x4b7b6a(0x193)][_0x4b7b6a(0xd2)](_0x378e39),0x64);else{if(this[_0x4b7b6a(0xf5)]){const _0xedce54=this[_0x4b7b6a(0x12e)]();this[_0x4b7b6a(0xf5)][_0x4b7b6a(0x1db)](_0xedce54['x'],_0xedce54['y'],_0xedce54[_0x4b7b6a(0x1ad)],_0xedce54[_0x4b7b6a(0x15e)]);}if(this[_0x4b7b6a(0x155)]){const _0x55f8a9=this[_0x4b7b6a(0x109)]();this['_optionsWindow']['move'](_0x55f8a9['x'],_0x55f8a9['y'],_0x55f8a9[_0x4b7b6a(0x1ad)],_0x55f8a9[_0x4b7b6a(0x15e)]);}if(this['_buttonAssistWindow']){const _0x2d501f=this[_0x4b7b6a(0xd7)]();this['_buttonAssistWindow'][_0x4b7b6a(0x1db)](_0x2d501f['x'],_0x2d501f['y'],_0x2d501f['width'],_0x2d501f['height']),this[_0x4b7b6a(0x18a)][_0x4b7b6a(0xa7)]();}this[_0x4b7b6a(0x193)]();}}}},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0xbf)]=Graphics[_0x40271e(0x264)],Graphics[_0x40271e(0x264)]=function(){const _0x356564=_0x40271e;VisuMZ[_0x356564(0x1e9)][_0x356564(0xbf)]['call'](this),this[_0x356564(0x1d2)]();},Graphics['_stretchScreenOptionsCore']=function(){const _0x442435=_0x40271e;ConfigManager&&ConfigManager[_0x442435(0x132)]!==undefined&&('pYRKf'==='mmVOc'?this[_0x442435(0x1b6)]=0x0:(ConfigManager[_0x442435(0x132)]=!!this[_0x442435(0x242)],setTimeout(ConfigManager[_0x442435(0x120)][_0x442435(0xd2)](ConfigManager),0x64)));if(SceneManager&&SceneManager[_0x442435(0x214)]){const _0x36c882=SceneManager[_0x442435(0x214)];_0x36c882[_0x442435(0xd9)]===Scene_Options&&setTimeout(_0x36c882['refreshWindows'][_0x442435(0xd2)](_0x36c882),0x64);}},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x22e)]={'enabled':VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x1ea)][_0x40271e(0xfe)][_0x40271e(0x116)]??!![],'change':VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x1ea)][_0x40271e(0xfe)]['change']??!![]},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x232)]=Input['isTriggered'],Input[_0x40271e(0xdd)]=function(_0x53efaa){const _0x16ae23=_0x40271e;if(VisuMZ[_0x16ae23(0x1e9)][_0x16ae23(0xb7)](_0x53efaa,![])){if(_0x16ae23(0x125)===_0x16ae23(0x125))return VisuMZ['OptionsCore'][_0x16ae23(0x1ee)](_0x53efaa),![];else{const _0x1dc33f=_0x5e459a[_0x16ae23(0x121)][_0x29b8f6[_0x16ae23(0x119)]];if(_0x1dc33f)return _0x5961f5[_0x16ae23(0x25d)](_0x1dc33f);}}return VisuMZ[_0x16ae23(0x1e9)][_0x16ae23(0x232)]['call'](this,_0x53efaa);},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0xbb)]=Input[_0x40271e(0x15b)],Input[_0x40271e(0x15b)]=function(_0x459f7e){const _0x509ae0=_0x40271e;if(VisuMZ['OptionsCore'][_0x509ae0(0xb7)](_0x459f7e,!![]))return VisuMZ[_0x509ae0(0x1e9)]['processVolumeShortcut'](_0x459f7e),![];return VisuMZ[_0x509ae0(0x1e9)][_0x509ae0(0xbb)][_0x509ae0(0xf3)](this,_0x459f7e);},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0xb7)]=function(_0xaf1834,_0xa560ef){const _0x483092=_0x40271e;if(!VisuMZ[_0x483092(0x1e9)][_0x483092(0x22e)][_0x483092(0x113)])return![];if(ConfigManager[_0x483092(0xb5)]===undefined)return![];if(!Input[_0x483092(0x1f0)]('control'))return![];if(_0xaf1834!==_0x483092(0xd5)&&_0xaf1834!==_0x483092(0x23a))return![];if(_0xa560ef)return VisuMZ[_0x483092(0x1e9)][_0x483092(0xbb)][_0x483092(0xf3)](Input,_0xaf1834);else{if(_0x483092(0x1a5)===_0x483092(0xef)){if(_0x51e1c0[_0x483092(0x1a8)]){if(this[_0x483092(0x194)]()['isActor']()&&_0x8ac205[_0x483092(0x1e0)]()){if(_0x120eeb[_0x483092(0x115)])_0x349d1f=_0xb2c3c9[_0x483092(0x140)](_0x4daea3,_0x2dfe2f['mhp']);}}_0x1f4c95[_0x483092(0x1e9)][_0x483092(0x212)]['call'](this,_0x12cbb7,_0x133959);}else return VisuMZ['OptionsCore']['Input_isTriggered'][_0x483092(0xf3)](Input,_0xaf1834);}},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x1ee)]=function(_0x19a22c){const _0x106e5a=_0x40271e,_0x8f2316=this[_0x106e5a(0x176)](_0x19a22c);this['updateOptionsCoreScene'](_0x8f2316);},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x176)]=function(_0x1fa32b){const _0x1cb5eb=_0x40271e,_0x1c3f40=VisuMZ[_0x1cb5eb(0x1e9)][_0x1cb5eb(0x22e)]['change'];let _0x12f3db=Math[_0x1cb5eb(0xb9)](WebAudio[_0x1cb5eb(0x9d)]*0x64);const _0x2f2ce5=ConfigManager[_0x1cb5eb(0xb5)];if(_0x1fa32b==='pageup'){if(_0x1cb5eb(0xe7)===_0x1cb5eb(0xe7))_0x12f3db+=_0x1c3f40;else{const _0x1db2d8=_0x5f2ceb[_0x1cb5eb(0x1ca)][_0x14a424[_0x1cb5eb(0x188)]];if(_0x1db2d8)return _0x2dcc41[_0x1cb5eb(0x25d)](_0x1db2d8);}}else _0x1fa32b===_0x1cb5eb(0x23a)&&(_0x12f3db-=_0x1c3f40);_0x12f3db=_0x12f3db[_0x1cb5eb(0x252)](0x0,0x64),ConfigManager[_0x1cb5eb(0xb5)]=_0x12f3db,ConfigManager['save'](),_0x12f3db/=0x64,WebAudio[_0x1cb5eb(0x131)](_0x12f3db);if(_0x2f2ce5!==ConfigManager['masterVolume']){if(_0x1fa32b===_0x1cb5eb(0xd5)){if(_0x1cb5eb(0x1c0)!=='qfizP')SoundManager[_0x1cb5eb(0xc3)]();else{if(_0x9c21c['assistMode']&&_0x20c1e2[_0x1cb5eb(0xe4)]===0x0)return!![];if(_0x17a4dc[_0x1cb5eb(0xdf)]===0x0)return!![];return _0x5d09b3[_0x1cb5eb(0x1e9)][_0x1cb5eb(0x13a)][_0x1cb5eb(0xf3)](this);}}else{if(_0x1fa32b===_0x1cb5eb(0x23a)){if(_0x1cb5eb(0x17f)==='DrUrg')SoundManager[_0x1cb5eb(0x9e)]();else{const _0x4cc242=this[_0x1cb5eb(0x110)];_0x4cc242[_0x1cb5eb(0x228)](_0x532dec,0x0,_0x2da8d8['y'],_0x4cc242[_0x1cb5eb(0x21b)],_0x1cb5eb(0xcc));}}}}return ConfigManager['masterVolume']!==_0x2f2ce5;},VisuMZ[_0x40271e(0x1e9)]['updateOptionsCoreScene']=function(_0x1869bf){const _0x1a03b5=_0x40271e;if(!_0x1869bf)return;const _0xeccebd=SceneManager[_0x1a03b5(0x214)];if(_0xeccebd[_0x1a03b5(0xd9)]!==Scene_Options)return;_0xeccebd[_0x1a03b5(0x155)][_0x1a03b5(0xa7)]();},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0xb8)]=DataManager[_0x40271e(0x1ed)],DataManager[_0x40271e(0x1ed)]=function(){const _0x71916e=_0x40271e,_0x37c9b5=($gameSystem?$gameSystem['windowTone']():$dataSystem['windowTone'])[_0x71916e(0x11d)](0x0);VisuMZ[_0x71916e(0x1e9)][_0x71916e(0xb8)][_0x71916e(0xf3)](this),$gameSystem[_0x71916e(0x21e)](_0x37c9b5);},SoundManager[_0x40271e(0x18d)]=JsonEx[_0x40271e(0x262)](VisuMZ[_0x40271e(0x1e9)]['Settings'][_0x40271e(0x263)]['SFXCursorList']),SoundManager[_0x40271e(0x121)]=JsonEx['makeDeepCopy'](VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x1ea)][_0x40271e(0x263)]['SFXOKList']),SoundManager[_0x40271e(0x1ca)]=JsonEx[_0x40271e(0x262)](VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x1ea)][_0x40271e(0x263)][_0x40271e(0xc1)]),SoundManager['buzzerSFXs']=JsonEx[_0x40271e(0x262)](VisuMZ['OptionsCore'][_0x40271e(0x1ea)][_0x40271e(0x263)][_0x40271e(0xd1)]),SoundManager[_0x40271e(0xf1)]=function(){const _0x38e8e2=_0x40271e,_0x387f32=[];_0x387f32[_0x38e8e2(0x266)](SoundManager[_0x38e8e2(0x18d)]),_0x387f32[_0x38e8e2(0x266)](SoundManager[_0x38e8e2(0x121)]),_0x387f32[_0x38e8e2(0x266)](SoundManager[_0x38e8e2(0x1ca)]),_0x387f32[_0x38e8e2(0x266)](SoundManager['buzzerSFXs']);let _0x145678=0x0;for(const _0x27263e of _0x387f32){for(let _0x3bd768=0x1;_0x3bd768<_0x27263e[_0x38e8e2(0xa9)];_0x3bd768++){if(_0x38e8e2(0x147)===_0x38e8e2(0x259))_0x4f742e[_0x38e8e2(0x1e9)][_0x38e8e2(0xbf)][_0x38e8e2(0xf3)](this),this[_0x38e8e2(0x1d2)]();else{const _0xa28f38=_0x27263e[_0x3bd768],_0x5e07ba=JsonEx['makeDeepCopy']($dataSystem[_0x38e8e2(0x1d7)][_0x145678]);_0x5e07ba['name']=_0xa28f38,_0x27263e[_0x3bd768]=_0x5e07ba;}}_0x145678++;}},VisuMZ[_0x40271e(0x1e9)]['SoundManager_playCursor']=SoundManager[_0x40271e(0x167)],SoundManager['playCursor']=function(){const _0x398f6a=_0x40271e;if(ConfigManager&&ConfigManager[_0x398f6a(0x163)]!==undefined){if('aQWne'===_0x398f6a(0x18c)){if(ConfigManager[_0x398f6a(0x163)]>0x0){const _0x52fc8c=SoundManager[_0x398f6a(0x18d)][ConfigManager['seCursor']];if(_0x52fc8c)return AudioManager[_0x398f6a(0x25d)](_0x52fc8c);}}else{this[_0x398f6a(0xb6)](),this[_0x398f6a(0xd4)](this[_0x398f6a(0x1ac)](_0x3c13a4));const _0x29e28b=this['_list'][_0x387d00][_0x398f6a(0x20b)];this['_currentDrawingIndex']=_0x54b9d4;try{this[_0x398f6a(0x97)][_0x2eb06b]['DrawJS'][_0x398f6a(0xf3)](this,_0x29e28b,_0x558b00);}catch(_0x748d0e){_0x5f295e[_0x398f6a(0x1e9)][_0x398f6a(0x183)][_0x398f6a(0xf3)](this,_0x1b34ef);}this[_0x398f6a(0x1aa)]=_0x1e9710;}}VisuMZ[_0x398f6a(0x1e9)][_0x398f6a(0xec)][_0x398f6a(0xf3)](this);},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0xff)]=SoundManager[_0x40271e(0x235)],SoundManager[_0x40271e(0x235)]=function(){const _0x457345=_0x40271e;if(ConfigManager&&ConfigManager[_0x457345(0x119)]!==undefined){if(ConfigManager[_0x457345(0x119)]>0x0){if('haUEp'!==_0x457345(0x174)){const _0x47f64d=SoundManager[_0x457345(0x121)][ConfigManager[_0x457345(0x119)]];if(_0x47f64d)return AudioManager[_0x457345(0x25d)](_0x47f64d);}else this[_0x457345(0xea)](_0x335af6[_0x457345(0xdd)]('pagedown'));}}VisuMZ['OptionsCore'][_0x457345(0xff)][_0x457345(0xf3)](this);},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x161)]=SoundManager['playCancel'],SoundManager[_0x40271e(0x92)]=function(){const _0x1be15e=_0x40271e;if(ConfigManager&&ConfigManager[_0x1be15e(0x188)]!==undefined){if(ConfigManager[_0x1be15e(0x188)]>0x0){if(_0x1be15e(0x129)!==_0x1be15e(0x1b0)){const _0x27d54d=SoundManager[_0x1be15e(0x1ca)][ConfigManager[_0x1be15e(0x188)]];if(_0x27d54d)return AudioManager['playStaticSe'](_0x27d54d);}else this[_0x1be15e(0x97)][_0x385f0f][_0x1be15e(0x1c7)][_0x1be15e(0xf3)](this,_0x4c9355,_0x39bfd);}}VisuMZ[_0x1be15e(0x1e9)][_0x1be15e(0x161)][_0x1be15e(0xf3)](this);},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0xfc)]=SoundManager[_0x40271e(0x1e8)],SoundManager['playBuzzer']=function(){const _0xd0d5e1=_0x40271e;if(ConfigManager&&ConfigManager[_0xd0d5e1(0x1c6)]!==undefined){if(ConfigManager[_0xd0d5e1(0x1c6)]>0x0){if(_0xd0d5e1(0x107)===_0xd0d5e1(0x22d))return _0x22b1b1[_0xd0d5e1(0x1fb)]['isHoverEnabled'][_0xd0d5e1(0xf3)](this);else{const _0x51f041=SoundManager[_0xd0d5e1(0x127)][ConfigManager[_0xd0d5e1(0x1c6)]];if(_0x51f041)return AudioManager[_0xd0d5e1(0x25d)](_0x51f041);}}}VisuMZ['OptionsCore']['SoundManager_playBuzzer'][_0xd0d5e1(0xf3)](this);},SoundManager[_0x40271e(0xc3)]=function(){const _0x4eb771=_0x40271e,_0x226985=VisuMZ[_0x4eb771(0x1e9)]['Settings']['MasterVolShortcut'],_0x5c6bd3={'name':_0x226985[_0x4eb771(0x90)],'volume':_0x226985[_0x4eb771(0x126)],'pitch':_0x226985[_0x4eb771(0xd3)],'pan':_0x226985['upPan']};AudioManager['playSe'](_0x5c6bd3);},SoundManager[_0x40271e(0x9e)]=function(){const _0x47e926=_0x40271e,_0x2e3927=VisuMZ['OptionsCore']['Settings'][_0x47e926(0xfe)],_0x2c23ee={'name':_0x2e3927['downName'],'volume':_0x2e3927[_0x47e926(0x269)],'pitch':_0x2e3927[_0x47e926(0x1d5)],'pan':_0x2e3927['downPan']};AudioManager['playSe'](_0x2c23ee);},TextManager['optionsCoreFonts']=VisuMZ['OptionsCore']['Settings'][_0x40271e(0x263)][_0x40271e(0x156)];function _0x5030(){const _0x26f841=['_fullScreenOptionsCore','dmJuL','uiMenuStyle','vyWPY','updateEffekseer','SoundManager_playBuzzer','YVRqV','MasterVolShortcut','SoundManager_playOk','WxzMk','textSizeEx','Azuer','switchModeOptionsCore','KntUD','assistResistNegatives','FUNC','FqxoF','update','optionsWindowRect','isRightInputMode','\x5cI[%1]%2','ARRAYSTR','touchUI','Window_Options_initialize','dmhgX','_commandNameWindow','processCursorMoveModernControls','drawTextEx','enabled','deselect','assistInstantKO','Enable','RhkXs','hasEncounterNone','seOK','makeDataOptionsCore','IyVFP','_doubleTouch','slice','optionsCoreUpdateWindowPositions','Scene_Map_updateMainMultiply','save','okSFXs','nBPXf','ConvertParams','commandSymbol','nfSsp','upVolume','buzzerSFXs','name','iNkrT','playCursorSound','icon','HiFGL','kaptW','categoryWindowRect','Game_Temp_requestAnimation','24789fWYZKG','setMasterVolume','stretchScreen','commandNameWindowDrawBackground','isItem','commandName','allowUpdateBattleAniSpeed','YKpTn','VeTws','deactivate','Game_Party_hasEncounterNone','_boxDiv','assistGoldMultiplier','windowTone','mainFontFace','text','max','Game_Battler_useItem','HYkBO','floor','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','ConfigManager_makeData','nWldQ','StDto','ProcessOkJS','_returnOptionsCore','drawIcon','createTextState','match','InputPosition','addWindow','drawItemStyleIconText','Wupcn','_windowLayer','uyprv','addDebuff','isHoverEnabled','_optionsWindow','FontFaces','updateMainMultiply','onDatabaseLoaded','sEoeF','gcQns','isRepeated','cursorPagedown','categoryWindowBgType','height','iconText','uiButtonPosition','SoundManager_playCancel','commandNameWindowCenter','seCursor','showFauxAnimations','ARRAYSTRUCT','shift','playCursor','Window_Options_cursorLeft','OptionsBgType','hMAMj','buttonY','LwfCB','buttonAssistText1','nYEzT','callUpdateHelp','map','isClicked','return\x200','style','OGytB','Graphics_switchFullScreen','changeMasterVolumeViaShortcut','replace','calcWindowHeight','layoutSettings','applyData','ShowJS','down','setConfigValue','start','DrUrg','auto','fullScreen','VisuMZ_0_CoreEngine','Window_Options_drawItem','processOptionsCoreFailsafe','ARRAYFUNC','EjlGb','XJeaQ','seCancel','JWopD','_buttonAssistWindow','CategoryTextAlign','aQWne','cursorSFXs','processHandling','includes','updateMain','kZVjH','uiHoverSelect','refreshWindows','subject','uqddx','CursorLeftJS','rKuDa','description','process_VisuMZ_OptionsCore_DefaultLoad','2004669jLyhdE','isBottomButtonMode','commandNameWindowDrawText','Categories','hepyT','mVBWG','FPSCounter','categories','dropItemRate','QhBka','categoryList','tdyMC','helpAreaHeight','setListWindow','assistMode','onTouchCancel','_currentDrawingIndex','boxWidth','isCommandEnabled','width','makeData','cursorPageup','gAfmu','EVAL','commandStyle','inBattle','kOlEu','ext','_optionsCoreFailsafeCheck','index','Window_Options_cursorRight','uiInputPosition','cursorLeft','processCursorHomeEndTrigger','isBottomHelpMode','updateCommandNameWindow','_switchFullScreen','hitIndex','FQevF','isActor','goldRate','YnbuD','List','Game_System_initialize','seBuzzer','DrawJS','58iDIWIL','processAllText','cancelSFXs','ONwgn','display','_pagedownButton','currentData','postCreateWindows','parse','LoadJS','_stretchScreenOptionsCore','checkActiveWindowPageUpDownHandlers','ConfigManager_save','downPitch','hHMoH','sounds','_data','bgsVolume','CursorRightJS','move','xarNw','eoHTq','isBusy','CategoryStyle','isEnemy','449200DvuuFM','_battleAniSpeedLooping','_pageupButton','create','[\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Effects\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistMode\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2287\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Playtest\x20Effects\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x5cnthis.refresh();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.refresh();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.refresh();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20false;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Exploration\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistMapSpeed\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2282\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Map\x20Update\x20Speed\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20segment\x20=\x20halfWidth\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Segments\x5c\x5c\x5c\x5cnconst\x20speedText\x20=\x20[\x27Normal\x27,\x20\x27Fast\x27,\x20\x27Faster\x27,\x20\x27Fastest\x27];\x5c\x5c\x5c\x5cnfor\x20(let\x20i\x20=\x200;\x20i\x20<\x204;\x20i++)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.changePaintOpacity(i\x20===\x20value);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20const\x20text\x20=\x20speedText[i];\x5c\x5c\x5c\x5cn\x20\x20\x20\x20const\x20sx\x20=\x20rect.x\x20+\x20halfWidth\x20+\x20(segment\x20*\x20i);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.drawText(text,\x20sx,\x20rect.y,\x20segment,\x20\x27center\x27);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x203\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x203);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x203);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x203);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x203);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x203);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistRandomEncounters\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2276\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Random\x20Encounters\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20segment\x20=\x20halfWidth\x20/\x203;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Segments\x5c\x5c\x5c\x5cnconst\x20speedText\x20=\x20[\x27None\x27,\x20\x27Half\x27,\x20\x27Normal\x27];\x5c\x5c\x5c\x5cnfor\x20(let\x20i\x20=\x200;\x20i\x20<\x203;\x20i++)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.changePaintOpacity(i\x20===\x20value);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20const\x20text\x20=\x20speedText[i];\x5c\x5c\x5c\x5cn\x20\x20\x20\x20const\x20sx\x20=\x20rect.x\x20+\x20halfWidth\x20+\x20(segment\x20*\x20i);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.drawText(text,\x20sx,\x20rect.y,\x20segment,\x20\x27center\x27);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x202\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x202);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x202);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x202);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x202;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x202);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x202);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Battle\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistGodmode\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22God\x20Mode\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20false;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistResistNegatives\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Resist\x20Negative\x20Effects\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode\x20&&\x20Imported.VisuMZ_1_SkillsStatesCore;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20false;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistInstantKO\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Instant\x20K.O.\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20false;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistSkillCosts\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Skill\x20Costs\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistConsumeItems\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Consume\x20Items\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Rewards\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistExpMultiplier\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2288\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22EXP\x20Multiplier\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Gauge\x5c\x5c\x5c\x5cnconst\x20rate\x20=\x20(value\x20/\x2010).clamp(0,\x201);\x5c\x5c\x5c\x5cnconst\x20gx\x20=\x20rect.x\x20+\x20halfWidth;\x5c\x5c\x5c\x5cnconst\x20gy\x20=\x20rect.y\x20+\x20rect.height\x20-\x2014;\x5c\x5c\x5c\x5cnconst\x20fillW\x20=\x20Math.floor((halfWidth\x20-\x202)\x20*\x20rate);\x5c\x5c\x5c\x5cnconst\x20color0\x20=\x20ColorManager.gaugeBackColor();\x5c\x5c\x5c\x5cnconst\x20color1\x20=\x20ColorManager.textColor(30);\x5c\x5c\x5c\x5cnconst\x20color2\x20=\x20ColorManager.textColor(31);\x5c\x5c\x5c\x5cnthis.contents.fillRect(gx,\x20gy,\x20halfWidth,\x2012,\x20color0);\x5c\x5c\x5c\x5cnthis.contents.gradientFillRect(gx\x20+\x201,\x20gy\x20+\x201,\x20fillW,\x2010,\x20color1,\x20color2);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Value\x5c\x5c\x5c\x5cnconst\x20text\x20=\x20\x27x%1\x27.format(2\x20**\x20value);\x5c\x5c\x5c\x5cnthis.drawText(text,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x2010\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistGoldMultiplier\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x22314\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Gold\x20Multiplier\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Gauge\x5c\x5c\x5c\x5cnconst\x20rate\x20=\x20(value\x20/\x2010).clamp(0,\x201);\x5c\x5c\x5c\x5cnconst\x20gx\x20=\x20rect.x\x20+\x20halfWidth;\x5c\x5c\x5c\x5cnconst\x20gy\x20=\x20rect.y\x20+\x20rect.height\x20-\x2014;\x5c\x5c\x5c\x5cnconst\x20fillW\x20=\x20Math.floor((halfWidth\x20-\x202)\x20*\x20rate);\x5c\x5c\x5c\x5cnconst\x20color0\x20=\x20ColorManager.gaugeBackColor();\x5c\x5c\x5c\x5cnconst\x20color1\x20=\x20ColorManager.textColor(14);\x5c\x5c\x5c\x5cnconst\x20color2\x20=\x20ColorManager.textColor(6);\x5c\x5c\x5c\x5cnthis.contents.fillRect(gx,\x20gy,\x20halfWidth,\x2012,\x20color0);\x5c\x5c\x5c\x5cnthis.contents.gradientFillRect(gx\x20+\x201,\x20gy\x20+\x201,\x20fillW,\x2010,\x20color1,\x20color2);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Value\x5c\x5c\x5c\x5cnconst\x20text\x20=\x20\x27x%1\x27.format(2\x20**\x20value);\x5c\x5c\x5c\x5cnthis.drawText(text,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x2010\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistDropMultiplier\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x22176\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Drop\x20Multiplier\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Gauge\x5c\x5c\x5c\x5cnconst\x20rate\x20=\x20(value\x20/\x2010).clamp(0,\x201);\x5c\x5c\x5c\x5cnconst\x20gx\x20=\x20rect.x\x20+\x20halfWidth;\x5c\x5c\x5c\x5cnconst\x20gy\x20=\x20rect.y\x20+\x20rect.height\x20-\x2014;\x5c\x5c\x5c\x5cnconst\x20fillW\x20=\x20Math.floor((halfWidth\x20-\x202)\x20*\x20rate);\x5c\x5c\x5c\x5cnconst\x20color0\x20=\x20ColorManager.gaugeBackColor();\x5c\x5c\x5c\x5cnconst\x20color1\x20=\x20ColorManager.textColor(11);\x5c\x5c\x5c\x5cnconst\x20color2\x20=\x20ColorManager.textColor(3);\x5c\x5c\x5c\x5cnthis.contents.fillRect(gx,\x20gy,\x20halfWidth,\x2012,\x20color0);\x5c\x5c\x5c\x5cnthis.contents.gradientFillRect(gx\x20+\x201,\x20gy\x20+\x201,\x20fillW,\x2010,\x20color1,\x20color2);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Value\x5c\x5c\x5c\x5cnconst\x20text\x20=\x20\x27x%1\x27.format(2\x20**\x20value);\x5c\x5c\x5c\x5cnthis.drawText(text,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x2010\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Spawners\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistSpawnItems\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x22176\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Spawn\x20Items\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Spawn\x20Items\x5c\x5c\x5c\x5cnconst\x20goods\x20=\x20[];\x5c\x5c\x5c\x5cnfor\x20(const\x20item\x20of\x20$dataItems)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20if\x20(item\x20&&\x20item.name.trim()\x20!==\x20\x27\x27)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20\x20\x20\x20\x20goods.push([0,\x20item.id,\x201,\x200]);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20}\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnSceneManager.push(Scene_Shop);\x5c\x5c\x5c\x5cnSceneManager.prepareNextScene(goods,\x20true);\x5c\x5c\x5c\x5cnthis.prepareOptionsCoreSceneChange();\x5c\x5c\x5c\x5cnSoundManager.playOk();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistSpawnWeapons\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Spawn\x20Weapons\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Spawn\x20Items\x5c\x5c\x5c\x5cnconst\x20goods\x20=\x20[];\x5c\x5c\x5c\x5cnfor\x20(const\x20item\x20of\x20$dataWeapons)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20if\x20(item\x20&&\x20item.name.trim()\x20!==\x20\x27\x27)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20\x20\x20\x20\x20goods.push([1,\x20item.id,\x201,\x200]);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20}\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnSceneManager.push(Scene_Shop);\x5c\x5c\x5c\x5cnSceneManager.prepareNextScene(goods,\x20true);\x5c\x5c\x5c\x5cnthis.prepareOptionsCoreSceneChange();\x5c\x5c\x5c\x5cnSoundManager.playOk();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistSpawnArmors\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x22137\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Spawn\x20Armors\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Spawn\x20Items\x5c\x5c\x5c\x5cnconst\x20goods\x20=\x20[];\x5c\x5c\x5c\x5cnfor\x20(const\x20item\x20of\x20$dataArmors)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20if\x20(item\x20&&\x20item.name.trim()\x20!==\x20\x27\x27)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20\x20\x20\x20\x20goods.push([2,\x20item.id,\x201,\x200]);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20}\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnSceneManager.push(Scene_Shop);\x5c\x5c\x5c\x5cnSceneManager.prepareNextScene(goods,\x20true);\x5c\x5c\x5c\x5cnthis.prepareOptionsCoreSceneChange();\x5c\x5c\x5c\x5cnSoundManager.playOk();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Debug\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistCallDebug\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2289\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Debug\x20Menu\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Call\x20Debug\x20Menu\x5c\x5c\x5c\x5cnSceneManager.push(Scene_Debug);\x5c\x5c\x5c\x5cnthis.prepareOptionsCoreSceneChange();\x5c\x5c\x5c\x5cnSoundManager.playOk();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22]','2721792uMuanZ','buttonAssistSwitch','playBuzzer','OptionsCore','Settings','version','updateOptionsSceneBgTypes','setupNewGame','processVolumeShortcut','Graphics_cancelFullScreen','isPressed','NUM','_requestFullScreen','mainAreaTop','onTouchOk','Scene_Title_update','expTotal','Scene_MenuBase_createPageButtons','itemLineRect','getConfigValue','parameters','prototype','Scene_Boot_onDatabaseLoaded','cursorUp','_isFullScreen','isCursorMovable','PFrUi','battleAniSpeed','ButtonPosition','drawItem','iSsAM','jbJns','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','initOptionsCore','addCommand','onListCancel','_windowTone','symbol','trim','visible','_cancelFullScreen','processOk','useItem','isOptionValid','Game_Action_executeHpDamage','_saving','_scene','switchMode','_scrollY','createCategoryWindow','onTouchSelectModern','updateButtonVisibility','TVWZs','innerWidth','_list','Game_BattlerBase_isStateResist','setWindowTone','167304YNuvmo','isCancelled','isSkill','mbGGo','nDUji','iconWidth','_isFPSCounterOn','Icon','uFUIg','drawText','assistConsumeItems','updateMainMultiplyOptionsCore','_handlers','714088zZosvr','oSgIr','VolumeShortcut','EdpZG','opacity','hoverEnabled','Input_isTriggered','ConfigManager_applyData','activate','playOk','toLowerCase','sPnsK','ypjSV','showRegularAnimations','pagedown','gCwiR','rytRB','clear','reduce','isPlaytest','cursorDown','contents','_stretchEnabled','onTouchSelect','Wxoax','updateOptionsCoreFailsafe','select','outputWidth','battleAniShow','createPageButtons','filter','buttonAssistBgType','Scene_Base_buttonAssistText1','isStateResist','ExtJS','playLoad','setBackgroundType','_fpsCounter','clamp','JVsNK','maxCols','JOAWb','Graphics_FPSCounter_switchMode','ePDxL','scrollY','rFqWG','format','ckWAv','optionsCoreFonts','playStaticSe','left','mainAreaHeight','category','_cancelButton','makeDeepCopy','OptionsSettings','_switchStretchMode','playBuzzerSound','push','seVolume','dyqES','downVolume','VhOLK','drawItemStyleIcon','gTncI','Untitled','smoothScrollTo','ARRAYEVAL','isOpenAndActive','textFont','exit','toUpperCase','upName','assistDropMultiplier','playCancel','status','KOpfe','NEGATIVE','Game_Troop_goldRate','_dataFunc','Game_Enemy_dropItemRate','Game_System_mainFontFace','CheckAmPresent','Game_Battler_addDebuff','refreshCursor','_masterVolume','playMasterVolumeDown','_index','Game_Party_hasEncounterHalf','ZgxeY','children','MVtTK','717IPyOKX','commandCategory','epkUX','refresh','optionsWindowBgType','length','makeCommandList','paintOpacity','uiHelpPosition','setCategory','OVvEp','DefaultJS','\x22//\x20Return\x20Boolean\x5cnreturn\x20!$gameTemp.isPlaytest()\x20&&\x20ConfigManager.assistMode;\x22','isUseModernControls','28oFgXkH','_scrollX','displayFPS','masterVolume','resetFontSettings','meetVolumeShortcutConditions','DataManager_setupNewGame','round','setHandler','Input_isRepeated','ARRAYNUM','_loading','AhyNy','Graphics_switchStretchMode','test','SFXCancelList','viLaD','playMasterVolumeUp','commandStyleCheck','maxItems','Game_Temp_showFauxAnimations','deathStateId','hasEncounterHalf','applyDataOptionsCore','_name','smoothSelect','center','iconHeight','optionsCoreUpdateButtonPositions','Scene_Battle_update','KiVIV','SFXBuzzerList','bind','upPitch','changePaintOpacity','pageup','IiSNy','buttonAssistWindowRect','jBsbE','constructor','createCommandNameWindow','updateButtonPositions','assistSkillCosts','isTriggered','oIqbl','randomEncounters','AgsZM','createButtons','Symbol','EFIIZ','assistRandomEncounters','assistExpMultiplier','assistMapSpeed','MdyJB','process_VisuMZ_OptionsCore_Failsafe','executeHpDamage','cursorRight','EinCb','SoundManager_playCursor','updateBattleAniSpeed','initialize','tFauB','Game_Troop_expTotal','processOptionsCoreSoundEffects','right','call','IwCOr','_categoryWindow','VisuMZ_1_SkillsStatesCore'];_0x5030=function(){return _0x26f841;};return _0x5030();}if(Imported['VisuMZ_0_CoreEngine']){VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x12f)]=Game_Temp[_0x40271e(0x1fb)]['requestAnimation'],Game_Temp['prototype']['requestAnimation']=function(_0x2bea39,_0x491d7b,_0xc3f07f){const _0x443fc9=_0x40271e;if(!this[_0x443fc9(0x239)]())return;VisuMZ[_0x443fc9(0x1e9)][_0x443fc9(0x12f)][_0x443fc9(0xf3)](this,_0x2bea39,_0x491d7b,_0xc3f07f);},Game_Temp['prototype'][_0x40271e(0x239)]=function(){const _0x3c0446=_0x40271e;if($gameParty[_0x3c0446(0x1b3)]()&&ConfigManager&&ConfigManager[_0x3c0446(0x248)]!==undefined)return _0x3c0446(0x268)!==_0x3c0446(0x268)?_0x2a44e9['uiMenuStyle']&&_0x4fdf24[_0x3c0446(0xac)]!==_0x1a4e54?_0x197de4[_0x3c0446(0xac)]:_0x430bf4['HelpPosition'][_0x3c0446(0xf3)](this):ConfigManager[_0x3c0446(0x248)]>=0x1;return!![];};Game_Temp[_0x40271e(0x1fb)][_0x40271e(0x164)]&&(VisuMZ[_0x40271e(0x1e9)][_0x40271e(0xc6)]=Game_Temp[_0x40271e(0x1fb)][_0x40271e(0x164)],Game_Temp[_0x40271e(0x1fb)][_0x40271e(0x164)]=function(){const _0x17a6f6=_0x40271e;if($gameParty[_0x17a6f6(0x1b3)]()&&ConfigManager&&ConfigManager[_0x17a6f6(0x248)]!==undefined)return _0x17a6f6(0x100)===_0x17a6f6(0xae)?this['_categoryWindow']&&this[_0x17a6f6(0xf5)]['isUseModernControls']():ConfigManager[_0x17a6f6(0x248)]>=0x2;return VisuMZ['OptionsCore']['Game_Temp_showFauxAnimations'][_0x17a6f6(0xf3)](this);});;};VisuMZ['OptionsCore'][_0x40271e(0x1c5)]=Game_System['prototype'][_0x40271e(0xee)],Game_System['prototype'][_0x40271e(0xee)]=function(){const _0xe9d91d=_0x40271e;VisuMZ[_0xe9d91d(0x1e9)]['Game_System_initialize'][_0xe9d91d(0xf3)](this),this[_0xe9d91d(0x207)]();},Game_System[_0x40271e(0x1fb)][_0x40271e(0x207)]=function(){const _0x15b527=_0x40271e;this[_0x15b527(0x20a)]=JsonEx[_0x15b527(0x262)]($dataSystem['windowTone']);},Game_System[_0x40271e(0x1fb)][_0x40271e(0x13d)]=function(){const _0xc96ece=_0x40271e;if(this['_windowTone'])return this[_0xc96ece(0x20a)];return this['initOptionsCore'](),this['_windowTone'];},VisuMZ['OptionsCore']['Game_System_mainFontFace']=Game_System[_0x40271e(0x1fb)][_0x40271e(0x13e)],Game_System[_0x40271e(0x1fb)][_0x40271e(0x13e)]=function(){const _0xedb888=_0x40271e,_0x685bbb=VisuMZ[_0xedb888(0x1e9)][_0xedb888(0x99)][_0xedb888(0xf3)](this);if(ConfigManager&&ConfigManager['textFont']!==undefined){if(ConfigManager[_0xedb888(0x8d)]>0x0){if('HYkBO'===_0xedb888(0x142))return TextManager[_0xedb888(0x25c)][ConfigManager[_0xedb888(0x8d)]]||_0x685bbb;else{if(_0x507fc9===_0xedb888(0xd5))_0x226a3f[_0xedb888(0xc3)]();else _0x324a36==='pagedown'&&_0x977187['playMasterVolumeDown']();}}}return _0x685bbb;},VisuMZ['OptionsCore'][_0x40271e(0x212)]=Game_Action[_0x40271e(0x1fb)][_0x40271e(0xe9)],Game_Action[_0x40271e(0x1fb)][_0x40271e(0xe9)]=function(_0x179f94,_0x2024f9){const _0x3767f6=_0x40271e;if(ConfigManager[_0x3767f6(0x1a8)]){if('qaYlO'==='VOksR'){_0x4737f4[_0x3767f6(0xdd)]()&&this['onTouchSelect'](!![]);if(_0x21bffd[_0x3767f6(0x171)]())this[_0x3767f6(0x1f4)]();else _0x12f680[_0x3767f6(0x220)]()&&this[_0x3767f6(0x1a9)]();}else{if(this[_0x3767f6(0x194)]()[_0x3767f6(0x1c1)]()&&_0x179f94['isEnemy']()){if(ConfigManager[_0x3767f6(0x115)])_0x2024f9=Math[_0x3767f6(0x140)](_0x2024f9,_0x179f94['mhp']);}}}VisuMZ[_0x3767f6(0x1e9)][_0x3767f6(0x212)][_0x3767f6(0xf3)](this,_0x179f94,_0x2024f9);},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x21d)]=Game_BattlerBase[_0x40271e(0x1fb)][_0x40271e(0x24d)],Game_BattlerBase['prototype'][_0x40271e(0x24d)]=function(_0x31ff35){const _0x4e213f=_0x40271e;if(ConfigManager[_0x4e213f(0x1a8)]&&this[_0x4e213f(0x1c1)]()){if(ConfigManager['assistGodmode']&&_0x31ff35===this[_0x4e213f(0xc7)]())return!![];if(Imported[_0x4e213f(0xf6)]&&ConfigManager[_0x4e213f(0x105)]){const _0x43d552=$dataStates[_0x31ff35];if(_0x43d552&&_0x43d552[_0x4e213f(0x1a1)]&&_0x43d552[_0x4e213f(0x1a1)]['includes'](_0x4e213f(0x95)))return!![];}}return VisuMZ['OptionsCore']['Game_BattlerBase_isStateResist'][_0x4e213f(0xf3)](this,_0x31ff35);},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x141)]=Game_Battler['prototype'][_0x40271e(0x210)],Game_Battler[_0x40271e(0x1fb)][_0x40271e(0x210)]=function(_0x4abff0){const _0x33511c=_0x40271e;if(ConfigManager&&ConfigManager[_0x33511c(0x1a8)]&&this['isActor']()){if('ePDxL'!==_0x33511c(0x257)){const _0x3c0f77=this['commandStyleCheck'](_0x231070);if(_0x3c0f77===_0x33511c(0x15f))this['drawItemStyleIconText'](_0x4d0f1e);else _0x3c0f77===_0x33511c(0x12b)?this[_0x33511c(0x26b)](_0x481ac6):_0x543326[_0x33511c(0x1fb)][_0x33511c(0x203)][_0x33511c(0xf3)](this,_0x3dd8af);}else{if(DataManager[_0x33511c(0x221)](_0x4abff0)&&ConfigManager[_0x33511c(0xdc)]===![])return;if(DataManager[_0x33511c(0x134)](_0x4abff0)&&ConfigManager[_0x33511c(0x229)]===![])return;}}VisuMZ[_0x33511c(0x1e9)][_0x33511c(0x141)][_0x33511c(0xf3)](this,_0x4abff0);},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x9b)]=Game_Battler[_0x40271e(0x1fb)][_0x40271e(0x153)],Game_Battler[_0x40271e(0x1fb)][_0x40271e(0x153)]=function(_0x26deb5,_0x350fc7){const _0x15f8af=_0x40271e;if(ConfigManager[_0x15f8af(0x1a8)]&&this[_0x15f8af(0x1c1)]()){if(Imported[_0x15f8af(0xf6)]&&ConfigManager[_0x15f8af(0x105)])return!![];}VisuMZ[_0x15f8af(0x1e9)][_0x15f8af(0x9b)][_0x15f8af(0xf3)](this,_0x26deb5,_0x350fc7);},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x98)]=Game_Enemy[_0x40271e(0x1fb)][_0x40271e(0x1a2)],Game_Enemy[_0x40271e(0x1fb)][_0x40271e(0x1a2)]=function(){const _0x5b8544=_0x40271e;let _0x228894=VisuMZ['OptionsCore'][_0x5b8544(0x98)]['call'](this);return ConfigManager[_0x5b8544(0x1a8)]&&(_0x228894*=0x2**(ConfigManager[_0x5b8544(0x91)]||0x0)),_0x228894;},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0xa0)]=Game_Party[_0x40271e(0x1fb)][_0x40271e(0xc8)],Game_Party['prototype'][_0x40271e(0xc8)]=function(){const _0x5f51e3=_0x40271e;if(ConfigManager[_0x5f51e3(0x1a8)]&&ConfigManager['assistRandomEncounters']===0x1)return!![];if(ConfigManager[_0x5f51e3(0xdf)]===0x1)return!![];return VisuMZ[_0x5f51e3(0x1e9)][_0x5f51e3(0xa0)][_0x5f51e3(0xf3)](this);},VisuMZ['OptionsCore'][_0x40271e(0x13a)]=Game_Party['prototype'][_0x40271e(0x118)],Game_Party['prototype'][_0x40271e(0x118)]=function(){const _0x4434c0=_0x40271e;if(ConfigManager[_0x4434c0(0x1a8)]&&ConfigManager[_0x4434c0(0xe4)]===0x0)return!![];if(ConfigManager[_0x4434c0(0xdf)]===0x0)return!![];return VisuMZ[_0x4434c0(0x1e9)][_0x4434c0(0x13a)]['call'](this);},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0xf0)]=Game_Troop[_0x40271e(0x1fb)][_0x40271e(0x1f6)],Game_Troop[_0x40271e(0x1fb)][_0x40271e(0x1f6)]=function(){const _0x2bd6e0=_0x40271e;let _0x47fed4=VisuMZ[_0x2bd6e0(0x1e9)]['Game_Troop_expTotal'][_0x2bd6e0(0xf3)](this);if(ConfigManager['assistMode']){if(_0x2bd6e0(0xde)===_0x2bd6e0(0xde))_0x47fed4*=0x2**(ConfigManager[_0x2bd6e0(0xe5)]||0x0);else{const _0x297746=_0x49bb28['_scene'];_0x297746[_0x2bd6e0(0xd9)]===_0x2529c5&&_0x24df20(_0x297746['refreshWindows']['bind'](_0x297746),0x64);}}return _0x47fed4;},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x96)]=Game_Troop[_0x40271e(0x1fb)][_0x40271e(0x1c2)],Game_Troop[_0x40271e(0x1fb)][_0x40271e(0x1c2)]=function(){const _0x2fea00=_0x40271e;let _0x5aab54=VisuMZ[_0x2fea00(0x1e9)][_0x2fea00(0x96)]['call'](this);if(ConfigManager[_0x2fea00(0x1a8)]){if(_0x2fea00(0xd8)==='jBsbE')_0x5aab54*=0x2**(ConfigManager[_0x2fea00(0x13c)]||0x0);else{let _0x4c9fd8=_0x37f208['OptionsCore'][_0x2fea00(0x96)][_0x2fea00(0xf3)](this);return _0x39e019[_0x2fea00(0x1a8)]&&(_0x4c9fd8*=0x2**(_0xb4534[_0x2fea00(0x13c)]||0x0)),_0x4c9fd8;}}return _0x5aab54;};var uiDefault=uiDefault||{};uiDefault['HelpPosition']=Scene_Base[_0x40271e(0x1fb)][_0x40271e(0x1bc)],Scene_Base[_0x40271e(0x1fb)][_0x40271e(0x1bc)]=function(){const _0x5c703c=_0x40271e;if(ConfigManager[_0x5c703c(0xf9)]&&ConfigManager[_0x5c703c(0xac)]!==undefined)return ConfigManager[_0x5c703c(0xac)];else{if('RCgSw'!==_0x5c703c(0x1d6))return uiDefault['HelpPosition'][_0x5c703c(0xf3)](this);else this['_pagedownButton']['y']+=0x32;}},uiDefault[_0x40271e(0x202)]=Scene_Base[_0x40271e(0x1fb)][_0x40271e(0x19b)],Scene_Base[_0x40271e(0x1fb)][_0x40271e(0x19b)]=function(){const _0x5e28d6=_0x40271e;return ConfigManager[_0x5e28d6(0x160)]!==undefined?ConfigManager[_0x5e28d6(0x160)]:uiDefault[_0x5e28d6(0x202)][_0x5e28d6(0xf3)](this);},uiDefault[_0x40271e(0x14d)]=Scene_Base[_0x40271e(0x1fb)][_0x40271e(0x10a)],Scene_Base[_0x40271e(0x1fb)][_0x40271e(0x10a)]=function(){const _0xb70bb6=_0x40271e;if(ConfigManager[_0xb70bb6(0xf9)]&&ConfigManager[_0xb70bb6(0x1b9)]!==undefined){if(_0xb70bb6(0x187)!==_0xb70bb6(0xf8))return ConfigManager['uiInputPosition'];else{this[_0xb70bb6(0xb6)]();const _0x2af89e=this['contents'][_0xb70bb6(0xab)];this['_currentDrawingIndex']>=0x0&&(!this[_0xb70bb6(0x1ac)](this[_0xb70bb6(0x1aa)])&&this[_0xb70bb6(0xd4)](![]));const _0x636d05=this[_0xb70bb6(0x14b)](_0x4a674b,_0x4c4671,_0x5a445c,_0x2b7475);this[_0xb70bb6(0x1c9)](_0x636d05);const _0x4c46ac=_0x636d05['outputWidth'];return this[_0xb70bb6(0x241)]['paintOpacity']=_0x2af89e,_0x4c46ac;}}else return uiDefault[_0xb70bb6(0x14d)]['call'](this);},Scene_Base['prototype'][_0x40271e(0x219)]=function(){const _0x2d8595=_0x40271e;this['_cancelButton']&&(this[_0x2d8595(0x261)][_0x2d8595(0x20d)]=ConfigManager[_0x2d8595(0x10d)]),this[_0x2d8595(0x1e3)]&&(this[_0x2d8595(0x1e3)]['visible']=ConfigManager[_0x2d8595(0x10d)]),this['_pagedownButton']&&(this[_0x2d8595(0x1cd)]['visible']=ConfigManager[_0x2d8595(0x10d)]);},Scene_Base['prototype'][_0x40271e(0xce)]=function(){const _0xcbf280=_0x40271e;this[_0xcbf280(0x261)]&&('vSanM'!==_0xcbf280(0x26c)?this[_0xcbf280(0x261)]['y']=this[_0xcbf280(0x16b)]():this['drawTextEx'](_0x4d2170,_0xadac89['x']+_0x53b3d8[_0xcbf280(0x1ad)]-_0x3ab803,_0x208bf5['y'],_0xdd9a4e));this[_0xcbf280(0x1e3)]&&(this[_0xcbf280(0x1e3)]['y']=this[_0xcbf280(0x16b)](),Graphics[_0xcbf280(0x225)]()&&!this[_0xcbf280(0x19b)]()&&(this['_pageupButton']['y']+=0x32));if(this['_pagedownButton']){this[_0xcbf280(0x1cd)]['y']=this[_0xcbf280(0x16b)]();if(Graphics['_isFPSCounterOn']()&&!this[_0xcbf280(0x19b)]()){if(_0xcbf280(0x117)===_0xcbf280(0x117))this['_pagedownButton']['y']+=0x32;else return _0x2ea7e9[_0xcbf280(0x248)]>=0x2;}}},VisuMZ[_0x40271e(0x1e9)]['Scene_Base_buttonAssistText1']=Scene_Base[_0x40271e(0x1fb)][_0x40271e(0x16d)],Scene_Base['prototype']['buttonAssistText1']=function(){const _0x19c417=_0x40271e;if(ConfigManager[_0x19c417(0x10d)]){if(_0x19c417(0x227)!=='uFUIg')_0x3c3305[_0x19c417(0x1e9)][_0x19c417(0x183)][_0x19c417(0xf3)](this,_0x17aa87);else return VisuMZ[_0x19c417(0x1e9)][_0x19c417(0x24c)][_0x19c417(0xf3)](this);}else{if(_0x19c417(0xf4)!==_0x19c417(0x223))return this[_0x19c417(0x1d3)]();else this[_0x19c417(0x22a)]();}},Scene_Base['prototype'][_0x40271e(0x1d3)]=function(){const _0x457dbc=_0x40271e;if(this[_0x457dbc(0x151)]&&this[_0x457dbc(0x151)][_0x457dbc(0xa2)]){if('QJSdO'!==_0x457dbc(0x16a))for(const _0x17720f of this[_0x457dbc(0x151)][_0x457dbc(0xa2)]){if(_0x457dbc(0xfd)!==_0x457dbc(0xfd)){const _0x16f767=_0x40a365[_0x457dbc(0x179)]['OptionsBgType']||0x0,_0x50352d=[this[_0x457dbc(0xf5)],this[_0x457dbc(0x155)],this[_0x457dbc(0x18a)]];for(const _0x37df88 of _0x50352d){if(_0x37df88)_0x37df88[_0x457dbc(0x250)](_0x16f767);}}else{if(!_0x17720f)continue;if(!_0x17720f['active'])continue;if(!_0x17720f[_0x457dbc(0x22b)])continue;if(_0x17720f[_0x457dbc(0x22b)][_0x457dbc(0xd5)])return TextManager[_0x457dbc(0x1e7)];}}else _0x42ae8c[_0x457dbc(0x1d1)][_0x457dbc(0xf3)](this,_0x117e82,_0x32cc3e);}return'';},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x1f7)]=Scene_MenuBase[_0x40271e(0x1fb)][_0x40271e(0x249)],Scene_MenuBase[_0x40271e(0x1fb)][_0x40271e(0x249)]=function(){const _0x157491=_0x40271e;VisuMZ[_0x157491(0x1e9)]['Scene_MenuBase_createPageButtons'][_0x157491(0xf3)](this),Graphics['_isFPSCounterOn']()&&!this[_0x157491(0x19b)]()&&(this[_0x157491(0x1e3)]['y']+=0x32,this['_pagedownButton']['y']+=0x32);},Scene_MenuBase[_0x40271e(0x1fb)][_0x40271e(0x219)]=function(){const _0xc0ea0f=_0x40271e;if(!this[_0xc0ea0f(0x261)])this[_0xc0ea0f(0xe1)]();Scene_Base[_0xc0ea0f(0x1fb)][_0xc0ea0f(0x219)][_0xc0ea0f(0xf3)](this);},VisuMZ[_0x40271e(0x1e9)]['Scene_Title_update']=Scene_Title[_0x40271e(0x1fb)]['update'],Scene_Title[_0x40271e(0x1fb)]['update']=function(){const _0x53d41a=_0x40271e;this['updateOptionsCoreFailsafe'](),VisuMZ[_0x53d41a(0x1e9)][_0x53d41a(0x1f5)][_0x53d41a(0xf3)](this);},Scene_Title[_0x40271e(0x1fb)][_0x40271e(0x245)]=function(){const _0x28324a=_0x40271e;if(ConfigManager[_0x28324a(0x1a8)])return;if($gameTemp[_0x28324a(0x23f)]())return;if(Input[_0x28324a(0xdd)](_0x28324a(0x17c)))this[_0x28324a(0x184)](0x2);if(Input['isTriggered']('left'))this['processOptionsCoreFailsafe'](0x4);if(Input[_0x28324a(0xdd)](_0x28324a(0xf2)))this['processOptionsCoreFailsafe'](0x6);if(Input[_0x28324a(0xdd)]('up'))this[_0x28324a(0x184)](0x8);},Scene_Title[_0x40271e(0x1fb)][_0x40271e(0x184)]=function(_0x2090f2){const _0x338bf4=_0x40271e,_0x40b3a2=[0x8,0x8,0x2,0x2,0x4,0x6,0x4,0x6];this[_0x338bf4(0x1b6)]=this[_0x338bf4(0x1b6)]||0x0;if(_0x2090f2===_0x40b3a2[this[_0x338bf4(0x1b6)]]){if(_0x338bf4(0x205)==='jbJns')this[_0x338bf4(0x1b6)]++;else{if(this[_0x338bf4(0x20a)])return this['_windowTone'];return this[_0x338bf4(0x207)](),this[_0x338bf4(0x20a)];}}else this[_0x338bf4(0x1b6)]=0x0;this[_0x338bf4(0x1b6)]===_0x40b3a2['length']&&(ConfigManager[_0x338bf4(0x1a8)]=!![],ConfigManager['save'](),SoundManager[_0x338bf4(0x24f)]());},VisuMZ[_0x40271e(0x1e9)]['Scene_Map_updateMainMultiply']=Scene_Map[_0x40271e(0x1fb)]['updateMainMultiply'],Scene_Map[_0x40271e(0x1fb)][_0x40271e(0x157)]=function(){const _0x93c0cc=_0x40271e;VisuMZ[_0x93c0cc(0x1e9)][_0x93c0cc(0x11f)][_0x93c0cc(0xf3)](this),ConfigManager[_0x93c0cc(0x1a8)]&&ConfigManager[_0x93c0cc(0xe6)]&&!$gameMessage[_0x93c0cc(0x1de)]()&&this[_0x93c0cc(0x22a)]();},Scene_Map[_0x40271e(0x1fb)]['updateMainMultiplyOptionsCore']=function(){const _0x3594d4=_0x40271e;let _0x3e3566=ConfigManager['assistMapSpeed']||0x0;while(_0x3e3566--){this[_0x3594d4(0x190)]();}},VisuMZ[_0x40271e(0x1e9)]['Scene_Battle_update']=Scene_Battle[_0x40271e(0x1fb)]['update'],Scene_Battle[_0x40271e(0x1fb)][_0x40271e(0x108)]=function(){const _0x1b6a2e=_0x40271e;VisuMZ[_0x1b6a2e(0x1e9)][_0x1b6a2e(0xcf)]['call'](this);if(ConfigManager[_0x1b6a2e(0x201)])this[_0x1b6a2e(0xed)]();},Scene_Battle['prototype'][_0x40271e(0xed)]=function(){const _0x1ab0d7=_0x40271e;if(this[_0x1ab0d7(0x136)]()){if(_0x1ab0d7(0xa1)===_0x1ab0d7(0xa1)){this[_0x1ab0d7(0x1e2)]=!![];let _0x51399c=ConfigManager['battleAniSpeed'];while(_0x51399c--){this[_0x1ab0d7(0x108)](),SceneManager[_0x1ab0d7(0xfb)]();}this[_0x1ab0d7(0x1e2)]=![];}else{const _0x387ac5=_0x49e9e7[_0x1ab0d7(0x1ab)],_0x2cd227=this[_0x1ab0d7(0x25f)]()-this[_0x1ab0d7(0xf5)][_0x1ab0d7(0x15e)],_0x4d31d9=0x0,_0x71ae6a=this[_0x1ab0d7(0xf5)]['y']+this['_categoryWindow']['height'];return new _0x235271(_0x4d31d9,_0x71ae6a,_0x387ac5,_0x2cd227);}}},Scene_Battle[_0x40271e(0x1fb)][_0x40271e(0x136)]=function(){const _0x492d62=_0x40271e;return!BattleManager['isInputting']()&&!this[_0x492d62(0x1e2)]&&!$gameMessage['isBusy']();},Scene_Options['prototype'][_0x40271e(0x1a6)]=function(){return 0x0;},Scene_Options[_0x40271e(0x1fb)]['isUseModernControls']=function(){const _0x11150e=_0x40271e;return this['_categoryWindow']&&this[_0x11150e(0xf5)][_0x11150e(0xb1)]();},Scene_Options[_0x40271e(0x1fb)][_0x40271e(0x1e4)]=function(){const _0xae0ca4=_0x40271e;Scene_MenuBase[_0xae0ca4(0x1fb)]['create'][_0xae0ca4(0xf3)](this),this[_0xae0ca4(0x217)](),this['createOptionsWindow'](),this[_0xae0ca4(0x1cf)]();if(Imported[_0xae0ca4(0x182)]){}this[_0xae0ca4(0x1ec)]();},Scene_Options[_0x40271e(0x1fb)][_0x40271e(0x217)]=function(){const _0x47ee24=_0x40271e,_0x355a33=this[_0x47ee24(0x12e)]();this['_categoryWindow']=new Window_OptionsCategory(_0x355a33),this['addWindow'](this[_0x47ee24(0xf5)]),!this[_0x47ee24(0xb1)]()&&(this[_0x47ee24(0xf5)]['setHandler']('category',this[_0x47ee24(0xa5)][_0x47ee24(0xd2)](this)),this[_0x47ee24(0xf5)][_0x47ee24(0xba)]('cancel',this['popScene'][_0x47ee24(0xd2)](this)));},Scene_Options[_0x40271e(0x1fb)][_0x40271e(0x12e)]=function(){const _0x5bf4fc=_0x40271e,_0x4cab14=Graphics[_0x5bf4fc(0x1ab)],_0x2a4f87=this[_0x5bf4fc(0x178)](0x1,!![]),_0x33176a=0x0,_0x541db1=this[_0x5bf4fc(0x1f3)]();return new Rectangle(_0x33176a,_0x541db1,_0x4cab14,_0x2a4f87);},Scene_Options[_0x40271e(0x1fb)]['createOptionsWindow']=function(){const _0x1238e0=_0x40271e,_0x51d5b5=this[_0x1238e0(0x109)]();this['_optionsWindow']=new Window_Options(_0x51d5b5),this[_0x1238e0(0x14e)](this[_0x1238e0(0x155)]),this['_optionsWindow'][_0x1238e0(0xba)]('cancel',this[_0x1238e0(0x209)]['bind'](this)),this[_0x1238e0(0xf5)]['setListWindow'](this[_0x1238e0(0x155)]),this[_0x1238e0(0xb1)]()?_0x1238e0(0x255)===_0x1238e0(0x197)?(_0x5c4bc1[_0x1238e0(0x1e9)][_0x1238e0(0x11f)]['call'](this),_0x5ee275[_0x1238e0(0x1a8)]&&_0x5e6988[_0x1238e0(0xe6)]&&!_0x363f91[_0x1238e0(0x1de)]()&&this['updateMainMultiplyOptionsCore']()):(this[_0x1238e0(0x155)]['activate'](),this[_0x1238e0(0x155)][_0x1238e0(0xcb)](0x0)):(this[_0x1238e0(0x155)][_0x1238e0(0x139)](),this['_optionsWindow'][_0x1238e0(0x114)]());},Scene_Options[_0x40271e(0x1fb)][_0x40271e(0x109)]=function(){const _0x37a7b6=_0x40271e,_0x5c20e6=Graphics['boxWidth'],_0x4c849e=this['mainAreaHeight']()-this[_0x37a7b6(0xf5)][_0x37a7b6(0x15e)],_0x1abb78=0x0,_0x47a4a0=this[_0x37a7b6(0xf5)]['y']+this['_categoryWindow'][_0x37a7b6(0x15e)];return new Rectangle(_0x1abb78,_0x47a4a0,_0x5c20e6,_0x4c849e);},Scene_Options[_0x40271e(0x1fb)][_0x40271e(0x1cf)]=function(){const _0x1d2c7c=_0x40271e;if($gameTemp[_0x1d2c7c(0x149)]!==undefined){if('TniKu'===_0x1d2c7c(0xe3))this[_0x1d2c7c(0x1e3)]['y']+=0x32,this['_pagedownButton']['y']+=0x32;else{const _0x2edba5=$gameTemp[_0x1d2c7c(0x149)];this[_0x1d2c7c(0xf5)]['smoothSelect'](_0x2edba5['category']),this[_0x1d2c7c(0xf5)][_0x1d2c7c(0x108)]();if(this[_0x1d2c7c(0xb1)]())this[_0x1d2c7c(0xf5)][_0x1d2c7c(0x234)]();else{if(_0x1d2c7c(0x200)!==_0x1d2c7c(0x200))return _0x3a167b[_0x1d2c7c(0x1e9)][_0x1d2c7c(0x24c)][_0x1d2c7c(0xf3)](this);else this[_0x1d2c7c(0xf5)]['deactivate']();}this[_0x1d2c7c(0x155)][_0x1d2c7c(0x234)](),this['_optionsWindow'][_0x1d2c7c(0x9f)]=_0x2edba5[_0x1d2c7c(0x1b7)],this[_0x1d2c7c(0x155)]['_scrollX']=_0x2edba5['scrollX'],this[_0x1d2c7c(0x155)][_0x1d2c7c(0x216)]=_0x2edba5[_0x1d2c7c(0x258)],this[_0x1d2c7c(0x155)]['_scrollDuration']=0x0,this[_0x1d2c7c(0x155)][_0x1d2c7c(0x9c)](),$gameTemp[_0x1d2c7c(0x149)]=undefined;}}},Scene_Options[_0x40271e(0x1fb)][_0x40271e(0xa5)]=function(){const _0xa6f530=_0x40271e;this[_0xa6f530(0x155)][_0xa6f530(0x234)](),this[_0xa6f530(0x155)][_0xa6f530(0xcb)](0x0);},Scene_Options[_0x40271e(0x1fb)][_0x40271e(0x209)]=function(){const _0x48ca4c=_0x40271e;if(this[_0x48ca4c(0xb1)]()){if(_0x48ca4c(0x1dd)!==_0x48ca4c(0x1dd))return _0x46b37f[_0x1395f3];else this['popScene']();}else this[_0x48ca4c(0xf5)][_0x48ca4c(0x234)](),this['_optionsWindow'][_0x48ca4c(0x114)]();},Scene_Options['prototype'][_0x40271e(0xce)]=function(){const _0x47233b=_0x40271e;Scene_MenuBase[_0x47233b(0x1fb)]['optionsCoreUpdateButtonPositions']['call'](this),this[_0x47233b(0x11e)]();},Scene_Options[_0x40271e(0x1fb)][_0x40271e(0x11e)]=function(){const _0x2c7e0a=_0x40271e;if(this[_0x2c7e0a(0xf5)]){if(_0x2c7e0a(0x1dc)===_0x2c7e0a(0x1b4)){if(_0x7ecd85['textFont']>0x0)return _0x44703c['optionsCoreFonts'][_0x28a074[_0x2c7e0a(0x8d)]]||_0x1c1340;}else{const _0x245876=this[_0x2c7e0a(0x12e)]();this[_0x2c7e0a(0xf5)]['move'](_0x245876['x'],_0x245876['y'],_0x245876['width'],_0x245876[_0x2c7e0a(0x15e)]);}}if(this[_0x2c7e0a(0x155)]){if(_0x2c7e0a(0xc2)===_0x2c7e0a(0xd6)){for(let _0x5c2d71=0x1;_0x5c2d71<_0x27eb36[_0x2c7e0a(0xa9)];_0x5c2d71++){const _0x5b26ae=_0x2d09cd[_0x5c2d71],_0x53a41b=_0x22694b['makeDeepCopy'](_0x6eeaeb[_0x2c7e0a(0x1d7)][_0x31a51d]);_0x53a41b[_0x2c7e0a(0x128)]=_0x5b26ae,_0x32ecd4[_0x5c2d71]=_0x53a41b;}_0x564dcc++;}else{const _0x7edba6=this[_0x2c7e0a(0x109)]();this[_0x2c7e0a(0x155)][_0x2c7e0a(0x1db)](_0x7edba6['x'],_0x7edba6['y'],_0x7edba6[_0x2c7e0a(0x1ad)],_0x7edba6[_0x2c7e0a(0x15e)]);}}if(this['_buttonAssistWindow']){const _0x57d69d=this[_0x2c7e0a(0xd7)]();this[_0x2c7e0a(0x18a)][_0x2c7e0a(0x1db)](_0x57d69d['x'],_0x57d69d['y'],_0x57d69d[_0x2c7e0a(0x1ad)],_0x57d69d[_0x2c7e0a(0x15e)]),this[_0x2c7e0a(0x18a)][_0x2c7e0a(0xa7)]();}this[_0x2c7e0a(0x193)]();},Scene_Options['prototype'][_0x40271e(0x193)]=function(){const _0x2b0b8a=_0x40271e;this[_0x2b0b8a(0xf5)]&&(_0x2b0b8a(0x244)===_0x2b0b8a(0x19e)?(_0x34a91d[_0x2b0b8a(0x1e9)][_0x2b0b8a(0x1ef)]['call'](this),this[_0x2b0b8a(0xf7)]()):(this[_0x2b0b8a(0xf5)][_0x2b0b8a(0xa7)](),this[_0x2b0b8a(0xf5)]['refreshCursor']())),this[_0x2b0b8a(0x155)]&&(this['_optionsWindow'][_0x2b0b8a(0xa7)](),this[_0x2b0b8a(0x155)][_0x2b0b8a(0x9c)]()),this[_0x2b0b8a(0x18a)]&&(_0x2b0b8a(0x26a)===_0x2b0b8a(0x26a)?this[_0x2b0b8a(0x18a)][_0x2b0b8a(0xa7)]():_0x101e16(_0x27221c[_0x2b0b8a(0x193)]['bind'](_0x3cf06c),0x64));},Scene_Options[_0x40271e(0x1fb)]['buttonAssistText1']=function(){const _0x26183f=_0x40271e;return VisuMZ[_0x26183f(0x1e9)][_0x26183f(0x1ea)][_0x26183f(0x263)]['buttonAssistCategory'];},Scene_Options[_0x40271e(0x1fb)]['updateCoreEngineOptionsCoreWindowBgStyle']=function(){const _0x1ebeee=_0x40271e,_0x32d058=Scene_Options[_0x1ebeee(0x179)][_0x1ebeee(0x169)]||0x0,_0x8c6d52=[this[_0x1ebeee(0xf5)],this['_optionsWindow'],this[_0x1ebeee(0x18a)]];for(const _0x411ca0 of _0x8c6d52){if(_0x411ca0)_0x411ca0['setBackgroundType'](_0x32d058);}},Scene_Options[_0x40271e(0x1fb)][_0x40271e(0x1ec)]=function(){const _0x450935=_0x40271e,_0x4ead94=VisuMZ[_0x450935(0x1e9)][_0x450935(0x1ea)]['OptionsSettings'];if(this[_0x450935(0xf5)]){const _0x91bf13=_0x4ead94[_0x450935(0x15d)]??0x0;this[_0x450935(0xf5)][_0x450935(0x250)](_0x91bf13);}if(this['_optionsWindow']){const _0xb6b0e5=_0x4ead94[_0x450935(0xa8)]??0x0;this[_0x450935(0x155)][_0x450935(0x250)](_0xb6b0e5);}if(this[_0x450935(0x18a)]){if(_0x450935(0x186)===_0x450935(0x186)){const _0x1c92cf=_0x4ead94[_0x450935(0x24b)]??0x0;this[_0x450935(0x18a)][_0x450935(0x250)](_0x1c92cf);}else _0x1ff0ae=_0x450935(0x10b)[_0x450935(0x25a)](_0x46eb58,_0xdbf4cb);}},uiDefault[_0x40271e(0x231)]=Window_Selectable[_0x40271e(0x1fb)][_0x40271e(0x154)],Window_Selectable['prototype']['isHoverEnabled']=function(){const _0x11f500=_0x40271e;if(ConfigManager[_0x11f500(0x192)]!==undefined){if(_0x11f500(0x16e)===_0x11f500(0x16c))this['onTouchSelect'](!![]);else return ConfigManager['uiHoverSelect'];}else{if(_0x11f500(0x23b)==='gCwiR'){return uiDefault[_0x11f500(0x231)][_0x11f500(0xf3)](this);;}else _0x596523+=_0x4cd8d1;}};function Window_OptionsCategory(){const _0x184759=_0x40271e;this[_0x184759(0xee)](...arguments);}Window_OptionsCategory[_0x40271e(0x1a4)]=VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x1ea)][_0x40271e(0x19d)],Window_OptionsCategory[_0x40271e(0x1fb)]=Object['create'](Window_HorzCommand['prototype']),Window_OptionsCategory['prototype'][_0x40271e(0xd9)]=Window_OptionsCategory,Window_OptionsCategory[_0x40271e(0x1fb)][_0x40271e(0xee)]=function(_0x5239b8){const _0x1d313c=_0x40271e;Window_HorzCommand[_0x1d313c(0x1fb)][_0x1d313c(0xee)][_0x1d313c(0xf3)](this,_0x5239b8),this[_0x1d313c(0xda)](_0x5239b8);},Window_OptionsCategory[_0x40271e(0x1fb)]['isUseModernControls']=function(){const _0x451b37=_0x40271e;return Imported[_0x451b37(0x182)]&&Window_HorzCommand[_0x451b37(0x1fb)][_0x451b37(0xb1)][_0x451b37(0xf3)](this);},Window_OptionsCategory[_0x40271e(0x1fb)][_0x40271e(0xda)]=function(_0x25e1f8){const _0x440776=_0x40271e,_0x1de30e=new Rectangle(0x0,0x0,_0x25e1f8['width'],_0x25e1f8['height']);this[_0x440776(0x110)]=new Window_Base(_0x1de30e),this[_0x440776(0x110)][_0x440776(0x230)]=0x0,this['addChild'](this[_0x440776(0x110)]),this[_0x440776(0x1bd)]();},Window_OptionsCategory[_0x40271e(0x1fb)][_0x40271e(0x16f)]=function(){const _0x419a42=_0x40271e;Window_HorzCommand[_0x419a42(0x1fb)][_0x419a42(0x16f)][_0x419a42(0xf3)](this);if(this[_0x419a42(0x110)])this['updateCommandNameWindow']();},Window_OptionsCategory[_0x40271e(0x1fb)][_0x40271e(0x1bd)]=function(){const _0x326923=_0x40271e,_0x22da0c=this[_0x326923(0x110)];_0x22da0c[_0x326923(0x241)][_0x326923(0x23d)]();const _0x669508=this[_0x326923(0xc4)](this['index']());if(_0x669508===_0x326923(0x12b)){if(_0x326923(0xeb)!=='EinCb')this[_0x326923(0x1cd)]['visible']=_0x324cb7[_0x326923(0x10d)];else{const _0x26da3b=this['itemLineRect'](this[_0x326923(0x1b7)]());let _0x6efb28=this['commandName'](this[_0x326923(0x1b7)]());_0x6efb28=_0x6efb28[_0x326923(0x177)](/\\I\[(\d+)\]/gi,''),_0x22da0c[_0x326923(0xb6)](),this[_0x326923(0x133)](_0x6efb28,_0x26da3b),this[_0x326923(0x19c)](_0x6efb28,_0x26da3b),this[_0x326923(0x162)](_0x6efb28,_0x26da3b);}}},Window_OptionsCategory[_0x40271e(0x1fb)][_0x40271e(0x133)]=function(_0x18cd59,_0x2fa716){},Window_OptionsCategory[_0x40271e(0x1fb)][_0x40271e(0x1bb)]=function(){},Window_OptionsCategory[_0x40271e(0x1fb)]['commandNameWindowDrawText']=function(_0x1abbda,_0x53f1dc){const _0x4cc0e6=_0x40271e,_0x20ed7e=this[_0x4cc0e6(0x110)];_0x20ed7e[_0x4cc0e6(0x228)](_0x1abbda,0x0,_0x53f1dc['y'],_0x20ed7e['innerWidth'],_0x4cc0e6(0xcc));},Window_OptionsCategory[_0x40271e(0x1fb)][_0x40271e(0x162)]=function(_0x328b96,_0x5e7748){const _0x2e3f24=_0x40271e,_0xce2673=this[_0x2e3f24(0x110)],_0x3f1137=$gameSystem['windowPadding'](),_0x1edc6a=_0x5e7748['x']+Math[_0x2e3f24(0x143)](_0x5e7748[_0x2e3f24(0x1ad)]/0x2)+_0x3f1137;_0xce2673['x']=_0xce2673[_0x2e3f24(0x1ad)]/-0x2+_0x1edc6a,_0xce2673['y']=Math[_0x2e3f24(0x143)](_0x5e7748[_0x2e3f24(0x15e)]/0x2);},Window_OptionsCategory[_0x40271e(0x1fb)][_0x40271e(0x254)]=function(){const _0x37d476=_0x40271e;return this[_0x37d476(0x21c)]?this['_list'][_0x37d476(0xa9)]:0x1;},Window_OptionsCategory[_0x40271e(0x1fb)][_0x40271e(0x1a7)]=function(_0x3b2f8e){const _0x42311b=_0x40271e;this[_0x42311b(0x155)]=_0x3b2f8e,this[_0x42311b(0xa7)]();},Window_OptionsCategory['prototype'][_0x40271e(0x108)]=function(){const _0x3ff0ed=_0x40271e;Window_HorzCommand[_0x3ff0ed(0x1fb)][_0x3ff0ed(0x108)][_0x3ff0ed(0xf3)](this),this[_0x3ff0ed(0x155)]&&this[_0x3ff0ed(0x155)][_0x3ff0ed(0xad)](this[_0x3ff0ed(0x1ce)]());},Window_OptionsCategory[_0x40271e(0x1fb)][_0x40271e(0x111)]=function(){const _0x35ff4d=_0x40271e;if(this[_0x35ff4d(0x1ff)]()){const _0x2cc06b=this[_0x35ff4d(0x1b7)]();Input['isRepeated'](_0x35ff4d(0x23a))&&this['cursorRight'](Input[_0x35ff4d(0xdd)](_0x35ff4d(0x23a))),Input[_0x35ff4d(0x15b)](_0x35ff4d(0xd5))&&this[_0x35ff4d(0x1ba)](Input[_0x35ff4d(0xdd)](_0x35ff4d(0xd5))),this['index']()!==_0x2cc06b&&(_0x35ff4d(0x222)==='aaYEI'?_0x193834['_scene'][_0x35ff4d(0x219)]():this[_0x35ff4d(0x12a)]());}},Window_OptionsCategory[_0x40271e(0x1fb)]['processHandling']=function(){const _0x93b20a=_0x40271e;if(this[_0x93b20a(0xb1)]())return;Window_HorzCommand[_0x93b20a(0x1fb)][_0x93b20a(0x18e)][_0x93b20a(0xf3)](this);},Window_OptionsCategory[_0x40271e(0x1fb)]['isHoverEnabled']=function(){const _0x4a2318=_0x40271e;if(this[_0x4a2318(0xb1)]())return![];else{if('ckWAv'===_0x4a2318(0x25b))return Window_HorzCommand[_0x4a2318(0x1fb)]['isHoverEnabled'][_0x4a2318(0xf3)](this);else this[_0x4a2318(0x199)](),_0x56c034[_0x4a2318(0x1e9)]['Scene_Boot_onDatabaseLoaded'][_0x4a2318(0xf3)](this),_0x577a91[_0x4a2318(0xf1)](),this[_0x4a2318(0xe8)](),!_0x4ac9e4[_0x4a2318(0x211)](_0x4a2318(0xc0))&&(_0xaa6508[_0x4a2318(0x1a8)]=![]);}},Window_OptionsCategory[_0x40271e(0x1fb)]['processTouchModernControls']=function(){const _0x309663=_0x40271e;if(this[_0x309663(0x8c)]()){TouchInput[_0x309663(0xdd)]()&&this[_0x309663(0x243)](!![]);if(TouchInput['isClicked']()){if(_0x309663(0x10f)!==_0x309663(0x10f)){if(_0x50f3d1[_0x309663(0x214)]['constructor']!==_0xe594f6)return;_0x1a750b[_0x309663(0x214)]['refreshWindows']();}else this['onTouchOk']();}else TouchInput[_0x309663(0x220)]()&&this[_0x309663(0x1a9)]();}},Window_OptionsCategory[_0x40271e(0x1fb)][_0x40271e(0x243)]=function(_0x385c02){const _0x5bd76b=_0x40271e;this[_0x5bd76b(0xb1)]()?this[_0x5bd76b(0x218)](!![]):Window_HorzCommand[_0x5bd76b(0x1fb)][_0x5bd76b(0x243)][_0x5bd76b(0xf3)](this,_0x385c02);},Window_OptionsCategory[_0x40271e(0x1fb)][_0x40271e(0x218)]=function(_0x5d3b77){const _0x245d6c=_0x40271e;this[_0x245d6c(0x11c)]=![];if(this[_0x245d6c(0x1ff)]()){if('snTsA'===_0x245d6c(0x12d)){const _0x26644c=this['_commandNameWindow'],_0x1d667f=_0x48534a['windowPadding'](),_0x271502=_0x3471c2['x']+_0x369b17[_0x245d6c(0x143)](_0x501ffa[_0x245d6c(0x1ad)]/0x2)+_0x1d667f;_0x26644c['x']=_0x26644c[_0x245d6c(0x1ad)]/-0x2+_0x271502,_0x26644c['y']=_0x41be9d[_0x245d6c(0x143)](_0x13ad4a[_0x245d6c(0x15e)]/0x2);}else{const _0x39d9e6=this[_0x245d6c(0x1b7)](),_0x2a4e66=this[_0x245d6c(0x1bf)]();_0x2a4e66>=0x0&&_0x2a4e66!==this['index']()&&this[_0x245d6c(0x246)](_0x2a4e66),_0x5d3b77&&this[_0x245d6c(0x1b7)]()!==_0x39d9e6&&this[_0x245d6c(0x12a)]();}}},Window_OptionsCategory[_0x40271e(0x1fb)][_0x40271e(0xaa)]=function(){const _0xe5200=_0x40271e;for(const _0xca3588 of Window_OptionsCategory['categoryList']){if(!_0xca3588[_0xe5200(0x17b)][_0xe5200(0xf3)](this))continue;const _0x5c516e=this[_0xe5200(0x1b2)](),_0x205cbf=_0xca3588['Name'],_0x23baaa=_0xca3588[_0xe5200(0x226)],_0x5b4ff5=_0x5c516e===_0xe5200(0x13f)?_0x205cbf:_0xe5200(0x10b)[_0xe5200(0x25a)](_0x23baaa,_0x205cbf),_0x33d7da=_0xca3588[_0xe5200(0x1c4)];this['addCommand'](_0x5b4ff5,_0xe5200(0x260),!![],_0x33d7da);}},Window_OptionsCategory[_0x40271e(0x1fb)]['itemTextAlign']=function(){const _0x1cfae2=_0x40271e;return VisuMZ['OptionsCore'][_0x1cfae2(0x1ea)]['OptionsSettings'][_0x1cfae2(0x18b)];},Window_OptionsCategory[_0x40271e(0x1fb)][_0x40271e(0x203)]=function(_0x39cdef){const _0x66eac6=_0x40271e,_0x245b6f=this[_0x66eac6(0xc4)](_0x39cdef);if(_0x245b6f==='iconText')_0x66eac6(0xd0)===_0x66eac6(0x11b)?(this[_0x66eac6(0xca)]=null,this['_data']=null,_0x2f7d14[_0x66eac6(0x1e9)]['Window_Options_initialize'][_0x66eac6(0xf3)](this,_0x2aed38)):this[_0x66eac6(0x14f)](_0x39cdef);else _0x245b6f===_0x66eac6(0x12b)?this[_0x66eac6(0x26b)](_0x39cdef):_0x66eac6(0x12c)!=='WVMXi'?Window_HorzCommand['prototype'][_0x66eac6(0x203)][_0x66eac6(0xf3)](this,_0x39cdef):_0x30a3ca*=0x2**(_0x4362e7['assistGoldMultiplier']||0x0);},Window_OptionsCategory['prototype'][_0x40271e(0x1b2)]=function(){const _0x3970f0=_0x40271e;return VisuMZ['OptionsCore'][_0x3970f0(0x1ea)]['OptionsSettings'][_0x3970f0(0x1df)];},Window_OptionsCategory[_0x40271e(0x1fb)]['commandStyleCheck']=function(_0x5d286c){const _0x559660=_0x40271e;if(_0x5d286c<0x0)return _0x559660(0x13f);const _0xa506b6=this[_0x559660(0x1b2)]();if(_0xa506b6!==_0x559660(0x180))return _0xa506b6;else{if(this[_0x559660(0xc5)]()>0x0){const _0x174e98=this[_0x559660(0x135)](_0x5d286c);if(_0x174e98[_0x559660(0x14c)](/\\I\[(\d+)\]/i)){const _0x28694d=this[_0x559660(0x1f8)](_0x5d286c),_0x2aed1f=this[_0x559660(0x101)](_0x174e98)[_0x559660(0x1ad)];return _0x2aed1f<=_0x28694d[_0x559660(0x1ad)]?_0x559660(0x15f):'icon';}}}return _0x559660(0x13f);},Window_OptionsCategory[_0x40271e(0x1fb)][_0x40271e(0x14f)]=function(_0x265bb9){const _0x3f0fe8=_0x40271e,_0x44b4e8=this[_0x3f0fe8(0x1f8)](_0x265bb9),_0x56329=this[_0x3f0fe8(0x135)](_0x265bb9),_0x64a557=this[_0x3f0fe8(0x101)](_0x56329)[_0x3f0fe8(0x1ad)];this[_0x3f0fe8(0xd4)](this[_0x3f0fe8(0x1ac)](_0x265bb9));const _0x4c1199=this['itemTextAlign']();if(_0x4c1199===_0x3f0fe8(0xf2))this[_0x3f0fe8(0x112)](_0x56329,_0x44b4e8['x']+_0x44b4e8['width']-_0x64a557,_0x44b4e8['y'],_0x64a557);else{if(_0x4c1199===_0x3f0fe8(0xcc)){if(_0x3f0fe8(0xfa)===_0x3f0fe8(0xfa)){const _0x4d2c5b=_0x44b4e8['x']+Math['floor']((_0x44b4e8['width']-_0x64a557)/0x2);this[_0x3f0fe8(0x112)](_0x56329,_0x4d2c5b,_0x44b4e8['y'],_0x64a557);}else this['_categoryWindow'][_0x3f0fe8(0x234)](),this[_0x3f0fe8(0x155)][_0x3f0fe8(0x114)]();}else _0x3f0fe8(0x22f)===_0x3f0fe8(0x1cb)?(this['_isFullScreen']()?_0x30638c[_0x3f0fe8(0x181)]=![]:_0x2d3ffc[_0x3f0fe8(0x181)]=!![],_0x214c1e[_0x3f0fe8(0x120)](),_0x2cc0f7[_0x3f0fe8(0x1e9)][_0x3f0fe8(0x175)]['call'](this),_0x1ba451[_0x3f0fe8(0xf7)]()):this['drawTextEx'](_0x56329,_0x44b4e8['x'],_0x44b4e8['y'],_0x64a557);}},Window_OptionsCategory[_0x40271e(0x1fb)][_0x40271e(0x26b)]=function(_0x2448dc){const _0x1bd581=_0x40271e;this[_0x1bd581(0x135)](_0x2448dc)[_0x1bd581(0x14c)](/\\I\[(\d+)\]/i);const _0x5c09c6=Number(RegExp['$1'])||0x0,_0x3ce638=this['itemLineRect'](_0x2448dc),_0x33ef49=_0x3ce638['x']+Math['floor']((_0x3ce638[_0x1bd581(0x1ad)]-ImageManager[_0x1bd581(0x224)])/0x2),_0x16fa85=_0x3ce638['y']+(_0x3ce638[_0x1bd581(0x15e)]-ImageManager[_0x1bd581(0xcd)])/0x2;this[_0x1bd581(0x14a)](_0x5c09c6,_0x33ef49,_0x16fa85);},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x10e)]=Window_Options['prototype'][_0x40271e(0xee)],Window_Options['prototype'][_0x40271e(0xee)]=function(_0x13b892){const _0x793afc=_0x40271e;this['_name']=null,this[_0x793afc(0x1d8)]=null,VisuMZ['OptionsCore']['Window_Options_initialize']['call'](this,_0x13b892);},Window_Options['prototype'][_0x40271e(0xb1)]=function(){const _0x27f189=_0x40271e;return Imported['VisuMZ_0_CoreEngine']&&Window_HorzCommand[_0x27f189(0x1fb)][_0x27f189(0xb1)][_0x27f189(0xf3)](this);},Window_Options[_0x40271e(0x1fb)][_0x40271e(0x111)]=function(){const _0xbfe0=_0x40271e;if(this[_0xbfe0(0x1ff)]()){if(_0xbfe0(0xe0)===_0xbfe0(0xe0)){const _0x5afbc6=this[_0xbfe0(0x1b7)]();if(Input['isRepeated']('down')){if(Input[_0xbfe0(0x1f0)](_0xbfe0(0x166))){if(_0xbfe0(0x104)!==_0xbfe0(0x104))return _0x60014b['uiInputPosition'];else this[_0xbfe0(0x15c)]();}else{if(_0xbfe0(0x23c)===_0xbfe0(0x23c))this[_0xbfe0(0x240)](Input[_0xbfe0(0xdd)](_0xbfe0(0x17c)));else return _0x2be561[_0xbfe0(0x192)];}}if(Input[_0xbfe0(0x15b)]('up')){if(Input[_0xbfe0(0x1f0)](_0xbfe0(0x166)))this[_0xbfe0(0x1af)]();else{if(_0xbfe0(0x94)==='KOpfe')this[_0xbfe0(0x1fd)](Input['isTriggered']('up'));else{_0x29c002&&_0x117256['displayFPS']!==_0x2fa041&&(_0x266c7b['displayFPS']=_0x501756[_0xbfe0(0x225)](),_0x2b2e53[_0xbfe0(0x120)]());if(_0x5d0463&&_0xb8dea5[_0xbfe0(0x214)]){const _0x1a502c=_0x35ba56[_0xbfe0(0x214)];_0x1a502c[_0xbfe0(0xce)](),_0x1a502c[_0xbfe0(0xd9)]===_0x233f1f&&_0x1a502c['refreshWindows']();}}}}Input[_0xbfe0(0x15b)](_0xbfe0(0xf2))&&this['cursorRight'](Input[_0xbfe0(0xdd)]('right')),Input[_0xbfe0(0x15b)](_0xbfe0(0x25e))&&(_0xbfe0(0x21a)!==_0xbfe0(0x189)?this[_0xbfe0(0x1ba)](Input['isTriggered']('left')):this[_0xbfe0(0x155)][_0xbfe0(0xad)](this['currentData']())),this[_0xbfe0(0x1b7)]()!==_0x5afbc6&&this[_0xbfe0(0x12a)]();}else this[_0xbfe0(0x246)](_0x49d899);}},Window_Options['prototype']['setCategory']=function(_0x5752e6){const _0x598c79=_0x40271e;if(!_0x5752e6)return;if(_0x5752e6[_0x598c79(0x128)]===this[_0x598c79(0xca)])return;this[_0x598c79(0xca)]=_0x5752e6[_0x598c79(0x128)],this[_0x598c79(0x1d8)]=_0x5752e6[_0x598c79(0x1b5)],this[_0x598c79(0x8a)](0x0,0x0),this[_0x598c79(0xa7)]();if(this[_0x598c79(0xb1)]())this[_0x598c79(0xcb)](0x0);},Window_Options['prototype'][_0x40271e(0xaa)]=function(){const _0x579ae8=_0x40271e;if(!this[_0x579ae8(0x1d8)])return;this[_0x579ae8(0x97)]=[];for(const _0x4bea9e of this[_0x579ae8(0x1d8)]){if(!_0x4bea9e[_0x579ae8(0x17b)][_0x579ae8(0xf3)](this))continue;let _0x5851a1=_0x4bea9e['TextStr'];if(['',_0x579ae8(0x89)][_0x579ae8(0x18f)](_0x5851a1))_0x5851a1=_0x4bea9e['TextJS'][_0x579ae8(0xf3)](this);const _0x488259=_0x4bea9e[_0x579ae8(0x226)];_0x488259>0x0&&(_0x5851a1=_0x579ae8(0x10b)['format'](_0x488259,_0x5851a1));const _0x413241=_0x4bea9e[_0x579ae8(0xe2)],_0x40c927=_0x4bea9e['EnableJS'][_0x579ae8(0xf3)](this),_0x170232=_0x4bea9e[_0x579ae8(0x24e)][_0x579ae8(0xf3)](this);this[_0x579ae8(0x208)](_0x5851a1,_0x413241,_0x40c927,_0x170232),this[_0x579ae8(0x97)][_0x579ae8(0x266)](_0x4bea9e);}},VisuMZ['OptionsCore']['Window_Options_drawItem']=Window_Options[_0x40271e(0x1fb)][_0x40271e(0x203)],Window_Options[_0x40271e(0x1fb)]['drawItem']=function(_0x268ba3){const _0x2fc315=_0x40271e;this[_0x2fc315(0xb6)](),this[_0x2fc315(0xd4)](this[_0x2fc315(0x1ac)](_0x268ba3));const _0x22ed31=this[_0x2fc315(0x21c)][_0x268ba3][_0x2fc315(0x20b)];this['_currentDrawingIndex']=_0x268ba3;try{this[_0x2fc315(0x97)][_0x268ba3]['DrawJS'][_0x2fc315(0xf3)](this,_0x22ed31,_0x268ba3);}catch(_0x436d48){_0x2fc315(0x102)===_0x2fc315(0x191)?this[_0x2fc315(0x20a)]=_0x614ac3[_0x2fc315(0x262)](_0x28876a[_0x2fc315(0x13d)]):VisuMZ[_0x2fc315(0x1e9)][_0x2fc315(0x183)][_0x2fc315(0xf3)](this,_0x268ba3);}this['_currentDrawingIndex']=undefined;},VisuMZ['OptionsCore']['Window_Options_processOk']=Window_Options[_0x40271e(0x1fb)]['processOk'],Window_Options['prototype'][_0x40271e(0x20f)]=function(){const _0xa77694=_0x40271e,_0x4f5483=this['index'](),_0x59f56c=this[_0xa77694(0x124)](_0x4f5483);if(!this[_0xa77694(0x1ac)](_0x4f5483)){this[_0xa77694(0x265)]();return;}try{this[_0xa77694(0x97)][_0x4f5483][_0xa77694(0x148)][_0xa77694(0xf3)](this,_0x59f56c,_0x4f5483);}catch(_0x71f5b1){_0xa77694(0xbe)!==_0xa77694(0x15a)?VisuMZ[_0xa77694(0x1e9)]['Window_Options_processOk'][_0xa77694(0xf3)](this):this[_0xa77694(0x97)][_0x25d644]['ProcessOkJS'][_0xa77694(0xf3)](this,_0x11c711,_0x45dc19);}},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x1b8)]=Window_Options[_0x40271e(0x1fb)][_0x40271e(0xea)],Window_Options[_0x40271e(0x1fb)][_0x40271e(0xea)]=function(){const _0x370943=_0x40271e,_0x3e7107=this['index'](),_0x539024=this[_0x370943(0x124)](_0x3e7107);if(!this[_0x370943(0x1ac)](_0x3e7107)){if(_0x370943(0x237)===_0x370943(0x237)){this[_0x370943(0x265)]();return;}else _0x26e435*=0x2**(_0x167a2c[_0x370943(0xe5)]||0x0);}try{this[_0x370943(0x97)][_0x3e7107][_0x370943(0x1da)][_0x370943(0xf3)](this,_0x539024,_0x3e7107);}catch(_0x2bef5a){VisuMZ[_0x370943(0x1e9)][_0x370943(0x1b8)][_0x370943(0xf3)](this);}},VisuMZ[_0x40271e(0x1e9)][_0x40271e(0x168)]=Window_Options[_0x40271e(0x1fb)]['cursorLeft'],Window_Options[_0x40271e(0x1fb)][_0x40271e(0x1ba)]=function(){const _0x589929=_0x40271e,_0x49d353=this[_0x589929(0x1b7)](),_0x500b49=this[_0x589929(0x124)](_0x49d353);if(!this[_0x589929(0x1ac)](_0x49d353)){this['playBuzzerSound']();return;}try{if(_0x589929(0x138)==='rdLkD'){const _0x8d627e=_0x59d553[_0x589929(0x214)];_0x8d627e['constructor']===_0x257160&&_0x246166(_0x8d627e['refreshWindows'][_0x589929(0xd2)](_0x8d627e),0x64);}else this[_0x589929(0x97)][_0x49d353][_0x589929(0x196)][_0x589929(0xf3)](this,_0x500b49,_0x49d353);}catch(_0x45f80b){VisuMZ[_0x589929(0x1e9)][_0x589929(0x168)][_0x589929(0xf3)](this);}},Window_Options['prototype'][_0x40271e(0x1f9)]=function(_0x2b250d){return ConfigManager[_0x2b250d];},Window_Options['prototype'][_0x40271e(0x17d)]=function(_0x20ee6e,_0x340fe5){ConfigManager[_0x20ee6e]=_0x340fe5;},Window_Options['prototype']['prepareOptionsCoreSceneChange']=function(){const _0x1f5ffc=_0x40271e;$gameTemp[_0x1f5ffc(0x149)]={'category':SceneManager[_0x1f5ffc(0x214)][_0x1f5ffc(0xf5)][_0x1f5ffc(0x1b7)](),'index':this[_0x1f5ffc(0x1b7)](),'scrollX':this[_0x1f5ffc(0xb3)],'scrollY':this[_0x1f5ffc(0x216)]};},Window_Options['prototype']['updateButtonVisibility']=function(){SceneManager['_scene']['updateButtonVisibility']();},Window_Options[_0x40271e(0x1fb)][_0x40271e(0xdb)]=function(){const _0x28478a=_0x40271e;SceneManager[_0x28478a(0x214)][_0x28478a(0xce)]();},Window_Options[_0x40271e(0x1fb)]['updateWindowPositions']=function(){const _0x7e628b=_0x40271e;SceneManager['_scene'][_0x7e628b(0x11e)]();},Window_Options[_0x40271e(0x1fb)][_0x40271e(0x193)]=function(){const _0xed7eb9=_0x40271e;if(SceneManager[_0xed7eb9(0x214)][_0xed7eb9(0xd9)]!==Scene_Options)return;SceneManager[_0xed7eb9(0x214)][_0xed7eb9(0x193)]();},Window_Options[_0x40271e(0x1fb)][_0x40271e(0x228)]=function(_0x35e213,_0x4707cf,_0x5735ec,_0x3e3b75,_0x429bfe){const _0x53613a=_0x40271e,_0x32c42c=this[_0x53613a(0x241)][_0x53613a(0xab)];this['_currentDrawingIndex']>=0x0&&(!this[_0x53613a(0x1ac)](this['_currentDrawingIndex'])&&this[_0x53613a(0xd4)](![])),Window_Command['prototype']['drawText'][_0x53613a(0xf3)](this,_0x35e213,_0x4707cf,_0x5735ec,_0x3e3b75,_0x429bfe),this[_0x53613a(0x241)][_0x53613a(0xab)]=_0x32c42c;},Window_Options[_0x40271e(0x1fb)][_0x40271e(0x112)]=function(_0x557d62,_0x499c96,_0x455124,_0x1a7dce){const _0x23aa70=_0x40271e;this['resetFontSettings']();const _0x3d9831=this['contents'][_0x23aa70(0xab)];if(this[_0x23aa70(0x1aa)]>=0x0){if(_0x23aa70(0xa3)===_0x23aa70(0xa3))!this[_0x23aa70(0x1ac)](this[_0x23aa70(0x1aa)])&&('aSSZt'!==_0x23aa70(0x19f)?this[_0x23aa70(0xd4)](![]):(_0x2f3278[_0x23aa70(0x1e9)][_0x23aa70(0x233)]['call'](this,_0x2ac03d),this[_0x23aa70(0xc9)](_0x483c1f)));else{if(_0x151f88['assistGodmode']&&_0x40d30c===this['deathStateId']())return!![];if(_0x50b5ae[_0x23aa70(0xf6)]&&_0x2b08d6[_0x23aa70(0x105)]){const _0x4fccb0=_0x10b93f[_0x369508];if(_0x4fccb0&&_0x4fccb0['categories']&&_0x4fccb0['categories'][_0x23aa70(0x18f)](_0x23aa70(0x95)))return!![];}}}const _0x2379cc=this[_0x23aa70(0x14b)](_0x557d62,_0x499c96,_0x455124,_0x1a7dce);this[_0x23aa70(0x1c9)](_0x2379cc);const _0x2224bd=_0x2379cc[_0x23aa70(0x247)];return this[_0x23aa70(0x241)][_0x23aa70(0xab)]=_0x3d9831,_0x2224bd;};