//=============================================================================
// VisuStella MZ - Items & Equips Core
// VisuMZ_1_ItemsEquipsCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_ItemsEquipsCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.ItemsEquipsCore = VisuMZ.ItemsEquipsCore || {};
VisuMZ.ItemsEquipsCore.version = 1.52;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 1] [Version 1.52] [ItemsEquipsCore]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Items_and_Equips_Core_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Items & Equips Core makes improvements to the RPG Maker MZ item and
 * equipment dedicated scenes (including the shop) and how they're handled.
 * From more item categories, better parameter control, rulings, and more, game
 * devs are able to take control over key aspects of their game's items.
 *
 * Features include all (but not limited to) the following:
 *
 * * Modifying the appearances to the Item Scene, Equip Scene, and Shop Scene.
 * * Categorizing items in unique and multiple categories.
 * * Item Scene and Shop Scene will now display detailed information on items.
 * * NEW! marker can be displayed over recently acquired items in-game.
 * * Equipment notetags to adjust parameters past the editor limitations.
 * * Equipment Rulings to adjust what slot types can and can't be unequipped
 *   and/or optimized.
 * * Equipment Type Handling offers more control over equipment loadouts.
 * * Items sold in shops can be hidden/shown based on Switches.
 * * Items sold in shops can have varying prices adjusted by notetags.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 1 ------
 *
 * This plugin is a Tier 1 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes: New Hard-Coded Features
 * ============================================================================
 *
 * This plugin adds some new hard-coded features to RPG Maker MZ's functions.
 * The following is a list of them.
 *
 * ---
 *
 * Equipment Type Handling
 *
 * - Characters will no longer have one universal equipment slot setting.
 * Classes can have different equipment type loadouts, made possible through
 * the usage of notetags. Also, equipment types of matching names would be
 * treated as the same type, where previously, they would be different types.
 * This means if you have two "Accessory" slots, be it in the form of notetags
 * or through the Database > Types tab, they can both equip the same type of
 * accessories.
 *
 * - The Change Equip event command is now updated to reflect this new change.
 * When processing an equip change, the slot changed will go to the first
 * empty slot of matching type. If all of the actor's matching slot types are
 * equipped, then the equip will replace the last slot available.
 *
 * ---
 *
 * Shop Status Window
 *
 * - The Status Window found in the Shop Scene was originally barren and did
 * not display much information at all. This is changed through this plugin's
 * new features. While the contents of the Shop Status Window can be customized
 * through the Plugin Parameters, it is a change that cannot be reversed and
 * for the better since it gives players the much needed information revolving
 * around the game's items.
 *
 * ---
 *
 * Core Engine Compatibility: Modern Controls
 *
 * - If the VisuStella Core Engine is added to your game with Modern Controls
 * enabled, then the Item Menu Scene, Equip Menu Scene, and Shop Menu Scene's
 * controls will be changed a bit.
 *
 * - The Item Menu Scene will automatically have the Item List Window active,
 * with using the Left/Right (for single column) or Page Up/Page Down (for
 * multi-columns) to navigate between the Item Categories. Similar will occur
 * when trying to sell items in the Shop Menu Scene.
 *
 * - The Equip Menu Scene will automatically have the Equip Slots Window active
 * and only activate the command window upon moving up to it.
 *
 * ---
 *
 * ============================================================================
 * VisuStella MZ Compatibility
 * ============================================================================
 *
 * While this plugin is compatible with the majority of the VisuStella MZ
 * plugin library, it is not compatible with specific plugins or specific
 * features. This section will highlight the main plugins/features that will
 * not be compatible with this plugin or put focus on how the make certain
 * features compatible.
 * 
 * ---
 * 
 * VisuMZ_1_BattleCore
 * 
 * Changing the "Damage Multiplier" or "Healing Multiplier" vocabulary for the
 * Item and Equip Core's Shop Status Window is not done with the Item and Equip
 * Core's Plugin Parameters if you have the Battle Core installed.
 * 
 * Instead, go to Battle Core's Plugin Parameters, Damage Settings, Damage
 * Styles, and adjust the style's version of the "Damage Multiplier" or
 * "Healing Multiplier" text instead.
 * 
 * Why does this work this way? Because not all damage styles work off
 * "Multipliers" so in order for it to convey the proper message to the player,
 * each damage style has its own vocabulary to be more accurate.
 * 
 * In case you forget about that, when you visit the Item and Equip Core's
 * plugin parameters for these, it should also remind you in the parameter's
 * description on where to change it.
 * 
 * ---
 *
 * VisuMZ_2_WeaponSwapSystem
 *
 * The custom equip slots feature from the VisuStella MZ Items and Equips Core
 * allowed you to add in extra weapon slots. This is now curated up to a max
 * of one weapon slot per character. This needs to be done to make the Weapon
 * Swap System viable.
 *
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 * 
 * ---
 *
 * === General ===
 * 
 * These notetags affect the Items, Weapons, and Armors on a general scale.
 *
 * ---
 *
 * <Max: x>
 *
 * - Used for: Item, Weapon, Armor Notetags
 * - Determines the maximum quantity that can be held for this item.
 * - Replace 'x' with a number value to determine the maximum amount.
 *
 * ---
 *
 * <Color: x>
 * <Color: #rrggbb>
 *
 * - Used for: Item, Weapon, Armor, Skill Notetags
 * - Determines the color of the object inside the in-game menus.
 * - Replace 'x' with a number value depicting a window text color.
 * - Replace 'rrggbb' with a hex color code for a more custom color.
 *
 * ---
 *
 * <Category: x>
 *
 * - Used for: Item, Weapon, Armor Notetags
 * - Arranges items into certain/multiple categories to work with the Category
 *   Plugin Parameter setting: "Category:x".
 * - Replace 'x' with a category name to mark this item as.
 *
 * ---
 *
 * <Categories>
 *  x
 *  x
 * </Categories>
 *
 * - Used for: Item, Weapon, Armor Notetags
 * - Arranges items into certain/multiple categories to work with the Category
 *   Plugin Parameter setting: "Category:x".
 * - Replace each 'x' with a category name to mark this item as.
 *
 * ---
 * 
 * <Conserve: x%>
 * 
 * - Used for: Item
 * - Gives the item a percent chance when used to not consume the item.
 * - Replace 'x' with a number representing the percent chance to successfully
 *   conserve the item.
 * - If an item cannot be consumed, conserve chance will be 100% regardless.
 * 
 * ---
 *
 * === Item Accessibility Notetags ===
 *
 * The following notetags allow you to choose when items can/cannot be used
 * based on switches.
 *
 * ---
 *
 * <Enable Switch: x>
 *
 * <Enable All Switches: x,x,x>
 * <Enable Any Switches: x,x,x>
 *
 * - Used for: Item Notetags
 * - Determines the enabled status of the item based on switches.
 * - Replace 'x' with the switch ID to determine the item's enabled status.
 * - If 'All' notetag variant is used, item will be disabled until all
 *   switches are ON. Then, it would be enabled.
 * - If 'Any' notetag variant is used, item will be enabled if any of the
 *   switches are ON. Otherwise, it would be disabled.
 *
 * ---
 *
 * <Disable Switch: x>
 *
 * <Disable All Switches: x,x,x>
 * <Disable Any Switches: x,x,x>
 *
 * - Used for: Item Notetags
 * - Determines the enabled status of the item based on switches.
 * - Replace 'x' with the switch ID to determine the item's enabled status.
 * - If 'All' notetag variant is used, item will be enabled until all switches
 *   are ON. Then, it would be disabled.
 * - If 'Any' notetag variant is used, item will be disabled if any of the
 *   switches are ON. Otherwise, it would be enabled.
 *
 * ---
 *
 * === JavaScript Notetags: Item Accessibility ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine if an item can be accessible by code.
 *
 * ---
 *
 * <JS Item Enable>
 *  code
 *  code
 *  enabled = code;
 * </JS Item Enable>
 *
 * - Used for: Item Notetags
 * - Determines the enabled status of the item based on JavaScript code.
 * - If the actor this is disabled for is the only party member, it will not be
 *   visible in the item list unless the VisuStella Battle Core is installed.
 *   - If the VisuStella Battle Core is installed, then all battle scope items
 *     will be visible even if they're disabled.
 * - Replace 'code' to determine the type enabled status of the item.
 * - The 'enabled' variable returns a boolean (true/false) to determine if the
 *   item will be enabled or not.
 * - The 'user' variable refers to the user with the item.
 * - The 'item' variable refers to the item being checked.
 * - All other item conditions must be met in order for this to code to count.
 *
 * ---
 *
 * === Equipment Notetags ===
 *
 * The following notetags provide equipment-related effects from deciding what
 * equip slots can be given to classes to the base parameter changes asigned
 * to weapons and armors.
 *
 * ---
 *
 * <Equip Slots>
 *  slotName
 *  slotName
 *  slotName
 * </Equip Slots>
 *
 * - Used for: Class Notetags
 * - Changes the equipment slot loadout for any actor who is that class.
 * - Replace 'slotName' with an Equipment Type name from Database > Types.
 *   This is case-sensitive.
 * - Insert or remove as many "slotName" equipment types as needed.
 *
 * ---
 *
 * <param: +x>
 * <param: -x>
 *
 * - Used for: Weapon, Armor Notetags
 * - Changes the base parameter value for the equip item.
 * - Replace 'param' with any of the following: 'MaxHP', 'MaxMP', 'ATK', 'DEF',
 *   'MAT', 'MDF', 'AGI', or 'LUK' to change that specific parameter's value.
 *   - These notetags do NOT work with X Parameters, S Parameters, or any
 *     custom parameters. These notetags ONLY work with the base parameters.
 * - Replace 'x' with a number value to set the parameter value to.
 * - This allows you to bypass the Database Editor's number limitations.
 *
 * ---
 * 
 * <Equip Copy Limit: x>
 * 
 * - Used for: Weapon, Armor Notetags
 * - Sets a maximum number of copies that the actor can wear of this equipment.
 * - Replace 'x' with a number value to determine the copy limit.
 * - This can be bypassed using Event Commands and/or Script Calls.
 * - Usage Example: Actors can only equip one copy of the "One-of-a-Kind Ring"
 *   on at any time despite having empty accessory slots because the ring has a
 *   <Equip Copy Limit: 1> notetag.
 * 
 * ---
 * 
 * <Equip Weapon Type Limit: x>
 * 
 * - Used for: Weapon
 * - This weapon cannot be equipped with other weapons of the same type once
 *   the limited amount has been reached.
 * - Replace 'x' with a number value to determine the weapon type limit.
 * - This can be bypassed using Event Commands and/or Script Calls.
 * - Usage Example: A dualwielding warrior who can only equip one sword and a
 *   dagger but never two swords or two daggers because the swords and daggers
 *   all have the <Equip Weapon Type Limit: 1> notetags on them.
 * 
 * ---
 * 
 * <Equip Armor Type Limit: x>
 * 
 * - Used for: Armor
 * - This armor cannot be equipped with other armors of the same type once the
 *   limited amount has been reached.
 * - Replace 'x' with a number value to determine the armor type limit.
 * - This can be bypassed using Event Commands and/or Script Calls.
 * - Usage Example: People cannot equip more than two glove accessories on at a
 *   time because the glove is a "Glove" armor-type and each glove item has the
 *   <Equip Armor Type Limit: 2> notetags on them.
 * 
 * ---
 * 
 * <Party Artifact>
 * <Troop Artifact>
 * 
 * <Stackable Party Artifact>
 * <Stackable Troop Artifact>
 * 
 * - Used for: Armor
 * - This armor cannot be equipped at all. However, by simply being in the
 *   party's inventory, its parameter bonuses and traits will be applied
 *   globally throughout the whole party or troop (depending on the notetag).
 * - Add both notetags to affect both groups.
 * - The normal versions of the notetag is only applied once regardless of the
 *   number of copies are found in the party's inventory.
 * - The stackable versions of the notetag will have the bonuses and traits
 *   stacked multiple times relative to the number of copies found in the
 *   party's inventory.
 * - This item will NOT be added during the setup phase for Battle Tests.
 *   - If you want to add the item, do it manually.
 * 
 * ---
 * 
 * <Equip For Class Only: x>
 * <Equip For Classes Only: x, x, x>
 * <Equip For Class Only: name>
 * <Equip For Classes Only: name, name, name>
 * 
 * - Used for: Weapon, Armor Notetags
 * - This piece of equipment can only be worn by members with 'x' as the main
 *   class. If there are multiple classes listed, at least one of them need to
 *   be the actor's main class.
 * - Replace 'x' with a number representing the ID of the class required.
 * - For the 'name' variant, replace 'name' with the name of the required class
 *   the actor needs to have in order to equip this object.
 * 
 * ---
 * 
 * <Equip Requirements>
 *  requirement
 *  requirement
 *  requirement
 * </Equip Requirements>
 * 
 * - Used for: Weapon, Armor Notetags
 * - Defines a requirement(s) for the actor to meet in order for the equip item
 *   to be equippable.
 * - Failure to meet these requirements will cause the equipment to unequip
 *   automatically.
 *   - Keep in mind that in some cases, this will not happen immediately.
 *     Things like switches will require the actor to meet its cache clear
 *     in order to trigger the automatic unequip.
 *   - Some ways to trigger a cache clear would be to change the actor's HP/MP,
 *     or adding and then removing a state for the actor (preferrably an unused
 *     state that has no real effect).
 * - Replace 'requirement' with one of the settings bellow:
 * - Add multiple 'requirement' lines for more requirements.
 * 
 *   Requirements:
 *
 *   param > x
 *   param >= x
 *   param === x
 *   param <= x
 *   param < x
 *   - Replace 'param' with 'level', 'maxhp', 'maxmp', 'atk', 'def', 'mat',
 *     'mdf', 'agi', or 'luk'.
 *   - This will make the piece of equipment require the actor's base parameter
 *     to be greater than (>), greater than or equal to (>=), equal to (===),
 *     less than or equal to (<=), or less than (<).
 *   - This is NOT the value for the total parameter, only the base parameter.
 *   - The base parameter is calculated by the user's class parameter value and
 *     any bonuses received through permanent stat increases.
 *
 *   learned skill: x
 *   learned skill: name
 *   - This will make the piece of equipment require the actor to have learned
 *     skill 'x'. 
 *   - If 'name' is used, priority will be given to the skill with the highest
 *     ID in the database.
 *   - The actor needs to have LEARNED the skill. This means that if you have
 *     added a skill to the actor's kit through a trait, it will not count.
 *
 *   switch: x
 *   - This will require switch X to be on.
 *   - If it isn't, the piece of equipment cannot be worn.
 *   - Insert multiple of these to add more switches that are are required to
 *     be on.
 * 
 *   ***NOTE 1***
 *   There is no "class: x" for these equip requirements. Instead, use the
 *   <Equip For Class Only: x> notetags.
 * 
 *   ***NOTE 2***
 *   For those wondering where "unique only" is, that does not exist in this
 *   plugin. Instead, use the <Equip Copy Limit: x> notetag listed above.
 * 
 *   Example A:
 * 
 *     <Equip Requirements>
 *     level >= 20
 *     </Equip Requirements>
 * 
 *     - Requires the user to be at least level 20 in order to equip.
 * 
 *   Example B:
 * 
 *     <Equip Requirements>
 *     atk >= 50
 *     def <= 50
 *     </Equip Requirements>
 *     - Requires the user have at least 50 base ATK to equip.
 *     - Requires the user to be under 50 base DEF to equip.
 * 
 * ---
 * 
 * <Added EType: x>
 * <Added ETypes: x, x, x>
 * 
 * - Used for: Armor Notetags
 * - This is for armors only and does NOT work with weapons!
 * - Allows a piece of armor to belong to multiple ETypes. This means a glove
 *   can be equipped as "Armgear" or as an "Accessory" if you so choose.
 * - Replace 'x' with a number representing the ID of the EType you wish to add
 *   to the list of ETypes.
 *   - Insert multiple 'x' entries to add more than one EType ID.
 * 
 * ---
 * 
 * <Cursed>
 * 
 * - Used for: Weapon, Armor Notetags
 * - If this weapon or armor is equipped, it cannot manually be removed by the
 *   player until it is purified.
 * - To remove it, it must be done by event commands, script calls, or through
 *   the Purify-related Plugin Commands provided by this plugin.
 * - Once purified, the weapon or armor will become unequipped unless it has a
 *   purify transformation.
 *   - If the newly transformed weapon/armor is equippable, it will remain in
 *     the actor's equipment slots.
 * - If you are using VisuMZ_2_WeaponSwapSystem, weapons cannot become cursed
 *   in order to allow free weapon swapping. Weaponry will not be cursed
 *   if VisuMZ_2_WeaponSwapSystem is installed.
 * 
 * ---
 * 
 * <Purify Transform: id>
 * <Purify Transform: name>
 * 
 * - Used for: Weapon, Armor Notetags
 * - If this notetag is present on a <Cursed> weapon or armor, then upon the
 *   actor receiving purification, the weapon or armor will transform into a
 *   different item.
 * - Replace 'id' with a number representing the transformed weapon/armor's ID.
 * - Replace 'name' with text representing the transformed weapon/armor's name.
 * - Weapons can only transform into weapons.
 * - Armors can only transform into armors.
 * 
 * ---
 *
 * === JavaScript Notetags: Equipment ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * adjust the parameter through code.
 *
 * ---
 *
 * <JS Parameters>
 *  MaxHP = code;
 *  MaxMP = code;
 *  ATK = code;
 *  DEF = code;
 *  MAT = code;
 *  MDF = code;
 *  AGI = code;
 *  LUK = code;
 * </JS Parameters>
 *
 * - Used for: Weapon, Armor Notetags
 * - Uses JavaScript to determine the values for the basic parameters based on
 *   the code used to calculate its value.
 * - The variables 'MaxHP', 'MaxMP', 'ATK', 'DEF', 'MAT', 'MDF', 'AGI', and
 *   'LUK' are used to determine the finalized value of the parameter. This
 *   variable is case sensitive.
 * - If a parameter is not present, its value will be treated as +0.
 *
 * ---
 *
 * === Status Window Notetags ===
 *
 * The following notetags will affect the Shop Status Window info. If for any
 * reason the data that is displayed is not to your liking or insufficient,
 * you can change it up using the following notetags.
 *
 * ---
 *
 * <Status Info>
 *  key: data
 *  key: data
 *  key: data
 * </Status Info>
 *
 * - Used for: Skill, Item Notetags
 * - If you do not like the generated data that's displayed, you can change it
 *   using this notetag to display what you want.
 * - Replace 'key' with one of the following:
 *   - Consumable
 *   - Quantity
 *   - Occasion
 *   - Scope
 *   - Speed
 *   - Success Rate
 *   - Repeat
 *   - Hit Type
 *   - Element
 *   - Damage Multiplier
 *   - HP Recovery
 *   - MP Recovery
 *   - TP Recovery
 *   - HP Damage
 *   - MP Damage
 *   - TP Damage
 *   - User TP Gain
 *   - Added Effects
 *   - Removed Effects
 * - Replace 'data' with the text data you want to visually appear. You may use
 *   text codes for this.
 * - This only affects info entries that are already visible and won't make
 *   other categories suddenly appear.
 * - Insert or remove as many "key: data" lines as needed.
 *
 * ---
 *
 * <Custom Status Info>
 *  key: data
 *  key: data
 *  key: data
 * </Custom Status Info>
 *
 * - Used for: Skill, Item
 * - If you want custom categories and data to be displayed for your items that
 *   aren't provided by the Shop Status Window Info to begin with, you can use
 *   this notetag to add in your own entries.
 * - Replace 'key' with text of the exact label you want. You may use text
 *   codes for this.
 * - Replace 'data' with text of the exact text data you want. You may use text
 *   codes for this.
 * - Insert or remove as many "key: data" lines as needed.
 *
 * ---
 * 
 * <Shop Picture Name: filename>
 * 
 * - Used for: Skill, Item, Weapon, Armor Notetags
 * - Enables a shop picture for the status window. This image can be seen in
 *   the item scene, shop scene, and skill scene if enabled.
 * - If this notetag is not used, there will be no image.
 * - Replace 'filename' with the filename of the graphic to use from the game
 *   project's img/pictures/ folder. Filenames are case sensitive. Leave out
 *   the filename extension from the notetag.
 * - Use the supporting notetags to determine where the image appears. If not,
 *   they will default to the background, fit to the window dimensions,
 *   centered at the middle of the window.
 * 
 * ---
 * 
 * <Shop Picture Layer: Background>
 * <Shop Picture Layer: Foreground>
 * 
 * - Used for: Skill, Item, Weapon, Armor Notetags
 * - Determines which layer the graphic will be drawn on.
 * - If the background layer is selected, the picture will appear behind the
 *   data text.
 * - If the foreground layer is selected, the picture will appear in front of
 *   the data text.
 * - If this notetag is not used, it will default to the background layer.
 * 
 * ---
 * 
 * <Shop Picture Max Width: x>
 * <Shop Picture Max Height: y>
 * <Shop Picture Max Dimensions: x, y>
 * 
 * - Used for: Skill, Item, Weapon, Armor Notetags
 * - Determines the maximum width and/or height for the image.
 * - This means the image will be automatically scaled proportionally to that
 *   width or height as long as everything else does not break boundaries.
 * - Replace 'x' and 'y' with number values representing the maximum dimensions
 *   the image can be in pixels.
 * - If these notetags are not used, the image will be automatically scaled to
 *   the dimensions of the shop status window.
 * 
 * ---
 * 
 * <Shop Picture Alignment: Left>
 * <Shop Picture Alignment: Center>
 * <Shop Picture Alignment: Right>
 * 
 * - Used for: Skill, Item, Weapon, Armor Notetags
 * - Adjusts the horizontal alignment for the image.
 * - Left, center, right determines how it's aligned horizontally if the
 *   image does not horizontally fit in the width of the window.
 * - If any of these notetags are not used, the image will default to the
 *   'center' alignment.
 * 
 * ---
 * 
 * <Shop Picture Position: Top>
 * <Shop Picture Position: Middle>
 * <Shop Picture Position: Bottom>
 * 
 * - Used for: Skill, Item, Weapon, Armor Notetags
 * - Adjusts the vertical position for the image.
 * - Top, middle, bottom determines how it's positioned vertically if the
 *   image does not vertically fit in the width of the window.
 * - If any of these notetags are not used, the image will default to the
 *   'middle' position.
 * 
 * ---
 * 
 * <Shop Picture Offset X: +x>
 * <Shop Picture Offset X: -x>
 * 
 * <Shop Picture Offset Y: +y>
 * <Shop Picture Offset Y: -y>
 * 
 * <Shop Picture Offset: +x, +y>
 * <Shop Picture Offset: -y, -y>
 * 
 * - Used for: Skill, Item, Weapon, Armor Notetags
 * - Offsets the X and Y positions of the image in the shop status window.
 * - X offsets adjust the horizontal position by x pixels.
 *   - Positive goes right.
 *   - Negative goes left.
 * - Y offsets adjust the horizontal position by y pixels.
 *   - Positive goes down.
 *   - Negative goes up.
 * - Replace 'x' and 'y' with number values representing the pixels to offset
 *   the image by. The '+' and '-' signs are required.
 * - If none of these notetags are used, there will be no offsets.
 * 
 * ---
 * 
 * <Shop Picture Opacity: x>
 * <Shop Picture Opacity: x%>
 * 
 * - Used for: Skill, Item, Weapon, Armor Notetags
 * - Adjusts the opacity of the image used.
 * - When using 'x' and not 'x%', use a number between 0 and 255.
 *   - The closer to 0, the more transparent the image is.
 *   - The closer to 255, the more opaque the image is.
 * - When using 'x%' and not 'x', use a number between 0% and 100%.
 *   - The closer to 0%, the more transparent the image is.
 *   - The closer to 100%, the more opaque the image is.
 * 
 * ---
 *
 * === Shop Menu Notetags ===
 *
 * These notetags adjust how prices and such are managed inside the Shop Menu
 * as well as whether or not some items are visible depending on switch states.
 *
 * ---
 *
 * <Price: x>
 *
 * - Used for: Item, Weapon, Armor Notetags
 * - Adjusts the buying price for this item.
 * - Replace 'x' with a number depicting the desired value for the buy price.
 * - This allows you to bypass the RPG Maker MZ editor's limitation of 999,999.
 *
 * ---
 *
 * <Can Sell>
 * <Cannot Sell>
 *
 * - Used for: Item, Weapon, Armor Notetags
 * - Makes the item either always sellable or cannot be sold.
 * - This bypasses the game's internal hard-coding to prevent items with a
 *   price of 0 from being able to be sold.
 * - This bypasses the game's internal hard-coding to always allow items with
 *   a price value of being able to be sold.
 *
 * ---
 *
 * <Sell Price: x>
 *
 * - Used for: Item, Weapon, Armor Notetags
 * - Changes the sell price to be something different than the default amount.
 * - Replace 'x' with a number depicting the desired value for the sell price.
 *
 * ---
 *
 * <Show Shop Switch: x>
 *
 * <Show Shop All Switches: x,x,x>
 * <Show Shop Any Switches: x,x,x>
 *
 * - Used for: Item, Weapon, Armor Notetags
 * - Determines the visibility of the shop item based on switches.
 * - Replace 'x' with the switch ID to determine the shop item's visibility.
 * - If 'All' notetag variant is used, item will be hidden until all switches
 *   are ON. Then, it would be shown.
 * - If 'Any' notetag variant is used, item will be shown if any of the
 *   switches are ON. Otherwise, it would be hidden.
 *
 * ---
 *
 * <Hide Shop Switch: x>
 *
 * <Hide Shop All Switches: x,x,x>
 * <Hide Shop Any Switches: x,x,x>
 *
 * - Used for: Item, Weapon, Armor Notetags
 * - Determines the visibility of the shop item based on switches.
 * - Replace 'x' with the switch ID to determine the shop item's visibility.
 * - If 'All' notetag variant is used, item will be shown until all switches
 *   are ON. Then, it would be hidden.
 * - If 'Any' notetag variant is used, item will be hidden if any of the
 *   switches are ON. Otherwise, it would be shown.
 *
 * ---
 *
 * <Cannot Sell Switch: x>
 *
 * <Cannot Sell All Switches: x,x,x>
 * <Cannot Sell Any Switches: x,x,x>
 *
 * - Used for: Item, Weapon, Armor Notetags
 * - Determines the sellability of the shop item based on switches.
 * - Replace 'x' with the switch ID to determine the shop item's sellability.
 * - If 'All' notetag variant is used, item cannot be sold until all switches
 *   are ON. Otherwise, it can be sold.
 * - If 'Any' notetag variant is used, item cannot be sold if any of the
 *   switches are ON. Otherwise, it can be sold.
 *
 * ---
 * 
 * <Buy Turn On Switch: x>
 * <Buy Turn On Switches: x, x, x>
 * 
 * - Used for: Item, Weapon, Armor Notetags
 * - When this item, weapon, or armor is bought in the shop scene, turn on the
 *   switch(es) 'x'.
 * - Replace 'x' with a number representing the ID of the switch to turn on.
 *   - Insert multiple 'x' values to turn on multiple switches upon buying.
 * 
 * ---
 * 
 * <Buy Turn Off Switch: x>
 * <Buy Turn Off Switches: x, x, x>
 * 
 * - Used for: Item, Weapon, Armor Notetags
 * - When this item, weapon, or armor is bought in the shop scene, turn off the
 *   switch(es) 'x'.
 * - Replace 'x' with a number representing the ID of the switch to turn off.
 *   - Insert multiple 'x' values to turn off multiple switches upon buying.
 * 
 * ---
 * 
 * <Sell Turn On Switch: x>
 * <Sell Turn On Switches: x, x, x>
 * 
 * - Used for: Item, Weapon, Armor Notetags
 * - When this item, weapon, or armor is sold in the shop scene, turn on the
 *   switch(es) 'x'.
 * - Replace 'x' with a number representing the ID of the switch to turn on.
 *   - Insert multiple 'x' values to turn on multiple switches upon selling.
 * 
 * ---
 * 
 * <Sell Turn Off Switch: x>
 * <Sell Turn Off Switches: x, x, x>
 * 
 * - Used for: Item, Weapon, Armor Notetags
 * - When this item, weapon, or armor is sold in the shop scene, turn off the
 *   switch(es) 'x'.
 * - Replace 'x' with a number representing the ID of the switch to turn off.
 *   - Insert multiple 'x' values to turn off multiple switches upon selling.
 * 
 * ---
 *
 * === JavaScript Notetags: Shop Menu ===
 *
 * The following are notetags made for users with JavaScript knowledge. These
 * notetags are primarily aimed at Buy and Sell prices.
 *
 * ---
 *
 * <JS Buy Price>
 *  code
 *  code
 *  price = code;
 * </JS Buy Price>
 *
 * - Used for: Item, Weapon, Armor Notetags
 * - Replace 'code' to determine the buying 'price' of the item.
 * - Insert the final buy price into the 'price' variable.
 * - The 'item' variable refers to the item being bought.
 *
 * ---
 *
 * <JS Sell Price>
 *  code
 *  code
 *  price = code;
 * </JS Sell Price>
 *
 * - Used for: Item, Weapon, Armor Notetags
 * - Replace 'code' to determine the selling 'price' of the item.
 * - Insert the final sell price into the 'price' variable.
 * - The 'item' variable refers to the item being sold.
 *
 * ---
 *
 * ============================================================================
 * Plugin Commands
 * ============================================================================
 *
 * The following are Plugin Commands that come with this plugin. They can be
 * accessed through the Plugin Command event command.
 *
 * ---
 * 
 * === Actor Plugin Commands ===
 * 
 * ---
 *
 * Actor: Change Equip Slots
 * - Forcefully change the actor(s) equip slots.
 * - These will persist through class changes.
 *
 *   Actor ID(s):
 *   - Select which Actor ID(s) to affect.
 *
 *   Equip Slots:
 *   - Insert the equip slots you want the actor(s) to have.
 *   - These entries are case-sensitive.
 *
 * ---
 *
 * Actor: Reset Equip Slots
 * - Reset any forced equip slots for the actor(s).
 * - Equip slots will then be based on class.
 *
 *   Actor ID(s):
 *   - Select which Actor ID(s) to affect.
 *
 * ---
 * 
 * === Purify Plugin Commands ===
 * 
 * ---
 * 
 * Purify: Target Actor(s)
 * - Purifies target actor(s) of any cursed weapons or armors.
 * - Cannot be used in battle.
 * 
 *   Actor ID(s):
 *   - Select which Actor ID(s) to affect.
 * 
 * ---
 * 
 * Purify: Whole Party
 * - Purifies whole party of any cursed weapons or armors.
 * - Cannot be used in battle.
 * 
 * ---
 * 
 * === Shop Plugin Commands ===
 * 
 * ---
 *
 * Shop: Advanced
 * - Make it easier to put together inventories for a shop.
 * - WARNING: Does not allow for event-specific prices.
 *
 *   Step 1: Item ID's
 *   - Select which Item ID ranges to add.
 *
 *   Step 2: Weapon ID's
 *   - Select which Weapon ID ranges to add.
 *
 *   Step 3: Armor ID's
 *   - Select which Armor ID ranges to add.
 *
 *   Step 4: Purchase Only?
 *   - Make the shop purchase-only?
 * 
 *   Optional:
 * 
 *     Blacklist
 *     - A list of categories to blacklist from the shop.
 *     - Not used if empty. Mark categories with <Category: x>
 * 
 *     Whitelist
 *     - A list of categories to whitelist for the shop.
 *     - Not used if empty. Mark categories with <Category: x>
 *
 * This Plugin Command primarily functions as an alternative to the editor's
 * "Shop Processing" event command as that one requires you to add items one at
 * a time, making it extremely tedious to add large amounts of items. This
 * Plugin Command will mitigate that by allowing ID ranges to determine which
 * items to make available.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Item Menu Settings
 * ============================================================================
 *
 * The Item Menu Settings allow you to adjust specifics on how key objects and
 * windows in the Item Menu Scene operate.
 *
 * ---
 *
 * General Window
 *
 *   Use Updated Layout:
 *   - Use the Updated Item Menu Layout provided by this plugin?
 *   - This will automatically enable the Status Window.
 *   - This will override the Core Engine windows settings.
 *
 *   Layout Style:
 *   - If using an updated layout, how do you want to style the menu scene?
 *     - Upper Help, Left Input
 *     - Upper Help, Right Input
 *     - Lower Help, Left Input
 *     - Lower Help, Right Input
 *
 * ---
 *
 * List Window
 * 
 *   Columns:
 *   - Number of maximum columns.
 *   - If you are using the VisuStella MZ Core Engine and the "Modern Controls"
 *     Plugin Parameter, please read through that section in case you have any
 *     questions about how to switch between categories when using multiple
 *     columns of items at a time.
 *
 * ---
 *
 * Item Quantity
 *
 *   Item Max:
 *   Weapon Max:
 *   Armor Max:
 *   - The default maximum quantity for items, weapons, and/or armors.
 * 
 *   Quantity Format:
 *   - How to display an item's quantity.
 *   - %1 - Item Quantity
 *
 *   Font Size:
 *   - Default font size for item quantity.
 *
 * ---
 *
 * Shop Status Window
 * 
 *   Show in Item Menu?:
 *   - Show the Shop Status Window in the Item Menu?
 *   - This is enabled if the Updated Layout is on.
 *
 *   Adjust List Window?:
 *   - Automatically adjust the Item List Window in the Item Menu if using the
 *     Shop Status Window?
 * 
 *   Background Type:
 *   - Select background type for this window.
 *     - 0 - Window
 *     - 1 - Dim
 *     - 2 - Transparent
 *
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this Status Window in the
 *     Item Menu.
 *
 * ---
 *
 * Button Assist Window
 *
 *   Switch Category:
 *   - Button assist text used for switching categories.
 *   - For VisuStella MZ's Core Engine's Button Assist Window.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Item Categories
 * ============================================================================
 *
 * Item Categories appear both in the Item Menu Scene and Shop Menu Scene (but
 * only under the Sell command). These Plugin Parameters give you the ability
 * to add in the specific categories you want displayed, remove the ones you
 * don't, and associate them with icons.
 *
 * ---
 *
 * List
 *
 *   Category List
 *   - A list of the item categories displayed in the Item/Shop menus.
 * 
 *     Type:
 *     - A list of the item categories displayed in the Item/Shop menus.
 *     - Replace x with ID numbers or text.
 *     - AllItems, RegularItems, KeyItems
 *     - HiddenItemA, HiddenItemB
 *     - Consumable, Nonconsumable
 *     - AlwaysUsable, BattleUsable, FieldUsable, NeverUsable
 *     - AllWeapons, WType:x
 *     - AllArmors, AType:x, EType:x
 *     - Category:x
 * 
 *     Icon:
 *     - Icon used for this category.
 *     - Use 0 for no icon.
 * 
 *     Visibility Switch:
 *     - This Switch must be turned ON in order for the category to show.
 *     - Use 0 for no Switch requirement.
 * 
 *     Sort By:
 *     - Sort this category (in Scene_Item and Scene_Shop only) this way.
 *
 *   Style:
 *   - How do you wish to draw categorie entries in the Category Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 *
 *   Text Alignment
 *   - Decide how you want the text to be aligned.
 *
 * ---
 *
 * Vocabulary
 *
 *   Hidden Item A
 *   Hidden Item B
 *   Consumable
 *   Nonconsumable
 *   Always Usable
 *   Battle Usable
 *   Field Usable
 *   Never Usable
 *   - How these categories are named in the Item Menu.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: NEW! Labels
 * ============================================================================
 *
 * Whenever the player receives a new item(s), a NEW! Label can be placed on
 * top of the item's icon when browsing a menu displaying the item(s). This is
 * a quality of life addition from more modern RPG's to help players figure out
 * what they've recently received. The following are Plugin Parameters made to
 * adjust how the NEW! Labels are handled in-game.
 *
 * ---
 *
 * NEW! Labels
 * 
 *   Use NEW! Labels?:
 *   - Use the NEW! Labels or not?
 * 
 *   Icon:
 *   - The icon index used to represent the NEW! text.
 *   - Use 0 to not draw any icons.
 * 
 *   Text:
 *   - The text written on the NEW! Label.
 * 
 *     Font Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors from
 *       the Window Skin.
 * 
 *     Font Size:
 *     - The font size used for the NEW! text.
 * 
 *   Fade Limit:
 *   - What's the upper opaque limit before reversing?
 * 
 *   Fade Speed:
 *   - What's the fade speed of the NEW! Label?
 * 
 *   Offset X:
 *   - How much to offset the NEW! Label's X position by.
 * 
 *   Offset Y:
 *   - How much to offset the NEW! Label's Y position by.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Equip Menu Settings
 * ============================================================================
 *
 * These Plugin Parameters adjust the Equipment Menu Scene, ranging from using
 * a more updated and modern layout, changing the styles of other windows, and
 * other key visual aspects of the Equip Menu Scene. Other settings here allow
 * you to adjust how equipment operate under certain rulings, too.
 *
 * ---
 *
 * General
 * 
 *   Use Updated Layout:
 *   - Use the Updated Equip Layout provided by this plugin?
 *   - This will override the Core Engine windows settings.
 * 
 *     Param Font Size:
 *     - The font size used for parameter values.
 * 
 *     Show Menu Portraits?:
 *     - If Main Menu Core is installed, display the Menu Portraits instead of
 *       the actor's face in the status window?
 * 
 *     JS: Portrait Upper:
 *     - If Menu Portraits are available, this is code used to draw the upper
 *       data like this in the Status Window.
 * 
 *     JS: Face Upper:
 *     - If faces used used, this is code used to draw the upper data like this
 *       in the Status Window.
 * 
 *     JS: Parameter Lower:
 *     - Code to determine how parameters are drawn in the Status Window.
 *
 *   Layout Style:
 *   - If using an updated layout, how do you want to style the menu scene?
 *     - Upper Help, Left Input
 *     - Upper Help, Right Input
 *     - Lower Help, Left Input
 *     - Lower Help, Right Input
 * 
 *   Status Window Width:
 *   - The usual width of the status window if using the non-Updated Equip
 *     Menu Layout.
 * 
 *   Show Back Rectangles?:
 *   - Show back rectangles of darker colors to display information better?
 * 
 *     Back Rectangle Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors
 *       from the Window Skin.
 * 
 *   Cursed Equip Popup:
 *   - Text popup appears when an actor equips a cursed weapon/armor.
 *   - Text codes allowed.
 *   - Requires VisuMZ_0_CoreEngine!
 *   - Empty to not use.
 *   -  %1 - Actor, %2 - Equip, %3 - Icon.
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Command Window.
 * 
 *   Equip Icon:
 *   - The icon used for the Equip command.
 * 
 *     Help Description:
 *     - Help description used when this command is selected.
 *     - Text codes allowed.
 * 
 *   Add Optimize Command?:
 *   - Add the "Optimize" command to the Command Window?
 * 
 *     Help Description:
 *     - Help description used when this command is selected.
 *     - Text codes allowed.
 * 
 *     Optimize Icon:
 *     - The icon used for the Optimize command.
 * 
 *   Add Clear Command?:
 *   - Add the "Clear" command to the Command Window?
 * 
 *     Help Description:
 *     - Help description used when this command is selected.
 *     - Text codes allowed.
 * 
 *     Clear Icon:
 *     - The icon used for the Clear command.
 *
 * ---
 *
 * Remove Equip
 * 
 *   Icon:
 *   - Icon used for equipment removal.
 * 
 *   Text:
 *   - Text used for equipment removal.
 * 
 *   Use SHIFT Shortcut?:
 *   - Add the "Shift" button as a shortcut key to removing items?
 *
 * ---
 *
 * Rulings
 * 
 *   Equip-Adjust HP/MP:
 *   - Adjust HP/MP differences after changing equips with MaxHP/MaxMP values.
 * 
 *   Non-Removable Types:
 *   - Insert ID's of the Equipment Types that must always have an item
 *     equipped and cannot be empty.
 * 
 *   Non-Optimized Types:
 *   - Insert ID's of the Equipment Types that will be ignored when equipment
 *     is being optimized.
 *
 * ---
 *
 * Button Assist Window
 *
 *   SHIFT: Remove:
 *   - Button assist text used for the SHIFT Remove Shortcut.
 *   - For VisuStella MZ's Core Engine's Button Assist Window.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Shop Menu Settings
 * ============================================================================
 *
 * These Plugin Parameters allow you a number of options to adjust the Shop
 * Menu Scene. These options range from enabling an updated and modern layout,
 * adjust how various key visual aspects appear, and determine how prices can
 * be affected when it comes to selling them or buying them (for coders).
 *
 * ---
 *
 * General
 * 
 *   Use Updated Layout:
 *   - Use the Updated Shop Layout provided by this plugin?
 *   - This will override the Core Engine windows settings.
 *
 *   Layout Style:
 *   - If using an updated layout, how do you want to style the menu scene?
 *     - Upper Help, Left Input
 *     - Upper Help, Right Input
 *     - Lower Help, Left Input
 *     - Lower Help, Right Input
 *
 * ---
 * 
 * Switches:
 * 
 *   Switch: Buy:
 *   - Buying items in the Shop Scene turns this Switch to ON.
 *   - Switch reverts to OFF whenever the Shop Scene opens.
 * 
 *   Switch: Sell
 *   - Selling items in the Shop Scene turns this Switch to ON.
 *   - Switch reverts to OFF whenever the Shop Scene opens.
 * 
 * ---
 *
 * Command Window
 * 
 *   Hide Unavailable?:
 *   - Hide all unavailable commands like when a shop is set to Purchase Only?
 * 
 *   Style:
 *   - How do you wish to draw commands in the Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Command Window.
 * 
 *   Buy Icon:
 *   - The icon used for the Buy command.
 * 
 *   Sell Icon:
 *   - The icon used for the Sell command.
 * 
 *   Cancel Icon:
 *   - The icon used for the Cancel command.
 * 
 *   Rename "Cancel":
 *   - Rename Cancel to something more logical for the Shop Menu Scene.
 *
 * ---
 *
 * Prices
 * 
 *   Sell Price Rate:
 *   - The default sell price rate.
 * 
 *   JS: Buy Price:
 *   - Modificatons made to the buy price before finalizing it.
 * 
 *   JS: Sell Price:
 *   - Modificatons made to the sell price before finalizing it.
 *
 * ---
 *
 * Button Assist Window
 *
 *   Small Increment:
 *   Large Increment:
 *   - Text used for changing amount bought/sold.
 *   - For VisuStella MZ's Core Engine's Button Assist Window.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Shop Status Window
 * ============================================================================
 *
 * These Plugin Parameters focuses on the Shop Status Window and determines how
 * its data is displayed.
 *
 * ---
 *
 * General
 * 
 *   Window Width:
 *   - The usual width of the status window.
 * 
 *   Parameter Font Size:
 *   - Font size used for parameter changes.
 * 
 *   Translucent Opacity:
 *   - Opacity setting used for translucent window objects.
 * 
 *   Show Back Rectangles?:
 *   - Show back rectangles of darker colors to display information better?
 * 
 *     Back Rectangle Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors
 *       from the Window Skin.
 *
 * ---
 *
 * Equipment Data
 * 
 *   Already Equipped:
 *   - Marker used to show an actor cannot equip an item.
 * 
 *   Can't Equip:
 *   - Marker used to show an actor cannot equip an item.
 * 
 *   Delay MS:
 *   - How many milliseconds (MS) to delay the preview update?
 *   - This is to prevent lag spikes for equips only.
 * 
 *   No Changes:
 *   - Marker used to show no changes have occurred.
 * 
 *   JS: Draw Equip Data:
 *   - Code used to draw the equipment data for the Shop Status Window.
 *
 * ---
 *
 * Item Data
 * 
 *   Max State/Buff Icons:
 *   - Maximum number of icons that can be displayed for Add/Remove
 *     States/Buffs.
 * 
 *   Multiplier Standard:
 *   - Constant standard to filter out random values when calculating the
 *     damage multiplier.
 * 
 *   JS: Draw Item Data:
 *   - Code used to draw the item data for the Shop Status Window.
 *
 * ---
 *
 * Vocabulary
 * 
 *   Consumable:
 *   Occasions:
 *   Scope:
 *   Speed:
 *   Success Rate:
 *   Repeats:
 *   Hit Type:
 *   Element:
 *   Damage Type:
 *   Effects:
 *   - Vocabulary used for these data entries.
 *   - Some of these have Plugin Parameters have sub-entries.
 * 
 *   NOTE: Regarding Damage Labels
 * 
 *   If Visu_1_BattleCore is installed, priority goes to its Damage Style
 *   settings. The label displayed is based on the damage style settings in
 *   place for that specific skill or item.
 * 
 *   Go to Battle Core > Plugin Parameters > Damage Settings > Style List >
 *   pick the damage style you want to edit > Damage Label and change the
 *   text settings you'd like there.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.52: May 16, 2024
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Irina:
 * *** Parameters > Item Categories > Category List > Category > Sorted By:
 * **** You can now sort specific item categories by ID or Name.
 * **** Only usable within Scene_Item and Scene_Shop.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.51: December 14, 2023
 * * Bug Fixes!
 * ** Fixed a bug where if an item is unequipped, it may cause a crash. Fix
 *    made by Arisu.
 * ** Fixed a bug where <Proxy: id> did not properly give the proxy item. Fix
 *    made by Arisu.
 * 
 * Version 1.50: November 16, 2023
 * * Bug Fixes!
 * ** <JS Buy Price> and <JS Sell Price> was not working properly. Fix made
 *    by Irina.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * * New Features!
 * ** New Notetags added by Arisu:
 * *** <Cursed>
 * **** If this weapon or armor is equipped, it cannot manually be removed by
 *      the player until it is purified.
 * **** To remove it, it must be done by event commands, script calls, or
 *     through the Purify-related Plugin Commands provided by this plugin.
 * **** Once purified, the weapon or armor will become unequipped unless it has
 *     a purify transformation.
 * **** If the newly transformed weapon/armor is equippable, it will remain in
 *     the actor's equipment slots.
 * **** If you are using VisuMZ_2_WeaponSwapSystem, weapons cannot become
 *      cursed in order to allow free weapon swapping. Weaponry will not be
 *      cursed if VisuMZ_2_WeaponSwapSystem is installed.
 * *** <Purify Transform: id>
 * *** <Purify Transform: name>
 * **** If this notetag is present on a <Cursed> weapon or armor, then upon the
 *      actor receiving purification, the weapon or armor will transform into a
 *      different item.
 * ** New Plugin Commands added by Arisu:
 * *** Purify: Target Actor(s)
 * **** Purifies target actor(s) of any cursed weapons or armors.
 * *** Purify: Whole Party
 * **** Purifies whole party of any cursed weapons or armors.
 * ** Added "Cursed Equip Popup" to Equip Scene Plugin Parameters.
 * *** Text popup appears when an actor equips a cursed weapon/armor.
 * ** Added "Ally or Enemy" or "Enemy or Ally" scopes to Shop Status Window
 *    Plugin Parameters.
 * *** If unused, will default to "1 Ally" or "1 Enemy" like usual.
 *     Added by Irina.
 * 
 * Version 1.49: October 12, 2023
 * * Bug Fixes!
 * ** Fixed a problem where for weapon types, all weapon types are listed in
 *    the equip menu even when the actor cannot equip them (though they would
 *    be disabled). Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia and sponsored by AndyL:
 * *** <Added EType: x>
 * *** <Added ETypes: x, x, x>
 * **** This is for armors only and does NOT work with weapons!
 * **** Allows a piece of armor to belong to multiple ETypes. This means a
 *      glove can be equipped as "Armgear" or as an "Accessory" if you so
 *      choose.
 * 
 * Version 1.48: September 14, 2023
 * * Bug Fixes!
 * ** Fixed a problem where the help window position of the non-updated layout
 *    would appear in the wrong position. Fix made by Irina.
 * * Optimization Update!
 * ** Plugin should run more optimized when weapons and armors exceed 2000
 *    in database quantity.
 * 
 * Version 1.47: July 13, 2023
 * * Bug Fixes!
 * ** Fixed a bug that would cause the shop status window to display incorrect
 *    removed buffs and debuffs. Fix made by Olivia.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Changes made to dynamic shop listings in order to update upon listing
 *    changes rather than having to enter and exit the shop again. Update made
 *    by Arisu.
 * * New Features!
 * ** New notetag effects added by Arisu and sponsored by AndyL:
 * *** <Conserve: x%>
 * **** Gives the item a percent chance when used to not consume the item.
 * *** <Buy Turn On Switches: x, x, x>
 * *** <Buy Turn Off Switches: x, x, x>
 * *** <Sell Turn On Switches: x, x, x>
 * *** <Sell Turn Off Switches: x, x, x>
 * **** When buying/selling an item, weapon, or armor with these notetags,
 *      turn on/off switch(es) 'x'.
 * *** New Plugin Parameters added by Arisu:
 * **** Params > Settings > Shop Status Window > Equipment Data > Delay MS:
 * ***** How many milliseconds (MS) to delay the preview update?
 * ***** This is to prevent lag spikes for equips only.
 * 
 * Version 1.46: June 15, 2023
 * * Bug Fixes!
 * ** Fixed a problem where the help and input modes are not adequately
 *    adjusted when not used with the updated layout or without the Options
 *    Core custom UI placement. Fix made by Arisu.
 * 
 * Version 1.45: May 18, 2023
 * * Bug Fixes!
 * ** Fixed a bug that would cause equip slots to not be recognized properly if
 *    the equip slot name ends in a space.
 * 
 * Version 1.44: April 13, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetag effects added by Arisu and sponsored by Anon:
 * *** <Equip For Class Only: x>
 * *** <Equip For Classes Only: x, x, x>
 * *** <Equip For Class Only: name>
 * *** <Equip For Classes Only: name, name, name>
 * **** The piece of equipment can only be worn by the listed classes.
 * *** <Equip Requirements> notetag added.
 * **** Define multiple requirements that the actor needs to meet in order for
 *      this equip item to be equippable.
 * **** See help file for more information on the types of requirements that
 *      can be added.
 * 
 * Version 1.43: March 16, 2023
 * * Bug Fixes!
 * ** Artifact armors should now update and refresh the party members' cache
 *    upon acquisition. Fix made by Olivia.
 * 
 * Version 1.42: February 16, 2023
 * * Bug Fixes!
 * ** Proxy items should no longer cause infinite loops if they're made to
 *    reference other proxy items in a circular fashion. Instead, they just
 *    give the exact first found proxy instead of cycling through others.
 *    Fix made by Arisu.
 * 
 * Version 1.41: December 15, 2022
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Arisu and sponsored by Anon:
 * *** Equip Scene > Equip Command > Help Description
 * *** Equip Scene > Optimize Command > Help Description
 * *** Equip Scene > Clear Command > Help Description
 * **** Help description used when these commands are selected.
 * 
 * Version 1.40: October 20, 2022
 * * Feature Update!
 * ** For the shop status window, when comparing equipment of a type where
 *    there are multiple equipment slots (such as accessories), the plugin will
 *    now check for an empty equipment slot first and then make calculations
 *    there. Otherwise, it will use the first available equipment slot of that
 *    type regardless of the equipped item. Update made by Arisu.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.39: September 29, 2022:
 * * Feature Update!
 * ** Changed the default code for the equip scene's status window display to
 *    prevent the face graphic and basic actor stats from going above the
 *    window boundaries if there are too many parameters displayed in the
 *    status window at a time.
 * ** If you already have this plugin installed the changes will not be
 *    reflected unless you do the following:
 * **** BACKUP your game project.
 * **** REMOVE this plugin from the Plugin Manager list.
 * **** REINSTALL this plugin into the Plugin Manager list.
 * **** SAVE the game project.
 * 
 * Version 1.38: March 3, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New mechanics and notetags added by Olivia and sponsored by Anon:
 * *** <Party Artifact>
 * *** <Troop Artifact>
 * *** <Stackable Party Artifact>
 * *** <Stackable Troop Artifact>
 * **** Armors only! This armor cannot be equipped at all. However, by simply
 *      being in the party's inventory, its parameter bonuses and traits will
 *      be applied globally throughout the whole party or troop (depending on
 *      the notetag). Add both notetags to affect both groups.
 * **** The normal versions of the notetag is only applied once regardless of
 *      the number of copies are found in the party's inventory.
 * **** The stackable versions of the notetag will have the bonuses and traits
 *      stacked multiple times relative to the number of copies found in the
 *      party's inventory.
 * **** This item will NOT be added during the setup phase for Battle Tests.
 * ***** If you want to add the item, do it manually.
 * 
 * Version 1.37: December 23, 2021
 * * Compatibility Update
 * ** Created foundation for proxy items to be used in any applicable system
 *    and extension plugins. Update made by Arisu.
 * 
 * Version 1.36: December 2, 2021
 * * Feature Update!
 * ** For those using custom parameters from the Core Engine and do not have
 *    the parameters all-capitalized, the plugin will automatically do it for
 *    you to prevent errors. Update made by Olivia.
 * 
 * Version 1.35: November 18, 2021
 * * Compatibility Update!
 * ** If this plugin's updated scene is disabled, the Help Window locations for
 *    the Item, Equip, and Shop Scenes should now be at their designated
 *    locations as calculated by the VisuMZ Core Engine instead of the RMMZ
 *    default location. Update made by Irina.
 * 
 * Version 1.34: October 28, 2021
 * * Feature Update
 * ** Added fail safe checks for projects that are using old data for starting
 *    equipment that no longer exist, thus preventing the game from opening.
 *    Update made by Arisu.
 * 
 * Version 1.33: August 6, 2021
 * * Documentation Update!
 * ** Removed "Weapon" and "Armor" from "Used For" for <Status Info>. This was
 *    an unintended piece of documentation.
 * 
 * Version 1.32: July 23, 2021
 * * Bug Fixes!
 * ** Fixed a bug that would cause armor duplication when changing to classes
 *    with unaligned equipment slot types. Fix made by Arisu.
 * 
 * Version 1.31: July 9, 2021
 * * Feature Update!
 * ** Added a failsafe for price manipulation JavaScript to never have prices
 *    drop below 0 if possible. Update made by Arisu.
 * 
 * Version 1.30: July 2, 2021
 * * Documentation Update!
 * ** Added an extra note to the help file for the following:
 *    Plugin Parameters > Item Menu Settings > List Window > Columns
 * *** If you are using the VisuStella MZ Core Engine and the "Modern Controls"
 *     Plugin Parameter, please read through that section in case you have any
 *     questions about how to switch between categories when using multiple
 *     columns of items at a time.
 *    
 * 
 * Version 1.29: June 25, 2021
 * * Compatibility Update
 * ** Compatibility update with RPG Maker MZ 1.3.0+.
 * * Feature Update!
 * ** Phantom data when changing equipment types in the database should no
 *    longer affect actors with cached equip ID's. Update made by Arisu.
 * 
 * Version 1.28: June 4, 2021
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.27: May 21, 2021
 * * Bug Fixes!
 * ** Using the mouse right click in the Equip Scene while inside of the item
 *    to slot window will no longer exit the Equip Scene. Fix made by Yanfly.
 * 
 * Version 1.26: April 30, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** "VisuStella MZ Compatibility" added VisuMZ_1_BattleCore section regarding
 *    Damage Multiplier and Healing Multiplier vocabulary settings to reduce
 *    commonly asked questions.
 * * New Features!
 * ** New notetags added by Irina and sponsored by Archeia:
 * *** <Shop Picture Name: filename>
 * *** <Shop Picture Layer: x>
 * *** <Shop Picture Max Width: x>
 * *** <Shop Picture Max Height: y>
 * *** <Shop Picture Max Dimensions: x, y>
 * *** <Shop Picture Alignment: x>
 * *** <Shop Picture Position: y>
 * *** <Shop Picture Offset X: +x>
 * *** <Shop Picture Offset X: -x>
 * *** <Shop Picture Offset Y: +y>
 * *** <Shop Picture Offset Y: -y>
 * *** <Shop Picture Offset: +x, +y>
 * *** <Shop Picture Offset: -x, -y>
 * *** <Shop Picture Opacity: x>
 * *** <Shop Picture Opacity: x%>
 * **** Add images from the game project's img/pictures/ folder to display in
 *      the Shop Status Window.
 * 
 * Version 1.25: April 23, 2021
 * * Documentation Update!
 * ** Added clarity to the <param: +x> and <param: -x> notetags:
 * *** These notetags do NOT work with X Parameters, S Parameters, or any
 *     custom parameters. These notetags ONLY work with the base parameters.
 * 
 * Version 1.24: April 16, 2021
 * * Bug Fixes!
 * ** Changing an actor's equipment slots to past their original amount will no
 *    longer yield errors with duplicate slot types. Fix made by Arisu.
 * ** Completely selling an item should now refresh the help window to the new
 *    selected item's help description. Fix made by Arisu.
 * * Optimization Update!
 * ** Non-removable equipment restrictions for the equipment scene are now
 *    better optimized. Update made by Olivia.
 * 
 * Version 1.23: April 2, 2021
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.22: March 26, 2021
 * * Documentation Update!
 * ** Added "VisuStella MZ Compatibility" section for detailed compatibility
 *    explanations with the VisuMZ_4_BreakShields plugin.
 * 
 * Version 1.21: March 5, 2021
 * * Feature Update!
 * ** Custom equipment slots are disabled during Battle Testing for better
 *    accuracy and results.
 * 
 * Version 1.20: February 26, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Shop Menu Settings > Switches > Switch: Buy
 * *** Plugin Parameters > Shop Menu Settings > Switches > Switch: Sell
 * **** Buying/selling items in the Shop Scene turns this Switch to ON.
 * **** Switch reverts to OFF whenever the Shop Scene opens.
 * **** These switches can be used after a "Shop Processing" event command to
 *      determine if the player has bought an item, bought and sold an item,
 *      sold an item, or neither.
 * 
 * Version 1.19: January 29, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Irina.
 * *** <Equip Copy Limit: x>
 * **** Sets a maximum number of copies that the actor can wear of this
 *      equipment. Usage Example: Actors can only equip one copy of the
 *      "One-of-a-Kind Ring" on at any time despite having empty accessory
 *      slots because the ring has a <Equip Copy Limit: 1> notetag.
 * *** <Equip Weapon Type Limit: x>
 * **** This weapon cannot be equipped with other weapons of the same type once
 *      the limited amount has been reached. Usage Example: A dualwielding
 *      warrior who can only equip one sword and a dagger but never two swords
 *      or two daggers because the swords and daggers all have the
 *      <Equip Weapon Type Limit: 1> notetags on them.
 * *** <Equip Armor Type Limit: x>
 * **** This armor cannot be equipped with other armors of the same type once
 *      the limited amount has been reached. Usage Example: People cannot equip
 *      more than two glove accessories on at a time because the glove is a
 *      "Glove" armor-type and each glove item has the
 *      <Equip Armor Type Limit: 2> notetags on them.
 * 
 * Version 1.18: January 15, 2021
 * * Bug Fixes!
 * ** Pressing "Shift" to remove equipment will now refresh the status window
 *    unlike before. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Feature!
 * ** New Plugin Parameters added
 * *** Plugin Parameters > Item Menu Settings > Background Type
 * 
 * Version 1.17: January 1, 2021
 * * Bug Fixes!
 * ** Equipping should be working properly again. Fix made by Yanfly.
 * 
 * Version 1.16: December 25, 2020
 * * Bug Fixes!
 * ** Equip-Adjust HP/MP should work properly now. Fix made by Yanfly.
 * * Documentation Update!
 * ** Added more clarity for <JS Item Enable> to state that if the VisuStella
 *    Battle Core is installed, then all battle scope items are visible, but
 *    not necessarily enabled if they are disabled otherwise.
 * 
 * Version 1.15: December 18, 2020
 * * Bug Fixes!
 * ** RPG Maker MZ Bug: Unusable items on an individual-actor basis will no
 *    longer be overwritten by party-based usability for battle. Fix by Yanfly.
 * * Documentation Update!
 * ** Added more clarity for <JS Item Enable> to state that it removes the
 *    usable item from visibility as well if the actor unable to use it is the
 *    only person in the party.
 * 
 * Version 1.14: December 11, 2020
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * 
 * Version 1.13: December 4, 2020
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Plugin Commands added by Arisu!
 * *** Actor: Change Equip Slots
 * *** Actor: Reset Equip Slots
 * **** These plugin commands allow you to forcefully change the equip slots
 *      available to an actor regardless of the slots provided by its class as
 *      well as reset them.
 * 
 * Version 1.12: November 15, 2020
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.11: November 8, 2020
 * * Bug Fix!
 * ** Font size ratio for the shop status window now scales to a hard coded
 *    value to prevent smaller font sizes from expanding icon sizes. Fix made
 *    by Arisu.
 * * Feature Update!
 * ** Currency display in the shop menu is now reflected upon how the plugin
 *    parameters set them to display. Update made by Arisu.
 * 
 * Version 1.10: November 1, 2020
 * * Feature Update!
 * ** Modern Controls compatibility with Core Engine no longer enables the
 *    Item Categories window and child classes to utilize the Home/End keys.
 * 
 * Version 1.09: October 25, 2020
 * * Bug Fixes!
 * ** "All Items" category should now display the "Items" text. Fix by Irina.
 * ** WType, AType, and EType categories now work with text. Fix by Irina.
 *
 * Version 1.08: October 18, 2020
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * 
 * Version 1.07: October 11, 2020
 * * Bug Fixes!
 * ** XParams and SParams in the Window_EquipStatus window will no longer show
 *    a non-percentile difference if the original value is not a whole value.
 *    Fix made by Yanfly.
 * 
 * Version 1.06: October 4, 2020
 * * Bug Fixes!
 * ** Select Item event command now displays the default amount of columns
 *    instead of whatever setting is made with the plugin parameters.
 * 
 * Version 1.05: September 27, 2020
 * * Bug Fixes!
 * ** When using the updated shop layout, leaving the sell option will no
 *    longer cause the dummy window to appear.
 * * Documentation Update
 * ** "Use Updated Layout" plugin parameters now have the added clause:
 *    "This will override the Core Engine windows settings." to reduce
 *    confusion. Added by Irina.
 * 
 * Version 1.04: September 13, 2020
 * * Bug Fixes!
 * ** Pressing Shift to quickly remove equipment should no longer crash the
 *    game. This will also clear the help window text. Fix made by Arisu.
 * 
 * Version 1.03: September 6, 2020
 * * Bug Fixes!
 * ** If both Optimize and Clear commands have been removed and using modern
 *    controls, pressing up at the top of the slot window list will not go to
 *    the window. Fix made by Yanfly.
 * ** If both Optimize and Clear commands have been removed, the window will no
 *    longer appear and the slot window will be moved upward to fill any empty
 *    spaces. Fix made by Yanfly.
 * * New Features!
 * ** New Plugin Parameter added in NEW! Label to let you adjust the font face.
 * ** New Plugin Parameters added in Equip Menu Scene Settings for disabling
 *    the back rectangles and/or changing their colors.
 * ** New Plugin Parameters added in Shop Status Window Settings for disabling
 *    the back rectangles and/or changing their colors.
 * 
 * Version 1.02: August 30, 2020
 * * Documentation Fix!
 * ** Added: NOTE: Regarding Damage Labels
 * *** If Visu_1_BattleCore is installed, priority goes to its Damage Style
 *   settings. The label displayed is based on the damage style settings in
 *   place for that specific skill or item.
 * *** Go to Battle Core > Plugin Parameters > Damage Settings > Style List >
 *   pick the damage style you want to edit > Damage Label and change the
 *   text settings you'd like there.
 * *** Documentation update added by Yanfly.
 * 
 * Version 1.01: August 23, 2020
 * * Added failsafe to prevent non-existent equipment (because the database
 *   entries have been deleted) from being equipped as initial equipment.
 *   Fix made by Olivia.
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Begin
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActorChangeEquipSlots
 * @text Actor: Change Equip Slots
 * @desc Forcefully change the actor(s) equip slots.
 * These will persist through class changes.
 *
 * @arg Actors:arraynum
 * @text Actor ID(s)
 * @type actor[]
 * @desc Select which Actor ID(s) to affect.
 * @default ["1"]
 * 
 * @arg Slots:arraystr
 * @text Equip Slots
 * @type string[]
 * @desc Insert the equip slots you want the actor(s) to have.
 * These entries are case-sensitive.
 * @default ["Weapon","Shield","Head","Body","Accessory"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActorResetEquipSlots
 * @text Actor: Reset Equip Slots
 * @desc Reset any forced equip slots for the actor(s).
 * Equip slots will then be based on class.
 *
 * @arg Actors:arraynum
 * @text Actor ID(s)
 * @type actor[]
 * @desc Select which Actor ID(s) to affect.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Purify
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command PurifyActors
 * @text Purify: Target Actor(s)
 * @desc Purifies target actor(s) of any cursed weapons or armors.
 * Cannot be used in battle.
 *
 * @arg Actors:arraynum
 * @text Actor ID(s)
 * @type actor[]
 * @desc Select which Actor ID(s) to affect.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command PurifyParty
 * @text Purify: Whole Party
 * @desc Purifies whole party of any cursed weapons or armors.
 * Cannot be used in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Shop
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command BatchShop
 * @text Shop: Advanced
 * @desc Make it easier to put together inventories for a shop.
 * WARNING: Does not allow for event-specific prices.
 *
 * @arg Step1
 * @text Step 1: Item ID's
 *
 * @arg Step1Start:num
 * @text Range Start
 * @parent Step1
 * @type item
 * @desc Select which Item ID to start from.
 * @default 1
 *
 * @arg Step1End:num
 * @text Range End
 * @parent Step1
 * @type item
 * @desc Select which Item ID to end at.
 * @default 4
 *
 * @arg Step2
 * @text Step 2: Weapon ID's
 *
 * @arg Step2Start:num
 * @text Range Start
 * @parent Step2
 * @type weapon
 * @desc Select which Weapon ID to start from.
 * @default 1
 *
 * @arg Step2End:num
 * @text Range End
 * @parent Step2
 * @type weapon
 * @desc Select which Weapon ID to end at.
 * @default 4
 *
 * @arg Step3
 * @text Step 3: Armor ID's
 *
 * @arg Step3Start:num
 * @text Range Start
 * @parent Step3
 * @type armor
 * @desc Select which Armor ID to start from.
 * @default 1
 *
 * @arg Step3End:num
 * @text Range End
 * @parent Step3
 * @type armor
 * @desc Select which Armor ID to end at.
 * @default 4
 *
 * @arg PurchaseOnly:eval
 * @text Step 4: Purchase Only?
 * @type boolean
 * @on Purchase-Only
 * @off Sell Accessible
 * @desc Make the shop purchase-only?
 * @default false
 * 
 * @arg Optional
 * 
 * @arg Blacklist:arraystr
 * @text Blacklisted Categories
 * @parent Optional
 * @type string[]
 * @desc A list of categories to blacklist from the shop.
 * Not used if empty. Mark categories with <Category: x>
 * @default []
 * 
 * @arg Whitelist:arraystr
 * @text Whitelisted Categories
 * @parent Optional
 * @type string[]
 * @desc A list of categories to whitelist for the shop.
 * Not used if empty. Mark categories with <Category: x>
 * @default []
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_End
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param ItemsEquipsCore
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param ItemScene:struct
 * @text Item Menu Settings
 * @type struct<ItemScene>
 * @desc Change the Item Menu Scene settings.
 * @default {"General":"","EnableLayout:eval":"true","LayoutStyle:str":"upper/left","ListWindow":"","ListWindowCols:num":"1","ItemQt":"","MaxItems:num":"99","MaxWeapons:num":"99","MaxArmors:num":"99","ItemQuantityFmt:str":"×%1","ItemQuantityFontSize:num":"22","ShopStatusWindow":"","ShowShopStatus:eval":"true","ItemSceneAdjustItemList:eval":"true","ItemMenuStatusRect:func":"\"const width = this.statusWidth();\\nconst height = this._itemWindow.height;\\nconst x = Graphics.boxWidth - width;\\nconst y = this._itemWindow.y;\\nreturn new Rectangle(x, y, width, height);\"","ButtonAssist":"","buttonAssistCategory:str":"Switch Category"}
 *
 * @param Categories:struct
 * @text Item Categories
 * @parent ItemScene:struct
 * @type struct<Categories>
 * @desc Change the categories displayed in the Item/Shop menus.
 * @default {"MainList":"","List:arraystruct":"[\"{\\\"Type:str\\\":\\\"FieldUsable\\\",\\\"Icon:num\\\":\\\"208\\\"}\",\"{\\\"Type:str\\\":\\\"BattleUsable\\\",\\\"Icon:num\\\":\\\"218\\\"}\",\"{\\\"Type:str\\\":\\\"NeverUsable\\\",\\\"Icon:num\\\":\\\"302\\\"}\",\"{\\\"Type:str\\\":\\\"AllWeapons\\\",\\\"Icon:num\\\":\\\"97\\\"}\",\"{\\\"Type:str\\\":\\\"EType:2\\\",\\\"Icon:num\\\":\\\"128\\\"}\",\"{\\\"Type:str\\\":\\\"EType:3\\\",\\\"Icon:num\\\":\\\"131\\\"}\",\"{\\\"Type:str\\\":\\\"EType:4\\\",\\\"Icon:num\\\":\\\"137\\\"}\",\"{\\\"Type:str\\\":\\\"EType:5\\\",\\\"Icon:num\\\":\\\"145\\\"}\",\"{\\\"Type:str\\\":\\\"KeyItems\\\",\\\"Icon:num\\\":\\\"195\\\"}\"]","Style:str":"icon","TextAlign:str":"center","Vocabulary":"","HiddenItemA:str":"Special Items","HiddenItemB:str":"Unique Items","Consumable:str":"Consumable","Nonconsumable:str":"Nonconsumable","AlwaysUsable:str":"Usable","BattleUsable:str":"Battle","FieldUsable:str":"Field","NeverUsable:str":"Materials"}
 *
 * @param New:struct
 * @text NEW! Labels
 * @parent ItemScene:struct
 * @type struct<NewLabel>
 * @desc Change how NEW! Labels apply to your game project.
 * @default {"Enable:eval":"true","Icon:num":"0","Text:str":"NEW!","FontColor:str":"17","FontFace:str":"Verdana","FontSize:str":"16","FadeLimit:num":"360","FadeSpeed:num":"4","OffsetX:num":"0","OffsetY:num":"4"}
 *
 * @param EquipScene:struct
 * @text Equip Menu Settings
 * @type struct<EquipScene>
 * @desc Adjust the settings regarding the Equip Menu Scene.
 * @default {"General":"","EnableLayout:eval":"true","ParamValueFontSize:num":"22","MenuPortraits:eval":"true","DrawPortraitJS:func":"\"// Declare Variables\\nconst lineHeight = this.lineHeight();\\nconst padding = this.itemPadding();\\nconst x1 = padding;\\nconst x2 = this.innerWidth - 128 - padding;\\n\\n// Draw Menu Image\\nthis.drawItemActorMenuImage(this._actor, 0, 0, this.innerWidth, this.innerHeight);\\n\\n// Draw Data\\nthis.drawActorName(this._actor, x1, lineHeight * 0);\\nthis.drawActorClass(this._actor, x1, lineHeight * 1);\\nthis.drawActorIcons(this._actor, x1, lineHeight * 2);\\nthis.drawActorLevel(this._actor, x2, lineHeight * 0);\\nthis.placeBasicGauges(this._actor, x2, lineHeight * 1);\"","DrawFaceJS:func":"\"// Declare Variables\\nconst lineHeight = this.lineHeight();\\nconst gaugeLineHeight = this.gaugeLineHeight();\\nconst x = Math.floor(this.innerWidth / 2);\\nconst limitHeight = this.innerHeight - (this.actorParams().length * lineHeight);\\nconst actorX = Math.floor((x - ImageManager.faceWidth) / 2);\\nconst actorY = Math.max(0, Math.floor((limitHeight - ImageManager.faceHeight) / 2));\\nlet dataHeight = lineHeight * 3;\\ndataHeight += gaugeLineHeight * ($dataSystem.optDisplayTp ? 3 : 2);\\nconst dataY = Math.max(0, Math.floor((limitHeight - dataHeight) / 2));\\n\\n// Draw Data\\nthis.drawActorFace(this._actor, actorX, actorY, ImageManager.faceWidth, ImageManager.faceHeight);\\nthis.drawActorIcons(this._actor, actorX + 16, actorY + ImageManager.faceHeight - lineHeight);\\nthis.drawActorName(this._actor, x, dataY + lineHeight * 0);\\nthis.drawActorLevel(this._actor, x, dataY + lineHeight * 1);\\nthis.drawActorClass(this._actor, x, dataY + lineHeight * 2);\\nthis.placeBasicGauges(this._actor, x, dataY + lineHeight * 3);\"","DrawParamJS:func":"\"// Declare variables\\nconst params = this.actorParams();\\nconst lineHeight = this.lineHeight();\\nconst padding = this.itemPadding();\\nconst baseX = 0;\\nconst baseY = this.innerHeight - params.length * lineHeight;\\nconst baseWidth = this.innerWidth;\\nconst valueFontSize = this.paramValueFontSize();\\n\\n// Calculate Widths\\nlet paramNameWidth = Math.max(...params.map(param => this.textWidth(TextManager.param(param))));\\nparamNameWidth += padding * 2;\\nif (this.isUseParamNamesWithIcons()) {\\n    paramNameWidth += ImageManager.iconWidth + 4;\\n}\\nlet arrowWidth = this.rightArrowWidth();\\nconst totalDivides = this.innerWidth >= 500 ? 3 : 2;\\nlet paramValueWidth = Math.floor((baseWidth - paramNameWidth - arrowWidth) / totalDivides);\\nparamNameWidth = baseWidth - (paramValueWidth * totalDivides) - arrowWidth;\\n\\n// Draw Parameters\\nlet x = baseX;\\nlet y = baseY;\\nlet value = 0;\\nlet diffValue = 0;\\nlet alter = 2;\\nfor (const paramId of params) {\\n    // Draw Param Name\\n    this.drawItemDarkRect(x, y, paramNameWidth, lineHeight, alter);\\n    this.drawUpdatedParamName(paramId, x, y, paramNameWidth);\\n    this.resetFontSettings();\\n    x += paramNameWidth;\\n\\n    // Draw Param Before\\n    this.contents.fontSize = valueFontSize;\\n    this.drawItemDarkRect(x, y, paramValueWidth, lineHeight, alter);\\n    this.drawUpdatedBeforeParamValue(paramId, x, y, paramValueWidth);\\n    this.resetFontSettings();\\n    x += paramValueWidth;\\n\\n    // Draw Arrow\\n    this.drawItemDarkRect(x, y, arrowWidth, lineHeight, alter);\\n    this.drawRightArrow(x, y);\\n    x += arrowWidth;\\n\\n    // Draw Param After\\n    this.contents.fontSize = valueFontSize;\\n    this.drawItemDarkRect(x, y, paramValueWidth, lineHeight, alter);\\n    this.drawUpdatedAfterParamValue(paramId, x, y, paramValueWidth);\\n    x += paramValueWidth;\\n\\n    // Draw Param Change\\n    if (totalDivides > 2) {\\n        this.drawItemDarkRect(x, y, paramValueWidth, lineHeight, alter);\\n        this.drawUpdatedParamValueDiff(paramId, x, y, paramValueWidth);\\n    }\\n\\n    // Prepare Next Parameter\\n    x = baseX;\\n    y += lineHeight;\\n    alter = alter === 2 ? 1 : 2;\\n}\"","LayoutStyle:str":"upper/right","StatusWindowWidth:num":"312","DrawBackRect:eval":"true","BackRectColor:str":"19","CursedTextPopup:json":"\"%1 is cursed by %3%2!\"","Command":"","CmdStyle:str":"auto","CmdTextAlign:str":"center","CmdIconEquip:num":"136","equipCmdDesc:json":"\"Pick and choose equipment to change.\"","CommandAddOptimize:eval":"true","optimizeCmdDesc:json":"\"Equip the strongest available equipment.\"","CmdIconOptimize:num":"137","CommandAddClear:eval":"true","clearCmdDesc:json":"\"Remove all available equipment.\"","CmdIconClear:num":"135","RemoveEquip":"","RemoveEquipIcon:num":"16","RemoveEquipText:str":"Remove","ShiftShortcutKey:eval":"true","Rulings":"","EquipAdjustHpMp:eval":"true","NonRemoveETypes:arraynum":"[]","NonOptimizeETypes:arraynum":"[]","ButtonAssist":"","buttonAssistRemove:str":"Unequip"}
 *
 * @param ShopScene:struct
 * @text Shop Menu Settings
 * @type struct<ShopScene>
 * @desc Change the Shop Menu Scene settings.
 * @default {"General":"","EnableLayout:eval":"true","LayoutStyle:str":"upper/left","Command":"","CmdHideDisabled:eval":"true","CmdStyle:str":"auto","CmdTextAlign:str":"center","CmdIconBuy:num":"208","CmdIconSell:num":"314","CmdIconCancel:num":"82","CmdCancelRename:str":"Exit","Prices":"","SellPriceRate:num":"0.50","BuyPriceJS:func":"\"// Declare variables\\nlet item = arguments[0];\\nlet price = arguments[1];\\n\\n// Return the finalized price\\nreturn price;\"","SellPriceJS:func":"\"// Declare variables\\nlet item = arguments[0];\\nlet price = arguments[1];\\n\\n// Return the finalized price\\nreturn price;\"","ButtonAssist":"","buttonAssistSmallIncrement:str":"-1/+1","buttonAssistLargeIncrement:str":"-10/+10"}
 *
 * @param StatusWindow:struct
 * @text Shop Status Window
 * @parent ShopScene:struct
 * @type struct<StatusWindow>
 * @desc Change the Item Status Window settings.
 * @default {"General":"","Width:num":"352","ParamChangeFontSize:num":"22","Translucent:num":"64","DrawBackRect:eval":"true","BackRectColor:str":"19","EquipData":"","AlreadyEquipMarker:str":"E","CannotEquipMarker:str":"-","EquipDelayMS:num":"240","NoChangeMarker:str":"-","DrawEquipData:func":"\"// Set Variables\\nconst lineHeight = this.lineHeight();\\nconst paramheight = this.gaugeLineHeight() + 8;\\nlet x = 0;\\nlet y = 0;\\nlet width = this.innerWidth;\\nlet height = this.innerHeight;\\nlet hw = Math.floor(width / 2);\\nlet hx = x + width - hw;\\n\\n// Draw Item Name, Type, and Quantity\\nthis.drawItemName(this._item, x + this.itemPadding(), y, width - this.itemPadding() * 2);\\nthis.drawItemDarkRect(x, y, width);\\ny += lineHeight;\\nif (this.drawItemEquipType(x, y, hw)) y += 0;\\nif (this.drawItemQuantity(hx, y, hw)) y += lineHeight;\\n\\n// Draw Parameter Names\\nconst params = this.actorParams();\\nconst backY = y;\\ny = height - (params.length * paramheight) - 4;\\nlet paramX = x;\\nlet paramWidth = 0;\\nlet tableY = y;\\nfor (const paramId of params) {\\n    paramWidth = Math.max(this.drawParamName(paramId, x + 4, y + 4, width), paramWidth);\\n    y += paramheight;\\n}\\n\\n// Draw Actor Data\\nconst actorMax = $gameParty.maxBattleMembers();\\nconst actorWidth = Math.floor((width - paramWidth) / actorMax);\\nparamWidth = width - (actorWidth * actorMax);\\nfor (const actor of $gameParty.battleMembers()) {\\n    const index = $gameParty.battleMembers().indexOf(actor);\\n    const actorX = paramX + paramWidth + (index * actorWidth);\\n    this.changePaintOpacity(actor.canEquip(this._item));\\n    this.drawActorCharacter(actor, actorX + (actorWidth / 2), tableY);\\n    let actorY = tableY;\\n\\n    // Draw Parameter Changes\\n    for (const paramId of params) {\\n        const diffY = actorY - ((lineHeight - paramheight) / 2);\\n        this.drawActorParamDifference(actor, paramId, actorX, diffY, actorWidth);\\n        actorY += paramheight;\\n    }\\n}\\n\\n// Draw Back Rectangles\\nthis.drawItemDarkRect(paramX, backY, paramWidth, tableY - backY);\\nfor (let i = 0; i < actorMax; i++) {\\n    const actorX = paramX + paramWidth + (i * actorWidth);\\n    this.drawItemDarkRect(actorX, backY, actorWidth, tableY - backY);\\n}\\nfor (const paramId of params) {\\n    this.drawItemDarkRect(paramX, tableY, paramWidth, paramheight);\\n    for (let i = 0; i < actorMax; i++) {\\n        const actorX = paramX + paramWidth + (i * actorWidth);\\n        this.drawItemDarkRect(actorX, tableY, actorWidth, paramheight);\\n    }\\n    tableY += paramheight;\\n}\"","ItemData":"","ItemGeneral":"","MaxIcons:num":"8","MultiplierStandard:num":"1000000","DrawItemData:func":"\"const lineHeight = this.lineHeight();\\nlet x = 0;\\nlet y = 0;\\nlet width = this.innerWidth;\\nlet height = this.innerHeight;\\nlet hw = Math.floor(width / 2);\\nlet hx = x + width - hw;\\n\\n// Draw Item Name and Quantity\\nthis.drawItemName(this._item, x + this.itemPadding(), y, width - this.itemPadding() * 2);\\nthis.drawItemDarkRect(x, y, width);\\ny += lineHeight;\\n\\n// Draw Main Item Properties\\nif (this.drawItemConsumable(x, y, hw)) y += 0;\\nif (this.drawItemQuantity(hx, y, hw)) y += lineHeight;\\nif (this._item.occasion < 3) {\\n    y = this.drawItemDamage(x, y, width);\\n    y = this.drawItemEffects(x, y, width);\\n}\\ny = this.drawItemCustomEntries(x, y, width);\\n\\n// Draw Remaining Item Properties\\nif (this._item.occasion < 3) {\\n    if (this.drawItemOccasion(x, y, hw)) y += 0;\\n    if (this.drawItemScope(hx, y, hw)) y += lineHeight;\\n    if (this.drawItemHitType(x, y, hw)) y += 0;\\n    if (this.drawItemSuccessRate(hx, y, hw)) y += lineHeight;\\n    if (this.drawItemSpeed(x, y, hw)) y += 0;\\n    if (this.drawItemRepeats(hx, y, hw)) y += lineHeight;\\n}\\n\\n// Fill Rest of the Window\\nthis.drawItemDarkRect(x, y, width, height - y);\"","Vocabulary":"","LabelConsume:str":"Consumable","Consumable:str":"✔","NotConsumable:str":"✘","Occasions":"","Occasion0:str":"Anytime Use","Occasion1:str":"Battle-Only","Occasion2:str":"Field-Only","Occasion3:str":"-","Scope":"","Scope0:str":"No Target","Scope1:str":"1 Foe","Scope2:str":"All Foes","Scope3:str":"Random Foe","Scope4:str":"2 Random Foes","Scope5:str":"3 Random Foes","Scope6:str":"4 Random Foes","Scope7:str":"1 Ally","Scope8:str":"Alive Allies","Scope9:str":"Dead Ally","Scope10:str":"Dead Allies","Scope11:str":"User","Scope12:str":"Any Ally","Scope13:str":"All Allies","Scope14:str":"Everybody","BattleCore":"","ScopeRandomAny:str":"%1 Random Units","ScopeRandomEnemies:str":"%1 Random Foes","ScopeRandomAllies:str":"%1 Random Allies","ScopeAlliesButUser:str":"Other Allies","ScopeAllyOrEnemy:str":"Ally/Enemy","ScopeEnemyOrAlly:str":"Enemy/Ally","LabelSpeed:str":"Speed","Speed2000:str":"Fastest","Speed1000:str":"Faster","Speed1:str":"Fast","Speed0:str":"Normal","SpeedNeg999:str":"Slow","SpeedNeg1999:str":"Slower","SpeedNeg2000:str":"Slowest","LabelSuccessRate:str":"Accuracy","LabelRepeats:str":"Hits","LabelHitType:str":"Type","HitType0:str":"Neutral","HitType1:str":"Physical","HitType2:str":"Magical","LabelElement:str":"Element","ElementWeapon:str":"\\I[97]Weapon","ElementNone:str":"\\I[160]No Element","DamageType":"","DamageType1:str":"%1 Damage Multiplier","DamageType2:str":"%1 Damage Multiplier","DamageType3:str":"%1 Recovery Multiplier","DamageType4:str":"%1 Recovery Multiplier","DamageType5:str":"%1 Drain Multiplier","DamageType6:str":"%1 Drain Multiplier","Effects":"","LabelRecoverHP:str":"%1 Recovery","LabelRecoverMP:str":"%1 Recovery","LabelRecoverTP:str":"%1 Recovery","LabelSelfGainTP:str":"User %1","LabelDamageHP:str":"%1 Damage","LabelDamageMP:str":"%1 Damage","LabelDamageTP:str":"%1 Damage","LabelApply:str":"Applies","LabelRemove:str":"Removes"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Item Menu Scene Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ItemScene:
 *
 * @param General
 *
 * @param EnableLayout:eval
 * @text Use Updated Layout
 * @parent General
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use the Updated Item Menu Layout provided by this plugin?
 * This will override the Core Engine windows settings.
 * @default true
 *
 * @param LayoutStyle:str
 * @text Layout Style
 * @parent General
 * @type select
 * @option Upper Help, Left Input
 * @value upper/left
 * @option Upper Help, Right Input
 * @value upper/right
 * @option Lower Help, Left Input
 * @value lower/left
 * @option Lower Help, Right Input
 * @value lower/right
 * @desc If using an updated layout, how do you want to style
 * the menu scene layout?
 * @default upper/left
 *
 * @param ListWindow
 * @text List Window
 *
 * @param ListWindowCols:num
 * @text Columns
 * @parent ListWindow
 * @type number
 * @min 1
 * @desc Number of maximum columns.
 * @default 1
 *
 * @param ItemQt
 * @text Item Quantity
 *
 * @param MaxItems:num
 * @text Item Max
 * @parent ItemQt
 * @desc The default maximum quantity for items.
 * @default 99
 *
 * @param MaxWeapons:num
 * @text Weapon Max
 * @parent ItemQt
 * @desc The default maximum quantity for weapons.
 * @default 99
 *
 * @param MaxArmors:num
 * @text Armor Max
 * @parent ItemQt
 * @desc The default maximum quantity for armors.
 * @default 99
 *
 * @param ItemQuantityFmt:str
 * @text Quantity Format
 * @parent ItemQt
 * @desc How to display an item's quantity.
 * %1 - Item Quantity
 * @default ×%1
 *
 * @param ItemQuantityFontSize:num
 * @text Font Size
 * @parent ItemQt
 * @desc Default font size for item quantity.
 * @default 22
 *
 * @param ShopStatusWindow
 * @text Shop Status Window
 *
 * @param ShowShopStatus:eval
 * @text Show in Item Menu?
 * @parent ShopStatusWindow
 * @type boolean
 * @on Show
 * @off Don't Show
 * @desc Show the Shop Status Window in the Item Menu?
 * This is enabled if the Updated Layout is on.
 * @default true
 *
 * @param ItemSceneAdjustItemList:eval
 * @text Adjust List Window?
 * @parent ShopStatusWindow
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the Item List Window in the Item Menu if using the Shop Status Window?
 * @default true
 *
 * @param ItemMenuStatusBgType:num
 * @text Background Type
 * @parent ShopStatusWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ItemMenuStatusRect:func
 * @text JS: X, Y, W, H
 * @parent ShopStatusWindow
 * @type note
 * @desc Code used to determine the dimensions for this Status Window in the Item Menu.
 * @default "const width = this.statusWidth();\nconst height = this._itemWindow.height;\nconst x = Graphics.boxWidth - width;\nconst y = this._itemWindow.y;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param ButtonAssist
 * @text Button Assist Window
 *
 * @param buttonAssistCategory:str
 * @text Switch Category
 * @parent ButtonAssist
 * @desc Button assist text used for switching categories.
 * For VisuStella MZ's Core Engine's Button Assist Window.
 * @default Switch Category
 *
 */
/* ----------------------------------------------------------------------------
 * Item Categories
 * ----------------------------------------------------------------------------
 */
/*~struct~Categories:
 *
 * @param MainList
 * @text List
 * 
 * @param List:arraystruct
 * @text Category List
 * @parent MainList
 * @type struct<Category>[]
 * @desc A list of the item categories displayed in the Item/Shop menus.
 * @default ["{\"Type:str\":\"RegularItems\",\"Icon:num\":\"208\"}","{\"Type:str\":\"AllWeapons\",\"Icon:num\":\"97\"}","{\"Type:str\":\"AllArmors\",\"Icon:num\":\"137\"}","{\"Type:str\":\"KeyItems\",\"Icon:num\":\"195\"}"]
 *
 * @param Style:str
 * @text Category Style
 * @parent MainList
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw categorie entries in the Category Window?
 * @default icon
 *
 * @param TextAlign:str
 * @text Text Alignment
 * @parent MainList
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Decide how you want the text to be aligned.
 * @default center
 *
 * @param Vocabulary
 *
 * @param HiddenItemA:str
 * @text Hidden Item A
 * @parent Vocabulary
 * @desc How this category is named in the Item Menu.
 * @default Special Items
 *
 * @param HiddenItemB:str
 * @text Hidden Item B
 * @parent Vocabulary
 * @desc How this category is named in the Item Menu.
 * @default Unique Items
 *
 * @param Consumable:str
 * @text Consumable
 * @parent Vocabulary
 * @desc How this category is named in the Item Menu.
 * @default Consumable
 *
 * @param Nonconsumable:str
 * @text Nonconsumable
 * @parent Vocabulary
 * @desc How this category is named in the Item Menu.
 * @default Nonconsumable
 *
 * @param AlwaysUsable:str
 * @text Always Usable
 * @parent Vocabulary
 * @desc How this category is named in the Item Menu.
 * @default Usable
 *
 * @param BattleUsable:str
 * @text Battle Usable
 * @parent Vocabulary
 * @desc How this category is named in the Item Menu.
 * @default Battle
 *
 * @param FieldUsable:str
 * @text Field Usable
 * @parent Vocabulary
 * @desc How this category is named in the Item Menu.
 * @default Field
 *
 * @param NeverUsable:str
 * @text Never Usable
 * @parent Vocabulary
 * @desc How this category is named in the Item Menu.
 * @default Materials
 *
 */
/* ----------------------------------------------------------------------------
 * Category Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Category:
 *
 * @param Type:str
 * @text Type
 * @type combo
 * @option AllItems
 * @option 
 * @option RegularItems
 * @option KeyItems
 * @option HiddenItemA
 * @option HiddenItemB
 * @option 
 * @option Consumable
 * @option Nonconsumable
 * @option 
 * @option AlwaysUsable
 * @option BattleUsable
 * @option FieldUsable
 * @option NeverUsable
 * @option 
 * @option AllWeapons
 * @option WType:x
 * @option 
 * @option AllArmors
 * @option AType:x
 * @option 
 * @option EType:x
 * @option 
 * @option Category:x
 * @option
 * @desc A list of the item categories displayed in the Item/Shop
 * menus. Replace x with ID numbers or text.
 * @default RegularItems
 *
 * @param Icon:num
 * @text Icon
 * @desc Icon used for this category.
 * Use 0 for no icon.
 * @default 0
 *
 * @param SwitchID:num
 * @text Visibility Switch
 * @type switch
 * @desc This Switch must be turned ON in order for the category to show.
 * Use 0 for no Switch requirement.
 * @default 0
 *
 * @param SortBy:str
 * @text Sorted By
 * @type select
 * @option ID
 * @option Name
 * @desc Sort this category (in Scene_Item and Scene_Shop only) this way.
 * @default ID
 *
 */
/* ----------------------------------------------------------------------------
 * New Label Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~NewLabel:
 *
 * @param Enable:eval
 * @text Use NEW! Labels?
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use the NEW! Labels or not?
 * @default true
 *
 * @param Icon:num
 * @text Icon
 * @desc The icon index used to represent the NEW! text.
 * Use 0 to not draw any icons.
 * @default 0
 *
 * @param Text:str
 * @text Text
 * @desc The text written on the NEW! Label.
 * @default NEW!
 *
 * @param FontColor:str
 * @text Font Color
 * @parent Text:str
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 17
 *
 * @param FontFace:str
 * @text Font Face
 * @parent Text:str
 * @desc Font face used for the NEW! Label.
 * @default Verdana
 *
 * @param FontSize:str
 * @text Font Size
 * @parent Text:str
 * @desc The font size used for the NEW! text.
 * @default 16
 *
 * @param FadeLimit:num
 * @text Fade Limit
 * @desc What's the upper opaque limit before reversing?
 * @default 360
 *
 * @param FadeSpeed:num
 * @text Fade Speed
 * @desc What's the fade speed of the NEW! Label?
 * @default 4
 *
 * @param OffsetX:num
 * @text Offset X
 * @desc How much to offset the NEW! Label's X position by.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @desc How much to offset the NEW! Label's Y position by.
 * @default 4
 *
 */
/* ----------------------------------------------------------------------------
 * Equip Menu Scene Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~EquipScene:
 *
 * @param General
 *
 * @param EnableLayout:eval
 * @text Use Updated Layout
 * @parent General
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use the Updated Equip Layout provided by this plugin?
 * This will override the Core Engine windows settings.
 * @default true
 *
 * @param LayoutStyle:str
 * @text Layout Style
 * @parent General
 * @type select
 * @option Upper Help, Left Input
 * @value upper/left
 * @option Upper Help, Right Input
 * @value upper/right
 * @option Lower Help, Left Input
 * @value lower/left
 * @option Lower Help, Right Input
 * @value lower/right
 * @desc If using an updated layout, how do you want to style
 * the menu scene layout?
 * @default upper/right
 *
 * @param ParamValueFontSize:num
 * @text Param Font Size
 * @parent EnableLayout:eval
 * @desc The font size used for parameter values.
 * @default 22
 *
 * @param MenuPortraits:eval
 * @text Show Menu Portraits?
 * @parent EnableLayout:eval
 * @type boolean
 * @on Use Portraits
 * @off Use Faces
 * @desc If Main Menu Core is installed, display the Menu Portraits
 * instead of the actor's face in the status window?
 * @default true
 *
 * @param DrawPortraitJS:func
 * @text JS: Portrait Upper
 * @parent EnableLayout:eval
 * @type note
 * @desc If Menu Portraits are available, this is code used to draw
 * the upper data like this in the Status Window.
 * @default "// Declare Variables\nconst lineHeight = this.lineHeight();\nconst padding = this.itemPadding();\nconst x1 = padding;\nconst x2 = this.innerWidth - 128 - padding;\n\n// Draw Menu Image\nthis.drawItemActorMenuImage(this._actor, 0, 0, this.innerWidth, this.innerHeight);\n\n// Draw Data\nthis.drawActorName(this._actor, x1, lineHeight * 0);\nthis.drawActorClass(this._actor, x1, lineHeight * 1);\nthis.drawActorIcons(this._actor, x1, lineHeight * 2);\nthis.drawActorLevel(this._actor, x2, lineHeight * 0);\nthis.placeBasicGauges(this._actor, x2, lineHeight * 1);"
 *
 * @param DrawFaceJS:func
 * @text JS: Face Upper
 * @parent EnableLayout:eval
 * @type note
 * @desc If faces used used, this is code used to draw the upper
 * data like this in the Status Window.
 * @default "// Declare Variables\nconst lineHeight = this.lineHeight();\nconst gaugeLineHeight = this.gaugeLineHeight();\nconst x = Math.floor(this.innerWidth / 2);\nconst limitHeight = this.innerHeight - (this.actorParams().length * lineHeight);\nconst actorX = Math.floor((x - ImageManager.faceWidth) / 2);\nconst actorY = Math.max(0, Math.floor((limitHeight - ImageManager.faceHeight) / 2));\nlet dataHeight = lineHeight * 3;\ndataHeight += gaugeLineHeight * ($dataSystem.optDisplayTp ? 3 : 2);\nconst dataY = Math.max(0, Math.floor((limitHeight - dataHeight) / 2));\n\n// Draw Data\nthis.drawActorFace(this._actor, actorX, actorY, ImageManager.faceWidth, ImageManager.faceHeight);\nthis.drawActorIcons(this._actor, actorX + 16, actorY + ImageManager.faceHeight - lineHeight);\nthis.drawActorName(this._actor, x, dataY + lineHeight * 0);\nthis.drawActorLevel(this._actor, x, dataY + lineHeight * 1);\nthis.drawActorClass(this._actor, x, dataY + lineHeight * 2);\nthis.placeBasicGauges(this._actor, x, dataY + lineHeight * 3);"
 *
 * @param DrawParamJS:func
 * @text JS: Parameter Lower
 * @parent EnableLayout:eval
 * @type note
 * @desc Code to determine how parameters are drawn in the
 * Status Window.
 * @default "// Declare variables\nconst params = this.actorParams();\nconst lineHeight = this.lineHeight();\nconst padding = this.itemPadding();\nconst baseX = 0;\nconst baseY = this.innerHeight - params.length * lineHeight;\nconst baseWidth = this.innerWidth;\nconst valueFontSize = this.paramValueFontSize();\n\n// Calculate Widths\nlet paramNameWidth = Math.max(...params.map(param => this.textWidth(TextManager.param(param))));\nparamNameWidth += padding * 2;\nif (this.isUseParamNamesWithIcons()) {\n    paramNameWidth += ImageManager.iconWidth + 4;\n}\nlet arrowWidth = this.rightArrowWidth();\nconst totalDivides = this.innerWidth >= 500 ? 3 : 2;\nlet paramValueWidth = Math.floor((baseWidth - paramNameWidth - arrowWidth) / totalDivides);\nparamNameWidth = baseWidth - (paramValueWidth * totalDivides) - arrowWidth;\n\n// Draw Parameters\nlet x = baseX;\nlet y = baseY;\nlet value = 0;\nlet diffValue = 0;\nlet alter = 2;\nfor (const paramId of params) {\n    // Draw Param Name\n    this.drawItemDarkRect(x, y, paramNameWidth, lineHeight, alter);\n    this.drawUpdatedParamName(paramId, x, y, paramNameWidth);\n    this.resetFontSettings();\n    x += paramNameWidth;\n\n    // Draw Param Before\n    this.contents.fontSize = valueFontSize;\n    this.drawItemDarkRect(x, y, paramValueWidth, lineHeight, alter);\n    this.drawUpdatedBeforeParamValue(paramId, x, y, paramValueWidth);\n    this.resetFontSettings();\n    x += paramValueWidth;\n\n    // Draw Arrow\n    this.drawItemDarkRect(x, y, arrowWidth, lineHeight, alter);\n    this.drawRightArrow(x, y);\n    x += arrowWidth;\n\n    // Draw Param After\n    this.contents.fontSize = valueFontSize;\n    this.drawItemDarkRect(x, y, paramValueWidth, lineHeight, alter);\n    this.drawUpdatedAfterParamValue(paramId, x, y, paramValueWidth);\n    x += paramValueWidth;\n\n    // Draw Param Change\n    if (totalDivides > 2) {\n        this.drawItemDarkRect(x, y, paramValueWidth, lineHeight, alter);\n        this.drawUpdatedParamValueDiff(paramId, x, y, paramValueWidth);\n    }\n\n    // Prepare Next Parameter\n    x = baseX;\n    y += lineHeight;\n    alter = alter === 2 ? 1 : 2;\n}"
 *
 * @param StatusWindowWidth:num
 * @text Status Window Width
 * @parent General
 * @desc The usual width of the status window if using the 
 * non-Updated Equip Menu Layout.
 * @default 312
 *
 * @param DrawBackRect:eval
 * @text Show Back Rectangles?
 * @parent General
 * @type boolean
 * @on Draw
 * @off Don't Draw
 * @desc Show back rectangles of darker colors to display information better?
 * @default true
 *
 * @param BackRectColor:str
 * @text Back Rectangle Color
 * @parent DrawBackRect:eval
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 19
 *
 * @param CursedTextPopup:json
 * @text Cursed Equip Popup
 * @parent General
 * @type note
 * @desc %1 - Actor, %2 - Equip, %3 - Icon. Text codes allowed.
 * Requires VisuMZ_0_CoreEngine! Empty to not use.
 * @default "%1 is cursed by %3%2!"
 *
 * @param Command
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Command
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Command
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Command Window.
 * @default center
 *
 * @param CmdIconEquip:num
 * @text Equip Icon
 * @parent Command
 * @desc The icon used for the Equip command.
 * @default 136
 *
 * @param equipCmdDesc:json
 * @text Help Description
 * @parent CmdIconEquip:num
 * @type note
 * @desc Help description used when this command is selected.
 * Text codes allowed.
 * @default "Pick and choose equipment to change."
 *
 * @param CommandAddOptimize:eval
 * @text Add Optimize Command?
 * @parent Command
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Optimize" command to the Command Window?
 * @default true
 *
 * @param optimizeCmdDesc:json
 * @text Help Description
 * @parent CommandAddOptimize:eval
 * @type note
 * @desc Help description used when this command is selected.
 * Text codes allowed.
 * @default "Equip the strongest available equipment."
 *
 * @param CmdIconOptimize:num
 * @text Optimize Icon
 * @parent CommandAddOptimize:eval
 * @desc The icon used for the Optimize command.
 * @default 137
 *
 * @param CommandAddClear:eval
 * @text Add Clear Command?
 * @parent Command
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Clear" command to the Command Window?
 * @default true
 *
 * @param clearCmdDesc:json
 * @text Help Description
 * @parent CommandAddClear:eval
 * @type note
 * @desc Help description used when this command is selected.
 * Text codes allowed.
 * @default "Remove all available equipment."
 *
 * @param CmdIconClear:num
 * @text Clear Icon
 * @parent CommandAddClear:eval
 * @desc The icon used for the Clear command.
 * @default 135
 *
 * @param RemoveEquip
 * @text Remove Equip
 *
 * @param RemoveEquipIcon:num
 * @text Icon
 * @parent RemoveEquip
 * @desc Icon used for equipment removal.
 * @default 16
 *
 * @param RemoveEquipText:str
 * @text Text
 * @parent RemoveEquip
 * @desc Text used for equipment removal.
 * @default Remove
 *
 * @param ShiftShortcutKey:eval
 * @text Use SHIFT Shortcut?
 * @parent RemoveEquip
 * @type boolean
 * @on Use
 * @off Don't
 * @desc Add the "Shift" button as a shortcut key to removing items?
 * @default true

 * @param Rulings
 *
 * @param EquipAdjustHpMp:eval
 * @text Equip-Adjust HP/MP
 * @parent Rulings
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Adjust HP/MP differences after changing equips with MaxHP/MaxMP values.
 * @default true
 * 
 * @param NonRemoveETypes:arraynum
 * @text Non-Removable Types
 * @parent Rulings
 * @type number[]
 * @min 1
 * @max 100
 * @desc Insert ID's of the Equipment Types that must always have
 * an item equipped and cannot be empty.
 * @default []
 *
 * @param NonOptimizeETypes:arraynum
 * @text Non-Optimized Types
 * @parent Rulings
 * @type number[]
 * @min 1
 * @max 100
 * @desc Insert ID's of the Equipment Types that will be ignored
 * when equipment is being optimized.
 * @default []
 *
 * @param ButtonAssist
 * @text Button Assist Window
 *
 * @param buttonAssistRemove:str
 * @text SHIFT: Remove
 * @parent ButtonAssist
 * @desc Button assist text used for the SHIFT Remove Shortcut.
 * For VisuStella MZ's Core Engine's Button Assist Window.
 * @default Unequip
 * 
 */
/* ----------------------------------------------------------------------------
 * Shop Menu Scene Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ShopScene:
 *
 * @param General
 *
 * @param EnableLayout:eval
 * @text Use Updated Layout
 * @parent General
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use the Updated Shop Layout provided by this plugin?
 * This will override the Core Engine windows settings.
 * @default true
 *
 * @param LayoutStyle:str
 * @text Layout Style
 * @parent General
 * @type select
 * @option Upper Help, Left Input
 * @value upper/left
 * @option Upper Help, Right Input
 * @value upper/right
 * @option Lower Help, Left Input
 * @value lower/left
 * @option Lower Help, Right Input
 * @value lower/right
 * @desc If using an updated layout, how do you want to style
 * the menu scene layout?
 * @default upper/left
 *
 * @param Switches
 *
 * @param SwitchBuy:num
 * @text Switch: Buy
 * @parent Switches
 * @type switch
 * @desc Buying items in the Shop Scene turns this Switch to ON.
 * Switch reverts to OFF whenever the Shop Scene opens.
 * @default 0
 *
 * @param SwitchSell:num
 * @text Switch: Sell
 * @parent Switches
 * @type switch
 * @desc Selling items in the Shop Scene turns this Switch to ON.
 * Switch reverts to OFF whenever the Shop Scene opens.
 * @default 0
 *
 * @param Command
 * @text Command Window
 *
 * @param CmdHideDisabled:eval
 * @text Hide Unavailable?
 * @parent Command
 * @type boolean
 * @on Hide
 * @off Default
 * @desc Hide all unavailable commands like when a shop is set to Purchase Only?
 * @default true
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Command
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Command
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Command Window.
 * @default center
 *
 * @param CmdIconBuy:num
 * @text Buy Icon
 * @parent Command
 * @desc The icon used for the Buy command.
 * @default 208
 *
 * @param CmdIconSell:num
 * @text Sell Icon
 * @parent Command
 * @desc The icon used for the Sell command.
 * @default 314
 *
 * @param CmdIconCancel:num
 * @text Cancel Icon
 * @parent Command
 * @desc The icon used for the Cancel command.
 * @default 82
 *
 * @param CmdCancelRename:str
 * @text Rename "Cancel"
 * @parent Command
 * @desc Rename Cancel to something more logical for the Shop Menu Scene.
 * @default Exit
 *
 * @param Prices
 *
 * @param SellPriceRate:num
 * @text Sell Price Rate
 * @parent Prices
 * @desc The default sell price rate.
 * @default 0.50
 *
 * @param BuyPriceJS:func
 * @text JS: Buy Price
 * @parent Prices
 * @type note
 * @desc Modificatons made to the buy price before finalizing it.
 * @default "// Declare variables\nlet item = arguments[0];\nlet price = arguments[1];\n\n// Return the finalized price\nreturn price;"
 *
 * @param SellPriceJS:func
 * @text JS: Sell Price
 * @parent Prices
 * @type note
 * @desc Modificatons made to the sell price before finalizing it.
 * @default "// Declare variables\nlet item = arguments[0];\nlet price = arguments[1];\n\n// Return the finalized price\nreturn price;"
 * 
 * @param ButtonAssist
 * @text Button Assist Window
 *
 * @param buttonAssistSmallIncrement:str
 * @text Small Increment
 * @parent ButtonAssist
 * @desc Text used for changing amount bought/sold.
 * For VisuStella MZ's Core Engine's Button Assist Window.
 * @default -1/+1
 *
 * @param buttonAssistLargeIncrement:str
 * @text Large Increment
 * @parent ButtonAssist
 * @desc Text used for changing amount bought/sold.
 * For VisuStella MZ's Core Engine's Button Assist Window.
 * @default -10/+10
 *
 */
/* ----------------------------------------------------------------------------
 * Shop Status Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~StatusWindow:
 *
 * @param General
 *
 * @param Width:num
 * @text Window Width
 * @parent General
 * @desc The usual width of the status window.
 * @default 352
 *
 * @param ParamChangeFontSize:num
 * @text Parameter Font Size
 * @parent General
 * @desc Font size used for parameter changes.
 * @default 22
 *
 * @param Translucent:num
 * @text Translucent Opacity
 * @parent General
 * @desc Opacity setting used for translucent window objects.
 * @default 64
 *
 * @param DrawBackRect:eval
 * @text Show Back Rectangles?
 * @parent General
 * @type boolean
 * @on Draw
 * @off Don't Draw
 * @desc Show back rectangles of darker colors to display information better?
 * @default true
 *
 * @param BackRectColor:str
 * @text Back Rectangle Color
 * @parent DrawBackRect:eval
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 19
 *
 * @param EquipData
 * @text Equipment Data
 *
 * @param AlreadyEquipMarker:str
 * @text Already Equipped
 * @parent EquipData
 * @desc Marker used to show an actor cannot equip an item.
 * @default E
 *
 * @param CannotEquipMarker:str
 * @text Can't Equip
 * @parent EquipData
 * @desc Marker used to show an actor cannot equip an item.
 * @default -
 *
 * @param EquipDelayMS:num
 * @text Delay MS
 * @parent EquipData
 * @type number
 * @min 1
 * @max 999
 * @desc How many milliseconds (MS) to delay the preview update?
 * This is to prevent lag spikes for equips only.
 * @default 240
 *
 * @param NoChangeMarker:str
 * @text No Changes
 * @parent EquipData
 * @desc Marker used to show no changes have occurred.
 * @default -
 *
 * @param DrawEquipData:func
 * @text JS: Draw Equip Data
 * @parent EquipData
 * @type note
 * @desc Code used to draw the equipment data for the Shop Status Window.
 * @default "// Set Variables\nconst lineHeight = this.lineHeight();\nconst paramheight = this.gaugeLineHeight() + 8;\nlet x = 0;\nlet y = 0;\nlet width = this.innerWidth;\nlet height = this.innerHeight;\nlet hw = Math.floor(width / 2);\nlet hx = x + width - hw;\n\n// Draw Item Name, Type, and Quantity\nthis.drawItemName(this._item, x + this.itemPadding(), y, width - this.itemPadding() * 2);\nthis.drawItemDarkRect(x, y, width);\ny += lineHeight;\nif (this.drawItemEquipType(x, y, hw)) y += 0;\nif (this.drawItemQuantity(hx, y, hw)) y += lineHeight;\n\n// Draw Parameter Names\nconst params = this.actorParams();\nconst backY = y;\ny = height - (params.length * paramheight) - 4;\nlet paramX = x;\nlet paramWidth = 0;\nlet tableY = y;\nfor (const paramId of params) {\n    paramWidth = Math.max(this.drawParamName(paramId, x + 4, y + 4, width), paramWidth);\n    y += paramheight;\n}\n\n// Draw Actor Data\nconst actorMax = $gameParty.maxBattleMembers();\nconst actorWidth = Math.floor((width - paramWidth) / actorMax);\nparamWidth = width - (actorWidth * actorMax);\nfor (const actor of $gameParty.battleMembers()) {\n    const index = $gameParty.battleMembers().indexOf(actor);\n    const actorX = paramX + paramWidth + (index * actorWidth);\n    this.changePaintOpacity(actor.canEquip(this._item));\n    this.drawActorCharacter(actor, actorX + (actorWidth / 2), tableY);\n    let actorY = tableY;\n\n    // Draw Parameter Changes\n    for (const paramId of params) {\n        const diffY = actorY - ((lineHeight - paramheight) / 2);\n        this.drawActorParamDifference(actor, paramId, actorX, diffY, actorWidth);\n        actorY += paramheight;\n    }\n}\n\n// Draw Back Rectangles\nthis.drawItemDarkRect(paramX, backY, paramWidth, tableY - backY);\nfor (let i = 0; i < actorMax; i++) {\n    const actorX = paramX + paramWidth + (i * actorWidth);\n    this.drawItemDarkRect(actorX, backY, actorWidth, tableY - backY);\n}\nfor (const paramId of params) {\n    this.drawItemDarkRect(paramX, tableY, paramWidth, paramheight);\n    for (let i = 0; i < actorMax; i++) {\n        const actorX = paramX + paramWidth + (i * actorWidth);\n        this.drawItemDarkRect(actorX, tableY, actorWidth, paramheight);\n    }\n    tableY += paramheight;\n}"
 *
 * @param ItemData
 * @text Item Data
 *
 * @param ItemGeneral
 * @parent ItemData
 *
 * @param MaxIcons:num
 * @text Max State/Buff Icons
 * @parent ItemGeneral
 * @desc Maximum number of icons that can be displayed for Add/Remove States/Buffs.
 * @default 8
 *
 * @param MultiplierStandard:num
 * @text Multiplier Standard
 * @parent ItemGeneral
 * @desc Constant standard to filter out random values when calculating the damage multiplier.
 * @default 1000000
 *
 * @param DrawItemData:func
 * @text JS: Draw Item Data
 * @parent ItemGeneral
 * @type note
 * @desc Code used to draw the item data for the Shop Status Window.
 * @default "const lineHeight = this.lineHeight();\nlet x = 0;\nlet y = 0;\nlet width = this.innerWidth;\nlet height = this.innerHeight;\nlet hw = Math.floor(width / 2);\nlet hx = x + width - hw;\n\n// Draw Item Name and Quantity\nthis.drawItemName(this._item, x + this.itemPadding(), y, width - this.itemPadding() * 2);\nthis.drawItemDarkRect(x, y, width);\ny += lineHeight;\n\n// Draw Main Item Properties\nif (this.drawItemConsumable(x, y, hw)) y += 0;\nif (this.drawItemQuantity(hx, y, hw)) y += lineHeight;\nif (this._item.occasion < 3) {\n    y = this.drawItemDamage(x, y, width);\n    y = this.drawItemEffects(x, y, width);\n}\ny = this.drawItemCustomEntries(x, y, width);\n\n// Draw Remaining Item Properties\nif (this._item.occasion < 3) {\n    if (this.drawItemOccasion(x, y, hw)) y += 0;\n    if (this.drawItemScope(hx, y, hw)) y += lineHeight;\n    if (this.drawItemHitType(x, y, hw)) y += 0;\n    if (this.drawItemSuccessRate(hx, y, hw)) y += lineHeight;\n    if (this.drawItemSpeed(x, y, hw)) y += 0;\n    if (this.drawItemRepeats(hx, y, hw)) y += lineHeight;\n}\n\n// Fill Rest of the Window\nthis.drawItemDarkRect(x, y, width, height - y);"
 *
 * @param Vocabulary
 * @parent ItemData
 *
 * @param LabelConsume:str
 * @text Consumable
 * @parent Vocabulary
 * @desc Vocabulary used for this data entry.
 * @default Consumable
 *
 * @param Consumable:str
 * @text Yes
 * @parent LabelConsume:str
 * @desc Vocabulary used for this data entry.
 * @default ✔
 *
 * @param NotConsumable:str
 * @text No
 * @parent LabelConsume:str
 * @desc Vocabulary used for this data entry.
 * @default ✘
 *
 * @param Occasions
 * @parent Vocabulary
 *
 * @param Occasion0:str
 * @text Always
 * @parent Occasions
 * @desc Vocabulary used for this data entry.
 * @default Anytime Use
 *
 * @param Occasion1:str
 * @text Battle Screen
 * @parent Occasions
 * @desc Vocabulary used for this data entry.
 * @default Battle-Only
 *
 * @param Occasion2:str
 * @text Menu Screen
 * @parent Occasions
 * @desc Vocabulary used for this data entry.
 * @default Field-Only
 *
 * @param Occasion3:str
 * @text Never
 * @parent Occasions
 * @desc Vocabulary used for this data entry.
 * @default -
 *
 * @param Scope
 * @parent Vocabulary
 *
 * @param Scope0:str
 * @text None
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default No Target
 *
 * @param Scope1:str
 * @text 1 Enemy
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default 1 Foe
 *
 * @param Scope2:str
 * @text All Enemies
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default All Foes
 *
 * @param Scope3:str
 * @text 1 Random Enemy
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default Random Foe
 *
 * @param Scope4:str
 * @text 2 Random Enemies
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default 2 Random Foes
 *
 * @param Scope5:str
 * @text 3 Random Enemies
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default 3 Random Foes
 *
 * @param Scope6:str
 * @text 4 Random Enemies
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default 4 Random Foes
 *
 * @param Scope7:str
 * @text 1 Ally
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default 1 Ally
 *
 * @param Scope8:str
 * @text All Allies
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default Alive Allies
 *
 * @param Scope9:str
 * @text 1 Ally (Dead)
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default Dead Ally
 *
 * @param Scope10:str
 * @text All Allies (Dead)
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default Dead Allies
 *
 * @param Scope11:str
 * @text The User
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default User
 *
 * @param Scope12:str
 * @text 1 Ally (DoA)
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default Any Ally
 *
 * @param Scope13:str
 * @text All Allies (DoA)
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default All Allies
 *
 * @param Scope14:str
 * @text Enemies & Allies
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default Everybody
 *
 * @param BattleCore
 * @text Battle Core Support
 * @parent Vocabulary
 *
 * @param ScopeRandomAny:str
 * @text x Random Any
 * @parent BattleCore
 * @desc Vocabulary used for <Target: x Random Any> notetag.
 * @default %1 Random Units
 *
 * @param ScopeRandomEnemies:str
 * @text x Random Enemies
 * @parent BattleCore
 * @desc Vocabulary used for <Target: x Random Enemies> notetag.
 * @default %1 Random Foes
 *
 * @param ScopeRandomAllies:str
 * @text x Random Allies
 * @parent BattleCore
 * @desc Vocabulary used for <Target: x Random Allies> notetag.
 * @default %1 Random Allies
 *
 * @param ScopeAlliesButUser:str
 * @text All Allies But User
 * @parent BattleCore
 * @desc Vocabulary used for <Target: All Allies But User> notetag.
 * @default Other Allies
 *
 * @param ScopeAllyOrEnemy:str
 * @text Ally or Enemy
 * @parent BattleCore
 * @desc Vocabulary used for <Target: Ally or Enemy> notetag.
 * @default Ally/Enemy
 *
 * @param ScopeEnemyOrAlly:str
 * @text Enemy or Ally
 * @parent BattleCore
 * @desc Vocabulary used for <Target: Enemy or Ally> notetag.
 * @default Enemy/Ally
 *
 * @param LabelSpeed:str
 * @text Speed
 * @parent Vocabulary
 * @desc Vocabulary used for this data entry.
 * @default Speed
 *
 * @param Speed2000:str
 * @text >= 2000 Speed
 * @parent LabelSpeed:str
 * @desc Vocabulary used for this data entry.
 * @default Fastest
 *
 * @param Speed1000:str
 * @text >= 1000 Speed
 * @parent LabelSpeed:str
 * @desc Vocabulary used for this data entry.
 * @default Faster
 *
 * @param Speed1:str
 * @text >= 1 Speed
 * @parent LabelSpeed:str
 * @desc Vocabulary used for this data entry.
 * @default Fast
 *
 * @param Speed0:str
 * @text == 0 Speed
 * @parent LabelSpeed:str
 * @desc Vocabulary used for this data entry.
 * @default Normal
 *
 * @param SpeedNeg999:str
 * @text >= -999 Speed
 * @parent LabelSpeed:str
 * @desc Vocabulary used for this data entry.
 * @default Slow
 *
 * @param SpeedNeg1999:str
 * @text >= -1999 Speed
 * @parent LabelSpeed:str
 * @desc Vocabulary used for this data entry.
 * @default Slower
 *
 * @param SpeedNeg2000:str
 * @text <= -2000 Speed
 * @parent LabelSpeed:str
 * @desc Vocabulary used for this data entry.
 * @default Slowest
 *
 * @param LabelSuccessRate:str
 * @text Success Rate
 * @parent Vocabulary
 * @desc Vocabulary used for this data entry.
 * @default Accuracy
 *
 * @param LabelRepeats:str
 * @text Repeats
 * @parent Vocabulary
 * @desc Vocabulary used for this data entry.
 * @default Hits
 *
 * @param LabelHitType:str
 * @text Hit Type
 * @parent Vocabulary
 * @desc Vocabulary used for this data entry.
 * @default Type
 *
 * @param HitType0:str
 * @text Certain Hit
 * @parent LabelHitType:str
 * @desc Vocabulary used for this data entry.
 * @default Neutral
 *
 * @param HitType1:str
 * @text Physical
 * @parent LabelHitType:str
 * @desc Vocabulary used for this data entry.
 * @default Physical
 *
 * @param HitType2:str
 * @text Magical
 * @parent LabelHitType:str
 * @desc Vocabulary used for this data entry.
 * @default Magical
 *
 * @param LabelElement:str
 * @text Element
 * @parent Vocabulary
 * @desc Vocabulary used for this data entry.
 * @default Element
 *
 * @param ElementWeapon:str
 * @text Weapon-Based
 * @parent LabelElement:str
 * @desc Vocabulary used for this data entry.
 * @default \I[97]Weapon
 *
 * @param ElementNone:str
 * @text Nonelement Element
 * @parent LabelElement:str
 * @desc Vocabulary used for this data entry.
 * @default \I[160]No Element
 *
 * @param DamageType
 * @text Damage Type
 * @parent Vocabulary
 *
 * @param DamageType1:str
 * @text HP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry. If Visu_1_BattleCore
 * is installed, priority goes to its Damage Style settings.
 * @default %1 Damage Multiplier
 *
 * @param DamageType2:str
 * @text MP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry. If Visu_1_BattleCore
 * is installed, priority goes to its Damage Style settings.
 * @default %1 Damage Multiplier
 *
 * @param DamageType3:str
 * @text HP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry. If Visu_1_BattleCore
 * is installed, priority goes to its Damage Style settings.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType4:str
 * @text MP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry. If Visu_1_BattleCore
 * is installed, priority goes to its Damage Style settings.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType5:str
 * @text HP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry. If Visu_1_BattleCore
 * is installed, priority goes to its Damage Style settings.
 * @default %1 Drain Multiplier
 *
 * @param DamageType6:str
 * @text MP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry. If Visu_1_BattleCore
 * is installed, priority goes to its Damage Style settings.
 * @default %1 Drain Multiplier
 *
 * @param Effects
 * @parent Vocabulary
 *
 * @param LabelRecoverHP:str
 * @text Recover HP
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery
 *
 * @param LabelRecoverMP:str
 * @text Recover MP
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery
 *
 * @param LabelRecoverTP:str
 * @text Recover TP
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery
 *
 * @param LabelSelfGainTP:str
 * @text Self Gain TP
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default User %1
 *
 * @param LabelDamageHP:str
 * @text Damage HP
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage
 *
 * @param LabelDamageMP:str
 * @text Damage MP
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage
 *
 * @param LabelDamageTP:str
 * @text Damage TP
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage
 *
 * @param LabelApply:str
 * @text Add State/Buff
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default Applies
 *
 * @param LabelRemove:str
 * @text Remove State/Buff
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default Removes
 *
 */
//=============================================================================

const _0x709961=_0x2c86;(function(_0xa43959,_0x421d89){const _0x5e3f68=_0x2c86,_0x20b438=_0xa43959();while(!![]){try{const _0x5dae3b=-parseInt(_0x5e3f68(0x21f))/0x1*(parseInt(_0x5e3f68(0x218))/0x2)+-parseInt(_0x5e3f68(0x52d))/0x3*(-parseInt(_0x5e3f68(0x411))/0x4)+parseInt(_0x5e3f68(0x1eb))/0x5+parseInt(_0x5e3f68(0x650))/0x6*(-parseInt(_0x5e3f68(0x482))/0x7)+parseInt(_0x5e3f68(0x656))/0x8+-parseInt(_0x5e3f68(0x5df))/0x9+parseInt(_0x5e3f68(0x21d))/0xa;if(_0x5dae3b===_0x421d89)break;else _0x20b438['push'](_0x20b438['shift']());}catch(_0x564ca7){_0x20b438['push'](_0x20b438['shift']());}}}(_0x5bde,0xbccdc));var label=_0x709961(0x3db),tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x709961(0x672)](function(_0x2fa805){const _0x3a00ef=_0x709961;return _0x2fa805[_0x3a00ef(0x241)]&&_0x2fa805['description']['includes']('['+label+']');})[0x0];VisuMZ[label][_0x709961(0x6b0)]=VisuMZ[label][_0x709961(0x6b0)]||{},VisuMZ[_0x709961(0x654)]=function(_0x5bb01a,_0x1da402){const _0x201bfe=_0x709961;for(const _0x3f8577 in _0x1da402){if(_0x3f8577['match'](/(.*):(.*)/i)){if(_0x201bfe(0x6c8)===_0x201bfe(0x6c8)){const _0x94bf3d=String(RegExp['$1']),_0x122b6e=String(RegExp['$2'])[_0x201bfe(0x45c)]()['trim']();let _0x2314eb,_0x379819,_0x1c94d7;switch(_0x122b6e){case _0x201bfe(0x4c0):_0x2314eb=_0x1da402[_0x3f8577]!==''?Number(_0x1da402[_0x3f8577]):0x0;break;case _0x201bfe(0x577):_0x379819=_0x1da402[_0x3f8577]!==''?JSON[_0x201bfe(0x692)](_0x1da402[_0x3f8577]):[],_0x2314eb=_0x379819[_0x201bfe(0x1ac)](_0x2676db=>Number(_0x2676db));break;case _0x201bfe(0x42a):_0x2314eb=_0x1da402[_0x3f8577]!==''?eval(_0x1da402[_0x3f8577]):null;break;case'ARRAYEVAL':_0x379819=_0x1da402[_0x3f8577]!==''?JSON['parse'](_0x1da402[_0x3f8577]):[],_0x2314eb=_0x379819[_0x201bfe(0x1ac)](_0x2a782f=>eval(_0x2a782f));break;case _0x201bfe(0x1c2):_0x2314eb=_0x1da402[_0x3f8577]!==''?JSON[_0x201bfe(0x692)](_0x1da402[_0x3f8577]):'';break;case'ARRAYJSON':_0x379819=_0x1da402[_0x3f8577]!==''?JSON[_0x201bfe(0x692)](_0x1da402[_0x3f8577]):[],_0x2314eb=_0x379819['map'](_0x522417=>JSON[_0x201bfe(0x692)](_0x522417));break;case _0x201bfe(0x4db):_0x2314eb=_0x1da402[_0x3f8577]!==''?new Function(JSON['parse'](_0x1da402[_0x3f8577])):new Function('return\x200');break;case'ARRAYFUNC':_0x379819=_0x1da402[_0x3f8577]!==''?JSON[_0x201bfe(0x692)](_0x1da402[_0x3f8577]):[],_0x2314eb=_0x379819[_0x201bfe(0x1ac)](_0x20f773=>new Function(JSON['parse'](_0x20f773)));break;case'STR':_0x2314eb=_0x1da402[_0x3f8577]!==''?String(_0x1da402[_0x3f8577]):'';break;case _0x201bfe(0x6b3):_0x379819=_0x1da402[_0x3f8577]!==''?JSON['parse'](_0x1da402[_0x3f8577]):[],_0x2314eb=_0x379819[_0x201bfe(0x1ac)](_0x2b9fe5=>String(_0x2b9fe5));break;case _0x201bfe(0x228):_0x1c94d7=_0x1da402[_0x3f8577]!==''?JSON[_0x201bfe(0x692)](_0x1da402[_0x3f8577]):{},_0x5bb01a[_0x94bf3d]={},VisuMZ[_0x201bfe(0x654)](_0x5bb01a[_0x94bf3d],_0x1c94d7);continue;case _0x201bfe(0x54d):_0x379819=_0x1da402[_0x3f8577]!==''?JSON['parse'](_0x1da402[_0x3f8577]):[],_0x2314eb=_0x379819[_0x201bfe(0x1ac)](_0x594878=>VisuMZ[_0x201bfe(0x654)]({},JSON[_0x201bfe(0x692)](_0x594878)));break;default:continue;}_0x5bb01a[_0x94bf3d]=_0x2314eb;}else _0x2fa367=_0x5dbe06[_0x201bfe(0x5f5)](this[_0x201bfe(0x69a)](_0x5de7fa,_0x38a896+0x4,_0x6a309b+0x4,_0x52b9f4),_0x534bdf),_0x135f4b+=_0x2c9f07;}}return _0x5bb01a;},(_0x250600=>{const _0x1a5b72=_0x709961,_0x3fb805=_0x250600[_0x1a5b72(0x5a7)];for(const _0x47e23f of dependencies){if(!Imported[_0x47e23f]){if('wvaFf'!==_0x1a5b72(0x4c6)){alert(_0x1a5b72(0x4b4)['format'](_0x3fb805,_0x47e23f)),SceneManager[_0x1a5b72(0x6e4)]();break;}else{const _0x53b387=_0x3fb538[_0x1a5b72(0x401)](_0x21b0ab[_0x1a5b72(0x1f1)]()),_0x5fe500=this[_0x1a5b72(0x224)]-_0x53b387[_0x1a5b72(0x4ca)];_0x5c211e+=_0x5fe500/0x2;if(_0x5fe500<0x0)_0x86283d-=_0x5fe500;_0x1b1912[_0x1a5b72(0x5ef)][_0x1a5b72(0x1f5)][_0x1a5b72(0x376)](this,_0x337873,_0xbee889,_0x5e6086,_0x244194,_0x566074);}}}const _0x1e824a=_0x250600[_0x1a5b72(0x3fa)];if(_0x1e824a[_0x1a5b72(0x1ed)](/\[Version[ ](.*?)\]/i)){const _0xbd4123=Number(RegExp['$1']);_0xbd4123!==VisuMZ[label][_0x1a5b72(0x6b8)]&&(alert(_0x1a5b72(0x5de)[_0x1a5b72(0x60c)](_0x3fb805,_0xbd4123)),SceneManager[_0x1a5b72(0x6e4)]());}if(_0x1e824a[_0x1a5b72(0x1ed)](/\[Tier[ ](\d+)\]/i)){const _0xc946cc=Number(RegExp['$1']);_0xc946cc<tier?(alert(_0x1a5b72(0x41d)[_0x1a5b72(0x60c)](_0x3fb805,_0xc946cc,tier)),SceneManager['exit']()):tier=Math['max'](_0xc946cc,tier);}VisuMZ['ConvertParams'](VisuMZ[label][_0x1a5b72(0x6b0)],_0x250600[_0x1a5b72(0x662)]);})(pluginData),PluginManager[_0x709961(0x58d)](pluginData['name'],_0x709961(0x3c8),_0x41f76d=>{const _0x5cf01a=_0x709961;VisuMZ[_0x5cf01a(0x654)](_0x41f76d,_0x41f76d);const _0x50256d=_0x41f76d['Actors'][_0x5cf01a(0x1ac)](_0x2ade0e=>$gameActors['actor'](_0x2ade0e)),_0x604097=_0x41f76d['Slots']['map'](_0x15cc52=>$dataSystem['equipTypes'][_0x5cf01a(0x532)](_0x15cc52['trim']()));for(const _0xf0294b of _0x50256d){if(_0x5cf01a(0x37b)!==_0x5cf01a(0x6b7)){if(!_0xf0294b)continue;_0xf0294b[_0x5cf01a(0x520)](_0x604097);}else return this[_0x5cf01a(0x4fa)]()[_0x5cf01a(0x1ed)](/LOWER/i);}}),PluginManager[_0x709961(0x58d)](pluginData[_0x709961(0x5a7)],_0x709961(0x30b),_0x5b4aa4=>{const _0x5416c5=_0x709961;VisuMZ[_0x5416c5(0x654)](_0x5b4aa4,_0x5b4aa4);const _0x71c65c=_0x5b4aa4[_0x5416c5(0x581)][_0x5416c5(0x1ac)](_0x3a5a76=>$gameActors['actor'](_0x3a5a76));for(const _0x854ec9 of _0x71c65c){if(_0x5416c5(0x31e)!==_0x5416c5(0x31e)){const _0x25856f=_0x3ae948['weaponTypes'][_0x5416c5(0x532)](_0x4e77ce(_0x4b8716['$1'])[_0x5416c5(0x3c4)]());return _0x1e12fd[_0x5416c5(0x67a)](_0x55fdac)&&_0x3789cb['wtypeId']===_0x25856f;}else{if(!_0x854ec9)continue;_0x854ec9[_0x5416c5(0x334)]();}}}),PluginManager[_0x709961(0x58d)](pluginData[_0x709961(0x5a7)],_0x709961(0x21a),_0x105f0a=>{const _0x29545f=_0x709961;if($gameParty[_0x29545f(0x30d)]())return;VisuMZ[_0x29545f(0x654)](_0x105f0a,_0x105f0a);const _0x509559=_0x105f0a[_0x29545f(0x581)]['map'](_0x28c973=>$gameActors[_0x29545f(0x67f)](_0x28c973));for(const _0x47b227 of _0x509559){if(!_0x47b227)continue;_0x47b227['purifyCursedEquips']();}}),PluginManager['registerCommand'](pluginData[_0x709961(0x5a7)],_0x709961(0x5e2),_0x17463b=>{const _0x226b23=_0x709961;if($gameParty['inBattle']())return;$gameParty[_0x226b23(0x550)]();}),PluginManager[_0x709961(0x58d)](pluginData['name'],_0x709961(0x584),_0x5558cc=>{const _0x76d7e=_0x709961;VisuMZ[_0x76d7e(0x654)](_0x5558cc,_0x5558cc);const _0x5777a5=[],_0x5054b1=_0x5558cc[_0x76d7e(0x4ce)][_0x76d7e(0x1ac)](_0x52c9a0=>_0x52c9a0[_0x76d7e(0x45c)]()[_0x76d7e(0x3c4)]()),_0x325d46=_0x5558cc[_0x76d7e(0x1b7)][_0x76d7e(0x1ac)](_0x35851b=>_0x35851b[_0x76d7e(0x45c)]()[_0x76d7e(0x3c4)]()),_0x188303=_0x5558cc[_0x76d7e(0x4bc)]>=_0x5558cc[_0x76d7e(0x2db)]?_0x5558cc['Step1Start']:_0x5558cc[_0x76d7e(0x4bc)],_0x522e26=_0x5558cc['Step1End']>=_0x5558cc[_0x76d7e(0x2db)]?_0x5558cc[_0x76d7e(0x4bc)]:_0x5558cc[_0x76d7e(0x2db)],_0x2f4ca6=Array(_0x522e26-_0x188303+0x1)[_0x76d7e(0x5d6)]()[_0x76d7e(0x1ac)]((_0x562b00,_0x1bf9e5)=>_0x188303+_0x1bf9e5);for(const _0x198fb9 of _0x2f4ca6){const _0x5ef3f7=$dataItems[_0x198fb9];if(!_0x5ef3f7)continue;if(!VisuMZ['ItemsEquipsCore'][_0x76d7e(0x1a5)](_0x5ef3f7,_0x5054b1,_0x325d46))continue;_0x5777a5[_0x76d7e(0x4ba)]([0x0,_0x198fb9,0x0,_0x5ef3f7[_0x76d7e(0x518)]]);}const _0x420851=_0x5558cc[_0x76d7e(0x6a3)]>=_0x5558cc[_0x76d7e(0x56c)]?_0x5558cc['Step2Start']:_0x5558cc[_0x76d7e(0x6a3)],_0x2612a6=_0x5558cc[_0x76d7e(0x6a3)]>=_0x5558cc['Step2Start']?_0x5558cc[_0x76d7e(0x6a3)]:_0x5558cc['Step2Start'],_0x442fb0=Array(_0x2612a6-_0x420851+0x1)[_0x76d7e(0x5d6)]()['map']((_0x25ca3e,_0x14c596)=>_0x420851+_0x14c596);for(const _0x3c2bd9 of _0x442fb0){const _0x4d2093=$dataWeapons[_0x3c2bd9];if(!_0x4d2093)continue;if(!VisuMZ['ItemsEquipsCore'][_0x76d7e(0x1a5)](_0x4d2093,_0x5054b1,_0x325d46))continue;_0x5777a5['push']([0x1,_0x3c2bd9,0x0,_0x4d2093[_0x76d7e(0x518)]]);}const _0xaca45f=_0x5558cc[_0x76d7e(0x601)]>=_0x5558cc[_0x76d7e(0x1b6)]?_0x5558cc['Step3Start']:_0x5558cc[_0x76d7e(0x601)],_0x1c0984=_0x5558cc['Step3End']>=_0x5558cc[_0x76d7e(0x1b6)]?_0x5558cc['Step3End']:_0x5558cc[_0x76d7e(0x1b6)],_0x58dd90=Array(_0x1c0984-_0xaca45f+0x1)[_0x76d7e(0x5d6)]()[_0x76d7e(0x1ac)]((_0x11ef5b,_0x408667)=>_0xaca45f+_0x408667);for(const _0x5ae488 of _0x58dd90){if('GXtvt'!==_0x76d7e(0x4f8))_0x74637a[_0x76d7e(0x3db)][_0x76d7e(0x3cf)][_0x76d7e(0x376)](this,_0x4a0066),this[_0x76d7e(0x68f)](_0x3a8dd7);else{const _0x24e9cb=$dataArmors[_0x5ae488];if(!_0x24e9cb)continue;if(!VisuMZ[_0x76d7e(0x3db)][_0x76d7e(0x1a5)](_0x24e9cb,_0x5054b1,_0x325d46))continue;_0x5777a5[_0x76d7e(0x4ba)]([0x2,_0x5ae488,0x0,_0x24e9cb[_0x76d7e(0x518)]]);}}SceneManager[_0x76d7e(0x4ba)](Scene_Shop),SceneManager[_0x76d7e(0x287)](_0x5777a5,_0x5558cc[_0x76d7e(0x4c7)]);}),VisuMZ[_0x709961(0x3db)][_0x709961(0x1a5)]=function(_0x7ad096,_0x2b6439,_0x176be1){const _0x5f8c2e=_0x709961;if(_0x7ad096[_0x5f8c2e(0x5a7)]['trim']()==='')return![];if(_0x7ad096[_0x5f8c2e(0x5a7)][_0x5f8c2e(0x1ed)](/-----/i))return![];const _0x2e5c96=_0x7ad096[_0x5f8c2e(0x5d4)];if(_0x2b6439[_0x5f8c2e(0x321)]>0x0)for(const _0x17e608 of _0x2b6439){if(_0x5f8c2e(0x51b)===_0x5f8c2e(0x51b)){if(!_0x17e608)continue;if(_0x2e5c96[_0x5f8c2e(0x3bb)](_0x17e608))return![];}else return _0xf3669b[_0x5f8c2e(0x615)]&&_0x4470e8[_0x5f8c2e(0x5ef)][_0x5f8c2e(0x6d8)][_0x5f8c2e(0x376)](this);}if(_0x176be1[_0x5f8c2e(0x321)]>0x0){if(_0x5f8c2e(0x38a)!==_0x5f8c2e(0x38a)){if(this[_0x5f8c2e(0x342)])return![];_0x4d241b[_0x5f8c2e(0x262)]=!![];const _0x4c70bf=_0x711ed9[_0x5f8c2e(0x3db)][_0x5f8c2e(0x235)][_0x5f8c2e(0x376)](this,_0x7dcca6,_0x366b89);return _0x549e5a[_0x5f8c2e(0x262)]=![],_0x4c70bf;}else{for(const _0x151f78 of _0x176be1){if('Hrnub'==='WThOU'){const _0x311b81=_0x49cf5a(_0x282e99['$1'])||0x0,_0xe6e1e9=this[_0x5f8c2e(0x46c)](_0xaa7c37),_0x36688a=_0xe6e1e9['x']+_0x116632['floor']((_0xe6e1e9[_0x5f8c2e(0x4ca)]-_0x47336b[_0x5f8c2e(0x357)])/0x2),_0x41c1ce=_0xe6e1e9['y']+(_0xe6e1e9[_0x5f8c2e(0x232)]-_0x5b353b[_0x5f8c2e(0x2ea)])/0x2;this[_0x5f8c2e(0x25a)](_0x311b81,_0x36688a,_0x41c1ce);}else{if(!_0x151f78)continue;if(_0x2e5c96['includes'](_0x151f78))return!![];}}return![];}}return!![];},VisuMZ[_0x709961(0x3db)]['Scene_Boot_onDatabaseLoaded']=Scene_Boot[_0x709961(0x5ef)]['onDatabaseLoaded'],Scene_Boot['prototype'][_0x709961(0x50c)]=function(){const _0x3127bc=_0x709961;this[_0x3127bc(0x500)](),VisuMZ[_0x3127bc(0x3db)][_0x3127bc(0x1aa)][_0x3127bc(0x376)](this),this[_0x3127bc(0x52c)](),VisuMZ['ItemsEquipsCore'][_0x3127bc(0x2d6)](),VisuMZ['ItemsEquipsCore']['SetupArtifactItemIDs']();},Scene_Boot[_0x709961(0x5ef)]['process_VisuMZ_ItemsEquipsCore_RegExp']=function(){const _0x2b3d2a=_0x709961;VisuMZ[_0x2b3d2a(0x3db)][_0x2b3d2a(0x34a)]={},VisuMZ[_0x2b3d2a(0x3db)][_0x2b3d2a(0x34a)][_0x2b3d2a(0x679)]=[],VisuMZ['ItemsEquipsCore']['RegExp'][_0x2b3d2a(0x41e)]=[];const _0x5c7e10=[_0x2b3d2a(0x24f),_0x2b3d2a(0x459),_0x2b3d2a(0x614),'DEF',_0x2b3d2a(0x381),_0x2b3d2a(0x2e7),_0x2b3d2a(0x50a),_0x2b3d2a(0x26c)];for(const _0x123654 of _0x5c7e10){if(_0x2b3d2a(0x6a4)!==_0x2b3d2a(0x3a4)){const _0x17564a=_0x2b3d2a(0x4fd)['format'](_0x123654);VisuMZ[_0x2b3d2a(0x3db)][_0x2b3d2a(0x34a)][_0x2b3d2a(0x679)]['push'](new RegExp(_0x17564a,'i'));const _0x308d59=_0x2b3d2a(0x564)[_0x2b3d2a(0x60c)](_0x123654);VisuMZ[_0x2b3d2a(0x3db)][_0x2b3d2a(0x34a)][_0x2b3d2a(0x41e)][_0x2b3d2a(0x4ba)](new RegExp(_0x308d59,'g'));}else this[_0x2b3d2a(0x1d6)](!![]);}},Scene_Boot[_0x709961(0x5ef)][_0x709961(0x52c)]=function(){const _0x28b35b=_0x709961;if(VisuMZ['ParseAllNotetags'])return;this[_0x28b35b(0x350)]();const _0x549c06=[$dataItems,$dataWeapons,$dataArmors];for(const _0x17b485 of _0x549c06){for(const _0x322ee3 of _0x17b485){if(_0x28b35b(0x460)==='amgCx'){if(!_0x322ee3)continue;VisuMZ[_0x28b35b(0x3db)]['Parse_Notetags_Category'](_0x322ee3,_0x17b485),VisuMZ[_0x28b35b(0x3db)]['Parse_Notetags_Prices'](_0x322ee3,_0x17b485),VisuMZ['ItemsEquipsCore'][_0x28b35b(0x355)](_0x322ee3,_0x17b485),VisuMZ['ItemsEquipsCore'][_0x28b35b(0x659)](_0x322ee3,_0x17b485),VisuMZ[_0x28b35b(0x3db)][_0x28b35b(0x29e)](_0x322ee3,_0x17b485);}else return _0xdec37a[_0x28b35b(0x3db)][_0x28b35b(0x6b0)][_0x28b35b(0x281)]['LabelRemove'];}}},Scene_Boot[_0x709961(0x5ef)][_0x709961(0x350)]=function(){const _0x35d6f2=_0x709961;for(const _0x47d03b of $dataClasses){if(_0x35d6f2(0x607)==='ljjyB')_0x39540e[_0x35d6f2(0x5ef)]['isRightInputMode']['call'](this);else{if(!_0x47d03b)continue;VisuMZ['ItemsEquipsCore']['Parse_Notetags_EquipSlots'](_0x47d03b);}}},VisuMZ[_0x709961(0x3db)]['ParseClassNotetags']=VisuMZ[_0x709961(0x23b)],VisuMZ[_0x709961(0x23b)]=function(_0xbe4e13){const _0x3d34f7=_0x709961;VisuMZ[_0x3d34f7(0x3db)][_0x3d34f7(0x23b)][_0x3d34f7(0x376)](this,_0xbe4e13),VisuMZ['ItemsEquipsCore']['Parse_Notetags_EquipSlots'](_0xbe4e13);},VisuMZ[_0x709961(0x3db)][_0x709961(0x1bc)]=VisuMZ['ParseItemNotetags'],VisuMZ[_0x709961(0x1bc)]=function(_0xa21fea){const _0xd04314=_0x709961;VisuMZ['ItemsEquipsCore'][_0xd04314(0x1bc)][_0xd04314(0x376)](this,_0xa21fea),VisuMZ['ItemsEquipsCore'][_0xd04314(0x1c8)](_0xa21fea,$dataItems);},VisuMZ[_0x709961(0x3db)][_0x709961(0x555)]=VisuMZ[_0x709961(0x555)],VisuMZ[_0x709961(0x555)]=function(_0x8da782){const _0x1e9af7=_0x709961;VisuMZ[_0x1e9af7(0x3db)]['ParseWeaponNotetags']['call'](this,_0x8da782),VisuMZ[_0x1e9af7(0x3db)][_0x1e9af7(0x1c8)](_0x8da782,$dataWeapons);},VisuMZ[_0x709961(0x3db)][_0x709961(0x3bf)]=VisuMZ[_0x709961(0x3bf)],VisuMZ[_0x709961(0x3bf)]=function(_0x479367){const _0x21212a=_0x709961;VisuMZ[_0x21212a(0x3db)][_0x21212a(0x3bf)][_0x21212a(0x376)](this,_0x479367),VisuMZ[_0x21212a(0x3db)][_0x21212a(0x1c8)](_0x479367,$dataArmors);},VisuMZ['ItemsEquipsCore'][_0x709961(0x48b)]=function(_0x4ebf5c){const _0x5beac6=_0x709961;_0x4ebf5c[_0x5beac6(0x252)]=[];const _0x3ee4e6=$dataSystem[_0x5beac6(0x2c9)]['map'](_0x45dd77=>_0x45dd77?_0x45dd77[_0x5beac6(0x3c4)]():'');if(!BattleManager[_0x5beac6(0x208)]()&&_0x4ebf5c[_0x5beac6(0x1e9)][_0x5beac6(0x1ed)](/<EQUIP SLOTS>\s*([\s\S]*)\s*<\/EQUIP SLOTS>/i)){if(_0x5beac6(0x559)!==_0x5beac6(0x559)){this[_0x5beac6(0x4e3)](),this[_0x5beac6(0x30a)][_0x5beac6(0x416)]=this[_0x5beac6(0x302)]();let _0x4a2780=this['textWidth'](_0x105757[_0x5beac6(0x307)](_0x5118ad))+0x4+_0x4d6ba8;return _0x334e6c['VisuMZ_0_CoreEngine']?(this[_0x5beac6(0x623)](_0x36af5a,_0x57edd4,_0x58104d,_0x5d0e01,!![]),_0x2e0bd3['CoreEngine'][_0x5beac6(0x6b0)][_0x5beac6(0x512)][_0x5beac6(0x426)]&&(_0x4a2780+=_0x4ed760['iconWidth']+0x4)):(this[_0x5beac6(0x61c)](_0x385dd4[_0x5beac6(0x697)]()),this[_0x5beac6(0x62c)](_0x1878a8['param'](_0x266f67),_0x9f2b1e,_0x44688c,_0xa7acb1)),this[_0x5beac6(0x4e3)](),_0x4a2780;}else{const _0x551ed8=String(RegExp['$1'])['split'](/[\r\n]+/);for(const _0x467915 of _0x551ed8){const _0x4f0db7=_0x3ee4e6[_0x5beac6(0x532)](_0x467915[_0x5beac6(0x3c4)]());if(_0x4f0db7>0x0)_0x4ebf5c[_0x5beac6(0x252)][_0x5beac6(0x4ba)](_0x4f0db7);}}}else for(const _0x464815 of _0x3ee4e6){const _0x304a67=_0x3ee4e6[_0x5beac6(0x532)](_0x464815[_0x5beac6(0x3c4)]());if(_0x304a67>0x0)_0x4ebf5c[_0x5beac6(0x252)][_0x5beac6(0x4ba)](_0x304a67);}},VisuMZ[_0x709961(0x3db)][_0x709961(0x1c8)]=function(_0x2bf0fa,_0x5a4f6a){const _0x1566bf=_0x709961;VisuMZ['ItemsEquipsCore']['Parse_Notetags_Category'](_0x2bf0fa,_0x5a4f6a),VisuMZ[_0x1566bf(0x3db)][_0x1566bf(0x5dd)](_0x2bf0fa,_0x5a4f6a),VisuMZ['ItemsEquipsCore']['Parse_Notetags_ParamValues'](_0x2bf0fa,_0x5a4f6a),VisuMZ['ItemsEquipsCore'][_0x1566bf(0x659)](_0x2bf0fa,_0x5a4f6a),VisuMZ['ItemsEquipsCore']['Parse_Notetags_EnableJS'](_0x2bf0fa,_0x5a4f6a);},VisuMZ['ItemsEquipsCore'][_0x709961(0x296)]=function(_0x9856c3,_0x2fa74e){const _0x4477b6=_0x709961;_0x9856c3[_0x4477b6(0x5d4)]=[];const _0xcce08d=_0x9856c3[_0x4477b6(0x1e9)],_0x59618c=_0xcce08d[_0x4477b6(0x1ed)](/<(?:CATEGORY|CATEGORIES):[ ](.*)>/gi);if(_0x59618c)for(const _0x231182 of _0x59618c){_0x231182['match'](/<(?:CATEGORY|CATEGORIES):[ ](.*)>/gi);const _0x4266c1=String(RegExp['$1'])[_0x4477b6(0x45c)]()['trim']()[_0x4477b6(0x617)](',');for(const _0x1598a2 of _0x4266c1){_0x9856c3[_0x4477b6(0x5d4)]['push'](_0x1598a2['trim']());}}if(_0xcce08d['match'](/<(?:CATEGORY|CATEGORIES)>\s*([\s\S]*)\s*<\/(?:CATEGORY|CATEGORIES)>/i)){if(_0x4477b6(0x582)!==_0x4477b6(0x31a)){const _0x11fdbb=RegExp['$1'][_0x4477b6(0x617)](/[\r\n]+/);for(const _0x333c70 of _0x11fdbb){if(_0x4477b6(0x63f)===_0x4477b6(0x63f))_0x9856c3['categories'][_0x4477b6(0x4ba)](_0x333c70[_0x4477b6(0x45c)]()[_0x4477b6(0x3c4)]());else return _0x3453d7[_0x4477b6(0x3db)][_0x4477b6(0x6b0)]['StatusWindow'][_0x4477b6(0x4d2)];}}else return!!_0x37ba0c&&_0x3a8005['categories'][_0x4477b6(0x3bb)](_0x20d128(_0x2f9a2e['$1'])['toUpperCase']()[_0x4477b6(0x3c4)]());}},VisuMZ[_0x709961(0x3db)]['Parse_Notetags_Prices']=function(_0x204839,_0x21ea19){const _0xedfd27=_0x709961;if(_0x204839[_0xedfd27(0x1e9)][_0xedfd27(0x1ed)](/<PRICE:[ ](\d+)>/i)){if(_0xedfd27(0x5b3)===_0xedfd27(0x686)){const _0x10f1ee=_0xedfd27(0x65c);if(this[_0xedfd27(0x6f3)][_0xedfd27(0x69d)]===0x0&&!this[_0xedfd27(0x3b8)][_0x10f1ee])return![];const _0xa230f8=this['getItemEffectsSelfTpGainLabel']();this[_0xedfd27(0x2c2)](_0xa230f8,_0x10fb8,_0x457c91,_0x422aae,!![]);const _0x5d4454=this[_0xedfd27(0x54f)]();return this[_0xedfd27(0x6f3)][_0xedfd27(0x69d)]>0x0?this[_0xedfd27(0x61c)](_0x274dec[_0xedfd27(0x35e)]()):this[_0xedfd27(0x61c)](_0x23b823[_0xedfd27(0x298)]()),this['drawItemKeyData'](_0x5d4454,_0x259b24,_0xf9a1fb,_0x4adb46,![],'right'),this[_0xedfd27(0x533)](_0x526739,_0x3c8961,_0x2e2f9f),this['resetFontSettings'](),!![];}else _0x204839[_0xedfd27(0x518)]=Number(RegExp['$1']);}},VisuMZ[_0x709961(0x3db)]['Parse_Notetags_ParamValues']=function(_0x244f66,_0x93c7ca){const _0x48dde8=_0x709961;if(_0x93c7ca===$dataItems)return;for(let _0x2b9c03=0x0;_0x2b9c03<0x8;_0x2b9c03++){const _0x41cebc=VisuMZ['ItemsEquipsCore'][_0x48dde8(0x34a)][_0x48dde8(0x679)][_0x2b9c03];_0x244f66['note'][_0x48dde8(0x1ed)](_0x41cebc)&&(_0x48dde8(0x4d0)!==_0x48dde8(0x4d0)?(_0x546de4[_0x48dde8(0x3db)][_0x48dde8(0x3e0)][_0x48dde8(0x376)](this),this[_0x48dde8(0x6d8)]()&&this[_0x48dde8(0x55f)]()):_0x244f66[_0x48dde8(0x63a)][_0x2b9c03]=parseInt(RegExp['$1']));}},VisuMZ[_0x709961(0x3db)][_0x709961(0x510)]={},VisuMZ['ItemsEquipsCore'][_0x709961(0x659)]=function(_0xc5f320,_0x407807){const _0x3f4825=_0x709961;if(_0x407807===$dataItems)return;if(_0xc5f320[_0x3f4825(0x1e9)]['match'](/<JS PARAMETERS>\s*([\s\S]*)\s*<\/JS PARAMETERS>/i)){const _0x5829a3=String(RegExp['$1']),_0x34126c=(_0x407807===$dataWeapons?_0x3f4825(0x557):_0x3f4825(0x473))[_0x3f4825(0x60c)](_0xc5f320['id']),_0x2a7e9e='\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20MaxHP\x20=\x200;\x20let\x20MaxMP\x20=\x200;\x20let\x20ATK\x20=\x200;\x20let\x20DEF\x20=\x200;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20MAT\x20=\x200;\x20let\x20MDF\x20=\x200;\x20let\x20AGI\x20=\x200;\x20let\x20LUK\x20=\x200;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20[MaxHP,\x20MaxMP,\x20ATK,\x20DEF,\x20MAT,\x20MDF,\x20AGI,\x20LUK][paramId];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20'[_0x3f4825(0x60c)](_0x5829a3);for(let _0x109238=0x0;_0x109238<0x8;_0x109238++){if(_0x3f4825(0x40a)!==_0x3f4825(0x40a))return _0x497342[_0x3f4825(0x6c1)]['isUseItemsEquipsCoreUpdatedLayout']()?0x1:0x2;else{if(_0x5829a3[_0x3f4825(0x1ed)](VisuMZ[_0x3f4825(0x3db)][_0x3f4825(0x34a)][_0x3f4825(0x41e)][_0x109238])){const _0x172562=_0x3f4825(0x47e)[_0x3f4825(0x60c)](_0x34126c,_0x109238);VisuMZ['ItemsEquipsCore']['paramJS'][_0x172562]=new Function(_0x3f4825(0x24d),'paramId',_0x2a7e9e);}}}}},VisuMZ['ItemsEquipsCore']['itemEnableJS']={},VisuMZ[_0x709961(0x3db)][_0x709961(0x29e)]=function(_0x48d5fd,_0x40473b){const _0x38a863=_0x709961;if(_0x40473b!==$dataItems)return;if(_0x48d5fd['note'][_0x38a863(0x1ed)](/<JS ITEM ENABLE>\s*([\s\S]*)\s*<\/JS ITEM ENABLE>/i)){const _0x1e64bd=String(RegExp['$1']),_0x2213fd=_0x38a863(0x64d)[_0x38a863(0x60c)](_0x1e64bd);VisuMZ[_0x38a863(0x3db)][_0x38a863(0x52b)][_0x48d5fd['id']]=new Function(_0x38a863(0x24d),_0x2213fd);}},DataManager[_0x709961(0x239)]=function(_0x55251f){const _0x3a463c=_0x709961;return this[_0x3a463c(0x2f3)](_0x55251f)&&_0x55251f[_0x3a463c(0x4d4)]===0x2;},DataManager[_0x709961(0x1ec)]=function(_0x26c2a1){const _0x5950b3=_0x709961;if(!_0x26c2a1){if(_0x5950b3(0x68b)===_0x5950b3(0x68b))return 0x63;else{const _0x388697=_0x54ca81[_0x5950b3(0x6c1)][_0x5950b3(0x3bc)];_0x388697&&(this[_0x5950b3(0x22a)](this[_0x5950b3(0x624)]())?(this[_0x5950b3(0x3ad)](),this[_0x5950b3(0x317)]()):this['playBuzzerSound']());}}else return _0x26c2a1['note'][_0x5950b3(0x1ed)](/<MAX:[ ](\d+)>/i)?parseInt(RegExp['$1']):this[_0x5950b3(0x67d)](_0x26c2a1);},DataManager[_0x709961(0x67d)]=function(_0x1175bb){const _0x46ff27=_0x709961;if(this[_0x46ff27(0x2f3)](_0x1175bb)){if(_0x46ff27(0x1d7)!==_0x46ff27(0x1d7)){const _0x3c5c54=_0x424665(_0x5873e3['$1'])[_0x46ff27(0x617)](',')[_0x46ff27(0x1ac)](_0x4bbd5f=>_0xf6be1d(_0x4bbd5f));if(_0x3c5c54['some'](_0x46803d=>!_0x1156f4[_0x46ff27(0x337)](_0x46803d)))return![];}else return VisuMZ[_0x46ff27(0x3db)][_0x46ff27(0x6b0)][_0x46ff27(0x309)][_0x46ff27(0x3e4)];}else{if(this[_0x46ff27(0x67a)](_0x1175bb)){if(_0x46ff27(0x303)===_0x46ff27(0x61b)){const _0x4f833c=this[_0x46ff27(0x2df)]();this[_0x46ff27(0x2c2)](_0x4f833c,_0x2ee227,_0x390e19,_0x3c1308,!![]),this['setupItemDamageTempActors']();const _0x2ff208=this[_0x46ff27(0x6f1)](),_0x410bbb=_0xa8a718[_0x46ff27(0x24c)]([0x0,0x0,0x2,0x1,0x3,0x1,0x3][this[_0x46ff27(0x3c2)][_0x46ff27(0x553)][_0x46ff27(0x44f)]]);return this[_0x46ff27(0x61c)](_0x410bbb),this[_0x46ff27(0x2c2)](_0x2ff208,_0x30b8f3,_0x33d830,_0x4ec016,![],'right'),this[_0x46ff27(0x533)](_0x542f4d,_0x589176,_0x2508b8),this[_0x46ff27(0x4e3)](),!![];}else return VisuMZ[_0x46ff27(0x3db)][_0x46ff27(0x6b0)][_0x46ff27(0x309)]['MaxWeapons'];}else{if(this[_0x46ff27(0x3b3)](_0x1175bb))return VisuMZ['ItemsEquipsCore'][_0x46ff27(0x6b0)]['ItemScene'][_0x46ff27(0x485)];}}},DataManager[_0x709961(0x508)]=function(_0x194ff3){const _0xbe31bd=_0x709961;_0x194ff3=_0x194ff3[_0xbe31bd(0x45c)]()[_0xbe31bd(0x3c4)](),this[_0xbe31bd(0x5b2)]=this['_classIDs']||{};if(this['_classIDs'][_0x194ff3])return this[_0xbe31bd(0x5b2)][_0x194ff3];for(const _0x4fbacb of $dataClasses){if(_0xbe31bd(0x1fd)!=='KMKtB'){const _0x33730d=this['_itemData'][_0xbe31bd(0x6d1)][_0xd143d6],_0x3021d7=_0x59fdc6[_0xbe31bd(0x5ef)][_0xbe31bd(0x1ea)](-0x1,_0x33730d);if(_0x3021d7>0x0){_0x5e1575+='\x5cI[%1]'[_0xbe31bd(0x60c)](_0x3021d7),_0x530793++;if(_0x4b09b0>=_0x221b89)return _0x5c92da;}}else{if(!_0x4fbacb)continue;let _0xc32f3=_0x4fbacb['name'];_0xc32f3=_0xc32f3[_0xbe31bd(0x3a5)](/\x1I\[(\d+)\]/gi,''),_0xc32f3=_0xc32f3[_0xbe31bd(0x3a5)](/\\I\[(\d+)\]/gi,''),this[_0xbe31bd(0x5b2)][_0xc32f3['toUpperCase']()[_0xbe31bd(0x3c4)]()]=_0x4fbacb['id'];}}return this[_0xbe31bd(0x5b2)][_0x194ff3]||0x0;},DataManager[_0x709961(0x215)]=function(_0x161de9){const _0x4950d0=_0x709961;_0x161de9=_0x161de9[_0x4950d0(0x45c)]()[_0x4950d0(0x3c4)](),this['_skillIDs']=this['_skillIDs']||{};if(this['_skillIDs'][_0x161de9])return this[_0x4950d0(0x635)][_0x161de9];for(const _0x5aa43f of $dataSkills){if(!_0x5aa43f)continue;this[_0x4950d0(0x635)][_0x5aa43f['name'][_0x4950d0(0x45c)]()[_0x4950d0(0x3c4)]()]=_0x5aa43f['id'];}return this[_0x4950d0(0x635)][_0x161de9]||0x0;},DataManager['getItemIdWithName']=function(_0xdea9){const _0x555541=_0x709961;_0xdea9=_0xdea9[_0x555541(0x45c)]()['trim'](),this[_0x555541(0x3ec)]=this[_0x555541(0x3ec)]||{};if(this[_0x555541(0x3ec)][_0xdea9])return this[_0x555541(0x3ec)][_0xdea9];for(const _0x418d5c of $dataItems){if(!_0x418d5c)continue;this[_0x555541(0x3ec)][_0x418d5c[_0x555541(0x5a7)][_0x555541(0x45c)]()['trim']()]=_0x418d5c['id'];}return this[_0x555541(0x3ec)][_0xdea9]||0x0;},DataManager[_0x709961(0x278)]=function(_0x393563){const _0x2f3355=_0x709961;_0x393563=_0x393563['toUpperCase']()['trim'](),this['_weaponIDs']=this['_weaponIDs']||{};if(this['_weaponIDs'][_0x393563])return this[_0x2f3355(0x214)][_0x393563];for(const _0x4f634f of $dataWeapons){if(!_0x4f634f)continue;this['_weaponIDs'][_0x4f634f[_0x2f3355(0x5a7)][_0x2f3355(0x45c)]()[_0x2f3355(0x3c4)]()]=_0x4f634f['id'];}return this[_0x2f3355(0x214)][_0x393563]||0x0;},DataManager[_0x709961(0x3c5)]=function(_0x14a73a){const _0x1b47cd=_0x709961;_0x14a73a=_0x14a73a[_0x1b47cd(0x45c)]()[_0x1b47cd(0x3c4)](),this[_0x1b47cd(0x4e8)]=this[_0x1b47cd(0x4e8)]||{};if(this[_0x1b47cd(0x4e8)][_0x14a73a])return this[_0x1b47cd(0x4e8)][_0x14a73a];for(const _0x5c92a9 of $dataArmors){if(_0x1b47cd(0x25f)===_0x1b47cd(0x23a))return![];else{if(!_0x5c92a9)continue;this[_0x1b47cd(0x4e8)][_0x5c92a9[_0x1b47cd(0x5a7)][_0x1b47cd(0x45c)]()[_0x1b47cd(0x3c4)]()]=_0x5c92a9['id'];}}return this[_0x1b47cd(0x4e8)][_0x14a73a]||0x0;},DataManager[_0x709961(0x5d9)]=function(_0x150cf6){const _0x5e0a6f=_0x709961;_0x150cf6=_0x150cf6[_0x5e0a6f(0x45c)]()['trim'](),this[_0x5e0a6f(0x2da)]=this[_0x5e0a6f(0x2da)]||{};if(this[_0x5e0a6f(0x2da)][_0x150cf6])return this[_0x5e0a6f(0x2da)][_0x150cf6];for(const _0x3d891e of $dataSystem[_0x5e0a6f(0x2c9)]){this[_0x5e0a6f(0x2da)][_0x3d891e[_0x5e0a6f(0x45c)]()['trim']()]=$dataSystem[_0x5e0a6f(0x2c9)]['indexOf'](_0x3d891e);}return this[_0x5e0a6f(0x2da)][_0x150cf6]||0x0;},VisuMZ[_0x709961(0x3db)][_0x709961(0x2d6)]=function(){const _0x1cbcc7=_0x709961;VisuMZ['ItemsEquipsCore']['SetupProxyItemGroup']($dataItems),VisuMZ['ItemsEquipsCore'][_0x1cbcc7(0x6e1)]($dataWeapons),VisuMZ['ItemsEquipsCore'][_0x1cbcc7(0x6e1)]($dataArmors);},VisuMZ[_0x709961(0x3db)][_0x709961(0x6e1)]=function(_0x335652){const _0x454f98=_0x709961;for(const _0x2a2082 of _0x335652){if(_0x454f98(0x45f)===_0x454f98(0x605))_0x26b562='item-%1'[_0x454f98(0x60c)](_0x1ffa98['id']);else{if(!_0x2a2082)continue;if(!DataManager[_0x454f98(0x4a0)](_0x2a2082))continue;const _0x32aa28=DataManager[_0x454f98(0x36d)](_0x2a2082),_0x137b1c=[_0x454f98(0x5a7),'iconIndex',_0x454f98(0x3fa)];for(const _0x585a27 of _0x137b1c){if('VVPBt'!==_0x454f98(0x1e4))_0x2a2082[_0x585a27]=_0x32aa28[_0x585a27];else for(const _0x6c255e of _0x57cb58[_0x454f98(0x68c)](this[_0x454f98(0x6f4)])){_0x6c255e['hide']();}}}}},DataManager[_0x709961(0x4a0)]=function(_0x30f936){const _0xc7513c=_0x709961;if(!_0x30f936)return![];if(!_0x30f936[_0xc7513c(0x1e9)])return![];return _0x30f936&&_0x30f936['note'][_0xc7513c(0x1ed)](/<PROXY:[ ](.*)>/i);},DataManager[_0x709961(0x36d)]=function(_0x2630c5){const _0x7438ef=_0x709961;return this[_0x7438ef(0x4a0)](_0x2630c5)?this[_0x7438ef(0x547)](_0x2630c5)||_0x2630c5:_0x2630c5;},DataManager['switchProxyItem']=function(_0x354643){const _0x33f769=_0x709961;_0x354643[_0x33f769(0x1e9)][_0x33f769(0x1ed)](/<PROXY:[ ](.*)>/i);const _0x237485=RegExp['$1'][_0x33f769(0x3c4)](),_0x342b03=/^\d+$/[_0x33f769(0x566)](_0x237485);if(this[_0x33f769(0x2f3)](_0x354643)){if(_0x33f769(0x391)!=='DVOkn')this[_0x33f769(0x34b)]();else{const _0x18c75d=_0x342b03?Number(_0x237485):DataManager[_0x33f769(0x665)](_0x237485);return $dataItems[_0x18c75d]||_0x354643;}}else{if(this[_0x33f769(0x67a)](_0x354643)){const _0xff0944=_0x342b03?Number(_0x237485):DataManager[_0x33f769(0x278)](_0x237485);return $dataWeapons[_0xff0944]||_0x354643;}else{if(this[_0x33f769(0x3b3)](_0x354643)){if('UtDJt'==='UtDJt'){const _0x383649=_0x342b03?Number(_0x237485):DataManager[_0x33f769(0x3c5)](_0x237485);return $dataArmors[_0x383649]||_0x354643;}else for(const _0x260bcb of _0x17d367){_0x260bcb['match'](/<(?:CATEGORY|CATEGORIES):[ ](.*)>/gi);const _0x3b0061=_0x17b807(_0xb028d3['$1'])[_0x33f769(0x45c)]()[_0x33f769(0x3c4)]()[_0x33f769(0x617)](',');for(const _0x39ec12 of _0x3b0061){_0x1944db['categories'][_0x33f769(0x4ba)](_0x39ec12['trim']());}}}}}return _0x354643;},VisuMZ[_0x709961(0x3db)][_0x709961(0x295)]=Window_ItemList[_0x709961(0x5ef)][_0x709961(0x24d)],Window_ItemList['prototype']['item']=function(){const _0x1261e6=_0x709961;if($gameTemp['_bypassProxy'])return VisuMZ[_0x1261e6(0x3db)][_0x1261e6(0x295)]['call'](this);return DataManager[_0x1261e6(0x36d)](VisuMZ[_0x1261e6(0x3db)][_0x1261e6(0x295)][_0x1261e6(0x376)](this));},Window_ItemList[_0x709961(0x5ef)][_0x709961(0x24e)]=function(){const _0x1a3fe8=_0x709961;return VisuMZ[_0x1a3fe8(0x3db)]['Window_ItemList_item']['call'](this);},VisuMZ[_0x709961(0x3db)][_0x709961(0x4d8)]=Window_ShopBuy['prototype'][_0x709961(0x24d)],Window_ShopBuy['prototype'][_0x709961(0x24d)]=function(){const _0x258acd=_0x709961;if($gameTemp[_0x258acd(0x327)])return VisuMZ[_0x258acd(0x3db)][_0x258acd(0x4d8)][_0x258acd(0x376)](this);return DataManager[_0x258acd(0x36d)](VisuMZ[_0x258acd(0x3db)][_0x258acd(0x4d8)][_0x258acd(0x376)](this));},Window_ShopBuy['prototype'][_0x709961(0x24e)]=function(){const _0x58a734=_0x709961;return VisuMZ['ItemsEquipsCore'][_0x58a734(0x4d8)][_0x58a734(0x376)](this);},VisuMZ[_0x709961(0x3db)][_0x709961(0x498)]=Game_Item[_0x709961(0x5ef)][_0x709961(0x299)],Game_Item[_0x709961(0x5ef)]['setObject']=function(_0x5bfd32){const _0x322178=_0x709961;if(DataManager['isProxyItem'](_0x5bfd32))return;VisuMZ[_0x322178(0x3db)]['Game_Item_setObject'][_0x322178(0x376)](this,_0x5bfd32);},VisuMZ[_0x709961(0x3db)][_0x709961(0x207)]=function(){const _0x4363a8=_0x709961;this[_0x4363a8(0x398)]={'partyArtifactIDs':[],'troopArtifactIDs':[]};for(const _0x298cfe of $dataArmors){if(!_0x298cfe)continue;if(!DataManager['isArtifact'](_0x298cfe))continue;DataManager['isPartyArtifact'](_0x298cfe)&&this[_0x4363a8(0x398)][_0x4363a8(0x470)]['push'](_0x298cfe['id']);if(DataManager[_0x4363a8(0x5c7)](_0x298cfe)){if(_0x4363a8(0x4ed)===_0x4363a8(0x2e4)){const _0x4e0b43=this[_0x4363a8(0x1be)](),_0x2e22f2=_0x5a2969['ItemsEquipsCore'][_0x4363a8(0x6b0)][_0x4363a8(0x300)][_0x4363a8(0x433)],_0x30bbf2=_0x4e0b43===_0x4363a8(0x461)?_0x4692e9[_0x4363a8(0x41a)]:'\x5cI[%1]%2'['format'](_0x2e22f2,_0x4036c5[_0x4363a8(0x41a)]),_0x2987f8=this[_0x4363a8(0x3d4)]();if(this[_0x4363a8(0x20c)]()&&!_0x2987f8)return;this[_0x4363a8(0x1cb)](_0x30bbf2,_0x4363a8(0x41a),_0x2987f8);}else this[_0x4363a8(0x398)][_0x4363a8(0x677)]['push'](_0x298cfe['id']);}}},DataManager[_0x709961(0x676)]=function(_0xb70b06){const _0xf7e5ac=_0x709961;if(!this[_0xf7e5ac(0x3b3)](_0xb70b06))return![];const _0x16ef36=_0xb70b06[_0xf7e5ac(0x1e9)];if(!_0x16ef36)return![];if(_0x16ef36[_0xf7e5ac(0x1ed)](/<(?:PARTY|ALLY) (?:ARTIFACT|RELIC)>/i))return!![];if(_0x16ef36[_0xf7e5ac(0x1ed)](/<(?:STACKABLE|STACK) (?:PARTY|ALLY) (?:ARTIFACT|RELIC)>/i))return!![];if(_0x16ef36[_0xf7e5ac(0x1ed)](/<(?:TROOP|FOE) (?:ARTIFACT|RELIC)>/i))return!![];if(_0x16ef36[_0xf7e5ac(0x1ed)](/<(?:STACKABLE|STACK) (?:TROOP|FOE) (?:ARTIFACT|RELIC)>/i))return!![];return![];},DataManager[_0x709961(0x55c)]=function(_0x344ed9){const _0x56e759=_0x709961;if(!this[_0x56e759(0x676)](_0x344ed9))return![];const _0x29f14e=_0x344ed9[_0x56e759(0x1e9)];if(!_0x29f14e)return![];if(_0x29f14e[_0x56e759(0x1ed)](/<(?:STACKABLE|STACK) (?:PARTY|ALLY) (?:ARTIFACT|RELIC)>/i))return!![];if(_0x29f14e['match'](/<(?:STACKABLE|STACK) (?:TROOP|FOE) (?:ARTIFACT|RELIC)>/i))return!![];return![];},DataManager[_0x709961(0x666)]=function(_0x36ba8a){const _0xba3d3=_0x709961;if(!this[_0xba3d3(0x676)](_0x36ba8a))return![];const _0x399165=_0x36ba8a[_0xba3d3(0x1e9)];if(!_0x399165)return![];if(_0x399165[_0xba3d3(0x1ed)](/<(?:PARTY|ALLY) (?:ARTIFACT|RELIC)>/i))return!![];if(_0x399165[_0xba3d3(0x1ed)](/<(?:STACKABLE|STACK) (?:PARTY|ALLY) (?:ARTIFACT|RELIC)>/i))return!![];return![];},DataManager[_0x709961(0x5c7)]=function(_0xd942ca){const _0x3ed2ed=_0x709961;if(!this[_0x3ed2ed(0x676)](_0xd942ca))return![];const _0xa28218=_0xd942ca['note'];if(!_0xa28218)return![];if(_0xa28218[_0x3ed2ed(0x1ed)](/<(?:TROOP|FOE) (?:ARTIFACT|RELIC)>/i))return!![];if(_0xa28218['match'](/<(?:STACKABLE|STACK) (?:TROOP|FOE) (?:ARTIFACT|RELIC)>/i))return!![];return![];},VisuMZ[_0x709961(0x3db)][_0x709961(0x37c)]=Game_BattlerBase[_0x709961(0x5ef)][_0x709961(0x447)],Game_BattlerBase[_0x709961(0x5ef)][_0x709961(0x447)]=function(_0x4936fd){const _0x2d0ddd=_0x709961;if(DataManager['isArtifact'](_0x4936fd))return![];if(!DataManager['meetsClassRequirements'](this,_0x4936fd))return![];if(!DataManager['meetsEquipRequirements'](this,_0x4936fd))return![];return VisuMZ[_0x2d0ddd(0x3db)][_0x2d0ddd(0x37c)]['call'](this,_0x4936fd);},VisuMZ['ItemsEquipsCore']['Game_BattlerBase_param_artifact']=Game_BattlerBase['prototype'][_0x709961(0x307)],Game_BattlerBase[_0x709961(0x5ef)][_0x709961(0x307)]=function(_0x4b17d0){const _0x274545=_0x709961;this[_0x274545(0x263)]=!![];const _0x5178cc=VisuMZ[_0x274545(0x3db)][_0x274545(0x4e9)][_0x274545(0x376)](this,_0x4b17d0);return this[_0x274545(0x263)]=undefined,_0x5178cc;},VisuMZ['ItemsEquipsCore']['Game_Actor_artifact']=Game_Actor[_0x709961(0x5ef)]['traitObjects'],Game_Actor[_0x709961(0x5ef)]['traitObjects']=function(){const _0x1c7a42=_0x709961;this[_0x1c7a42(0x1bd)]=!![];const _0xed4654=VisuMZ[_0x1c7a42(0x3db)][_0x1c7a42(0x2a6)][_0x1c7a42(0x376)](this);return this[_0x1c7a42(0x1bd)]=undefined,_0xed4654;},VisuMZ[_0x709961(0x3db)][_0x709961(0x3b1)]=Game_Actor[_0x709961(0x5ef)][_0x709961(0x673)],Game_Actor[_0x709961(0x5ef)][_0x709961(0x673)]=function(){const _0x4afdab=_0x709961,_0x19a0ef=VisuMZ[_0x4afdab(0x3db)]['Game_Actor_equips_artifacts'][_0x4afdab(0x376)](this);if(this[_0x4afdab(0x1bd)]||this[_0x4afdab(0x263)]){const _0x18b8b0=_0x19a0ef['concat']($gameParty[_0x4afdab(0x359)]());return _0x18b8b0;}else return _0x19a0ef;},VisuMZ[_0x709961(0x3db)][_0x709961(0x38c)]=Game_BattlerBase[_0x709961(0x5ef)][_0x709961(0x6e2)],Game_BattlerBase[_0x709961(0x5ef)]['paramPlus']=function(_0x89db3e){const _0x2af691=_0x709961;let _0x7f192e=VisuMZ[_0x2af691(0x3db)][_0x2af691(0x38c)][_0x2af691(0x376)](this,_0x89db3e);if(this[_0x2af691(0x3f7)]===Game_Enemy)for(const _0x1c8ea3 of $gameParty[_0x2af691(0x428)]()){if(_0x1c8ea3)_0x7f192e+=_0x1c8ea3['params'][_0x89db3e];}return _0x7f192e;},VisuMZ[_0x709961(0x3db)][_0x709961(0x46a)]=Game_Enemy['prototype']['traitObjects'],Game_Enemy['prototype'][_0x709961(0x1e1)]=function(){const _0x530dde=_0x709961;let _0x4ff017=VisuMZ[_0x530dde(0x3db)]['Game_Enemy_traitObjects_artifact'][_0x530dde(0x376)](this);return _0x4ff017['concat']($gameParty[_0x530dde(0x428)]());},VisuMZ['ItemsEquipsCore'][_0x709961(0x259)]=Game_Party[_0x709961(0x5ef)]['gainItem'],Game_Party[_0x709961(0x5ef)][_0x709961(0x2a5)]=function(_0x2f2e59,_0x4efafa,_0x580b29){const _0x237e52=_0x709961;VisuMZ[_0x237e52(0x3db)]['Game_Party_gainItem_artifact'][_0x237e52(0x376)](this,_0x2f2e59,_0x4efafa,_0x580b29);if(DataManager[_0x237e52(0x676)](_0x2f2e59)){if('eSbTk'===_0x237e52(0x62b)){let _0x4bdd6d=$gameParty[_0x237e52(0x1cc)]();if($gameParty[_0x237e52(0x30d)]())_0x4bdd6d=_0x4bdd6d['concat']($gameTroop['members']());for(const _0x35a228 of _0x4bdd6d){if(_0x237e52(0x603)===_0x237e52(0x48e))this[_0x237e52(0x2d5)]();else{if(!_0x35a228)continue;_0x35a228['_cache']={};}}}else _0x2a35b9[_0x237e52(0x4be)]=this[_0x237e52(0x48a)];}},Game_Party[_0x709961(0x5ef)][_0x709961(0x359)]=function(){const _0x4c5720=_0x709961;let _0x19d4ed=[];const _0x55b200=VisuMZ[_0x4c5720(0x3db)][_0x4c5720(0x398)][_0x4c5720(0x470)];if(_0x55b200){if(_0x4c5720(0x33f)!=='aQaqf')for(const _0x32afd8 of _0x55b200){const _0x19eeb7=$dataArmors[_0x32afd8];if(!_0x19eeb7)continue;if(!this[_0x4c5720(0x646)](_0x19eeb7))continue;let _0x38797e=0x1;if(DataManager[_0x4c5720(0x55c)](_0x19eeb7))_0x38797e=this[_0x4c5720(0x402)](_0x19eeb7);while(_0x38797e--)_0x19d4ed[_0x4c5720(0x4ba)](_0x19eeb7);}else _0x3e86a8['prototype'][_0x4c5720(0x67e)][_0x4c5720(0x376)](this);}return _0x19d4ed;},Game_Party[_0x709961(0x5ef)][_0x709961(0x428)]=function(){const _0x5dcbd8=_0x709961;let _0x5eb042=[];const _0x59a6c4=VisuMZ[_0x5dcbd8(0x3db)][_0x5dcbd8(0x398)]['troopArtifactIDs'];if(_0x59a6c4)for(const _0x27e4f2 of _0x59a6c4){if('SvJxF'===_0x5dcbd8(0x43e))_0x2d04f8['push'](_0x431299);else{const _0x1bdaad=$dataArmors[_0x27e4f2];if(!_0x1bdaad)continue;if(!this[_0x5dcbd8(0x646)](_0x1bdaad))continue;let _0x5a0686=0x1;if(DataManager['isStackableArtifact'](_0x1bdaad))_0x5a0686=this['numItems'](_0x1bdaad);while(_0x5a0686--)_0x5eb042[_0x5dcbd8(0x4ba)](_0x1bdaad);}}return _0x5eb042;},Game_Party[_0x709961(0x5ef)][_0x709961(0x694)]=function(){const _0x45ffb9=_0x709961;return this[_0x45ffb9(0x359)]()[_0x45ffb9(0x33e)](this[_0x45ffb9(0x428)]());},VisuMZ[_0x709961(0x3db)][_0x709961(0x647)]=Game_Party[_0x709961(0x5ef)][_0x709961(0x2bf)],Game_Party[_0x709961(0x5ef)][_0x709961(0x2bf)]=function(){const _0x47b901=_0x709961;VisuMZ[_0x47b901(0x3db)][_0x47b901(0x647)][_0x47b901(0x376)](this),this[_0x47b901(0x415)]();},Game_Party[_0x709961(0x5ef)]['removeBattleTestArtifacts']=function(){const _0xcbbe3f=_0x709961,_0x4529bb=$gameParty[_0xcbbe3f(0x2e6)]()[_0xcbbe3f(0x672)](_0x338026=>DataManager[_0xcbbe3f(0x676)](_0x338026));for(const _0x4936b8 of _0x4529bb){const _0x5683d4=this[_0xcbbe3f(0x402)](_0x4936b8);if(_0x5683d4)this[_0xcbbe3f(0x65b)](_0x4936b8,_0x5683d4);}},DataManager[_0x709961(0x62e)]=function(_0x5757c3,_0x3bbc01){const _0x229b83=_0x709961;if(this[_0x229b83(0x2f3)](_0x3bbc01))return![];if(!_0x5757c3)return![];if($gameTemp[_0x229b83(0x61d)])return!![];if(BattleManager[_0x229b83(0x208)]())return!![];const _0x22606c=this[_0x229b83(0x541)](_0x3bbc01);if(_0x22606c[_0x229b83(0x321)]<=0x0)return!![];return _0x22606c[_0x229b83(0x3bb)](_0x5757c3[_0x229b83(0x6d4)]()['id']);},DataManager[_0x709961(0x541)]=function(_0xc553a3){const _0x1d8bbd=_0x709961;if(!_0xc553a3)return[];this['_getClassRequirements']=this['_getClassRequirements']||{};const _0x304b64=_0x1d8bbd(0x47e)['format'](this[_0x1d8bbd(0x67a)](_0xc553a3)?_0x1d8bbd(0x6d7):'ARMOR',_0xc553a3['id']);if(this['_getClassRequirements'][_0x304b64]!==undefined)return this[_0x1d8bbd(0x5da)][_0x304b64];let _0x456521=[];const _0x22a86b=_0xc553a3[_0x1d8bbd(0x1e9)]||'';if(_0x22a86b['match'](/<EQUIP FOR CLASS(?:|ES) ONLY:[ ](.*)>/i)){if(_0x1d8bbd(0x51a)!==_0x1d8bbd(0x6d2)){const _0x3e440d=String(RegExp['$1'])['split'](',')[_0x1d8bbd(0x1ac)](_0x42965c=>_0x42965c[_0x1d8bbd(0x3c4)]());for(const _0x577aeb of _0x3e440d){const _0x447ca1=/^\d+$/[_0x1d8bbd(0x566)](_0x577aeb);_0x447ca1?_0x456521[_0x1d8bbd(0x4ba)](Number(_0x577aeb)):_0x456521['push'](DataManager[_0x1d8bbd(0x508)](_0x577aeb));}}else _0x33b9b7[_0x1d8bbd(0x3db)][_0x1d8bbd(0x4e7)][_0x1d8bbd(0x376)](this),this['isUseItemsEquipsCoreUpdatedLayout']()&&this[_0x1d8bbd(0x3b5)](),this[_0x1d8bbd(0x6d8)]()&&(this[_0x1d8bbd(0x5cd)][_0x1d8bbd(0x1de)](0x0),this[_0x1d8bbd(0x55f)]());}return this['_getClassRequirements'][_0x304b64]=_0x456521,this[_0x1d8bbd(0x5da)][_0x304b64];},DataManager['meetsEquipRequirements']=function(_0x5b6281,_0x2d30ae){const _0x239783=_0x709961;if(this[_0x239783(0x2f3)](_0x2d30ae))return![];if(!_0x5b6281)return![];if($gameTemp[_0x239783(0x61d)])return!![];if(BattleManager[_0x239783(0x208)]())return!![];const _0x40053d=this[_0x239783(0x4a8)](_0x2d30ae);for(const _0x11001f of _0x40053d){if(!this['meetsEquipRequirement'](_0x5b6281,_0x11001f))return![];}return!![];},DataManager[_0x709961(0x4a8)]=function(_0x34c65d){const _0xd582d=_0x709961;if(!_0x34c65d)return[];this[_0xd582d(0x43c)]=this[_0xd582d(0x43c)]||{};const _0x488faa=_0xd582d(0x47e)[_0xd582d(0x60c)](this[_0xd582d(0x67a)](_0x34c65d)?_0xd582d(0x6d7):_0xd582d(0x5c2),_0x34c65d['id']);if(this[_0xd582d(0x43c)][_0x488faa]!==undefined)return this[_0xd582d(0x43c)][_0x488faa];let _0x5dc9ea=[];const _0x26fc2f=_0x34c65d[_0xd582d(0x1e9)]||'';if(_0x26fc2f[_0xd582d(0x1ed)](/<EQUIP(?:|MENT)[ ]REQUIREMENT(?:|S)>\s*([\s\S]*)\s*<\/EQUIP(?:|MENT)[ ]REQUIREMENT(?:|S)>/i)){if('bPMjt'==='bPMjt')_0x5dc9ea=String(RegExp['$1'])[_0xd582d(0x617)](/[\r\n]+/);else{this[_0xd582d(0x661)]=!![];const _0x1c8cee=_0x1587c5['ItemsEquipsCore'][_0xd582d(0x510)][_0x451462][_0xd582d(0x376)](this,_0x384acc,_0x17baa0);return this[_0xd582d(0x661)]=![],_0x1c8cee;}}return this[_0xd582d(0x43c)][_0x488faa]=_0x5dc9ea,this[_0xd582d(0x43c)][_0x488faa];},DataManager[_0x709961(0x687)]=function(_0x3a2eb7,_0x539e16){const _0x49b920=_0x709961;if(_0x539e16['match'](/(?:LEVEL|LV|LVL)[ ](>|>=|===|<=|<)[ ](\d+)/i)){if(_0x49b920(0x345)!==_0x49b920(0x4ea)){const _0x4e19d5=String(RegExp['$1'])[_0x49b920(0x3c4)](),_0x4df5c1=Number(RegExp['$2']);switch(_0x4e19d5){case'>':return _0x3a2eb7[_0x49b920(0x468)]>_0x4df5c1;case'>=':return _0x3a2eb7[_0x49b920(0x468)]>=_0x4df5c1;case _0x49b920(0x408):return _0x3a2eb7[_0x49b920(0x468)]===_0x4df5c1;case'<=':return _0x3a2eb7['level']<=_0x4df5c1;case'<':return _0x3a2eb7[_0x49b920(0x468)]<_0x4df5c1;}return![];}else{const _0x32e235=_0x480e04['ItemsEquipsCore'][_0x49b920(0x6b0)][_0x49b920(0x281)]['LabelDamageMP'];return _0x32e235[_0x49b920(0x60c)](_0x229ce6['mp']);}}if(_0x539e16[_0x49b920(0x1ed)](/(MAXHP|MAXMP|MHP|MMP)[ ](>|>=|===|<=|<)[ ](\d+)/i)){const _0x2f58e1=String(RegExp['$1'])[_0x49b920(0x52f)]()[_0x49b920(0x3c4)](),_0x5c420e=String(RegExp['$2'])[_0x49b920(0x3c4)](),_0x117263=Number(RegExp['$3']);let _0x2e1dcd=0x0;if([_0x49b920(0x23e),_0x49b920(0x21c)][_0x49b920(0x3bb)](_0x2f58e1))_0x2e1dcd=0x1;const _0x1ac5d7=_0x3a2eb7[_0x49b920(0x5b4)][_0x2e1dcd]||0x0;switch(_0x5c420e){case'>':return _0x3a2eb7['paramBase'](_0x2e1dcd)+_0x1ac5d7>_0x117263;case'>=':return _0x3a2eb7['paramBase'](_0x2e1dcd)+_0x1ac5d7>=_0x117263;case _0x49b920(0x408):return _0x3a2eb7[_0x49b920(0x51d)](_0x2e1dcd)+_0x1ac5d7===_0x117263;case'<=':return _0x3a2eb7[_0x49b920(0x51d)](_0x2e1dcd)+_0x1ac5d7<=_0x117263;case'<':return _0x3a2eb7[_0x49b920(0x51d)](_0x2e1dcd)+_0x1ac5d7<_0x117263;}return![];}if(_0x539e16[_0x49b920(0x1ed)](/(ATK|DEF|MAT|MDF|AGI|LUK)[ ](>|>=|===|<=|<)[ ](\d+)/i)){if(_0x49b920(0x5f4)!==_0x49b920(0x5f4))_0x29e547=_0x49b920(0x49c)[_0x49b920(0x60c)](_0x449e1b['id']);else{const _0x4115f7=String(RegExp['$1'])[_0x49b920(0x52f)]()[_0x49b920(0x3c4)](),_0x540810=String(RegExp['$2'])[_0x49b920(0x3c4)](),_0x50fe43=Number(RegExp['$3']),_0x5de0b6=[_0x49b920(0x6be),_0x49b920(0x1db),_0x49b920(0x419),_0x49b920(0x3e2),'agi',_0x49b920(0x5ca)];let _0x25c007=_0x5de0b6[_0x49b920(0x532)](_0x4115f7)+0x2;if(_0x25c007<0x2)return![];const _0x50ca28=_0x3a2eb7[_0x49b920(0x5b4)][_0x25c007]||0x0;switch(_0x540810){case'>':return _0x3a2eb7['paramBase'](_0x25c007)+_0x50ca28>_0x50fe43;case'>=':return _0x3a2eb7[_0x49b920(0x51d)](_0x25c007)+_0x50ca28>=_0x50fe43;case'===':return _0x3a2eb7[_0x49b920(0x51d)](_0x25c007)+_0x50ca28===_0x50fe43;case'<=':return _0x3a2eb7[_0x49b920(0x51d)](_0x25c007)+_0x50ca28<=_0x50fe43;case'<':return _0x3a2eb7[_0x49b920(0x51d)](_0x25c007)+_0x50ca28<_0x50fe43;}return![];}}if(_0x539e16[_0x49b920(0x1ed)](/LEARNED SKILL:[ ](\d+)/i)){if(_0x49b920(0x4d1)!=='gYIex'){const _0x1fc1be=Number(RegExp['$1']);return _0x3a2eb7[_0x49b920(0x3f1)](_0x1fc1be);}else{_0x3a23df['isTriggered']()&&this[_0x49b920(0x382)](!![]);if(_0x5a45ec[_0x49b920(0x536)]())this[_0x49b920(0x3df)]();else _0x2c3754[_0x49b920(0x5ab)]()&&this['onTouchCancel']();}}else{if(_0x539e16[_0x49b920(0x1ed)](/LEARNED SKILL:[ ](.*)/i)){if(_0x49b920(0x3a6)==='DSNNR')return this[_0x49b920(0x2f9)]();else{const _0x244ed3=String(RegExp['$1']),_0x11020c=this['getSkillIdWithName'](_0x244ed3);return _0x3a2eb7[_0x49b920(0x3f1)](_0x11020c);}}}if(_0x539e16[_0x49b920(0x1ed)](/SWITCH:[ ](\d+)/i)){if(_0x49b920(0x330)!==_0x49b920(0x330)){const _0x29fe67=_0x59b3f6[_0x49b920(0x3db)][_0x49b920(0x6b0)][_0x49b920(0x281)][_0x49b920(0x54a)];return _0x29fe67[_0x49b920(0x60c)](_0x9561f['mp']);}else{const _0xe0ea18=Number(RegExp['$1']);return $gameSwitches[_0x49b920(0x337)](_0xe0ea18);}}return!![];},DataManager['getEtypeIDs']=function(_0x547440){const _0x58b1f8=_0x709961;return this['isArmor'](_0x547440)?this['getEtypeIDsCache'](_0x547440):[_0x547440[_0x58b1f8(0x5fe)]||0x0];},DataManager[_0x709961(0x240)]=function(_0x2a2a78){const _0x2bea02=_0x709961;this[_0x2bea02(0x28b)]=this[_0x2bea02(0x28b)]||{};if(this['_cache_etypeIDs'][_0x2a2a78['id']]!==undefined)return this[_0x2bea02(0x28b)][_0x2a2a78['id']];this[_0x2bea02(0x28b)][_0x2a2a78['id']]=[_0x2a2a78[_0x2bea02(0x5fe)]||0x0];const _0x1f73fe=_0x2a2a78[_0x2bea02(0x1e9)]||'';if(_0x1f73fe[_0x2bea02(0x1ed)](/<ADDED ETYPE(?:|S):[ ](.*)>/i)){const _0x32f190=String(RegExp['$1'])[_0x2bea02(0x617)](',')[_0x2bea02(0x1ac)](_0xa1b9d6=>_0xa1b9d6[_0x2bea02(0x3c4)]());for(const _0x447b99 of _0x32f190){if(_0x2bea02(0x1ba)==='yzvjn'){const _0x49fb12=/^\d+$/[_0x2bea02(0x566)](_0x447b99);let _0x2c1304=0x0;if(_0x49fb12){if(_0x2bea02(0x511)===_0x2bea02(0x511))_0x2c1304=Number(_0x447b99);else return this[_0x2bea02(0x289)]()?this[_0x2bea02(0x3ce)]():_0x6a14c1[_0x2bea02(0x3db)][_0x2bea02(0x6b0)][_0x2bea02(0x309)][_0x2bea02(0x396)][_0x2bea02(0x376)](this);}else{if('XeIWa'!==_0x2bea02(0x4f3))_0x2c1304=this['getEtypeIdWithName'](_0x447b99);else return _0x758650['ItemsEquipsCore'][_0x2bea02(0x1b5)][_0x2bea02(0x376)](this);}_0x2c1304>0x1&&this['_cache_etypeIDs'][_0x2a2a78['id']][_0x2bea02(0x4ba)](_0x2c1304);}else return this[_0x2bea02(0x42e)]();}}return this[_0x2bea02(0x28b)][_0x2a2a78['id']];},Game_BattlerBase[_0x709961(0x5ef)]['canEquipArmor']=function(_0xaddbbf){const _0x144b6f=_0x709961;return this[_0x144b6f(0x4de)](_0xaddbbf[_0x144b6f(0x3e1)])&&!this[_0x144b6f(0x576)](_0xaddbbf[_0x144b6f(0x5fe)])&&DataManager['getEtypeIDs'](_0xaddbbf)[_0x144b6f(0x328)](_0x566015=>!this[_0x144b6f(0x576)](_0x566015));},DataManager[_0x709961(0x45e)]=function(_0x876f32){const _0xc080bd=_0x709961;if(!this['isWeapon'](_0x876f32)&&!this[_0xc080bd(0x3b3)](_0x876f32))return![];if(Imported[_0xc080bd(0x26b)]&&this[_0xc080bd(0x67a)](_0x876f32)){if(_0xc080bd(0x5a1)===_0xc080bd(0x36a)){if(this[_0xc080bd(0x289)]())return this[_0xc080bd(0x61a)]();else{const _0x2a34da=_0x2c0686['ItemsEquipsCore'][_0xc080bd(0x1e5)][_0xc080bd(0x376)](this);return this[_0xc080bd(0x34f)]()&&this[_0xc080bd(0x260)]()&&(_0x2a34da['width']-=this[_0xc080bd(0x62f)]()),_0x2a34da;}}else return![];}if(!_0x876f32[_0xc080bd(0x1e9)])return![];return _0x876f32[_0xc080bd(0x1e9)]['match'](/<CURSED>/i);},DataManager[_0x709961(0x57a)]=function(_0x382ff6){const _0x291e01=_0x709961;if(!_0x382ff6)return _0x382ff6;if(!this[_0x291e01(0x67a)](_0x382ff6)&&!this[_0x291e01(0x3b3)](_0x382ff6))return _0x382ff6;if(_0x382ff6[_0x291e01(0x1e9)][_0x291e01(0x1ed)](/<PURIFY TRANSFORM:[ ](.*)>/i)){const _0x42c257=String(RegExp['$1'])[_0x291e01(0x3c4)](),_0x159f09=/^\d+$/[_0x291e01(0x566)](_0x42c257);if(_0x159f09){if(this['isWeapon'](_0x382ff6))return $dataWeapons[Number(_0x42c257)];if(this[_0x291e01(0x3b3)](_0x382ff6))return $dataArmors[Number(_0x42c257)];}else{if(_0x291e01(0x455)===_0x291e01(0x329))_0x2df2b6['log'](_0x291e01(0x6cd)[_0x291e01(0x60c)](this[_0x291e01(0x3c2)]['name'])),_0x47cc2b[_0x291e01(0x4df)](_0x180114);else{if(this[_0x291e01(0x67a)](_0x382ff6))return $dataWeapons[this['getWeaponIdWithName'](_0x42c257)];if(this[_0x291e01(0x3b3)](_0x382ff6))return $dataArmors[this[_0x291e01(0x3c5)](_0x42c257)];}}}return _0x382ff6;},Game_Party[_0x709961(0x5ef)][_0x709961(0x550)]=function(){const _0x2c857c=_0x709961,_0xb3239e=this['allMembers']();for(const _0x2fa26c of _0xb3239e){if('AGSpj'==='EfweK')_0x257b30=_0x2c857c(0x598);else{if(!_0x2fa26c)continue;_0x2fa26c[_0x2c857c(0x550)]();}}},Game_Actor[_0x709961(0x5ef)]['purifyCursedEquips']=function(){const _0x3c2d4c=_0x709961,_0x3ba566=this[_0x3c2d4c(0x252)]()[_0x3c2d4c(0x321)];for(let _0x12cd45=0x0;_0x12cd45<_0x3ba566;_0x12cd45++){const _0x2469ca=this[_0x3c2d4c(0x5fd)][_0x12cd45];if(!_0x2469ca)continue;const _0x2fddc5=_0x2469ca[_0x3c2d4c(0x2c6)]();if(!DataManager['isCursedItem'](_0x2fddc5))continue;let _0x5dddee=DataManager[_0x3c2d4c(0x57a)](_0x2fddc5);this['isPurifyItemSwapOk'](_0x2fddc5,_0x5dddee)?(this[_0x3c2d4c(0x5fd)][_0x12cd45]['setObject'](_0x5dddee),this[_0x3c2d4c(0x349)]()):this[_0x3c2d4c(0x274)](_0x12cd45,null);}},Game_Actor[_0x709961(0x5ef)][_0x709961(0x257)]=function(_0x1dbc0f,_0x5a9240){const _0x56ab9a=_0x709961;if(_0x1dbc0f===_0x5a9240)return![];const _0x3189d0=DataManager[_0x56ab9a(0x323)](_0x5a9240);if(!_0x3189d0[_0x56ab9a(0x3bb)](_0x1dbc0f[_0x56ab9a(0x5fe)]))return![];if(DataManager['isWeapon'](_0x5a9240)){if(_0x56ab9a(0x393)!==_0x56ab9a(0x393))this[_0x56ab9a(0x649)](_0x3fe361[_0x56ab9a(0x5c1)]('up'));else return this[_0x56ab9a(0x237)](_0x5a9240[_0x56ab9a(0x4f2)]);}else{if(DataManager[_0x56ab9a(0x3b3)](_0x5a9240)){if(_0x56ab9a(0x472)!==_0x56ab9a(0x472)){const _0x4e912f=_0x56ab9a(0x29c);if(this['_customItemInfo'][_0x4e912f])return this[_0x56ab9a(0x3b8)][_0x4e912f];const _0x25977e=_0x56ab9a(0x6c6);return _0x25977e[_0x56ab9a(0x60c)](this['_item'][_0x56ab9a(0x643)]);}else return this[_0x56ab9a(0x4de)](_0x5a9240['atypeId']);}}return![];},TextManager[_0x709961(0x5e9)]={'helpDesc':{'equip':VisuMZ[_0x709961(0x3db)][_0x709961(0x6b0)][_0x709961(0x6b4)][_0x709961(0x5a5)]??_0x709961(0x324),'optimize':VisuMZ[_0x709961(0x3db)][_0x709961(0x6b0)][_0x709961(0x6b4)][_0x709961(0x219)]??_0x709961(0x44b),'clear':VisuMZ[_0x709961(0x3db)][_0x709961(0x6b0)][_0x709961(0x6b4)][_0x709961(0x5a0)]??_0x709961(0x2b9)}},ColorManager[_0x709961(0x2c5)]=function(_0x20ec24){const _0x2ba884=_0x709961;if(!_0x20ec24)return this[_0x2ba884(0x5ee)]();else{if(_0x20ec24[_0x2ba884(0x1e9)]['match'](/<COLOR:[ ](\d+)>/i))return this['textColor'](Number(RegExp['$1'])['clamp'](0x0,0x1f));else return _0x20ec24[_0x2ba884(0x1e9)][_0x2ba884(0x1ed)](/<COLOR:[ ]#(.*)>/i)?'#'+String(RegExp['$1']):this[_0x2ba884(0x5ee)]();}},ColorManager['getColor']=function(_0x37c012){const _0x3234df=_0x709961;return _0x37c012=String(_0x37c012),_0x37c012[_0x3234df(0x1ed)](/#(.*)/i)?_0x3234df(0x19f)[_0x3234df(0x60c)](String(RegExp['$1'])):this['textColor'](Number(_0x37c012));},SceneManager[_0x709961(0x62a)]=function(){const _0x5f2c1f=_0x709961;return this[_0x5f2c1f(0x6c1)]&&this['_scene'][_0x5f2c1f(0x3f7)]===Scene_Shop;},Game_Temp[_0x709961(0x5ef)][_0x709961(0x243)]=function(){const _0xeec563=_0x709961;if(this[_0xeec563(0x262)])return![];return VisuMZ[_0xeec563(0x3db)][_0xeec563(0x6b0)]['New'][_0xeec563(0x54b)];},VisuMZ[_0x709961(0x26e)]=VisuMZ['ItemsEquipsCore'][_0x709961(0x6b0)][_0x709961(0x281)][_0x709961(0x3b0)],VisuMZ[_0x709961(0x3db)][_0x709961(0x225)]=Game_BattlerBase['prototype'][_0x709961(0x307)],Game_BattlerBase[_0x709961(0x5ef)][_0x709961(0x307)]=function(_0x3c607d){const _0x2d93ad=_0x709961;return this['_shopStatusMenuMode']?this['_shopStatusMenuAlly']?VisuMZ[_0x2d93ad(0x26e)]:0x1:VisuMZ[_0x2d93ad(0x3db)]['Game_BattlerBase_param'][_0x2d93ad(0x376)](this,_0x3c607d);},VisuMZ['ItemsEquipsCore'][_0x709961(0x490)]=Game_BattlerBase['prototype']['meetsItemConditions'],Game_BattlerBase[_0x709961(0x5ef)][_0x709961(0x5a6)]=function(_0x1fc3bc){const _0x53089c=_0x709961;if(!_0x1fc3bc)return![];if(!VisuMZ[_0x53089c(0x3db)][_0x53089c(0x490)][_0x53089c(0x376)](this,_0x1fc3bc))return![];if(!this[_0x53089c(0x60d)](_0x1fc3bc))return![];if(!this[_0x53089c(0x3e9)](_0x1fc3bc))return![];return!![];},Game_BattlerBase[_0x709961(0x5ef)][_0x709961(0x60d)]=function(_0x338c07){const _0x438c7d=_0x709961;if(!this[_0x438c7d(0x47f)](_0x338c07))return![];return!![];},Game_BattlerBase[_0x709961(0x5ef)][_0x709961(0x47f)]=function(_0xb2ccd3){const _0x2c6884=_0x709961,_0xbe7548=_0xb2ccd3[_0x2c6884(0x1e9)];if(_0xbe7548[_0x2c6884(0x1ed)](/<ENABLE[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if(_0x2c6884(0x693)!==_0x2c6884(0x1ab)){const _0x5d1686=JSON['parse']('['+RegExp['$1'][_0x2c6884(0x1ed)](/\d+/g)+']');for(const _0x5509a5 of _0x5d1686){if(!$gameSwitches[_0x2c6884(0x337)](_0x5509a5))return![];}return!![];}else{if(!this[_0x2c6884(0x342)])return!![];return this[_0x2c6884(0x342)][_0x2c6884(0x385)]()!==_0x5a0c0d[_0x2c6884(0x385)]();}}if(_0xbe7548[_0x2c6884(0x1ed)](/<ENABLE ALL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if('Fxsjx'==='kBsQd'){const _0x2d83b3=this[_0x2c6884(0x4d9)](_0x3c8a48);if(_0x2d83b3<0x0)return;const _0x88181d=_0x47cd9e===0x1?_0x18a51a[_0xb6aab0]:_0x37a1e0[_0x51365f];this['changeEquip'](_0x2d83b3,_0x88181d);}else{const _0x29ae08=JSON[_0x2c6884(0x692)]('['+RegExp['$1']['match'](/\d+/g)+']');for(const _0x5583f5 of _0x29ae08){if('lSjkq'!==_0x2c6884(0x4c4))_0x2c0998=_0x117b90(_0x3ebd03['$1']),_0x10fa90=_0xe90ad3(_0x9369b9['$2']);else{if(!$gameSwitches[_0x2c6884(0x337)](_0x5583f5))return![];}}return!![];}}if(_0xbe7548[_0x2c6884(0x1ed)](/<ENABLE ANY[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x54d4ac=JSON[_0x2c6884(0x692)]('['+RegExp['$1'][_0x2c6884(0x1ed)](/\d+/g)+']');for(const _0x55e6ad of _0x54d4ac){if($gameSwitches['value'](_0x55e6ad))return!![];}return![];}if(_0xbe7548[_0x2c6884(0x1ed)](/<DISABLE[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0xae3d26=JSON['parse']('['+RegExp['$1'][_0x2c6884(0x1ed)](/\d+/g)+']');for(const _0x361d7e of _0xae3d26){if('kcIsm'!==_0x2c6884(0x595)){if(!$gameSwitches[_0x2c6884(0x337)](_0x361d7e))return!![];}else{const _0x555043=_0xbd6322[_0x2c6884(0x3db)][_0x2c6884(0x6b0)][_0x2c6884(0x36c)],_0x371b20=_0x555043[_0x2c6884(0x495)];if(_0x371b20==='')return;const _0x2c2a8d=_0x8ea2d8[_0x2c6884(0x357)],_0x457e40=_0x39a857[_0x2c6884(0x2ea)];this[_0x2c6884(0x41c)]['fontFace']=_0x555043[_0x2c6884(0x5d5)]||_0x3c54d1[_0x2c6884(0x63d)](),this[_0x2c6884(0x41c)][_0x2c6884(0x637)]=this[_0x2c6884(0x696)](),this[_0x2c6884(0x41c)][_0x2c6884(0x416)]=_0x555043[_0x2c6884(0x229)],this[_0x2c6884(0x41c)]['drawText'](_0x371b20,0x0,_0x457e40/0x2,_0x2c2a8d,_0x457e40/0x2,'center');}}return![];}if(_0xbe7548[_0x2c6884(0x1ed)](/<DISABLE ALL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x474b3f=JSON[_0x2c6884(0x692)]('['+RegExp['$1'][_0x2c6884(0x1ed)](/\d+/g)+']');for(const _0x7eca66 of _0x474b3f){if(!$gameSwitches['value'](_0x7eca66))return!![];}return![];}if(_0xbe7548[_0x2c6884(0x1ed)](/<DISABLE ANY[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x94f5ac=JSON[_0x2c6884(0x692)]('['+RegExp['$1'][_0x2c6884(0x1ed)](/\d+/g)+']');for(const _0x3893d7 of _0x94f5ac){if(_0x2c6884(0x204)!==_0x2c6884(0x204)){if(_0x232805[_0x2c6884(0x327)])return _0x340cf6[_0x2c6884(0x3db)][_0x2c6884(0x295)][_0x2c6884(0x376)](this);return _0xe39578['getProxyItem'](_0x5debdb['ItemsEquipsCore'][_0x2c6884(0x295)]['call'](this));}else{if($gameSwitches[_0x2c6884(0x337)](_0x3893d7))return![];}}return!![];}return!![];},Game_BattlerBase[_0x709961(0x5ef)]['meetsItemConditionsJS']=function(_0x378a50){const _0x2fb6be=_0x709961,_0x54defa=_0x378a50[_0x2fb6be(0x1e9)],_0x532a94=VisuMZ[_0x2fb6be(0x3db)][_0x2fb6be(0x52b)];if(_0x532a94[_0x378a50['id']]){if(_0x2fb6be(0x368)!=='NjiAu')return _0x532a94[_0x378a50['id']][_0x2fb6be(0x376)](this,_0x378a50);else this[_0x2fb6be(0x2c2)](_0x3056ce,_0x4e1f57,_0x1ff14a,_0x89274f,!![]),this[_0x2fb6be(0x2c2)](_0x39f5e4,_0x4dc95f,_0xcb8787,_0x4a16fc,![],_0x2fb6be(0x4b9)),this['drawItemDarkRect'](_0x1bd76b,_0x50e864,_0x1e9802),this[_0x2fb6be(0x4e3)]();}else{if(_0x2fb6be(0x4a2)===_0x2fb6be(0x4a2))return!![];else{const _0x29e5bc=_0xb8699d(_0x189500['$1'])||0x1;if(_0x8f4b89>=_0x29e5bc)return!![];}}},Game_Actor[_0x709961(0x5ef)][_0x709961(0x6a0)]=function(_0x4167b7){const _0x489b9e=_0x709961;_0x4167b7=this[_0x489b9e(0x3b7)](_0x4167b7);const _0x2f2ffb=this['equipSlots']();this['_equips']=[];for(let _0x4fe78f=0x0;_0x4fe78f<_0x2f2ffb[_0x489b9e(0x321)];_0x4fe78f++){this['_equips'][_0x4fe78f]=new Game_Item();}for(let _0x5382cb=0x0;_0x5382cb<_0x2f2ffb['length'];_0x5382cb++){const _0x2b9e27=_0x2f2ffb[_0x5382cb],_0x1b6ee0=this[_0x489b9e(0x563)](_0x4167b7,_0x2b9e27);if(this[_0x489b9e(0x447)](_0x1b6ee0))this[_0x489b9e(0x5fd)][_0x5382cb][_0x489b9e(0x299)](_0x1b6ee0);}this['releaseUnequippableItems'](!![]),this[_0x489b9e(0x349)]();},Game_Actor[_0x709961(0x5ef)]['convertInitEquipsToItems']=function(_0x2828f0){const _0x286b56=_0x709961,_0x3a2b2e=[];for(let _0x3c277a=0x0;_0x3c277a<_0x2828f0[_0x286b56(0x321)];_0x3c277a++){const _0x27159d=_0x2828f0[_0x3c277a];if(_0x27159d<=0x0)continue;const _0x2f1f1b=$dataSystem['equipTypes'][_0x3c277a+0x1];if(_0x2f1f1b===$dataSystem['equipTypes'][0x1]||_0x3c277a===0x1&&this[_0x286b56(0x4fc)]())_0x3a2b2e[_0x286b56(0x4ba)]($dataWeapons[_0x27159d]);else{if(BattleManager['isBattleTest']()){const _0x4400a4=$dataArmors[_0x27159d];_0x4400a4&&_0x4400a4[_0x286b56(0x5fe)]===_0x3c277a+0x1&&_0x3a2b2e[_0x286b56(0x4ba)](_0x4400a4);}else{const _0x160784=$dataArmors[_0x27159d];if(_0x160784&&_0x160784[_0x286b56(0x5fe)]===_0x3c277a+0x1){if(_0x286b56(0x6a6)===_0x286b56(0x6a6))_0x3a2b2e[_0x286b56(0x4ba)](_0x160784);else{const _0x42cc05=_0xaa178d(_0x210fde['$1'])[_0x286b56(0x617)](',')[_0x286b56(0x1ac)](_0x456282=>_0x456282['trim']());for(const _0x2543b8 of _0x42cc05){const _0x47af2c=/^\d+$/['test'](_0x2543b8);_0x47af2c?_0x5c27c1[_0x286b56(0x4ba)](_0x296c3f(_0x2543b8)):_0x5c95d2[_0x286b56(0x4ba)](_0x5ad780[_0x286b56(0x508)](_0x2543b8));}}}}}}return _0x3a2b2e;},Game_Actor[_0x709961(0x5ef)]['getMatchingInitEquip']=function(_0x3367e9,_0x4c46bb){const _0x2f17cb=_0x709961;for(const _0x2cd9b5 of _0x3367e9){if(!_0x2cd9b5)continue;if(_0x2cd9b5[_0x2f17cb(0x5fe)]===_0x4c46bb)return _0x3367e9[_0x2f17cb(0x43d)](_0x3367e9[_0x2f17cb(0x532)](_0x2cd9b5),0x1),_0x2cd9b5;}return null;},Game_Actor['prototype'][_0x709961(0x252)]=function(){const _0x51e90c=_0x709961,_0x95d10=VisuMZ[_0x51e90c(0x3db)][_0x51e90c(0x40e)](this[_0x51e90c(0x616)]||this[_0x51e90c(0x6d4)]()[_0x51e90c(0x252)]);if(_0x95d10[_0x51e90c(0x321)]>=0x2&&this[_0x51e90c(0x4fc)]())_0x95d10[0x1]=0x1;return _0x95d10;},Game_Actor[_0x709961(0x5ef)][_0x709961(0x520)]=function(_0x479292){const _0x23f4fc=_0x709961;_0x479292['remove'](0x0),_0x479292[_0x23f4fc(0x34e)](-0x1),this[_0x23f4fc(0x616)]=_0x479292,this['refresh'](),this[_0x23f4fc(0x5a4)]();},Game_Actor[_0x709961(0x5ef)][_0x709961(0x334)]=function(){const _0x540ed0=_0x709961;this['_forcedSlots']=undefined,this[_0x540ed0(0x349)](),this[_0x540ed0(0x5a4)]();},Game_Actor[_0x709961(0x5ef)]['updateChangedSlots']=function(){const _0x4f0995=_0x709961;let _0x17d11f=this[_0x4f0995(0x252)]()[_0x4f0995(0x321)];while(this['_equips']['length']>_0x17d11f){if(_0x4f0995(0x1e2)===_0x4f0995(0x1e2)){const _0x1fabb8=this['_equips'][this[_0x4f0995(0x5fd)]['length']-0x1];_0x1fabb8&&_0x1fabb8[_0x4f0995(0x2c6)]()&&$gameParty[_0x4f0995(0x2a5)](_0x1fabb8[_0x4f0995(0x2c6)](),0x1),this[_0x4f0995(0x5fd)][_0x4f0995(0x21b)]();}else return this[_0x4f0995(0x1a6)]&&this[_0x4f0995(0x1a6)][_0x4f0995(0x6d8)]();}while(_0x17d11f>this['_equips'][_0x4f0995(0x321)]){this[_0x4f0995(0x5fd)][_0x4f0995(0x4ba)](new Game_Item());}},Game_Actor[_0x709961(0x5ef)][_0x709961(0x366)]=function(){const _0x421b29=_0x709961,_0x177aa0=this[_0x421b29(0x252)]();for(let _0x365743=0x0;_0x365743<_0x177aa0[_0x421b29(0x321)];_0x365743++){if(_0x421b29(0x2e5)===_0x421b29(0x2e5)){if(!this[_0x421b29(0x5fd)][_0x365743])this['_equips'][_0x365743]=new Game_Item();}else _0x3adb1b[_0x421b29(0x5ef)][_0x421b29(0x522)][_0x421b29(0x376)](this,_0x4c7806,_0x306276,_0x2d1a19,_0x12695a);}this['releaseUnequippableItems'](![]),this[_0x421b29(0x349)]();},VisuMZ[_0x709961(0x3db)][_0x709961(0x26f)]=Game_Actor['prototype'][_0x709961(0x274)],Game_Actor[_0x709961(0x5ef)]['changeEquip']=function(_0x1471aa,_0x5070de){const _0x5323fe=_0x709961;if(!this[_0x5323fe(0x342)]){const _0x54ddf6=JsonEx[_0x5323fe(0x340)](this);_0x54ddf6[_0x5323fe(0x342)]=!![],this[_0x5323fe(0x1d5)](_0x1471aa,_0x5070de),this[_0x5323fe(0x267)](_0x54ddf6);}else this[_0x5323fe(0x1d5)](_0x1471aa,_0x5070de);},Game_Actor[_0x709961(0x5ef)]['changeEquipBase']=function(_0x2780aa,_0x34cfd2){const _0x587c57=_0x709961;if(!this[_0x587c57(0x3af)](_0x34cfd2,this[_0x587c57(0x673)]()[_0x2780aa]))return;if(_0x34cfd2){if(_0x587c57(0x622)===_0x587c57(0x622)){const _0x43e5ad=DataManager[_0x587c57(0x323)](_0x34cfd2);if(!_0x43e5ad['includes'](this['equipSlots']()[_0x2780aa]))return;}else _0x1aeb1a[_0x587c57(0x3db)][_0x587c57(0x1f6)]['call'](this),this[_0x587c57(0x6d8)]()&&this[_0x587c57(0x38e)]();}this['_equips'][_0x2780aa]['setObject'](_0x34cfd2);if(VisuMZ[_0x587c57(0x3db)][_0x587c57(0x546)](_0x34cfd2)){const _0xa823c2=VisuMZ['ItemsEquipsCore'][_0x587c57(0x6b0)]['EquipScene']['CursedTextPopup']||'',_0x4fa777=this[_0x587c57(0x5a7)](),_0x13c641=_0x587c57(0x3d2)[_0x587c57(0x60c)](_0x34cfd2[_0x587c57(0x4a7)]),_0x283bbb=_0x34cfd2[_0x587c57(0x5a7)]||'';let _0x1e34fd=_0xa823c2[_0x587c57(0x60c)](_0x4fa777,_0x13c641,_0x283bbb);if(_0x1e34fd[_0x587c57(0x321)]>0x0)$textPopup(_0x1e34fd);}this[_0x587c57(0x349)]();},VisuMZ[_0x709961(0x3db)]['CheckCursedItemMsg']=function(_0x173f4d){const _0x41b064=_0x709961;if(!_0x173f4d)return![];if(!Imported[_0x41b064(0x615)])return![];if(!$textPopup)return;return DataManager['isCursedItem'](_0x173f4d);},VisuMZ[_0x709961(0x3db)][_0x709961(0x35d)]=Game_Actor[_0x709961(0x5ef)]['forceChangeEquip'],Game_Actor['prototype']['forceChangeEquip']=function(_0x11d86b,_0x1c8493){const _0x1ba794=_0x709961;if(!this[_0x1ba794(0x342)]){if('NldCE'!==_0x1ba794(0x3a1))this[_0x1ba794(0x25a)](_0x44fcca,_0x2271dc['x'],_0x3d7677['y']+0x2);else{const _0x1e2a9c=JsonEx['makeDeepCopy'](this);_0x1e2a9c[_0x1ba794(0x342)]=!![],VisuMZ[_0x1ba794(0x3db)][_0x1ba794(0x35d)][_0x1ba794(0x376)](this,_0x11d86b,_0x1c8493),this['equipAdjustHpMp'](_0x1e2a9c);}}else VisuMZ[_0x1ba794(0x3db)][_0x1ba794(0x35d)]['call'](this,_0x11d86b,_0x1c8493);},VisuMZ[_0x709961(0x3db)]['Game_Actor_discardEquip']=Game_Actor[_0x709961(0x5ef)][_0x709961(0x36b)],Game_Actor[_0x709961(0x5ef)][_0x709961(0x36b)]=function(_0x2cd137){const _0x16e972=_0x709961;if(!this[_0x16e972(0x342)]){if('LsCKQ'!==_0x16e972(0x32f)){const _0x3c3064=JsonEx[_0x16e972(0x340)](this);_0x3c3064[_0x16e972(0x342)]=!![],VisuMZ[_0x16e972(0x3db)][_0x16e972(0x6ae)][_0x16e972(0x376)](this,_0x2cd137),this[_0x16e972(0x267)](_0x3c3064);}else{const _0x7964dd=_0x5c1f05?_0x3772bc(_0xbb7d1c):_0x5a1099['getItemIdWithName'](_0x4b1985);return _0x5b40f0[_0x7964dd]||_0x2a633b;}}else VisuMZ[_0x16e972(0x3db)][_0x16e972(0x6ae)][_0x16e972(0x376)](this,_0x2cd137);},Game_Actor[_0x709961(0x5ef)][_0x709961(0x55b)]=function(_0xdb0417){const _0x716e0c=_0x709961;if(this['_bypassReleaseUnequippableItemsItemsEquipsCore'])return;let _0x10c9eb=0x0;for(;;){_0x10c9eb++;if(_0x10c9eb>0x3)break;const _0x4948f1=this[_0x716e0c(0x252)](),_0xa66530=this[_0x716e0c(0x673)](),_0x2d25a4=_0xa66530[_0x716e0c(0x321)];let _0x4d6584=![];for(let _0x1f8320=0x0;_0x1f8320<_0x2d25a4;_0x1f8320++){if(_0x716e0c(0x37f)!==_0x716e0c(0x37f))_0x36d7e2[_0x716e0c(0x5ef)][_0x716e0c(0x2ef)]['call'](this);else{const _0x134909=_0xa66530[_0x1f8320];if(!_0x134909)continue;const _0x4bda2e=DataManager['getEtypeIDs'](_0x134909);if(!this[_0x716e0c(0x447)](_0x134909)||!_0x4bda2e['includes'](_0x4948f1[_0x1f8320])){!_0xdb0417&&this[_0x716e0c(0x3af)](null,_0x134909);if(!this[_0x716e0c(0x342)]){if(_0x716e0c(0x399)==='FwiMr')this[_0x716e0c(0x5fd)][_0x1c8604][_0x716e0c(0x299)](null);else{const _0x24c566=JsonEx[_0x716e0c(0x340)](this);_0x24c566['_tempActor']=!![],this['_equips'][_0x1f8320][_0x716e0c(0x299)](null),this[_0x716e0c(0x2d1)]=!![],this[_0x716e0c(0x267)](_0x24c566),this[_0x716e0c(0x2d1)]=undefined;}}else{if(this[_0x716e0c(0x5fd)][_0x1f8320]){if(_0x716e0c(0x261)===_0x716e0c(0x261))this[_0x716e0c(0x5fd)][_0x1f8320][_0x716e0c(0x299)](null);else{const _0x5220af=_0x716e0c(0x4fd)['format'](_0x1f8633);_0x408ad4[_0x716e0c(0x3db)]['RegExp'][_0x716e0c(0x679)][_0x716e0c(0x4ba)](new _0x1e9e2e(_0x5220af,'i'));const _0x26080e=_0x716e0c(0x564)['format'](_0x5a415d);_0x7024c[_0x716e0c(0x3db)][_0x716e0c(0x34a)][_0x716e0c(0x41e)][_0x716e0c(0x4ba)](new _0x5e53fa(_0x26080e,'g'));}}else continue;}_0x4d6584=!![];}}}if(!_0x4d6584){if('yfmKg'===_0x716e0c(0x477))break;else{if(_0x8d610b!==_0x43226b)return;if(_0x7320eb[_0x716e0c(0x1e9)][_0x716e0c(0x1ed)](/<JS ITEM ENABLE>\s*([\s\S]*)\s*<\/JS ITEM ENABLE>/i)){const _0x1ae7f2=_0x48abbd(_0x1c7e43['$1']),_0x26dfa5=_0x716e0c(0x64d)[_0x716e0c(0x60c)](_0x1ae7f2);_0x58756f[_0x716e0c(0x3db)][_0x716e0c(0x52b)][_0x26bc6e['id']]=new _0x1fb3a0('item',_0x26dfa5);}}}}},Game_Actor['prototype'][_0x709961(0x267)]=function(_0x3f9e1a){const _0x41a1d4=_0x709961;if(this[_0x41a1d4(0x342)])return;if(!VisuMZ[_0x41a1d4(0x3db)]['Settings'][_0x41a1d4(0x6b4)]['EquipAdjustHpMp'])return;const _0x4dadbd=Math['round'](_0x3f9e1a[_0x41a1d4(0x4a4)]()*this['mhp']),_0x388026=Math[_0x41a1d4(0x284)](_0x3f9e1a[_0x41a1d4(0x2cf)]()*this[_0x41a1d4(0x21c)]);if(this['hp']>0x0)this[_0x41a1d4(0x6e0)](_0x4dadbd);if(this['mp']>0x0)this['setMp'](_0x388026);},Game_Actor[_0x709961(0x5ef)][_0x709961(0x1f2)]=function(){const _0x2ac4c4=_0x709961,_0x1d5ee1=this[_0x2ac4c4(0x252)]()['length'];for(let _0x5bd577=0x0;_0x5bd577<_0x1d5ee1;_0x5bd577++){if(this['isClearEquipOk'](_0x5bd577))this[_0x2ac4c4(0x274)](_0x5bd577,null);}},Game_Actor['prototype'][_0x709961(0x202)]=function(_0x1ec67d){const _0x48fed=_0x709961;if(this[_0x48fed(0x290)]()[_0x48fed(0x3bb)](this[_0x48fed(0x252)]()[_0x1ec67d]))return![];else{if('HZcms'!=='GZlAc')return this['isEquipChangeOk'](_0x1ec67d);else{this[_0x48fed(0x30a)][_0x48fed(0x556)]();if(!this[_0x48fed(0x3bc)])return;if(this[_0x48fed(0x30e)]()){const _0x3a74df=_0x4bab0c[_0x48fed(0x401)](this[_0x48fed(0x3bc)][_0x48fed(0x1f1)]());_0x3a74df[_0x48fed(0x535)](this[_0x48fed(0x273)][_0x48fed(0x4b0)](this));}else this[_0x48fed(0x377)]();}}},Game_Actor['prototype']['nonRemovableEtypes']=function(){const _0xf73111=_0x709961;return VisuMZ[_0xf73111(0x3db)][_0xf73111(0x6b0)][_0xf73111(0x6b4)]['NonRemoveETypes'];},Game_Actor[_0x709961(0x5ef)][_0x709961(0x255)]=function(){const _0x18c4a8=_0x709961,_0x26dfd5=this[_0x18c4a8(0x252)]()[_0x18c4a8(0x321)];for(let _0x3439e1=0x0;_0x3439e1<_0x26dfd5;_0x3439e1++){if(_0x18c4a8(0x2c0)!==_0x18c4a8(0x689)){if(this['isOptimizeEquipOk'](_0x3439e1))this[_0x18c4a8(0x274)](_0x3439e1,null);}else return _0xfcfa9e[_0x18c4a8(0x3db)][_0x18c4a8(0x6b0)][_0x18c4a8(0x300)]['CmdHideDisabled'];}for(let _0x2b886d=0x0;_0x2b886d<_0x26dfd5;_0x2b886d++){if(this[_0x18c4a8(0x3c1)](_0x2b886d))this[_0x18c4a8(0x274)](_0x2b886d,this[_0x18c4a8(0x5a2)](_0x2b886d));}},Game_Actor[_0x709961(0x5ef)][_0x709961(0x5a2)]=function(_0x17f349){const _0x354686=_0x709961,_0x1462da=this[_0x354686(0x252)]()[_0x17f349],_0x831b9e=$gameParty[_0x354686(0x4cb)]()[_0x354686(0x672)](_0x1c55f8=>DataManager[_0x354686(0x323)](_0x1c55f8)['includes'](_0x1462da)&&this[_0x354686(0x447)](_0x1c55f8)&&!DataManager[_0x354686(0x45e)](_0x1c55f8));let _0x39515e=null,_0x314c3f=-0x3e8;for(let _0x5588b0=0x0;_0x5588b0<_0x831b9e[_0x354686(0x321)];_0x5588b0++){if(_0x354686(0x251)!==_0x354686(0x251))return _0x32c61b;else{const _0x249a44=this[_0x354686(0x51f)](_0x831b9e[_0x5588b0]);if(_0x249a44>_0x314c3f){if(_0x354686(0x5c6)!==_0x354686(0x5c6)){_0xa36325=_0x8e8449||this[_0x354686(0x361)](),this[_0x354686(0x30a)]['paintOpacity']=0xa0;const _0x1564a8=_0x28a9cb[_0x354686(0x6a7)]();this[_0x354686(0x30a)][_0x354686(0x68d)](_0x511e08+0x1,_0x1d307f+0x1,_0x3dfcb9-0x2,_0x1d46c8-0x2,_0x1564a8),this[_0x354686(0x30a)][_0x354686(0x32b)]=0xff;}else _0x314c3f=_0x249a44,_0x39515e=_0x831b9e[_0x5588b0];}}}return _0x39515e;},Game_Actor['prototype']['isOptimizeEquipOk']=function(_0x2d1754){const _0x347fe3=_0x709961;return this['nonOptimizeEtypes']()[_0x347fe3(0x3bb)](this[_0x347fe3(0x252)]()[_0x2d1754])?![]:this[_0x347fe3(0x698)](_0x2d1754);},VisuMZ[_0x709961(0x3db)][_0x709961(0x6d0)]=Game_Actor[_0x709961(0x5ef)]['isEquipChangeOk'],Game_Actor['prototype'][_0x709961(0x698)]=function(_0x2d02ce){const _0x523a6c=_0x709961,_0x2c0f6c=this[_0x523a6c(0x5fd)][_0x2d02ce];if(_0x2c0f6c){if(_0x523a6c(0x525)!=='PRXze')return this[_0x523a6c(0x240)](_0x18609c);else{const _0x5ba00b=_0x2c0f6c[_0x523a6c(0x2c6)]();if(DataManager[_0x523a6c(0x45e)](_0x5ba00b))return![];}}return VisuMZ[_0x523a6c(0x3db)][_0x523a6c(0x6d0)]['call'](this,_0x2d02ce);},Game_Actor['prototype'][_0x709961(0x442)]=function(){const _0x50a0b2=_0x709961;return VisuMZ[_0x50a0b2(0x3db)][_0x50a0b2(0x6b0)][_0x50a0b2(0x6b4)]['NonOptimizeETypes'];},VisuMZ[_0x709961(0x3db)][_0x709961(0x235)]=Game_Actor['prototype'][_0x709961(0x3af)],Game_Actor[_0x709961(0x5ef)][_0x709961(0x3af)]=function(_0x313134,_0x4a2721){const _0x9adcb2=_0x709961;if(this['_tempActor'])return![];$gameTemp[_0x9adcb2(0x262)]=!![];const _0x2f2287=VisuMZ[_0x9adcb2(0x3db)][_0x9adcb2(0x235)][_0x9adcb2(0x376)](this,_0x313134,_0x4a2721);return $gameTemp[_0x9adcb2(0x262)]=![],_0x2f2287;},Game_Actor[_0x709961(0x5ef)][_0x709961(0x432)]=function(_0x15237e,_0x1dee7d){const _0x177299=_0x709961,_0x4749f8=this[_0x177299(0x4d9)](_0x15237e);if(_0x4749f8<0x0)return;const _0x24e64b=_0x15237e===0x1?$dataWeapons[_0x1dee7d]:$dataArmors[_0x1dee7d];this[_0x177299(0x274)](_0x4749f8,_0x24e64b);},Game_Actor[_0x709961(0x5ef)][_0x709961(0x4d9)]=function(_0x2e55ec){const _0x23bb3a=_0x709961;let _0x5666ca=0x0;const _0x4bb2a5=this['equipSlots'](),_0x469d0d=this[_0x23bb3a(0x673)]();for(let _0x50b03f=0x0;_0x50b03f<_0x4bb2a5['length'];_0x50b03f++){if(_0x4bb2a5[_0x50b03f]===_0x2e55ec){_0x5666ca=_0x50b03f;if(!_0x469d0d[_0x50b03f])return _0x5666ca;}}return _0x5666ca;},VisuMZ[_0x709961(0x3db)]['Game_Actor_paramPlus']=Game_Actor[_0x709961(0x5ef)]['paramPlus'],Game_Actor[_0x709961(0x5ef)][_0x709961(0x6e2)]=function(_0x44d174){const _0x32fbd8=_0x709961;let _0x51dc31=VisuMZ[_0x32fbd8(0x3db)][_0x32fbd8(0x638)][_0x32fbd8(0x376)](this,_0x44d174);for(const _0x178f93 of this[_0x32fbd8(0x673)]()){if(_0x178f93)_0x51dc31+=this[_0x32fbd8(0x23f)](_0x178f93,_0x44d174);}return _0x51dc31;},Game_Actor[_0x709961(0x5ef)][_0x709961(0x23f)]=function(_0xa53384,_0x2fe97e){const _0x500e24=_0x709961;if(this[_0x500e24(0x661)])return 0x0;const _0x1a538e=(DataManager[_0x500e24(0x67a)](_0xa53384)?'W%1':_0x500e24(0x473))[_0x500e24(0x60c)](_0xa53384['id']),_0xa91b91='%1-%2'[_0x500e24(0x60c)](_0x1a538e,_0x2fe97e);if(VisuMZ[_0x500e24(0x3db)][_0x500e24(0x510)][_0xa91b91]){this[_0x500e24(0x661)]=!![];const _0x480777=VisuMZ[_0x500e24(0x3db)]['paramJS'][_0xa91b91][_0x500e24(0x376)](this,_0xa53384,_0x2fe97e);return this[_0x500e24(0x661)]=![],_0x480777;}else{if(_0x500e24(0x43f)===_0x500e24(0x668))this[_0x500e24(0x5d0)](),_0x2a5ee4[_0x500e24(0x6c1)][_0x500e24(0x344)](),_0x552cac[_0x500e24(0x6c1)][_0x500e24(0x3f9)][_0x500e24(0x1de)](-0x1);else return 0x0;}},Game_Actor[_0x709961(0x5ef)][_0x709961(0x6a1)]=function(_0x2d4f31){const _0x5cd9ca=_0x709961;this[_0x5cd9ca(0x216)]=!![],this[_0x5cd9ca(0x551)]=_0x2d4f31;},VisuMZ['ItemsEquipsCore']['Game_Party_initialize']=Game_Party[_0x709961(0x5ef)][_0x709961(0x527)],Game_Party['prototype'][_0x709961(0x527)]=function(){const _0x398593=_0x709961;VisuMZ['ItemsEquipsCore'][_0x398593(0x5aa)]['call'](this),this['initNewItemsList'](),this[_0x398593(0x59b)]();},Game_Party[_0x709961(0x5ef)][_0x709961(0x414)]=function(){const _0x4c37b9=_0x709961;this[_0x4c37b9(0x3ed)]=[];},Game_Party[_0x709961(0x5ef)][_0x709961(0x572)]=function(_0x24dcee){const _0xeedb19=_0x709961;if(!$gameTemp[_0xeedb19(0x243)]())return![];if(this[_0xeedb19(0x3ed)]===undefined)this[_0xeedb19(0x414)]();let _0x5eee08='';if(DataManager[_0xeedb19(0x2f3)](_0x24dcee))'ZXzNH'===_0xeedb19(0x3cb)?this['cursorPageup']():_0x5eee08='item-%1'[_0xeedb19(0x60c)](_0x24dcee['id']);else{if(DataManager[_0xeedb19(0x67a)](_0x24dcee)){if(_0xeedb19(0x319)!==_0xeedb19(0x319)){if(!this[_0xeedb19(0x3fe)]())return;const _0x35f286=this[_0xeedb19(0x1be)](),_0x653e13=_0x3817c8[_0xeedb19(0x3db)][_0xeedb19(0x6b0)][_0xeedb19(0x6b4)][_0xeedb19(0x5bb)],_0xcf0793=_0x35f286===_0xeedb19(0x461)?_0x46dc49[_0xeedb19(0x49d)]:_0xeedb19(0x297)[_0xeedb19(0x60c)](_0x653e13,_0x5bbf97[_0xeedb19(0x49d)]),_0x2ff9da=this[_0xeedb19(0x201)]();this['addCommand'](_0xcf0793,'optimize',_0x2ff9da);}else _0x5eee08=_0xeedb19(0x49c)['format'](_0x24dcee['id']);}else{if(DataManager[_0xeedb19(0x3b3)](_0x24dcee)){if('vJmPz'!==_0xeedb19(0x39b)){if(_0x4b6d6f[_0xeedb19(0x38b)]())_0x321ae1[_0xeedb19(0x4df)](_0x491d24);}else _0x5eee08=_0xeedb19(0x269)[_0xeedb19(0x60c)](_0x24dcee['id']);}else return;}}return this[_0xeedb19(0x3ed)][_0xeedb19(0x3bb)](_0x5eee08);},Game_Party[_0x709961(0x5ef)]['setNewItem']=function(_0x5bf5c1){const _0x2ada46=_0x709961;if(!$gameTemp['newLabelEnabled']())return;if(this['_newItemsList']===undefined)this['initNewItemsList']();let _0x2bb510='';if(DataManager[_0x2ada46(0x2f3)](_0x5bf5c1)){if(_0x2ada46(0x5b9)===_0x2ada46(0x3b4))return this[_0x2ada46(0x568)]();else _0x2bb510='item-%1'[_0x2ada46(0x60c)](_0x5bf5c1['id']);}else{if(DataManager['isWeapon'](_0x5bf5c1))_0x2ada46(0x5bc)!=='CtVFD'?_0x215695+='%1'[_0x2ada46(0x60c)](this[_0x2ada46(0x6f3)]['selfTP']):_0x2bb510='weapon-%1'['format'](_0x5bf5c1['id']);else{if(DataManager['isArmor'](_0x5bf5c1))'LufjS'===_0x2ada46(0x5ba)?this['artifactIDs'][_0x2ada46(0x677)][_0x2ada46(0x4ba)](_0x3aa724['id']):_0x2bb510=_0x2ada46(0x269)[_0x2ada46(0x60c)](_0x5bf5c1['id']);else return;}}if(!this[_0x2ada46(0x3ed)][_0x2ada46(0x3bb)](_0x2bb510))this[_0x2ada46(0x3ed)][_0x2ada46(0x4ba)](_0x2bb510);},Game_Party[_0x709961(0x5ef)][_0x709961(0x6b1)]=function(_0x57f9e2){const _0x1a41fb=_0x709961;if(!$gameTemp[_0x1a41fb(0x243)]())return;if(this[_0x1a41fb(0x3ed)]===undefined)this[_0x1a41fb(0x414)]();let _0x501390='';if(DataManager[_0x1a41fb(0x2f3)](_0x57f9e2))_0x501390=_0x1a41fb(0x4c8)[_0x1a41fb(0x60c)](_0x57f9e2['id']);else{if(DataManager[_0x1a41fb(0x67a)](_0x57f9e2))_0x501390=_0x1a41fb(0x49c)[_0x1a41fb(0x60c)](_0x57f9e2['id']);else{if(DataManager[_0x1a41fb(0x3b3)](_0x57f9e2)){if(_0x1a41fb(0x43a)===_0x1a41fb(0x43a))_0x501390=_0x1a41fb(0x269)[_0x1a41fb(0x60c)](_0x57f9e2['id']);else{if(!_0x27228f)return _0x2c2a76;if(!this['isWeapon'](_0x54a3e1)&&!this[_0x1a41fb(0x3b3)](_0x275647))return _0x3a3707;if(_0x814b4b['note']['match'](/<PURIFY TRANSFORM:[ ](.*)>/i)){const _0x427867=_0x378c4c(_0xe4e90a['$1'])[_0x1a41fb(0x3c4)](),_0x2c5122=/^\d+$/[_0x1a41fb(0x566)](_0x427867);if(_0x2c5122){if(this[_0x1a41fb(0x67a)](_0x386d62))return _0x5c7655[_0x45afae(_0x427867)];if(this[_0x1a41fb(0x3b3)](_0xecad70))return _0x2f0f6c[_0x32b7a5(_0x427867)];}else{if(this[_0x1a41fb(0x67a)](_0xd743f1))return _0x528858[this['getWeaponIdWithName'](_0x427867)];if(this[_0x1a41fb(0x3b3)](_0x3c9ff7))return _0x3a35b1[this[_0x1a41fb(0x3c5)](_0x427867)];}}return _0x2198d6;}}else{if(_0x1a41fb(0x373)!==_0x1a41fb(0x373)){const _0x373574=_0x238b33[_0x8c7bc];_0x373574&&_0x373574[_0x1a41fb(0x5fe)]===_0x1d97e6+0x1&&_0x5ef590[_0x1a41fb(0x4ba)](_0x373574);}else return;}}}this[_0x1a41fb(0x3ed)][_0x1a41fb(0x3bb)](_0x501390)&&(_0x1a41fb(0x6af)!=='TPIkm'?_0x88669f=_0x1a41fb(0x269)[_0x1a41fb(0x60c)](_0x11e3e9['id']):this[_0x1a41fb(0x3ed)][_0x1a41fb(0x43d)](this[_0x1a41fb(0x3ed)][_0x1a41fb(0x532)](_0x501390),0x1));},VisuMZ[_0x709961(0x3db)][_0x709961(0x2d3)]=Game_Party['prototype'][_0x709961(0x402)],Game_Party[_0x709961(0x5ef)]['numItems']=function(_0x170301){const _0x1095dc=_0x709961;if(DataManager['isProxyItem'](_0x170301))_0x170301=DataManager[_0x1095dc(0x36d)](_0x170301);return VisuMZ[_0x1095dc(0x3db)][_0x1095dc(0x2d3)]['call'](this,_0x170301);},VisuMZ[_0x709961(0x3db)][_0x709961(0x5d3)]=Game_Party[_0x709961(0x5ef)][_0x709961(0x2a5)],Game_Party['prototype'][_0x709961(0x2a5)]=function(_0x4be3f4,_0xfb890a,_0x26d5d9){const _0x4efed4=_0x709961;if(DataManager[_0x4efed4(0x4a0)](_0x4be3f4))_0x4be3f4=null;const _0x5a3758=this['numItems'](_0x4be3f4);VisuMZ[_0x4efed4(0x3db)]['Game_Party_gainItem'][_0x4efed4(0x376)](this,_0x4be3f4,_0xfb890a,_0x26d5d9);if(this[_0x4efed4(0x402)](_0x4be3f4)>_0x5a3758)this[_0x4efed4(0x678)](_0x4be3f4);},Game_Party[_0x709961(0x5ef)][_0x709961(0x1fb)]=function(_0x3464b9){const _0x56e1ab=_0x709961;if(DataManager['isProxyItem'](_0x3464b9))_0x3464b9=DataManager[_0x56e1ab(0x36d)](_0x3464b9);return DataManager['maxItemAmount'](_0x3464b9);},VisuMZ['ItemsEquipsCore'][_0x709961(0x404)]=Game_Party['prototype'][_0x709961(0x46f)],Game_Party[_0x709961(0x5ef)][_0x709961(0x46f)]=function(_0x4fc1a4){const _0x2ebba4=_0x709961;if(_0x4fc1a4){const _0x4e65dd=_0x4fc1a4[_0x2ebba4(0x1e9)]||'';if(_0x4e65dd['match'](/<(?:CONSERVE|PRESERVE):[ ](\d+)([%％])>/i)){const _0x1203ce=Number(RegExp['$1'])*0.01;if(Math[_0x2ebba4(0x580)]()<_0x1203ce)return;}}VisuMZ['ItemsEquipsCore']['Game_Party_consumeItem']['call'](this,_0x4fc1a4);},Game_Party[_0x709961(0x5ef)][_0x709961(0x59b)]=function(){this['_shopTrackingData']={'buy':{'gold':0x0,'items':{}},'sell':{'gold':0x0,'items':{}}};},Game_Party['prototype']['getShopTrackingData']=function(){const _0x330d60=_0x709961;return this[_0x330d60(0x5cf)]===undefined&&this[_0x330d60(0x59b)](),this[_0x330d60(0x5cf)];},Game_Party['prototype']['getShopTrackingItem']=function(_0x49ec83,_0x5892a7){const _0x3fca1b=_0x709961;if(!_0x5892a7)return 0x0;this[_0x3fca1b(0x5cf)]===undefined&&this['initShopTrackingData']();const _0x4002d1=this[_0x3fca1b(0x1a1)]();if(!_0x4002d1[_0x49ec83])return 0x0;if(_0x5892a7===_0x3fca1b(0x1d4))return _0x4002d1[_0x49ec83]['gold']=_0x4002d1[_0x49ec83][_0x3fca1b(0x1d4)]||0x0,_0x4002d1[_0x49ec83][_0x3fca1b(0x1d4)];else{if(DataManager[_0x3fca1b(0x2f3)](_0x5892a7))key=_0x3fca1b(0x4c8)[_0x3fca1b(0x60c)](_0x5892a7['id']);else{if(DataManager[_0x3fca1b(0x67a)](_0x5892a7)){if('VhXrM'===_0x3fca1b(0x3aa))return _0x45a930['ItemsEquipsCore'][_0x3fca1b(0x6b0)][_0x3fca1b(0x281)]['NotConsumable'];else key=_0x3fca1b(0x49c)[_0x3fca1b(0x60c)](_0x5892a7['id']);}else{if(DataManager['isArmor'](_0x5892a7))key=_0x3fca1b(0x269)[_0x3fca1b(0x60c)](_0x5892a7['id']);else{if(_0x3fca1b(0x2d7)!==_0x3fca1b(0x2d7))_0x1210b7[_0x3fca1b(0x32c)](_0x2b9e42,![]);else return 0x0;}}}}return _0x4002d1[_0x49ec83]['items'][key]=_0x4002d1[_0x49ec83]['items'][key]||0x0,_0x4002d1[_0x49ec83][_0x3fca1b(0x4b1)][key];},Game_Party[_0x709961(0x5ef)][_0x709961(0x1f0)]=function(_0x3632bd){const _0x30cb67=_0x709961;return this[_0x30cb67(0x339)](_0x30cb67(0x41a),_0x3632bd);},Game_Party[_0x709961(0x5ef)][_0x709961(0x3da)]=function(_0x33ee2a){const _0x1d34ab=_0x709961;return this[_0x1d34ab(0x339)](_0x1d34ab(0x1b9),_0x33ee2a);},Game_Party[_0x709961(0x5ef)]['getShopTrackingGoldBuy']=function(){const _0x14ae49=_0x709961;return this['getShopTrackingItem'](_0x14ae49(0x41a),'gold');},Game_Party['prototype'][_0x709961(0x360)]=function(){const _0x200dad=_0x709961;return this['getShopTrackingItem'](_0x200dad(0x1b9),'gold');},Game_Party['prototype']['addShopTrackingItem']=function(_0x30d527,_0x21341d,_0x1baef2){const _0x12a38c=_0x709961;if(!_0x21341d)return;if(_0x1baef2<=0x0)return;this['_shopTrackingData']===undefined&&this[_0x12a38c(0x59b)]();const _0x30e546=this[_0x12a38c(0x1a1)]();if(!_0x30e546[_0x30d527])return;if(_0x21341d===_0x12a38c(0x1d4)){_0x30e546[_0x30d527]['gold']=_0x30e546[_0x30d527][_0x12a38c(0x1d4)]||0x0,_0x30e546[_0x30d527][_0x12a38c(0x1d4)]+=_0x1baef2;return;}else{if(DataManager[_0x12a38c(0x2f3)](_0x21341d))key=_0x12a38c(0x4c8)[_0x12a38c(0x60c)](_0x21341d['id']);else{if(DataManager[_0x12a38c(0x67a)](_0x21341d))key=_0x12a38c(0x49c)['format'](_0x21341d['id']);else{if(DataManager['isArmor'](_0x21341d))key=_0x12a38c(0x269)['format'](_0x21341d['id']);else return;}}}_0x30e546[_0x30d527][_0x12a38c(0x4b1)][key]=_0x30e546[_0x30d527][_0x12a38c(0x4b1)][key]||0x0,_0x30e546[_0x30d527][_0x12a38c(0x4b1)][key]+=_0x1baef2;},Game_Party[_0x709961(0x5ef)][_0x709961(0x28c)]=function(_0x393fbb,_0x3e1bf7){const _0x3d6bc3=_0x709961;this[_0x3d6bc3(0x4f9)](_0x3d6bc3(0x41a),_0x393fbb,_0x3e1bf7);},Game_Party[_0x709961(0x5ef)]['addShopTrackingItemSell']=function(_0x41fb8,_0x52115e){const _0x56b937=_0x709961;this[_0x56b937(0x4f9)](_0x56b937(0x1b9),_0x41fb8,_0x52115e);},Game_Party[_0x709961(0x5ef)][_0x709961(0x64b)]=function(_0x147721){const _0x1a0944=_0x709961;this[_0x1a0944(0x4f9)](_0x1a0944(0x41a),_0x1a0944(0x1d4),_0x147721);},Game_Party[_0x709961(0x5ef)][_0x709961(0x37e)]=function(_0x2cb089){const _0x3e3d6b=_0x709961;this[_0x3e3d6b(0x4f9)]('sell',_0x3e3d6b(0x1d4),_0x2cb089);},VisuMZ['ItemsEquipsCore'][_0x709961(0x28d)]=Scene_ItemBase[_0x709961(0x5ef)][_0x709961(0x65e)],Scene_ItemBase['prototype'][_0x709961(0x65e)]=function(){const _0xf36466=_0x709961;VisuMZ[_0xf36466(0x3db)][_0xf36466(0x28d)][_0xf36466(0x376)](this),this[_0xf36466(0x2ec)][_0xf36466(0x3d8)]();},Scene_Item[_0x709961(0x5ef)][_0x709961(0x4bf)]=function(){const _0x1d4220=_0x709961;if(ConfigManager[_0x1d4220(0x53e)]&&ConfigManager[_0x1d4220(0x32e)]!==undefined){if('lbZrd'===_0x1d4220(0x63c))return ConfigManager['uiHelpPosition'];else this[_0x1d4220(0x2ec)][_0x1d4220(0x630)]=0x1,this[_0x1d4220(0x2ec)]['updateSmoothScroll']();}else return this[_0x1d4220(0x289)]()?this[_0x1d4220(0x4fa)]()['match'](/LOWER/i):Scene_ItemBase[_0x1d4220(0x5ef)][_0x1d4220(0x4bf)][_0x1d4220(0x376)](this);},Scene_Item[_0x709961(0x5ef)][_0x709961(0x2ef)]=function(){const _0x3dfc26=_0x709961;if(ConfigManager[_0x3dfc26(0x53e)]&&ConfigManager['uiInputPosition']!==undefined)return ConfigManager['uiInputPosition'];else{if(this[_0x3dfc26(0x289)]())return _0x3dfc26(0x212)===_0x3dfc26(0x632)?this[_0x3dfc26(0x289)]()?this[_0x3dfc26(0x3ce)]():_0x1cf064[_0x3dfc26(0x3db)][_0x3dfc26(0x1a2)][_0x3dfc26(0x376)](this):this['updatedLayoutStyle']()[_0x3dfc26(0x1ed)](/RIGHT/i);else{if('OFiWY'===_0x3dfc26(0x55d))_0x15e9c8[_0x3dfc26(0x5ef)][_0x3dfc26(0x527)][_0x3dfc26(0x376)](this),this[_0x3dfc26(0x1ff)]();else return Scene_ItemBase[_0x3dfc26(0x5ef)][_0x3dfc26(0x2ef)][_0x3dfc26(0x376)](this);}}},Scene_Item[_0x709961(0x5ef)][_0x709961(0x4fa)]=function(){const _0xa8add3=_0x709961;return VisuMZ[_0xa8add3(0x3db)][_0xa8add3(0x6b0)][_0xa8add3(0x309)][_0xa8add3(0x315)];},Scene_Item[_0x709961(0x5ef)][_0x709961(0x6d8)]=function(){const _0x2869da=_0x709961;return this[_0x2869da(0x5cd)]&&this[_0x2869da(0x5cd)][_0x2869da(0x6d8)]();},Scene_Item['prototype']['isUseItemsEquipsCoreUpdatedLayout']=function(){const _0x5bbf02=_0x709961;return VisuMZ[_0x5bbf02(0x3db)][_0x5bbf02(0x6b0)][_0x5bbf02(0x309)][_0x5bbf02(0x494)];},VisuMZ[_0x709961(0x3db)][_0x709961(0x3e0)]=Scene_Item['prototype'][_0x709961(0x256)],Scene_Item['prototype'][_0x709961(0x256)]=function(){const _0x2f3474=_0x709961;VisuMZ[_0x2f3474(0x3db)][_0x2f3474(0x3e0)]['call'](this),this['isUseModernControls']()&&this['onCategoryOk']();},VisuMZ['ItemsEquipsCore']['Scene_Item_helpWindowRect']=Scene_Item[_0x709961(0x5ef)][_0x709961(0x67b)],Scene_Item[_0x709961(0x5ef)][_0x709961(0x67b)]=function(){const _0x1c974d=_0x709961;return this['isUseItemsEquipsCoreUpdatedLayout']()?this['helpWindowRectItemsEquipsCore']():VisuMZ[_0x1c974d(0x3db)][_0x1c974d(0x310)][_0x1c974d(0x376)](this);},Scene_Item[_0x709961(0x5ef)][_0x709961(0x386)]=function(){const _0x59b92f=_0x709961,_0x35a188=0x0,_0x5c43f0=this['helpAreaTop'](),_0xf947d3=Graphics['boxWidth'],_0x5490bc=this[_0x59b92f(0x60f)]();return new Rectangle(_0x35a188,_0x5c43f0,_0xf947d3,_0x5490bc);},VisuMZ[_0x709961(0x3db)][_0x709961(0x369)]=Scene_Item[_0x709961(0x5ef)][_0x709961(0x5fb)],Scene_Item[_0x709961(0x5ef)][_0x709961(0x5fb)]=function(){const _0x154518=_0x709961;VisuMZ[_0x154518(0x3db)][_0x154518(0x369)][_0x154518(0x376)](this),this['isUseModernControls']()&&this[_0x154518(0x38e)]();},Scene_Item['prototype']['postCreateCategoryWindowItemsEquipsCore']=function(){const _0x41d9e0=_0x709961;delete this['_categoryWindow'][_0x41d9e0(0x4c3)]['ok'],delete this['_categoryWindow'][_0x41d9e0(0x4c3)][_0x41d9e0(0x320)];},VisuMZ[_0x709961(0x3db)][_0x709961(0x227)]=Scene_Item[_0x709961(0x5ef)]['categoryWindowRect'],Scene_Item[_0x709961(0x5ef)][_0x709961(0x549)]=function(){const _0x4821ac=_0x709961;if(this[_0x4821ac(0x289)]()){if('ZoBmU'===_0x4821ac(0x663))return this[_0x4821ac(0x507)]();else this['drawItemStyleIconText'](_0x4e3f8b);}else return VisuMZ[_0x4821ac(0x3db)][_0x4821ac(0x227)][_0x4821ac(0x376)](this);},Scene_Item[_0x709961(0x5ef)][_0x709961(0x507)]=function(){const _0xdf99f1=_0x709961,_0x407c37=0x0,_0xa537b4=this[_0xdf99f1(0x31b)](),_0x17e021=Graphics[_0xdf99f1(0x628)],_0x4f28be=this[_0xdf99f1(0x6ac)](0x1,!![]);return new Rectangle(_0x407c37,_0xa537b4,_0x17e021,_0x4f28be);},VisuMZ['ItemsEquipsCore'][_0x709961(0x5b7)]=Scene_Item[_0x709961(0x5ef)][_0x709961(0x561)],Scene_Item[_0x709961(0x5ef)][_0x709961(0x561)]=function(){const _0x466d34=_0x709961;VisuMZ[_0x466d34(0x3db)][_0x466d34(0x5b7)]['call'](this);this[_0x466d34(0x6d8)]()&&this[_0x466d34(0x1b0)]();if(this[_0x466d34(0x34f)]()){if(_0x466d34(0x394)!=='HQIGy')return _0x4337b9[_0x466d34(0x5f5)](0x1,_0x2073ac['mainFontSize']()-0x4);else this[_0x466d34(0x5e4)]();}},VisuMZ[_0x709961(0x3db)][_0x709961(0x1e5)]=Scene_Item[_0x709961(0x5ef)][_0x709961(0x1f9)],Scene_Item[_0x709961(0x5ef)][_0x709961(0x1f9)]=function(){const _0x5ee965=_0x709961;if(this[_0x5ee965(0x289)]())return this[_0x5ee965(0x61a)]();else{if('sTsQn'!==_0x5ee965(0x6a8)){const _0x1bdaba=VisuMZ['ItemsEquipsCore']['Scene_Item_itemWindowRect']['call'](this);return this[_0x5ee965(0x34f)]()&&this[_0x5ee965(0x260)]()&&(_0x1bdaba[_0x5ee965(0x4ca)]-=this[_0x5ee965(0x62f)]()),_0x1bdaba;}else return this[_0x5ee965(0x4fa)]()['match'](/RIGHT/i);}},Scene_Item['prototype'][_0x709961(0x61a)]=function(){const _0x46c4cd=_0x709961,_0xd9c632=this[_0x46c4cd(0x2ef)]()?this[_0x46c4cd(0x62f)]():0x0,_0x5c1cb9=this[_0x46c4cd(0x5cd)]['y']+this[_0x46c4cd(0x5cd)][_0x46c4cd(0x232)],_0x4b6e8e=Graphics[_0x46c4cd(0x628)]-this['statusWidth'](),_0x36915c=this[_0x46c4cd(0x496)]()-_0x5c1cb9;return new Rectangle(_0xd9c632,_0x5c1cb9,_0x4b6e8e,_0x36915c);},Scene_Item[_0x709961(0x5ef)][_0x709961(0x1b0)]=function(){const _0x3a1db5=_0x709961;this[_0x3a1db5(0x2ec)]['setHandler'](_0x3a1db5(0x320),this['popScene'][_0x3a1db5(0x4b0)](this));},Scene_Item[_0x709961(0x5ef)][_0x709961(0x34f)]=function(){const _0x57e649=_0x709961;return this[_0x57e649(0x289)]()?!![]:VisuMZ['ItemsEquipsCore'][_0x57e649(0x6b0)]['ItemScene'][_0x57e649(0x452)];},Scene_Item['prototype']['adjustItemWidthByStatus']=function(){const _0x5a2d5d=_0x709961;return VisuMZ[_0x5a2d5d(0x3db)][_0x5a2d5d(0x6b0)][_0x5a2d5d(0x309)][_0x5a2d5d(0x363)];},Scene_Item['prototype'][_0x709961(0x5e4)]=function(){const _0x37a05d=_0x709961,_0x4a4015=this[_0x37a05d(0x59f)]();this[_0x37a05d(0x633)]=new Window_ShopStatus(_0x4a4015),this[_0x37a05d(0x5e8)](this[_0x37a05d(0x633)]),this['_itemWindow'][_0x37a05d(0x6b6)](this['_statusWindow']);const _0x4592f2=VisuMZ[_0x37a05d(0x3db)][_0x37a05d(0x6b0)][_0x37a05d(0x309)]['ItemMenuStatusBgType'];this['_statusWindow'][_0x37a05d(0x3e7)](_0x4592f2||0x0);},Scene_Item['prototype'][_0x709961(0x59f)]=function(){const _0x34b917=_0x709961;if(this[_0x34b917(0x289)]()){if(_0x34b917(0x47a)!==_0x34b917(0x374))return this[_0x34b917(0x3ce)]();else{const _0xcc1349=this['_commandNameWindow'];_0xcc1349[_0x34b917(0x30a)]['clear']();const _0x4e7322=this[_0x34b917(0x2b7)](this[_0x34b917(0x624)]());if(_0x4e7322==='icon'){const _0x5a66ab=this['itemLineRect'](this[_0x34b917(0x624)]());let _0x3205a5=this[_0x34b917(0x626)](this[_0x34b917(0x624)]());_0x3205a5=_0x3205a5[_0x34b917(0x3a5)](/\\I\[(\d+)\]/gi,''),_0xcc1349['resetFontSettings'](),this[_0x34b917(0x25d)](_0x3205a5,_0x5a66ab),this[_0x34b917(0x690)](_0x3205a5,_0x5a66ab),this[_0x34b917(0x45a)](_0x3205a5,_0x5a66ab);}}}else return VisuMZ['ItemsEquipsCore'][_0x34b917(0x6b0)][_0x34b917(0x309)][_0x34b917(0x396)][_0x34b917(0x376)](this);},Scene_Item['prototype']['statusWindowRectItemsEquipsCore']=function(){const _0x3b61fd=_0x709961,_0x34ef3d=this[_0x3b61fd(0x62f)](),_0x361fd2=this[_0x3b61fd(0x2ec)]['height'],_0x59ea53=this[_0x3b61fd(0x2ef)]()?0x0:Graphics['boxWidth']-this[_0x3b61fd(0x62f)](),_0x2c9627=this[_0x3b61fd(0x2ec)]['y'];return new Rectangle(_0x59ea53,_0x2c9627,_0x34ef3d,_0x361fd2);},Scene_Item[_0x709961(0x5ef)][_0x709961(0x62f)]=function(){const _0x430091=_0x709961;return Scene_Shop[_0x430091(0x5ef)][_0x430091(0x62f)]();},Scene_Item[_0x709961(0x5ef)][_0x709961(0x484)]=function(){const _0x4676f1=_0x709961;if(!this[_0x4676f1(0x4fa)]())return![];if(!this[_0x4676f1(0x6d8)]())return![];if(!this['_itemWindow'])return![];if(!this[_0x4676f1(0x2ec)][_0x4676f1(0x3bd)])return![];return this[_0x4676f1(0x4fa)]()&&this[_0x4676f1(0x6d8)]();},Scene_Item[_0x709961(0x5ef)]['buttonAssistKey1']=function(){const _0x5df0a6=_0x709961;if(this[_0x5df0a6(0x484)]()){if(_0x5df0a6(0x435)!==_0x5df0a6(0x40f)){if(this['_itemWindow'][_0x5df0a6(0x515)]()===0x1)return TextManager[_0x5df0a6(0x4bd)]('left',_0x5df0a6(0x4b9));else{if(_0x5df0a6(0x343)!=='XJmHG'){const _0x5dd6ab=this[_0x5df0a6(0x407)]();let _0x4ea531=0x0,_0x132922=0x0,_0x37b418='';if(this[_0x5df0a6(0x342)]){_0x4e7f89[_0x5df0a6(0x615)]?(_0x4ea531=this[_0x5df0a6(0x3bc)][_0x5df0a6(0x29d)](_0x50a5f4,![]),_0x132922=this[_0x5df0a6(0x342)][_0x5df0a6(0x29d)](_0x3c7c0a,![]),_0x37b418=this[_0x5df0a6(0x342)]['paramValueByName'](_0x3a14ff,!![])):(_0x4ea531=this['_actor'][_0x5df0a6(0x307)](_0x33c788),_0x132922=this[_0x5df0a6(0x342)][_0x5df0a6(0x307)](_0x177fa5),_0x37b418=this['_tempActor']['param'](_0x5c44dc));const _0x4a0a77=_0x4ea531,_0x27c436=_0x132922;_0x888d4a=_0x27c436-_0x4a0a77,this[_0x5df0a6(0x61c)](_0x4985df[_0x5df0a6(0x4da)](_0x340359)),this[_0x5df0a6(0x62c)](_0x37b418,_0x22a2bd,_0x8b50c,_0x292656-_0x5dd6ab,'right');}}else return TextManager[_0x5df0a6(0x4bd)](_0x5df0a6(0x277),_0x5df0a6(0x5af));}}else return this[_0x5df0a6(0x289)]()?this['geUpdatedLayoutStatusWidth']():_0x51965b[_0x5df0a6(0x3db)][_0x5df0a6(0x6b0)]['EquipScene'][_0x5df0a6(0x610)];}return Scene_ItemBase[_0x5df0a6(0x5ef)]['buttonAssistKey1'][_0x5df0a6(0x376)](this);},Scene_Item[_0x709961(0x5ef)][_0x709961(0x211)]=function(){const _0x4d94e0=_0x709961;if(this[_0x4d94e0(0x484)]())return VisuMZ[_0x4d94e0(0x3db)][_0x4d94e0(0x6b0)][_0x4d94e0(0x309)]['buttonAssistCategory'];return Scene_ItemBase[_0x4d94e0(0x5ef)][_0x4d94e0(0x211)]['call'](this);},Scene_Equip['prototype'][_0x709961(0x56e)]=function(){const _0x13c3af=_0x709961;Scene_ItemBase['prototype'][_0x13c3af(0x56e)][_0x13c3af(0x376)](this),this[_0x13c3af(0x5f0)]();},Scene_Equip[_0x709961(0x5ef)][_0x709961(0x4bf)]=function(){const _0x3addab=_0x709961;if(ConfigManager[_0x3addab(0x53e)]&&ConfigManager[_0x3addab(0x32e)]!==undefined)return ConfigManager['uiHelpPosition'];else{if(this[_0x3addab(0x289)]())return this[_0x3addab(0x4fa)]()[_0x3addab(0x1ed)](/LOWER/i);else Scene_MenuBase[_0x3addab(0x5ef)][_0x3addab(0x2ef)][_0x3addab(0x376)](this);}},Scene_Equip[_0x709961(0x5ef)][_0x709961(0x2ef)]=function(){const _0x553cdd=_0x709961;if(ConfigManager[_0x553cdd(0x53e)]&&ConfigManager['uiInputPosition']!==undefined)return ConfigManager[_0x553cdd(0x2e1)];else{if(this['isUseItemsEquipsCoreUpdatedLayout']()){if(_0x553cdd(0x4a6)===_0x553cdd(0x6ee))_0x46af01=_0x1e371f[_0x553cdd(0x3db)][_0x553cdd(0x40e)](_0x5245c1),_0x1d36db['ItemsEquipsCore'][_0x553cdd(0x591)]['call'](this,_0x3c988c,_0x2b2c0d),this[_0x553cdd(0x6cc)]();else return this[_0x553cdd(0x4fa)]()[_0x553cdd(0x1ed)](/RIGHT/i);}else{if(_0x553cdd(0x4af)===_0x553cdd(0x4af))Scene_MenuBase[_0x553cdd(0x5ef)][_0x553cdd(0x2ef)][_0x553cdd(0x376)](this);else return this['updatedLayoutStyle']()['match'](/RIGHT/i);}}},Scene_Equip[_0x709961(0x5ef)]['updatedLayoutStyle']=function(){const _0x3d9b06=_0x709961;return VisuMZ[_0x3d9b06(0x3db)][_0x3d9b06(0x6b0)][_0x3d9b06(0x6b4)]['LayoutStyle'];},Scene_Equip['prototype']['isUseModernControls']=function(){const _0x17bfc4=_0x709961;return this[_0x17bfc4(0x1a6)]&&this[_0x17bfc4(0x1a6)][_0x17bfc4(0x6d8)]();},Scene_Equip['prototype'][_0x709961(0x289)]=function(){const _0x32d410=_0x709961;return VisuMZ['ItemsEquipsCore']['Settings'][_0x32d410(0x6b4)][_0x32d410(0x494)];},VisuMZ[_0x709961(0x3db)][_0x709961(0x1b2)]=Scene_Equip[_0x709961(0x5ef)]['create'],Scene_Equip[_0x709961(0x5ef)][_0x709961(0x256)]=function(){const _0x5b49d6=_0x709961;VisuMZ[_0x5b49d6(0x3db)][_0x5b49d6(0x1b2)]['call'](this),this[_0x5b49d6(0x6d8)]()&&this[_0x5b49d6(0x344)]();},VisuMZ['ItemsEquipsCore'][_0x709961(0x6bf)]=Scene_Equip[_0x709961(0x5ef)][_0x709961(0x67b)],Scene_Equip[_0x709961(0x5ef)][_0x709961(0x67b)]=function(){const _0x5b3e24=_0x709961;return this['isUseItemsEquipsCoreUpdatedLayout']()?'gfYno'!==_0x5b3e24(0x4b6)?![]:this[_0x5b3e24(0x386)]():VisuMZ[_0x5b3e24(0x3db)]['Scene_Equip_helpWindowRect'][_0x5b3e24(0x376)](this);},Scene_Equip['prototype']['helpWindowRectItemsEquipsCore']=function(){const _0xa368e3=_0x709961,_0x1456e4=0x0,_0x5e6a61=this[_0xa368e3(0x2fb)](),_0xbde460=Graphics['boxWidth'],_0x1c3148=this[_0xa368e3(0x60f)]();return new Rectangle(_0x1456e4,_0x5e6a61,_0xbde460,_0x1c3148);},VisuMZ[_0x709961(0x3db)][_0x709961(0x1a2)]=Scene_Equip[_0x709961(0x5ef)]['statusWindowRect'],Scene_Equip[_0x709961(0x5ef)][_0x709961(0x59f)]=function(){const _0x171b5b=_0x709961;if(this[_0x171b5b(0x289)]()){if('qCfvW'!==_0x171b5b(0x441)){_0x411f08[_0x171b5b(0x5ef)][_0x171b5b(0x3d8)][_0x171b5b(0x376)](this);if(this['_categoryNameWindow'])this[_0x171b5b(0x280)]();}else return this[_0x171b5b(0x3ce)]();}else return VisuMZ['ItemsEquipsCore'][_0x171b5b(0x1a2)]['call'](this);},Scene_Equip[_0x709961(0x5ef)][_0x709961(0x3ce)]=function(){const _0x43ec8d=_0x709961,_0x5752f5=this[_0x43ec8d(0x2ef)]()?0x0:Graphics[_0x43ec8d(0x628)]-this[_0x43ec8d(0x62f)](),_0x5e48ea=this[_0x43ec8d(0x31b)](),_0x4ef769=this[_0x43ec8d(0x62f)](),_0x3134aa=this['mainAreaHeight']();return new Rectangle(_0x5752f5,_0x5e48ea,_0x4ef769,_0x3134aa);},VisuMZ[_0x709961(0x3db)]['Scene_Equip_createCommandWindow']=Scene_Equip[_0x709961(0x5ef)]['createCommandWindow'],Scene_Equip[_0x709961(0x5ef)][_0x709961(0x5f9)]=function(){const _0xc0fc62=_0x709961;VisuMZ[_0xc0fc62(0x3db)][_0xc0fc62(0x4ab)][_0xc0fc62(0x376)](this);if(this[_0xc0fc62(0x2c3)])this['_commandWindow'][_0xc0fc62(0x33a)](this[_0xc0fc62(0x2c3)]);},VisuMZ[_0x709961(0x3db)][_0x709961(0x6d9)]=Scene_Equip[_0x709961(0x5ef)][_0x709961(0x558)],Scene_Equip[_0x709961(0x5ef)][_0x709961(0x558)]=function(){const _0x5097dd=_0x709961;return this[_0x5097dd(0x289)]()?this[_0x5097dd(0x1f3)]():VisuMZ[_0x5097dd(0x3db)][_0x5097dd(0x6d9)][_0x5097dd(0x376)](this);},Scene_Equip[_0x709961(0x5ef)]['shouldCommandWindowExist']=function(){const _0x953233=_0x709961,_0x4170a6=VisuMZ['ItemsEquipsCore'][_0x953233(0x6b0)][_0x953233(0x6b4)];return _0x4170a6['CommandAddOptimize']||_0x4170a6[_0x953233(0x578)];},Scene_Equip[_0x709961(0x5ef)][_0x709961(0x1f3)]=function(){const _0x18380d=_0x709961,_0x32346d=this[_0x18380d(0x492)](),_0xe9aacc=this['isRightInputMode']()?this[_0x18380d(0x62f)]():0x0,_0x18e653=this[_0x18380d(0x31b)](),_0x41c48f=Graphics[_0x18380d(0x628)]-this['statusWidth'](),_0x7a75bf=_0x32346d?this[_0x18380d(0x6ac)](0x1,!![]):0x0;return new Rectangle(_0xe9aacc,_0x18e653,_0x41c48f,_0x7a75bf);},VisuMZ[_0x709961(0x3db)][_0x709961(0x451)]=Scene_Equip['prototype'][_0x709961(0x64f)],Scene_Equip[_0x709961(0x5ef)][_0x709961(0x64f)]=function(){const _0x3b8d57=_0x709961;VisuMZ[_0x3b8d57(0x3db)][_0x3b8d57(0x451)][_0x3b8d57(0x376)](this),this[_0x3b8d57(0x6d8)]()&&this['postCreateSlotWindowItemsEquipsCore']();},VisuMZ[_0x709961(0x3db)]['Scene_Equip_slotWindowRect']=Scene_Equip[_0x709961(0x5ef)][_0x709961(0x2f9)],Scene_Equip['prototype'][_0x709961(0x2f9)]=function(){const _0x2be399=_0x709961;if(this['isUseItemsEquipsCoreUpdatedLayout']())return this['slotWindowRectItemsEquipsCore']();else{if(_0x2be399(0x627)!==_0x2be399(0x6d5))return VisuMZ[_0x2be399(0x3db)][_0x2be399(0x5bf)][_0x2be399(0x376)](this);else this[_0x2be399(0x6e8)][_0x2be399(0x5b0)](),this[_0x2be399(0x1a6)][_0x2be399(0x5b0)]();}},Scene_Equip[_0x709961(0x5ef)][_0x709961(0x42e)]=function(){const _0x234da4=_0x709961,_0x315856=this[_0x234da4(0x558)](),_0x4587dc=this[_0x234da4(0x2ef)]()?this[_0x234da4(0x62f)]():0x0,_0xaebf33=_0x315856['y']+_0x315856[_0x234da4(0x232)],_0x5d4aec=Graphics[_0x234da4(0x628)]-this[_0x234da4(0x62f)](),_0xc4896a=this[_0x234da4(0x5e0)]()-_0x315856[_0x234da4(0x232)];return new Rectangle(_0x4587dc,_0xaebf33,_0x5d4aec,_0xc4896a);},VisuMZ[_0x709961(0x3db)][_0x709961(0x1b5)]=Scene_Equip['prototype'][_0x709961(0x1f9)],Scene_Equip[_0x709961(0x5ef)][_0x709961(0x1f9)]=function(){const _0x1d6686=_0x709961;return this[_0x1d6686(0x289)]()?this[_0x1d6686(0x2f9)]():VisuMZ['ItemsEquipsCore']['Scene_Equip_itemWindowRect'][_0x1d6686(0x376)](this);},Scene_Equip['prototype'][_0x709961(0x62f)]=function(){const _0x338708=_0x709961;return this['isUseItemsEquipsCoreUpdatedLayout']()?this[_0x338708(0x2d2)]():VisuMZ[_0x338708(0x3db)][_0x338708(0x6b0)][_0x338708(0x6b4)][_0x338708(0x610)];},Scene_Equip[_0x709961(0x5ef)][_0x709961(0x2d2)]=function(){const _0x39dda9=_0x709961;return Math[_0x39dda9(0x4e5)](Graphics[_0x39dda9(0x628)]/0x2);},Scene_Equip[_0x709961(0x5ef)][_0x709961(0x5db)]=function(){const _0x21f44b=_0x709961;this[_0x21f44b(0x3f9)]['setHandler'](_0x21f44b(0x320),this['popScene'][_0x21f44b(0x4b0)](this)),this[_0x21f44b(0x3f9)][_0x21f44b(0x2c8)](_0x21f44b(0x5af),this['nextActor'][_0x21f44b(0x4b0)](this)),this[_0x21f44b(0x3f9)]['setHandler'](_0x21f44b(0x277),this[_0x21f44b(0x1c3)][_0x21f44b(0x4b0)](this));},VisuMZ[_0x709961(0x3db)][_0x709961(0x272)]=Scene_Equip[_0x709961(0x5ef)]['commandEquip'],Scene_Equip[_0x709961(0x5ef)][_0x709961(0x344)]=function(){const _0xb6d038=_0x709961;this[_0xb6d038(0x6d8)]()&&(this[_0xb6d038(0x1a6)]['deselect'](),this['_commandWindow'][_0xb6d038(0x6df)]()),VisuMZ[_0xb6d038(0x3db)]['Scene_Equip_commandEquip']['call'](this);},VisuMZ[_0x709961(0x3db)][_0x709961(0x326)]=Scene_Equip[_0x709961(0x5ef)]['onSlotOk'],Scene_Equip[_0x709961(0x5ef)][_0x709961(0x1b4)]=function(){const _0x5e4bbf=_0x709961;this[_0x5e4bbf(0x3f9)][_0x5e4bbf(0x624)]()>=0x0?_0x5e4bbf(0x3d7)==='jPqRG'?(VisuMZ[_0x5e4bbf(0x3db)][_0x5e4bbf(0x326)][_0x5e4bbf(0x376)](this),this[_0x5e4bbf(0x65a)]()):this['cursorLeft'](_0x53591c[_0x5e4bbf(0x5c1)](_0x5e4bbf(0x316))):(this[_0x5e4bbf(0x3f9)][_0x5e4bbf(0x1de)](0x0),this[_0x5e4bbf(0x3f9)][_0x5e4bbf(0x55a)]());},Scene_Equip[_0x709961(0x5ef)][_0x709961(0x65a)]=function(){const _0x4639d5=_0x709961;this[_0x4639d5(0x2ec)]['refresh']();const _0x5e8eff=this['_slotWindow']['item'](),_0x3c6cfa=this[_0x4639d5(0x2ec)]['_data']['indexOf'](_0x5e8eff),_0x203fbe=Math[_0x4639d5(0x4e5)](this[_0x4639d5(0x2ec)][_0x4639d5(0x436)]()/0x2)-0x1;this[_0x4639d5(0x2ec)][_0x4639d5(0x1de)](_0x3c6cfa>=0x0?_0x3c6cfa:0x0),this['_itemWindow'][_0x4639d5(0x630)]>0x1&&(this[_0x4639d5(0x2ec)][_0x4639d5(0x630)]=0x1,this[_0x4639d5(0x2ec)][_0x4639d5(0x4e1)]()),this[_0x4639d5(0x2ec)][_0x4639d5(0x57d)](this[_0x4639d5(0x2ec)][_0x4639d5(0x624)]()-_0x203fbe);},VisuMZ[_0x709961(0x3db)][_0x709961(0x49f)]=Scene_Equip[_0x709961(0x5ef)][_0x709961(0x236)],Scene_Equip[_0x709961(0x5ef)][_0x709961(0x236)]=function(){const _0x2e480a=_0x709961;VisuMZ[_0x2e480a(0x3db)][_0x2e480a(0x49f)][_0x2e480a(0x376)](this),this[_0x2e480a(0x6d8)]()&&(_0x2e480a(0x338)!==_0x2e480a(0x63b)?(this['_commandWindow']['smoothSelect'](0x0),this[_0x2e480a(0x3f9)]['deactivate']()):(this[_0x2e480a(0x216)]=!![],this[_0x2e480a(0x551)]=_0x26b73a));},VisuMZ['ItemsEquipsCore'][_0x709961(0x571)]=Scene_Equip[_0x709961(0x5ef)][_0x709961(0x641)],Scene_Equip[_0x709961(0x5ef)][_0x709961(0x641)]=function(){const _0x1fcd9b=_0x709961;VisuMZ[_0x1fcd9b(0x3db)]['Scene_Equip_onActorChange']['call'](this);if(this[_0x1fcd9b(0x6d8)]()){if(_0x1fcd9b(0x27c)===_0x1fcd9b(0x429))return _0x5af809['getInputMultiButtonStrings']('pageup',_0x1fcd9b(0x5af));else this['_commandWindow']['deactivate'](),this[_0x1fcd9b(0x1a6)]['deselect'](),this[_0x1fcd9b(0x3f9)][_0x1fcd9b(0x1de)](0x0),this[_0x1fcd9b(0x3f9)]['activate']();}},Scene_Equip['prototype'][_0x709961(0x38d)]=function(){const _0x470f0b=_0x709961;if(!this['_slotWindow'])return![];if(!this[_0x470f0b(0x3f9)][_0x470f0b(0x3bd)])return![];return this[_0x470f0b(0x3f9)][_0x470f0b(0x466)]();},Scene_Equip[_0x709961(0x5ef)][_0x709961(0x648)]=function(){const _0x677559=_0x709961;if(this[_0x677559(0x38d)]()){if(_0x677559(0x48c)==='udknT')return TextManager[_0x677559(0x32d)]('shift');else{const _0x3f78fb=this[_0x677559(0x3b2)]();return this[_0x677559(0x2c2)](_0x3f78fb,_0x55a638,_0x17cd44,_0x56d7db,![],_0x677559(0x50b)),this[_0x677559(0x533)](_0x1249fc,_0x5b8512,_0x5d9f00),this['resetFontSettings'](),!![];}}return Scene_MenuBase[_0x677559(0x5ef)][_0x677559(0x648)]['call'](this);},Scene_Equip[_0x709961(0x5ef)][_0x709961(0x60e)]=function(){const _0x4f513b=_0x709961;if(this[_0x4f513b(0x38d)]()){if('byFjv'===_0x4f513b(0x341))return VisuMZ['ItemsEquipsCore'][_0x4f513b(0x6b0)][_0x4f513b(0x6b4)][_0x4f513b(0x3ba)];else{const _0x3eb7d9=_0xaa277a(_0xa7f16a['$1'])[_0x4f513b(0x617)](',')[_0x4f513b(0x1ac)](_0x49db7b=>_0x6c6460(_0x49db7b));for(const _0x538169 of _0x3eb7d9){_0x47a07b[_0x4f513b(0x32c)](_0x538169,![]);}}}return Scene_MenuBase['prototype'][_0x4f513b(0x60e)][_0x4f513b(0x376)](this);},Scene_Equip[_0x709961(0x5ef)][_0x709961(0x48f)]=function(){const _0xd2965a=_0x709961;if(this[_0xd2965a(0x38d)]())return this[_0xd2965a(0x2b8)][_0xd2965a(0x4ca)]/0x5/-0x3;return Scene_MenuBase['prototype'][_0xd2965a(0x48f)][_0xd2965a(0x376)](this);},Scene_Equip[_0x709961(0x5ef)][_0x709961(0x4d7)]=function(){const _0x1c37b5=_0x709961;SceneManager[_0x1c37b5(0x21b)]();},VisuMZ['ItemsEquipsCore'][_0x709961(0x286)]=Scene_Load[_0x709961(0x5ef)][_0x709961(0x2ff)],Scene_Load[_0x709961(0x5ef)][_0x709961(0x2ff)]=function(){const _0x4b9e78=_0x709961;VisuMZ[_0x4b9e78(0x3db)][_0x4b9e78(0x286)][_0x4b9e78(0x376)](this),this['refreshActorEquipSlotsIfUpdated']();},Scene_Load[_0x709961(0x5ef)][_0x709961(0x636)]=function(){const _0x3d4f4b=_0x709961;if($gameSystem[_0x3d4f4b(0x47b)]()!==$dataSystem[_0x3d4f4b(0x47b)]){if(_0x3d4f4b(0x657)==='QPhfe')for(const _0x29e067 of $gameActors[_0x3d4f4b(0x53a)]){if(_0x29e067)_0x29e067[_0x3d4f4b(0x366)]();}else this[_0x3d4f4b(0x3af)](null,_0x9620b3);}},Scene_Shop[_0x709961(0x5ef)]['isBottomHelpMode']=function(){const _0x1dedf1=_0x709961;if(ConfigManager[_0x1dedf1(0x53e)]&&ConfigManager[_0x1dedf1(0x32e)]!==undefined)return ConfigManager[_0x1dedf1(0x32e)];else{if(this[_0x1dedf1(0x289)]())return this['updatedLayoutStyle']()[_0x1dedf1(0x1ed)](/LOWER/i);else{if(_0x1dedf1(0x322)!==_0x1dedf1(0x423))Scene_MenuBase[_0x1dedf1(0x5ef)][_0x1dedf1(0x2ef)]['call'](this);else return _0x1dedf1(0x3be);}}},Scene_Shop['prototype'][_0x709961(0x2ef)]=function(){const _0x34dd3b=_0x709961;if(ConfigManager[_0x34dd3b(0x53e)]&&ConfigManager['uiInputPosition']!==undefined){if('PmWfq'==='PmWfq')return ConfigManager[_0x34dd3b(0x2e1)];else{if(!this[_0x34dd3b(0x3fc)]()&&!_0x76bf5c['isItem'](this[_0x34dd3b(0x3c2)]))return![];if(_0x12e3df[_0x34dd3b(0x239)](this[_0x34dd3b(0x3c2)])&&!_0x269454[_0x34dd3b(0x33d)]){const _0x5d8c28=_0x5cad61[_0x34dd3b(0x44d)];this['drawItemKeyData'](_0x5d8c28,_0x3faac6,_0x5e0a4d,_0x42f51c,!![],_0x34dd3b(0x50b));}else{const _0x5b6f89=_0xc46bfb[_0x34dd3b(0x65d)];this[_0x34dd3b(0x2c2)](_0x5b6f89,_0x4b9d96,_0x4b6a93,_0x3f77d7,!![]);const _0x462797=this[_0x34dd3b(0x2e2)]();this[_0x34dd3b(0x2c2)](_0x462797,_0x58d4ac,_0x24c043,_0x1a2a6a,![],_0x34dd3b(0x4b9));}return this[_0x34dd3b(0x533)](_0x25a4f6,_0x5056e5,_0x1c2833),this['resetFontSettings'](),!![];}}else{if(this['isUseItemsEquipsCoreUpdatedLayout']()){if(_0x34dd3b(0x683)!==_0x34dd3b(0x2d9))return this[_0x34dd3b(0x4fa)]()[_0x34dd3b(0x1ed)](/RIGHT/i);else this[_0x34dd3b(0x55f)]();}else _0x34dd3b(0x3f3)==='JHzAf'?Scene_MenuBase['prototype'][_0x34dd3b(0x2ef)][_0x34dd3b(0x376)](this):this['playBuzzerSound']();}},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x4fa)]=function(){const _0x3254b5=_0x709961;return VisuMZ['ItemsEquipsCore'][_0x3254b5(0x6b0)]['ShopScene'][_0x3254b5(0x315)];},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x6d8)]=function(){const _0x5ef87d=_0x709961;return this[_0x5ef87d(0x5cd)]&&this[_0x5ef87d(0x5cd)][_0x5ef87d(0x6d8)]();},Scene_Shop['prototype'][_0x709961(0x289)]=function(){const _0x2d9d8f=_0x709961;return VisuMZ[_0x2d9d8f(0x3db)]['Settings']['ShopScene']['EnableLayout'];},VisuMZ[_0x709961(0x3db)][_0x709961(0x591)]=Scene_Shop[_0x709961(0x5ef)][_0x709961(0x2dc)],Scene_Shop[_0x709961(0x5ef)][_0x709961(0x2dc)]=function(_0x4e09c3,_0x5a7b1a){const _0x2d39f7=_0x709961;_0x4e09c3=VisuMZ[_0x2d39f7(0x3db)]['deepCopy'](_0x4e09c3),VisuMZ[_0x2d39f7(0x3db)][_0x2d39f7(0x591)]['call'](this,_0x4e09c3,_0x5a7b1a),this['adjustHiddenShownGoods']();},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x6cc)]=function(){const _0x3cd243=_0x709961;this[_0x3cd243(0x25b)]=0x0;const _0x29cd74=[];for(const _0x343225 of this[_0x3cd243(0x2fe)]){if(this[_0x3cd243(0x6bc)](_0x343225))this['_goodsCount']++;else{if('XqSPE'===_0x3cd243(0x383))return _0xcc7a8d[_0x3cd243(0x3db)][_0x3cd243(0x58a)][_0x3cd243(0x376)](this);else _0x29cd74['push'](_0x343225);}}for(const _0x458d64 of _0x29cd74){this[_0x3cd243(0x2fe)][_0x3cd243(0x34e)](_0x458d64);}},Scene_Shop[_0x709961(0x5ef)]['isGoodShown']=function(_0x361f86){if(_0x361f86[0x0]>0x2||_0x361f86[0x0]<0x0)return![];const _0x1e8f53=[$dataItems,$dataWeapons,$dataArmors][_0x361f86[0x0]][_0x361f86[0x1]];if(!_0x1e8f53)return![];return!![];},VisuMZ[_0x709961(0x3db)][_0x709961(0x2ab)]=Scene_Shop[_0x709961(0x5ef)][_0x709961(0x256)],Scene_Shop[_0x709961(0x5ef)][_0x709961(0x256)]=function(){const _0x4a7676=_0x709961;VisuMZ['ItemsEquipsCore'][_0x4a7676(0x2ab)]['call'](this);if(this['isUseItemsEquipsCoreUpdatedLayout']()){if('RAuKW'!==_0x4a7676(0x446)){const _0x429919=_0x527578[_0x339a22],_0x480d19=this[_0x4a7676(0x563)](_0x1cf796,_0x429919);if(this[_0x4a7676(0x447)](_0x480d19))this[_0x4a7676(0x5fd)][_0x170678][_0x4a7676(0x299)](_0x480d19);}else this[_0x4a7676(0x34b)]();}this[_0x4a7676(0x4dd)]();},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x34b)]=function(){const _0xb7c899=_0x709961;this[_0xb7c899(0x50e)][_0xb7c899(0x5b0)](),this[_0xb7c899(0x6e8)][_0xb7c899(0x314)](),this['_buyWindow']['deselect'](),this[_0xb7c899(0x633)][_0xb7c899(0x314)]();},VisuMZ[_0x709961(0x3db)]['Scene_Shop_helpWindowRect']=Scene_Shop[_0x709961(0x5ef)][_0x709961(0x67b)],Scene_Shop[_0x709961(0x5ef)][_0x709961(0x67b)]=function(){const _0x5afb50=_0x709961;return this['isUseItemsEquipsCoreUpdatedLayout']()?this[_0x5afb50(0x386)]():VisuMZ['ItemsEquipsCore'][_0x5afb50(0x58a)][_0x5afb50(0x376)](this);},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x386)]=function(){const _0x458878=_0x709961,_0x52bc14=0x0,_0x57db92=this['helpAreaTop'](),_0x36ed1b=Graphics[_0x458878(0x628)],_0xac0827=this[_0x458878(0x60f)]();return new Rectangle(_0x52bc14,_0x57db92,_0x36ed1b,_0xac0827);},VisuMZ['ItemsEquipsCore']['Scene_Shop_goldWindowRect']=Scene_Shop[_0x709961(0x5ef)][_0x709961(0x3b9)],Scene_Shop[_0x709961(0x5ef)]['goldWindowRect']=function(){const _0x3ff2ed=_0x709961;if(this[_0x3ff2ed(0x289)]())return this[_0x3ff2ed(0x568)]();else{if(_0x3ff2ed(0x6c3)!==_0x3ff2ed(0x4c9))return VisuMZ[_0x3ff2ed(0x3db)][_0x3ff2ed(0x1cd)][_0x3ff2ed(0x376)](this);else!this['processCursorSpecialCheckModernControls']()&&_0x4db55c[_0x3ff2ed(0x5ef)][_0x3ff2ed(0x67e)][_0x3ff2ed(0x376)](this);}},Scene_Shop['prototype'][_0x709961(0x568)]=function(){const _0xcb3430=_0x709961,_0x2c03fc=this[_0xcb3430(0x5a8)](),_0x343213=this[_0xcb3430(0x6ac)](0x1,!![]),_0x3ff3ff=this[_0xcb3430(0x2ef)]()?0x0:Graphics[_0xcb3430(0x628)]-_0x2c03fc,_0x15bde9=this['mainAreaTop']();return new Rectangle(_0x3ff3ff,_0x15bde9,_0x2c03fc,_0x343213);},VisuMZ['ItemsEquipsCore'][_0x709961(0x2bd)]=Scene_Shop['prototype'][_0x709961(0x558)],Scene_Shop[_0x709961(0x5ef)][_0x709961(0x558)]=function(){const _0x4d930e=_0x709961;if(this['isUseItemsEquipsCoreUpdatedLayout']()){if('EWgRV'==='EWgRV')return this[_0x4d930e(0x1f3)]();else _0x209f88=_0x31f0a9[_0x4d930e(0x29d)](_0x11edbf),_0x5037d8=_0x589793-_0x3af10e[_0x4d930e(0x29d)](_0x179301),this[_0x4d930e(0x61c)](_0x172091[_0x4d930e(0x4da)](_0x3bcd73)),_0x36eec6=(_0x229a37>=0x0?'+':'')+_0x114426['ConvertNumberToString'](_0x3941c1,0x0,_0x2bae34);}else{if(_0x4d930e(0x4f5)!==_0x4d930e(0x4f5))_0x49c134=this[_0x4d930e(0x5d9)](_0x16934a);else return VisuMZ['ItemsEquipsCore']['Scene_Shop_commandWindowRect'][_0x4d930e(0x376)](this);}},Scene_Shop[_0x709961(0x5ef)]['commandWindowRectItemsEquipsCore']=function(){const _0x33b4cc=_0x709961,_0xa83c27=this[_0x33b4cc(0x2ef)]()?this['mainCommandWidth']():0x0,_0x5a7751=this[_0x33b4cc(0x31b)](),_0xc441c4=Graphics[_0x33b4cc(0x628)]-this[_0x33b4cc(0x5a8)](),_0x59a6dc=this['calcWindowHeight'](0x1,!![]);return new Rectangle(_0xa83c27,_0x5a7751,_0xc441c4,_0x59a6dc);},VisuMZ[_0x709961(0x3db)][_0x709961(0x685)]=Scene_Shop[_0x709961(0x5ef)]['numberWindowRect'],Scene_Shop[_0x709961(0x5ef)][_0x709961(0x445)]=function(){const _0x2e5038=_0x709961;if(this[_0x2e5038(0x289)]()){if('OxvIq'!==_0x2e5038(0x20d))return this[_0x2e5038(0x1bb)]();else this[_0x2e5038(0x30a)][_0x2e5038(0x556)](),this['contentsBack'][_0x2e5038(0x556)](),this['_item']&&(this[_0x2e5038(0x4e3)](),this[_0x2e5038(0x403)](!![]),this[_0x2e5038(0x365)](),this['isEquipItem']()?this[_0x2e5038(0x44e)]():this[_0x2e5038(0x6ef)](),this['drawCustomShopGraphic']());}else return VisuMZ['ItemsEquipsCore'][_0x2e5038(0x685)][_0x2e5038(0x376)](this);},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x1bb)]=function(){const _0x5d52e9=_0x709961,_0x4d2ae8=this[_0x5d52e9(0x1a6)]['y']+this[_0x5d52e9(0x1a6)][_0x5d52e9(0x232)],_0x1656cb=Graphics[_0x5d52e9(0x628)]-this[_0x5d52e9(0x62f)](),_0x4ad421=this['isRightInputMode']()?Graphics[_0x5d52e9(0x628)]-_0x1656cb:0x0,_0x4d9731=this[_0x5d52e9(0x5e0)]()-this['_commandWindow'][_0x5d52e9(0x232)];return new Rectangle(_0x4ad421,_0x4d2ae8,_0x1656cb,_0x4d9731);},VisuMZ[_0x709961(0x3db)][_0x709961(0x6c7)]=Scene_Shop[_0x709961(0x5ef)][_0x709961(0x59f)],Scene_Shop['prototype'][_0x709961(0x59f)]=function(){const _0x4ac7d3=_0x709961;return this['isUseItemsEquipsCoreUpdatedLayout']()?this['statusWindowRectItemsEquipsCore']():VisuMZ['ItemsEquipsCore']['Scene_Shop_statusWindowRect'][_0x4ac7d3(0x376)](this);},Scene_Shop[_0x709961(0x5ef)]['statusWindowRectItemsEquipsCore']=function(){const _0x4581f6=_0x709961,_0x4e0dd6=this[_0x4581f6(0x62f)](),_0x32d12f=this[_0x4581f6(0x5e0)]()-this[_0x4581f6(0x1a6)]['height'],_0x3612fa=this[_0x4581f6(0x2ef)]()?0x0:Graphics[_0x4581f6(0x628)]-_0x4e0dd6,_0x3a1df4=this['_commandWindow']['y']+this[_0x4581f6(0x1a6)][_0x4581f6(0x232)];return new Rectangle(_0x3612fa,_0x3a1df4,_0x4e0dd6,_0x32d12f);},VisuMZ[_0x709961(0x3db)]['Scene_Shop_buyWindowRect']=Scene_Shop[_0x709961(0x5ef)][_0x709961(0x23d)],Scene_Shop[_0x709961(0x5ef)]['buyWindowRect']=function(){const _0x501925=_0x709961;return this[_0x501925(0x289)]()?this[_0x501925(0x28e)]():VisuMZ['ItemsEquipsCore'][_0x501925(0x6f0)]['call'](this);},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x28e)]=function(){const _0x14a4a7=_0x709961,_0x3ded93=this[_0x14a4a7(0x1a6)]['y']+this[_0x14a4a7(0x1a6)][_0x14a4a7(0x232)],_0x1abdc0=Graphics['boxWidth']-this[_0x14a4a7(0x62f)](),_0x45034b=this[_0x14a4a7(0x5e0)]()-this['_commandWindow'][_0x14a4a7(0x232)],_0x599969=this['isRightInputMode']()?Graphics['boxWidth']-_0x1abdc0:0x0;return new Rectangle(_0x599969,_0x3ded93,_0x1abdc0,_0x45034b);},VisuMZ[_0x709961(0x3db)][_0x709961(0x1f6)]=Scene_Shop[_0x709961(0x5ef)][_0x709961(0x5fb)],Scene_Shop[_0x709961(0x5ef)][_0x709961(0x5fb)]=function(){const _0x8fe057=_0x709961;VisuMZ[_0x8fe057(0x3db)][_0x8fe057(0x1f6)]['call'](this),this['isUseModernControls']()&&this[_0x8fe057(0x38e)]();},VisuMZ[_0x709961(0x3db)][_0x709961(0x2ad)]=Scene_Shop['prototype'][_0x709961(0x549)],Scene_Shop[_0x709961(0x5ef)][_0x709961(0x549)]=function(){const _0x17f417=_0x709961;if(this[_0x17f417(0x289)]()){if(_0x17f417(0x5c0)==='ptTGt')return this[_0x17f417(0x507)]();else this['_cache_etypeIDs'][_0x2df66e['id']]['push'](_0x21f1f5);}else return VisuMZ[_0x17f417(0x3db)]['Scene_Shop_categoryWindowRect'][_0x17f417(0x376)](this);},Scene_Shop[_0x709961(0x5ef)]['categoryWindowRectItemsEquipsCore']=function(){const _0x1391a3=_0x709961,_0x40b9ae=this['_commandWindow']['y'],_0x4977fc=this[_0x1391a3(0x1a6)][_0x1391a3(0x4ca)],_0x1bdd5f=this[_0x1391a3(0x6ac)](0x1,!![]),_0x223b21=this['isRightInputMode']()?Graphics[_0x1391a3(0x628)]-_0x4977fc:0x0;return new Rectangle(_0x223b21,_0x40b9ae,_0x4977fc,_0x1bdd5f);},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x38e)]=function(){const _0x2963a8=_0x709961;delete this[_0x2963a8(0x5cd)][_0x2963a8(0x4c3)]['ok'],delete this[_0x2963a8(0x5cd)][_0x2963a8(0x4c3)][_0x2963a8(0x320)];},VisuMZ[_0x709961(0x3db)][_0x709961(0x64a)]=Scene_Shop[_0x709961(0x5ef)][_0x709961(0x618)],Scene_Shop[_0x709961(0x5ef)]['createSellWindow']=function(){const _0x5e2a3c=_0x709961;VisuMZ[_0x5e2a3c(0x3db)][_0x5e2a3c(0x64a)][_0x5e2a3c(0x376)](this),this['isUseItemsEquipsCoreUpdatedLayout']()&&this[_0x5e2a3c(0x3ee)]();},VisuMZ[_0x709961(0x3db)][_0x709961(0x19e)]=Scene_Shop[_0x709961(0x5ef)][_0x709961(0x513)],Scene_Shop[_0x709961(0x5ef)][_0x709961(0x513)]=function(){const _0x26412c=_0x709961;if(this['isUseItemsEquipsCoreUpdatedLayout']())return this['sellWindowRectItemsEquipsCore']();else{if('FpZEC'===_0x26412c(0x23c))return VisuMZ['ItemsEquipsCore'][_0x26412c(0x19e)][_0x26412c(0x376)](this);else _0x5cc281[_0x26412c(0x4ba)](_0xb417c7[_0x26412c(0x508)](_0x668d9));}},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x288)]=function(){const _0x40a7e7=_0x709961,_0x13e30d=this[_0x40a7e7(0x5cd)]['y']+this[_0x40a7e7(0x5cd)][_0x40a7e7(0x232)],_0xc7f6d5=Graphics[_0x40a7e7(0x628)]-this[_0x40a7e7(0x62f)](),_0x390f12=this[_0x40a7e7(0x5e0)]()-this[_0x40a7e7(0x5cd)][_0x40a7e7(0x232)],_0x274fab=this[_0x40a7e7(0x2ef)]()?Graphics[_0x40a7e7(0x628)]-_0xc7f6d5:0x0;return new Rectangle(_0x274fab,_0x13e30d,_0xc7f6d5,_0x390f12);},Scene_Shop[_0x709961(0x5ef)]['postCreateSellWindowItemsEquipsCore']=function(){const _0x2ebaf5=_0x709961;this[_0x2ebaf5(0x449)]['setStatusWindow'](this['_statusWindow']);},Scene_Shop['prototype']['statusWidth']=function(){const _0x24c2cb=_0x709961;return VisuMZ[_0x24c2cb(0x3db)]['Settings'][_0x24c2cb(0x281)]['Width'];},VisuMZ[_0x709961(0x3db)][_0x709961(0x1d8)]=Scene_Shop['prototype'][_0x709961(0x5c4)],Scene_Shop[_0x709961(0x5ef)][_0x709961(0x5c4)]=function(){const _0x5c692d=_0x709961;VisuMZ[_0x5c692d(0x3db)][_0x5c692d(0x1d8)][_0x5c692d(0x376)](this),this[_0x5c692d(0x289)]()&&this[_0x5c692d(0x633)][_0x5c692d(0x314)](),this[_0x5c692d(0x449)][_0x5c692d(0x317)]();},VisuMZ['ItemsEquipsCore'][_0x709961(0x358)]=Scene_Shop['prototype'][_0x709961(0x4cf)],Scene_Shop[_0x709961(0x5ef)]['commandBuy']=function(){const _0x466ff2=_0x709961;VisuMZ[_0x466ff2(0x3db)][_0x466ff2(0x358)][_0x466ff2(0x376)](this);if(this['isUseItemsEquipsCoreUpdatedLayout']()){if(_0x466ff2(0x37d)===_0x466ff2(0x629)){if(!this['active'])return![];if(!_0x238035[_0x466ff2(0x3db)][_0x466ff2(0x6b0)][_0x466ff2(0x6b4)][_0x466ff2(0x469)])return![];return!![];}else this[_0x466ff2(0x1d1)]();}},Scene_Shop['prototype'][_0x709961(0x1d1)]=function(){const _0xd327e7=_0x709961;this[_0xd327e7(0x5be)]=this[_0xd327e7(0x5be)]||0x0,this[_0xd327e7(0x6e8)][_0xd327e7(0x1de)](this[_0xd327e7(0x5be)]);},VisuMZ[_0x709961(0x3db)][_0x709961(0x4e7)]=Scene_Shop[_0x709961(0x5ef)][_0x709961(0x397)],Scene_Shop['prototype'][_0x709961(0x397)]=function(){const _0x9889f8=_0x709961;VisuMZ[_0x9889f8(0x3db)][_0x9889f8(0x4e7)][_0x9889f8(0x376)](this);if(this['isUseItemsEquipsCoreUpdatedLayout']()){if(_0x9889f8(0x33c)!==_0x9889f8(0x20b))this[_0x9889f8(0x3b5)]();else return!![];}if(this[_0x9889f8(0x6d8)]()){if(_0x9889f8(0x249)!==_0x9889f8(0x305))this['_categoryWindow'][_0x9889f8(0x1de)](0x0),this[_0x9889f8(0x55f)]();else return!!_0x1efd1c&&_0x163253[_0x9889f8(0x5fe)]===_0x4281f4(_0x595117['$1']);}},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x3b5)]=function(){const _0x3c579f=_0x709961;this[_0x3c579f(0x6e8)][_0x3c579f(0x5b0)](),this[_0x3c579f(0x1a6)][_0x3c579f(0x5b0)]();},VisuMZ[_0x709961(0x3db)][_0x709961(0x332)]=Scene_Shop[_0x709961(0x5ef)]['onBuyCancel'],Scene_Shop[_0x709961(0x5ef)][_0x709961(0x4f0)]=function(){const _0x4c7976=_0x709961;VisuMZ[_0x4c7976(0x3db)][_0x4c7976(0x332)][_0x4c7976(0x376)](this),this['isUseItemsEquipsCoreUpdatedLayout']()&&this['onBuyCancelItemsEquipsCore']();},Scene_Shop['prototype']['onBuyCancelItemsEquipsCore']=function(){const _0x36db1a=_0x709961;this['_buyWindowLastIndex']=this[_0x36db1a(0x6e8)][_0x36db1a(0x624)](),this[_0x36db1a(0x6e8)][_0x36db1a(0x314)](),this[_0x36db1a(0x6e8)]['deselect'](),this['_buyWindow']['smoothScrollTo'](0x0,0x0),this[_0x36db1a(0x633)]['show'](),this[_0x36db1a(0x50e)][_0x36db1a(0x5b0)]();},VisuMZ[_0x709961(0x3db)][_0x709961(0x285)]=Scene_Shop['prototype'][_0x709961(0x4ad)],Scene_Shop[_0x709961(0x5ef)]['onCategoryCancel']=function(){const _0x20d51a=_0x709961;VisuMZ['ItemsEquipsCore'][_0x20d51a(0x285)][_0x20d51a(0x376)](this),this[_0x20d51a(0x289)]()&&this[_0x20d51a(0x43b)]();},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x43b)]=function(){const _0x452b76=_0x709961;this[_0x452b76(0x6e8)][_0x452b76(0x314)](),this[_0x452b76(0x1a6)]['show']();},VisuMZ[_0x709961(0x3db)]['Scene_Shop_onBuyOk']=Scene_Shop[_0x709961(0x5ef)]['onBuyOk'],Scene_Shop[_0x709961(0x5ef)][_0x709961(0x4cd)]=function(){const _0x55eae7=_0x709961;$gameTemp[_0x55eae7(0x327)]=!![],VisuMZ[_0x55eae7(0x3db)][_0x55eae7(0x3a8)][_0x55eae7(0x376)](this),$gameTemp['_bypassProxy']=![],this['_item']=this[_0x55eae7(0x6e8)][_0x55eae7(0x24d)]();},VisuMZ['ItemsEquipsCore'][_0x709961(0x1af)]=Scene_Shop[_0x709961(0x5ef)][_0x709961(0x22b)],Scene_Shop[_0x709961(0x5ef)]['buyingPrice']=function(){const _0x290507=_0x709961;$gameTemp[_0x290507(0x327)]=!![],this[_0x290507(0x3c2)]=this[_0x290507(0x6e8)][_0x290507(0x24d)]();const _0x50042a=VisuMZ[_0x290507(0x3db)][_0x290507(0x1af)][_0x290507(0x376)](this);return $gameTemp['_bypassProxy']=![],this[_0x290507(0x3c2)]=this['_buyWindow'][_0x290507(0x24d)](),_0x50042a;},VisuMZ[_0x709961(0x3db)]['Scene_Shop_onSellOk']=Scene_Shop[_0x709961(0x5ef)][_0x709961(0x573)],Scene_Shop[_0x709961(0x5ef)][_0x709961(0x573)]=function(){const _0x284f2b=_0x709961;VisuMZ[_0x284f2b(0x3db)][_0x284f2b(0x57c)][_0x284f2b(0x376)](this),this[_0x284f2b(0x289)]()&&this[_0x284f2b(0x27a)]();},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x27a)]=function(){const _0x4bf399=_0x709961;this[_0x4bf399(0x5cd)]['show']();},VisuMZ[_0x709961(0x3db)][_0x709961(0x1c9)]=Scene_Shop[_0x709961(0x5ef)][_0x709961(0x226)],Scene_Shop['prototype']['onSellCancel']=function(){const _0x278097=_0x709961;VisuMZ[_0x278097(0x3db)][_0x278097(0x1c9)][_0x278097(0x376)](this);this[_0x278097(0x6d8)]()&&this[_0x278097(0x4ad)]();if(this[_0x278097(0x289)]()){if(_0x278097(0x3d1)!==_0x278097(0x348))this[_0x278097(0x50e)][_0x278097(0x5b0)]();else{const _0x4b6ceb='ELEMENT';if(this[_0x278097(0x3b8)][_0x4b6ceb])return this[_0x278097(0x3b8)][_0x4b6ceb];if(this['_item']['damage'][_0x278097(0x2de)]<=-0x1)return _0x37959f[_0x278097(0x3db)]['Settings'][_0x278097(0x281)][_0x278097(0x2cb)];else return this['_item'][_0x278097(0x553)][_0x278097(0x2de)]===0x0?_0x4d61d4[_0x278097(0x3db)][_0x278097(0x6b0)][_0x278097(0x281)][_0x278097(0x5d2)]:_0x254da5[_0x278097(0x664)][this['_item'][_0x278097(0x553)][_0x278097(0x2de)]];}}},Scene_Shop['prototype'][_0x709961(0x417)]=function(_0x14dccf){const _0x58e865=_0x709961,_0x451ce4=this['_item'];this[_0x58e865(0x3c2)]=_0x14dccf;const _0x53bd67=this[_0x58e865(0x270)]();return this[_0x58e865(0x3c2)]=_0x451ce4,_0x53bd67;},VisuMZ[_0x709961(0x3db)][_0x709961(0x54c)]=Scene_Shop['prototype'][_0x709961(0x270)],Scene_Shop[_0x709961(0x5ef)][_0x709961(0x270)]=function(){const _0x17c0ec=_0x709961;let _0x3a1202=this[_0x17c0ec(0x3ff)]();const _0x56e24c=this[_0x17c0ec(0x3c2)];return _0x3a1202=VisuMZ['ItemsEquipsCore']['Settings'][_0x17c0ec(0x300)][_0x17c0ec(0x4fb)][_0x17c0ec(0x376)](this,_0x56e24c,_0x3a1202),_0x3a1202;},Scene_Shop[_0x709961(0x5ef)]['determineBaseSellingPrice']=function(){const _0x45b38f=_0x709961;let _0x5beef1=this[_0x45b38f(0x3c2)]['price'];if(!this[_0x45b38f(0x3c2)])return 0x0;else{if(this[_0x45b38f(0x3c2)][_0x45b38f(0x1e9)][_0x45b38f(0x1ed)](/<JS SELL PRICE>\s*([\s\S]*)\s*<\/JS SELL PRICE>/i)){const _0x4665f9=String(RegExp['$1']);window['item']=this[_0x45b38f(0x3c2)],window['price']=_0x5beef1*this['sellPriceRate']();try{if(_0x45b38f(0x4e4)===_0x45b38f(0x4e4))eval(_0x4665f9);else{const _0x35b4b0=_0x3984fa[_0x45b38f(0x692)]('['+_0x3fd571['$1'][_0x45b38f(0x1ed)](/\d+/g)+']');for(const _0x285bfd of _0x35b4b0){if(!_0x18177f['value'](_0x285bfd))return![];}return!![];}}catch(_0xcf346){if($gameTemp['isPlaytest']())console[_0x45b38f(0x4df)](_0xcf346);}let _0x1caf8d=window[_0x45b38f(0x518)];window[_0x45b38f(0x24d)]=undefined,window['price']=undefined;if(isNaN(_0x1caf8d))_0x1caf8d=0x0;return Math[_0x45b38f(0x4e5)](_0x1caf8d);}else{if(this['_item'][_0x45b38f(0x1e9)][_0x45b38f(0x1ed)](/<SELL PRICE:[ ](\d+)>/i)){if(_0x45b38f(0x427)!==_0x45b38f(0x427)){const _0x27aca0=_0x45b38f(0x5fa);if(this[_0x45b38f(0x3b8)][_0x27aca0])return this['_customItemInfo'][_0x27aca0];let _0x53bcf7='';return _0x53bcf7+=_0x45b38f(0x367)['format'](this[_0x45b38f(0x6f3)][_0x45b38f(0x5b1)]),_0x53bcf7;}else return parseInt(RegExp['$1']);}else return Math['floor'](this['baseSellingPrice']());}}},Scene_Shop[_0x709961(0x5ef)]['baseSellingPrice']=function(){const _0x84c275=_0x709961;return this[_0x84c275(0x3c2)]['price']*this[_0x84c275(0x590)]();},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x590)]=function(){const _0x4a376d=_0x709961;return VisuMZ[_0x4a376d(0x3db)][_0x4a376d(0x6b0)][_0x4a376d(0x300)][_0x4a376d(0x254)];},Scene_Shop[_0x709961(0x5ef)]['buttonAssistItemListRequirement']=function(){const _0x720a55=_0x709961;if(!this[_0x720a55(0x4fa)]())return![];if(!this[_0x720a55(0x6d8)]())return![];if(!this[_0x720a55(0x449)])return![];if(!this['_sellWindow'][_0x720a55(0x3bd)])return![];return this[_0x720a55(0x4fa)]()&&this['isUseModernControls']();},Scene_Shop[_0x709961(0x5ef)]['buttonAssistKey1']=function(){const _0x27722a=_0x709961;if(this[_0x27722a(0x484)]()){if(this[_0x27722a(0x449)]['maxCols']()===0x1){if(_0x27722a(0x3c7)!=='eHTWG')return TextManager[_0x27722a(0x4bd)](_0x27722a(0x316),_0x27722a(0x4b9));else{const _0x2b7959=this[_0x27722a(0x62f)](),_0x22f8ff=this[_0x27722a(0x5e0)]()-this[_0x27722a(0x1a6)][_0x27722a(0x232)],_0x1d5cda=this[_0x27722a(0x2ef)]()?0x0:_0x56d12d[_0x27722a(0x628)]-_0x2b7959,_0x286b74=this['_commandWindow']['y']+this[_0x27722a(0x1a6)][_0x27722a(0x232)];return new _0x25752c(_0x1d5cda,_0x286b74,_0x2b7959,_0x22f8ff);}}else return TextManager[_0x27722a(0x4bd)](_0x27722a(0x277),_0x27722a(0x5af));}else{if(this[_0x27722a(0x502)]&&this[_0x27722a(0x502)][_0x27722a(0x3bd)]){if(_0x27722a(0x438)!==_0x27722a(0x438)){const _0x83011e=_0x5179bc(_0x500d78['$1'])[_0x27722a(0x617)](/[\r\n]+/);for(const _0x33744f of _0x83011e){if(_0x33744f[_0x27722a(0x1ed)](/(.*):[ ](.*)/i)){const _0x43a157=_0x2b0185(_0x4bff24['$1'])[_0x27722a(0x45c)]()[_0x27722a(0x3c4)](),_0x5f3fe1=_0x22d1db(_0x459312['$2'])[_0x27722a(0x3c4)]();this[_0x27722a(0x3b8)][_0x43a157]=_0x5f3fe1;}}}else return TextManager['getInputMultiButtonStrings'](_0x27722a(0x316),_0x27722a(0x4b9));}}return Scene_MenuBase[_0x27722a(0x5ef)][_0x27722a(0x3a2)][_0x27722a(0x376)](this);},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x5cc)]=function(){const _0xba843c=_0x709961;if(this[_0xba843c(0x502)]&&this[_0xba843c(0x502)][_0xba843c(0x3bd)])return TextManager[_0xba843c(0x4bd)]('up','down');return Scene_MenuBase['prototype'][_0xba843c(0x5cc)][_0xba843c(0x376)](this);},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x211)]=function(){const _0x395cca=_0x709961;if(this[_0x395cca(0x484)]()){if('NiVhw'!=='NiVhw')_0x39768c[_0x395cca(0x5c1)](_0x395cca(0x5af))&&_0x1b99e4[_0x395cca(0x40b)](_0x395cca(0x5ce))&&this[_0x395cca(0x222)](),_0x49a62d['isTriggered'](_0x395cca(0x277))&&_0x566158[_0x395cca(0x40b)](_0x395cca(0x5ce))&&this['cursorPageup']();else return VisuMZ['ItemsEquipsCore']['Settings'][_0x395cca(0x309)]['buttonAssistCategory'];}else{if(this['_numberWindow']&&this[_0x395cca(0x502)][_0x395cca(0x3bd)]){if(_0x395cca(0x4d5)!==_0x395cca(0x4d5)){if(!this[_0x395cca(0x3af)](_0x47a21b,this[_0x395cca(0x673)]()[_0x1c8835]))return;if(_0x5464e0){const _0x31ad84=_0x308a6c[_0x395cca(0x323)](_0x514dd1);if(!_0x31ad84[_0x395cca(0x3bb)](this['equipSlots']()[_0x4efdd3]))return;}this[_0x395cca(0x5fd)][_0x5cd981][_0x395cca(0x299)](_0x124542);if(_0x890cd2[_0x395cca(0x3db)][_0x395cca(0x546)](_0x5edc3b)){const _0x3fdc24=_0x23f08b[_0x395cca(0x3db)][_0x395cca(0x6b0)][_0x395cca(0x6b4)]['CursedTextPopup']||'',_0x5274a1=this[_0x395cca(0x5a7)](),_0x443791='\x5cI[%1]'[_0x395cca(0x60c)](_0x2a3c18[_0x395cca(0x4a7)]),_0x56ae36=_0x19b0a8[_0x395cca(0x5a7)]||'';let _0x249015=_0x3fdc24['format'](_0x5274a1,_0x443791,_0x56ae36);if(_0x249015[_0x395cca(0x321)]>0x0)_0x4819dc(_0x249015);}this[_0x395cca(0x349)]();}else return VisuMZ[_0x395cca(0x3db)]['Settings'][_0x395cca(0x300)][_0x395cca(0x200)];}}return Scene_MenuBase['prototype'][_0x395cca(0x211)][_0x395cca(0x376)](this);},Scene_Shop['prototype'][_0x709961(0x39a)]=function(){const _0x2b86ec=_0x709961;if(this[_0x2b86ec(0x502)]&&this[_0x2b86ec(0x502)]['active'])return'fJmXh'!==_0x2b86ec(0x2f0)?this[_0x2b86ec(0x237)](_0xe5034b[_0x2b86ec(0x4f2)]):VisuMZ['ItemsEquipsCore'][_0x2b86ec(0x6b0)]['ShopScene'][_0x2b86ec(0x420)];return Scene_MenuBase['prototype'][_0x2b86ec(0x39a)][_0x2b86ec(0x376)](this);},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x4dd)]=function(){const _0x312f83=_0x709961;if(!SceneManager['isSceneShop']())return;const _0x556a3b=VisuMZ[_0x312f83(0x3db)]['Settings'][_0x312f83(0x300)];if(_0x556a3b['SwitchBuy']){if('uEsKx'!==_0x312f83(0x488))return _0xadc135[_0x312f83(0x32e)];else $gameSwitches[_0x312f83(0x32c)](_0x556a3b[_0x312f83(0x4a9)],![]);}_0x556a3b[_0x312f83(0x4a5)]&&('zaWYq'===_0x312f83(0x65f)?_0x464719=_0x23a592[_0x312f83(0x24d)]:$gameSwitches[_0x312f83(0x32c)](_0x556a3b[_0x312f83(0x4a5)],![]));},VisuMZ[_0x709961(0x3db)][_0x709961(0x4fe)]=Scene_Shop['prototype'][_0x709961(0x42c)],Scene_Shop[_0x709961(0x5ef)][_0x709961(0x42c)]=function(_0xb82a3b){const _0x20ed2b=_0x709961;VisuMZ[_0x20ed2b(0x3db)][_0x20ed2b(0x4fe)][_0x20ed2b(0x376)](this,_0xb82a3b),this[_0x20ed2b(0x418)](this[_0x20ed2b(0x3c2)],_0xb82a3b);if(_0xb82a3b<=0x0)return;const _0x5c8d7c=VisuMZ['ItemsEquipsCore']['Settings'][_0x20ed2b(0x300)];_0x5c8d7c[_0x20ed2b(0x4a9)]&&$gameSwitches[_0x20ed2b(0x32c)](_0x5c8d7c[_0x20ed2b(0x4a9)],!![]),this[_0x20ed2b(0x6e8)]['refresh'](),this[_0x20ed2b(0x449)][_0x20ed2b(0x349)]();},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x418)]=function(_0x4397d2,_0xe3848d){const _0x39742b=_0x709961;this[_0x39742b(0x509)](_0x4397d2,_0xe3848d),$gameParty[_0x39742b(0x28c)](_0x4397d2,_0xe3848d),$gameParty[_0x39742b(0x64b)](_0xe3848d*this['buyingPrice']());},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x509)]=function(_0x25bd99,_0x59a81f){const _0x434f9c=_0x709961;if(!_0x25bd99)return;if(!_0x59a81f)return;const _0x5abbe1=VisuMZ['ItemsEquipsCore'][_0x434f9c(0x4ae)],_0x121653=_0x25bd99[_0x434f9c(0x1e9)]||'';if(_0x121653['match'](_0x5abbe1[_0x434f9c(0x352)])){const _0x35d73c=String(RegExp['$1'])[_0x434f9c(0x617)](',')['map'](_0x2d8d57=>Number(_0x2d8d57));for(const _0x2641ae of _0x35d73c){$gameSwitches[_0x434f9c(0x32c)](_0x2641ae,!![]);}}if(_0x121653[_0x434f9c(0x1ed)](_0x5abbe1[_0x434f9c(0x5fc)])){const _0x165af5=String(RegExp['$1'])[_0x434f9c(0x617)](',')['map'](_0x43fa6a=>Number(_0x43fa6a));for(const _0x592d8d of _0x165af5){$gameSwitches[_0x434f9c(0x32c)](_0x592d8d,![]);}}},VisuMZ[_0x709961(0x3db)][_0x709961(0x3d3)]=Scene_Shop[_0x709961(0x5ef)][_0x709961(0x3c0)],Scene_Shop[_0x709961(0x5ef)][_0x709961(0x3c0)]=function(_0x53177b){const _0x40fa59=_0x709961;VisuMZ[_0x40fa59(0x3db)][_0x40fa59(0x3d3)][_0x40fa59(0x376)](this,_0x53177b),this[_0x40fa59(0x39f)](this['_item'],_0x53177b);if(_0x53177b<=0x0)return;const _0x1cd075=VisuMZ[_0x40fa59(0x3db)][_0x40fa59(0x6b0)][_0x40fa59(0x300)];if(_0x1cd075['SwitchBuy']){if(_0x40fa59(0x2a4)==='OsZdK'){this[_0x40fa59(0x56a)]=![];if(this[_0x40fa59(0x565)]()){const _0x1e65bc=this[_0x40fa59(0x624)](),_0x2d73ee=this[_0x40fa59(0x2bb)]();_0x2d73ee>=0x0&&_0x2d73ee!==this[_0x40fa59(0x624)]()&&this[_0x40fa59(0x2a0)](_0x2d73ee),_0xbb612c&&this[_0x40fa59(0x624)]()!==_0x1e65bc&&this['playCursorSound']();}}else $gameSwitches[_0x40fa59(0x32c)](_0x1cd075[_0x40fa59(0x4a5)],!![]);}this[_0x40fa59(0x6e8)][_0x40fa59(0x349)](),this[_0x40fa59(0x449)][_0x40fa59(0x349)]();},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x39f)]=function(_0x3c79ee,_0x47a2e7){const _0x4cbac0=_0x709961;this['processShopCondListingOnSellItem'](_0x3c79ee,_0x47a2e7),$gameParty[_0x4cbac0(0x2cc)](_0x3c79ee,_0x47a2e7),$gameParty[_0x4cbac0(0x37e)](_0x47a2e7*this['sellingPrice']());},Scene_Shop[_0x709961(0x5ef)][_0x709961(0x22e)]=function(_0x56fc25,_0x5185d0){const _0x10ee98=_0x709961;if(!_0x56fc25)return;if(!_0x5185d0)return;const _0x321d94=VisuMZ[_0x10ee98(0x3db)][_0x10ee98(0x4ae)],_0x1a9111=_0x56fc25[_0x10ee98(0x1e9)]||'';if(_0x1a9111[_0x10ee98(0x1ed)](_0x321d94['SellTurnSwitchOn'])){const _0x553984=String(RegExp['$1'])[_0x10ee98(0x617)](',')[_0x10ee98(0x1ac)](_0x298669=>Number(_0x298669));for(const _0x5d1729 of _0x553984){if('aghXB'!=='aghXB')return!this['nonRemovableEtypes']()[_0x10ee98(0x3bb)](this[_0x10ee98(0x5fe)]());else $gameSwitches[_0x10ee98(0x32c)](_0x5d1729,!![]);}}if(_0x1a9111[_0x10ee98(0x1ed)](_0x321d94[_0x10ee98(0x642)])){if(_0x10ee98(0x5f8)===_0x10ee98(0x4c1))this[_0x10ee98(0x5be)]=this[_0x10ee98(0x6e8)]['index'](),this['_buyWindow'][_0x10ee98(0x314)](),this[_0x10ee98(0x6e8)][_0x10ee98(0x6cb)](),this['_buyWindow'][_0x10ee98(0x53c)](0x0,0x0),this[_0x10ee98(0x633)][_0x10ee98(0x314)](),this['_dummyWindow'][_0x10ee98(0x5b0)]();else{const _0x437169=String(RegExp['$1'])[_0x10ee98(0x617)](',')[_0x10ee98(0x1ac)](_0x4c75c7=>Number(_0x4c75c7));for(const _0x2d903f of _0x437169){$gameSwitches[_0x10ee98(0x32c)](_0x2d903f,![]);}}}};function Sprite_NewLabel(){const _0x3ffd83=_0x709961;this[_0x3ffd83(0x527)](...arguments);}function _0x2c86(_0x337ec8,_0x315b81){const _0x5bde49=_0x5bde();return _0x2c86=function(_0x2c86ef,_0x1fd6ff){_0x2c86ef=_0x2c86ef-0x19c;let _0x485bdb=_0x5bde49[_0x2c86ef];return _0x485bdb;},_0x2c86(_0x337ec8,_0x315b81);}function _0x5bde(){const _0x5b7d28=['onCategoryOk','TegKy','createItemWindow','?????','getMatchingInitEquip','\x5cb%1\x5cb','isCursorMovable','test','ykEWB','goldWindowRectItemsEquipsCore','NeEWA','_doubleTouch','CmdIconCancel','Step2Start','mekbR','start','setText','bvsEW','Scene_Equip_onActorChange','isNewItem','onSellOk','EFFECT_RECOVER_HP','drawItemSpeed','isEquipTypeSealed','ARRAYNUM','CommandAddClear','mgjVr','getPurifyTransformation','setItem','Scene_Shop_onSellOk','setTopRow','cursorPageup','drawItemDamageAmount','random','Actors','abIKw','LabelApply','BatchShop','isShiftShortcutKeyForRemove','sbwOX','drawActorCharacter','NoChangeMarker','LabelDamageTP','Scene_Shop_helpWindowRect','getItemEffectsMpRecoveryLabel','EFFECT_REMOVE_DEBUFF','registerCommand','mainFontSize','needsNewTempActor','sellPriceRate','Scene_Shop_prepare','Window_Selectable_initialize','KNpkW','NgRtj','gIsfS','drawItemEffectsTpDamage','Translucent','foreground','SpeedNeg1999','fontFace','initShopTrackingData','addCancelCommand','zwzEQ','isClearCommandEnabled','statusWindowRect','clearCmdDesc','vYjbG','bestEquipItem','AllArmors','updateChangedSlots','equipCmdDesc','meetsItemConditions','name','mainCommandWidth','UcidE','Game_Party_initialize','isCancelled','getItemEffects','drawNewLabelText','Scene_Shop','pagedown','hide','gainTP','_classIDs','DWPsr','_paramPlus','getItemDamageAmountLabelBattleCore','CONSUMABLE','Scene_Item_createItemWindow','ItemQuantityFmt','vPPgO','gGhxW','CmdIconOptimize','CtVFD','WYOmi','_buyWindowLastIndex','Scene_Equip_slotWindowRect','ptTGt','isTriggered','ARMOR','canConsumeItem','activateSellWindow','getItemEffectsAddedStatesBuffsLabel','AacgG','isTroopArtifact','Window_EquipItem_includes','drawing','luk','colSpacing','buttonAssistKey2','_categoryWindow','shift','_shopTrackingData','playCursorSound','SYsbK','ElementNone','Game_Party_gainItem','categories','FontFace','fill','uPKtC','GLvfL','getEtypeIdWithName','_getClassRequirements','postCreateSlotWindowItemsEquipsCore','DjWPZ','Parse_Notetags_Prices','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','10435932VCEaOh','mainAreaHeight','drawItemEffectsHpDamage','PurifyParty','lIeUg','createStatusWindow','weaponTypes','LabelDamageMP','getItemEffectsTpRecoveryLabel','addWindow','ITEMS_EQUIPS_CORE','placeNewLabel','BmNgN','currentExt','drawItemEffectsMpDamage','normalColor','prototype','refreshActor','vjVmm','limitedPageUpDownSceneCheck','makeItemList','ZXxvC','max','NotConsumable','FieldUsable','gJrEF','createCommandWindow','TP\x20RECOVERY','createCategoryWindow','BuyTurnSwitchOff','_equips','etypeId','wpEOl','isSellCommandEnabled','Step3End','drawItem','OTnqU','ktmun','DOcTD','refreshCursor','eWiCK','getItemEffectsAddedStatesBuffsText','qQJMQ','(+%1)','blt','format','meetsItemConditionsNotetags','buttonAssistText3','helpAreaHeight','StatusWindowWidth','aSpNN','aiUkS','MP\x20RECOVERY','ATK','VisuMZ_0_CoreEngine','_forcedSlots','split','createSellWindow','RemoveEquipText','itemWindowRectItemsEquipsCore','REqdK','changeTextColor','_checkEquipRequirements','processCursorMove','processDrawIcon','DrawFaceJS','+%1%','ttnYn','drawParamText','index','anyEmptyEquipSlotsOfSameEtype','commandName','qjSbj','boxWidth','dxMva','isSceneShop','eSbTk','drawText','drawItemOccasion','meetsClassRequirements','statusWidth','_scrollDuration','ItemQuantityFontSize','ZtzEK','_statusWindow','getItemRepeatsText','_skillIDs','refreshActorEquipSlotsIfUpdated','textColor','Game_Actor_paramPlus','isClearCommandAdded','params','cdjPG','lbZrd','mainFontFace','LabelElement','afUvP','CmdIconEquip','onActorChange','SellTurnSwitchOff','repeats','ouUDr','cFXVW','hasItem','Game_Party_setupBattleTestItems_artifact','buttonAssistKey3','cursorUp','Scene_Shop_createSellWindow','addShopTrackingGoldBuy','TP\x20DAMAGE','\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20enabled\x20=\x20true;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20enabled;\x0a\x20\x20\x20\x20\x20\x20\x20\x20','getItemEffectsTpDamageText','createSlotWindow','930408qXajQA','VisuMZ_1_MainMenuCore','Eeohh','update','ConvertParams','categoryStyle','2894288tvzAEX','QPhfe','BackRectColor','Parse_Notetags_ParamJS','onSlotOkAutoSelect','loseItem','USER\x20TP\x20GAIN','possession','activateItemWindow','QvkQG','EFFECT_REMOVE_STATE','_calculatingJSParameters','parameters','ZoBmU','elements','getItemIdWithName','isPartyArtifact','LabelRecoverHP','PqhUF','rateMP','textSizeEx','ifQty','bLHpB','czBmw','AllItems','dataId','RBdDE','YEAbt','filter','equips','Window_ItemList_updateHelp','CmdCancelRename','isArtifact','troopArtifactIDs','setNewItem','EquipParams','isWeapon','helpWindowRect','LabelRemove','defaultItemMax','processCursorMoveModernControls','actor','hhmHx','OffsetY','ScopeRandomAllies','oDCHZ','flatMP','Scene_Shop_numberWindowRect','qxKzj','meetsEquipRequirement','EFFECT_ADD_DEBUFF','LXoLc','Scene_Item','emNSQ','values','fillRect','KeyItems','placeItemNewLabel','commandNameWindowDrawText','AbUAu','parse','MRAZT','artifacts','_purchaseOnly','getTextColor','systemColor','isEquipChangeOk','getItemDamageElementLabel','drawParamName','_newLabelOpacityChange','sortListItemScene','selfTP','SPEED','meetsEquipRequirements','initEquips','setShopStatusWindowMode','LJHNs','Step2End','WgsyQ','consumable','fJypc','getItemsEquipsCoreBackColor2','DNdYr','zVOgc','categoryStyleCheck','processHandling','calcWindowHeight','isPageChangeRequested','Game_Actor_discardEquip','TPIkm','Settings','clearNewItem','Window_EquipCommand_initialize','ARRAYSTR','EquipScene','LMfEW','setStatusWindow','lBYgR','version','wqGZk','drawTextEx','CoosO','isGoodShown','UoqaT','atk','Scene_Equip_helpWindowRect','Window_EquipItem_isEnabled','_scene','EFFECT_RECOVER_MP','XZDHg','HToGo','HP\x20RECOVERY','×%1','Scene_Shop_statusWindowRect','EvhLO','isEquipCommandEnabled','innerHeight','deselect','adjustHiddenShownGoods','Damage\x20Formula\x20Error\x20for\x20%1','dkcII','initNewLabelSprites','Game_Actor_isEquipChangeOk','removeDebuff','ckpAf','MenuPortraits','currentClass','XUENO','YXocE','WEAPON','isUseModernControls','Scene_Equip_commandWindowRect','changeBuff','getItemScopeText','category','qUbdM','iwVhL','deactivate','setHp','SetupProxyItemGroup','paramPlus','getItemDamageElementText','exit','CmdHideDisabled','CousE','AlwaysUsable','_buyWindow','drawItemSuccessRate','createTempActorEquips','getItemEffectsMpDamageText','drawCustomShopGraphicLoad','getItemDamageAmountLabelOriginal','zoRZq','drawItemData','Scene_Shop_buyWindowRect','getItemDamageAmountText','KeyItemProtect','_itemData','_newLabelSprites','dcVCF','KUGAm','Scene_Shop_sellWindowRect','#%1','createNewLabelSprite','getShopTrackingData','Scene_Equip_statusWindowRect','Zshug','meetsShopListingConditions','IncludeShopItem','_commandWindow','DUUwL','vdYQV','znfKy','Scene_Boot_onDatabaseLoaded','uhkOr','map','LabelSpeed','Window_ShopCommand_initialize','Scene_Shop_buyingPrice','postCreateItemWindowModernControls','glwjf','Scene_Equip_create','eubfC','onSlotOk','Scene_Equip_itemWindowRect','Step3Start','Whitelist','BuJzT','sell','yzvjn','numberWindowRectItemsEquipsCore','ParseItemNotetags','_allowArtifactTraitObjects','commandStyle','MP\x20DAMAGE','resetTextColor','onTouchCancel','JSON','previousActor','currentSymbol','background','Scope1','pVYgA','Parse_Notetags_Batch','Scene_Shop_onSellCancel','Speed1','addCommand','allMembers','Scene_Shop_goldWindowRect','updateCommandNameWindow','cursorDown','AnyGJ','commandBuyItemsEquipsCore','drawItemEffectsSelfTpGain','removeState','gold','changeEquipBase','onTouchSelectModernControls','nntEd','Scene_Shop_activateSellWindow','gaugeBackColor','addItemCategories','def','bMTmr','PLjzr','smoothSelect','helpDescriptionText','Window_Selectable_refresh','traitObjects','tyTdZ','getItemSuccessRateLabel','BAROq','Scene_Item_itemWindowRect','wbBQw','BattleUsable','Scope%1','note','buffIconIndex','6453895XqFxby','maxItemAmount','match','isHoverEnabled','IzTQr','getShopTrackingItemBuy','getMenuImage','clearEquipments','commandWindowRectItemsEquipsCore','DrawEquipData','drawItemActorMenuImage','Scene_Shop_createCategoryWindow','visible','hitType','itemWindowRect','getItemEffectsTpDamageLabel','maxItems','HP\x20DAMAGE','KMKtB','FadeLimit','createBitmap','buttonAssistSmallIncrement','isOptimizeCommandEnabled','isClearEquipOk','vVYQB','lwcRV','IconSet','ACjcH','SetupArtifactItemIDs','isBattleTest','getItemEffectsRemovedStatesBuffsLabel','Window_ItemCategory_setItemWindow','vSEIg','hideDisabledCommands','WzaVQ','itemHasEquipLimit','ceil','addState','buttonAssistText1','lMfqB','maxBattleMembers','_weaponIDs','getSkillIdWithName','_shopStatusMenuMode','some','52602axNNVH','optimizeCmdDesc','PurifyActors','pop','mmp','16805390SHuCGx','EFFECT_ADD_STATE','54TxPEdD','icon','DrawParamJS','cursorPagedown','jMljf','innerWidth','Game_BattlerBase_param','onSellCancel','Scene_Item_categoryWindowRect','STRUCT','FontSize','canShiftRemoveEquipment','buyingPrice','_categoryNameWindow','hasOwnProperty','processShopCondListingOnSellItem','aJisa','isEquipCommandAdded','IVMDe','height','QQwYN','lCBDk','Game_Actor_tradeItemWithParty','onSlotCancel','isEquipWtypeOk','HmycV','isKeyItem','qAmOD','ParseClassNotetags','FpZEC','buyWindowRect','maxmp','paramPlusItemsEquipsCoreCustomJS','getEtypeIDsCache','status','AllWeapons','newLabelEnabled','drawItemRepeats','PkAry','formula','FBMdh','addBuyCommand','nzyOb','getItemEffectsSelfTpGainLabel','isEnabled','damageColor','item','proxyItem','MaxHP','getItemHitTypeText','IAHRp','equipSlots','Speed2000','SellPriceRate','optimizeEquipments','create','isPurifyItemSwapOk','NkYQO','Game_Party_gainItem_artifact','drawIcon','_goodsCount','windowPadding','commandNameWindowDrawBackground','UWgkE','XmZNL','adjustItemWidthByStatus','REbZo','_bypassNewLabel','_allowArtifactParamBase','MbYiX','XyTMd','onBuyCancelItemsEquipsCore','equipAdjustHpMp','drawItemCost','armor-%1','UfIEg','VisuMZ_2_WeaponSwapSystem','LUK','RegularItems','ShopMenuStatusStandard','Game_Actor_changeEquip','sellingPrice','addChild','Scene_Equip_commandEquip','onMenuImageLoad','changeEquip','_category','NIrAs','pageup','getWeaponIdWithName','removeBuff','onSellOkItemsEquipsCore','itemTextAlign','OMjfj','paramValueFontSize','OCCASION','isRepeated','updateCategoryNameWindow','StatusWindow','ejvPa','ExtDisplayedParams','round','Scene_Shop_onCategoryCancel','Scene_Load_reloadMapIfUpdated','prepareNextScene','sellWindowRectItemsEquipsCore','isUseItemsEquipsCoreUpdatedLayout','playEquip','_cache_etypeIDs','addShopTrackingItemBuy','Scene_ItemBase_activateItemWindow','buyWindowRectItemsEquipsCore','auto','nonRemovableEtypes','addItemCategory','CommandAddOptimize','members','currencyUnit','Window_ItemList_item','Parse_Notetags_Category','\x5cI[%1]%2','powerDownColor','setObject','categoryList','Categories','REPEAT','paramValueByName','Parse_Notetags_EnableJS','mxvmC','select','translucentOpacity','characterName','flatHP','qLdHb','gainItem','Game_Actor_artifact','vTiqR','aAOfq','clearNewLabelFromItem','HiddenItemB','Scene_Shop_create','playBuzzerSound','Scene_Shop_categoryWindowRect','ScopeAllyOrEnemy','drawActorParamDifference','edoth','drawItemEffectsTpRecovery','DkCoo','vuHSL','isShowNew','nMgpv','hVDzX','commandStyleCheck','_buttonAssistWindow','Remove\x20all\x20available\x20equipment.','isArray','hitIndex','qgavq','Scene_Shop_commandWindowRect','goodsToItem','setupBattleTestItems','OfcmW','setHelpWindowItem','drawItemKeyData','_helpWindow','Window_ItemList_makeItemList','getItemColor','object','getItemEffectsHpDamageLabel','setHandler','equipTypes','prepareRefreshItemsEquipsCoreLayout','ElementWeapon','addShopTrackingItemSell','user','kgxWR','mpRate','min','_bypassReleaseUnequippableItemsItemsEquipsCore','geUpdatedLayoutStatusWidth','Game_Party_numItems','Icon','processCursorHomeEndTrigger','SetupProxyItemGroups','sUqkT','fontSizeRatio','nSPrb','_etypeIDs','Step1Start','prepare','setItemDelay','elementId','getItemDamageAmountLabel','YygoU','uiInputPosition','getItemQuantityText','aPwhA','YnQFQ','jRFQy','armors','MDF','setupItemDamageTempActors','equipSlotIndex','iconHeight','actorParams','_itemWindow','zaKLt','hideAdditionalSprites','isRightInputMode','fJmXh','getItemConsumableText','CMjFR','isItem','localeCompare','drawItemStyleIconText','cSJKJ','processCursorSpecialCheckModernControls','PgAyk','slotWindowRect','addEquipCommand','helpAreaTop','hTiXT','Pwcog','_goods','reloadMapIfUpdated','ShopScene','Window_ShopStatus_setItem','smallParamFontSize','UfqAH','LabelConsume','kObNN','ZXFCa','param','lCNfD','ItemScene','contents','ActorResetEquipSlots','ELnbg','inBattle','isMainMenuCoreMenuImageOptionAvailable','hraYv','Scene_Item_helpWindowRect','getItemEffectsMpRecoveryText','addStateBuffChanges','bzvIJ','show','LayoutStyle','left','updateHelp','SwitchID','MdLfQ','BFDre','mainAreaTop','drawItemScope','drawItemQuantity','xYpiC','getDamageStyle','cancel','length','FaglX','getEtypeIDs','Pick\x20and\x20choose\x20equipment\x20to\x20change.','weapon','Scene_Equip_onSlotOk','_bypassProxy','every','bnupq','down','paintOpacity','setValue','getInputButtonString','uiHelpPosition','iEKEl','hWcvX','getItemEffectsHpDamageText','Scene_Shop_onBuyCancel','drawNewLabelIcon','forceResetEquipSlots','forceChangeEquip','drawItemConsumable','value','MHstG','getShopTrackingItem','setHelpWindow','OffsetX','ctrje','optKeyItemsNumber','concat','IKyDk','makeDeepCopy','byFjv','_tempActor','XJmHG','commandEquip','iKNka','setItemWindow','uJCYe','Orefy','refresh','RegExp','postCreateItemsEquipsCore','scope','CmdTextAlign','remove','allowCreateStatusWindow','process_VisuMZ_ItemsEquipsCore_EquipSlots','_newLabelOpacityUpperLimit','BuyTurnSwitchOn','drawRemoveItem','FontColor','Parse_Notetags_ParamValues','isSoleArmorType','iconWidth','Scene_Shop_commandBuy','partyArtifacts','isCommandEnabled','cursorRight','loadSystem','Game_Actor_forceChangeEquip','powerUpColor','WNSAE','getShopTrackingGoldSell','lineHeight','getItemEffectsTpRecoveryText','ItemSceneAdjustItemList','itemAt','prepareItemCustomData','prepareNewEquipSlotsOnLoad','+%1','yyHEm','Scene_Item_createCategoryWindow','GpXHP','discardEquip','New','getProxyItem','tpGain','revertGlobalNamespaceVariables','Window_ItemList_maxCols','clamp','DrawBackRect','TTLQl','hhnGi','createCategoryNameWindow','call','refreshItemsEquipsCoreNoMenuImage','occasion','Occasion%1','EQUIP_DELAY_MS','mXAVR','Game_BattlerBase_canEquip_artifact','kHrRw','addShopTrackingGoldSell','sOPDc','DAMAGE\x20MULTIPLIER','MAT','onTouchSelect','Igklo','GAUUC','actorId','helpWindowRectItemsEquipsCore','nGSKy','getItemSpeedLabel','_resetFontColor','FNcCi','isPlaytest','Game_BattlerBase_paramPlus_artifact','buttonAssistSlotWindowShift','postCreateCategoryWindowItemsEquipsCore','iLJzv','drawUpdatedParamValueDiff','DVOkn','MPqEO','znjCk','HQIGy','rateHP','ItemMenuStatusRect','commandSell','artifactIDs','zvDYB','buttonAssistText2','vJmPz','removeStateBuffChanges','isUseParamNamesWithIcons','wqbJG','onSellItem','addClearCommand','NldCE','buttonAssistKey1','NeverUsable','YqGJO','replace','jtCXZ','DamageType%1','Scene_Shop_onBuyOk','ScopeRandomEnemies','zRmHL','value1','xEffl','processShiftRemoveShortcut','Type','tradeItemWithParty','MultiplierStandard','Game_Actor_equips_artifacts','getItemOccasionText','isArmor','HZBqH','commandSellItemsEquipsCore','yoktL','convertInitEquipsToItems','_customItemInfo','goldWindowRect','buttonAssistRemove','includes','_actor','active','iconText','ParseArmorNotetags','doSell','isOptimizeEquipOk','_item','_slotId','trim','getArmorIdWithName','checkShiftRemoveShortcut','pFIUd','ActorChangeEquipSlots','getItemConsumableLabel','Window_Selectable_setHelpWindowItem','WuKZQ','Window_ShopBuy_goodsToItem','ScopeEnemyOrAlly','statusWindowRectItemsEquipsCore','Window_ItemList_drawItem','drawItemCustomEntryLine','aHnZi','\x5cI[%1]','Scene_Shop_doSell','isBuyCommandEnabled','PXetd','processTouchModernControls','jPqRG','callUpdateHelp','LabelDamageHP','getShopTrackingItemSell','ItemsEquipsCore','_list','cursorLeft','middle','onTouchOk','Scene_Item_create','atypeId','mdf','getItemSpeedText','MaxItems','zQHbl','KrBSS','setBackgroundType','uHYUK','meetsItemConditionsJS','drawItemEffectsMpRecovery','ADDED\x20EFFECTS','_itemIDs','_newItemsList','postCreateSellWindowItemsEquipsCore','categoryNameWindowDrawBackground','isSoleWeaponType','isLearnedSkill','SDAUg','JHzAf','_resetFontSize','makeItemData','_tempActorA','constructor','FIEgI','_slotWindow','description','_commandNameWindow','isEquipItem','getColor','isOptimizeCommandAdded','determineBaseSellingPrice','%1%','loadPicture','numItems','changePaintOpacity','Game_Party_consumeItem','playOkSound','cNjxO','itemPadding','===','yqDRc','iFNWW','isPressed','Window_ItemList_colSpacing','Speed0','deepCopy','TfElb','VisuMZ_1_BattleCore','970484pfdJfm','getItemEffectsMpDamageLabel','categoryNameWindowDrawText','initNewItemsList','removeBattleTestArtifacts','fontSize','sellPriceOfItem','onBuyItem','mat','buy','Consumable','bitmap','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','BorderRegExp','HiddenItemA','buttonAssistLargeIncrement','UUzjA','getEmptyEquipSlotOfSameEtype','ZsZam','getItemSuccessRateText','Window_ShopSell_isEnabled','DrawIcons','JjcBk','troopArtifacts','kuAHK','EVAL','WRfDi','doBuy','NonRemoveETypes','slotWindowRectItemsEquipsCore','List','dasXt','BOjwt','changeEquipById','CmdIconBuy','pxgxu','nGKIr','maxVisibleItems','eDQmH','DHlxV','tcqVh','OOItv','onCategoryCancelItemsEquipsCore','_getEquipRequirements','splice','ujYsv','ZDwFp','drawItemEffects','qCfvW','nonOptimizeEtypes','wgTTS','CannotEquipMarker','numberWindowRect','RAuKW','canEquip','allowShiftScrolling','_sellWindow','drawItemEffectsRemovedStatesBuffs','Equip\x20the\x20strongest\x20available\x20equipment.','ZNaGa','keyItem','drawEquipData','type','value2','Scene_Equip_createSlotWindow','ShowShopStatus','makeCommandList','drawUpdatedAfterParamValue','ZurSn','addSellCommand','isHandled','slzKt','MaxMP','commandNameWindowCenter','drawItemEffectsHpRecovery','toUpperCase','ConvertNumberToString','isCursedItem','QSbiy','amgCx','text','ScopeRandomAny','gWmPC','hCBXA','setTempActor','isShiftRemoveShortcutEnabled','code','level','ShiftShortcutKey','Game_Enemy_traitObjects_artifact','TextAlign','itemLineRect','fCPYW','Window_Selectable_update','consumeItem','partyArtifactIDs','gaugeLineHeight','sdlpa','A%1','(%1)','0000','refreshDelay','yfmKg','canUse','sort','ZMPlZ','versionId','Window_ShopBuy_refresh','OmLFn','%1-%2','checkItemConditionsSwitchNotetags','itemDataFontSize','battleMembers','21eFcmZb','helpDesc','buttonAssistItemListRequirement','MaxArmors','bxUZh','drawItemEffectsAddedStatesBuffs','uEsKx','DrawItemData','_newLabelOpacity','Parse_Notetags_EquipSlots','udknT','textWidth','YlfYs','buttonAssistOffset3','Game_BattlerBase_meetsItemConditions','Window_ItemCategory_initialize','shouldCommandWindowExist','qtpcG','EnableLayout','Text','mainAreaBottom','cEVpb','Game_Item_setObject','alterSkillName','wkfkG','allowCommandWindowCursorUp','weapon-%1','optimize','find','Scene_Equip_onSlotCancel','isProxyItem','LabelRecoverTP','lRGaT','drawItemEquipType','hpRate','SwitchSell','rtpFN','iconIndex','getEquipRequirements','SwitchBuy','FadeSpeed','Scene_Equip_createCommandWindow','getItemsEquipsCoreBackColor1','onCategoryCancel','ShopListingRegExp','Waeku','bind','items','LcWRr','getItemRepeatsLabel','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','REMOVED\x20EFFECTS','gfYno','MExcB','isOpen','right','push','ParamValueFontSize','Step1End','getInputMultiButtonStrings','opacity','isBottomHelpMode','NUM','CFKbL','drawItemDamage','_handlers','lSjkq','drawCustomShopGraphic','HqXZF','PurchaseOnly','item-%1','YitOV','width','equipItems','canSortListItemScene','onBuyOk','Blacklist','commandBuy','utQhM','XgUIu','ParamChangeFontSize','Nonconsumable','itypeId','wnkkd','equip2','popScene','Window_ShopBuy_item','getNextAvailableEtypeId','paramchangeTextColor','FUNC','drawItemName','resetShopSwitches','isEquipAtypeOk','log','drawItemDamageElement','updateSmoothScroll','bhDxM','resetFontSettings','rNmvn','floor','hKtAD','Scene_Shop_commandSell','_armorIDs','Game_BattlerBase_param_artifact','OUtTG','armorTypes','drawItemStyleIcon','yucyx','getItemEffectsRemovedStatesBuffsText','setCategory','onBuyCancel','OLGgM','wtypeId','VisAn','ShowAllSwitches','UeRcD','Vdlji','UulpX','GXtvt','addShopTrackingItem','updatedLayoutStyle','SellPriceJS','isDualWield','<%1:[\x20]([\x5c+\x5c-]\x5cd+)>','Scene_Shop_doBuy','HLTXe','process_VisuMZ_ItemsEquipsCore_RegExp','getItemDamageAmountTextOriginal','_numberWindow','RXYTo','hideNewLabelSprites','ELEMENT','LabelSelfGainTP','categoryWindowRectItemsEquipsCore','getClassIdWithName','processShopCondListingOnBuyItem','AGI','center','onDatabaseLoaded','Window_EquipStatus_refresh','_dummyWindow','_money','paramJS','yyICf','Param','sellWindowRect','HIT\x20TYPE','maxCols','CoreEngine','xfyBA','price','ZNloW','XxATt','LNinT','isEquipped','paramBase','updateNewLabelOpacity','calcEquipItemPerformance','forceChangeEquipSlots','CmdStyle','drawItemNumber','updateMoneyAmount','WpFIY','PRXze','neyOm','initialize','GHnCs','HideAllSwitches','drawParamsItemsEquipsCore','itemEnableJS','process_VisuMZ_ItemsEquipsCore_Notetags','6pHIPZg','getItemEffectsHpRecoveryLabel','toLowerCase','equip','createCommandNameWindow','indexOf','drawItemDarkRect','CIkTg','addLoadListener','isClicked','ListWindowCols','processDownCursorSpecialCheckModernControls','addOptimizeCommand','_data','_tempActorB','smoothScrollTo','SUCCESS\x20RATE','uiMenuStyle','RemoveEquipIcon','number','getClassRequirements','move','ElqYT','contentsBack','100%','CheckCursedItemMsg','switchProxyItem','categoryItemTypes','categoryWindowRect','LabelRecoverMP','Enable','Scene_Shop_sellingPrice','ARRAYSTRUCT','modifiedBuyPriceItemsEquipsCore','getItemEffectsSelfTpGainText','purifyCursedEquips','_shopStatusMenuAlly','Mdswv','damage','MANUAL','ParseWeaponNotetags','clear','W%1','commandWindowRect','NXufE','activate','releaseUnequippableItems','isStackableArtifact','KHePS','ScopeAlliesButUser'];_0x5bde=function(){return _0x5b7d28;};return _0x5bde();}Sprite_NewLabel[_0x709961(0x5ef)]=Object['create'](Sprite[_0x709961(0x5ef)]),Sprite_NewLabel['prototype'][_0x709961(0x3f7)]=Sprite_NewLabel,Sprite_NewLabel['prototype'][_0x709961(0x527)]=function(){const _0x27b646=_0x709961;Sprite[_0x27b646(0x5ef)][_0x27b646(0x527)][_0x27b646(0x376)](this),this[_0x27b646(0x1ff)]();},Sprite_NewLabel[_0x709961(0x5ef)][_0x709961(0x1ff)]=function(){const _0x554a15=_0x709961,_0x26670d=ImageManager[_0x554a15(0x357)],_0xf0e569=ImageManager['iconHeight'];this[_0x554a15(0x41c)]=new Bitmap(_0x26670d,_0xf0e569),this[_0x554a15(0x333)](),this[_0x554a15(0x5ad)]();},Sprite_NewLabel[_0x709961(0x5ef)]['drawNewLabelIcon']=function(){const _0x56a654=_0x709961,_0x3497db=VisuMZ[_0x56a654(0x3db)]['Settings']['New'][_0x56a654(0x2d4)];if(_0x3497db<=0x0)return;const _0x15de9a=ImageManager[_0x56a654(0x35c)](_0x56a654(0x205)),_0x305a27=ImageManager['iconWidth'],_0x77f791=ImageManager[_0x56a654(0x2ea)],_0x3e5433=_0x3497db%0x10*_0x305a27,_0x18a68a=Math[_0x56a654(0x4e5)](_0x3497db/0x10)*_0x77f791;this[_0x56a654(0x41c)][_0x56a654(0x60b)](_0x15de9a,_0x3e5433,_0x18a68a,_0x305a27,_0x77f791,0x0,0x0);},Sprite_NewLabel[_0x709961(0x5ef)]['drawNewLabelText']=function(){const _0xba5f89=_0x709961,_0xf28aeb=VisuMZ['ItemsEquipsCore'][_0xba5f89(0x6b0)]['New'],_0x52fcdd=_0xf28aeb[_0xba5f89(0x495)];if(_0x52fcdd==='')return;const _0x387edd=ImageManager[_0xba5f89(0x357)],_0x555d28=ImageManager[_0xba5f89(0x2ea)];this[_0xba5f89(0x41c)][_0xba5f89(0x59a)]=_0xf28aeb[_0xba5f89(0x5d5)]||$gameSystem[_0xba5f89(0x63d)](),this[_0xba5f89(0x41c)][_0xba5f89(0x637)]=this[_0xba5f89(0x696)](),this[_0xba5f89(0x41c)][_0xba5f89(0x416)]=_0xf28aeb[_0xba5f89(0x229)],this['bitmap']['drawText'](_0x52fcdd,0x0,_0x555d28/0x2,_0x387edd,_0x555d28/0x2,_0xba5f89(0x50b));},Sprite_NewLabel[_0x709961(0x5ef)][_0x709961(0x696)]=function(){const _0x1ee55f=_0x709961,_0x359bc5=VisuMZ['ItemsEquipsCore'][_0x1ee55f(0x6b0)][_0x1ee55f(0x36c)]['FontColor'];return _0x359bc5[_0x1ee55f(0x1ed)](/#(.*)/i)?'#'+String(RegExp['$1']):ColorManager['textColor'](_0x359bc5);},Window_Base[_0x709961(0x5ef)][_0x709961(0x4dc)]=function(_0x328afb,_0x4a4543,_0x532919,_0x2aadb0){const _0x1d5b28=_0x709961;if(_0x328afb){if(_0x1d5b28(0x49a)===_0x1d5b28(0x463))return _0x12107e[_0x1d5b28(0x3db)][_0x1d5b28(0x295)][_0x1d5b28(0x376)](this);else{const _0x2133d1=_0x532919+(this[_0x1d5b28(0x361)]()-ImageManager[_0x1d5b28(0x2ea)])/0x2,_0x58464b=ImageManager['iconWidth']+0x4,_0x4f750b=Math[_0x1d5b28(0x5f5)](0x0,_0x2aadb0-_0x58464b);this[_0x1d5b28(0x61c)](ColorManager[_0x1d5b28(0x2c5)](_0x328afb)),this['drawIcon'](_0x328afb[_0x1d5b28(0x4a7)],_0x4a4543,_0x2133d1),this[_0x1d5b28(0x62c)](_0x328afb[_0x1d5b28(0x5a7)],_0x4a4543+_0x58464b,_0x532919,_0x4f750b),this[_0x1d5b28(0x1c0)]();}}},Window_Base[_0x709961(0x5ef)][_0x709961(0x522)]=function(_0x1772f2,_0x455ed2,_0xd4a7bd,_0x59ab37){const _0x3a44b3=_0x709961;if(this['isDrawItemNumber'](_0x1772f2)){this['resetFontSettings']();const _0x820ba7=VisuMZ['ItemsEquipsCore'][_0x3a44b3(0x6b0)][_0x3a44b3(0x309)],_0x731c2=_0x820ba7[_0x3a44b3(0x5b8)],_0x6fe309=_0x731c2[_0x3a44b3(0x60c)]($gameParty[_0x3a44b3(0x402)](_0x1772f2));this['contents'][_0x3a44b3(0x416)]=_0x820ba7[_0x3a44b3(0x631)],this[_0x3a44b3(0x62c)](_0x6fe309,_0x455ed2,_0xd4a7bd,_0x59ab37,_0x3a44b3(0x4b9)),this[_0x3a44b3(0x4e3)]();}},Window_Base['prototype']['isDrawItemNumber']=function(_0x1f134d){if(DataManager['isKeyItem'](_0x1f134d))return $dataSystem['optKeyItemsNumber'];return!![];},Window_Base['prototype'][_0x709961(0x533)]=function(_0xdf9bdb,_0x36eecd,_0x3ea2d4,_0xf7da8a,_0x44e485){const _0x25c22c=_0x709961;_0x44e485=Math[_0x25c22c(0x5f5)](_0x44e485||0x1,0x1);while(_0x44e485--){_0xf7da8a=_0xf7da8a||this['lineHeight'](),this[_0x25c22c(0x544)]['paintOpacity']=0xa0;const _0x18085f=ColorManager[_0x25c22c(0x1d9)]();this[_0x25c22c(0x544)][_0x25c22c(0x68d)](_0xdf9bdb+0x1,_0x36eecd+0x1,_0x3ea2d4-0x2,_0xf7da8a-0x2,_0x18085f),this['contentsBack'][_0x25c22c(0x32b)]=0xff;}},VisuMZ[_0x709961(0x3db)][_0x709961(0x592)]=Window_Selectable[_0x709961(0x5ef)][_0x709961(0x527)],Window_Selectable[_0x709961(0x5ef)][_0x709961(0x527)]=function(_0x24da51){const _0x1dc67a=_0x709961;this[_0x1dc67a(0x6cf)](),VisuMZ['ItemsEquipsCore']['Window_Selectable_initialize'][_0x1dc67a(0x376)](this,_0x24da51);},Window_Selectable['prototype'][_0x709961(0x6cf)]=function(){const _0x511bfa=_0x709961;this[_0x511bfa(0x6f4)]={},this[_0x511bfa(0x48a)]=0xff,this[_0x511bfa(0x69b)]=VisuMZ[_0x511bfa(0x3db)]['Settings'][_0x511bfa(0x36c)][_0x511bfa(0x4aa)],this[_0x511bfa(0x351)]=VisuMZ[_0x511bfa(0x3db)][_0x511bfa(0x6b0)][_0x511bfa(0x36c)][_0x511bfa(0x1fe)];},Window_Selectable['prototype'][_0x709961(0x2b4)]=function(){return![];},VisuMZ['ItemsEquipsCore'][_0x709961(0x3ca)]=Window_Selectable['prototype']['setHelpWindowItem'],Window_Selectable[_0x709961(0x5ef)][_0x709961(0x2c1)]=function(_0x53ec7a){const _0x5d245b=_0x709961;VisuMZ[_0x5d245b(0x3db)]['Window_Selectable_setHelpWindowItem'][_0x5d245b(0x376)](this,_0x53ec7a);if(this['isShowNew']())this['clearNewLabelFromItem'](_0x53ec7a);},Window_Selectable[_0x709961(0x5ef)][_0x709961(0x2a9)]=function(_0x173823){const _0x11764f=_0x709961;if(!_0x173823)return;$gameParty['clearNewItem'](_0x173823);let _0x2ef27a='';if(DataManager[_0x11764f(0x2f3)](_0x173823))_0x2ef27a=_0x11764f(0x4c8)[_0x11764f(0x60c)](_0x173823['id']);else{if(DataManager[_0x11764f(0x67a)](_0x173823))_0x11764f(0x264)!==_0x11764f(0x25e)?_0x2ef27a='weapon-%1'[_0x11764f(0x60c)](_0x173823['id']):(this[_0x11764f(0x4e3)](),this[_0x11764f(0x403)](!![]),this['prepareItemCustomData'](),this[_0x11764f(0x3fc)]()?this['drawEquipData']():this[_0x11764f(0x6ef)](),this[_0x11764f(0x4c5)]());else{if(DataManager[_0x11764f(0x3b3)](_0x173823))_0x2ef27a=_0x11764f(0x269)[_0x11764f(0x60c)](_0x173823['id']);else return;}}const _0x486ff0=this[_0x11764f(0x6f4)][_0x2ef27a];if(_0x486ff0)_0x486ff0[_0x11764f(0x5b0)]();},VisuMZ['ItemsEquipsCore'][_0x709961(0x1e0)]=Window_Selectable['prototype'][_0x709961(0x349)],Window_Selectable[_0x709961(0x5ef)][_0x709961(0x349)]=function(){const _0x93d6a2=_0x709961;this[_0x93d6a2(0x504)](),VisuMZ[_0x93d6a2(0x3db)][_0x93d6a2(0x1e0)]['call'](this);},Window_Selectable[_0x709961(0x5ef)][_0x709961(0x504)]=function(){const _0x5ba00e=_0x709961;for(const _0x31355a of Object[_0x5ba00e(0x68c)](this['_newLabelSprites'])){_0x31355a[_0x5ba00e(0x5b0)]();}},VisuMZ['ItemsEquipsCore'][_0x709961(0x46e)]=Window_Selectable['prototype'][_0x709961(0x653)],Window_Selectable[_0x709961(0x5ef)][_0x709961(0x653)]=function(){const _0xc47ebd=_0x709961;this[_0xc47ebd(0x51e)](),VisuMZ[_0xc47ebd(0x3db)][_0xc47ebd(0x46e)]['call'](this);},Window_Selectable['prototype'][_0x709961(0x51e)]=function(){const _0x5bf25b=_0x709961;if(!this['isShowNew']())return;const _0x42b784=this[_0x5bf25b(0x351)];this[_0x5bf25b(0x48a)]+=this[_0x5bf25b(0x69b)];(this[_0x5bf25b(0x48a)]>=_0x42b784||this[_0x5bf25b(0x48a)]<=0x0)&&(this[_0x5bf25b(0x69b)]*=-0x1);this['_newLabelOpacity']=this[_0x5bf25b(0x48a)][_0x5bf25b(0x371)](0x0,_0x42b784);for(const _0x233548 of Object[_0x5bf25b(0x68c)](this[_0x5bf25b(0x6f4)])){_0x233548['opacity']=this[_0x5bf25b(0x48a)];}},Window_Selectable['prototype'][_0x709961(0x1a0)]=function(_0x1011d7){const _0x20c325=_0x709961,_0x3e34eb=this[_0x20c325(0x6f4)];if(_0x3e34eb[_0x1011d7])return _0x3e34eb[_0x1011d7];else{if('yYjxZ'===_0x20c325(0x265))_0x20a0a5[_0x20c325(0x27f)](_0x20c325(0x4b9))&&this[_0x20c325(0x35b)](_0x3f835c[_0x20c325(0x5c1)](_0x20c325(0x4b9))),_0x2ae3c8['isRepeated']('left')&&this[_0x20c325(0x3dd)](_0x3a52c5[_0x20c325(0x5c1)](_0x20c325(0x316)));else{const _0x2642db=new Sprite_NewLabel();return _0x3e34eb[_0x1011d7]=_0x2642db,this['addInnerChild'](_0x2642db),_0x2642db;}}},Window_Selectable[_0x709961(0x5ef)]['placeNewLabel']=function(_0x4a3f67,_0x48469b,_0x4be285){const _0x2ab8d8=_0x709961;let _0x4c37a5='';if(DataManager[_0x2ab8d8(0x2f3)](_0x4a3f67))_0x2ab8d8(0x594)===_0x2ab8d8(0x4f7)?this['onTouchSelectModernControls'](![]):_0x4c37a5=_0x2ab8d8(0x4c8)['format'](_0x4a3f67['id']);else{if(DataManager[_0x2ab8d8(0x67a)](_0x4a3f67)){if(_0x2ab8d8(0x6ce)===_0x2ab8d8(0x231)){if(_0x24e1b6[_0x2ab8d8(0x53e)]&&_0x303cf1['uiInputPosition']!==_0x32a0b8)return _0x233434['uiInputPosition'];else{if(this['isUseItemsEquipsCoreUpdatedLayout']())return this[_0x2ab8d8(0x4fa)]()[_0x2ab8d8(0x1ed)](/RIGHT/i);else _0x5a8c4e[_0x2ab8d8(0x5ef)][_0x2ab8d8(0x2ef)][_0x2ab8d8(0x376)](this);}}else _0x4c37a5='weapon-%1'[_0x2ab8d8(0x60c)](_0x4a3f67['id']);}else{if(DataManager[_0x2ab8d8(0x3b3)](_0x4a3f67)){if(_0x2ab8d8(0x609)===_0x2ab8d8(0x611)){if(this['buttonAssistItemListRequirement']())return this[_0x2ab8d8(0x2ec)][_0x2ab8d8(0x515)]()===0x1?_0xde64f2[_0x2ab8d8(0x4bd)](_0x2ab8d8(0x316),_0x2ab8d8(0x4b9)):_0x4ef876['getInputMultiButtonStrings'](_0x2ab8d8(0x277),'pagedown');return _0x519f2c[_0x2ab8d8(0x5ef)][_0x2ab8d8(0x3a2)][_0x2ab8d8(0x376)](this);}else _0x4c37a5='armor-%1'['format'](_0x4a3f67['id']);}else{if(_0x2ab8d8(0x6de)===_0x2ab8d8(0x6de))return;else{if(!this[_0x2ab8d8(0x676)](_0x2b7647))return![];const _0x515118=_0xdc088a['note'];if(!_0x515118)return![];if(_0x515118[_0x2ab8d8(0x1ed)](/<(?:PARTY|ALLY) (?:ARTIFACT|RELIC)>/i))return!![];if(_0x515118[_0x2ab8d8(0x1ed)](/<(?:STACKABLE|STACK) (?:PARTY|ALLY) (?:ARTIFACT|RELIC)>/i))return!![];return![];}}}}const _0x1e4b9f=this[_0x2ab8d8(0x1a0)](_0x4c37a5);_0x1e4b9f[_0x2ab8d8(0x542)](_0x48469b,_0x4be285),_0x1e4b9f[_0x2ab8d8(0x314)](),_0x1e4b9f[_0x2ab8d8(0x4be)]=this['_newLabelOpacity'];},Window_ItemCategory[_0x709961(0x29a)]=VisuMZ[_0x709961(0x3db)][_0x709961(0x6b0)]['Categories'][_0x709961(0x42f)],Window_ItemCategory[_0x709961(0x548)]=[_0x709961(0x41f),_0x709961(0x2aa),_0x709961(0x4d3),'Consumable',_0x709961(0x6e7),_0x709961(0x1e7),_0x709961(0x5f7),'NeverUsable'],VisuMZ['ItemsEquipsCore']['Window_ItemCategory_initialize']=Window_ItemCategory[_0x709961(0x5ef)][_0x709961(0x527)],Window_ItemCategory[_0x709961(0x5ef)]['initialize']=function(_0x5b3d3a){const _0x11c64e=_0x709961;VisuMZ[_0x11c64e(0x3db)][_0x11c64e(0x491)]['call'](this,_0x5b3d3a),this[_0x11c64e(0x375)](_0x5b3d3a);},Window_ItemCategory['prototype'][_0x709961(0x375)]=function(_0x179d76){const _0x4a4d40=_0x709961,_0x5e736c=new Rectangle(0x0,0x0,_0x179d76[_0x4a4d40(0x4ca)],_0x179d76['height']);this[_0x4a4d40(0x22c)]=new Window_Base(_0x5e736c),this['_categoryNameWindow'][_0x4a4d40(0x4be)]=0x0,this[_0x4a4d40(0x271)](this[_0x4a4d40(0x22c)]),this['updateCategoryNameWindow']();},Window_ItemCategory[_0x709961(0x5ef)][_0x709961(0x6d8)]=function(){const _0x2b65e8=_0x709961;return Imported[_0x2b65e8(0x615)]&&Window_HorzCommand[_0x2b65e8(0x5ef)]['isUseModernControls'][_0x2b65e8(0x376)](this);},Window_ItemCategory[_0x709961(0x5ef)][_0x709961(0x2d5)]=function(){},Window_ItemCategory['prototype'][_0x709961(0x405)]=function(){const _0xc9e6db=_0x709961;if(!this[_0xc9e6db(0x6d8)]())Window_HorzCommand[_0xc9e6db(0x5ef)][_0xc9e6db(0x405)][_0xc9e6db(0x376)](this);},Window_ItemCategory[_0x709961(0x5ef)][_0x709961(0x515)]=function(){const _0x740afc=_0x709961;return this[_0x740afc(0x3dc)]?this[_0x740afc(0x1fb)]():0x4;},Window_ItemCategory[_0x709961(0x5ef)][_0x709961(0x653)]=function(){const _0x359b7b=_0x709961;Window_HorzCommand[_0x359b7b(0x5ef)]['update'][_0x359b7b(0x376)](this),this[_0x359b7b(0x2ec)]&&this[_0x359b7b(0x2ec)][_0x359b7b(0x4ef)](this[_0x359b7b(0x5ec)]());},Window_ItemCategory[_0x709961(0x5ef)]['processCursorMoveModernControls']=function(){const _0x481315=_0x709961;if(this[_0x481315(0x565)]()){if(_0x481315(0x5d8)==='Kaigv')this[_0x481315(0x59b)]();else{const _0x5c2a21=this[_0x481315(0x624)]();if(this[_0x481315(0x2ec)]&&this['_itemWindow'][_0x481315(0x515)]()<=0x1){if(_0x481315(0x439)===_0x481315(0x439)){Input[_0x481315(0x27f)]('right')&&this[_0x481315(0x35b)](Input[_0x481315(0x5c1)](_0x481315(0x4b9)));if(Input[_0x481315(0x27f)](_0x481315(0x316))){if(_0x481315(0x1e6)===_0x481315(0x1e6))this['cursorLeft'](Input['isTriggered'](_0x481315(0x316)));else return this[_0x481315(0x1f3)]();}}else _0x4e75ea=_0x2cc040[_0x481315(0x307)](_0x4370be),_0x1c797c=_0x5593ab-_0x296ca8[_0x481315(0x307)](_0x19f603),this[_0x481315(0x61c)](_0x2acb6d[_0x481315(0x4da)](_0x322ea2)),_0x5e6040=(_0x585193>=0x0?'+':'')+_0x1ae38e;}else this[_0x481315(0x2ec)]&&this[_0x481315(0x2ec)][_0x481315(0x515)]()>0x1&&(Input['isRepeated'](_0x481315(0x5af))&&!Input[_0x481315(0x40b)](_0x481315(0x5ce))&&this['cursorRight'](Input[_0x481315(0x5c1)]('pagedown')),Input['isRepeated'](_0x481315(0x277))&&!Input['isPressed'](_0x481315(0x5ce))&&(_0x481315(0x2e0)!==_0x481315(0x2e0)?(this['addBuyCommand'](),this[_0x481315(0x456)](),this['addCancelCommand']()):this[_0x481315(0x3dd)](Input[_0x481315(0x5c1)](_0x481315(0x277)))));if(this[_0x481315(0x624)]()!==_0x5c2a21){if(_0x481315(0x5d1)!=='SvGIK')this['playCursorSound']();else return _0x26af36[_0x481315(0x3db)][_0x481315(0x6b0)][_0x481315(0x281)][_0x481315(0x5d2)];}}}},Window_ItemCategory['prototype'][_0x709961(0x6ab)]=function(){const _0x1e9dcf=_0x709961;if(this['isUseModernControls']())return;Window_HorzCommand['prototype'][_0x1e9dcf(0x6ab)][_0x1e9dcf(0x376)](this);},Window_ItemCategory[_0x709961(0x5ef)]['isHoverEnabled']=function(){const _0x366c45=_0x709961;return this['isUseModernControls']()?![]:Window_HorzCommand[_0x366c45(0x5ef)][_0x366c45(0x1ee)][_0x366c45(0x376)](this);},Window_ItemCategory['prototype'][_0x709961(0x3d6)]=function(){const _0x212101=_0x709961;if(this['isOpenAndActive']()){TouchInput[_0x212101(0x5c1)]()&&this[_0x212101(0x382)](!![]);if(TouchInput[_0x212101(0x536)]()){if(_0x212101(0x528)===_0x212101(0x528))this[_0x212101(0x3df)]();else{this['_item']=_0x469a15;const _0x31cb88=_0x525cb0[_0x212101(0x37a)];_0x21c400(this['refreshDelay'][_0x212101(0x4b0)](this,_0x30b5f1),_0x31cb88);}}else{if(TouchInput[_0x212101(0x5ab)]()){if(_0x212101(0x5d7)!=='uPKtC')return _0x4f67ab['ScopeRandomEnemies'][_0x212101(0x60c)](_0x5a7f54(_0x584f46['$1']));else this[_0x212101(0x1c1)]();}}}},Window_ItemCategory[_0x709961(0x5ef)][_0x709961(0x382)]=function(_0x2ef650){const _0x240eab=_0x709961;this[_0x240eab(0x6d8)]()?this['onTouchSelectModern'](!![]):Window_HorzCommand[_0x240eab(0x5ef)]['onTouchSelect'][_0x240eab(0x376)](this,_0x2ef650);},Window_ItemCategory[_0x709961(0x5ef)]['onTouchSelectModern']=function(_0xe4b4ac){const _0x4e4554=_0x709961;this[_0x4e4554(0x56a)]=![];if(this['isCursorMovable']()){if(_0x4e4554(0x3e6)===_0x4e4554(0x3e6)){const _0x29d25f=this['index'](),_0x2903a7=this[_0x4e4554(0x2bb)]();if(_0x2903a7>=0x0&&_0x2903a7!==this['index']()){if(_0x4e4554(0x652)===_0x4e4554(0x430)){if(!_0x44bbe8)return![];if(!_0x15b8ec[_0x4e4554(0x3db)][_0x4e4554(0x490)][_0x4e4554(0x376)](this,_0xb40d58))return![];if(!this[_0x4e4554(0x60d)](_0x33ce7d))return![];if(!this[_0x4e4554(0x3e9)](_0x3cac8a))return![];return!![];}else this[_0x4e4554(0x2a0)](_0x2903a7);}_0xe4b4ac&&this['index']()!==_0x29d25f&&(_0x4e4554(0x258)===_0x4e4554(0x567)?_0x4e0d88['params'][_0x580488]=_0x373cf3(_0x40911d['$1']):this[_0x4e4554(0x5d0)]());}else _0x2f931a=this[_0x4e4554(0x3bc)]['paramValueByName'](_0x39a4d0,!![]);}},Window_ItemCategory['prototype'][_0x709961(0x453)]=function(){const _0x9e71cc=_0x709961;this[_0x9e71cc(0x1da)](),this[_0x9e71cc(0x2a0)](this['index']());},Window_ItemCategory[_0x709961(0x5ef)][_0x709961(0x1da)]=function(){const _0x300330=_0x709961;for(const _0x2651f2 of Window_ItemCategory[_0x300330(0x29a)]){if('eubfC'!==_0x300330(0x1b3))return this[_0x300330(0x339)]('buy',_0x1a303a);else this[_0x300330(0x291)](_0x2651f2);}},Window_ItemCategory[_0x709961(0x5ef)]['addItemCategory']=function(_0x1be87b){const _0x4591f9=_0x709961,_0x2e4cd2=_0x1be87b[_0x4591f9(0x3ae)],_0x52b6e5=_0x1be87b[_0x4591f9(0x2d4)],_0x3f511e=_0x1be87b[_0x4591f9(0x318)]||0x0;if(_0x3f511e>0x0&&!$gameSwitches[_0x4591f9(0x337)](_0x3f511e))return;let _0x360e2a='',_0x4def4f=_0x4591f9(0x6dc),_0x3fdd8d=_0x2e4cd2;if(_0x2e4cd2[_0x4591f9(0x1ed)](/Category:(.*)/i))_0x360e2a=String(RegExp['$1'])['trim']();else{if(Window_ItemCategory[_0x4591f9(0x548)]['includes'](_0x2e4cd2))_0x360e2a=VisuMZ['ItemsEquipsCore'][_0x4591f9(0x6b0)][_0x4591f9(0x29b)][_0x2e4cd2];else{if([_0x4591f9(0x66e),_0x4591f9(0x26d)][_0x4591f9(0x3bb)](_0x2e4cd2))_0x360e2a=TextManager['item'];else{if(_0x2e4cd2===_0x4591f9(0x68e)){if('WuPMs'!=='zrNST')_0x360e2a=TextManager[_0x4591f9(0x44d)];else{const _0x3eb5b5='OCCASION';if(this[_0x4591f9(0x3b8)][_0x3eb5b5])return this['_customItemInfo'][_0x3eb5b5];const _0x44e951=_0x4b88c9[_0x4591f9(0x3db)][_0x4591f9(0x6b0)]['StatusWindow'],_0x33fd62=_0x4591f9(0x379)['format'](this[_0x4591f9(0x3c2)]['occasion']);return _0x44e951[_0x33fd62];}}else{if(_0x2e4cd2===_0x4591f9(0x242)){if('wpEOl'!==_0x4591f9(0x5ff))return this[_0x4591f9(0x289)]()?this[_0x4591f9(0x288)]():_0x211f29['ItemsEquipsCore']['Scene_Shop_sellWindowRect'][_0x4591f9(0x376)](this);else _0x360e2a=TextManager[_0x4591f9(0x325)];}else{if(_0x2e4cd2===_0x4591f9(0x5a3))_0x360e2a=TextManager['armor'];else{if(_0x2e4cd2[_0x4591f9(0x1ed)](/WTYPE:(\d+)/i))_0x360e2a=$dataSystem[_0x4591f9(0x5e5)][Number(RegExp['$1'])]||'';else{if(_0x2e4cd2[_0x4591f9(0x1ed)](/ATYPE:(\d+)/i)){if(_0x4591f9(0x534)!==_0x4591f9(0x534)){this[_0x4591f9(0x626)](_0x2c1ed1)[_0x4591f9(0x1ed)](/\\I\[(\d+)\]/i);const _0x35744d=_0x871045(_0x55bd32['$1'])||0x0,_0x477b14=this[_0x4591f9(0x46c)](_0xe5501),_0x3de28e=_0x477b14['x']+_0xbb7352[_0x4591f9(0x4e5)]((_0x477b14[_0x4591f9(0x4ca)]-_0x51bd6e[_0x4591f9(0x357)])/0x2),_0x71b237=_0x477b14['y']+(_0x477b14[_0x4591f9(0x232)]-_0x48022f[_0x4591f9(0x2ea)])/0x2;this['drawIcon'](_0x35744d,_0x3de28e,_0x71b237);}else _0x360e2a=$dataSystem[_0x4591f9(0x4eb)][Number(RegExp['$1'])]||'';}else _0x2e4cd2[_0x4591f9(0x1ed)](/ETYPE:(\d+)/i)&&(_0x360e2a=$dataSystem[_0x4591f9(0x2c9)][Number(RegExp['$1'])]||'');}}}}}}}_0x52b6e5>0x0&&this[_0x4591f9(0x655)]()!=='text'&&(_0x360e2a='\x5cI[%1]%2'[_0x4591f9(0x60c)](_0x52b6e5,_0x360e2a)),this['addCommand'](_0x360e2a,_0x4def4f,!![],_0x3fdd8d);},Window_ItemCategory[_0x709961(0x5ef)]['itemTextAlign']=function(){const _0xa54e71=_0x709961;return VisuMZ[_0xa54e71(0x3db)][_0xa54e71(0x6b0)]['Categories'][_0xa54e71(0x46b)];},Window_ItemCategory[_0x709961(0x5ef)][_0x709961(0x602)]=function(_0x5b5751){const _0x146259=_0x709961,_0x551a9b=this[_0x146259(0x6aa)](_0x5b5751);if(_0x551a9b==='iconText'){if('YKBkD'!=='iXtMZ')this[_0x146259(0x2f5)](_0x5b5751);else{let _0x46f8aa=_0x49122a[_0x146259(0x3db)][_0x146259(0x46a)][_0x146259(0x376)](this);return _0x46f8aa[_0x146259(0x33e)](_0x5c72b7[_0x146259(0x428)]());}}else _0x551a9b===_0x146259(0x220)?_0x146259(0x2b5)!=='nMgpv'?_0x5e690a=_0x4608f2[_0x146259(0x5f5)](_0x247129,_0x3159b7):this[_0x146259(0x4ec)](_0x5b5751):Window_HorzCommand[_0x146259(0x5ef)][_0x146259(0x602)][_0x146259(0x376)](this,_0x5b5751);},Window_ItemCategory[_0x709961(0x5ef)][_0x709961(0x655)]=function(){const _0x1bc834=_0x709961;return VisuMZ[_0x1bc834(0x3db)][_0x1bc834(0x6b0)][_0x1bc834(0x29b)]['Style'];},Window_ItemCategory[_0x709961(0x5ef)][_0x709961(0x6aa)]=function(_0x2fb03){const _0x42abce=_0x709961;if(_0x2fb03<0x0)return _0x42abce(0x461);const _0x50a4d2=this[_0x42abce(0x655)]();if(_0x50a4d2!==_0x42abce(0x28f)){if(_0x42abce(0x4b7)!==_0x42abce(0x4b7))_0x26425f[_0x42abce(0x4ba)](_0x4b9d0c[_0x33bc8b]);else return _0x50a4d2;}else{if('qYeCH'===_0x42abce(0x66c)){const _0x19010f=new _0x28746f(0x0,0x0,_0x7d1dca[_0x42abce(0x4ca)],_0x4a3d9b[_0x42abce(0x232)]);this[_0x42abce(0x3fb)]=new _0x56ff33(_0x19010f),this[_0x42abce(0x3fb)][_0x42abce(0x4be)]=0x0,this['addChild'](this[_0x42abce(0x3fb)]),this[_0x42abce(0x1ce)]();}else{const _0x15f49c=this[_0x42abce(0x626)](_0x2fb03);if(_0x15f49c[_0x42abce(0x1ed)](/\\I\[(\d+)\]/i)){const _0x3f5719=this[_0x42abce(0x46c)](_0x2fb03),_0x1b8494=this['textSizeEx'](_0x15f49c)[_0x42abce(0x4ca)];return _0x1b8494<=_0x3f5719[_0x42abce(0x4ca)]?_0x42abce(0x3be):_0x42abce(0x220);}else return _0x42abce(0x461);}}},Window_ItemCategory[_0x709961(0x5ef)]['drawItemStyleIconText']=function(_0x41c85b){const _0x229bcb=_0x709961,_0x50bc53=this[_0x229bcb(0x46c)](_0x41c85b),_0x421d24=this[_0x229bcb(0x626)](_0x41c85b),_0x3bcaad=this['textSizeEx'](_0x421d24)[_0x229bcb(0x4ca)];this[_0x229bcb(0x403)](this[_0x229bcb(0x35a)](_0x41c85b));const _0x34a858=this[_0x229bcb(0x27b)]();if(_0x34a858===_0x229bcb(0x4b9)){if(_0x229bcb(0x2b3)!=='vuHSL'){const _0x47617e=this[_0x229bcb(0x46c)](_0x2891fa),_0x4a7530=this[_0x229bcb(0x66a)](_0x524dee)[_0x229bcb(0x4ca)];return _0x4a7530<=_0x47617e[_0x229bcb(0x4ca)]?_0x229bcb(0x3be):_0x229bcb(0x220);}else this[_0x229bcb(0x6ba)](_0x421d24,_0x50bc53['x']+_0x50bc53[_0x229bcb(0x4ca)]-_0x3bcaad,_0x50bc53['y'],_0x3bcaad);}else{if(_0x34a858===_0x229bcb(0x50b)){if(_0x229bcb(0x2fc)!==_0x229bcb(0x6bb)){const _0x5a7b27=_0x50bc53['x']+Math['floor']((_0x50bc53['width']-_0x3bcaad)/0x2);this['drawTextEx'](_0x421d24,_0x5a7b27,_0x50bc53['y'],_0x3bcaad);}else this['playCursorSound']();}else this[_0x229bcb(0x6ba)](_0x421d24,_0x50bc53['x'],_0x50bc53['y'],_0x3bcaad);}},Window_ItemCategory[_0x709961(0x5ef)][_0x709961(0x4ec)]=function(_0x524479){const _0x205c7e=_0x709961,_0x588d40=this['commandName'](_0x524479);if(_0x588d40['match'](/\\I\[(\d+)\]/i)){const _0x49e0f0=Number(RegExp['$1'])||0x0,_0x469c44=this[_0x205c7e(0x46c)](_0x524479),_0x2b167f=_0x469c44['x']+Math[_0x205c7e(0x4e5)]((_0x469c44[_0x205c7e(0x4ca)]-ImageManager[_0x205c7e(0x357)])/0x2),_0x347097=_0x469c44['y']+(_0x469c44['height']-ImageManager[_0x205c7e(0x2ea)])/0x2;this[_0x205c7e(0x25a)](_0x49e0f0,_0x2b167f,_0x347097);}},VisuMZ['ItemsEquipsCore'][_0x709961(0x20a)]=Window_ItemCategory['prototype'][_0x709961(0x346)],Window_ItemCategory['prototype'][_0x709961(0x346)]=function(_0x27995a){const _0x304c45=_0x709961;VisuMZ[_0x304c45(0x3db)][_0x304c45(0x20a)][_0x304c45(0x376)](this,_0x27995a),_0x27995a[_0x304c45(0x5cd)]=this;},Window_ItemCategory[_0x709961(0x5ef)][_0x709961(0x3d8)]=function(){const _0xe9f04f=_0x709961;Window_HorzCommand[_0xe9f04f(0x5ef)][_0xe9f04f(0x3d8)][_0xe9f04f(0x376)](this);if(this['_categoryNameWindow'])this['updateCategoryNameWindow']();},Window_ItemCategory['prototype'][_0x709961(0x280)]=function(){const _0x47f446=_0x709961,_0x5164b9=this[_0x47f446(0x22c)];_0x5164b9[_0x47f446(0x30a)][_0x47f446(0x556)]();const _0x4bc279=this['categoryStyleCheck'](this[_0x47f446(0x624)]());if(_0x4bc279===_0x47f446(0x220)){const _0x3c436c=this[_0x47f446(0x46c)](this[_0x47f446(0x624)]());let _0x3b6d97=this[_0x47f446(0x626)](this[_0x47f446(0x624)]());_0x3b6d97=_0x3b6d97[_0x47f446(0x3a5)](/\\I\[(\d+)\]/gi,''),_0x5164b9[_0x47f446(0x4e3)](),this[_0x47f446(0x3ef)](_0x3b6d97,_0x3c436c),this[_0x47f446(0x413)](_0x3b6d97,_0x3c436c),this['categoryNameWindowCenter'](_0x3b6d97,_0x3c436c);}},Window_ItemCategory['prototype'][_0x709961(0x3ef)]=function(_0x4d307a,_0x8e51fc){},Window_ItemCategory[_0x709961(0x5ef)]['categoryNameWindowDrawText']=function(_0x344c9c,_0x2b3efe){const _0x19d8fb=_0x709961,_0x2459eb=this['_categoryNameWindow'];_0x2459eb[_0x19d8fb(0x62c)](_0x344c9c,0x0,_0x2b3efe['y'],_0x2459eb[_0x19d8fb(0x224)],'center');},Window_ItemCategory[_0x709961(0x5ef)]['categoryNameWindowCenter']=function(_0x4dc918,_0xa8a9bc){const _0x26374f=_0x709961,_0x3539ca=this['_categoryNameWindow'],_0x596c88=$gameSystem['windowPadding'](),_0xed94eb=_0xa8a9bc['x']+Math[_0x26374f(0x4e5)](_0xa8a9bc['width']/0x2)+_0x596c88;_0x3539ca['x']=_0x3539ca['width']/-0x2+_0xed94eb,_0x3539ca['y']=Math[_0x26374f(0x4e5)](_0xa8a9bc[_0x26374f(0x232)]/0x2);},Window_ItemList[_0x709961(0x5ef)][_0x709961(0x67e)]=function(){const _0x169788=_0x709961;if(this['isCursorMovable']()){const _0x4b00f5=this[_0x169788(0x624)]();if(this[_0x169788(0x515)]()<=0x1)!this[_0x169788(0x457)]('pagedown')&&Input[_0x169788(0x5c1)](_0x169788(0x5af))&&this[_0x169788(0x222)](),!this['isHandled']('pageup')&&Input['isTriggered'](_0x169788(0x277))&&this[_0x169788(0x57e)]();else{if(this[_0x169788(0x515)]()>0x1){Input[_0x169788(0x27f)](_0x169788(0x4b9))&&this[_0x169788(0x35b)](Input[_0x169788(0x5c1)](_0x169788(0x4b9)));Input[_0x169788(0x27f)](_0x169788(0x316))&&this['cursorLeft'](Input[_0x169788(0x5c1)]('left'));if(this[_0x169788(0x5f2)]())Input['isTriggered'](_0x169788(0x5af))&&Input[_0x169788(0x40b)]('shift')&&this[_0x169788(0x222)](),Input[_0x169788(0x5c1)]('pageup')&&Input[_0x169788(0x40b)](_0x169788(0x5ce))&&this[_0x169788(0x57e)]();else{if(_0x169788(0x59d)===_0x169788(0x59d)){if(Input[_0x169788(0x5c1)](_0x169788(0x5af))){if(_0x169788(0x4f6)!==_0x169788(0x604))this[_0x169788(0x222)]();else return!![];}if(Input[_0x169788(0x5c1)](_0x169788(0x277))){if(_0x169788(0x524)==='WpFIY')this['cursorPageup']();else{const _0x3c14c2=_0x4d6d69(_0x14dfe5['$1'])||0x1;if(_0x27670d>=_0x3c14c2)return!![];}}}else{const _0x3fbc44=this['isRightInputMode']()?this['mainCommandWidth']():0x0,_0x3e2499=this['mainAreaTop'](),_0x5eb297=_0x4a910c[_0x169788(0x628)]-this[_0x169788(0x5a8)](),_0x39cc3a=this[_0x169788(0x6ac)](0x1,!![]);return new _0xfdeb77(_0x3fbc44,_0x3e2499,_0x5eb297,_0x39cc3a);}}}}Input[_0x169788(0x27f)](_0x169788(0x32a))&&(Input[_0x169788(0x40b)]('shift')&&this[_0x169788(0x448)]()?this['cursorPagedown']():this['cursorDown'](Input[_0x169788(0x5c1)](_0x169788(0x32a))));if(Input[_0x169788(0x27f)]('up')){if('RXYTo'!==_0x169788(0x503)){const _0x40a67d=this[_0x169788(0x3c2)]['note'];if(_0x40a67d[_0x169788(0x1ed)](/<ALWAYS HIT>/i))return _0x169788(0x545);else{if(_0x40a67d[_0x169788(0x1ed)](/<ALWAYS HIT RATE: (\d+)([%％])>/i))return _0x169788(0x400)[_0x169788(0x60c)](_0x4d33ac(_0x31ee2d['$1']));}}else Input[_0x169788(0x40b)](_0x169788(0x5ce))&&this[_0x169788(0x448)]()?this[_0x169788(0x57e)]():this[_0x169788(0x649)](Input[_0x169788(0x5c1)]('up'));}if(Imported['VisuMZ_0_CoreEngine']){if(_0x169788(0x233)!=='QQwYN')return this[_0x169788(0x3c2)][_0x169788(0x6a5)];else this[_0x169788(0x2d5)]();}if(this[_0x169788(0x624)]()!==_0x4b00f5){if(_0x169788(0x2ce)!==_0x169788(0x2ce))return this[_0x169788(0x43c)][_0x1c40c1];else this[_0x169788(0x5d0)]();}}},Window_ItemList[_0x709961(0x5ef)][_0x709961(0x5f2)]=function(){const _0x23ae0a=_0x709961,_0x3a0eca=SceneManager[_0x23ae0a(0x6c1)],_0x80228f=[Scene_Item,Scene_Shop];return _0x80228f[_0x23ae0a(0x3bb)](_0x3a0eca[_0x23ae0a(0x3f7)]);},Window_ItemList[_0x709961(0x5ef)][_0x709961(0x55a)]=function(){const _0x3bb93d=_0x709961;Window_Selectable[_0x3bb93d(0x5ef)][_0x3bb93d(0x55a)][_0x3bb93d(0x376)](this),this[_0x3bb93d(0x5cd)]&&this[_0x3bb93d(0x5cd)][_0x3bb93d(0x6d8)]()&&this[_0x3bb93d(0x5cd)][_0x3bb93d(0x55a)]();},Window_ItemList[_0x709961(0x5ef)][_0x709961(0x6df)]=function(){const _0x559c84=_0x709961;Window_Selectable['prototype'][_0x559c84(0x6df)]['call'](this),this[_0x559c84(0x5cd)]&&this['_categoryWindow'][_0x559c84(0x6d8)]()&&this[_0x559c84(0x5cd)][_0x559c84(0x6df)]();},Window_ItemList['prototype'][_0x709961(0x4ef)]=function(_0x1dd75f){const _0x24b37f=_0x709961;this[_0x24b37f(0x275)]!==_0x1dd75f&&(this[_0x24b37f(0x275)]=_0x1dd75f,this['refresh'](),this[_0x24b37f(0x5cd)]&&this['_categoryWindow'][_0x24b37f(0x6d8)]()?this['smoothSelect'](0x0):this['scrollTo'](0x0,0x0));},VisuMZ[_0x709961(0x3db)][_0x709961(0x370)]=Window_ItemList[_0x709961(0x5ef)][_0x709961(0x515)],Window_ItemList[_0x709961(0x5ef)][_0x709961(0x515)]=function(){const _0x47e2ce=_0x709961;if(SceneManager[_0x47e2ce(0x6c1)]['constructor']===Scene_Battle)return VisuMZ['ItemsEquipsCore'][_0x47e2ce(0x370)]['call'](this);else return SceneManager['_scene'][_0x47e2ce(0x3f7)]===Scene_Map?VisuMZ['ItemsEquipsCore']['Window_ItemList_maxCols']['call'](this):_0x47e2ce(0x387)===_0x47e2ce(0x593)?this['_buttonAssistWindow'][_0x47e2ce(0x4ca)]/0x5/-0x3:VisuMZ[_0x47e2ce(0x3db)][_0x47e2ce(0x6b0)][_0x47e2ce(0x309)][_0x47e2ce(0x537)];},VisuMZ['ItemsEquipsCore'][_0x709961(0x40c)]=Window_ItemList[_0x709961(0x5ef)][_0x709961(0x5cb)],Window_ItemList[_0x709961(0x5ef)][_0x709961(0x5cb)]=function(){const _0x327e03=_0x709961;if(this[_0x327e03(0x515)]()<=0x1)return Window_Selectable[_0x327e03(0x5ef)][_0x327e03(0x5cb)][_0x327e03(0x376)](this);else{if(_0x327e03(0x5f1)!==_0x327e03(0x5f1)){if(_0x5ee1ee){const _0x227071=_0x41d530+(this[_0x327e03(0x361)]()-_0x4a0ffb['iconHeight'])/0x2,_0x49a314=_0x277cc2['iconWidth']+0x4,_0x31c5ac=_0x5dde11[_0x327e03(0x5f5)](0x0,_0x426a6c-_0x49a314);this[_0x327e03(0x61c)](_0x9684e0[_0x327e03(0x2c5)](_0x4a0fe5)),this['drawIcon'](_0x249ca5[_0x327e03(0x4a7)],_0x33e5f1,_0x227071),this[_0x327e03(0x62c)](_0x3bc337['name'],_0x3dc605+_0x49a314,_0x407576,_0x31c5ac),this['resetTextColor']();}}else return VisuMZ[_0x327e03(0x3db)][_0x327e03(0x40c)][_0x327e03(0x376)](this);}},Window_ItemList['prototype'][_0x709961(0x3bb)]=function(_0x3d6c6c){const _0x17f05b=_0x709961;switch(this[_0x17f05b(0x275)]){case'AllItems':return DataManager['isItem'](_0x3d6c6c);case'RegularItems':return DataManager[_0x17f05b(0x2f3)](_0x3d6c6c)&&_0x3d6c6c[_0x17f05b(0x4d4)]===0x1;case _0x17f05b(0x68e):return DataManager[_0x17f05b(0x2f3)](_0x3d6c6c)&&_0x3d6c6c['itypeId']===0x2;case'HiddenItemA':return DataManager['isItem'](_0x3d6c6c)&&_0x3d6c6c[_0x17f05b(0x4d4)]===0x3;case _0x17f05b(0x2aa):return DataManager['isItem'](_0x3d6c6c)&&_0x3d6c6c[_0x17f05b(0x4d4)]===0x4;case _0x17f05b(0x41b):return DataManager['isItem'](_0x3d6c6c)&&_0x3d6c6c[_0x17f05b(0x6a5)];case _0x17f05b(0x4d3):return DataManager[_0x17f05b(0x2f3)](_0x3d6c6c)&&!_0x3d6c6c[_0x17f05b(0x6a5)];case _0x17f05b(0x6e7):return DataManager[_0x17f05b(0x2f3)](_0x3d6c6c)&&[0x0][_0x17f05b(0x3bb)](_0x3d6c6c[_0x17f05b(0x378)]);case'BattleUsable':return DataManager[_0x17f05b(0x2f3)](_0x3d6c6c)&&[0x0,0x1][_0x17f05b(0x3bb)](_0x3d6c6c[_0x17f05b(0x378)]);case _0x17f05b(0x5f7):return DataManager[_0x17f05b(0x2f3)](_0x3d6c6c)&&[0x0,0x2][_0x17f05b(0x3bb)](_0x3d6c6c[_0x17f05b(0x378)]);case _0x17f05b(0x3a3):return DataManager['isItem'](_0x3d6c6c)&&[0x3][_0x17f05b(0x3bb)](_0x3d6c6c[_0x17f05b(0x378)]);case _0x17f05b(0x242):return DataManager['isWeapon'](_0x3d6c6c);case _0x17f05b(0x5a3):return DataManager[_0x17f05b(0x3b3)](_0x3d6c6c);default:if(this[_0x17f05b(0x275)][_0x17f05b(0x1ed)](/WTYPE:(\d+)/i)){if(_0x17f05b(0x3f2)!==_0x17f05b(0x1b8))return DataManager[_0x17f05b(0x67a)](_0x3d6c6c)&&_0x3d6c6c[_0x17f05b(0x4f2)]===Number(RegExp['$1']);else{const _0x4d5ee7=this['mainCommandWidth'](),_0xc2bc58=this[_0x17f05b(0x6ac)](0x1,!![]),_0x211ac2=this['isRightInputMode']()?0x0:_0x347f0b[_0x17f05b(0x628)]-_0x4d5ee7,_0xfceb48=this[_0x17f05b(0x31b)]();return new _0xbdca4e(_0x211ac2,_0xfceb48,_0x4d5ee7,_0xc2bc58);}}else{if(this[_0x17f05b(0x275)][_0x17f05b(0x1ed)](/WTYPE:(.*)/i)){if(_0x17f05b(0x517)!=='xfyBA')_0x3592c3=_0x4937bd(_0x396947['$1'])[_0x17f05b(0x3c4)]();else{const _0x5d5c30=$dataSystem[_0x17f05b(0x5e5)]['indexOf'](String(RegExp['$1'])[_0x17f05b(0x3c4)]());return DataManager[_0x17f05b(0x67a)](_0x3d6c6c)&&_0x3d6c6c[_0x17f05b(0x4f2)]===_0x5d5c30;}}else{if(this[_0x17f05b(0x275)][_0x17f05b(0x1ed)](/ATYPE:(\d+)/i))return DataManager[_0x17f05b(0x3b3)](_0x3d6c6c)&&_0x3d6c6c[_0x17f05b(0x3e1)]===Number(RegExp['$1']);else{if(this[_0x17f05b(0x275)][_0x17f05b(0x1ed)](/ATYPE:(.*)/i)){if(_0x17f05b(0x570)===_0x17f05b(0x4e2)){_0x59de46=this['convertInitEquipsToItems'](_0x30a512);const _0x3b2e1a=this['equipSlots']();this[_0x17f05b(0x5fd)]=[];for(let _0x109768=0x0;_0x109768<_0x3b2e1a['length'];_0x109768++){this[_0x17f05b(0x5fd)][_0x109768]=new _0x7fa957();}for(let _0x51c429=0x0;_0x51c429<_0x3b2e1a[_0x17f05b(0x321)];_0x51c429++){const _0x3c076f=_0x3b2e1a[_0x51c429],_0x5e8f2f=this[_0x17f05b(0x563)](_0x2ac576,_0x3c076f);if(this[_0x17f05b(0x447)](_0x5e8f2f))this['_equips'][_0x51c429]['setObject'](_0x5e8f2f);}this['releaseUnequippableItems'](!![]),this['refresh']();}else{const _0x2a9cb5=$dataSystem[_0x17f05b(0x4eb)][_0x17f05b(0x532)](String(RegExp['$1'])[_0x17f05b(0x3c4)]());return DataManager[_0x17f05b(0x3b3)](_0x3d6c6c)&&_0x3d6c6c[_0x17f05b(0x3e1)]===_0x2a9cb5;}}else{if(this[_0x17f05b(0x275)][_0x17f05b(0x1ed)](/ETYPE:(\d+)/i))return!!_0x3d6c6c&&_0x3d6c6c[_0x17f05b(0x5fe)]===Number(RegExp['$1']);else{if(this[_0x17f05b(0x275)][_0x17f05b(0x1ed)](/ETYPE:(.*)/i)){const _0xb0cb58=$dataSystem[_0x17f05b(0x2c9)][_0x17f05b(0x532)](String(RegExp['$1'])['trim']());return DataManager[_0x17f05b(0x3b3)](_0x3d6c6c)&&_0x3d6c6c['etypeId']===_0xb0cb58;}else{if(this[_0x17f05b(0x275)][_0x17f05b(0x1ed)](/Category:(.*)/i)){if('ouUDr'!==_0x17f05b(0x644))this[_0x17f05b(0x6ba)](_0x5be6ab,_0x210f4f['x']+_0x5773d4['width']-_0x402ea0,_0xb18640['y'],_0x24ee1d);else return!!_0x3d6c6c&&_0x3d6c6c[_0x17f05b(0x5d4)][_0x17f05b(0x3bb)](String(RegExp['$1'])[_0x17f05b(0x45c)]()[_0x17f05b(0x3c4)]());}}}}}}}}return![];},VisuMZ[_0x709961(0x3db)][_0x709961(0x2c4)]=Window_ItemList['prototype'][_0x709961(0x5f3)],Window_ItemList[_0x709961(0x5ef)][_0x709961(0x5f3)]=function(){const _0x51352d=_0x709961;VisuMZ[_0x51352d(0x3db)][_0x51352d(0x2c4)][_0x51352d(0x376)](this);if(this[_0x51352d(0x4cc)]())this[_0x51352d(0x69c)]();},Window_ItemList['prototype'][_0x709961(0x4cc)]=function(){const _0x51d16=_0x709961,_0x3732c2=[_0x51d16(0x68a),_0x51d16(0x5ae)],_0x1dccf4=SceneManager[_0x51d16(0x6c1)];return _0x3732c2['includes'](_0x1dccf4[_0x51d16(0x3f7)]['name']);},Window_ItemList[_0x709961(0x5ef)][_0x709961(0x69c)]=function(){const _0x4fad1a=_0x709961,_0x2dcd6b=Window_ItemCategory[_0x4fad1a(0x29a)],_0x5d28ec=_0x2dcd6b[_0x4fad1a(0x49e)](_0x5008cf=>_0x5008cf['Type']===this[_0x4fad1a(0x275)]);if(!_0x5d28ec)return;const _0x5abc64=((_0x5d28ec['SortBy']??'ID')||'ID')[_0x4fad1a(0x45c)]()['trim']();if(_0x5abc64==='NAME'){if(_0x4fad1a(0x276)!==_0x4fad1a(0x276)){const _0x40366f=_0x127904(_0x59b55c['$1'])[_0x4fad1a(0x617)](',')[_0x4fad1a(0x1ac)](_0x135d31=>_0x8a815f(_0x135d31));if(_0x40366f[_0x4fad1a(0x328)](_0x16084a=>_0x19c8f0[_0x4fad1a(0x337)](_0x16084a)))return![];}else this[_0x4fad1a(0x53a)][_0x4fad1a(0x479)]((_0x4f73e7,_0xc6313e)=>{const _0x119740=_0x4fad1a;if('ffLJu'===_0x119740(0x6b9))return _0x5964e1['ItemsEquipsCore'][_0x119740(0x6b0)]['EquipScene'][_0x119740(0x42d)];else{if(!!_0x4f73e7&&!!_0xc6313e)return _0x4f73e7[_0x119740(0x5a7)][_0x119740(0x2f4)](_0xc6313e[_0x119740(0x5a7)]);return 0x0;}});}else{}},Window_ItemList[_0x709961(0x5ef)][_0x709961(0x2b4)]=function(){return!![];},VisuMZ[_0x709961(0x3db)]['Window_ItemList_drawItem']=Window_ItemList[_0x709961(0x5ef)][_0x709961(0x602)],Window_ItemList[_0x709961(0x5ef)][_0x709961(0x602)]=function(_0x5be1bd){const _0x3372bf=_0x709961;VisuMZ['ItemsEquipsCore'][_0x3372bf(0x3cf)]['call'](this,_0x5be1bd),this[_0x3372bf(0x68f)](_0x5be1bd);},Window_ItemList[_0x709961(0x5ef)][_0x709961(0x522)]=function(_0xff76b3,_0x426cc0,_0x3c1fc1,_0x57f256){const _0x3af76d=_0x709961;Window_Selectable[_0x3af76d(0x5ef)]['drawItemNumber'][_0x3af76d(0x376)](this,_0xff76b3,_0x426cc0,_0x3c1fc1,_0x57f256);},Window_ItemList[_0x709961(0x5ef)][_0x709961(0x68f)]=function(_0x31443f){const _0x34748c=_0x709961,_0x526497=this[_0x34748c(0x364)](_0x31443f);if(!_0x526497||!this[_0x34748c(0x2b4)]())return;if(!$gameParty[_0x34748c(0x572)](_0x526497))return;const _0x476339=this[_0x34748c(0x46c)](_0x31443f),_0x26c347=_0x476339['x'],_0x136897=_0x476339['y']+(this[_0x34748c(0x361)]()-ImageManager[_0x34748c(0x2ea)])/0x2,_0x5001f6=VisuMZ['ItemsEquipsCore']['Settings'][_0x34748c(0x36c)][_0x34748c(0x33b)],_0x31b39e=VisuMZ[_0x34748c(0x3db)]['Settings']['New'][_0x34748c(0x681)];this[_0x34748c(0x5ea)](_0x526497,_0x26c347+_0x5001f6,_0x136897+_0x31b39e);},Window_ItemList[_0x709961(0x5ef)][_0x709961(0x6b6)]=function(_0x4fccab){const _0x9ce590=_0x709961;this[_0x9ce590(0x633)]=_0x4fccab,this[_0x9ce590(0x3d8)]();},VisuMZ[_0x709961(0x3db)][_0x709961(0x674)]=Window_ItemList[_0x709961(0x5ef)]['updateHelp'],Window_ItemList['prototype'][_0x709961(0x317)]=function(){const _0xdf8280=_0x709961;VisuMZ[_0xdf8280(0x3db)][_0xdf8280(0x674)][_0xdf8280(0x376)](this);if(this['_statusWindow']&&this[_0xdf8280(0x633)][_0xdf8280(0x3f7)]===Window_ShopStatus){if('FmQLD'!==_0xdf8280(0x35f))this['_statusWindow'][_0xdf8280(0x57b)](this[_0xdf8280(0x24d)]());else{if(this['isOptimizeEquipOk'](_0x2ade90))this['changeEquip'](_0x42922e,null);}}},Window_BattleItem[_0x709961(0x5ef)][_0x709961(0x24b)]=function(_0x29d714){const _0x4d6c36=_0x709961;if(BattleManager[_0x4d6c36(0x67f)]()){if(_0x4d6c36(0x1b1)!==_0x4d6c36(0x66b))return BattleManager[_0x4d6c36(0x67f)]()[_0x4d6c36(0x478)](_0x29d714);else{if(this[_0x4d6c36(0x502)]&&this['_numberWindow'][_0x4d6c36(0x3bd)])return _0x184141[_0x4d6c36(0x3db)][_0x4d6c36(0x6b0)][_0x4d6c36(0x300)][_0x4d6c36(0x420)];return _0x452b96[_0x4d6c36(0x5ef)][_0x4d6c36(0x39a)]['call'](this);}}else return Window_ItemList[_0x4d6c36(0x5ef)][_0x4d6c36(0x24b)][_0x4d6c36(0x376)](this,_0x29d714);},Window_EventItem[_0x709961(0x5ef)][_0x709961(0x2b4)]=function(){return![];},Window_EquipStatus['prototype'][_0x709961(0x289)]=function(){const _0x2212d4=_0x709961;return VisuMZ[_0x2212d4(0x3db)][_0x2212d4(0x6b0)]['EquipScene']['EnableLayout'];},VisuMZ[_0x709961(0x3db)]['Window_EquipStatus_refresh']=Window_EquipStatus[_0x709961(0x5ef)]['refresh'],Window_EquipStatus['prototype'][_0x709961(0x349)]=function(){const _0x4931ad=_0x709961;this[_0x4931ad(0x2ee)](),this[_0x4931ad(0x4e3)]();if(this['_actor'])this[_0x4931ad(0x3bc)][_0x4931ad(0x349)]();this[_0x4931ad(0x289)]()?this[_0x4931ad(0x2ca)]():VisuMZ[_0x4931ad(0x3db)][_0x4931ad(0x50d)][_0x4931ad(0x376)](this);},Window_EquipStatus['prototype'][_0x709961(0x2ca)]=function(){const _0x575ed1=_0x709961;this[_0x575ed1(0x30a)][_0x575ed1(0x556)]();if(!this[_0x575ed1(0x3bc)])return;if(this[_0x575ed1(0x30e)]()){if(_0x575ed1(0x5dc)==='DjWPZ'){const _0x428816=ImageManager[_0x575ed1(0x401)](this['_actor'][_0x575ed1(0x1f1)]());_0x428816[_0x575ed1(0x535)](this[_0x575ed1(0x273)][_0x575ed1(0x4b0)](this));}else{if(!_0x405f74[_0x575ed1(0x2f3)](this['_item']))return![];const _0x4061de=this['getItemConsumableLabel']();this[_0x575ed1(0x2c2)](_0x4061de,_0x35fbab,_0x119426,_0x4a0d09,!![]);const _0xe35eee=this[_0x575ed1(0x2f1)]();return this[_0x575ed1(0x2c2)](_0xe35eee,_0x5aed0c,_0x583d4a,_0x2d61eb,![],_0x575ed1(0x4b9)),this['drawItemDarkRect'](_0x1c3546,_0x20022d,_0x1ab366),this[_0x575ed1(0x4e3)](),!![];}}else this[_0x575ed1(0x377)]();},Window_EquipStatus['prototype'][_0x709961(0x30e)]=function(){const _0x3f981d=_0x709961;return Imported[_0x3f981d(0x651)]&&this[_0x3f981d(0x3bc)]['getMenuImage']()!==''&&VisuMZ[_0x3f981d(0x3db)]['Settings'][_0x3f981d(0x6b4)][_0x3f981d(0x6d3)];},Window_EquipStatus['prototype']['onMenuImageLoad']=function(){const _0x952b6e=_0x709961;VisuMZ['ItemsEquipsCore'][_0x952b6e(0x6b0)]['EquipScene']['DrawPortraitJS'][_0x952b6e(0x376)](this),this[_0x952b6e(0x52a)]();},Window_EquipStatus[_0x709961(0x5ef)][_0x709961(0x377)]=function(){const _0x17a059=_0x709961;VisuMZ['ItemsEquipsCore'][_0x17a059(0x6b0)][_0x17a059(0x6b4)][_0x17a059(0x620)][_0x17a059(0x376)](this),this[_0x17a059(0x52a)]();},Window_EquipStatus[_0x709961(0x5ef)]['drawParamsItemsEquipsCore']=function(){const _0x5af85e=_0x709961;this[_0x5af85e(0x4e3)](),VisuMZ[_0x5af85e(0x3db)][_0x5af85e(0x6b0)][_0x5af85e(0x6b4)][_0x5af85e(0x221)][_0x5af85e(0x376)](this);},Window_EquipStatus[_0x709961(0x5ef)]['drawItemActorMenuImage']=function(_0x31490a,_0x9e87e9,_0x40628a,_0x416e89,_0x242fa5){const _0x46d645=_0x709961,_0x11ba78=ImageManager[_0x46d645(0x401)](_0x31490a['getMenuImage']()),_0x3f4f0a=this[_0x46d645(0x224)]-_0x11ba78[_0x46d645(0x4ca)];_0x9e87e9+=_0x3f4f0a/0x2;if(_0x3f4f0a<0x0)_0x416e89-=_0x3f4f0a;Window_StatusBase[_0x46d645(0x5ef)][_0x46d645(0x1f5)][_0x46d645(0x376)](this,_0x31490a,_0x9e87e9,_0x40628a,_0x416e89,_0x242fa5);},Window_EquipStatus['prototype'][_0x709961(0x2eb)]=function(){const _0x118441=_0x709961;return Imported[_0x118441(0x615)]?VisuMZ['CoreEngine'][_0x118441(0x6b0)][_0x118441(0x512)][_0x118441(0x283)]:[0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7];},Window_EquipStatus[_0x709961(0x5ef)][_0x709961(0x27d)]=function(){const _0x21c01e=_0x709961;return VisuMZ[_0x21c01e(0x3db)][_0x21c01e(0x6b0)][_0x21c01e(0x6b4)][_0x21c01e(0x4bb)];},Window_EquipStatus[_0x709961(0x5ef)][_0x709961(0x39d)]=function(){const _0x8990b3=_0x709961;return Imported[_0x8990b3(0x615)]&&VisuMZ[_0x8990b3(0x516)][_0x8990b3(0x6b0)]['Param'][_0x8990b3(0x426)];},Window_EquipStatus[_0x709961(0x5ef)]['drawUpdatedParamName']=function(_0x25e80d,_0x1688ec,_0x2b5f9e,_0x28b2a3){const _0x495299=_0x709961,_0x3c87ae=this['itemPadding']();Imported[_0x495299(0x615)]?this[_0x495299(0x623)](_0x1688ec+_0x3c87ae,_0x2b5f9e,_0x28b2a3,_0x25e80d,![]):this[_0x495299(0x62c)](TextManager[_0x495299(0x307)](_0x25e80d),_0x1688ec+_0x3c87ae,_0x2b5f9e,_0x28b2a3);},Window_EquipStatus[_0x709961(0x5ef)]['drawUpdatedBeforeParamValue']=function(_0x55beb8,_0x15d4eb,_0x5d5188,_0x462a10){const _0x222b31=_0x709961,_0x3834af=this[_0x222b31(0x407)]();let _0x3b6e41=0x0;if(Imported['VisuMZ_0_CoreEngine'])_0x3b6e41=this[_0x222b31(0x3bc)]['paramValueByName'](_0x55beb8,!![]);else{if(_0x222b31(0x6a9)!==_0x222b31(0x245))_0x3b6e41=this[_0x222b31(0x3bc)][_0x222b31(0x307)](_0x55beb8);else return this[_0x222b31(0x386)]();}const _0x1e8269=_0x3b6e41;this[_0x222b31(0x62c)](_0x3b6e41,_0x15d4eb,_0x5d5188,_0x462a10-_0x3834af,'right');},Window_EquipStatus[_0x709961(0x5ef)][_0x709961(0x454)]=function(_0x51327b,_0x33c08a,_0x5365de,_0xf114a5){const _0x3a772e=_0x709961,_0x3d8d27=this[_0x3a772e(0x407)]();let _0x38fdd9=0x0,_0x1aa3cc=0x0,_0x592a9a='';if(this['_tempActor']){Imported[_0x3a772e(0x615)]?_0x3a772e(0x3f8)===_0x3a772e(0x203)?(_0x54a9f6[_0x3a772e(0x3db)][_0x3a772e(0x369)][_0x3a772e(0x376)](this),this[_0x3a772e(0x6d8)]()&&this[_0x3a772e(0x38e)]()):(_0x38fdd9=this[_0x3a772e(0x3bc)][_0x3a772e(0x29d)](_0x51327b,![]),_0x1aa3cc=this['_tempActor'][_0x3a772e(0x29d)](_0x51327b,![]),_0x592a9a=this[_0x3a772e(0x342)][_0x3a772e(0x29d)](_0x51327b,!![])):(_0x38fdd9=this[_0x3a772e(0x3bc)]['param'](_0x51327b),_0x1aa3cc=this[_0x3a772e(0x342)][_0x3a772e(0x307)](_0x51327b),_0x592a9a=this[_0x3a772e(0x342)]['param'](_0x51327b));const _0x5bc09b=_0x38fdd9,_0x6ee9d6=_0x1aa3cc;diffValue=_0x6ee9d6-_0x5bc09b,this[_0x3a772e(0x61c)](ColorManager[_0x3a772e(0x4da)](diffValue)),this[_0x3a772e(0x62c)](_0x592a9a,_0x33c08a,_0x5365de,_0xf114a5-_0x3d8d27,_0x3a772e(0x4b9));}},Window_EquipStatus[_0x709961(0x5ef)][_0x709961(0x390)]=function(_0x54bc11,_0x3eb9e5,_0x8cc6be,_0xf48e18){const _0x1f579a=_0x709961,_0x4fff92=this[_0x1f579a(0x407)]();let _0x5dfcf2=0x0,_0x235810=0x0,_0x3a0aaa=![];if(this['_tempActor']){if(Imported['VisuMZ_0_CoreEngine']){if(_0x1f579a(0x47d)!=='sysiF')_0x5dfcf2=this[_0x1f579a(0x3bc)][_0x1f579a(0x29d)](_0x54bc11,![]),_0x235810=this['_tempActor'][_0x1f579a(0x29d)](_0x54bc11,![]),_0x3a0aaa=String(this[_0x1f579a(0x3bc)][_0x1f579a(0x29d)](_0x54bc11,!![]))[_0x1f579a(0x1ed)](/([%％])/i);else return _0xb27bec;}else{if(_0x1f579a(0x434)===_0x1f579a(0x434))_0x5dfcf2=this[_0x1f579a(0x3bc)][_0x1f579a(0x307)](_0x54bc11),_0x235810=this[_0x1f579a(0x342)][_0x1f579a(0x307)](_0x54bc11),_0x3a0aaa=_0x5dfcf2%0x1!==0x0||_0x235810%0x1!==0x0;else{if(_0x7e7afd['id']===_0x5af7e1['id'])_0xc036d2+=0x1;}}const _0x583798=_0x5dfcf2,_0x57b722=_0x235810,_0x406264=_0x57b722-_0x583798;let _0x30bca4=_0x406264;if(_0x3a0aaa)_0x30bca4=Math[_0x1f579a(0x284)](_0x406264*0x64)+'%';_0x406264!==0x0&&(this[_0x1f579a(0x61c)](ColorManager['paramchangeTextColor'](_0x406264)),_0x30bca4=(_0x406264>0x0?_0x1f579a(0x60a):_0x1f579a(0x474))[_0x1f579a(0x60c)](_0x30bca4),this[_0x1f579a(0x62c)](_0x30bca4,_0x3eb9e5+_0x4fff92,_0x8cc6be,_0xf48e18,_0x1f579a(0x316)));}},Window_EquipStatus[_0x709961(0x5ef)][_0x709961(0x533)]=function(_0xd3174f,_0x292706,_0x53c73e,_0x382fb0,_0xecd52f){const _0x4e3cc2=_0x709961;if(VisuMZ[_0x4e3cc2(0x3db)][_0x4e3cc2(0x6b0)]['EquipScene'][_0x4e3cc2(0x372)]===![])return;_0xecd52f=Math[_0x4e3cc2(0x5f5)](_0xecd52f||0x1,0x1);while(_0xecd52f--){_0x382fb0=_0x382fb0||this['lineHeight'](),this[_0x4e3cc2(0x30a)][_0x4e3cc2(0x32b)]=0xa0;const _0x43da5d=ColorManager[_0x4e3cc2(0x6a7)]();this[_0x4e3cc2(0x30a)][_0x4e3cc2(0x68d)](_0xd3174f+0x1,_0x292706+0x1,_0x53c73e-0x2,_0x382fb0-0x2,_0x43da5d),this['contents'][_0x4e3cc2(0x32b)]=0xff;}},ColorManager[_0x709961(0x6a7)]=function(){const _0x4232d7=_0x709961,_0x2e6be3=VisuMZ['ItemsEquipsCore'][_0x4232d7(0x6b0)][_0x4232d7(0x6b4)];let _0x216b49=_0x2e6be3['BackRectColor']!==undefined?_0x2e6be3[_0x4232d7(0x658)]:0x13;return ColorManager[_0x4232d7(0x3fd)](_0x216b49);},VisuMZ['ItemsEquipsCore'][_0x709961(0x6b2)]=Window_EquipCommand[_0x709961(0x5ef)]['initialize'],Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x527)]=function(_0x389663){const _0x357bd7=_0x709961;VisuMZ[_0x357bd7(0x3db)][_0x357bd7(0x6b2)][_0x357bd7(0x376)](this,_0x389663),this[_0x357bd7(0x531)](_0x389663);},Window_EquipCommand['prototype'][_0x709961(0x531)]=function(_0x1e4fe2){const _0x237027=_0x709961,_0xc40c02=new Rectangle(0x0,0x0,_0x1e4fe2[_0x237027(0x4ca)],_0x1e4fe2[_0x237027(0x232)]);this[_0x237027(0x3fb)]=new Window_Base(_0xc40c02),this[_0x237027(0x3fb)]['opacity']=0x0,this[_0x237027(0x271)](this[_0x237027(0x3fb)]),this[_0x237027(0x1ce)]();},Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x3d8)]=function(){const _0x5d8b52=_0x709961;Window_HorzCommand[_0x5d8b52(0x5ef)]['callUpdateHelp'][_0x5d8b52(0x376)](this);if(this[_0x5d8b52(0x3fb)])this[_0x5d8b52(0x1ce)]();},Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x1ce)]=function(){const _0x36b701=_0x709961,_0x351659=this[_0x36b701(0x3fb)];_0x351659[_0x36b701(0x30a)][_0x36b701(0x556)]();const _0x189d90=this[_0x36b701(0x2b7)](this[_0x36b701(0x624)]());if(_0x189d90===_0x36b701(0x220)){if(_0x36b701(0x486)!==_0x36b701(0x384)){const _0x1bb979=this[_0x36b701(0x46c)](this[_0x36b701(0x624)]());let _0x4e807c=this[_0x36b701(0x626)](this[_0x36b701(0x624)]());_0x4e807c=_0x4e807c[_0x36b701(0x3a5)](/\\I\[(\d+)\]/gi,''),_0x351659[_0x36b701(0x4e3)](),this[_0x36b701(0x25d)](_0x4e807c,_0x1bb979),this[_0x36b701(0x690)](_0x4e807c,_0x1bb979),this[_0x36b701(0x45a)](_0x4e807c,_0x1bb979);}else{_0x55c139['ItemsEquipsCore'][_0x36b701(0x2c4)][_0x36b701(0x376)](this);if(this[_0x36b701(0x4cc)]())this[_0x36b701(0x69c)]();}}},Window_EquipCommand[_0x709961(0x5ef)]['commandNameWindowDrawBackground']=function(_0x4dc19f,_0x6c7caf){},Window_EquipCommand['prototype'][_0x709961(0x690)]=function(_0x4a6204,_0x517a8a){const _0x393124=_0x709961,_0x392a4d=this[_0x393124(0x3fb)];_0x392a4d[_0x393124(0x62c)](_0x4a6204,0x0,_0x517a8a['y'],_0x392a4d[_0x393124(0x224)],_0x393124(0x50b));},Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x45a)]=function(_0x5d0ffb,_0x5038d7){const _0xf84f7=_0x709961,_0xdbe3df=this['_commandNameWindow'],_0x285713=$gameSystem[_0xf84f7(0x25c)](),_0x43043f=_0x5038d7['x']+Math[_0xf84f7(0x4e5)](_0x5038d7[_0xf84f7(0x4ca)]/0x2)+_0x285713;_0xdbe3df['x']=_0xdbe3df[_0xf84f7(0x4ca)]/-0x2+_0x43043f,_0xdbe3df['y']=Math[_0xf84f7(0x4e5)](_0x5038d7['height']/0x2);},Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x6d8)]=function(){const _0x349154=_0x709961;return Imported['VisuMZ_0_CoreEngine']&&Window_HorzCommand['prototype']['isUseModernControls'][_0x349154(0x376)](this);},Window_EquipCommand['prototype'][_0x709961(0x405)]=function(){const _0x2728b7=_0x709961;if(this[_0x2728b7(0x1c4)]()==='equip')Window_HorzCommand[_0x2728b7(0x5ef)][_0x2728b7(0x405)][_0x2728b7(0x376)](this);},Window_EquipCommand['prototype'][_0x709961(0x67e)]=function(){const _0x373300=_0x709961;!this[_0x373300(0x2f7)]()&&('slzKt'===_0x373300(0x458)?Window_HorzCommand['prototype'][_0x373300(0x67e)][_0x373300(0x376)](this):_0x153f60['prototype'][_0x373300(0x2ef)][_0x373300(0x376)](this));},Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x2f7)]=function(){const _0x2ec9aa=_0x709961;if(!this[_0x2ec9aa(0x565)]())return![];if(SceneManager[_0x2ec9aa(0x6c1)][_0x2ec9aa(0x3f7)]!==Scene_Equip)return![];if(Input[_0x2ec9aa(0x5c1)]('down')){if('YXocE'!==_0x2ec9aa(0x6d6)){if(!this[_0x2ec9aa(0x342)]){const _0x244c1a=_0x58fd7b[_0x2ec9aa(0x340)](this);_0x244c1a['_tempActor']=!![],_0x2861e6['ItemsEquipsCore'][_0x2ec9aa(0x35d)][_0x2ec9aa(0x376)](this,_0x21716e,_0x5ce95e),this[_0x2ec9aa(0x267)](_0x244c1a);}else _0x556400[_0x2ec9aa(0x3db)][_0x2ec9aa(0x35d)][_0x2ec9aa(0x376)](this,_0x1592e3,_0x5a6bf5);}else this[_0x2ec9aa(0x538)]();}return![];},Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x538)]=function(){const _0x331ae8=_0x709961;this[_0x331ae8(0x5d0)](),SceneManager[_0x331ae8(0x6c1)]['commandEquip'](),SceneManager[_0x331ae8(0x6c1)][_0x331ae8(0x3f9)][_0x331ae8(0x1de)](-0x1);},Window_EquipCommand[_0x709961(0x5ef)]['maxCols']=function(){const _0x1d6a2f=_0x709961;return this[_0x1d6a2f(0x3dc)]?this[_0x1d6a2f(0x3dc)][_0x1d6a2f(0x321)]:0x3;},Window_EquipCommand[_0x709961(0x5ef)]['processTouchModernControls']=function(){const _0x52d37f=_0x709961;if(this[_0x52d37f(0x4b8)]()&&this[_0x52d37f(0x1f7)]&&SceneManager[_0x52d37f(0x6c1)][_0x52d37f(0x3f7)]===Scene_Equip){if(this[_0x52d37f(0x1ee)]()&&TouchInput['isHovered']())this['onTouchSelectModernControls'](![]);else TouchInput[_0x52d37f(0x5c1)]()&&this['onTouchSelectModernControls'](!![]);TouchInput[_0x52d37f(0x536)]()&&this[_0x52d37f(0x3df)]();}},Window_EquipCommand['prototype']['onTouchSelectModernControls']=function(_0x22c809){const _0x415828=_0x709961;this[_0x415828(0x56a)]=![];const _0xb94d63=this[_0x415828(0x624)](),_0x38caf7=this['hitIndex'](),_0xd70d1e=SceneManager[_0x415828(0x6c1)][_0x415828(0x3f9)];if(_0xd70d1e[_0x415828(0x4b8)]()&&_0xd70d1e[_0x415828(0x1f7)]){if(_0x38caf7>=0x0){if(_0x415828(0x6bd)!==_0x415828(0x6bd))return this[_0x415828(0x4de)](_0x398f8a[_0x415828(0x3e1)]);else _0x38caf7===this['index']()&&(this[_0x415828(0x56a)]=!![]),this[_0x415828(0x55a)](),this[_0x415828(0x2a0)](_0x38caf7);}else{if(_0xd70d1e[_0x415828(0x2bb)]()>=0x0){if(_0x415828(0x2ed)!=='kWtfG')this[_0x415828(0x6df)](),this[_0x415828(0x6cb)]();else{if(this['isItem'](_0x2e490f))return![];if(!_0x19c1cd)return![];if(_0x4c8151[_0x415828(0x61d)])return!![];if(_0x2139c7[_0x415828(0x208)]())return!![];const _0x3c6882=this['getEquipRequirements'](_0x48b702);for(const _0x44cb6e of _0x3c6882){if(!this[_0x415828(0x687)](_0x5a2ef1,_0x44cb6e))return![];}return!![];}}}}_0x22c809&&this[_0x415828(0x624)]()!==_0xb94d63&&this['playCursorSound']();},Window_EquipCommand['prototype']['makeCommandList']=function(){const _0x26d921=_0x709961;this['addEquipCommand'](),this[_0x26d921(0x539)](),this[_0x26d921(0x3a0)]();},Window_EquipCommand[_0x709961(0x5ef)]['refresh']=function(){const _0x5c00f4=_0x709961;Window_HorzCommand[_0x5c00f4(0x5ef)][_0x5c00f4(0x349)][_0x5c00f4(0x376)](this),this[_0x5c00f4(0x606)]();},Window_EquipCommand['prototype'][_0x709961(0x2fa)]=function(){const _0x580072=_0x709961;if(!this[_0x580072(0x230)]())return;const _0x1382e4=this['commandStyle'](),_0x303a7c=VisuMZ[_0x580072(0x3db)]['Settings'][_0x580072(0x6b4)][_0x580072(0x640)],_0x2434cb=_0x1382e4===_0x580072(0x461)?TextManager[_0x580072(0x4d6)]:_0x580072(0x297)['format'](_0x303a7c,TextManager[_0x580072(0x4d6)]),_0x18e154=this[_0x580072(0x6c9)]();this[_0x580072(0x1cb)](_0x2434cb,_0x580072(0x530),_0x18e154);},Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x230)]=function(){const _0x14809a=_0x709961;return!this[_0x14809a(0x6d8)]();},Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x6c9)]=function(){return!![];},Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x539)]=function(){const _0x49c306=_0x709961;if(!this['isOptimizeCommandAdded']())return;const _0x50eca0=this[_0x49c306(0x1be)](),_0x4023b1=VisuMZ[_0x49c306(0x3db)][_0x49c306(0x6b0)][_0x49c306(0x6b4)][_0x49c306(0x5bb)],_0xa4c7a2=_0x50eca0==='text'?TextManager['optimize']:_0x49c306(0x297)[_0x49c306(0x60c)](_0x4023b1,TextManager[_0x49c306(0x49d)]),_0x157463=this[_0x49c306(0x201)]();this[_0x49c306(0x1cb)](_0xa4c7a2,_0x49c306(0x49d),_0x157463);},Window_EquipCommand[_0x709961(0x5ef)]['isOptimizeCommandAdded']=function(){const _0x466a9a=_0x709961;return VisuMZ[_0x466a9a(0x3db)][_0x466a9a(0x6b0)][_0x466a9a(0x6b4)][_0x466a9a(0x292)];},Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x201)]=function(){return!![];},Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x3a0)]=function(){const _0x535bfc=_0x709961;if(!this[_0x535bfc(0x639)]())return;const _0x1a73f7=this['commandStyle'](),_0x796f69=VisuMZ[_0x535bfc(0x3db)][_0x535bfc(0x6b0)]['EquipScene']['CmdIconClear'],_0x5ce7b4=_0x1a73f7===_0x535bfc(0x461)?TextManager['clear']:_0x535bfc(0x297)['format'](_0x796f69,TextManager[_0x535bfc(0x556)]),_0x50186f=this[_0x535bfc(0x59e)]();this[_0x535bfc(0x1cb)](_0x5ce7b4,'clear',_0x50186f);},Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x639)]=function(){const _0x2baa0f=_0x709961;return VisuMZ[_0x2baa0f(0x3db)][_0x2baa0f(0x6b0)][_0x2baa0f(0x6b4)][_0x2baa0f(0x578)];},Window_EquipCommand['prototype']['isClearCommandEnabled']=function(){return!![];},Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x27b)]=function(){const _0x40b7e4=_0x709961;return VisuMZ[_0x40b7e4(0x3db)][_0x40b7e4(0x6b0)][_0x40b7e4(0x6b4)][_0x40b7e4(0x34d)];},Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x602)]=function(_0x213562){const _0x5aade1=_0x709961,_0x815c0=this[_0x5aade1(0x2b7)](_0x213562);if(_0x815c0===_0x5aade1(0x3be))this['drawItemStyleIconText'](_0x213562);else _0x815c0==='icon'?this[_0x5aade1(0x4ec)](_0x213562):Window_HorzCommand[_0x5aade1(0x5ef)][_0x5aade1(0x602)][_0x5aade1(0x376)](this,_0x213562);},Window_EquipCommand[_0x709961(0x5ef)]['commandStyle']=function(){const _0x2013f3=_0x709961;return VisuMZ[_0x2013f3(0x3db)][_0x2013f3(0x6b0)][_0x2013f3(0x6b4)][_0x2013f3(0x521)];},Window_EquipCommand[_0x709961(0x5ef)]['commandStyleCheck']=function(_0xe8c956){const _0x4ed37b=_0x709961;if(_0xe8c956<0x0)return'text';const _0x6fac38=this[_0x4ed37b(0x1be)]();if(_0x6fac38!==_0x4ed37b(0x28f))return _0x4ed37b(0x526)===_0x4ed37b(0x526)?_0x6fac38:this[_0x4ed37b(0x6d8)]()?![]:_0x4f7327['prototype']['isHoverEnabled'][_0x4ed37b(0x376)](this);else{if(this['maxItems']()>0x0){const _0xb61870=this[_0x4ed37b(0x626)](_0xe8c956);if(_0xb61870[_0x4ed37b(0x1ed)](/\\I\[(\d+)\]/i)){const _0x46fa61=this[_0x4ed37b(0x46c)](_0xe8c956),_0x22030d=this[_0x4ed37b(0x66a)](_0xb61870)[_0x4ed37b(0x4ca)];return _0x22030d<=_0x46fa61[_0x4ed37b(0x4ca)]?'iconText':_0x4ed37b(0x220);}}}return'text';},Window_EquipCommand['prototype'][_0x709961(0x2f5)]=function(_0x486c8c){const _0x4a0508=_0x709961,_0xf44c2b=this['itemLineRect'](_0x486c8c),_0x18e1bf=this[_0x4a0508(0x626)](_0x486c8c),_0x2fca4e=this['textSizeEx'](_0x18e1bf)['width'];this[_0x4a0508(0x403)](this['isCommandEnabled'](_0x486c8c));const _0x472e1a=this[_0x4a0508(0x27b)]();if(_0x472e1a==='right'){if(_0x4a0508(0x206)!=='qGmbe')this[_0x4a0508(0x6ba)](_0x18e1bf,_0xf44c2b['x']+_0xf44c2b[_0x4a0508(0x4ca)]-_0x2fca4e,_0xf44c2b['y'],_0x2fca4e);else{if(_0x316d4e[_0x4a0508(0x6c1)]['constructor']===_0x58be7f)return _0xebe83d[_0x4a0508(0x3db)][_0x4a0508(0x370)]['call'](this);else return _0x23444e['_scene'][_0x4a0508(0x3f7)]===_0x26ee5f?_0x4b7df3['ItemsEquipsCore'][_0x4a0508(0x370)][_0x4a0508(0x376)](this):_0x3cdd62[_0x4a0508(0x3db)][_0x4a0508(0x6b0)][_0x4a0508(0x309)][_0x4a0508(0x537)];}}else{if(_0x472e1a===_0x4a0508(0x50b)){if(_0x4a0508(0x42b)!==_0x4a0508(0x42b)){const _0x596d6f=this[_0x4a0508(0x62f)](),_0x4be875=this[_0x4a0508(0x2ec)][_0x4a0508(0x232)],_0x8fbe6=this[_0x4a0508(0x2ef)]()?0x0:_0x345c47['boxWidth']-this['statusWidth'](),_0x12b80f=this[_0x4a0508(0x2ec)]['y'];return new _0x3884dc(_0x8fbe6,_0x12b80f,_0x596d6f,_0x4be875);}else{const _0x40ba6f=_0xf44c2b['x']+Math['floor']((_0xf44c2b[_0x4a0508(0x4ca)]-_0x2fca4e)/0x2);this[_0x4a0508(0x6ba)](_0x18e1bf,_0x40ba6f,_0xf44c2b['y'],_0x2fca4e);}}else _0x4a0508(0x3ac)!==_0x4a0508(0x3ac)?this['cursorRight'](_0x4acb1b[_0x4a0508(0x5c1)](_0x4a0508(0x5af))):this[_0x4a0508(0x6ba)](_0x18e1bf,_0xf44c2b['x'],_0xf44c2b['y'],_0x2fca4e);}},Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x4ec)]=function(_0x2292c1){const _0x5d5f31=_0x709961;this[_0x5d5f31(0x626)](_0x2292c1)[_0x5d5f31(0x1ed)](/\\I\[(\d+)\]/i);const _0x48e7d5=Number(RegExp['$1'])||0x0,_0x1ebe7c=this[_0x5d5f31(0x46c)](_0x2292c1),_0x160277=_0x1ebe7c['x']+Math[_0x5d5f31(0x4e5)]((_0x1ebe7c[_0x5d5f31(0x4ca)]-ImageManager[_0x5d5f31(0x357)])/0x2),_0x3801e5=_0x1ebe7c['y']+(_0x1ebe7c[_0x5d5f31(0x232)]-ImageManager['iconHeight'])/0x2;this[_0x5d5f31(0x25a)](_0x48e7d5,_0x160277,_0x3801e5);},Window_EquipCommand['prototype'][_0x709961(0x67f)]=function(){const _0x16c62a=_0x709961,_0x3b4da7=SceneManager[_0x16c62a(0x6c1)];if(_0x3b4da7&&_0x3b4da7['user'])return _0x16c62a(0x1c7)===_0x16c62a(0x1c7)?_0x3b4da7[_0x16c62a(0x2cd)]():_0x5cc5a3['getInputMultiButtonStrings']('up',_0x16c62a(0x32a));return null;},Window_EquipCommand[_0x709961(0x5ef)][_0x709961(0x317)]=function(){const _0x3a3028=_0x709961;Window_Command[_0x3a3028(0x5ef)]['updateHelp']['call'](this),this[_0x3a3028(0x2c3)][_0x3a3028(0x56f)](this[_0x3a3028(0x1df)]());},Window_EquipCommand['prototype'][_0x709961(0x1df)]=function(){const _0x129c97=_0x709961,_0x57ef97=this[_0x129c97(0x1c4)]();switch(_0x57ef97){case _0x129c97(0x530):return TextManager['ITEMS_EQUIPS_CORE'][_0x129c97(0x483)][_0x129c97(0x530)];case _0x129c97(0x49d):return TextManager[_0x129c97(0x5e9)]['helpDesc'][_0x129c97(0x49d)];case _0x129c97(0x556):return TextManager[_0x129c97(0x5e9)][_0x129c97(0x483)]['clear'];default:return'';}},Window_EquipSlot['prototype']['isUseModernControls']=function(){const _0x5d825a=_0x709961;return Imported['VisuMZ_0_CoreEngine']&&Window_HorzCommand[_0x5d825a(0x5ef)][_0x5d825a(0x6d8)]['call'](this);},Window_EquipSlot['prototype'][_0x709961(0x55a)]=function(){const _0x34b59e=_0x709961;Window_StatusBase[_0x34b59e(0x5ef)][_0x34b59e(0x55a)]['call'](this),this[_0x34b59e(0x3d8)]();},Window_EquipSlot[_0x709961(0x5ef)][_0x709961(0x61e)]=function(){const _0x3aaae5=_0x709961;Window_StatusBase[_0x3aaae5(0x5ef)][_0x3aaae5(0x61e)][_0x3aaae5(0x376)](this),this[_0x3aaae5(0x3c6)]();},Window_EquipSlot[_0x709961(0x5ef)][_0x709961(0x3c6)]=function(){const _0x1b9818=_0x709961;if(!this['isShiftRemoveShortcutEnabled']())return;if(Input[_0x1b9818(0x5c1)](_0x1b9818(0x5ce))&&this[_0x1b9818(0x24d)]()){const _0x4185a7=SceneManager[_0x1b9818(0x6c1)][_0x1b9818(0x3bc)];if(_0x4185a7){if(this['canShiftRemoveEquipment'](this[_0x1b9818(0x624)]())){if(_0x1b9818(0x308)===_0x1b9818(0x5bd)){this[_0x1b9818(0x1bd)]=!![];const _0x43f0e7=_0x64bff4['ItemsEquipsCore'][_0x1b9818(0x2a6)][_0x1b9818(0x376)](this);return this['_allowArtifactTraitObjects']=_0x513243,_0x43f0e7;}else this['processShiftRemoveShortcut'](),this[_0x1b9818(0x317)]();}else this[_0x1b9818(0x2ac)]();}}},Window_EquipSlot[_0x709961(0x5ef)][_0x709961(0x22a)]=function(_0x202158){const _0x439bca=_0x709961,_0x59abea=SceneManager[_0x439bca(0x6c1)][_0x439bca(0x3bc)];if(!_0x59abea)return;if(!_0x59abea['isEquipChangeOk'](_0x202158))return![];const _0x48cd12=_0x59abea[_0x439bca(0x252)]()[_0x202158];if(_0x59abea['nonRemovableEtypes']()['includes'](_0x48cd12))return![];return!![];;},Window_EquipSlot[_0x709961(0x5ef)][_0x709961(0x3ad)]=function(){const _0x574710=_0x709961;SoundManager[_0x574710(0x28a)]();const _0x3efa94=SceneManager[_0x574710(0x6c1)]['_actor'];_0x3efa94[_0x574710(0x274)](this[_0x574710(0x624)](),null),this[_0x574710(0x349)](),this['_itemWindow']['refresh'](),this['callUpdateHelp']();const _0x380ea1=SceneManager['_scene'][_0x574710(0x633)];if(_0x380ea1)_0x380ea1[_0x574710(0x349)]();},Window_EquipSlot['prototype'][_0x709961(0x466)]=function(){const _0x1b968a=_0x709961;if(!this[_0x1b968a(0x3bd)])return![];if(!VisuMZ['ItemsEquipsCore'][_0x1b968a(0x6b0)]['EquipScene'][_0x1b968a(0x469)])return![];return!![];},Window_EquipSlot[_0x709961(0x5ef)][_0x709961(0x67e)]=function(){const _0x201a44=_0x709961;if(!this[_0x201a44(0x2f7)]()){if(_0x201a44(0x2f2)!==_0x201a44(0x2f2)){const _0x76100c=this[_0x201a44(0x5fd)][this['_equips']['length']-0x1];_0x76100c&&_0x76100c[_0x201a44(0x2c6)]()&&_0x21bc54[_0x201a44(0x2a5)](_0x76100c[_0x201a44(0x2c6)](),0x1),this[_0x201a44(0x5fd)][_0x201a44(0x21b)]();}else Window_StatusBase[_0x201a44(0x5ef)][_0x201a44(0x67e)]['call'](this);}},Window_EquipSlot['prototype']['processCursorSpecialCheckModernControls']=function(){const _0x5a143f=_0x709961;if(!this[_0x5a143f(0x565)]())return![];if(SceneManager[_0x5a143f(0x6c1)]['constructor']!==Scene_Equip)return![];if(this[_0x5a143f(0x49b)]())return _0x5a143f(0x1dd)===_0x5a143f(0x3e8)?_0x38788d[_0x5a143f(0x615)]&&_0x16f4cf[_0x5a143f(0x5ef)][_0x5a143f(0x6d8)]['call'](this):(this[_0x5a143f(0x5d0)](),Input[_0x5a143f(0x556)](),SceneManager[_0x5a143f(0x6c1)][_0x5a143f(0x236)](),![]);else{if(Input[_0x5a143f(0x27f)](_0x5a143f(0x32a))){const _0x57cd93=this[_0x5a143f(0x624)]();if(Input[_0x5a143f(0x40b)](_0x5a143f(0x5ce))){if(_0x5a143f(0x579)!=='IBSZk')this[_0x5a143f(0x222)]();else{const _0x28cd97=_0x39d040(_0x565105['$1'])[_0x5a143f(0x617)](/[\r\n]+/);for(const _0x3dde4a of _0x28cd97){const _0x2f151f=_0x393d58[_0x5a143f(0x532)](_0x3dde4a['trim']());if(_0x2f151f>0x0)_0x442b2b['equipSlots'][_0x5a143f(0x4ba)](_0x2f151f);}}}else _0x5a143f(0x3b6)===_0x5a143f(0x670)?this[_0x5a143f(0x4ec)](_0x3b2dbc):this[_0x5a143f(0x1cf)](Input[_0x5a143f(0x5c1)](_0x5a143f(0x32a)));return this[_0x5a143f(0x624)]()!==_0x57cd93&&this[_0x5a143f(0x5d0)](),!![];}else{if(this[_0x5a143f(0x585)]()&&Input[_0x5a143f(0x5c1)](_0x5a143f(0x5ce)))return!![];}}return![];},Window_EquipSlot[_0x709961(0x5ef)]['allowCommandWindowCursorUp']=function(){const _0x38fee8=_0x709961;if(this[_0x38fee8(0x624)]()!==0x0)return![];const _0x1f4b66=VisuMZ[_0x38fee8(0x3db)][_0x38fee8(0x6b0)][_0x38fee8(0x6b4)];if(!_0x1f4b66[_0x38fee8(0x292)]&&!_0x1f4b66['CommandAddClear'])return![];return Input[_0x38fee8(0x5c1)]('up');},Window_EquipSlot[_0x709961(0x5ef)]['isShiftShortcutKeyForRemove']=function(){const _0x1ac858=_0x709961;return VisuMZ[_0x1ac858(0x3db)][_0x1ac858(0x6b0)]['EquipScene']['ShiftShortcutKey'];},Window_EquipSlot[_0x709961(0x5ef)][_0x709961(0x3d6)]=function(){const _0xc1827b=_0x709961;if(this[_0xc1827b(0x4b8)]()&&this['visible']&&SceneManager[_0xc1827b(0x6c1)][_0xc1827b(0x3f7)]===Scene_Equip){if(this[_0xc1827b(0x1ee)]()&&TouchInput['isHovered']())this[_0xc1827b(0x1d6)](![]);else TouchInput['isTriggered']()&&this[_0xc1827b(0x1d6)](!![]);if(TouchInput[_0xc1827b(0x536)]())_0xc1827b(0x6b5)!==_0xc1827b(0x234)?this[_0xc1827b(0x3df)]():(_0x5f3965['ItemsEquipsCore'][_0xc1827b(0x6b2)][_0xc1827b(0x376)](this,_0x144dcb),this[_0xc1827b(0x531)](_0x7eb12e));else TouchInput[_0xc1827b(0x5ab)]()&&this[_0xc1827b(0x1c1)]();}},Window_EquipSlot[_0x709961(0x5ef)][_0x709961(0x1d6)]=function(_0x29a3b3){const _0xf7049d=_0x709961;this[_0xf7049d(0x56a)]=![];const _0x42ac70=this['index'](),_0x47b693=this[_0xf7049d(0x2bb)](),_0x55c554=SceneManager[_0xf7049d(0x6c1)][_0xf7049d(0x1a6)];if(_0x55c554['isOpen']()&&_0x55c554[_0xf7049d(0x1f7)]){if(_0x47b693>=0x0)_0x47b693===this[_0xf7049d(0x624)]()&&(this[_0xf7049d(0x56a)]=!![]),this[_0xf7049d(0x55a)](),this['select'](_0x47b693);else _0x55c554[_0xf7049d(0x2bb)]()>=0x0&&(this[_0xf7049d(0x6df)](),this[_0xf7049d(0x6cb)]());}if(_0x29a3b3&&this['index']()!==_0x42ac70){if(_0xf7049d(0x671)===_0xf7049d(0x1d0)){const _0x476685=_0x26aef2[_0xf7049d(0x340)](this);_0x476685['_tempActor']=!![],this[_0xf7049d(0x1d5)](_0x4eec53,_0x5fa0e3),this[_0xf7049d(0x267)](_0x476685);}else this['playCursorSound']();}},Window_EquipSlot['prototype'][_0x709961(0x2e9)]=function(){const _0xdf594b=_0x709961;return this[_0xdf594b(0x624)]();},VisuMZ['ItemsEquipsCore'][_0x709961(0x5c8)]=Window_EquipItem[_0x709961(0x5ef)]['includes'],Window_EquipItem[_0x709961(0x5ef)][_0x709961(0x3bb)]=function(_0x2a60d0){const _0x73d113=_0x709961;if(_0x2a60d0===null&&this[_0x73d113(0x290)]()[_0x73d113(0x3bb)](this[_0x73d113(0x5fe)]()))return![];else{$gameTemp[_0x73d113(0x61d)]=!![];let _0x58dc62=VisuMZ[_0x73d113(0x3db)][_0x73d113(0x5c8)]['call'](this,_0x2a60d0);if(!_0x58dc62&&_0x2a60d0&&DataManager[_0x73d113(0x3b3)](_0x2a60d0)){const _0x81def7=_0x2a60d0[_0x73d113(0x3e1)]||0x0;if(this[_0x73d113(0x3bc)]&&this[_0x73d113(0x3bc)][_0x73d113(0x4de)](_0x81def7)){const _0x3a89d2=DataManager[_0x73d113(0x323)](_0x2a60d0);_0x3a89d2[_0x73d113(0x3bb)](this['etypeId']())&&(_0x58dc62=!![]);}}return $gameTemp[_0x73d113(0x61d)]=undefined,_0x58dc62;}},VisuMZ[_0x709961(0x3db)][_0x709961(0x6c0)]=Window_EquipItem[_0x709961(0x5ef)][_0x709961(0x24b)],Window_EquipItem[_0x709961(0x5ef)][_0x709961(0x24b)]=function(_0x260a8a){const _0x9c7270=_0x709961;if(_0x260a8a&&this[_0x9c7270(0x3bc)]){if(_0x9c7270(0x431)===_0x9c7270(0x543)){let _0x3667d6=_0x47e49e[_0x9c7270(0x3db)][_0x9c7270(0x38c)][_0x9c7270(0x376)](this,_0xed5ab9);if(this[_0x9c7270(0x3f7)]===_0x4de513)for(const _0x3c27aa of _0x5ed65b[_0x9c7270(0x428)]()){if(_0x3c27aa)_0x3667d6+=_0x3c27aa[_0x9c7270(0x63a)][_0x480c60];}return _0x3667d6;}else{if(this[_0x9c7270(0x20e)](_0x260a8a))return![];if(this[_0x9c7270(0x3f0)](_0x260a8a))return![];if(this[_0x9c7270(0x356)](_0x260a8a))return![];if(!this[_0x9c7270(0x3bc)][_0x9c7270(0x447)](_0x260a8a))return![];}}if(!_0x260a8a)return!this[_0x9c7270(0x290)]()[_0x9c7270(0x3bb)](this[_0x9c7270(0x5fe)]());return VisuMZ['ItemsEquipsCore'][_0x9c7270(0x6c0)][_0x9c7270(0x376)](this,_0x260a8a);},Window_EquipItem[_0x709961(0x5ef)]['itemHasEquipLimit']=function(_0x45ee4c){const _0x3fa358=_0x709961,_0x209cef=_0x45ee4c['note'];if(_0x209cef[_0x3fa358(0x1ed)](/<EQUIP COPY LIMIT:[ ](\d+)>/i)){if('CousE'!==_0x3fa358(0x6e6))return![];else{const _0x585c8a=Number(RegExp['$1'])||0x1;let _0x59bd1c=0x0;const _0x1d274a=this[_0x3fa358(0x3bc)][_0x3fa358(0x673)](),_0x58b9af=SceneManager['_scene'][_0x3fa358(0x3f9)][_0x3fa358(0x2e9)]();_0x1d274a[_0x58b9af]=null;for(const _0x2f7401 of _0x1d274a){if(!_0x2f7401)continue;if(DataManager[_0x3fa358(0x67a)](_0x45ee4c)===DataManager[_0x3fa358(0x67a)](_0x2f7401)){if(_0x45ee4c['id']===_0x2f7401['id'])_0x59bd1c+=0x1;}}return _0x59bd1c>=_0x585c8a;}}else{if(_0x3fa358(0x645)!=='AIuOv')return![];else{const _0x1598d0=_0x5a79e0(_0x7539ce['$1'])[_0x3fa358(0x3c4)](),_0x44197c=/^\d+$/['test'](_0x1598d0);if(_0x44197c){if(this['isWeapon'](_0x486789))return _0x1bb602[_0x1afae4(_0x1598d0)];if(this[_0x3fa358(0x3b3)](_0x1f43b2))return _0x1c1bf5[_0x51a992(_0x1598d0)];}else{if(this[_0x3fa358(0x67a)](_0x2d9faf))return _0x49ff0e[this[_0x3fa358(0x278)](_0x1598d0)];if(this['isArmor'](_0x40d7ab))return _0x18abaa[this[_0x3fa358(0x3c5)](_0x1598d0)];}}}},Window_EquipItem[_0x709961(0x5ef)][_0x709961(0x3f0)]=function(_0x43b58f){const _0x3fa6e8=_0x709961;if(!DataManager[_0x3fa6e8(0x67a)](_0x43b58f))return![];const _0x3c9f3d=/<EQUIP WEAPON TYPE LIMIT:[ ](\d+)>/i;let _0xd8aa7a=0x0;const _0x4ebcde=this[_0x3fa6e8(0x3bc)]['equips'](),_0x2c2886=SceneManager[_0x3fa6e8(0x6c1)][_0x3fa6e8(0x3f9)]['equipSlotIndex']();_0x4ebcde[_0x2c2886]=null;for(const _0x31b5f6 of _0x4ebcde){if(_0x3fa6e8(0x519)==='WxgPR')return this[_0x3fa6e8(0x5b5)]();else{if(!_0x31b5f6)continue;if(!DataManager['isWeapon'](_0x31b5f6))continue;if(_0x43b58f[_0x3fa6e8(0x4f2)]===_0x31b5f6[_0x3fa6e8(0x4f2)]){_0xd8aa7a+=0x1;if(_0x43b58f[_0x3fa6e8(0x1e9)][_0x3fa6e8(0x1ed)](_0x3c9f3d)){const _0x14f09c=Number(RegExp['$1'])||0x1;if(_0xd8aa7a>=_0x14f09c)return!![];}if(_0x31b5f6[_0x3fa6e8(0x1e9)][_0x3fa6e8(0x1ed)](_0x3c9f3d)){const _0x2e482c=Number(RegExp['$1'])||0x1;if(_0xd8aa7a>=_0x2e482c)return!![];}}}}return![];},Window_EquipItem[_0x709961(0x5ef)][_0x709961(0x356)]=function(_0x1f5fa2){const _0x33f310=_0x709961;if(!DataManager[_0x33f310(0x3b3)](_0x1f5fa2))return![];const _0x1060d4=/<EQUIP ARMOR TYPE LIMIT:[ ](\d+)>/i;let _0x2148c6=0x0;const _0x21bdca=this[_0x33f310(0x3bc)]['equips'](),_0x11d4a2=SceneManager[_0x33f310(0x6c1)][_0x33f310(0x3f9)][_0x33f310(0x2e9)]();_0x21bdca[_0x11d4a2]=null;for(const _0x530df8 of _0x21bdca){if(!_0x530df8)continue;if(!DataManager[_0x33f310(0x3b3)](_0x530df8))continue;if(_0x1f5fa2[_0x33f310(0x3e1)]===_0x530df8['atypeId']){_0x2148c6+=0x1;if(_0x1f5fa2[_0x33f310(0x1e9)][_0x33f310(0x1ed)](_0x1060d4)){const _0x374e45=Number(RegExp['$1'])||0x1;if(_0x2148c6>=_0x374e45)return!![];}if(_0x530df8[_0x33f310(0x1e9)]['match'](_0x1060d4)){if(_0x33f310(0x6a2)==='LJHNs'){const _0x2f29be=Number(RegExp['$1'])||0x1;if(_0x2148c6>=_0x2f29be)return!![];}else return this[_0x33f310(0x1bb)]();}}}return![];},Window_EquipItem[_0x709961(0x5ef)][_0x709961(0x290)]=function(){const _0x1c5e85=_0x709961;return VisuMZ[_0x1c5e85(0x3db)][_0x1c5e85(0x6b0)][_0x1c5e85(0x6b4)]['NonRemoveETypes'];},Window_EquipItem[_0x709961(0x5ef)][_0x709961(0x602)]=function(_0x2005fb){const _0x1e4e51=_0x709961,_0x2438ea=this[_0x1e4e51(0x364)](_0x2005fb);if(_0x2438ea){if('RLrxx'===_0x1e4e51(0x680)){const _0x5eb0f7='QUANTITY';if(this[_0x1e4e51(0x3b8)][_0x5eb0f7])return this['_customItemInfo'][_0x5eb0f7];const _0x1e37c3=_0x4152d7['ItemsEquipsCore'][_0x1e4e51(0x6b0)][_0x1e4e51(0x309)][_0x1e4e51(0x5b8)];return _0x1e37c3['format'](_0xdef943[_0x1e4e51(0x402)](this[_0x1e4e51(0x3c2)]));}else Window_ItemList[_0x1e4e51(0x5ef)]['drawItem'][_0x1e4e51(0x376)](this,_0x2005fb);}else this[_0x1e4e51(0x353)](_0x2005fb);},Window_EquipItem[_0x709961(0x5ef)][_0x709961(0x353)]=function(_0x349e5c){const _0x41e1cc=_0x709961;this[_0x41e1cc(0x403)](this[_0x41e1cc(0x24b)](null));const _0x4fd988=VisuMZ['ItemsEquipsCore'][_0x41e1cc(0x6b0)][_0x41e1cc(0x6b4)],_0x5453c2=this[_0x41e1cc(0x46c)](_0x349e5c),_0x3ef48f=_0x5453c2['y']+(this[_0x41e1cc(0x361)]()-ImageManager['iconHeight'])/0x2,_0x24f962=ImageManager['iconWidth']+0x4,_0x48b575=Math[_0x41e1cc(0x5f5)](0x0,_0x5453c2[_0x41e1cc(0x4ca)]-_0x24f962);this[_0x41e1cc(0x1c0)](),this[_0x41e1cc(0x25a)](_0x4fd988[_0x41e1cc(0x53f)],_0x5453c2['x'],_0x3ef48f),this[_0x41e1cc(0x62c)](_0x4fd988[_0x41e1cc(0x619)],_0x5453c2['x']+_0x24f962,_0x5453c2['y'],_0x48b575),this[_0x41e1cc(0x403)](!![]);},Window_EquipItem[_0x709961(0x5ef)]['updateHelp']=function(){const _0xa4603e=_0x709961;Window_ItemList[_0xa4603e(0x5ef)][_0xa4603e(0x317)][_0xa4603e(0x376)](this);if(this[_0xa4603e(0x3bc)]&&this[_0xa4603e(0x633)]&&this[_0xa4603e(0x3c3)]>=0x0){const _0x1a5231=JsonEx['makeDeepCopy'](this[_0xa4603e(0x3bc)]);_0x1a5231[_0xa4603e(0x342)]=!![],_0x1a5231[_0xa4603e(0x335)](this[_0xa4603e(0x3c3)],this['item']()),this['_statusWindow'][_0xa4603e(0x465)](_0x1a5231);}},VisuMZ[_0x709961(0x3db)][_0x709961(0x1ae)]=Window_ShopCommand[_0x709961(0x5ef)]['initialize'],Window_ShopCommand[_0x709961(0x5ef)][_0x709961(0x527)]=function(_0x3709e2){const _0x282948=_0x709961;VisuMZ['ItemsEquipsCore'][_0x282948(0x1ae)][_0x282948(0x376)](this,_0x3709e2),this[_0x282948(0x531)](_0x3709e2);},Window_ShopCommand[_0x709961(0x5ef)][_0x709961(0x531)]=function(_0x6f1ca1){const _0x357fb1=_0x709961,_0x118da1=new Rectangle(0x0,0x0,_0x6f1ca1['width'],_0x6f1ca1[_0x357fb1(0x232)]);this['_commandNameWindow']=new Window_Base(_0x118da1),this[_0x357fb1(0x3fb)][_0x357fb1(0x4be)]=0x0,this[_0x357fb1(0x271)](this[_0x357fb1(0x3fb)]),this[_0x357fb1(0x1ce)]();},Window_ShopCommand[_0x709961(0x5ef)][_0x709961(0x3d8)]=function(){const _0x267f6a=_0x709961;Window_HorzCommand[_0x267f6a(0x5ef)][_0x267f6a(0x3d8)]['call'](this);if(this[_0x267f6a(0x3fb)])this[_0x267f6a(0x1ce)]();},Window_ShopCommand[_0x709961(0x5ef)]['updateCommandNameWindow']=function(){const _0x1ec5ef=_0x709961,_0x218467=this[_0x1ec5ef(0x3fb)];_0x218467[_0x1ec5ef(0x30a)][_0x1ec5ef(0x556)]();const _0x500bfa=this[_0x1ec5ef(0x2b7)](this['index']());if(_0x500bfa===_0x1ec5ef(0x220)){const _0x5d155e=this['itemLineRect'](this[_0x1ec5ef(0x624)]());let _0x394af1=this[_0x1ec5ef(0x626)](this[_0x1ec5ef(0x624)]());_0x394af1=_0x394af1[_0x1ec5ef(0x3a5)](/\\I\[(\d+)\]/gi,''),_0x218467[_0x1ec5ef(0x4e3)](),this[_0x1ec5ef(0x25d)](_0x394af1,_0x5d155e),this[_0x1ec5ef(0x690)](_0x394af1,_0x5d155e),this[_0x1ec5ef(0x45a)](_0x394af1,_0x5d155e);}},Window_ShopCommand[_0x709961(0x5ef)][_0x709961(0x25d)]=function(_0x3990bc,_0x25008e){},Window_ShopCommand['prototype'][_0x709961(0x690)]=function(_0x3ca4a8,_0x55897c){const _0x38d66f=_0x709961,_0x1f6e48=this['_commandNameWindow'];_0x1f6e48['drawText'](_0x3ca4a8,0x0,_0x55897c['y'],_0x1f6e48[_0x38d66f(0x224)],_0x38d66f(0x50b));},Window_ShopCommand[_0x709961(0x5ef)][_0x709961(0x45a)]=function(_0x262e60,_0x51f3f0){const _0x3e5212=_0x709961,_0x33a8d7=this[_0x3e5212(0x3fb)],_0x3dca93=$gameSystem[_0x3e5212(0x25c)](),_0x5a7544=_0x51f3f0['x']+Math[_0x3e5212(0x4e5)](_0x51f3f0[_0x3e5212(0x4ca)]/0x2)+_0x3dca93;_0x33a8d7['x']=_0x33a8d7[_0x3e5212(0x4ca)]/-0x2+_0x5a7544,_0x33a8d7['y']=Math[_0x3e5212(0x4e5)](_0x51f3f0[_0x3e5212(0x232)]/0x2);},Window_ShopCommand[_0x709961(0x5ef)]['maxCols']=function(){const _0x4388e2=_0x709961;return this['_list']?this[_0x4388e2(0x3dc)][_0x4388e2(0x321)]:0x3;},Window_ShopCommand[_0x709961(0x5ef)]['hideDisabledCommands']=function(){const _0x23f9d9=_0x709961;return VisuMZ[_0x23f9d9(0x3db)]['Settings'][_0x23f9d9(0x300)][_0x23f9d9(0x6e5)];},Window_ShopCommand['prototype'][_0x709961(0x453)]=function(){const _0x50b477=_0x709961;this[_0x50b477(0x248)](),this[_0x50b477(0x456)](),this['addCancelCommand']();},Window_ShopCommand[_0x709961(0x5ef)]['refresh']=function(){const _0x5525b5=_0x709961;Window_HorzCommand[_0x5525b5(0x5ef)][_0x5525b5(0x349)][_0x5525b5(0x376)](this),this[_0x5525b5(0x606)]();},Window_ShopCommand[_0x709961(0x5ef)]['addBuyCommand']=function(){const _0x2b630f=_0x709961,_0x15a798=this[_0x2b630f(0x1be)](),_0x1d98fa=VisuMZ[_0x2b630f(0x3db)]['Settings'][_0x2b630f(0x300)]['CmdIconBuy'],_0x11ef18=_0x15a798===_0x2b630f(0x461)?TextManager[_0x2b630f(0x41a)]:_0x2b630f(0x297)[_0x2b630f(0x60c)](_0x1d98fa,TextManager[_0x2b630f(0x41a)]),_0xb9d8b4=this[_0x2b630f(0x3d4)]();if(this['hideDisabledCommands']()&&!_0xb9d8b4)return;this[_0x2b630f(0x1cb)](_0x11ef18,'buy',_0xb9d8b4);},Window_ShopCommand[_0x709961(0x5ef)][_0x709961(0x3d4)]=function(){const _0x2ac4b2=_0x709961;return SceneManager[_0x2ac4b2(0x6c1)][_0x2ac4b2(0x3f7)]===Scene_Shop?SceneManager[_0x2ac4b2(0x6c1)]['_goodsCount']>0x0:!![];},Window_ShopCommand[_0x709961(0x5ef)][_0x709961(0x456)]=function(){const _0x467867=_0x709961,_0x590352=this[_0x467867(0x1be)](),_0xce0129=VisuMZ[_0x467867(0x3db)][_0x467867(0x6b0)]['ShopScene']['CmdIconSell'],_0x36ae82=_0x590352===_0x467867(0x461)?TextManager[_0x467867(0x1b9)]:_0x467867(0x297)[_0x467867(0x60c)](_0xce0129,TextManager['sell']),_0x3db2ca=this[_0x467867(0x600)]();if(this[_0x467867(0x20c)]()&&!_0x3db2ca)return;this[_0x467867(0x1cb)](_0x36ae82,_0x467867(0x1b9),_0x3db2ca);},Window_ShopCommand[_0x709961(0x5ef)][_0x709961(0x600)]=function(){const _0x1119f6=_0x709961;return!this[_0x1119f6(0x695)];},Window_ShopCommand[_0x709961(0x5ef)][_0x709961(0x59c)]=function(){const _0x5a247d=_0x709961,_0x4d4541=this[_0x5a247d(0x1be)](),_0x5cd392=VisuMZ[_0x5a247d(0x3db)][_0x5a247d(0x6b0)][_0x5a247d(0x300)][_0x5a247d(0x56b)],_0x5486b3=VisuMZ[_0x5a247d(0x3db)]['Settings'][_0x5a247d(0x300)][_0x5a247d(0x675)],_0x12d1ea=_0x4d4541==='text'?_0x5486b3:_0x5a247d(0x297)[_0x5a247d(0x60c)](_0x5cd392,_0x5486b3);this['addCommand'](_0x12d1ea,_0x5a247d(0x320));},Window_ShopCommand[_0x709961(0x5ef)][_0x709961(0x27b)]=function(){const _0x12f027=_0x709961;return VisuMZ[_0x12f027(0x3db)][_0x12f027(0x6b0)]['ShopScene'][_0x12f027(0x34d)];},Window_ShopCommand['prototype']['drawItem']=function(_0x2209c9){const _0x130ea5=_0x709961,_0x26669f=this['commandStyleCheck'](_0x2209c9);if(_0x26669f===_0x130ea5(0x3be))this[_0x130ea5(0x2f5)](_0x2209c9);else _0x26669f===_0x130ea5(0x220)?this[_0x130ea5(0x4ec)](_0x2209c9):'lywij'===_0x130ea5(0x2a7)?this[_0x130ea5(0x5cd)][_0x130ea5(0x55a)]():Window_HorzCommand[_0x130ea5(0x5ef)][_0x130ea5(0x602)]['call'](this,_0x2209c9);},Window_ShopCommand[_0x709961(0x5ef)][_0x709961(0x1be)]=function(){const _0x297c54=_0x709961;return VisuMZ['ItemsEquipsCore'][_0x297c54(0x6b0)][_0x297c54(0x300)]['CmdStyle'];},Window_ShopCommand['prototype'][_0x709961(0x2b7)]=function(_0x2d4f6f){const _0x1a51f7=_0x709961;if(_0x2d4f6f<0x0)return _0x1a51f7(0x461);const _0x585e82=this[_0x1a51f7(0x1be)]();if(_0x585e82!==_0x1a51f7(0x28f)){if(_0x1a51f7(0x4e6)!==_0x1a51f7(0x4e6))_0x2eb56e=_0x1a51f7(0x49c)['format'](_0x1bda1b['id']);else return _0x585e82;}else{if(this['maxItems']()>0x0){if(_0x1a51f7(0x2f8)!=='PgAyk'){const _0x26c271=this[_0x1a51f7(0x402)](_0x1788e4);if(_0x26c271)this['loseItem'](_0x406aea,_0x26c271);}else{const _0x142ec2=this[_0x1a51f7(0x626)](_0x2d4f6f);if(_0x142ec2[_0x1a51f7(0x1ed)](/\\I\[(\d+)\]/i)){if('QCCeB'===_0x1a51f7(0x2fd))return this[_0x1a51f7(0x289)]()?this[_0x1a51f7(0x1f3)]():_0x355bf2['ItemsEquipsCore'][_0x1a51f7(0x6d9)][_0x1a51f7(0x376)](this);else{const _0x1ba5e0=this[_0x1a51f7(0x46c)](_0x2d4f6f),_0x2a25b8=this[_0x1a51f7(0x66a)](_0x142ec2)['width'];return _0x2a25b8<=_0x1ba5e0[_0x1a51f7(0x4ca)]?_0x1a51f7(0x3be):_0x1a51f7(0x220);}}}}}return _0x1a51f7(0x461);},Window_ShopCommand[_0x709961(0x5ef)][_0x709961(0x2f5)]=function(_0x51f462){const _0x525668=_0x709961,_0x2a05d0=this['itemLineRect'](_0x51f462),_0x5f462e=this['commandName'](_0x51f462),_0x1f4ccf=this[_0x525668(0x66a)](_0x5f462e)[_0x525668(0x4ca)];this['changePaintOpacity'](this[_0x525668(0x35a)](_0x51f462));const _0x38dd45=this[_0x525668(0x27b)]();if(_0x38dd45===_0x525668(0x4b9)){if(_0x525668(0x569)!==_0x525668(0x569))return this[_0x525668(0x4de)](_0x290c05[_0x525668(0x3e1)])&&!this['isEquipTypeSealed'](_0x3bab2d[_0x525668(0x5fe)])&&_0x5a0eab[_0x525668(0x323)](_0x5bc30d)[_0x525668(0x328)](_0x32caa0=>!this['isEquipTypeSealed'](_0x32caa0));else this[_0x525668(0x6ba)](_0x5f462e,_0x2a05d0['x']+_0x2a05d0['width']-_0x1f4ccf,_0x2a05d0['y'],_0x1f4ccf);}else{if(_0x38dd45===_0x525668(0x50b)){const _0x5f0516=_0x2a05d0['x']+Math[_0x525668(0x4e5)]((_0x2a05d0[_0x525668(0x4ca)]-_0x1f4ccf)/0x2);this[_0x525668(0x6ba)](_0x5f462e,_0x5f0516,_0x2a05d0['y'],_0x1f4ccf);}else{if(_0x525668(0x306)===_0x525668(0x6dd)){if(_0xc3cf7)_0xe50c11+=this[_0x525668(0x23f)](_0x2d37d8,_0x1f2447);}else this[_0x525668(0x6ba)](_0x5f462e,_0x2a05d0['x'],_0x2a05d0['y'],_0x1f4ccf);}}},Window_ShopCommand['prototype'][_0x709961(0x4ec)]=function(_0x1fadb7){const _0x217fa5=_0x709961;this[_0x217fa5(0x626)](_0x1fadb7)['match'](/\\I\[(\d+)\]/i);const _0x4a3668=Number(RegExp['$1'])||0x0,_0x2a6c75=this[_0x217fa5(0x46c)](_0x1fadb7),_0x5e2e7f=_0x2a6c75['x']+Math[_0x217fa5(0x4e5)]((_0x2a6c75[_0x217fa5(0x4ca)]-ImageManager[_0x217fa5(0x357)])/0x2),_0x3756e1=_0x2a6c75['y']+(_0x2a6c75['height']-ImageManager[_0x217fa5(0x2ea)])/0x2;this['drawIcon'](_0x4a3668,_0x5e2e7f,_0x3756e1);},VisuMZ['ItemsEquipsCore'][_0x709961(0x47c)]=Window_ShopBuy['prototype'][_0x709961(0x349)],Window_ShopBuy[_0x709961(0x5ef)]['refresh']=function(){const _0x488990=_0x709961;this[_0x488990(0x523)](),VisuMZ[_0x488990(0x3db)][_0x488990(0x47c)]['call'](this);},Window_ShopBuy[_0x709961(0x5ef)][_0x709961(0x523)]=function(){const _0x162437=_0x709961;SceneManager[_0x162437(0x6c1)][_0x162437(0x3f7)]===Scene_Shop&&(this[_0x162437(0x50f)]=SceneManager[_0x162437(0x6c1)]['money']());},VisuMZ[_0x709961(0x3db)]['Window_ShopBuy_price']=Window_ShopBuy[_0x709961(0x5ef)]['price'],Window_ShopBuy[_0x709961(0x5ef)][_0x709961(0x518)]=function(_0xcb4b62){const _0x5edd69=_0x709961;if(!_0xcb4b62)return 0x0;let _0x478114=VisuMZ[_0x5edd69(0x3db)]['Window_ShopBuy_price'][_0x5edd69(0x376)](this,_0xcb4b62);return Math[_0x5edd69(0x5f5)](0x0,this[_0x5edd69(0x54e)](_0xcb4b62,_0x478114));},Window_ShopBuy[_0x709961(0x5ef)][_0x709961(0x54e)]=function(_0x1f4c36,_0x3aaadc){const _0xee4ee3=_0x709961,_0x2e644c=_0x1f4c36['note'];if(_0x2e644c[_0xee4ee3(0x1ed)](/<JS BUY PRICE>\s*([\s\S]*)\s*<\/JS BUY PRICE>/i)){const _0x18db61=String(RegExp['$1']);window[_0xee4ee3(0x518)]=_0x3aaadc,window[_0xee4ee3(0x24d)]=_0x1f4c36;try{eval(_0x18db61);}catch(_0x476e50){if($gameTemp[_0xee4ee3(0x38b)]())console[_0xee4ee3(0x4df)](_0x476e50);}_0x3aaadc=window[_0xee4ee3(0x518)],window[_0xee4ee3(0x518)]=undefined,window[_0xee4ee3(0x24d)]=undefined;}_0x3aaadc=VisuMZ[_0xee4ee3(0x3db)][_0xee4ee3(0x6b0)][_0xee4ee3(0x300)]['BuyPriceJS'][_0xee4ee3(0x376)](this,_0x1f4c36,_0x3aaadc);if(isNaN(_0x3aaadc))_0x3aaadc=0x0;return Math[_0xee4ee3(0x4e5)](_0x3aaadc);},VisuMZ['ItemsEquipsCore'][_0x709961(0x3cc)]=Window_ShopBuy[_0x709961(0x5ef)][_0x709961(0x2be)],Window_ShopBuy[_0x709961(0x5ef)][_0x709961(0x2be)]=function(_0x5a0d3a){const _0x4083c6=_0x709961,_0x164876=VisuMZ['ItemsEquipsCore'][_0x4083c6(0x3cc)][_0x4083c6(0x376)](this,_0x5a0d3a);return _0x164876&&!this[_0x4083c6(0x1a4)](_0x164876)?null:_0x164876;},VisuMZ[_0x709961(0x3db)][_0x709961(0x4ae)]={'ShowAllSwitches':/<SHOW SHOP (?:ALL |)SWITCH(?:|ES):[ ](.*)>/i,'ShowAnySwitches':/<SHOW SHOP ANY SWITCH(?:|ES):[ ](.*)>/i,'HideAllSwitches':/<HIDE SHOP (?:ALL |)SWITCH(?:|ES):[ ](.*)>/i,'HideAnySwitches':/<HIDE SHOP ANY SWITCH(?:|ES):[ ](.*)>/i,'BuyTurnSwitchOn':/<BUY TURN ON SWITCH(?:|ES):[ ](.*)>/i,'BuyTurnSwitchOff':/<BUY TURN OFF SWITCH(?:|ES):[ ](.*)>/i,'SellTurnSwitchOn':/<SELL TURN ON SWITCH(?:|ES):[ ](.*)>/i,'SellTurnSwitchOff':/<SELL TURN OFF SWITCH(?:|ES):[ ](.*)>/i},Window_ShopBuy[_0x709961(0x5ef)][_0x709961(0x1a4)]=function(_0x58a9fc){const _0x5992d0=_0x709961;if(!_0x58a9fc)return![];const _0x2f2860=VisuMZ[_0x5992d0(0x3db)][_0x5992d0(0x4ae)],_0x247ed1=_0x58a9fc?_0x58a9fc[_0x5992d0(0x1e9)]||'':'';if(_0x247ed1[_0x5992d0(0x1ed)](_0x2f2860[_0x5992d0(0x4f4)])){const _0x15071e=String(RegExp['$1'])[_0x5992d0(0x617)](',')[_0x5992d0(0x1ac)](_0xe1b297=>Number(_0xe1b297));if(_0x15071e[_0x5992d0(0x217)](_0x445e1e=>!$gameSwitches[_0x5992d0(0x337)](_0x445e1e)))return![];}if(_0x247ed1[_0x5992d0(0x1ed)](_0x2f2860['ShowAnySwitches'])){const _0x2dd431=String(RegExp['$1'])['split'](',')['map'](_0x2ebb36=>Number(_0x2ebb36));if(_0x2dd431['every'](_0x49b6c0=>!$gameSwitches[_0x5992d0(0x337)](_0x49b6c0)))return![];}if(_0x247ed1['match'](_0x2f2860[_0x5992d0(0x529)])){if(_0x5992d0(0x1a3)!==_0x5992d0(0x19c)){const _0x272d28=String(RegExp['$1'])[_0x5992d0(0x617)](',')[_0x5992d0(0x1ac)](_0x12495b=>Number(_0x12495b));if(_0x272d28['every'](_0x2d7efb=>$gameSwitches[_0x5992d0(0x337)](_0x2d7efb)))return![];}else _0x564b55['push'](_0x36d07b(_0x558bc4));}if(_0x247ed1[_0x5992d0(0x1ed)](_0x2f2860['HideAnySwitches'])){if('rNQUW'!==_0x5992d0(0x29f)){const _0x48a11a=String(RegExp['$1'])[_0x5992d0(0x617)](',')[_0x5992d0(0x1ac)](_0x49495d=>Number(_0x49495d));if(_0x48a11a[_0x5992d0(0x217)](_0x125535=>$gameSwitches[_0x5992d0(0x337)](_0x125535)))return![];}else _0x2c7515[_0x5992d0(0x3db)][_0x5992d0(0x451)][_0x5992d0(0x376)](this),this[_0x5992d0(0x6d8)]()&&this[_0x5992d0(0x5db)]();}return!![];},Window_ShopBuy[_0x709961(0x5ef)][_0x709961(0x602)]=function(_0x22d56d){const _0x3170c5=_0x709961;this[_0x3170c5(0x4e3)]();const _0x1922fa=this[_0x3170c5(0x364)](_0x22d56d),_0x324159=this[_0x3170c5(0x46c)](_0x22d56d),_0xda0fc3=_0x324159[_0x3170c5(0x4ca)];this[_0x3170c5(0x403)](this['isEnabled'](_0x1922fa)),this['drawItemName'](_0x1922fa,_0x324159['x'],_0x324159['y'],_0xda0fc3),this[_0x3170c5(0x268)](_0x1922fa,_0x324159),this[_0x3170c5(0x403)](!![]);},Window_ShopBuy[_0x709961(0x5ef)]['drawItemCost']=function(_0x345473,_0x44255e){const _0x13cf22=_0x709961,_0x16db94=this[_0x13cf22(0x518)](_0x345473);this['drawCurrencyValue'](_0x16db94,TextManager[_0x13cf22(0x294)],_0x44255e['x'],_0x44255e['y'],_0x44255e[_0x13cf22(0x4ca)]);},Window_ShopSell[_0x709961(0x5ef)]['maxCols']=function(){const _0x52b579=_0x709961;return SceneManager[_0x52b579(0x6c1)][_0x52b579(0x289)]()?0x1:0x2;},VisuMZ[_0x709961(0x3db)]['Window_ShopSell_isEnabled']=Window_ShopSell['prototype'][_0x709961(0x24b)],Window_ShopSell[_0x709961(0x5ef)]['isEnabled']=function(_0x30b35){const _0x196704=_0x709961;if(!_0x30b35)return![];const _0x31b2f3=_0x30b35['note'];if(_0x31b2f3[_0x196704(0x1ed)](/<CANNOT SELL>/i))return![];if(_0x31b2f3[_0x196704(0x1ed)](/<CAN SELL>/i))return!![];if(_0x31b2f3[_0x196704(0x1ed)](/<CANNOT SELL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x25bf7c=JSON[_0x196704(0x692)]('['+RegExp['$1'][_0x196704(0x1ed)](/\d+/g)+']');for(const _0x5d6038 of _0x25bf7c){if('pKySE'==='pKySE'){if(!$gameSwitches[_0x196704(0x337)](_0x5d6038))return![];}else{const _0x172c97=_0x58e1a4[_0x196704(0x3db)]['Settings']['New'][_0x196704(0x354)];return _0x172c97[_0x196704(0x1ed)](/#(.*)/i)?'#'+_0x40ed94(_0x8c35ac['$1']):_0x6d4bed[_0x196704(0x637)](_0x172c97);}}}if(_0x31b2f3[_0x196704(0x1ed)](/<CANNOT SELL ALL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if(_0x196704(0x2bc)!==_0x196704(0x2f6)){const _0x5d46b6=JSON['parse']('['+RegExp['$1']['match'](/\d+/g)+']');for(const _0x20f8bb of _0x5d46b6){if(!$gameSwitches[_0x196704(0x337)](_0x20f8bb))return![];}}else _0xbe87a1['prototype'][_0x196704(0x61e)][_0x196704(0x376)](this),this['checkShiftRemoveShortcut']();}if(_0x31b2f3[_0x196704(0x1ed)](/<CANNOT SELL ANY[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x2815d2=JSON['parse']('['+RegExp['$1']['match'](/\d+/g)+']');for(const _0xe05cff of _0x2815d2){if($gameSwitches[_0x196704(0x337)](_0xe05cff))return![];}}return VisuMZ[_0x196704(0x3db)][_0x196704(0x425)][_0x196704(0x376)](this,_0x30b35);},Window_ShopStatus['EQUIP_DELAY_MS']=VisuMZ[_0x709961(0x3db)][_0x709961(0x6b0)]['StatusWindow']['EquipDelayMS']??0xf0,VisuMZ[_0x709961(0x3db)][_0x709961(0x301)]=Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x57b)],Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x57b)]=function(_0x48a646){const _0x2e5760=_0x709961;_0x48a646=DataManager[_0x2e5760(0x36d)](_0x48a646);if(DataManager[_0x2e5760(0x67a)](_0x48a646)||DataManager[_0x2e5760(0x3b3)](_0x48a646))this[_0x2e5760(0x2dd)](_0x48a646);else{if('IfFRH'===_0x2e5760(0x1dc))return _0x2e5760(0x19f)['format'](_0x8ec210(_0x116bb9['$1']));else VisuMZ['ItemsEquipsCore']['Window_ShopStatus_setItem'][_0x2e5760(0x376)](this,_0x48a646);}},Window_ShopStatus[_0x709961(0x5ef)]['setItemDelay']=function(_0x5d54ed){const _0x134ce4=_0x709961;this[_0x134ce4(0x3c2)]=_0x5d54ed;const _0x9c4623=Window_ShopStatus[_0x134ce4(0x37a)];setTimeout(this[_0x134ce4(0x476)]['bind'](this,_0x5d54ed),_0x9c4623);},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x476)]=function(_0x1f9334){const _0x307315=_0x709961;if(this['_item']===_0x1f9334){if(_0x307315(0x443)!==_0x307315(0x691))this[_0x307315(0x349)]();else return _0x307315(0x220);}},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x6ad)]=function(){return![];},Window_ShopStatus[_0x709961(0x5ef)]['loadFaceImages']=function(){const _0x3e6b81=_0x709961;Window_StatusBase['prototype']['loadFaceImages'][_0x3e6b81(0x376)](this);for(const _0x3e370a of $gameParty[_0x3e6b81(0x293)]()){ImageManager['loadCharacter'](_0x3e370a[_0x3e6b81(0x2a2)]());}},Window_ShopStatus['prototype'][_0x709961(0x2a1)]=function(){const _0x3d6f7a=_0x709961;return VisuMZ[_0x3d6f7a(0x3db)][_0x3d6f7a(0x6b0)]['StatusWindow'][_0x3d6f7a(0x597)];},Window_ShopStatus[_0x709961(0x5ef)]['refresh']=function(){const _0x117d35=_0x709961;this[_0x117d35(0x30a)]['clear'](),this[_0x117d35(0x544)][_0x117d35(0x556)](),this[_0x117d35(0x3c2)]&&(this[_0x117d35(0x4e3)](),this['changePaintOpacity'](!![]),this[_0x117d35(0x365)](),this[_0x117d35(0x3fc)]()?this['drawEquipData']():this[_0x117d35(0x6ef)](),this[_0x117d35(0x4c5)]());},Window_ShopStatus[_0x709961(0x5ef)]['drawPossession']=function(_0x177e33,_0x1c6045){const _0x53bb9f=_0x709961;if(!this[_0x53bb9f(0x3fc)]()&&!DataManager[_0x53bb9f(0x2f3)](this[_0x53bb9f(0x3c2)]))return;const _0x3f7515=this[_0x53bb9f(0x224)]-this[_0x53bb9f(0x407)]()-_0x177e33,_0x52af36=this[_0x53bb9f(0x48d)](_0x53bb9f(0x475));this[_0x53bb9f(0x61c)](ColorManager['systemColor']()),this[_0x53bb9f(0x62c)](TextManager[_0x53bb9f(0x65d)],_0x177e33+this[_0x53bb9f(0x407)](),_0x1c6045,_0x3f7515-_0x52af36),this[_0x53bb9f(0x1c0)](),this['drawItemNumber'](this[_0x53bb9f(0x3c2)],_0x177e33,_0x1c6045,_0x3f7515);},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x533)]=function(_0x16cd5a,_0x150815,_0x1b7241,_0x250471,_0x1ff6d8){const _0x3839fd=_0x709961;if(VisuMZ[_0x3839fd(0x3db)][_0x3839fd(0x6b0)][_0x3839fd(0x281)][_0x3839fd(0x372)]===![])return;_0x1ff6d8=Math['max'](_0x1ff6d8||0x1,0x1);while(_0x1ff6d8--){_0x250471=_0x250471||this[_0x3839fd(0x361)](),this[_0x3839fd(0x544)][_0x3839fd(0x32b)]=0xa0;const _0xeb1617=ColorManager['getItemsEquipsCoreBackColor1']();this[_0x3839fd(0x544)]['fillRect'](_0x16cd5a+0x1,_0x150815+0x1,_0x1b7241-0x2,_0x250471-0x2,_0xeb1617),this['contentsBack'][_0x3839fd(0x32b)]=0xff;}},ColorManager[_0x709961(0x4ac)]=function(){const _0x2b7f7b=_0x709961,_0x5ab9cb=VisuMZ[_0x2b7f7b(0x3db)][_0x2b7f7b(0x6b0)][_0x2b7f7b(0x281)];let _0x291142=_0x5ab9cb[_0x2b7f7b(0x658)]!==undefined?_0x5ab9cb[_0x2b7f7b(0x658)]:0x13;return ColorManager[_0x2b7f7b(0x3fd)](_0x291142);},Window_ShopStatus['prototype'][_0x709961(0x44e)]=function(){const _0x14032a=_0x709961;this[_0x14032a(0x342)]=null;if(VisuMZ['ItemsEquipsCore']['Settings'][_0x14032a(0x281)][_0x14032a(0x1f4)]){VisuMZ[_0x14032a(0x3db)][_0x14032a(0x6b0)][_0x14032a(0x281)][_0x14032a(0x1f4)][_0x14032a(0x376)](this);return;}const _0x100145=this[_0x14032a(0x361)](),_0x19dc1b=this[_0x14032a(0x471)]()+0x8;let _0x443bc4=0x0,_0x2bea68=0x0,_0x575f10=this[_0x14032a(0x224)],_0x2086d2=this[_0x14032a(0x6ca)],_0x1de0e7=Math[_0x14032a(0x4e5)](_0x575f10/0x2),_0x125b4f=_0x443bc4+_0x575f10-_0x1de0e7;this[_0x14032a(0x4dc)](this[_0x14032a(0x3c2)],_0x443bc4+this[_0x14032a(0x407)](),_0x2bea68,_0x575f10-this[_0x14032a(0x407)]()*0x2),this[_0x14032a(0x533)](_0x443bc4,_0x2bea68,_0x575f10),_0x2bea68+=_0x100145;if(this[_0x14032a(0x4a3)](_0x443bc4,_0x2bea68,_0x1de0e7))_0x2bea68+=0x0;if(this['drawItemQuantity'](_0x125b4f,_0x2bea68,_0x1de0e7))_0x2bea68+=_0x100145;const _0x552a0d=this[_0x14032a(0x2eb)](),_0x24b9d8=_0x2bea68;_0x2bea68=_0x2086d2-_0x552a0d[_0x14032a(0x321)]*_0x19dc1b-0x4;let _0x68e95a=_0x443bc4,_0x258ebe=0x0,_0x2bbb94=_0x2bea68;for(const _0x497f1f of _0x552a0d){_0x258ebe=Math[_0x14032a(0x5f5)](this[_0x14032a(0x69a)](_0x497f1f,_0x443bc4+0x4,_0x2bea68+0x4,_0x575f10),_0x258ebe),_0x2bea68+=_0x19dc1b;}const _0x258565=$gameParty[_0x14032a(0x213)](),_0x496d8f=Math[_0x14032a(0x4e5)]((_0x575f10-_0x258ebe)/_0x258565);_0x258ebe=_0x575f10-_0x496d8f*_0x258565;for(const _0x1cab7f of $gameParty['battleMembers']()){const _0x543b51=$gameParty[_0x14032a(0x481)]()['indexOf'](_0x1cab7f),_0xd54a64=_0x68e95a+_0x258ebe+_0x543b51*_0x496d8f;this[_0x14032a(0x403)](_0x1cab7f[_0x14032a(0x447)](this[_0x14032a(0x3c2)])),this[_0x14032a(0x587)](_0x1cab7f,_0xd54a64+_0x496d8f/0x2,_0x2bbb94);let _0x5f36c2=_0x2bbb94;for(const _0x181fa5 of _0x552a0d){if(_0x14032a(0x66d)!=='czBmw')return'icon';else{const _0x3913dd=_0x5f36c2-(_0x100145-_0x19dc1b)/0x2;this[_0x14032a(0x2af)](_0x1cab7f,_0x181fa5,_0xd54a64,_0x3913dd,_0x496d8f),_0x5f36c2+=_0x19dc1b;}}}this[_0x14032a(0x533)](_0x68e95a,_0x24b9d8,_0x258ebe,_0x2bbb94-_0x24b9d8);for(let _0x18efbf=0x0;_0x18efbf<_0x258565;_0x18efbf++){if(_0x14032a(0x26a)===_0x14032a(0x26a)){const _0x3d2615=_0x68e95a+_0x258ebe+_0x18efbf*_0x496d8f;this[_0x14032a(0x533)](_0x3d2615,_0x24b9d8,_0x496d8f,_0x2bbb94-_0x24b9d8);}else _0x574691[_0x14032a(0x3db)][_0x14032a(0x1d8)][_0x14032a(0x376)](this),this[_0x14032a(0x289)]()&&this[_0x14032a(0x633)]['show'](),this['_sellWindow']['updateHelp']();}for(const _0x2381a1 of _0x552a0d){if(_0x14032a(0x421)===_0x14032a(0x421)){this['drawItemDarkRect'](_0x68e95a,_0x2bbb94,_0x258ebe,_0x19dc1b);for(let _0x1455c5=0x0;_0x1455c5<_0x258565;_0x1455c5++){if(_0x14032a(0x5e3)!=='lIeUg')return _0x54d0f5['ItemsEquipsCore']['Scene_Shop_numberWindowRect'][_0x14032a(0x376)](this);else{const _0x56ba11=_0x68e95a+_0x258ebe+_0x1455c5*_0x496d8f;this[_0x14032a(0x533)](_0x56ba11,_0x2bbb94,_0x496d8f,_0x19dc1b);}}_0x2bbb94+=_0x19dc1b;}else return _0x7782e0[_0x14032a(0x3db)]['Scene_Equip_commandWindowRect'][_0x14032a(0x376)](this);}},Window_ShopStatus['prototype'][_0x709961(0x4a3)]=function(_0x1ecfec,_0x1833d3,_0x219b97){const _0x2dee3f=_0x709961;if(!this[_0x2dee3f(0x3fc)]())return![];const _0x278630=$dataSystem[_0x2dee3f(0x2c9)][this[_0x2dee3f(0x3c2)][_0x2dee3f(0x5fe)]];return this[_0x2dee3f(0x2c2)](_0x278630,_0x1ecfec,_0x1833d3,_0x219b97,!![]),this['drawItemDarkRect'](_0x1ecfec,_0x1833d3,_0x219b97),this[_0x2dee3f(0x4e3)](),!![];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x2e2)]=function(){const _0x3af5da=_0x709961,_0x49253e=VisuMZ['ItemsEquipsCore']['Settings']['ItemScene'][_0x3af5da(0x5b8)];return _0x49253e['format']($gameParty[_0x3af5da(0x402)](this['_item']));},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x2eb)]=function(){const _0x922261=_0x709961;let _0x473099=[0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7];return Imported['VisuMZ_0_CoreEngine']&&(_0x473099=VisuMZ['CoreEngine']['Settings'][_0x922261(0x512)][_0x922261(0x283)]),_0x473099=_0x473099['map'](_0x3730f=>typeof _0x3730f===_0x922261(0x540)?_0x3730f:_0x3730f[_0x922261(0x45c)]()['trim']()),_0x473099;},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x302)]=function(){const _0x479d21=_0x709961;return VisuMZ[_0x479d21(0x3db)][_0x479d21(0x6b0)][_0x479d21(0x281)][_0x479d21(0x4d2)];},Window_ShopStatus['prototype'][_0x709961(0x69a)]=function(_0x24ca65,_0x3d208a,_0x4824cc,_0x11235e){const _0x304aa6=_0x709961;this[_0x304aa6(0x4e3)](),this['contents'][_0x304aa6(0x416)]=this['smallParamFontSize']();let _0x5d2a3c=this[_0x304aa6(0x48d)](TextManager[_0x304aa6(0x307)](_0x24ca65))+0x4+_0x3d208a;return Imported[_0x304aa6(0x615)]?(this[_0x304aa6(0x623)](_0x3d208a,_0x4824cc,_0x11235e,_0x24ca65,!![]),VisuMZ[_0x304aa6(0x516)]['Settings'][_0x304aa6(0x512)][_0x304aa6(0x426)]&&(_0x5d2a3c+=ImageManager['iconWidth']+0x4)):_0x304aa6(0x4f1)===_0x304aa6(0x4f1)?(this['changeTextColor'](ColorManager[_0x304aa6(0x697)]()),this[_0x304aa6(0x62c)](TextManager[_0x304aa6(0x307)](_0x24ca65),_0x3d208a,_0x4824cc,_0x11235e)):this[_0x304aa6(0x222)](),this[_0x304aa6(0x4e3)](),_0x5d2a3c;},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x2af)]=function(_0x3a627a,_0x39a86b,_0x11dfd2,_0x237782,_0x43095c){const _0x56a877=_0x709961;_0x11dfd2+=this[_0x56a877(0x407)](),_0x43095c-=this[_0x56a877(0x407)]()*0x2;const _0x48676e=VisuMZ[_0x56a877(0x3db)][_0x56a877(0x6b0)]['StatusWindow'];this['contents'][_0x56a877(0x416)]=_0x48676e[_0x56a877(0x4d2)],this[_0x56a877(0x403)](_0x3a627a['canEquip'](this[_0x56a877(0x3c2)]));if(_0x3a627a[_0x56a877(0x51c)](this['_item'])&&!_0x3a627a[_0x56a877(0x625)](this[_0x56a877(0x3c2)])){const _0x1199bf=_0x48676e['AlreadyEquipMarker'];this[_0x56a877(0x62c)](_0x1199bf,_0x11dfd2,_0x237782,_0x43095c,'center');}else{if(_0x3a627a[_0x56a877(0x447)](this['_item'])){if(_0x56a877(0x493)===_0x56a877(0x392))_0x1d6933=_0x531d07[_0x56a877(0x2c9)][_0x231165(_0x30a0d9['$1'])]||'';else{const _0x59a606=this[_0x56a877(0x6ea)](_0x3a627a);let _0x50d87b=0x0,_0x818bac=0x0,_0x4ae652=0x0;Imported[_0x56a877(0x615)]?(_0x50d87b=_0x59a606['paramValueByName'](_0x39a86b),_0x818bac=_0x50d87b-_0x3a627a['paramValueByName'](_0x39a86b),this[_0x56a877(0x61c)](ColorManager[_0x56a877(0x4da)](_0x818bac)),_0x4ae652=(_0x818bac>=0x0?'+':'')+VisuMZ[_0x56a877(0x45d)](_0x818bac,0x0,_0x39a86b)):(_0x50d87b=_0x59a606['param'](_0x39a86b),_0x818bac=_0x50d87b-_0x3a627a[_0x56a877(0x307)](_0x39a86b),this[_0x56a877(0x61c)](ColorManager[_0x56a877(0x4da)](_0x818bac)),_0x4ae652=(_0x818bac>=0x0?'+':'')+_0x818bac),_0x4ae652==='+0'&&(_0x4ae652=_0x48676e[_0x56a877(0x588)]),this[_0x56a877(0x62c)](_0x4ae652,_0x11dfd2,_0x237782,_0x43095c,_0x56a877(0x50b));}}else{const _0x5a8ebb=_0x48676e[_0x56a877(0x444)];this[_0x56a877(0x62c)](_0x5a8ebb,_0x11dfd2,_0x237782,_0x43095c,_0x56a877(0x50b));}}this[_0x56a877(0x4e3)](),this[_0x56a877(0x403)](!![]);},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x6ea)]=function(_0x5b6480){const _0x444c14=_0x709961;if(this[_0x444c14(0x58f)](_0x5b6480)){const _0x5ae431=JsonEx[_0x444c14(0x340)](_0x5b6480);_0x5ae431[_0x444c14(0x342)]=!![];const _0x4413f9=_0x5ae431[_0x444c14(0x422)](this['_item']);_0x4413f9>=0x0&&_0x5ae431[_0x444c14(0x335)](_0x4413f9,this['_item']),this[_0x444c14(0x342)]=_0x5ae431;}return this['_tempActor'];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x58f)]=function(_0x1d7de4){const _0x4810cf=_0x709961;if(!this['_tempActor'])return!![];return this[_0x4810cf(0x342)][_0x4810cf(0x385)]()!==_0x1d7de4['actorId']();},Game_Actor[_0x709961(0x5ef)][_0x709961(0x625)]=function(_0x11146b){const _0x53112d=_0x709961;if(!_0x11146b)return![];const _0xec9538=_0x11146b[_0x53112d(0x5fe)],_0x235847=this[_0x53112d(0x252)]();for(let _0x5c1438=0x0;_0x5c1438<_0x235847[_0x53112d(0x321)];_0x5c1438++){const _0x2d1425=_0x235847[_0x5c1438];if(_0x2d1425!==_0xec9538)continue;if(!this[_0x53112d(0x673)]()[_0x5c1438])return!![];}return![];},Game_Actor[_0x709961(0x5ef)][_0x709961(0x422)]=function(_0x3a5b72){const _0x751c8e=_0x709961;if(!_0x3a5b72)return-0x1;const _0x1e2747=_0x3a5b72[_0x751c8e(0x5fe)],_0x317285=this[_0x751c8e(0x252)]();let _0x35f39f=-0x1;for(let _0x9f4766=0x0;_0x9f4766<_0x317285[_0x751c8e(0x321)];_0x9f4766++){if('DYiWs'===_0x751c8e(0x1a9))this[_0x751c8e(0x1d6)](![]);else{const _0x47262e=_0x317285[_0x9f4766];if(_0x47262e!==_0x1e2747)continue;if(!this[_0x751c8e(0x673)]()[_0x9f4766])return _0x9f4766;if(_0x35f39f<0x0)_0x35f39f=_0x9f4766;}}return _0x35f39f;},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x6ef)]=function(){const _0x4476f8=_0x709961;VisuMZ[_0x4476f8(0x3db)]['Settings'][_0x4476f8(0x281)][_0x4476f8(0x489)]['call'](this);},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x4dc)]=function(_0x1b9f6b,_0xec6232,_0x23ca8a,_0x5edfc8){const _0x7cea81=_0x709961,_0x3be191=DataManager['isSkill'](_0x1b9f6b,_0xec6232,_0x23ca8a,_0x5edfc8)&&Imported['VisuMZ_1_SkillsStatesCore'],_0x1cd631=_0x1b9f6b?_0x1b9f6b['name']:'';if(_0x3be191)Window_SkillList[_0x7cea81(0x5ef)][_0x7cea81(0x499)][_0x7cea81(0x376)](this,_0x1b9f6b);Window_Base[_0x7cea81(0x5ef)][_0x7cea81(0x4dc)][_0x7cea81(0x376)](this,_0x1b9f6b,_0xec6232,_0x23ca8a,_0x5edfc8);if(_0x3be191)_0x1b9f6b[_0x7cea81(0x5a7)]=_0x1cd631;},Window_ShopStatus[_0x709961(0x5ef)]['prepareItemCustomData']=function(){const _0x5413c6=_0x709961;this[_0x5413c6(0x3b8)]={};if(!this[_0x5413c6(0x3c2)])return;const _0x51a074=this['_item'][_0x5413c6(0x1e9)];if(_0x51a074[_0x5413c6(0x1ed)](/<STATUS INFO>\s*([\s\S]*)\s*<\/STATUS INFO>/i)){const _0x5af028=String(RegExp['$1'])['split'](/[\r\n]+/);for(const _0x91f9e7 of _0x5af028){if(_0x91f9e7[_0x5413c6(0x1ed)](/(.*):[ ](.*)/i)){if(_0x5413c6(0x464)===_0x5413c6(0x406))this[_0x5413c6(0x633)]=_0x1d78a3,this['callUpdateHelp']();else{const _0x555dbc=String(RegExp['$1'])[_0x5413c6(0x45c)]()[_0x5413c6(0x3c4)](),_0x154454=String(RegExp['$2'])['trim']();this['_customItemInfo'][_0x555dbc]=_0x154454;}}}}},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x480)]=function(){const _0x48acba=_0x709961;return Math[_0x48acba(0x5f5)](0x1,$gameSystem[_0x48acba(0x58e)]()-0x4);},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x4e3)]=function(){const _0x4ee8fc=_0x709961;Window_StatusBase[_0x4ee8fc(0x5ef)][_0x4ee8fc(0x4e3)]['call'](this),this[_0x4ee8fc(0x30a)][_0x4ee8fc(0x416)]=this['_resetFontSize']||this[_0x4ee8fc(0x30a)][_0x4ee8fc(0x416)],this[_0x4ee8fc(0x30a)][_0x4ee8fc(0x637)]=this['_resetFontColor']||this[_0x4ee8fc(0x30a)][_0x4ee8fc(0x637)];},Window_ShopStatus['prototype']['fontSizeRatio']=function(){const _0x174193=_0x709961;return this['contents'][_0x174193(0x416)]/$gameSystem[_0x174193(0x58e)]();},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x25a)]=function(_0x3fba0e,_0x4b3681,_0xaf69b8){const _0x12c9ea=_0x709961,_0x46d1a4=ImageManager[_0x12c9ea(0x35c)](_0x12c9ea(0x205)),_0x5ecf20=ImageManager[_0x12c9ea(0x357)],_0x5158e0=ImageManager[_0x12c9ea(0x2ea)],_0x30484d=_0x3fba0e%0x10*_0x5ecf20,_0x58f18d=Math['floor'](_0x3fba0e/0x10)*_0x5158e0,_0x408f9d=Math[_0x12c9ea(0x20f)](_0x5ecf20*this[_0x12c9ea(0x2d8)]()),_0x4600de=Math['ceil'](_0x5158e0*this[_0x12c9ea(0x2d8)]());this[_0x12c9ea(0x30a)][_0x12c9ea(0x60b)](_0x46d1a4,_0x30484d,_0x58f18d,_0x5ecf20,_0x5158e0,_0x4b3681,_0xaf69b8,_0x408f9d,_0x4600de);},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x61f)]=function(_0x596782,_0x55b728){const _0x5ee429=_0x709961;_0x55b728[_0x5ee429(0x5c9)]&&this[_0x5ee429(0x25a)](_0x596782,_0x55b728['x'],_0x55b728['y']+0x2);_0x55b728['x']+=Math['ceil'](ImageManager[_0x5ee429(0x357)]*this['fontSizeRatio']());if(this[_0x5ee429(0x2d8)]()===0x1)_0x55b728['x']+=0x4;},Window_ShopStatus[_0x709961(0x5ef)]['drawItemKeyData']=function(_0x5557bd,_0x5d4d19,_0x2fe20f,_0x4c2356,_0x5864b3,_0x54ddca){const _0x1e6153=_0x709961;_0x5557bd=_0x5557bd||'',_0x54ddca=_0x54ddca||_0x1e6153(0x316),this['_resetFontSize']=this[_0x1e6153(0x480)](),this[_0x1e6153(0x389)]=_0x5864b3?ColorManager[_0x1e6153(0x697)]():this[_0x1e6153(0x30a)][_0x1e6153(0x637)],_0x5d4d19+=this['itemPadding'](),_0x4c2356-=this['itemPadding']()*0x2;const _0x1a0015=this[_0x1e6153(0x66a)](_0x5557bd);if(_0x54ddca===_0x1e6153(0x50b))_0x5d4d19=_0x5d4d19+Math[_0x1e6153(0x4e5)]((_0x4c2356-_0x1a0015[_0x1e6153(0x4ca)])/0x2);else _0x54ddca===_0x1e6153(0x4b9)&&(_0x5d4d19=_0x5d4d19+_0x4c2356-_0x1a0015[_0x1e6153(0x4ca)]);_0x2fe20f+=(this[_0x1e6153(0x361)]()-_0x1a0015[_0x1e6153(0x232)])/0x2,this[_0x1e6153(0x6ba)](_0x5557bd,_0x5d4d19,_0x2fe20f,_0x4c2356),this[_0x1e6153(0x3f4)]=undefined,this[_0x1e6153(0x389)]=undefined,this['resetFontSettings']();},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x336)]=function(_0x31614d,_0x133e0a,_0x27c3a0){const _0x41b994=_0x709961;if(!DataManager[_0x41b994(0x2f3)](this[_0x41b994(0x3c2)]))return![];const _0x3a10c9=this[_0x41b994(0x3c9)]();this[_0x41b994(0x2c2)](_0x3a10c9,_0x31614d,_0x133e0a,_0x27c3a0,!![]);const _0x29dee1=this[_0x41b994(0x2f1)]();return this[_0x41b994(0x2c2)](_0x29dee1,_0x31614d,_0x133e0a,_0x27c3a0,![],'right'),this['drawItemDarkRect'](_0x31614d,_0x133e0a,_0x27c3a0),this[_0x41b994(0x4e3)](),!![];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x3c9)]=function(){const _0x1c9cbf=_0x709961;return VisuMZ[_0x1c9cbf(0x3db)]['Settings'][_0x1c9cbf(0x281)][_0x1c9cbf(0x304)];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x2f1)]=function(){const _0x5bcd40=_0x709961,_0x4938ef=_0x5bcd40(0x5b6);if(this[_0x5bcd40(0x3b8)][_0x4938ef])return this[_0x5bcd40(0x3b8)][_0x4938ef];return this['canConsumeItem']()?VisuMZ['ItemsEquipsCore'][_0x5bcd40(0x6b0)]['StatusWindow']['Consumable']:VisuMZ[_0x5bcd40(0x3db)][_0x5bcd40(0x6b0)][_0x5bcd40(0x281)][_0x5bcd40(0x5f6)];},Window_ShopStatus['prototype'][_0x709961(0x5c3)]=function(){const _0x530c65=_0x709961;return VisuMZ[_0x530c65(0x516)]&&VisuMZ[_0x530c65(0x516)][_0x530c65(0x6b0)]['QoL'][_0x530c65(0x6f2)]&&DataManager[_0x530c65(0x239)](this['_item'])?![]:'aJisa'===_0x530c65(0x22f)?this['_item'][_0x530c65(0x6a5)]:_0x5aee34[_0x530c65(0x462)][_0x530c65(0x60c)](_0x237986(_0x59ba6b['$1']));},Window_ShopStatus['prototype'][_0x709961(0x31d)]=function(_0x52bbb5,_0x42640c,_0x521e19){const _0x38c2bf=_0x709961;if(!this['isEquipItem']()&&!DataManager['isItem'](this[_0x38c2bf(0x3c2)]))return![];if(DataManager[_0x38c2bf(0x239)](this[_0x38c2bf(0x3c2)])&&!$dataSystem[_0x38c2bf(0x33d)]){const _0x1fd4f0=TextManager[_0x38c2bf(0x44d)];this['drawItemKeyData'](_0x1fd4f0,_0x52bbb5,_0x42640c,_0x521e19,!![],_0x38c2bf(0x50b));}else{const _0x55b60e=TextManager[_0x38c2bf(0x65d)];this['drawItemKeyData'](_0x55b60e,_0x52bbb5,_0x42640c,_0x521e19,!![]);const _0x3d16e3=this[_0x38c2bf(0x2e2)]();this['drawItemKeyData'](_0x3d16e3,_0x52bbb5,_0x42640c,_0x521e19,![],'right');}return this[_0x38c2bf(0x533)](_0x52bbb5,_0x42640c,_0x521e19),this['resetFontSettings'](),!![];},Window_ShopStatus[_0x709961(0x5ef)]['getItemQuantityText']=function(){const _0x7c3ea3=_0x709961,_0x2fd25e='QUANTITY';if(this['_customItemInfo'][_0x2fd25e])return this['_customItemInfo'][_0x2fd25e];const _0x1f5c36=VisuMZ[_0x7c3ea3(0x3db)][_0x7c3ea3(0x6b0)][_0x7c3ea3(0x309)]['ItemQuantityFmt'];return _0x1f5c36[_0x7c3ea3(0x60c)]($gameParty['numItems'](this['_item']));},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x62d)]=function(_0x40d272,_0x40b111,_0xabb61f){const _0x47f2d7=_0x709961,_0xee0bba=this[_0x47f2d7(0x3b2)]();return this[_0x47f2d7(0x2c2)](_0xee0bba,_0x40d272,_0x40b111,_0xabb61f,![],'center'),this[_0x47f2d7(0x533)](_0x40d272,_0x40b111,_0xabb61f),this[_0x47f2d7(0x4e3)](),!![];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x3b2)]=function(){const _0x4723f0=_0x709961,_0x30fdda=_0x4723f0(0x27e);if(this['_customItemInfo'][_0x30fdda])return this[_0x4723f0(0x3b8)][_0x30fdda];const _0xbe2c05=VisuMZ[_0x4723f0(0x3db)]['Settings'][_0x4723f0(0x281)],_0x1c3795=_0x4723f0(0x379)['format'](this[_0x4723f0(0x3c2)][_0x4723f0(0x378)]);return _0xbe2c05[_0x1c3795];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x31c)]=function(_0x52145e,_0x5074c9,_0xf5a1f3){const _0x8ca518=_0x709961,_0x532031=this[_0x8ca518(0x6db)]();return this[_0x8ca518(0x2c2)](_0x532031,_0x52145e,_0x5074c9,_0xf5a1f3,![],'center'),this[_0x8ca518(0x533)](_0x52145e,_0x5074c9,_0xf5a1f3),this[_0x8ca518(0x4e3)](),!![];},Window_ShopStatus['prototype']['getItemScopeText']=function(){const _0x547ad3=_0x709961,_0x37e247='SCOPE';if(this['_customItemInfo'][_0x37e247])return this[_0x547ad3(0x3b8)][_0x37e247];const _0x242b67=VisuMZ[_0x547ad3(0x3db)][_0x547ad3(0x6b0)][_0x547ad3(0x281)];if(Imported[_0x547ad3(0x410)]){const _0xf29b06=this[_0x547ad3(0x3c2)][_0x547ad3(0x1e9)];if(_0xf29b06[_0x547ad3(0x1ed)](/<TARGET:[ ](.*)>/i)){const _0xc75da7=String(RegExp['$1']);if(_0xc75da7[_0x547ad3(0x1ed)](/(\d+) RANDOM ANY/i))return _0x547ad3(0x247)==='mNvYs'?_0x211ae5['VisuMZ_0_CoreEngine']&&_0x4ffbbd['prototype'][_0x547ad3(0x6d8)][_0x547ad3(0x376)](this):_0x242b67[_0x547ad3(0x462)][_0x547ad3(0x60c)](Number(RegExp['$1']));else{if(_0xc75da7['match'](/(\d+) RANDOM (?:ENEMY|ENEMIES|FOE|FOES)/i))return _0x242b67[_0x547ad3(0x3a9)][_0x547ad3(0x60c)](Number(RegExp['$1']));else{if(_0xc75da7['match'](/(\d+) RANDOM (?:ALLY|ALLIES|FRIEND|FRIENDS)/i))return _0x242b67[_0x547ad3(0x682)][_0x547ad3(0x60c)](Number(RegExp['$1']));else{if(_0xc75da7[_0x547ad3(0x1ed)](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS) (?:BUT|EXCEPT) (?:USER|SELF)/i))return _0x242b67[_0x547ad3(0x55e)];else{if(_0xc75da7[_0x547ad3(0x1ed)](/ALLY OR ENEMY/i))return _0x242b67[_0x547ad3(0x2ae)]||_0x242b67['Scope7'];else{if(_0xc75da7['match'](/ENEMY OR ALLY/i))return _0x242b67[_0x547ad3(0x3cd)]||_0x242b67[_0x547ad3(0x1c6)];}}}}}}}const _0x200a68=_0x547ad3(0x1e8)['format'](this[_0x547ad3(0x3c2)][_0x547ad3(0x34c)]);return _0x242b67[_0x200a68];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x575)]=function(_0x341f5d,_0x527cd2,_0xcf3c3f){const _0x5a2ce3=_0x709961,_0x4f132f=this[_0x5a2ce3(0x388)]();this[_0x5a2ce3(0x2c2)](_0x4f132f,_0x341f5d,_0x527cd2,_0xcf3c3f,!![]);const _0x54d6ec=this['getItemSpeedText']();return this[_0x5a2ce3(0x2c2)](_0x54d6ec,_0x341f5d,_0x527cd2,_0xcf3c3f,![],_0x5a2ce3(0x4b9)),this[_0x5a2ce3(0x533)](_0x341f5d,_0x527cd2,_0xcf3c3f),this[_0x5a2ce3(0x4e3)](),!![];},Window_ShopStatus['prototype']['getItemSpeedLabel']=function(){const _0x3e46f3=_0x709961;return VisuMZ[_0x3e46f3(0x3db)][_0x3e46f3(0x6b0)][_0x3e46f3(0x281)][_0x3e46f3(0x1ad)];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x3e3)]=function(){const _0x225941=_0x709961,_0x493721=_0x225941(0x69e);if(this[_0x225941(0x3b8)][_0x493721])return this[_0x225941(0x3b8)][_0x493721];const _0x518811=this['_item']['speed'];if(_0x518811>=0x7d0){if(_0x225941(0x223)===_0x225941(0x223))return VisuMZ['ItemsEquipsCore']['Settings'][_0x225941(0x281)][_0x225941(0x253)];else{_0x335a9b[_0x225941(0x615)]?(_0x1442c4=this[_0x225941(0x3bc)][_0x225941(0x29d)](_0x1511d7,![]),_0x3c6c38=this['_tempActor']['paramValueByName'](_0x188d0b,![]),_0x2f77d8=_0x1bf277(this[_0x225941(0x3bc)][_0x225941(0x29d)](_0x3af505,!![]))[_0x225941(0x1ed)](/([%％])/i)):(_0x32fea2=this[_0x225941(0x3bc)][_0x225941(0x307)](_0x4fef4a),_0x3c5440=this[_0x225941(0x342)][_0x225941(0x307)](_0x3a8bc0),_0xc67988=_0x17a5e4%0x1!==0x0||_0x590f67%0x1!==0x0);const _0xfbad31=_0x2455aa,_0x4be909=_0xac13be,_0x97b9b9=_0x4be909-_0xfbad31;let _0x381028=_0x97b9b9;if(_0x107e27)_0x381028=_0x103531['round'](_0x97b9b9*0x64)+'%';_0x97b9b9!==0x0&&(this['changeTextColor'](_0xc7b85d['paramchangeTextColor'](_0x97b9b9)),_0x381028=(_0x97b9b9>0x0?_0x225941(0x60a):'(%1)')[_0x225941(0x60c)](_0x381028),this[_0x225941(0x62c)](_0x381028,_0x5ca569+_0x50d22e,_0x53880d,_0x501de0,'left'));}}else{if(_0x518811>=0x3e8){if('VoYZp'!=='VoYZp')_0x1c7339=_0x28a3db[_0x225941(0x284)]((this['innerWidth']-_0x4986cd)/0x2);else return VisuMZ[_0x225941(0x3db)][_0x225941(0x6b0)][_0x225941(0x281)]['Speed1000'];}else{if(_0x518811>0x0)return VisuMZ[_0x225941(0x3db)][_0x225941(0x6b0)][_0x225941(0x281)][_0x225941(0x1ca)];else{if(_0x518811===0x0)return VisuMZ[_0x225941(0x3db)][_0x225941(0x6b0)][_0x225941(0x281)][_0x225941(0x40d)];else{if(_0x518811>-0x3e8){if(_0x225941(0x44c)===_0x225941(0x44c))return VisuMZ[_0x225941(0x3db)][_0x225941(0x6b0)][_0x225941(0x281)]['SpeedNeg999'];else{let _0x1f4b46=_0x2907bf[_0x225941(0x3db)][_0x225941(0x638)]['call'](this,_0x51aa80);for(const _0x550b30 of this[_0x225941(0x673)]()){if(_0x550b30)_0x1f4b46+=this[_0x225941(0x23f)](_0x550b30,_0x203712);}return _0x1f4b46;}}else{if(_0x518811>-0x7d0)return VisuMZ['ItemsEquipsCore'][_0x225941(0x6b0)]['StatusWindow'][_0x225941(0x599)];else return _0x518811<=-0x7d0?VisuMZ['ItemsEquipsCore']['Settings'][_0x225941(0x281)]['SpeedNeg2000']:_0x225941(0x562);}}}}}},Window_ShopStatus['prototype'][_0x709961(0x6e9)]=function(_0x14fdc2,_0x434ed4,_0x31d01b){const _0x11f315=_0x709961,_0x2c773f=this[_0x11f315(0x1e3)]();this[_0x11f315(0x2c2)](_0x2c773f,_0x14fdc2,_0x434ed4,_0x31d01b,!![]);const _0x2f288b=this[_0x11f315(0x424)]();return this[_0x11f315(0x2c2)](_0x2f288b,_0x14fdc2,_0x434ed4,_0x31d01b,![],'right'),this[_0x11f315(0x533)](_0x14fdc2,_0x434ed4,_0x31d01b),this[_0x11f315(0x4e3)](),!![];},Window_ShopStatus[_0x709961(0x5ef)]['getItemSuccessRateLabel']=function(){const _0x50d2e6=_0x709961;return VisuMZ[_0x50d2e6(0x3db)][_0x50d2e6(0x6b0)][_0x50d2e6(0x281)]['LabelSuccessRate'];},Window_ShopStatus[_0x709961(0x5ef)]['getItemSuccessRateText']=function(){const _0x3b4c04=_0x709961,_0x5e89bd=_0x3b4c04(0x53d);if(this['_customItemInfo'][_0x5e89bd])return this[_0x3b4c04(0x3b8)][_0x5e89bd];if(Imported[_0x3b4c04(0x410)]){const _0x1bb250=this[_0x3b4c04(0x3c2)][_0x3b4c04(0x1e9)];if(_0x1bb250['match'](/<ALWAYS HIT>/i)){if(_0x3b4c04(0x4ff)!==_0x3b4c04(0x4ff)){const _0x38593a=_0x3b4c04(0x4b5);if(!this[_0x3b4c04(0x6f3)]['removeStateBuffChanges']&&!this[_0x3b4c04(0x3b8)][_0x38593a])return![];const _0x19c2c2=this[_0x3b4c04(0x209)]();this[_0x3b4c04(0x2c2)](_0x19c2c2,_0x496ea8,_0x5528c1,_0x52b562,!![]);const _0x73ad2b=this[_0x3b4c04(0x4ee)]();return this[_0x3b4c04(0x2c2)](_0x73ad2b,_0x30ce3e,_0x5882e0,_0x587da0,![],_0x3b4c04(0x4b9)),this[_0x3b4c04(0x533)](_0x449fd9,_0x48600a,_0x5019aa),this[_0x3b4c04(0x4e3)](),!![];}else return _0x3b4c04(0x545);}else{if(_0x1bb250[_0x3b4c04(0x1ed)](/<ALWAYS HIT RATE: (\d+)([%％])>/i)){if('aAOfq'!==_0x3b4c04(0x2a8))_0x48116f[_0x3b4c04(0x3db)][_0x3b4c04(0x6ae)]['call'](this,_0xbcb7c2);else return'%1%'[_0x3b4c04(0x60c)](Number(RegExp['$1']));}}}return _0x3b4c04(0x400)[_0x3b4c04(0x60c)](this[_0x3b4c04(0x3c2)]['successRate']);},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x244)]=function(_0x2d2ff5,_0x1c62fd,_0x5757e0){const _0x2fa566=_0x709961,_0x63c4c8=this[_0x2fa566(0x4b3)]();this[_0x2fa566(0x2c2)](_0x63c4c8,_0x2d2ff5,_0x1c62fd,_0x5757e0,!![]);const _0x556de7=this[_0x2fa566(0x634)]();return this[_0x2fa566(0x2c2)](_0x556de7,_0x2d2ff5,_0x1c62fd,_0x5757e0,![],_0x2fa566(0x4b9)),this['drawItemDarkRect'](_0x2d2ff5,_0x1c62fd,_0x5757e0),this['resetFontSettings'](),!![];},Window_ShopStatus[_0x709961(0x5ef)]['getItemRepeatsLabel']=function(){const _0x475761=_0x709961;return VisuMZ[_0x475761(0x3db)][_0x475761(0x6b0)]['StatusWindow']['LabelRepeats'];},Window_ShopStatus['prototype']['getItemRepeatsText']=function(){const _0x19750e=_0x709961,_0x30bdde=_0x19750e(0x29c);if(this[_0x19750e(0x3b8)][_0x30bdde])return this[_0x19750e(0x3b8)][_0x30bdde];const _0x312aa5='×%1';return _0x312aa5[_0x19750e(0x60c)](this[_0x19750e(0x3c2)][_0x19750e(0x643)]);},Window_ShopStatus['prototype']['drawItemHitType']=function(_0x198125,_0x2b4cdd,_0x3e8e9d){const _0x9d5daf=_0x709961,_0x46fdc6=this['getItemHitTypeLabel']();this[_0x9d5daf(0x2c2)](_0x46fdc6,_0x198125,_0x2b4cdd,_0x3e8e9d,!![]);const _0x7d4bae=this[_0x9d5daf(0x250)]();return this[_0x9d5daf(0x2c2)](_0x7d4bae,_0x198125,_0x2b4cdd,_0x3e8e9d,![],_0x9d5daf(0x4b9)),this[_0x9d5daf(0x533)](_0x198125,_0x2b4cdd,_0x3e8e9d),this[_0x9d5daf(0x4e3)](),!![];},Window_ShopStatus[_0x709961(0x5ef)]['getItemHitTypeLabel']=function(){const _0x5bfbff=_0x709961;return VisuMZ[_0x5bfbff(0x3db)][_0x5bfbff(0x6b0)]['StatusWindow']['LabelHitType'];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x250)]=function(){const _0x40b911=_0x709961,_0x4efd3e=_0x40b911(0x514);if(this[_0x40b911(0x3b8)][_0x4efd3e])return this[_0x40b911(0x3b8)][_0x4efd3e];const _0x6e3bf2=VisuMZ['ItemsEquipsCore'][_0x40b911(0x6b0)][_0x40b911(0x281)],_0x52da29='HitType%1'[_0x40b911(0x60c)](this[_0x40b911(0x3c2)][_0x40b911(0x1f8)]);return _0x6e3bf2[_0x52da29];},Window_ShopStatus['prototype'][_0x709961(0x4c2)]=function(_0x298499,_0x1660b9,_0x23f596){const _0x4873a2=_0x709961;if(this[_0x4873a2(0x3c2)][_0x4873a2(0x553)][_0x4873a2(0x44f)]<=0x0)return _0x1660b9;if(this[_0x4873a2(0x4e0)](_0x298499,_0x1660b9,_0x23f596))_0x1660b9+=this['lineHeight']();if(this[_0x4873a2(0x57f)](_0x298499,_0x1660b9,_0x23f596))_0x1660b9+=this[_0x4873a2(0x361)]();return this[_0x4873a2(0x4e3)](),_0x1660b9;},Window_ShopStatus[_0x709961(0x5ef)]['drawItemDamageElement']=function(_0x52f421,_0x119af9,_0x53b183){const _0x5982e5=_0x709961,_0x593d92=this[_0x5982e5(0x699)]();this['drawItemKeyData'](_0x593d92,_0x52f421,_0x119af9,_0x53b183,!![]);const _0xc82f74=this[_0x5982e5(0x6e3)]();return this['drawItemKeyData'](_0xc82f74,_0x52f421,_0x119af9,_0x53b183,![],_0x5982e5(0x4b9)),this[_0x5982e5(0x533)](_0x52f421,_0x119af9,_0x53b183),this['resetFontSettings'](),!![];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x699)]=function(){const _0x245936=_0x709961;return VisuMZ['ItemsEquipsCore']['Settings'][_0x245936(0x281)][_0x245936(0x63e)];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x6e3)]=function(){const _0x5aa728=_0x709961,_0x397f03=_0x5aa728(0x505);if(this[_0x5aa728(0x3b8)][_0x397f03])return this[_0x5aa728(0x3b8)][_0x397f03];if(this[_0x5aa728(0x3c2)][_0x5aa728(0x553)][_0x5aa728(0x2de)]<=-0x1){if(_0x5aa728(0x2b6)===_0x5aa728(0x586))this[_0x5aa728(0x222)]();else return VisuMZ['ItemsEquipsCore'][_0x5aa728(0x6b0)]['StatusWindow'][_0x5aa728(0x2cb)];}else return this[_0x5aa728(0x3c2)][_0x5aa728(0x553)][_0x5aa728(0x2de)]===0x0?VisuMZ[_0x5aa728(0x3db)][_0x5aa728(0x6b0)][_0x5aa728(0x281)][_0x5aa728(0x5d2)]:_0x5aa728(0x19d)!==_0x5aa728(0x1ef)?$dataSystem[_0x5aa728(0x664)][this[_0x5aa728(0x3c2)][_0x5aa728(0x553)][_0x5aa728(0x2de)]]:_0x1457d0[_0x5aa728(0x3db)]['Scene_Equip_helpWindowRect']['call'](this);},Window_ShopStatus[_0x709961(0x5ef)]['drawItemDamageAmount']=function(_0x2d8952,_0x288c2e,_0x592e2c){const _0x3aec0f=_0x709961,_0x151d4d=this['getItemDamageAmountLabel']();this[_0x3aec0f(0x2c2)](_0x151d4d,_0x2d8952,_0x288c2e,_0x592e2c,!![]),this['setupItemDamageTempActors']();const _0x494ee5=this[_0x3aec0f(0x6f1)](),_0x3ee97f=ColorManager[_0x3aec0f(0x24c)]([0x0,0x0,0x2,0x1,0x3,0x1,0x3][this[_0x3aec0f(0x3c2)][_0x3aec0f(0x553)][_0x3aec0f(0x44f)]]);return this[_0x3aec0f(0x61c)](_0x3ee97f),this[_0x3aec0f(0x2c2)](_0x494ee5,_0x2d8952,_0x288c2e,_0x592e2c,![],_0x3aec0f(0x4b9)),this[_0x3aec0f(0x533)](_0x2d8952,_0x288c2e,_0x592e2c),this[_0x3aec0f(0x4e3)](),!![];},Window_ShopStatus['prototype'][_0x709961(0x2df)]=function(){const _0x3f4a3f=_0x709961;if(Imported[_0x3f4a3f(0x410)]&&DataManager[_0x3f4a3f(0x31f)](this[_0x3f4a3f(0x3c2)])!=='MANUAL'){if('sNOzt'!=='sNOzt')_0x2cd5f0=_0x4f8361[_0x3f4a3f(0x36d)](_0x4e669f),_0x11e982[_0x3f4a3f(0x67a)](_0x3699a3)||_0x480a28[_0x3f4a3f(0x3b3)](_0x2d7497)?this[_0x3f4a3f(0x2dd)](_0xc85a5f):_0x507c55['ItemsEquipsCore'][_0x3f4a3f(0x301)][_0x3f4a3f(0x376)](this,_0x2e2901);else return this['getItemDamageAmountLabelBattleCore']();}else{if(_0x3f4a3f(0x347)!==_0x3f4a3f(0x1a7))return this[_0x3f4a3f(0x6ed)]();else{if(_0x2bf786[_0x3f4a3f(0x676)](_0x3ac8e6))return![];if(!_0x5b6e1b[_0x3f4a3f(0x62e)](this,_0x1458d0))return![];if(!_0x52f285[_0x3f4a3f(0x69f)](this,_0x26809e))return![];return _0x5622e9[_0x3f4a3f(0x3db)][_0x3f4a3f(0x37c)]['call'](this,_0x5e1790);}}},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x6ed)]=function(){const _0x11cc3e=_0x709961,_0x3fd2aa=VisuMZ['ItemsEquipsCore']['Settings'][_0x11cc3e(0x281)],_0x4cf03d=_0x11cc3e(0x3a7)[_0x11cc3e(0x60c)](this[_0x11cc3e(0x3c2)]['damage'][_0x11cc3e(0x44f)]),_0x279e89=[null,TextManager['hp'],TextManager['mp'],TextManager['hp'],TextManager['mp'],TextManager['hp'],TextManager['mp']][this[_0x11cc3e(0x3c2)][_0x11cc3e(0x553)][_0x11cc3e(0x44f)]];return _0x3fd2aa[_0x4cf03d]['format'](_0x279e89);},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x2e8)]=function(){const _0x1da700=_0x709961,_0x24b842=$gameActors[_0x1da700(0x67f)](0x1);this[_0x1da700(0x3f6)]=JsonEx[_0x1da700(0x340)](_0x24b842),this[_0x1da700(0x53b)]=JsonEx[_0x1da700(0x340)](_0x24b842);},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x6f1)]=function(){const _0x3e72d0=_0x709961,_0xda0d2f=_0x3e72d0(0x380);if(this['_customItemInfo'][_0xda0d2f])return this['_customItemInfo'][_0xda0d2f];return Imported[_0x3e72d0(0x410)]&&DataManager['getDamageStyle'](this[_0x3e72d0(0x3c2)])!==_0x3e72d0(0x554)?this['getItemDamageAmountTextBattleCore']():this[_0x3e72d0(0x501)]();},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x501)]=function(){const _0x54bb68=_0x709961;window['a']=this[_0x54bb68(0x3f6)],window['b']=this[_0x54bb68(0x53b)],this[_0x54bb68(0x3f6)][_0x54bb68(0x6a1)](!![]),this[_0x54bb68(0x53b)][_0x54bb68(0x6a1)]([0x3,0x4][_0x54bb68(0x3bb)](this[_0x54bb68(0x3c2)][_0x54bb68(0x553)][_0x54bb68(0x44f)]));let _0x37a13c=this['_item'][_0x54bb68(0x553)][_0x54bb68(0x246)];try{if(_0x54bb68(0x313)===_0x54bb68(0x560))return this[_0x54bb68(0x5cd)]&&this[_0x54bb68(0x5cd)][_0x54bb68(0x6d8)]();else{const _0xf52975=Math[_0x54bb68(0x5f5)](eval(_0x37a13c),0x0)/window['a']['atk'];return this[_0x54bb68(0x36f)](),isNaN(_0xf52975)?_0x54bb68(0x562):_0x54bb68(0x400)['format'](Math['round'](_0xf52975*0x64));}}catch(_0x2c763a){return _0x54bb68(0x552)!==_0x54bb68(0x552)?_0x5b4ec0[_0x54bb68(0x3db)][_0x54bb68(0x6b0)][_0x54bb68(0x281)]['LabelApply']:($gameTemp[_0x54bb68(0x38b)]()&&(_0x54bb68(0x6c4)!==_0x54bb68(0x497)?(console['log'](_0x54bb68(0x6cd)[_0x54bb68(0x60c)](this[_0x54bb68(0x3c2)][_0x54bb68(0x5a7)])),console[_0x54bb68(0x4df)](_0x2c763a)):this['cursorPagedown']()),this[_0x54bb68(0x36f)](),_0x54bb68(0x562));}},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x36f)]=function(){window['a']=undefined,window['b']=undefined;},Window_ShopStatus['prototype'][_0x709961(0x440)]=function(_0x17fbcd,_0x2c1e05,_0xe88f03){const _0x2410d5=_0x709961;if(!this[_0x2410d5(0x3f5)]())return _0x2c1e05;if(this[_0x2410d5(0x45b)](_0x17fbcd,_0x2c1e05,_0xe88f03))_0x2c1e05+=this[_0x2410d5(0x361)]();if(this[_0x2410d5(0x3ea)](_0x17fbcd,_0x2c1e05,_0xe88f03))_0x2c1e05+=this[_0x2410d5(0x361)]();if(this[_0x2410d5(0x2b1)](_0x17fbcd,_0x2c1e05,_0xe88f03))_0x2c1e05+=this[_0x2410d5(0x361)]();if(this[_0x2410d5(0x5e1)](_0x17fbcd,_0x2c1e05,_0xe88f03))_0x2c1e05+=this[_0x2410d5(0x361)]();if(this['drawItemEffectsMpDamage'](_0x17fbcd,_0x2c1e05,_0xe88f03))_0x2c1e05+=this[_0x2410d5(0x361)]();if(this[_0x2410d5(0x596)](_0x17fbcd,_0x2c1e05,_0xe88f03))_0x2c1e05+=this[_0x2410d5(0x361)]();if(this['drawItemEffectsSelfTpGain'](_0x17fbcd,_0x2c1e05,_0xe88f03))_0x2c1e05+=this[_0x2410d5(0x361)]();if(this[_0x2410d5(0x487)](_0x17fbcd,_0x2c1e05,_0xe88f03))_0x2c1e05+=this[_0x2410d5(0x361)]();if(this['drawItemEffectsRemovedStatesBuffs'](_0x17fbcd,_0x2c1e05,_0xe88f03))_0x2c1e05+=this[_0x2410d5(0x361)]();return this[_0x2410d5(0x4e3)](),_0x2c1e05;},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x5ac)]=function(){const _0x3d6414=_0x709961;return this[_0x3d6414(0x3c2)]['effects'];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x3f5)]=function(){const _0x4f78ac=_0x709961;let _0x169207=![];this[_0x4f78ac(0x6f3)]={'rateHP':0x0,'flatHP':0x0,'rateMP':0x0,'flatMP':0x0,'gainTP':0x0,'selfTP':0x0,'addState':[],'removeState':[],'changeBuff':[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],'removeBuff':[],'removeDebuff':[],'addStateBuffChanges':![],'removeStateBuffChanges':![]};const _0x446902=this[_0x4f78ac(0x5ac)]();for(const _0x5c7ff4 of _0x446902){if(_0x4f78ac(0x46d)===_0x4f78ac(0x39e))_0x59c6ab['prototype']['processCursorMoveModernControls'][_0x4f78ac(0x376)](this);else switch(_0x5c7ff4[_0x4f78ac(0x467)]){case Game_Action[_0x4f78ac(0x574)]:this['_itemData']['rateHP']+=_0x5c7ff4[_0x4f78ac(0x3ab)],this[_0x4f78ac(0x6f3)][_0x4f78ac(0x2a3)]+=_0x5c7ff4['value2'],_0x169207=!![];break;case Game_Action[_0x4f78ac(0x6c2)]:this['_itemData']['rateMP']+=_0x5c7ff4['value1'],this[_0x4f78ac(0x6f3)][_0x4f78ac(0x684)]+=_0x5c7ff4[_0x4f78ac(0x450)],_0x169207=!![];break;case Game_Action['EFFECT_GAIN_TP']:this[_0x4f78ac(0x6f3)][_0x4f78ac(0x5b1)]+=_0x5c7ff4[_0x4f78ac(0x3ab)],_0x169207=!![];break;case Game_Action[_0x4f78ac(0x21e)]:this[_0x4f78ac(0x6f3)][_0x4f78ac(0x210)][_0x4f78ac(0x4ba)](_0x5c7ff4[_0x4f78ac(0x66f)]),_0x169207=!![];break;case Game_Action[_0x4f78ac(0x660)]:this['_itemData'][_0x4f78ac(0x1d3)][_0x4f78ac(0x4ba)](_0x5c7ff4[_0x4f78ac(0x66f)]),this['_itemData'][_0x4f78ac(0x39c)]=!![],_0x169207=!![];break;case Game_Action['EFFECT_ADD_BUFF']:this[_0x4f78ac(0x6f3)][_0x4f78ac(0x6da)][_0x5c7ff4[_0x4f78ac(0x66f)]]+=0x1,_0x169207=!![];break;case Game_Action[_0x4f78ac(0x688)]:this[_0x4f78ac(0x6f3)][_0x4f78ac(0x6da)][_0x5c7ff4[_0x4f78ac(0x66f)]]-=0x1,_0x169207=!![];break;case Game_Action['EFFECT_REMOVE_BUFF']:this[_0x4f78ac(0x6f3)][_0x4f78ac(0x279)]['push'](_0x5c7ff4[_0x4f78ac(0x66f)]),this[_0x4f78ac(0x6f3)][_0x4f78ac(0x39c)]=!![],_0x169207=!![];break;case Game_Action[_0x4f78ac(0x58c)]:this[_0x4f78ac(0x6f3)]['removeDebuff'][_0x4f78ac(0x4ba)](_0x5c7ff4[_0x4f78ac(0x66f)]),this['_itemData'][_0x4f78ac(0x39c)]=!![],_0x169207=!![];break;}}if(this['_itemData'][_0x4f78ac(0x210)]['length']>0x0)this[_0x4f78ac(0x6f3)]['addStateBuffChanges']=!![];for(let _0xa574d3=0x0;_0xa574d3<this[_0x4f78ac(0x6f3)][_0x4f78ac(0x6da)][_0x4f78ac(0x321)];_0xa574d3++){if('aUZsI'!==_0x4f78ac(0x3d5)){if(this['_itemData'][_0x4f78ac(0x6da)][_0xa574d3]!==0x0)this['_itemData']['addStateBuffChanges']=!![];}else _0x22a1f3=_0xfe640b[_0x4f78ac(0x5e5)][_0x496fd5(_0x6f19b6['$1'])]||'';}this['_item'][_0x4f78ac(0x36e)]!==0x0&&(this['_itemData']['selfTP']=this[_0x4f78ac(0x3c2)][_0x4f78ac(0x36e)],_0x169207=!![]);const _0x43b878=[_0x4f78ac(0x6c5),_0x4f78ac(0x613),_0x4f78ac(0x5fa),'HP\x20DAMAGE',_0x4f78ac(0x1bf),'TP\x20DAMAGE',_0x4f78ac(0x65c),_0x4f78ac(0x3eb),_0x4f78ac(0x4b5)];for(const _0x230558 of _0x43b878){if(this[_0x4f78ac(0x3b8)][_0x230558]){if('TUOsg'!=='MqqTn'){_0x169207=!![];break;}else{const _0x306dac=_0x33c180['concat'](_0x32c3a0[_0x4f78ac(0x359)]());return _0x306dac;}}}return _0x169207;},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x45b)]=function(_0xa3095,_0x2e9bb6,_0x3c4fec){const _0x27cdac=_0x709961,_0x3a7036=_0x27cdac(0x6c5);if(this[_0x27cdac(0x6f3)][_0x27cdac(0x395)]<=0x0&&this[_0x27cdac(0x6f3)][_0x27cdac(0x2a3)]<=0x0&&!this[_0x27cdac(0x3b8)][_0x3a7036])return![];const _0x1765bb=this[_0x27cdac(0x52e)]();this[_0x27cdac(0x2c2)](_0x1765bb,_0xa3095,_0x2e9bb6,_0x3c4fec,!![]);const _0x3990c7=this['getItemEffectsHpRecoveryText']();return this[_0x27cdac(0x61c)](ColorManager[_0x27cdac(0x24c)](0x1)),this[_0x27cdac(0x2c2)](_0x3990c7,_0xa3095,_0x2e9bb6,_0x3c4fec,![],_0x27cdac(0x4b9)),this[_0x27cdac(0x533)](_0xa3095,_0x2e9bb6,_0x3c4fec),this['resetFontSettings'](),!![];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x52e)]=function(){const _0x8f7f08=_0x709961,_0x48a148=VisuMZ[_0x8f7f08(0x3db)][_0x8f7f08(0x6b0)][_0x8f7f08(0x281)][_0x8f7f08(0x667)];return _0x48a148[_0x8f7f08(0x60c)](TextManager['hp']);},Window_ShopStatus[_0x709961(0x5ef)]['getItemEffectsHpRecoveryText']=function(){const _0x3bd95f=_0x709961,_0x11a38f=_0x3bd95f(0x6c5);if(this[_0x3bd95f(0x3b8)][_0x11a38f])return this['_customItemInfo'][_0x11a38f];let _0x3527c2='';if(this[_0x3bd95f(0x6f3)][_0x3bd95f(0x395)]>0x0)_0x3527c2+=_0x3bd95f(0x621)['format'](Math[_0x3bd95f(0x4e5)](this[_0x3bd95f(0x6f3)][_0x3bd95f(0x395)]*0x64));if(this[_0x3bd95f(0x6f3)]['rateHP']>0x0&&this[_0x3bd95f(0x6f3)]['flatHP']>0x0)_0x3527c2+='\x20';if(this[_0x3bd95f(0x6f3)][_0x3bd95f(0x2a3)]>0x0)_0x3527c2+=_0x3bd95f(0x367)[_0x3bd95f(0x60c)](this[_0x3bd95f(0x6f3)][_0x3bd95f(0x2a3)]);return _0x3527c2;},Window_ShopStatus[_0x709961(0x5ef)]['drawItemEffectsMpRecovery']=function(_0x354810,_0x29c2bd,_0x542926){const _0x16441f=_0x709961,_0xcb5ad2=_0x16441f(0x613);if(this['_itemData']['rateMP']<=0x0&&this[_0x16441f(0x6f3)][_0x16441f(0x684)]<=0x0&&!this[_0x16441f(0x3b8)][_0xcb5ad2])return![];const _0x5216cd=this[_0x16441f(0x58b)]();this[_0x16441f(0x2c2)](_0x5216cd,_0x354810,_0x29c2bd,_0x542926,!![]);const _0x1157f0=this['getItemEffectsMpRecoveryText']();return this['changeTextColor'](ColorManager[_0x16441f(0x24c)](0x3)),this['drawItemKeyData'](_0x1157f0,_0x354810,_0x29c2bd,_0x542926,![],_0x16441f(0x4b9)),this[_0x16441f(0x533)](_0x354810,_0x29c2bd,_0x542926),this[_0x16441f(0x4e3)](),!![];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x58b)]=function(){const _0x3fb5e2=_0x709961,_0x3bb0e8=VisuMZ[_0x3fb5e2(0x3db)][_0x3fb5e2(0x6b0)][_0x3fb5e2(0x281)][_0x3fb5e2(0x54a)];return _0x3bb0e8[_0x3fb5e2(0x60c)](TextManager['mp']);},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x311)]=function(){const _0x296b5e=_0x709961,_0x56ed34=_0x296b5e(0x613);if(this[_0x296b5e(0x3b8)][_0x56ed34])return this[_0x296b5e(0x3b8)][_0x56ed34];let _0x2be804='';if(this[_0x296b5e(0x6f3)][_0x296b5e(0x669)]>0x0)_0x2be804+=_0x296b5e(0x621)['format'](Math['floor'](this[_0x296b5e(0x6f3)][_0x296b5e(0x669)]*0x64));if(this[_0x296b5e(0x6f3)][_0x296b5e(0x669)]>0x0&&this[_0x296b5e(0x6f3)][_0x296b5e(0x684)]>0x0)_0x2be804+='\x20';if(this[_0x296b5e(0x6f3)]['flatMP']>0x0)_0x2be804+=_0x296b5e(0x367)[_0x296b5e(0x60c)](this[_0x296b5e(0x6f3)][_0x296b5e(0x684)]);return _0x2be804;},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x2b1)]=function(_0x2bb68f,_0x39690c,_0x47c7cc){const _0x35327f=_0x709961,_0x5e9744=_0x35327f(0x5fa);if(this[_0x35327f(0x6f3)]['gainTP']<=0x0&&!this[_0x35327f(0x3b8)][_0x5e9744])return![];const _0xeee1bd=this[_0x35327f(0x5e7)]();this['drawItemKeyData'](_0xeee1bd,_0x2bb68f,_0x39690c,_0x47c7cc,!![]);const _0x4e43b0=this[_0x35327f(0x362)]();return this[_0x35327f(0x61c)](ColorManager[_0x35327f(0x35e)]()),this['drawItemKeyData'](_0x4e43b0,_0x2bb68f,_0x39690c,_0x47c7cc,![],_0x35327f(0x4b9)),this[_0x35327f(0x533)](_0x2bb68f,_0x39690c,_0x47c7cc),this[_0x35327f(0x4e3)](),!![];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x5e7)]=function(){const _0xd44656=_0x709961,_0x1b0096=VisuMZ[_0xd44656(0x3db)][_0xd44656(0x6b0)][_0xd44656(0x281)][_0xd44656(0x4a1)];return _0x1b0096[_0xd44656(0x60c)](TextManager['tp']);},Window_ShopStatus[_0x709961(0x5ef)]['getItemEffectsTpRecoveryText']=function(){const _0x4660de=_0x709961,_0x38893f=_0x4660de(0x5fa);if(this[_0x4660de(0x3b8)][_0x38893f])return this['_customItemInfo'][_0x38893f];let _0x2509d1='';return _0x2509d1+=_0x4660de(0x367)['format'](this['_itemData'][_0x4660de(0x5b1)]),_0x2509d1;},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x1d2)]=function(_0x811144,_0x33b344,_0x3651a2){const _0x487ad6=_0x709961,_0x1c6c4d=_0x487ad6(0x65c);if(this[_0x487ad6(0x6f3)]['selfTP']===0x0&&!this[_0x487ad6(0x3b8)][_0x1c6c4d])return![];const _0x1787e8=this['getItemEffectsSelfTpGainLabel']();this[_0x487ad6(0x2c2)](_0x1787e8,_0x811144,_0x33b344,_0x3651a2,!![]);const _0xc6ef2e=this[_0x487ad6(0x54f)]();return this[_0x487ad6(0x6f3)]['selfTP']>0x0?this[_0x487ad6(0x61c)](ColorManager[_0x487ad6(0x35e)]()):this[_0x487ad6(0x61c)](ColorManager[_0x487ad6(0x298)]()),this[_0x487ad6(0x2c2)](_0xc6ef2e,_0x811144,_0x33b344,_0x3651a2,![],'right'),this[_0x487ad6(0x533)](_0x811144,_0x33b344,_0x3651a2),this[_0x487ad6(0x4e3)](),!![];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x24a)]=function(){const _0x1d06f0=_0x709961,_0x501e78=VisuMZ[_0x1d06f0(0x3db)][_0x1d06f0(0x6b0)][_0x1d06f0(0x281)][_0x1d06f0(0x506)];return _0x501e78[_0x1d06f0(0x60c)](TextManager['tp']);},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x54f)]=function(){const _0x48bc23=_0x709961,_0x194e96='USER\x20TP\x20GAIN';if(this[_0x48bc23(0x3b8)][_0x194e96])return this['_customItemInfo'][_0x194e96];let _0x270054='';if(this[_0x48bc23(0x6f3)][_0x48bc23(0x69d)]>0x0){if(_0x48bc23(0x30c)===_0x48bc23(0x30c))_0x270054+=_0x48bc23(0x367)[_0x48bc23(0x60c)](this[_0x48bc23(0x6f3)][_0x48bc23(0x69d)]);else{if(_0x545ee0>=0x0)_0x1446cb===this[_0x48bc23(0x624)]()&&(this[_0x48bc23(0x56a)]=!![]),this[_0x48bc23(0x55a)](),this[_0x48bc23(0x2a0)](_0x597ca2);else _0x84d328[_0x48bc23(0x2bb)]()>=0x0&&(this['deactivate'](),this[_0x48bc23(0x6cb)]());}}else _0x48bc23(0x3e5)!==_0x48bc23(0x3e5)?this['artifactIDs'][_0x48bc23(0x470)]['push'](_0x26492e['id']):_0x270054+='%1'[_0x48bc23(0x60c)](this[_0x48bc23(0x6f3)][_0x48bc23(0x69d)]);return _0x270054;},Window_ShopStatus[_0x709961(0x5ef)]['drawItemEffectsHpDamage']=function(_0x324bd4,_0x4340ec,_0x3a0484){const _0x298b9f=_0x709961,_0x4611f0=_0x298b9f(0x1fc);if(this[_0x298b9f(0x6f3)][_0x298b9f(0x395)]>=0x0&&this[_0x298b9f(0x6f3)][_0x298b9f(0x2a3)]>=0x0&&!this[_0x298b9f(0x3b8)][_0x4611f0])return![];const _0x3cebbe=this[_0x298b9f(0x2c7)]();this[_0x298b9f(0x2c2)](_0x3cebbe,_0x324bd4,_0x4340ec,_0x3a0484,!![]);const _0x39ccb0=this[_0x298b9f(0x331)]();return this[_0x298b9f(0x61c)](ColorManager['damageColor'](0x0)),this[_0x298b9f(0x2c2)](_0x39ccb0,_0x324bd4,_0x4340ec,_0x3a0484,![],'right'),this[_0x298b9f(0x533)](_0x324bd4,_0x4340ec,_0x3a0484),this[_0x298b9f(0x4e3)](),!![];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x2c7)]=function(){const _0x2634f6=_0x709961,_0x4f2186=VisuMZ[_0x2634f6(0x3db)][_0x2634f6(0x6b0)]['StatusWindow'][_0x2634f6(0x3d9)];return _0x4f2186[_0x2634f6(0x60c)](TextManager['hp']);},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x331)]=function(){const _0x25218e=_0x709961,_0x54c5eb='HP\x20DAMAGE';if(this[_0x25218e(0x3b8)][_0x54c5eb])return this[_0x25218e(0x3b8)][_0x54c5eb];let _0x24d69b='';if(this['_itemData']['rateHP']<0x0)_0x24d69b+=_0x25218e(0x400)[_0x25218e(0x60c)](Math['floor'](this['_itemData'][_0x25218e(0x395)]*0x64));if(this['_itemData'][_0x25218e(0x395)]<0x0&&this[_0x25218e(0x6f3)][_0x25218e(0x2a3)]<0x0)_0x24d69b+='\x20';if(this[_0x25218e(0x6f3)][_0x25218e(0x2a3)]<0x0)_0x24d69b+='%1'[_0x25218e(0x60c)](this['_itemData'][_0x25218e(0x2a3)]);return _0x24d69b;},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x5ed)]=function(_0x2daa8e,_0x20fd9e,_0x120b8f){const _0x3aa864=_0x709961,_0x1a0889=_0x3aa864(0x1bf);if(this[_0x3aa864(0x6f3)][_0x3aa864(0x669)]>=0x0&&this['_itemData'][_0x3aa864(0x684)]>=0x0&&!this['_customItemInfo'][_0x1a0889])return![];const _0x366dc5=this[_0x3aa864(0x412)]();this[_0x3aa864(0x2c2)](_0x366dc5,_0x2daa8e,_0x20fd9e,_0x120b8f,!![]);const _0x1e25cd=this[_0x3aa864(0x6eb)]();return this[_0x3aa864(0x61c)](ColorManager[_0x3aa864(0x24c)](0x2)),this[_0x3aa864(0x2c2)](_0x1e25cd,_0x2daa8e,_0x20fd9e,_0x120b8f,![],_0x3aa864(0x4b9)),this['drawItemDarkRect'](_0x2daa8e,_0x20fd9e,_0x120b8f),this[_0x3aa864(0x4e3)](),!![];},Window_ShopStatus['prototype'][_0x709961(0x412)]=function(){const _0x26e30d=_0x709961,_0x1cfa4e=VisuMZ[_0x26e30d(0x3db)][_0x26e30d(0x6b0)][_0x26e30d(0x281)][_0x26e30d(0x5e6)];return _0x1cfa4e[_0x26e30d(0x60c)](TextManager['mp']);},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x6eb)]=function(){const _0x5162d3=_0x709961,_0x1714b2='MP\x20DAMAGE';if(this[_0x5162d3(0x3b8)][_0x1714b2])return this[_0x5162d3(0x3b8)][_0x1714b2];let _0x4901b1='';if(this[_0x5162d3(0x6f3)][_0x5162d3(0x669)]<0x0)_0x4901b1+=_0x5162d3(0x400)[_0x5162d3(0x60c)](Math[_0x5162d3(0x4e5)](this[_0x5162d3(0x6f3)][_0x5162d3(0x669)]*0x64));if(this['_itemData'][_0x5162d3(0x669)]<0x0&&this[_0x5162d3(0x6f3)][_0x5162d3(0x684)]<0x0)_0x4901b1+='\x20';if(this[_0x5162d3(0x6f3)][_0x5162d3(0x684)]<0x0)_0x4901b1+='%1'[_0x5162d3(0x60c)](this['_itemData'][_0x5162d3(0x684)]);return _0x4901b1;},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x596)]=function(_0x35c3d3,_0x47500e,_0x50db60){const _0x1daaea=_0x709961,_0x34f23c=_0x1daaea(0x64c);if(this[_0x1daaea(0x6f3)][_0x1daaea(0x5b1)]>=0x0&&!this[_0x1daaea(0x3b8)][_0x34f23c])return![];const _0x1b9788=this['getItemEffectsTpDamageLabel']();this[_0x1daaea(0x2c2)](_0x1b9788,_0x35c3d3,_0x47500e,_0x50db60,!![]);const _0x176f90=this[_0x1daaea(0x64e)]();return this[_0x1daaea(0x61c)](ColorManager[_0x1daaea(0x298)]()),this[_0x1daaea(0x2c2)](_0x176f90,_0x35c3d3,_0x47500e,_0x50db60,![],'right'),this[_0x1daaea(0x533)](_0x35c3d3,_0x47500e,_0x50db60),this[_0x1daaea(0x4e3)](),!![];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x1fa)]=function(){const _0x39d1f2=_0x709961,_0x46f981=VisuMZ[_0x39d1f2(0x3db)]['Settings'][_0x39d1f2(0x281)][_0x39d1f2(0x589)];return _0x46f981['format'](TextManager['tp']);},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x64e)]=function(){const _0x35b02e=_0x709961,_0x4046e8=_0x35b02e(0x64c);if(this[_0x35b02e(0x3b8)][_0x4046e8])return this[_0x35b02e(0x3b8)][_0x4046e8];let _0x346a23='';return _0x346a23+='%1'[_0x35b02e(0x60c)](this[_0x35b02e(0x6f3)][_0x35b02e(0x5b1)]),_0x346a23;},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x487)]=function(_0x3ea59c,_0x5ab4e6,_0x77eac1){const _0x238cd9=_0x709961,_0x4ed1d5=_0x238cd9(0x3eb);if(!this['_itemData'][_0x238cd9(0x312)]&&!this[_0x238cd9(0x3b8)][_0x4ed1d5])return![];const _0x329e82=this['getItemEffectsAddedStatesBuffsText']();if(_0x329e82[_0x238cd9(0x321)]<=0x0)return![];const _0x59953e=this['getItemEffectsAddedStatesBuffsLabel']();return this['drawItemKeyData'](_0x59953e,_0x3ea59c,_0x5ab4e6,_0x77eac1,!![]),this['drawItemKeyData'](_0x329e82,_0x3ea59c,_0x5ab4e6,_0x77eac1,![],_0x238cd9(0x4b9)),this[_0x238cd9(0x533)](_0x3ea59c,_0x5ab4e6,_0x77eac1),this[_0x238cd9(0x4e3)](),!![];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x5c5)]=function(){const _0x3b4c5a=_0x709961;return VisuMZ[_0x3b4c5a(0x3db)][_0x3b4c5a(0x6b0)][_0x3b4c5a(0x281)][_0x3b4c5a(0x583)];},Window_ShopStatus['prototype'][_0x709961(0x608)]=function(){const _0xf84aef=_0x709961,_0x30203d=_0xf84aef(0x3eb);if(this[_0xf84aef(0x3b8)][_0x30203d])return this['_customItemInfo'][_0x30203d];let _0x4c44c2='',_0x414d51=0x0;const _0x1bfb1f=0x8;for(const _0xbd36c7 of this[_0xf84aef(0x6f3)][_0xf84aef(0x210)]){const _0x342a3e=$dataStates[_0xbd36c7];if(_0x342a3e&&_0x342a3e[_0xf84aef(0x4a7)]>0x0){_0x4c44c2+='\x5cI[%1]'[_0xf84aef(0x60c)](_0x342a3e['iconIndex']),_0x414d51++;if(_0x414d51>=_0x1bfb1f)return _0x4c44c2;}}for(let _0x35dc08=0x0;_0x35dc08<this[_0xf84aef(0x6f3)][_0xf84aef(0x6da)]['length'];_0x35dc08++){if(_0xf84aef(0x2b2)==='DkCoo'){const _0x100764=this[_0xf84aef(0x6f3)][_0xf84aef(0x6da)][_0x35dc08],_0x9d8708=Game_BattlerBase[_0xf84aef(0x5ef)][_0xf84aef(0x1ea)](_0x100764,_0x35dc08);if(_0x9d8708>0x0){_0x4c44c2+=_0xf84aef(0x3d2)[_0xf84aef(0x60c)](_0x9d8708),_0x414d51++;if(_0x414d51>=_0x1bfb1f)return _0x4c44c2;}}else _0x4fe42d[_0xf84aef(0x3db)][_0xf84aef(0x332)]['call'](this),this[_0xf84aef(0x289)]()&&this[_0xf84aef(0x266)]();}return _0x4c44c2;},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x44a)]=function(_0x28d91e,_0x3d7be4,_0x2ae4a2){const _0x424322=_0x709961,_0x9911be=_0x424322(0x4b5);if(!this['_itemData'][_0x424322(0x39c)]&&!this[_0x424322(0x3b8)][_0x9911be])return![];const _0x56225b=this[_0x424322(0x209)]();this[_0x424322(0x2c2)](_0x56225b,_0x28d91e,_0x3d7be4,_0x2ae4a2,!![]);const _0x4be738=this[_0x424322(0x4ee)]();return this[_0x424322(0x2c2)](_0x4be738,_0x28d91e,_0x3d7be4,_0x2ae4a2,![],'right'),this[_0x424322(0x533)](_0x28d91e,_0x3d7be4,_0x2ae4a2),this['resetFontSettings'](),!![];},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x209)]=function(){const _0xbaa0b5=_0x709961;return VisuMZ[_0xbaa0b5(0x3db)][_0xbaa0b5(0x6b0)][_0xbaa0b5(0x281)][_0xbaa0b5(0x67c)];},Window_ShopStatus['prototype'][_0x709961(0x4ee)]=function(){const _0x29080b=_0x709961,_0x2567be=_0x29080b(0x4b5);if(this['_customItemInfo'][_0x2567be])return this[_0x29080b(0x3b8)][_0x2567be];let _0x2ddbcb='',_0xb8f9f2=0x0;const _0x3e0074=VisuMZ['ItemsEquipsCore'][_0x29080b(0x6b0)][_0x29080b(0x281)]['MaxIcons'];for(const _0x1355ac of this[_0x29080b(0x6f3)][_0x29080b(0x1d3)]){const _0x5d9ae2=$dataStates[_0x1355ac];if(_0x5d9ae2&&_0x5d9ae2[_0x29080b(0x4a7)]>0x0){_0x2ddbcb+=_0x29080b(0x3d2)[_0x29080b(0x60c)](_0x5d9ae2[_0x29080b(0x4a7)]),_0xb8f9f2++;if(_0xb8f9f2>=_0x3e0074)return _0x2ddbcb;}}for(let _0x2411ed=0x0;_0x2411ed<this[_0x29080b(0x6f3)][_0x29080b(0x279)]['length'];_0x2411ed++){const _0x4c3b82=this[_0x29080b(0x6f3)][_0x29080b(0x279)][_0x2411ed],_0x171ffe=Game_BattlerBase[_0x29080b(0x5ef)][_0x29080b(0x1ea)](0x1,_0x4c3b82);if(_0x171ffe>0x0){_0x2ddbcb+=_0x29080b(0x3d2)[_0x29080b(0x60c)](_0x171ffe),_0xb8f9f2++;if(_0xb8f9f2>=_0x3e0074)return _0x2ddbcb;}}for(let _0x12c0a4=0x0;_0x12c0a4<this[_0x29080b(0x6f3)][_0x29080b(0x6d1)]['length'];_0x12c0a4++){if(_0x29080b(0x38f)!=='OmdWX'){const _0x265a48=this[_0x29080b(0x6f3)]['removeDebuff'][_0x12c0a4],_0x3eae31=Game_BattlerBase[_0x29080b(0x5ef)]['buffIconIndex'](-0x1,_0x265a48);if(_0x3eae31>0x0){_0x2ddbcb+=_0x29080b(0x3d2)['format'](_0x3eae31),_0xb8f9f2++;if(_0xb8f9f2>=_0x3e0074)return _0x2ddbcb;}}else return![];}return _0x2ddbcb;},Window_ShopStatus[_0x709961(0x5ef)]['drawItemCustomEntries']=function(_0x5f246d,_0x26255a,_0x30a883){const _0x9ece3d=_0x709961;if(this[_0x9ece3d(0x3c2)][_0x9ece3d(0x1e9)][_0x9ece3d(0x1ed)](/<CUSTOM STATUS INFO>\s*([\s\S]*)\s*<\/CUSTOM STATUS INFO>/i)){if('aiUkS'===_0x9ece3d(0x612)){const _0xe583e2=String(RegExp['$1'])[_0x9ece3d(0x617)](/[\r\n]+/);for(const _0x166fb9 of _0xe583e2){if('bYgWD'===_0x9ece3d(0x437)){const _0x2e35cb=this[_0x9ece3d(0x6f3)][_0x9ece3d(0x6da)][_0x146528],_0x46596a=_0x4b7abb[_0x9ece3d(0x5ef)][_0x9ece3d(0x1ea)](_0x2e35cb,_0x4704f3);if(_0x46596a>0x0){_0xf3ace0+=_0x9ece3d(0x3d2)['format'](_0x46596a),_0x39547d++;if(_0x519164>=_0x12a7c8)return _0x3f7084;}}else{if(_0x166fb9[_0x9ece3d(0x1ed)](/(.*):[ ](.*)/i)){if(_0x9ece3d(0x282)===_0x9ece3d(0x282)){const _0x3323ea=String(RegExp['$1'])[_0x9ece3d(0x3c4)](),_0x23490c=String(RegExp['$2'])[_0x9ece3d(0x3c4)]();this[_0x9ece3d(0x3d0)](_0x3323ea,_0x23490c,_0x5f246d,_0x26255a,_0x30a883),_0x26255a+=this[_0x9ece3d(0x361)]();}else this['drawRemoveItem'](_0x36cc75);}}}}else{const _0xeaba3e=_0x17c4a5(_0x142bfd['$1'])[_0x9ece3d(0x617)](',')[_0x9ece3d(0x1ac)](_0x45594c=>_0x1cdc9f(_0x45594c));if(_0xeaba3e[_0x9ece3d(0x217)](_0x709243=>_0x358ce5[_0x9ece3d(0x337)](_0x709243)))return![];}}return this[_0x9ece3d(0x4e3)](),_0x26255a;},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x3d0)]=function(_0x344af2,_0x518f43,_0x3fe7c2,_0x4f43e1,_0x29c4d9){const _0x52927e=_0x709961;this[_0x52927e(0x2c2)](_0x344af2,_0x3fe7c2,_0x4f43e1,_0x29c4d9,!![]),this['drawItemKeyData'](_0x518f43,_0x3fe7c2,_0x4f43e1,_0x29c4d9,![],_0x52927e(0x4b9)),this['drawItemDarkRect'](_0x3fe7c2,_0x4f43e1,_0x29c4d9),this[_0x52927e(0x4e3)]();},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x4c5)]=function(){const _0x3dc262=_0x709961;if(!this[_0x3dc262(0x3c2)])return;const _0x35fb0e=this['_item'][_0x3dc262(0x1e9)],_0x1f8fae=/<SHOP (?:PICTURE|IMAGE|PICTURE NAME|PICTURE FILENAME|IMAGE NAME|IMAGE FILENAME):[ ](.*)>/gi,_0x62f42e=_0x35fb0e[_0x3dc262(0x1ed)](_0x1f8fae);if(_0x62f42e)for(const _0x483322 of _0x62f42e){if(_0x3dc262(0x56d)!==_0x3dc262(0x2b0)){_0x483322['match'](_0x1f8fae);const _0x593414=String(RegExp['$1'])[_0x3dc262(0x3c4)]()||'';if(_0x593414==='')continue;const _0x1f404e=ImageManager['loadPicture'](_0x593414);_0x1f404e[_0x3dc262(0x535)](this['drawCustomShopGraphicLoad']['bind'](this,_0x1f404e,this[_0x3dc262(0x3c2)]));}else{const _0xe4457e=0x0,_0x31db96=this[_0x3dc262(0x31b)](),_0x2e4745=_0x3beba5[_0x3dc262(0x628)],_0x8072e3=this['calcWindowHeight'](0x1,!![]);return new _0x3867bd(_0xe4457e,_0x31db96,_0x2e4745,_0x8072e3);}}},Window_ShopStatus[_0x709961(0x5ef)][_0x709961(0x6ec)]=function(_0x609fca,_0x4e5614){const _0x5006d4=_0x709961;if(this[_0x5006d4(0x3c2)]!==_0x4e5614)return;if(!_0x609fca)return;if(_0x609fca['width']<=0x0||_0x609fca[_0x5006d4(0x232)]<=0x0)return;const _0x14472c=_0x4e5614[_0x5006d4(0x1e9)];let _0x581443=_0x5006d4(0x1c5);_0x14472c[_0x5006d4(0x1ed)](/<SHOP (?:PICTURE|IMAGE) LAYER:[ ]FOREGROUND>/i)&&(_0x581443=_0x5006d4(0x598));const _0x3fa161=_0x581443===_0x5006d4(0x1c5)?this[_0x5006d4(0x544)]:this[_0x5006d4(0x30a)];let _0x13e7d8=this[_0x5006d4(0x224)],_0x5adf1f=this[_0x5006d4(0x6ca)];_0x14472c['match'](/<SHOP (?:PICTURE|IMAGE) MAX WIDTH:[ ](\d+)>/i)&&(_0x13e7d8=Number(RegExp['$1']));_0x14472c[_0x5006d4(0x1ed)](/<SHOP (?:PICTURE|IMAGE) MAX HEIGHT:[ ](\d+)>/i)&&(_0x5adf1f=Number(RegExp['$1']));_0x14472c[_0x5006d4(0x1ed)](/<SHOP (?:PICTURE|IMAGE) MAX DIMENSIONS:[ ](\d+),[ ]*(\d+)>/i)&&(_0x13e7d8=Number(RegExp['$1']),_0x5adf1f=Number(RegExp['$2']));const _0x2facba=Math[_0x5006d4(0x2d0)](0x1,_0x13e7d8/_0x609fca[_0x5006d4(0x4ca)],_0x5adf1f/_0x609fca[_0x5006d4(0x232)]);let _0x5a7402=0x0,_0x3afd94=0x0,_0x20b938=Math[_0x5006d4(0x4e5)](_0x609fca[_0x5006d4(0x4ca)]*_0x2facba),_0x30337b=Math['floor'](_0x609fca[_0x5006d4(0x232)]*_0x2facba),_0x4ed75c=_0x5006d4(0x50b);_0x14472c[_0x5006d4(0x1ed)](/<SHOP (?:PICTURE|IMAGE) (?:ALIGN|ALIGNMENT):[ ](LEFT|CENTER|RIGHT)>/i)&&(_0x4ed75c=String(RegExp['$1'])[_0x5006d4(0x52f)]()[_0x5006d4(0x3c4)]());if(_0x4ed75c===_0x5006d4(0x316))'LcWRr'!==_0x5006d4(0x4b2)?this[_0x5006d4(0x3df)]():_0x5a7402=0x0;else _0x4ed75c===_0x5006d4(0x50b)?_0x5a7402=Math[_0x5006d4(0x284)]((this[_0x5006d4(0x224)]-_0x20b938)/0x2):_0x5a7402=this[_0x5006d4(0x224)]-_0x20b938;let _0x5d6f3c='middle';_0x14472c['match'](/<SHOP (?:PICTURE|IMAGE) POSITION:[ ](TOP|MIDDLE|BOTTOM)>/i)&&(_0x5d6f3c=String(RegExp['$1'])[_0x5006d4(0x52f)]()['trim']());if(_0x5d6f3c==='top')_0x3afd94=0x0;else{if(_0x5d6f3c===_0x5006d4(0x3de)){if(_0x5006d4(0x5eb)!==_0x5006d4(0x5eb))return this['isUseItemsEquipsCoreUpdatedLayout']()?this[_0x5006d4(0x386)]():_0xb45a01[_0x5006d4(0x3db)][_0x5006d4(0x58a)]['call'](this);else _0x3afd94=Math[_0x5006d4(0x284)]((this[_0x5006d4(0x6ca)]-_0x30337b)/0x2);}else _0x3afd94=this[_0x5006d4(0x6ca)]-_0x30337b;}if(_0x14472c[_0x5006d4(0x1ed)](/<SHOP (?:PICTURE|IMAGE) OFFSET X:[ ]([\+\-]\d+)>/i)){if(_0x5006d4(0x2e3)==='nDHeY'){if(_0x364b23['value'](_0x2a4a0b))return![];}else _0x5a7402+=Number(RegExp['$1']);}if(_0x14472c[_0x5006d4(0x1ed)](/<SHOP (?:PICTURE|IMAGE) OFFSET Y:[ ]([\+\-]\d+)>/i)){if(_0x5006d4(0x30f)===_0x5006d4(0x238)){const _0x593840=_0x328cbd(_0x10d4bb['$1'])||0x1;if(_0x365a21>=_0x593840)return!![];}else _0x3afd94+=Number(RegExp['$1']);}_0x14472c[_0x5006d4(0x1ed)](/<SHOP (?:PICTURE|IMAGE) OFFSET:[ ]([\+\-]\d+),[ ]*([\+\-]\d+)>/i)&&(_0x5a7402+=Number(RegExp['$1']),_0x3afd94+=Number(RegExp['$2']));let _0x4fd13f=0xff;if(_0x14472c[_0x5006d4(0x1ed)](/<SHOP (?:PICTURE|IMAGE) OPACITY:[ ](\d+)>/i))_0x4fd13f=Number(RegExp['$1']);else{if(_0x14472c[_0x5006d4(0x1ed)](/<SHOP (?:PICTURE|IMAGE) OPACITY:[ ](\d+)([%％])>/i)){if(_0x5006d4(0x409)!==_0x5006d4(0x409))return!![];else _0x4fd13f=Math[_0x5006d4(0x284)](Number(RegExp['$1'])*0.01*0xff)[_0x5006d4(0x371)](0x0,0xff);}}_0x3fa161[_0x5006d4(0x32b)]=_0x4fd13f,_0x3fa161[_0x5006d4(0x60b)](_0x609fca,0x0,0x0,_0x609fca['width'],_0x609fca[_0x5006d4(0x232)],_0x5a7402,_0x3afd94,_0x20b938,_0x30337b),_0x3fa161[_0x5006d4(0x32b)]=0xff;},VisuMZ['ItemsEquipsCore'][_0x709961(0x40e)]=function(_0x43fb04){const _0x19b848=_0x709961;if(_0x43fb04===null||typeof _0x43fb04!==_0x19b848(0x2c6))return _0x43fb04;const _0x444b98=Array[_0x19b848(0x2ba)](_0x43fb04)?[]:Object[_0x19b848(0x256)](Object['getPrototypeOf'](_0x43fb04));for(const _0x5e0a45 in _0x43fb04){if(_0x19b848(0x1a8)!==_0x19b848(0x1a8))return _0x17c0eb;else{if(Object[_0x19b848(0x5ef)][_0x19b848(0x22d)][_0x19b848(0x376)](_0x43fb04,_0x5e0a45)){if(_0x19b848(0x5a9)===_0x19b848(0x5a9))_0x444b98[_0x5e0a45]=typeof _0x43fb04[_0x5e0a45]==='object'&&_0x43fb04[_0x5e0a45]!==null?VisuMZ[_0x19b848(0x3db)][_0x19b848(0x40e)](_0x43fb04[_0x5e0a45]):_0x43fb04[_0x5e0a45];else{if(!this[_0x19b848(0x565)]())return![];if(_0x451239[_0x19b848(0x6c1)][_0x19b848(0x3f7)]!==_0x3dbcf1)return![];return _0x35fcfe[_0x19b848(0x5c1)]('down')&&this[_0x19b848(0x538)](),![];}}}}return _0x444b98;};