/*:
 * @target MZ
 * @plugindesc NLT Specific Message Item Selection 
 * @help
 * This plugin creates modifies the existing message item selection
 * as well as adds a second type of message item selection 
 *
 * Game Switch 2 Off: A single column occupying the left side of the screen
 * Game Switch 2 On: Double columns occupying the bottom of the screen
 *
 * No plugin commands are necessary.
 */

(function() {
    // Game_Interpreter
    Game_Interpreter.prototype.setupItemChoice = function(params) {
        if ($gameSwitches.value(2) == false) {
            $gameMessage.setItemChoice(params[0], params[1] || 2);
        } else {
            $gameMessage.setItemTwoColChoice(params[0], params[1] || 2);
        }
    };

    // Game Message
    const GameMessageClear = Game_Message.prototype.clear;
    Game_Message.prototype.clear = function() {
        GameMessageClear.call(this);
        this._itemChoiceTwoColVariableId = 0;
        this._itemChoiceTwoColItypeId = 0;
    };

    Game_Message.prototype.isItemTwoColChoice = function() {
        return this._itemChoiceTwoColVariableId > 0;
    };

    Game_Message.prototype.itemChoiceTwoColVariableId = function() {
        return this._itemChoiceTwoColVariableId;
    };

    Game_Message.prototype.itemChoiceTwoColItypeId = function() {
        return this._itemChoiceTwoColItypeId;
    };

    const GameMessageIsBusy = Game_Message.prototype.isBusy;
    Game_Message.prototype.isBusy = function() {
        const GameMessageIsBusyResult = GameMessageIsBusy.call(this);
        return GameMessageIsBusyResult || this.isItemTwoColChoice()
    };

    Game_Message.prototype.setItemTwoColChoice = function(variableId, itemType) {
        this._itemChoiceTwoColVariableId = variableId;
        this._itemChoiceTwoColItypeId = itemType;
    };


    // Window Message
    Window_Message.prototype.startInput = function() {
        if ($gameMessage.isChoice()) {
            this._choiceListWindow.start();
            return true;
        } else if ($gameMessage.isNumberInput()) {
            this._numberInputWindow.start();
            return true;
        } else if ($gameMessage.isItemChoice()) {
            this._eventItemWindow.start();
            return true;
        } else if ($gameMessage.isItemTwoColChoice()) {
            this._eventItemWindowTwoCol.start();
            return true;
        } else {
            return false;
        }
    };

    Window_Message.prototype.setEventItemWindowTwoCol = function(eventItemWindowTwoCol) {
        this._eventItemWindowTwoCol = eventItemWindowTwoCol;
    };

    Window_Message.prototype.initMembers = function() {
        this._background = 0;
        this._positionType = 2;
        this._waitCount = 0;
        this._faceBitmap = null;
        this._textState = null;
        this._goldWindow = null;
        this._nameBoxWindow = null;
        this._choiceListWindow = null;
        this._numberInputWindow = null;
        this._eventItemWindow = null;
        this._eventItemWindowTwoCol = null;
        this.clearFlags();
    };

    Window_Message.prototype.terminateMessage = function() {
        this.close();
        this._goldWindow.close();
        $gameMessage.clear();
    };


    const WindowMessageIsAnySubWindowActive = Window_Message.prototype.isAnySubWindowActive;
    Window_Message.prototype.isAnySubWindowActive = function() {
        const WindowMessageIsAnySubWindowActiveResult = WindowMessageIsAnySubWindowActive.call(this);
        return WindowMessageIsAnySubWindowActiveResult || this._eventItemWindowTwoCol.active;
    };


    // Window EventItem
    
    Window_EventItem.prototype.includes = function(item) {
        if($gameMessage.isItemTwoColChoice()) {
            const itypeId = $gameMessage.itemChoiceTwoColItypeId();
            return DataManager.isItem(item) && item.itypeId === itypeId;
        } else {
            const itypeId = $gameMessage.itemChoiceItypeId();
            return DataManager.isItem(item) && item.itypeId === itypeId;
        }
    };
    
    Window_EventItem.prototype.updatePlacement = function() {
        if (this._messageWindow.y >= Graphics.boxHeight / 2 && !$gameMessage.isItemTwoColChoice()) {
            this.y = 0;
        } else {
            this.y = Graphics.boxHeight - this.height;
        }
    };


    Window_EventItem.prototype.placeCancelButton = function() {
        if (this._cancelButton) {
            const spacing = 8;
            const button = this._cancelButton;

            // Simplify for single column
            if ($gameSwitches.value(2) == false) { 
                button.x = Graphics.boxWidth - button.width;
                button.y = -210; // Or some appropriate value
            } else {
                // Existing two-column mode logic
                button.x = Graphics.boxWidth - button.width - spacing;
                button.y = -button.height;
            }
        }
    };
    
    Window_EventItem.prototype.onOk = function() {
        const item = this.item();
        const itemId = item ? item.id : 0;
        
        if($gameSwitches.value(2) == false) {
            $gameVariables.setValue($gameMessage.itemChoiceVariableId(), itemId);
        } else {
            $gameVariables.setValue($gameMessage.itemChoiceTwoColVariableId(), itemId);
        }
        this._messageWindow.terminateMessage();
        this.close();
    };



    // Window ItemList
    Window_ItemList.prototype.initialize = function(rect) {
        Window_Selectable.prototype.initialize.call(this, rect);
        this._category = "none";
        this._data = [];
    };

    Window_ItemList.prototype.maxCols = function() {
        //NLT edit
        if ($gameSwitches.value(2) == false) {
            return 1;
        } else {
            return 2;
        }
    };

    Window_ItemList.prototype.drawItem = function(index) {
        const item = this.itemAt(index);
        if (item) {
            const numberWidth = this.numberWidth();
            const rect = this.itemLineRect(index);
            this.changePaintOpacity(this.isEnabled(item));
            this.drawItemName(item, rect.x, rect.y, rect.width - numberWidth + 40);
            //this.drawItemNumber(item, rect.x, rect.y, rect.width);
            if (!item.note.includes("Singular")) {
                this.drawItemNumber(item, rect.x, rect.y, rect.width);
            }
            this.changePaintOpacity(1);
        }
    };

    // Scene Message
    const SceneMessageAssociateWindows = Scene_Message.prototype.associateWindows;
    Scene_Message.prototype.associateWindows = function() {

        SceneMessageAssociateWindows.call(this);

        const messageWindow = this._messageWindow;
        messageWindow.setEventItemWindowTwoCol(this._eventItemWindowTwoCol);
        this._eventItemWindowTwoCol.setMessageWindow(messageWindow);
    };

    const SceneMessageCreateEventItemWindow = Scene_Message.prototype.createEventItemWindow;
    

    Scene_Message.prototype.createEventItemWindow = function() {
        SceneMessageCreateEventItemWindow.call(this);

        const rectTwoCol = this.eventItemWindowRectTwoCol();
        this._eventItemWindowTwoCol = new Window_EventItem(rectTwoCol);
        this.addWindow(this._eventItemWindowTwoCol);
    };


    Scene_Message.prototype.eventItemWindowRect = function() {
        const wx = 0;
        const wy = 0;
        const ww = Graphics.boxWidth / 3;
        const wh = this.calcWindowHeight(12, true);
        return new Rectangle(0, -500, ww, wh);
    };

    Scene_Message.prototype.eventItemWindowRectTwoCol = function() {
        const wx = 0;
        const wy = 0;
        const ww = Graphics.boxWidth;
        const wh = this.calcWindowHeight(4, true);
        return new Rectangle(wx, wy, ww, wh);
    }

})();
















