/*:
 * @target MZ
 * @plugindesc Support plugin for add ons to VisuStella options core
 * @help Add the below lines to VisuStella Options Core options
 * Open Plugins and double click VisuMZ_1_OptionsCore
 * In the parameters double click "Options Categories"
 * Double click the first line, probably says "Options" somewhere
 * Double click the "Options List"
 * Scroll to the end and double click the empty line
 * Click on the "Text" tab, delete what is there and paste the below line:
 * {"Symbol:str":"stretchMode","Icon:num":"245","TextStr:str":"Stretch Mode","TextJS:func":"\"return 'Stretch Mode';\"","Accessibility":"","ShowJS:func":"\"// Return Boolean\\nreturn true;\"","EnableJS:func":"\"// Return Boolean\\nreturn true;\"","ExtJS:func":"\"// Return Value\\nreturn 0;\"","Functions":"","DrawJS:func":"\"// Declare Constants\\nconst symbol = arguments[0];\\nconst index = arguments[1];\\nconst title = this.commandName(index);\\nconst rect = this.itemLineRect(index);\\nconst quarterWidth = rect.width / 4;\\nconst halfWidth = rect.width / 2;\\nconst value = ConfigManager.stretchMode;\\n\\n// Draw Command Name\\nthis.resetFontSettings();\\nthis.changePaintOpacity(true);\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\"left\\\");\\n\\n// Draw Status Text\\nconst off = 'Vertical';\\nconst on  = 'Horizontal';\\nthis.changePaintOpacity(!value);\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\"center\\\");\\nthis.changePaintOpacity(value);\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\"center\\\");\"","ProcessOkJS:func":"\"// Declare Constants\\nconst symbol = arguments[0];\\nconst value = ConfigManager.stretchMode;\\n\\n// Perform Actions\\nthis.setConfigValue(symbol, !value);\\nthis.redrawItem(this.findSymbol(symbol));\\nthis.playCursorSound();\\nGraphics._updateStretchHeight();\"","CursorRightJS:func":"\"// Declare Constants\\nconst symbol = arguments[0];\\nconst value = ConfigManager.stretchMode;\\nconst lastValue = value;\\n\\n// Perform Actions\\nConfigManager.stretchMode = true;\\nthis.redrawItem(this.findSymbol(symbol));\\nif (ConfigManager.stretchMode !== lastValue) {\\n    this.playCursorSound();\\n    Graphics._updateStretchHeight();\\n}\"","CursorLeftJS:func":"\"// Declare Constants\\nconst symbol = arguments[0];\\nconst value = ConfigManager.stretchMode;\\nconst lastValue = value;\\n\\n// Perform Actions\\nConfigManager.stretchMode = false;\\nthis.redrawItem(this.findSymbol(symbol));\\nif (ConfigManager.stretchMode !== lastValue) {\\n    this.playCursorSound();\\n    Graphics._updateStretchHeight();\\n}\"","Data":"","DefaultJS:func":"\"// Declare Constants\\nconst config = arguments[0];\\nconst symbol = arguments[1];\\n\\n// Perform Actions\\nConfigManager[symbol] = false;\"","SaveJS:func":"\"// Declare Constants\\nconst config = arguments[0];\\nconst symbol = arguments[1];\\n\\n// Return Value\\nconfig[symbol] = ConfigManager.stretchMode;\"","LoadJS:func":"\"// Declare Constants\\nconst config = arguments[0];\\nconst symbol = arguments[1];\\n\\n// Return Value\\nConfigManager[symbol] = config[symbol];\\nif (ConfigManager[symbol]) {\\n    ConfigManager.stretchMode = true;\\n} else {\\n    ConfigManager.stretchMode = false;\\n}\""}
 * Click OK then drag the new option underneath the stetchScreen option
 * Scroll back down and double click the blank line again
 * Click on the "Text" tab, delete what is there and paste the below line:
 * {"Symbol:str":"addPadding","Icon:num":"245","TextStr:str":"Add Padding","TextJS:func":"\"return 'Text';\"","Accessibility":"","ShowJS:func":"\"// Return Boolean\\nreturn true;\"","EnableJS:func":"\"// Return Boolean\\nreturn true;\"","ExtJS:func":"\"// Return Value\\nreturn 0;\"","Functions":"","DrawJS:func":"\"// Declare Constants\\nconst symbol = arguments[0];\\nconst index = arguments[1];\\nconst title = this.commandName(index);\\nconst rect = this.itemLineRect(index);\\nconst quarterWidth = rect.width / 4;\\nconst halfWidth = rect.width / 2;\\nconst value = ConfigManager.addPadding;\\n\\n// Draw Command Name\\nthis.resetFontSettings();\\nthis.changePaintOpacity(true);\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\"left\\\");\\n\\n// Draw Status Text\\nconst off = 'OFF';\\nconst on  = 'ON';\\nthis.changePaintOpacity(!value);\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\"center\\\");\\nthis.changePaintOpacity(value);\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\"center\\\");\"","ProcessOkJS:func":"\"// Declare Constants\\nconst symbol = arguments[0];\\nconst value = ConfigManager.addPadding;\\n\\n// Perform Actions\\nthis.setConfigValue(symbol, !value);\\nthis.redrawItem(this.findSymbol(symbol));\\nthis.playCursorSound();\\nGraphics._updateStretchHeight();\"","CursorRightJS:func":"\"// Declare Constants\\nconst symbol = arguments[0];\\nconst value = ConfigManager.addPadding;\\nconst lastValue = value;\\n\\n// Perform Actions\\nConfigManager.addPadding = true;\\nthis.redrawItem(this.findSymbol(symbol));\\nif (ConfigManager.addPadding !== lastValue) {\\n    this.playCursorSound();\\n    Graphics._updateStretchHeight();\\n}\"","CursorLeftJS:func":"\"// Declare Constants\\nconst symbol = arguments[0];\\nconst value = ConfigManager.addPadding;\\nconst lastValue = value;\\n\\n// Perform Actions\\nConfigManager.addPadding = false;\\nthis.redrawItem(this.findSymbol(symbol));\\nif (ConfigManager.addPadding !== lastValue) {\\n    this.playCursorSound();\\n    Graphics._updateStretchHeight();\\n}\"","Data":"","DefaultJS:func":"\"// Declare Constants\\nconst config = arguments[0];\\nconst symbol = arguments[1];\\n\\n// Perform Actions\\nConfigManager[symbol] = false;\"","SaveJS:func":"\"// Declare Constants\\nconst config = arguments[0];\\nconst symbol = arguments[1];\\n\\n// Return Value\\nconfig[symbol] = ConfigManager.addPadding;\"","LoadJS:func":"\"// Declare Constants\\nconst config = arguments[0];\\nconst symbol = arguments[1];\\n\\n// Return Value\\nConfigManager[symbol] = config[symbol];\\nif (ConfigManager[symbol]) {\\n    ConfigManager.addPadding = true;\\n} else {\\n    ConfigManager.addPadding = false;\\n}\""}
 * Click OK and drag this under the stretchMode option
 */

(() => {
    // Add the new ConfigManager options
    ConfigManager.addPadding = false;
    ConfigManager.stretchMode = false;

    // Modify makeData function to include the new options
    const _ConfigManager_makeData = ConfigManager.makeData;
    ConfigManager.makeData = function() {
        const config = _ConfigManager_makeData.call(this);
        config.addPadding = this.addPadding;
        config.stretchMode = this.stretchMode;
        return config;
    };

    // Modify applyData function to load the new options
    const _ConfigManager_applyData = ConfigManager.applyData;
    ConfigManager.applyData = function(config) {
        _ConfigManager_applyData.call(this, config);
        this.addPadding = this.readFlag(config, 'addPadding');
        this.stretchMode = this.readFlag(config, 'stretchMode');
    };

    // Override the _stretchHeight function
    Graphics._stretchHeight = function() {
        const gameWidth = Graphics._width;  // Get the game width dynamically
        const gameHeight = Graphics._height;  // Get the game height dynamically
        const aspectRatio = gameHeight / gameWidth;

        if (ConfigManager.addPadding) {
            if (ConfigManager.stretchMode) { // Horizontal
                const availableWidth = window.innerWidth * 0.9;
                return availableWidth * aspectRatio;
            } else { // Vertical
                return window.innerHeight * 0.9;
            }
        } else {
            if (ConfigManager.stretchMode) { // Horizontal
                const availableWidth = window.innerWidth;
                return availableWidth * aspectRatio;
            } else { // Vertical
                return window.innerHeight;
            }
        }
    };

    // Ensure the options are applied immediately when changed
    Graphics._updateStretchHeight = function() {
        Graphics._stretchHeight();
        Graphics._updateAllElements();
    };
})();
