/*:
 * @target MZ
 * @plugindesc Prevents fullscreen request until user interaction is detected.
 * @help This plugin ensures that a fullscreen request is only made after
 * the user has interacted with the page. If no interaction is detected,
 * the fullscreen request is skipped.
 *
 * @command attemptFullscreen
 * @text Attempt Fullscreen
 * @desc Attempt to request fullscreen mode if user interaction is detected.
 */

(() => {
    const pluginName = "Otto_FullscreenInteractionCheck";

    // Flag to track if the user has interacted with the page
    let userHasInteracted = false;

    // Event listeners to detect user interaction
    window.addEventListener('click', () => userHasInteracted = true);
    window.addEventListener('keypress', () => userHasInteracted = true);
    window.addEventListener('touchstart', () => userHasInteracted = true);

    Graphics._requestFullScreen = function() {
        if (!userHasInteracted) {
            console.log("Skipping fullscreen request: No user interaction detected");
            return;
        }

        const element = document.body;
        if (element.requestFullScreen) {
            element.requestFullScreen();
        } else if (element.mozRequestFullScreen) {
            element.mozRequestFullScreen();
        } else if (element.webkitRequestFullScreen) {
            element.webkitRequestFullScreen(Element.ALLOW_KEYBOARD_INPUT);
        } else if (element.msRequestFullscreen) {
            element.msRequestFullscreen();
        }
    };

    // Plugin command to attempt fullscreen
    PluginManager.registerCommand(pluginName, "attemptFullscreen", () => {
        Graphics._requestFullScreen();
    });
})();
