/*:
 * @target MZ
 * @plugindesc Instantly moves the player to a specified (x, y) position within the same scene without reloading the scene.
 * @command movePlayer
 * @text Move Player
 * @desc Instantly moves the player to the specified (x, y) position.
 *
 * @arg x
 * @text X Coordinate
 * @type number
 * @min 0
 * @desc The X coordinate to move the player to.
 * @default 0
 *
 * @arg y
 * @text Y Coordinate
 * @type number
 * @min 0
 * @desc The Y coordinate to move the player to.
 * @default 0
 */

(() => {
    const pluginName = 'InstantMove';

    PluginManager.registerCommand(pluginName, 'movePlayer', args => {
        const x = Number(args.x);
        const y = Number(args.y);
        if ($gameMap.isValid(x, y)) {
            $gamePlayer.locate(x, y);
            $gamePlayer.refresh();
        }
    });
})();
