/*:
 * @target MZ
 * @plugindesc Modifies the screen fade in to start with a configurable number of solid black frames before beginning the fade in.
 * @author Wes Townsend
 * @param fadeFrameDelay
 * @text Fade Frame Delay
 * @type number
 * @default 5
 * @desc Sets the number of frames to wait in full black before starting the fade in.
 *
 * @help This plugin modifies the screen fade in effect to start with a specified number of solid black frames before
 * beginning the fade in, enhancing dramatic effect and initial scene impact.
 */
(() => {
    // Read the parameter from the plugin manager
    const parameters = PluginManager.parameters('DelayFadeIn'); // Make sure the string matches your plugin file name
    const fadeFrameDelay = Number(parameters['fadeFrameDelay'] || 5);

    const _Scene_Base_startFadeIn = Scene_Base.prototype.startFadeIn;
    Scene_Base.prototype.startFadeIn = function(duration, white) {
        if (!this._fadeSprite) {
            this.createFadeSprite(white);
        }
        
        this._fadeSign = 1;
        this._fadeDuration = duration;
        this._fadeSprite.opacity = 255;
        this._fadeFrameDelay = fadeFrameDelay; // Use the parameter value
        this._initialFade = true;
    };

    const _Scene_Base_updateFade = Scene_Base.prototype.updateFade;
    Scene_Base.prototype.updateFade = function() {
        if (this._fadeSign > 0) {
            if (this._fadeFrameDelay > 0 && this._initialFade) {
                this._fadeFrameDelay--;
                this._fadeSprite.opacity = 255;
            } else {
                this._initialFade = false;
                if (this._fadeDuration > 0) {
                    const d = this._fadeDuration;
                    this._fadeSprite.opacity -= this._fadeSprite.opacity / d;
                    this._fadeDuration--;
                }
            }
        } else {
            _Scene_Base_updateFade.call(this);
        }
    };

    Scene_Base.prototype.createFadeSprite = function(white) {
        this._fadeSprite = new ScreenSprite();
        this._fadeSprite.setColor(white ? 'white' : 'black');
        this.addChild(this._fadeSprite);
    };
})();
